
<%@ include file="/jsp/init.jsp"%>

<c:set var="form_" value="${caretMap_['form_']}" />

<c:set var="payLog" value="${form_['payLog']}" />
<c:set var="workItem" value="${form_['workItem']}" />
<c:set var="calcInfo" value="${workItem.calcInfo}" />
<c:set var="veteran" value="${workItem.veteran}" /> 
<c:set var="vcgSupport" value="${workItem.vcgSupport}" /> 
<c:set var="caregiver" value="${workItem.caregiver}" /> 
<c:set var="stipendPaymentConfig" value="${calcInfo.stipendPaymentConfig}" /> 


<style>

.itemized-fract{
	font-size:1.5em;
}

.manage-layout label.checkbox {
    width: 350px;
}


</style>

<div id="${randomString}workTab">
	<ul class="nav nav-tabs">
		<li class="tab-click"><a href="#tab-3${randomStringing}1"><div class="icon-bullhorn"></div> Create ${form_['workType']} </a></li>
		<li class="tab-click"><a href="#tab-3${randomStringing}2"><div class="icon-user"></div> Additional Information </a></li>
		<li class="tab-click"><a href="#tab-3${randomStringing}3"><div class="icon-credit"></div> Calculation Information </a></li>
	</ul>

	<div class="tab-content">

		<div id="tab-3${randomStringing}1" class="tab-pane">

			<div id="reviewOccWork2">
				<input type="hidden" value="${form_['statusDate']}" id="statusDate" />
				<input type="hidden" value="${form_['maxDate']}" id="maxDate" />

				<div class='portlet-msg-info' style="width: 80%">
					(TBD) Top things to Highlight here...
					<div class="ten-ten-links">
						<portlet:resourceURL var="getDocum">
							<portlet:param name="action" value="getDocum" />
							<portlet:param name="classPk" value="${workItem.classPk}" />
						</portlet:resourceURL>
						<a href="${getDocum}" tabindex="0" target="_blank"
							class="tab-click btn icon-file stipend-row float-right"
							title='<liferay-ui:message key="pdf-10-10cg" />'>&nbsp;<liferay-ui:message
								key="pdf-10-10cg-review-message" /></a>
					</div>


					<ul>
						<fmt:formatDate
							value="${vcgSupport.primaryVcgAn.receivedDate}"
							var="appReceivedDate" type="date" pattern="MM/dd/yyyy" />
						<fmt:formatDate
							value="${stipendPaymentConfig.stipendStartDate}"
							var="stipendStartDate" type="date" pattern="MM/dd/yyyy" />
						<fmt:formatDate
							value="${stipendPaymentConfig.payslipDate}"
							var="payslipDate" type="date" pattern="MM/dd/yyyy" />

						<fmt:formatDate value="${payLog.paymentDate}" var="paymentDate"
							type="date" pattern="MM/dd/yyyy" />


					<c:if test="${! empty payLog}">
						<li>Last Check Submit Date: ${paymentDate}</li>
						<li>Last FMS Payment Response: <fmt:formatNumber
								value="${payLog.amount}" type="currency" />, <liferay-ui:message
								key='${payLog.reason}' />
						</li>
					</c:if>
						
						<li>Payment Status: ${stipendPaymentConfig.paymentStatusStr}</li>
						
						<li><liferay-ui:message key='cg-vendor' /> Name:
							${caregiver.lastName}, ${caregiver.firstName}
							${caregiver.middleName} &nbsp;</li>
						<li>SSN: ${caregiver.ssn}</li>
						<li>Other Insurance: ${caregiver.otherHealthInsurance} </li>
					</ul>
				</div>
				<!-- end Top things to Highlight here... -->

				<div class="clear-both" id="createVndrWk">
					<input type="hidden" name="<portlet:namespace/>worImId" id="<portlet:namespace/>worImId17" value="${workItem.worImId}">

					<div class="my-shim"></div>
					<input type="hidden" name="paymentLogId" value="${payLog.paymentLogId}" /> <input type="hidden" name="type" value="MANUAL_PAYMENT" />
					<input type="hidden" value="${TRACKER}" name="TRACKER" />
					<input type="hidden" value="0" name="oneTimeCount" id="<portlet:namespace/>oneTimeCount" />
					<input type="hidden" value="${stipendPaymentConfig.vendrId}" name="vendrId" />
					
					
					<div class="manage-layout float-left">
						<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="required-input float-left">
							<aui:select style="width:125px;" label="pay-period" name="config_cycle_month" id="config_cycle_month" disabled="${form_['disableDates']}"	>
								<aui:option value="" label="Please Select" selected="true" />
								<c:forEach var="month" items="${form_['MONTHS']}" varStatus="varStat" >
									<c:if test="${! empty month}" >
										<aui:option value="0${varStat.index}" label="${month}" selected="${month eq form_['MONTH']}" />
									</c:if>
								</c:forEach>
							</aui:select>
						</aui:field-wrapper>
						<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="required-input float-left">
							<aui:select style="width:80px;" label="" name="config_cycle_year" id="config_cycle_year" disabled="${form_['disableDates']}" >
								<c:forEach var="year" items="${form_['YEARS']}">
									<aui:option value="${year}" label="${year}" selected="${year eq form_['YEAR']}"  />
								</c:forEach>
							</aui:select>
						</aui:field-wrapper>
					</div>
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input float-left" data="${form_['restrictionDateData']}" >
						<aui:input label="${form_['MODE']} Event Date" name="checkDate" id="checkDate" cssClass="date-field not-future after-status-date" type="text" size="25" value=""  />
					</aui:field-wrapper>
					
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input"   >
						<fmt:formatNumber value="${payLog.amount}" var="amount" type="currency"/>
						<aui:input label="manual-payment-amount" class='money-field' name="dollarAmount" id="dollarAmount" type="text" size="50" value="${amount}"  />
					</aui:field-wrapper>

					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="required-input">
						<aui:select label="manual-payment-reason" name="worIm_manualPaymentReason" id="worIm_manualPaymentReason" cssClass="manage-layout-wide">
							<aui:option value="manual-payment-reason-reissue-lost-check" label="manual-payment-reason-reissue-lost-check" />
							<aui:option value="other" label="other" />
						</aui:select>
					</aui:field-wrapper>

					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-vcg-medium-input">
						<aui:input label="manual-comments" name="worIm_comments" size="50" type="textarea" />
					</aui:field-wrapper>

					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false">
						<a class="btn btn-primary" style="float: right; margin-left: 30px; margin-bottom: -10px" href="javascript:submitWorkItem();">&nbsp;<liferay-ui:message key="new-work-item" /></a>
					</aui:field-wrapper>

					<div id="validationResultOuter">
						
						<div id="validationResult">
						</div>
						
						<div class='portlet-msg-alert' id="validationResult2" >
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" >
							 	<aui:input name="validateCount" id="validateCount" type="checkbox" label="dollar-amount-or-date-period-potential-duplicate" inlineField="true"   >
									</aui:input>
							 </aui:field-wrapper>
						</div>
					</div>

				</div>
			</div>
		</div>

		<div id="tab-3${randomStringing}2" class="tab-pane">

			<div style="padding: 2px;" id="${randomString}itemization0" tabindex="0"
				class="header toggler-header-collapsed">

				<div class="work-section">
					<div class="center-position">
						<div class="care-giver-name" id="update_veteran">
							<div class="selected-vcg">
								<div class="selected-info">
									<div class="selected-vcg-row">
										<div class="srow-label">Veteran Name:</div>${veteran.lastName},
										${veteran.firstName}
									</div>
									<div class="selected-vcg-row">
										<div class="srow-label">Facility:</div>${veteran.facilityName}
									</div>
									<div class="selected-vcg-row">
										<div class="srow-label">SSN:</div>${veteran.ssn}
									</div>
									<div class="selected-vcg-row">
										<fmt:formatDate value="${veteran.birthDate}"
											var="vbday" type="date" pattern="MM/dd/yyyy" />
										<div class="lrow-label">DOB:</div>${vbday}
									</div>
									<div class="selected-vcg-row">
										<div class="lrow-label">Application Id:</div>${workItem.applicationId}
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="work-section" id="viewVendor">
					<%@include file="/jsp/internal/viewVendor.jsp"%>
				</div>
			</div>
		</div>


		<div id="tab-3${randomStringing}3" class="tab-pane">
			<div class="work-section manage-layout">
				<div class="center-position">
					<div id="tier-info">
						<div class="selected-vcg">
							<div class="selected-info">
								<fmt:formatDate value="${vcgSupport.tierEffectiveDate}"
									var="tierEffectiveDate" type="date" pattern="MM/dd/yyyy" />
								<fmt:formatDate value="${payLog.paymentDate}" var="paymentDate"
									type="date" pattern="MM/dd/yyyy" />

								<div class="selected-vcg-row">
									<div class="srow-label">Tier Level:</div>
									<liferay-ui:message
										key="tier-level-${vcgSupport.tierLevel}" />
								</div>
								<div class="my-shim"></div>
								<div class="selected-vcg-row">
									<div class="srow-label">Stipend Start Date:</div>${stipendStartDate}
								</div>
								<div class="selected-vcg-row">
									<div class="srow-label">Initial Payment Date:</div>${payslipDate}
								</div>
								<div class="selected-vcg-row">
									<div class="srow-label">Payment Status:</div>${stipendPaymentConfig.paymentStatusStr}
								</div>
								
							  <c:if test="${! empty payLog}">
								<div class="selected-vcg-row">
									<div class="srow-label">Check Submit Date:</div>${paymentDate}
								</div>
								<div class="my-shim"></div>
								<div class="selected-vcg-row">
									<div class="srow-label">FMS Payment Response:</div>
									<fmt:formatNumber value="${payLog.amount}" type="currency" />
									,
									<liferay-ui:message key='${payLog.reason}' />
								</div>
							  </c:if>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="work-section">
				<div class="center-position">
					<div class="rate-info" id="update_primary">
						<div class="selected-vcg">
							<div class="selected-info">
								<div class="selected-vcg-row">
									<div class="srow-label">Zip:</div>${caregiver.zip}
									&nbsp;
								</div>
								<div class="selected-vcg-row has-tooltip"
									id="${randomString}itemization1" title="click-for-itemization">
									<div class="header toggler-header-collapsed">
										<div class="srow-label">Monthly Rate:</div>
										<div class="float-left">
											<fmt:formatNumber value="${calcInfo.monthlyRate}"
												type="currency" />
											&nbsp;
										</div>
										<div class="icon-info-sign "></div>
										&nbsp;
									</div>
									<div class="content toggler-content-collapsed portlet-msg-info">
										<table class="itemized-table">
											<tr>
												<th>[Monthly Rate] =</th>
												<th>[Tier Monthly Hrs] x</th>
												<th>[ZIP Hourly Wage]</th>
											</tr>
											<tr>
												<td>$${calcInfo.monthlyRate}</td>
												<td>${stipendPaymentConfig.tierHours}</td>
												<td>$${calcInfo.hourlyRate}</td>
											</tr>
										</table>
										<table class="itemized-table">
											<tr>
												<th>[Daily Rate] =</th>
												<th>[Tier Monthly Hrs] &times;</th>
												<th>[ZIP Hourly Wage] &times;</th>
												<th class="itemized-fract"><sup>12</sup>&frasl;<sub>365</sub>
												</th>
											</tr>
											<tr>
												<td>$${calcInfo.dailyRate}</td>
												<td>${stipendPaymentConfig.tierHours}</td>
												<td>$${calcInfo.hourlyRate}</td>
												<td class="itemized-fract"><sup>12</sup>&frasl;<sub>365</sub></td>
											</tr>
										</table>
									</div>
								</div>
								
								<c:if test="${! empty payLog}">
									<div class="selected-vcg-row has-tooltip"
										id="${randomString}itemization2"
										title="click-for-itemization-of-retroactive-and-or-prorated">
										<div class="header toggler-header-collapsed">
											<div class="srow-label">Back Pay:</div>
											<div class="float-left">${(calcInfo.backPayAmount + calcInfo.proratedAmount)  gt 0 ? "YES": "NO"}
												&nbsp;</div>
											<div class="icon-info-sign "></div>
											&nbsp;
										</div>
										<div class="content toggler-content-collapsed">
											<div class="portlet-msg-info">
												<div class="itemized-data">[# of Retro Months] =
													Number of Unpaid Full months after Tier Effective
													date(${tierEffectiveDate}) prior to Payment Month
													(${paymentDate})</div>
												<table class="itemized-table">
													<tr>
														<th>[Monthly Back Pay] =</th>
														<th>[Monthly Rate] x</th>
														<th>[# of Retro Months]</th>
													</tr>
													<tr>
														<td><fmt:formatNumber
																value="${calcInfo.backPayAmount}" type="currency" /></td>
														<td>$${calcInfo.monthlyRate}</td>
														<td>${calcInfo.retroactiveMonths}</td>
													</tr>
												</table>
												<div class="itemized-data">[# of Retro Days] = Number
													of Partial-month days after Tier Effective
													date(${tierEffectiveDate}) prior to Payment Month
													(${paymentDate})</div>
												<table class="itemized-table">
													<tr>
														<th>[Prorated Amt] =</th>
														<th>[Daily Rate] x</th>
														<th>[# of Retro Days]</th>
													</tr>
													<tr>
														<td><fmt:formatNumber
																value="${calcInfo.proratedAmount}" type="currency" /></td>
														<td><fmt:formatNumber value="${calcInfo.dailyRate}"
																type="currency" /></td>
														<td>${calcInfo.totalDays}</td>
													</tr>
												</table>
												<table class="itemized-table">
													<tr>
														<th>[Back Pay] =</th>
														<th>[Monthly Back Pay] +</th>
														<th>[Prorated Amt]</th>
													</tr>
													<tr>
														<td><fmt:formatNumber
																value="${calcInfo.backPayAmount + calcInfo.proratedAmount}"
																type="currency" /></td>
														<td><fmt:formatNumber
																value="${calcInfo.backPayAmount}" type="currency" /></td>
														<td><fmt:formatNumber
																value="${calcInfo.proratedAmount}" type="currency" /></td>
													</tr>
												</table>
											</div>
										</div>
									</div>
									<div class="selected-vcg-row">
										<div class="srow-label">Back Pay Amount:</div>
										<fmt:formatNumber
											value="${calcInfo.backPayAmount + calcInfo.proratedAmount}"
											type="currency" />
										&nbsp;
									</div>
	
									<div class="selected-vcg-row">
										<div class="srow-label">Total Payment Amount:</div>
										<fmt:formatNumber value="${calcInfo.finalAmount}"
											type="currency" />
										&nbsp;
									</div>
								</c:if>
								
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>
	<!-- end tab-context -->
</div>
<!-- workTab -->


<aui:script
	use="aui-tabview,aui-toggler">

	A.one ('#validationResult2').hide();
	
  new A.TabView({
      srcNode: '#${randomString}workTab',
      type: 'pills'
    }
  ).render();
  
  

	window.submitWorkItem = function (){
		validateFields( function ( message ) {
		         var validationNotice = A.one ('#validationResult');
		         A.one ('#validationResult2').hide();
		         var erred = false;
		            		    		
		         if ( message.length > 0 ){
		         	var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
		            validationNotice.html(msg);
		            validationNotice.scrollIntoView();
		            return false;	
		        }
		        validationNotice.hide();
		        
		        window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="validateCount" /></portlet:resourceURL>', 'json', { 
				      dollarAmount: A.one('#<portlet:namespace/>dollarAmount').val(),
				      monthDate: A.one('#<portlet:namespace/>config_cycle_month').val(),
				      yearDate: A.one('#<portlet:namespace/>config_cycle_year').val(),
				      vendrId: ${stipendPaymentConfig.vendrId}
					}, function( data ){
						if ( data && parseInt ( data.validateCount ) > 0 ){
			
							var count = parseInt ( data.validateCount );
	   						A.one('#<portlet:namespace/>oneTimeCount').val( count );
					        validationNotice = A.one ('#validationResult2');
				    	
				    		if ( A.one('#<portlet:namespace />validateCountCheckbox').attr('checked') ){
				    			overwrite( A.one( "#modalVndrWk" ), A.one("#createVndrWk") );
								A.one("#<portlet:namespace />createVndrWk_fm").submit();
				    		} else {
		            			validationNotice.show();
		            			validationNotice.scrollIntoView();
								return false;				   
				    		}
					   } else {
							overwrite( A.one( "#modalVndrWk" ), A.one("#createVndrWk") );
							A.one("#<portlet:namespace />createVndrWk_fm").submit();
					   
					   }
					}
				);
				
		            
		                 		    	}, '#createVndrWk');
	}
	

	
	new A.TogglerDelegate( {
				animated: true,
				container: '#${randomString}itemization1',
				content: '.content',
				expanded: false,
				header: '.header'
			  });
	
	<c:if test="${! empty payLog}">
		new A.TogglerDelegate( {
				animated: true,
				container: '#${randomString}itemization2',
				content: '.content',
				expanded: false,
				header: '.header'
			  });
	</c:if>
	
	A.one('#<portlet:namespace />dollarAmount').on('change', window.dollarFormat);
	<c:if test="${! empty payLog and ! empty payLog.payment }" >
		A.one('#<portlet:namespace />dollarAmount').attr('disabled', 'disabled');
	</c:if>
	enforceFormats();
	
</aui:script>