<%@include file="/jsp/init.jsp" %>

<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

 	
	<c:set var="form_" value="${caretMap_['form_']}" />
 	
 	<c:set var="vcg" value="${form_['vcg']}" />
	<c:set var="veteranVcg" value="${vcg.veteran}" />
 	
 	<c:set var="eeRecords" value="${form_['eeRecords']}" />
 	<c:set var="militaryRecords" value="${form_['militaryRecords']}" />
 	<c:set var="monetaryBenefits" value="${form_['monetaryBenefits']}" />
 	<c:set var="ratedDisabilities" value="${form_['ratedDisabilities']}" />
 	
	<c:set var="editAction" value="edit-vcg-entry icon-pencil" />
	<c:set var="auditLog" value="audit-vcg-entry icon-time" />
	<c:set var="title" value="click-to-begin-changes" />
	<c:set var="message" value="edit-vcg" />
	

 	<c:set var="veteranId" value="${form_['veteranId']}" />
 	<c:set var="primaryValidAppDate" value="${form_['primaryValidAppDate']}" />
 	<c:set var="secondaryValidAppDate" value="${form_['secondaryValidAppDate']}" />
 	<c:set var="secondaryTwoValidAppDate" value="${form_['secondaryTwoValidAppDate']}" />
 	<c:set var="primaryApplicationId" value="${form_['primaryApplicationId']}" />
 	<c:set var="secondaryApplicationId" value="${form_['secondaryApplicationId']}" />
 	<c:set var="secondaryTwoApplicationId" value="${form_['secondaryTwoApplicationId']}" />	

 	<c:set var="primaryApprovalDate" value="${form_['primaryApprovalDate']}" />	
 	<c:set var="vcgUploadFileTypes" value="${form_['vcgUploadFileTypes']}" />	
 	
<liferay-ui:icon-menu cssClass="messageicon">
	<liferay-ui:icon image="message" message="internal_message" url="javascript:composeVCG(${vcg.vcgId});"  />
</liferay-ui:icon-menu>
	

	<div class="next-line">	
	  	<fieldset id="sectionCollapse0" class="clear-both vcg-section">
			<legend class="header"><div class="icon-group"></div> <liferay-ui:message key="vcg-record" />, ID ${vcg.vcgId}</legend>
			<div class="content toggler-header-expanded"  id="vcgPersonsOuter" >
				<div id="vcgPersons" class="tab-pane" > 	
				
					<div class="vcg-entry-menu" id="${vcg.vcgId}" >
						<div>
							<div class="float-right">
								<a class="btn-link ${auditLog} btn-primary" title="<liferay-ui:message key="vcg-audit-log-all-tooltip" />" >&nbsp;<liferay-ui:message key="vcg-entry-log-all" /></a>
							</div>
						</div>
					</div>
					
		<div class="select-caregiver" >
		<div class="person-selection vcg-entry-menu" id="${veteranVcg.primaryKey}">
			<div>
				<div class="float-left">
					<c:if test="${form_['EaE']}" >
						<a href="javascript:loadEligibilityFromCaret();" class="view-eligibility icon-info-sign btn-link btn-primary" title='<liferay-ui:message key="view-eligibility-tooltip" />'  >&nbsp;E&amp;E</a>
					</c:if>
					<a class="btn-link ${editAction} btn-primary" title="<liferay-ui:message key="${title}" />" >&nbsp;<liferay-ui:message key="edit-vcg-veteran" /></a>
				</div>
				<div class="float-right">
					<a class="btn-link ${auditLog} btn-primary" title="<liferay-ui:message key="vcg-person-audit-log-tooltip" />" >&nbsp;<liferay-ui:message key="vcg-entry-log" /></a>
				</div>
			</div>
			<hr/>
			<div class="center-position">
				<div class="care-giver-name" id="update_veteran">
					<c:if test="${! empty vcg.veteran}">
						<div class="selected-vcg">
				    	 	<div class="selected-info">
				    	 		<div class="selected-vcg-row">
				    	 			<div class="srow-label">
				    	 			Veteran Name:</div>${veteranVcg.lastName}, ${veteranVcg.firstName} ${veteranVcg.middleName}
				    	 			<!-- <div class="edit-identity icon-user btn mini" title='<liferay-ui:message key="user-verified-${veteranVcg.verifiedIdentity}-tooltip" />'  >&nbsp;</div>-->
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">SSN:</div>${veteranVcg.ssn}
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">Facility:</div>${veteranVcg.facilityName} 
				    			</div>
				    			<hr/>
				    			<div class="selected-vcg-row">
				    				<div class="arow-label">Address:</div>${veteranVcg.address} ${veteranVcg.address2}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="arow-label">&nbsp;&nbsp;
				    					<c:choose>
				    						<c:when test="${veteranVcg.validUspsAddress}">
						    					<div class="icon-star upper-icon-padding" title="<liferay-ui:message key='usps-validated'/>"></div>
				    						</c:when>
				    						<c:otherwise>
												<div class="icon-flag upper-icon-padding" title="<liferay-ui:message key='non-usps-validated'/>"></div>
				    						</c:otherwise>
				    					</c:choose>
									&nbsp;&nbsp;</div>${veteranVcg.city}, ${veteranVcg.state} ${veteranVcg.zip}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Email:</div>${veteranVcg.email}  
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Phone:</div>${veteranVcg.phone}  ${veteranVcg.phone2} 
				    			</div>
				    			<hr/>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">Gender:</div><liferay-ui:message key="${veteranVcg.gender}" />
				    			</div>
				    			<!-- 
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">ICN:</div>${veteranVcg.icn}
				    			</div>
				    			 -->
				    			<div class="selected-vcg-row">
				    	 			<fmt:formatDate value="${veteranVcg.birthDate}" var="vbday" type="date" pattern="MM/dd/yyyy"/>
				    	 			<div class="lrow-label">DOB:</div>${vbday}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">VA Health Enrolled:</div><liferay-ui:message key="${veteranVcg.vaHealthEnrolled}-yes" />
				    			</div>
				    		</div>
			    		</div>
		    		</c:if>
				</div>
			</div>
		</div>
	</div>
	
	
	<c:if test="${! empty vcg.primary}">
		<c:set var="primaryCaregiver" value="${vcg.primary}" />
		<div class="select-caregiver" >
			<div class="person-selection vcg-entry-menu" id="${primaryCaregiver.primaryKey}" >
				<div>
					<div class="float-left">
						<a class="btn-link ${editAction} edit-primary btn-primary" title="<liferay-ui:message key="${title}" />" >&nbsp;
							<liferay-ui:message key="edit-vcg-primary" />
						</a>
					</div>
					<div class="float-right">
						<a class="btn-link ${auditLog} btn-primary" title="<liferay-ui:message key="vcg-person-audit-log-tooltip" />"  >&nbsp;<liferay-ui:message key="vcg-entry-log" /></a>
					</div>
				</div>
				<hr/>
				<div class="center-position">
					<div class="care-giver-name" id="update_primary">
							<div class="selected-vcg">
								<div class="selected-info">
									<div class="selected-vcg-row">
										<div class="srow-label">Primary Name:</div>${primaryCaregiver.lastName}, ${primaryCaregiver.firstName} ${primaryCaregiver.middleName} &nbsp;
										<c:if test="${!primaryCaregiver.verifiedIdentity}" >
											<c:set var="primBtn" value="btn"/>
										</c:if>
									</div>
									<div class="selected-vcg-row">
										<div class="srow-label">SSN:</div> ${primaryCaregiver.ssn} 
									</div>
									
									<div class="selected-vcg-row" style="background: rgb(31, 147, 255); color: white; font-size:large;" >
										<div class="srow-label">
									  <c:choose> 
										<c:when test="${( vcg.hasPrimaryDispChoices() ) || vcg.primaryWaiverCode eq 'VISN_NEEDED' || vcg.primaryWaiverCode eq 'VISN_REVIEW_EXPIRED' }" >
											<c:set var="dispReason">
											  <c:choose>
												<c:when test="${fn:startsWith(vcg.primaryDispReason, 'revoked')}">revoked-caregiver</c:when>
												<c:otherwise>${vcg.primaryDispReason}</c:otherwise>
											  </c:choose>
											 </c:set>
											 <c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "DISPOSITION_VCG") }' >
												<div class="edit-disposition ${vcg.primaryDispIcon} has-tooltip" title='<liferay-ui:message key="${dispReason}-tooltip" />'  >&nbsp;</div>
											 </c:if>
										</c:when>
										<c:when test="${ !vcg.hasPrimaryDispChoices() and ( fn:startsWith(vcg.primaryDispReason, 'revoked') || fn:startsWith(vcg.primaryDispReason, 'disapproved') )  }" >
											<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "TECH_DISPOSITION") }' >
												<c:set var="dispBtn" value="edit-disposition"/>
											</c:if>
											<div class="${vcg.primaryDispIcon} has-tooltip ${dispBtn}" title='<liferay-ui:message key="call-helpdesk-disposition" />'  >&nbsp;</div>
										</c:when>
									  </c:choose>
										Status:</div><liferay-ui:message key="${vcg.primaryDispReason}" />&nbsp;&nbsp;
									</div>
									<c:if test="${vcg.primaryDispReason eq 'IN_PROCESS' && !empty vcg.waiverPrimaryWork}">
										<c:choose> 
										<c:when test="${vcg.primaryWaiverCode eq 'DENIED' or vcg.primaryWaiverCode eq 'APPROVED' }" >
											<div class="delay-submitted selected-vcg-row" >
												VISN Application Delay processed, open until ${vcg.waiverPrimaryWorkExpires}
											</div>
										</c:when>
										<c:when test="${vcg.primaryWaiverCode eq 'VISN_REVIEW_NEEDED'}" >
											<div class="delay-submitted selected-vcg-row" >
												VISN Application Delay Review Submitted
											</div>
										</c:when>
										<c:otherwise>
										</c:otherwise>
									  </c:choose>
											
									</c:if>
									
									<div class="selected-vcg-row float-left">
										<fmt:formatDate value="${vcg.tierEffectiveDate}" var="tierEffectiveDate" type="date" pattern="MM/dd/yyyy"/>
										<div class="srow-label">
										<c:if test="${vcg.tierEditEnabled}" >
											<div class="edit-tier ${vcg.tierIcon} has-tooltip" title='<liferay-ui:message key="tier-tooltip"/>' >&nbsp;</div>
										</c:if>
										Tier:</div><liferay-ui:message key="tier-level-${vcg.tierLevel}" />
										<c:if test="${vcg.tierAppealed}" >
											-In Appeal &nbsp;
										</c:if>	
									</div>
									<div class="has-tooltip" title='Tier Effective date' >&nbsp; ${tierEffectiveDate} </div>
									
								<c:if test="${ vcg.monthlyAmount gt 0}">
									
									<div style="padding:2px;" id="${randomStr}itemization0" tabindex="0" class="has-tooltip" title="<liferay-ui:message key='click-to-toggle-last-payment-view'/>" >
									
										<div id="vendorStipend" class="selected-vcg-row header toggler-header-collapsed">
											<div class="arow-label">Monthly Stipend:</div><div class="icon-credit">&nbsp; <fmt:formatNumber value="${vcg.monthlyAmount}" type="currency"/> </div>
										</div>
										<div class="content toggler-content-collapsed portlet-msg-info" >
											<c:choose>
												<c:when test="${! empty vcg.lastPayment}">
													<div class="selected-vcg-row">
														<div class="arow-label">Last Payment Date:</div> <fmt:formatDate value="${vcg.lastPayment.paymentDate}" var="payDay" type="date" pattern="MM/dd/yyyy"/>${payDay} 
													</div>
													<div class="selected-vcg-row">
														<div class="arow-label">Last Payment Amount:</div> <fmt:formatNumber value="${vcg.lastPayment.amount}" type="currency"/> 
													</div>
												</c:when>
												<c:otherwise>
													No Payments found.
												</c:otherwise>
											</c:choose>
										</div>
									</div>
								</c:if>
									
									<hr/>
									<div class="split-left" >
										<div class="selected-vcg-row">
											<div class="arow-label">Address:</div>${primaryCaregiver.address} ${primaryCaregiver.address2}
										</div>
										<div class="selected-vcg-row">
											<div class="arow-label">&nbsp;&nbsp;
												<c:choose>
													<c:when test="${primaryCaregiver.validUspsAddress}">
														<div class="icon-star upper-icon-padding" title="<liferay-ui:message key='usps-validated'/>"></div>
													</c:when>
													<c:otherwise>
														<div class="icon-flag upper-icon-padding" title="<liferay-ui:message key='non-usps-validated'/>"></div>
													</c:otherwise>
												</c:choose>
											&nbsp;&nbsp;</div>${primaryCaregiver.city}, ${primaryCaregiver.state} ${primaryCaregiver.zip}
										</div>
										<div class="selected-vcg-row">
											<div class="lrow-label">Email:</div>${primaryCaregiver.email}  
										</div>
										<div class="selected-vcg-row">
											<div class="lrow-label">Phone:</div>${primaryCaregiver.phone}  ${primaryCaregiver.phone2} 
										</div>
										<hr/>
										<div class="selected-vcg-row">
											<div class="lrow-label">Relationship to Veteran:</div><liferay-ui:message key="${vcg.primaryType}" />
										</div>
										<div class="selected-vcg-row">
											<div class="lrow-label">Gender:</div> <liferay-ui:message key="${primaryCaregiver.gender}" />
										</div>
										<!-- 
										<div class="selected-vcg-row">
											<div class="lrow-label">ICN:</div>${primaryCaregiver.icn}
										</div>
										-->
										<div class="selected-vcg-row">
										<fmt:formatDate value="${primaryCaregiver.birthDate}" var="pbday" type="date" pattern="MM/dd/yyyy"/>
											<div class="lrow-label">DOB:</div> ${pbday}
										</div>
										<div class="selected-vcg-row">
											<div class="lrow-label">Medicare Enrolled:</div> <liferay-ui:message key="${empty primaryCaregiver.mediEnrolled? 'neither': primaryCaregiver.mediEnrolled}-yes" />
										</div>
										<div class="selected-vcg-row">
											<div class="lrow-label">Tricare Enrolled:</div> <liferay-ui:message key="${empty primaryCaregiver.tricareEnrolled? 'neither':  primaryCaregiver.tricareEnrolled}-yes" />
										</div>
										<div class="selected-vcg-row">
											<div class="lrow-label">CHAMPVA Enrolled:</div> <liferay-ui:message key="${empty primaryCaregiver.champEnrolled? 'neither':  primaryCaregiver.champEnrolled}-yes" />
										</div>
										<div class="selected-vcg-row">
											<div class="lrow-label">Other Insurance:</div> ${primaryCaregiver.otherHealthInsurance}
										</div>
									</div>
									
								</div>
							</div>
					</div>
				</div>
			</div>
		</div>
	</c:if>

	
	<c:if test="${! empty vcg.secondary}">
	<c:set var="secondaryCaregiver" value="${vcg.secondary}" />
<div class="select-caregiver" >
		<div class="person-selection vcg-entry-menu" id="${secondaryCaregiver.primaryKey}" >
			<div>
				<div class="float-left">
					<a class="btn-link ${editAction} btn-primary" title='<liferay-ui:message key="${title}" />'  >&nbsp;<liferay-ui:message key="edit-vcg-secondary" /></a>
				</div>
				<div class="float-right">
					<a class="btn-link ${auditLog} btn-primary" title='<liferay-ui:message key="vcg-person-audit-log-tooltip" />' >&nbsp;<liferay-ui:message key="vcg-entry-log" /></a>
				</div>
			</div>
			<hr/>
			<div class="center-position">
				<div class="care-giver-name" id="update_secondary">
					
						<div class="selected-vcg">
				    	 	<div class="selected-info">
				    	 		<div class="selected-vcg-row">
				    	 			<c:if test="${!secondaryCaregiver.verifiedIdentity}" >
				    	 				<c:set var="secBtn" value="btn"/>
				    	 			</c:if>
				    	 			<div class="srow-label">Secondary Name:</div>${secondaryCaregiver.lastName}, ${secondaryCaregiver.firstName} ${secondaryCaregiver.middleName} &nbsp;
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">SSN:</div> ${secondaryCaregiver.ssn}
				    			</div>
				    			
				    			<div class="selected-vcg-row" style="background: rgb(31, 147, 255); color: white; font-size:large;" >
				    	 			<div class="srow-label">
				    	 			<c:choose>
				    	 			<c:when test="${ vcg.hasSecondaryDispChoices() || vcg.secondaryWaiverCode eq 'VISN_NEEDED' || vcg.secondaryWaiverCode eq 'VISN_REVIEW_EXPIRED' }" >
				    	 				<c:set var="dispReason">
				    	 				  <c:choose>
				    						<c:when test="${fn:startsWith(vcg.secondaryDispReason, 'revoked')}">revoked-caregiver</c:when>
				    						<c:otherwise>${vcg.secondaryDispReason}</c:otherwise>
				    					 </c:choose>
				    					 </c:set>
				    	 				<div class="edit-disposition ${vcg.secondaryDispIcon} has-tooltip" title='<liferay-ui:message key="${dispReason}-tooltip" />'  >&nbsp;</div>
				    	 			</c:when>
				    	 			<c:when test="${ !vcg.hasSecondaryDispChoices() and ( fn:startsWith(vcg.secondaryDispReason, 'revoked') || fn:startsWith(vcg.secondaryDispReason, 'disapproved') )  }" >
				    	 		    	<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "TECH_DISPOSITION") }' >
											<c:set var="dispBtn" value="edit-disposition"/>
										</c:if>
				    	 		    	<div class="${vcg.secondaryDispIcon} has-tooltip ${dispBtn}" title='<liferay-ui:message key="call-helpdesk-disposition" />'  >&nbsp;</div>
				    	 		    </c:when>
				    	 		   </c:choose>
				    	 			Status:</div><liferay-ui:message key="${vcg.secondaryDispReason}" />&nbsp;&nbsp;
				    			</div>
				    			<c:if test="${vcg.secondaryDispReason eq 'IN_PROCESS' && !empty vcg.waiverSecondaryWork}">
				    			
				    				<c:choose> 
				    	 			<c:when test="${! empty vcg.secondaryWaiverCode eq 'DENIED' or vcg.secondaryWaiverCode eq 'APPROVED'}" >
				    	 				<div class="delay-submitted selected-vcg-row" >
				    	 					VISN Application Delay processed, open until ${vcg.waiverSecondaryWorkExpires}
				    	 				</div>
				    	 			</c:when>
				    				<c:when test="${vcg.secondaryWaiverCode eq 'VISN_REVIEW_NEEDED'}" >
				    					<div class="delay-submitted selected-vcg-row" >
				    	 					VISN Application Delay Review Submitted
				    	 				</div>
									</c:when>
				    	 		  </c:choose>
				    	 				
				    	 		</c:if>
				    			
				    			
				    			<hr>
				    			<div class="selected-vcg-row">
				    				<div class="arow-label">Address:</div>${secondaryCaregiver.address} ${secondaryCaregiver.address2}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="arow-label">&nbsp;&nbsp;
				    					<c:choose>
				    						<c:when test="${secondaryCaregiver.validUspsAddress}">
						    					<div class="icon-star upper-icon-padding" title="<liferay-ui:message key='usps-validated'/>"></div>
				    						</c:when>
				    						<c:otherwise>
												<div class="icon-flag upper-icon-padding" title="<liferay-ui:message key='non-usps-validated'/>"></div>
				    						</c:otherwise>
				    					</c:choose>
									&nbsp;&nbsp;</div>${secondaryCaregiver.city}, ${secondaryCaregiver.state} ${secondaryCaregiver.zip}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Email:</div>${secondaryCaregiver.email}  
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Phone:</div>${secondaryCaregiver.phone}  ${secondaryCaregiver.phone2} 
				    			</div>
				    			
				    			<hr>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">Relationship to Veteran:</div><liferay-ui:message key="${vcg.secondaryType}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">Gender:</div> <liferay-ui:message key="${secondaryCaregiver.gender}" />
				    			</div>
				    			<!-- 
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">ICN:</div> ${secondaryCaregiver.icn}
				    			</div>
				    			 -->
				    			<div class="selected-vcg-row">
				    				<fmt:formatDate value="${secondaryCaregiver.birthDate}" var="sbday" type="date" pattern="MM/dd/yyyy"/>
				    	 			<div class="lrow-label">DOB:</div> ${sbday}
				    			</div>
				    		</div>
			    		</div>
			    		
				</div>
			</div>
		</div>
	</div>
			    	</c:if>


					<c:if test="${! empty vcg.secondaryTwo}">
						<c:set var="secondaryTwoCaregiver" value="${vcg.secondaryTwo}" />
<div class="select-caregiver" >
		<div class="person-selection vcg-entry-menu" id="${secondaryTwoCaregiver.primaryKey}" >
			<div>
				<div class="float-left">
					<a class="btn-link ${editAction} btn-primary" title='<liferay-ui:message key="${title}" />'  >&nbsp;<liferay-ui:message key="edit-vcg-secondaryTwo" /></a>
				</div>
				<div class="float-right">
					<a class="btn-link ${auditLog} btn-primary" title='<liferay-ui:message key="vcg-person-audit-log-tooltip" />'  >&nbsp;<liferay-ui:message key="vcg-entry-log" /></a>
				</div>
			</div>
			<hr/>
			<div class="center-position">
				<div class="care-giver-name" id="update_secondaryTwo">
						<div class="selected-vcg">
				    	 	<div class="selected-info">
				    	 		<div class="selected-vcg-row">
				    	 			<div class="srow-label">Secondary II Name:</div>${secondaryTwoCaregiver.lastName}, ${secondaryTwoCaregiver.firstName} ${secondaryTwoCaregiver.middleName} &nbsp;
				    	 			<c:if test="${!secondaryTwoCaregiver.verifiedIdentity}" >
				    	 				<c:set var="secTwoBtn" value="btn"/>
				    	 			</c:if>
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">SSN:</div> ${secondaryTwoCaregiver.ssn} 
				    			</div>
				    			<div class="selected-vcg-row" style="background: rgb(31, 147, 255); color: white; font-size:large;" >
				    	 			<div class="srow-label">
				    	 			<c:choose>
				    	 			<c:when test="${vcg.hasSecondaryTwoDispChoices() || vcg.secondaryTwoWaiverCode eq 'VISN_NEEDED' || vcg.secondaryTwoWaiverCode eq 'VISN_REVIEW_EXPIRED' }" >
				    	 				<c:set var="dispReason">
				    	 				  <c:choose>
				    						<c:when test="${fn:startsWith(vcg.secondaryTwoDispReason, 'revoked')}">revoked-caregiver</c:when>
				    						<c:otherwise>${vcg.secondaryTwoDispReason}</c:otherwise>
				    					 </c:choose>
				    					 </c:set>
				    	 				<div class="edit-disposition ${vcg.secondaryTwoDispIcon} has-tooltip" title='<liferay-ui:message key="${dispReason}-tooltip" />'  >&nbsp;</div>
				    	 			</c:when>
				    	 			<c:when test="${ !vcg.hasSecondaryTwoDispChoices() and ( fn:startsWith(vcg.secondaryTwoDispReason, 'revoked') || fn:startsWith(vcg.secondaryTwoDispReason, 'disapproved') )  }" >
				    	 		    	<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "TECH_DISPOSITION") }' >
											<c:set var="dispBtn" value="edit-disposition"/>
										</c:if>
				    	 		    	<div class="${vcg.secondaryTwoDispIcon} has-tooltip ${dispBtn}" title='<liferay-ui:message key="call-helpdesk-disposition" />'  >&nbsp;</div>
				    	 		    </c:when>
				    	 		   </c:choose>
				    	 			Status:</div><liferay-ui:message key="${vcg.secondaryTwoDispReason}" />&nbsp;&nbsp;
				    			</div>
				    			<c:if test="${vcg.secondaryTwoDispReason eq 'IN_PROCESS' && !empty vcg.waiverSecondaryTwoWork}">
				    			
				    				<c:choose> 
				    	 			<c:when test="${! empty vcg.secondaryTwoWaiverCode eq 'DENIED' or vcg.secondaryTwoWaiverCode eq 'APPROVED'}" >
				    	 				<div class="delay-submitted selected-vcg-row" >
				    	 					VISN Application Delay processed, open until ${vcg.waiverSecondaryTwoWorkExpires}
				    	 				</div>
				    	 			</c:when>
				    				<c:when test="${vcg.secondaryTwoWaiverCode eq 'VISN_REVIEW_NEEDED'}" >
				    					<div class="delay-submitted selected-vcg-row" >
				    	 					VISN Application Delay Review Submitted
				    	 				</div>
									</c:when>
				    	 		  </c:choose>
				    	 				
				    	 		</c:if>
				    			
				    			
				    			<hr>
				    			<div class="selected-vcg-row">
				    				<div class="arow-label">Address:</div>${secondaryTwoCaregiver.address} ${secondaryTwoCaregiver.address2}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="arow-label">&nbsp;&nbsp;
				    					<c:choose>
				    						<c:when test="${secondaryTwoCaregiver.validUspsAddress}">
						    					<div class="icon-star upper-icon-padding" title="<liferay-ui:message key='usps-validated'/>"></div>
				    						</c:when>
				    						<c:otherwise>
												<div class="icon-flag upper-icon-padding" title="<liferay-ui:message key='non-usps-validated'/>"></div>
				    						</c:otherwise>
				    					</c:choose>
									&nbsp;&nbsp;</div>${secondaryTwoCaregiver.city}, ${secondaryTwoCaregiver.state} ${secondaryTwoCaregiver.zip}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Email:</div>${secondaryTwoCaregiver.email}  
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Phone:</div>${secondaryTwoCaregiver.phone}  ${secondaryTwoCaregiver.phone2} 
				    			</div>
				    			
				    			<hr>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">Relationship to Veteran:</div><liferay-ui:message key="${vcg.secondaryTwoType}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">Gender:</div> <liferay-ui:message key="${secondaryTwoCaregiver.gender}" />
				    			</div>
				    			<!-- 
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">ICN:</div> ${secondaryTwoCaregiver.icn}
				    			</div>
				    			 -->
				    			<div class="selected-vcg-row">
				    				<fmt:formatDate value="${secondaryTwoCaregiver.birthDate}" var="s2bday" type="date" pattern="MM/dd/yyyy"/>
				    	 			<div class="lrow-label">DOB:</div> ${s2bday}
				    			</div>
				    		</div>
			    		</div>
				</div>
			</div>
		</div>
	</div>
			    	</c:if>
	
	<c:if test="${vcg.generalAssignable}">
		<c:set var="editAction" value="create-vcg-entry icon-user" />
		<c:set var="editVal">Assign</c:set>
		
		<c:set var="editGenAction" value="edit-vcg-entry icon-pencil" />
	</c:if>
	
<div class="select-caregiver" >
	<c:set var="generalCaregiver" value="${vcg.general}" />
		<div class="person-selection vcg-entry-menu" id="${generalCaregiver.primaryKey}" >
			<div>
				<div class="float-left">
					<a class="btn-link ${editAction} btn-primary" title='<liferay-ui:message key="${title}" />'  >&nbsp;<liferay-ui:message key="edit${editVal}-vcg-general" /></a>
				</div>
				<div class="float-right">
					<a class="btn-link ${auditLog} btn-primary" title='<liferay-ui:message key="vcg-person-audit-log-tooltip" />'  >&nbsp;<liferay-ui:message key="vcg-entry-log" /></a>
				</div>
			</div>
			<hr/>
			<div class="center-position">
				<div class="care-giver-name" id="update_general">
	<c:if test="${! empty vcg.general}">
						<div class="selected-vcg">
				    	 	<div class="selected-info">
				    	 		<div class="selected-vcg-row">
				    	 			
				    	 			<div class="srow-label">
				    	 			<c:if test="${!empty editGenAction}" >
					    	 			<div class="edit-vcg-entry icon-pencil " title='<liferay-ui:message key="edit-vcg-general" />'  >&nbsp;</div>
				    	 			</c:if>
				    	 			General Caregiver Name:</div>${generalCaregiver.lastName}, ${generalCaregiver.firstName} ${generalCaregiver.middleName} &nbsp;
				    	 			<c:if test="${!generalCaregiver.verifiedIdentity}" >
				    	 				<c:set var="genBtn" value="btn"/>
				    	 			</c:if>
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">SSN:</div> ${generalCaregiver.ssn} 
				    			</div>
				    			<div class="selected-vcg-row" style="background: rgb(31, 147, 255); color: white; font-size:large;" >
				    	 			<div class="srow-label">
				    	 			<c:if test="${ vcg.hasGeneralDispChoices() }" >
				    	 				<c:set var="dispReason">
				    	 				  <c:choose>
				    						<c:when test="${fn:startsWith(vcg.generalDispReason, 'revoked')}">revoked-caregiver</c:when>
				    						<c:otherwise>${vcg.generalDispReason}</c:otherwise>
				    					  </c:choose>
				    					 </c:set>
				    	 				<div class="edit-disposition ${vcg.generalDispIcon} has-tooltip" title='<liferay-ui:message key="${dispReason}-tooltip" />'  >&nbsp;</div>
				    	 			</c:if>
				    	 			Status:</div><liferay-ui:message key="${vcg.generalDispReason}" />&nbsp;&nbsp;
				    			</div>
				    			
				    			
				    			<hr>
				    			<div class="selected-vcg-row">
				    				<div class="arow-label">Address:</div>${generalCaregiver.address} ${generalCaregiver.address2}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="arow-label">&nbsp;&nbsp;
				    					<c:choose>
				    						<c:when test="${generalCaregiver.validUspsAddress}">
						    					<div class="icon-star upper-icon-padding" title="<liferay-ui:message key='usps-validated'/>"></div>
				    						</c:when>
				    						<c:otherwise>
												<div class="icon-flag upper-icon-padding" title="<liferay-ui:message key='non-usps-validated'/>"></div>
				    						</c:otherwise>
				    					</c:choose>
									&nbsp;&nbsp;</div>${generalCaregiver.city}, ${generalCaregiver.state} ${generalCaregiver.zip}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Email:</div>${generalCaregiver.email}  
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Phone:</div>${generalCaregiver.phone}  ${generalCaregiver.phone2} 
				    			</div>
				    			<hr>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">Relationship to Veteran:</div><liferay-ui:message key="${vcg.generalType}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">Gender:</div> <liferay-ui:message key="${generalCaregiver.gender}" />
				    			</div>
				    			<!-- 
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">ICN:</div> ${generalCaregiver.icn}
				    			</div>
				    			 -->
				    			<div class="selected-vcg-row">
				    				<fmt:formatDate value="${generalCaregiver.birthDate}" var="s2bday" type="date" pattern="MM/dd/yyyy"/>
				    	 			<div class="lrow-label">DOB:</div> ${s2bday}
				    			</div>
				    		</div>
			    		</div>
			    	</c:if>
				</div>
			</div>
		</div>
	</div>
									
				
				</div>
			</div>
		</fieldset>
	</div>
		
	<div class="next-line">	
	  	<fieldset id="sectionCollapse8" class="clear-both vcg-section">
			<legend class="header"><div class="icon-list-alt"></div> <liferay-ui:message key="vcg-notes" /></legend>
			<div class="content toggler-header-expanded"  id="vcgNotesOuter" >
				<div id="vcgNotes" class="tab-pane" ></div>
			</div>
		</fieldset>
	</div>
	
	<div class="next-line">	
	  	<fieldset id="sectionCollapse1" class="clear-both vcg-section">
			<legend class="header"><div class="icon-folder-open"></div> <liferay-ui:message key="supporting-docs" /></legend>
				
			<div class="content toggler-header-expanded"  id="supportingDocsOuter" >
				<div id="supportingDocs" class="tab-pane" > 	
				
					<div>
						<a class="btn-link section-link supporting-documents-all icon-time btn-primary"  title="<liferay-ui:message key="supporting-docs-all" />" >&nbsp;<liferay-ui:message key="supporting-docs-all" /></a>
					</div>
					<div>
						<a class="btn-link section-link supporting-documents-history icon-time btn-primary"  title="<liferay-ui:message key="supporting-docs-history" />" >&nbsp;<liferay-ui:message key="supporting-docs-history" /></a>
					</div>
					
					
					<div class="sectionHeading">Current Supporting Documents</div>		
	<div class="summaryTable">
		<table style="width:98%">
			<tr>
			  <th width="5%">Type</th> 
			  <th width="15%">File Name</th> 
			  <th width="5%">File Type</th>
			  <th width="5%">File Size</th> 	
			  <th width="10%">Creation Date</th>  
			   <th width="10%">Created By</th>  
			  <th width="5%">Primary</th> 
			  <th width="5%">Secondary</th>
			  <th width="5%">Secondary Two</th>
			  <th width="10%">Action</th>			  
			</tr>
			
		<c:if test="${form_['vcgDocsCurrentSize'] gt 0}">
			<c:forEach var="doc" items="${form_['vcgDocsCurrent']}">	
			<tr id="row_${doc.documId}">
			    <td>${doc.uiDocType}</td>
			    <td>${doc.name}</td>
			    <td>${doc.docType}</td>
			    <td>${doc.docSize}&nbsp;KB</td>
			    <td>${doc.creationDate}</td>
			    <td>${doc.createdByLastName} , ${doc.createdByFirstName}</td>
			    <td><c:if test="${doc.primary}"><div class="icon-ok"></div></c:if></td>
			    <td><c:if test="${doc.secondary}"><div class="icon-ok"></div></c:if></td>
			    <td><c:if test="${doc.secondaryTwo}"><div class="icon-ok"></div></c:if></td>
			    <td>
					<portlet:resourceURL var="getDocum">
						<portlet:param name="action" value="getDocum"/>
						<portlet:param name="documId" value="${doc.documId}"/>
					</portlet:resourceURL>
					<a href="${getDocum}" target="_blank" ><i class="close-window btn btn-primary" >&nbsp; View</i></a>
					<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "VIEW_DELETED_DOCS") }' >
					<a class="btn-primary delete-document" id="${doc.documId}"><i class="close-window btn btn-primary" >&nbsp; Delete</i></a>
					</c:if>			    	
				</td>
			</tr>
			</c:forEach>
		</c:if>
		<c:if test="${form_['vcgDocsCurrentSize'] eq 0}">
			<tr>
				<td colspan=10>No Current Documents because there are no In Process, Approved or Reinstated Caregivers</td>
			</tr>
		</c:if>
		
		</table>
	</div>
				
				</div>
			</div>
		</fieldset>
	</div>

	<div class="next-line">	
	  	<fieldset id="sectionCollapse2" class="clear-both vcg-section">
			<legend class="header"><div class="icon-file"></div> <liferay-ui:message key="assessments" /></legend>
			<div class="content toggler-header-expanded"  id="assessmentsOuter" >
				<div id="assessments" class="tab-pane" >
				
					<div>
						<a class="btn-link section-link assessment-history-all icon-time btn-primary" title="<liferay-ui:message key="assmt-audit-log" />" >&nbsp;<liferay-ui:message key="assmt-audit-all" /></a>
					</div>
					
					
					<c:if test="${vcg.primaryId gt 0 && (vcg.primaryDispReason eq 'IN_PROCESS' || vcg.primaryDispReason eq 'APPROVED' || vcg.primaryDispReason eq 'REINSTATED') }">
		<div class="sectionHeading">Primary Caregiver</div>		
		<div class="summaryTable">
		<table style="width:98%">
			<tr>
			  <td width="100%" colspan='5' style="text-align:left;">Valid Application Received Date - ${primaryValidAppDate}</td> 
			</tr>

			<tr>
			  <th width="30%">Assessment</th> 
			  <th width="10%">* Completion Date</th> 	  
			  <th width="30%">Comment/Note</th> 
			  <th width="15%">Action</th>
			  <th width="15%">History</th>			  
			</tr>
	
			<c:forEach var="oneAssessment" items="${form_['primaryAssessmentList']}" >	
			<c:set var="isDisabled" value="false"/>
			<!-- Disable when primary status id approved or reinstated, or assessment is already there -->
			<c:if test="${ vcg.primaryDispReason eq 'APPROVED' || vcg.primaryDispReason eq 'REINSTATED' || oneAssessment.assessment.assmtId gt 0}"><c:set var="isDisabled" value="true"/></c:if>
			<tr>
			    <td>
				    <input type="hidden" name="${oneAssessment.assessment.type}_caregiverId" value="${vcg.primaryId}" id="${oneAssessment.assessment.type}_caregiverId"/>
				    <input type="hidden" name="${oneAssessment.assessment.type}_assessmentId" value="${oneAssessment.assessment.assmtId}" id="${oneAssessment.assessment.type}_assessmentId"/>
				    <liferay-ui:message key="${oneAssessment.assessment.type}_ui" />
				</td>
			    <td>
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass['completionDate']}"  >
						<aui:input label="" name="${oneAssessment.assessment.type}_completionDate" value="${oneAssessment.formattedcompletionDate}" cssClass="date-field" type="text" id="${oneAssessment.assessment.type}_completionDate" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			  		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass}"  >
				 		<aui:input label="" name="${oneAssessment.assessment.type}_comment" value="${oneAssessment.assessment.comment}" type="textarea" id="${oneAssessment.assessment.type}_comment" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			    	<!-- show only when primary caregiver status is in_process -->
			    	<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "TRACK_ASSESSMENT") }' >
			    	<c:if test="${vcg.primaryDispReason eq 'IN_PROCESS'}">
			    	<div id="action_${oneAssessment.assessment.type}">			    	
				    	<a class="btn-primary save-assessment" id="save_${oneAssessment.assessment.type}" style="${isDisabled ? 'display: none' : ''}"><i class="close-window btn btn-primary" >Save</i></a>
				    	<a class="btn-primary edit-assessment" id="edit_${oneAssessment.assessment.type}" style="${isDisabled ? '' : 'display: none'}"><i class="close-window btn btn-primary" >Edit</i></a>			    	
			    	</div>
			    	</c:if>
			    	</c:if>
		    	</td>
		    	<td>
					<div>
						<a class="btn-link assessment-history icon-time btn-primary history_div_${oneAssessment.assessment.type}" id="${oneAssessment.assessment.assmtId}" title="<liferay-ui:message key="assmt-audit-log" />" >&nbsp;<liferay-ui:message key="history" /></a>
					</div>
		    	</td>
			</tr>
			</c:forEach>
		</table>
		</div>
		</c:if>
				
				<c:if test="${vcg.secondaryId gt 0 && (vcg.secondaryDispReason eq 'IN_PROCESS' || vcg.secondaryDispReason eq 'APPROVED' || vcg.secondaryDispReason eq 'REINSTATED') }">
		<div class="sectionHeading">Secondary Caregiver</div>
		<div class="summaryTable">
		<table style="width:98%">
			<tr>
			  <td width="100%" colspan='5' style="text-align:left;">Valid Application Received Date - ${secondaryValidAppDate}</td> 
			</tr>

			<tr>
			  <th width="30%">Assessment</th> 
			  <th width="10%">* Completion Date</th> 	  
			  <th width="30%">Comment/Note</th> 
			  <th width="15%">Action</th>
			  <th width="15%">History</th>			  
			</tr>
	
			<c:forEach var="oneAssessment" items="${form_['secondaryAssessmentList']}" >
			<c:set var="isDisabled" value="false"/>
			<c:if test="${vcg.secondaryDispReason eq 'APPROVED' || vcg.secondaryDispReason eq 'REINSTATED' || oneAssessment.assessment.assmtId gt 0}"><c:set var="isDisabled" value="true"/></c:if>
			<tr>
			    <td>
				    <input type="hidden" name="${oneAssessment.assessment.type}_caregiverId" value="${vcg.secondaryId}" id="${oneAssessment.assessment.type}_caregiverId"/>
				    <input type="hidden" name="${oneAssessment.assessment.type}_assessmentId" value="${oneAssessment.assessment.assmtId}" id="${oneAssessment.assessment.type}_assessmentId"/>
				    <liferay-ui:message key="${oneAssessment.assessment.type}_ui" />
				</td>
			    <td>
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass['completionDate']}"  >
						<aui:input label="" name="${oneAssessment.assessment.type}_completionDate" value="${oneAssessment.formattedcompletionDate}" cssClass="date-field" type="text" id="${oneAssessment.assessment.type}_completionDate" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			  		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass}"  >
				 		<aui:input label="" name="${oneAssessment.assessment.type}_comment" value="${oneAssessment.assessment.comment}" type="textarea" id="${oneAssessment.assessment.type}_comment" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			    	<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "TRACK_ASSESSMENT") }' >
			    	<c:if test="${vcg.secondaryDispReason eq 'IN_PROCESS'}">
			    	<div id="action_${oneAssessment.assessment.type}">			    	
				    	<a class="btn-primary save-assessment" id="save_${oneAssessment.assessment.type}" style="${isDisabled ? 'display: none' : ''}"><i class="close-window btn btn-primary" >Save</i></a>
				    	<a class="btn-primary edit-assessment" id="edit_${oneAssessment.assessment.type}" style="${isDisabled ? '' : 'display: none'}"><i class="close-window btn btn-primary" >Edit</i></a>			    	
			    	</div>
			    	</c:if>
			    	</c:if>
		    	</td>
		    	<td>
					<div>
						<a class="btn-link assessment-history icon-time btn-primary history_div_${oneAssessment.assessment.type}" id="${oneAssessment.assessment.assmtId}" title="<liferay-ui:message key="assmt-audit-log" />" >&nbsp;<liferay-ui:message key="history" /></a>
					</div>
		    	</td>
			</tr>
			</c:forEach>
		</table>
		</div>
		</c:if>
		
		<c:if test="${vcg.secondaryTwoId gt 0  && (vcg.secondaryTwoDispReason eq 'IN_PROCESS' || vcg.secondaryTwoDispReason eq 'APPROVED' || vcg.secondaryTwoDispReason eq 'REINSTATED') }">
		<div class="sectionHeading">Secondary Two Caregiver</div>
		<div class="summaryTable">
		<table style="width:98%">
			<tr>
			  <td width="100%" colspan='5' style="text-align:left;">Valid Application Received Date - ${secondaryTwoValidAppDate}</td> 
			</tr>

			<tr>
			  <th width="30%">Assessment</th> 
			  <th width="10%">* Completion Date</th> 	  
			  <th width="30%">Comment/Note</th> 
			  <th width="15%">Action</th>
			  <th width="15%">History</th>			  
			</tr>
	
			<c:forEach var="oneAssessment" items="${form_['secondaryTwoAssessmentList']}" >
			<c:set var="isDisabled" value="false"/>
			<c:if test="${ vcg.secondaryTwoDispReason eq 'APPROVED' || vcg.secondaryTwoDispReason eq 'REINSTATED' || oneAssessment.assessment.assmtId gt 0}"><c:set var="isDisabled" value="true"/></c:if>
			<tr>
			    <td>
				    <input type="hidden" name="${oneAssessment.assessment.type}_caregiverId" value="${vcg.secondaryTwoId}" id="${oneAssessment.assessment.type}_caregiverId"/>
				    <input type="hidden" name="${oneAssessment.assessment.type}_assessmentId" value="${oneAssessment.assessment.assmtId}" id="${oneAssessment.assessment.type}_assessmentId"/>
				    <liferay-ui:message key="${oneAssessment.assessment.type}_ui" />
				</td>
			    <td>
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass['completionDate']}"  >
						<aui:input label="" name="${oneAssessment.assessment.type}_completionDate" value="${oneAssessment.formattedcompletionDate}" cssClass="date-field" type="text" id="${oneAssessment.assessment.type}_completionDate" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			  		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass}"  >
				 		<aui:input label="" name="${oneAssessment.assessment.type}_comment" value="${oneAssessment.assessment.comment}" type="textarea" id="${oneAssessment.assessment.type}_comment" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
					<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "TRACK_ASSESSMENT") }' >
			    	<c:if test="${vcg.secondaryTwoDispReason eq 'IN_PROCESS'}">
			    	<div id="action_${oneAssessment.assessment.type}">			    	
				    	<a class="btn-primary save-assessment" id="save_${oneAssessment.assessment.type}" style="${isDisabled ? 'display: none' : ''}"><i class="close-window btn btn-primary" >Save</i></a>
				    	<a class="btn-primary edit-assessment" id="edit_${oneAssessment.assessment.type}" style="${isDisabled ? '' : 'display: none'}"><i class="close-window btn btn-primary" >Edit</i></a>			    	
			    	</div>
			    	</c:if>
			    	</c:if>
		    	</td>
		    	<td>
					<div>
						<a class="btn-link assessment-history icon-time btn-primary history_div_${oneAssessment.assessment.type}" id="${oneAssessment.assessment.assmtId}" title="<liferay-ui:message key="assmt-audit-log" />" >&nbsp;<liferay-ui:message key="history" /></a>
					</div>
		    	</td>
			</tr>
			</c:forEach>
		</table>
		</div>
		</c:if>
				
				
				</div>
			</div>
		</fieldset>
	</div>
	
	<div class="next-line">	
	  	<fieldset id="sectionCollapse3" class="clear-both vcg-section">
			<legend class="header"><div class="icon-list"></div> <liferay-ui:message key="assessments-ongoing" /></legend>
			<div class="content toggler-header-expanded"  id="ongoingAssessmentsOuter" >
				<div id="ongoingAssessments" class="tab-pane" > 	
				
	<div>
		<a class="btn-link ongoing-assmt-all icon-time btn-primary"  title='<liferay-ui:message key="ongoing-assmt-all" />' >&nbsp;<liferay-ui:message key="ongoing-assmt-all" /></a>
	</div>
	<div>
		<a class="btn-link ongoing-assmt-history-all icon-time btn-primary"  title='<liferay-ui:message key="assmt-audit-log" />' >&nbsp;<liferay-ui:message key="assmt-audit-all" /></a>
	</div>

	
	<input type="hidden" name="section" value="${form_['section']}" id="section"/>	
	<input type="hidden" value="${veteranVcg.icn}" id="<portlet:namespace/>icn"/>	
		
		<div class="summaryTable">
		<table style="width:98%">
			<tr>
			  <td width="100%" colspan='7' style="text-align:left;">Primary Caregiver Approval Date - ${primaryApprovalDate}</td> 
			</tr>
			<tr>
			  <th width="10%">Assessment</th> 
			  <th width="10%">Due Date</th> 
			  <th width="10%">* Mode of Assessment</th>  
			  <th width="10%">* Completion Date</th> 	
			  <th width="15%">Comment/Note (* if completed more than 45 days before or after due date)</th> 
			  <th width="10%">Action</th>
			  <th width="10%">History</th>			  
			</tr>

		<c:if test="${vcg.primaryDispReason eq 'APPROVED' || vcg.primaryDispReason eq 'REINSTATED'}">	
			<c:if test="${form_['periodicAssessmentSize'] gt 0}">
			<c:forEach var="oneAssessment" items="${form_['periodicAssessmentList']}" >	
			<c:set var="isDisabled" value="false"/>
			<c:if test="${not empty oneAssessment.assessment.mode}"><c:set var="isDisabled" value="true"/></c:if>
			<tr>
			    <td>
				    <input type="hidden" name="${oneAssessment.assessment.assmtId}_caregiverId" value="${vcg.primaryId}" id="${oneAssessment.assessment.assmtId}_caregiverId"/>
				    <input type="hidden" name="${oneAssessment.assessment.assmtId}_type" value="${oneAssessment.assessment.type}" id="${oneAssessment.assessment.assmtId}_type"/>
				    <liferay-ui:message key="${oneAssessment.assessment.type}" />
				</td>
			    <td>
			   	 	<input type="hidden" name="${oneAssessment.assessment.assmtId}_scheduleDate" value="${oneAssessment.formattedScheduleDate}" id="${oneAssessment.assessment.assmtId}_scheduleDate"/>
			    	<c:out value="${oneAssessment.formattedScheduleDate}" />
				</td>
				<td>
					<div class="assmt-mode" id="${oneAssessment.assessment.assmtId}_modediv">
					<aui:select label="" name="${oneAssessment.assessment.assmtId}_mode" id="${oneAssessment.assessment.assmtId}_mode" disabled="${isDisabled}">
						<aui:option value="" >Select</aui:option>
						<aui:option value="In-home" label="In-home" selected="${oneAssessment.assessment.mode eq 'In-home'}"/>
						<c:if test="${oneAssessment.assessment.type ne 'annual'}">
							<aui:option value="Telephone" label="Telephone" selected="${oneAssessment.assessment.mode eq 'Telephone'}"/>
							<aui:option value="TeleHealth" label="TeleHealth" selected="${oneAssessment.assessment.mode eq 'TeleHealth'}"/>
							<aui:option value="Facility Visit" label="Facility Visit" selected="${oneAssessment.assessment.mode eq 'Facility Visit'}"/>
						</c:if>
						<aui:option value="Not completed" label="Not completed" selected="${oneAssessment.assessment.mode eq 'Not completed'}"/>
					</aui:select>
					</div>					
				</td>			
			    <td>
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass['completionDate']}"  >
						<aui:input label="" name="${oneAssessment.assessment.assmtId}_completionDate"  cssClass="date-field" value="${oneAssessment.assessment.mode eq 'Not completed' ? 'N/A' : oneAssessment.formattedcompletionDate}" type="text" id="${oneAssessment.assessment.assmtId}_completionDate" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			  		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass}"  >
				 		<aui:input label="" name="${oneAssessment.assessment.assmtId}_comment" value="${oneAssessment.assessment.comment}" type="textarea" id="${oneAssessment.assessment.assmtId}_comment" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
					<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "TRACK_ASSESSMENT") }' >
			    	<div id="action_${oneAssessment.assessment.assmtId}">			    	
				    	<a class="btn-primary save-assessment" id="save_${oneAssessment.assessment.assmtId}" style="${isDisabled ? 'display: none' : ''}"><i class="close-window btn btn-primary" >Save</i></a>
				    	<a class="btn-primary edit-per-assessment" id="edit_${oneAssessment.assessment.assmtId}" style="${isDisabled ? '' : 'display: none'}"><i class="close-window btn btn-primary" >Edit</i></a>			    	
			    	</div>
					</c:if>
		    	</td>
		    	<td>
					<div>
						<a class="btn-link assessment-history icon-time btn-primary history_div_${oneAssessment.assessment.assmtId}" id="${oneAssessment.assessment.assmtId}" title='<liferay-ui:message key="assmt-audit-log" />' >&nbsp;<liferay-ui:message key="history" /></a>
					</div>
		    	</td>
			</tr>
			</c:forEach>
			</c:if>
			<c:if test="${form_['periodicAssessmentSize'] eq 0}">
				<tr>
					<td colspan=7><liferay-ui:message key="no-periodic-assmt-found" /></td>
				</tr>	
			</c:if>
		</c:if>
		<c:if test="${vcg.primaryDispReason ne 'APPROVED' && vcg.primaryDispReason ne 'REINSTATED'}">	
			<tr>
				<td colspan=7>Primary caregiver not in Approved or Reinstated state</td>
			</tr>				
		</c:if>	
		
		</table>
		</div>
				
				
				</div>
			</div>
		</fieldset>
	</div>

	<div class="next-line">	
	  	<fieldset id="sectionCollapse6" class="clear-both vcg-section">
			<legend class="header"><div class="icon-eye-open"></div> <liferay-ui:message key="open-work" />, VCG ID ${vcg.vcgId}</legend>
			<div class="content toggler-header-expanded"  id="openWorkOuter" >
				<div id="openWork" class="tab-pane" url='<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="vcgOpenWork" /><portlet:param name="classPk" value="${vcg.vcgId}" /><portlet:param name="fromParameter" value="true" /><portlet:param name="context" value="manageVcg" /><portlet:param name="openClose" value="open" /><portlet:param name="workType" value="notCalls" /></portlet:resourceURL>' ></div>
			</div>
		</fieldset>
	</div>
	
	<div class="next-line">	
	  	<fieldset id="sectionCollapse7" class="clear-both vcg-section">
			<legend class="header"><div class="icon-eye-close"></div> <liferay-ui:message key="closed-work" /></legend>
			<div class="content toggler-header-expanded"  id="closedWorkOuter" >
				<div id="closedWork" class="tab-pane" url='<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="vcgClosedWork" /><portlet:param name="classPk" value="${vcg.vcgId}" /><portlet:param name="fromParameter" value="true" /><portlet:param name="context" value="manageVcg" /><portlet:param name="openClose" value="close" /><portlet:param name="workType" value="notCalls" /></portlet:resourceURL>' ></div>
			</div>
		</fieldset>
	</div>
	
	
	<div class="next-line">	
	  	<fieldset id="sectionCollapse4" class="clear-both vcg-section">
			<legend class="header"><div class="icon-phone"></div> <liferay-ui:message key="open-referrals" /></legend>
			<div class="content toggler-header-expanded"  id="openReferralsWorkOuter" >
				<div id="openReferralsWork" class="tab-pane" url='<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="vcgOpenRefs" /><portlet:param name="classPk" value="${vcg.vcgId}" /><portlet:param name="fromParameter" value="true" /><portlet:param name="context" value="manageVcg" /><portlet:param name="openClose" value="open" /><portlet:param name="workType" value="calls" /></portlet:resourceURL>' ></div>
			</div>
		</fieldset>
	</div>
	
	<div class="next-line">	
	  	<fieldset id="sectionCollapse5" class="clear-both vcg-section">
			<legend class="header"><div class="icon-phone-sign"></div> <liferay-ui:message key="closed-referrals" /></legend>
			<div class="content toggler-header-expanded"  id="closedReferralsWorkOuter" >
				<div id="closedReferralsWork" class="tab-pane" url='<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="vcgClosedRefs" /><portlet:param name="classPk" value="${vcg.vcgId}" /><portlet:param name="fromParameter" value="true" /><portlet:param name="context" value="manageVcg" /><portlet:param name="openClose" value="close" /><portlet:param name="workType" value="calls" /></portlet:resourceURL>' ></div>
			</div>
		</fieldset>
	</div>

	

<portlet:actionURL var="reviewMyWork">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="reviewMyWork"/>
</portlet:actionURL>

<aui:form name="reviewMyWork_fm" method="post"  action="${reviewMyWork}"  >
	<input type="hidden" id="reviewMyWorkNode" />
</aui:form>

<div id="review_work_entry">
</div>
<div id="work_header" >
</div>

<aui:script use="aui-modal" >
						
	 /////--------------------------------------
		window.manageOccWork = function( worImId, type, veteran, caregiver ) {
				    	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadOccWork" /><portlet:param name="page" value="manageOccWork"/><portlet:param name="strip" value="0"/><portlet:param name="fromParameter" value="true" /></portlet:resourceURL>', 'html', 
									{ 
				    	  				classPk: worImId,
				    	  				MODE: 3
									},
									function( data ){
										overwrite( A.one( '#review_work_entry' ), data );
										overwrite( A.one( '#work_header' ), (type + " (" + worImId + ") <p class='highlight-info'><i style='font-weight: bold;'> Veteran:</i>" + veteran + "</p><i style='font-weight: bold;'> Primary CG:</i>" + caregiver) );
										modalOccWork.render();
							        	modalOccWork.show();
							        	//window.enforceFormats();
									} 
							);
				    };
	
		var modalOccWork = new A.Modal({
				headerContent: A.one("#work_header"),
		        bodyContent: A.one("#review_work_entry"),
		        destroyOnHide: false,
		        modal: true,
		        render: '#modalUpdateWk',
		        visible: false,
				xy: [225, document.body.parentElement.scrollTop+25],
		        zIndex: 1100,
		        width: 1000		        
		    });
	 /////--------------------------------------
</aui:script>
<div class="">
	<div id="modalUpdateWk"></div>
</div>
<aui:script use="aui-base,aui-toggler,anim">
	window.loadNotes = function ( note ) {
		window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadVcgNotes" /><portlet:param name="page" value="vcgNotes" /><portlet:param name="classPk" value="${vcg.vcgId}" /><portlet:param name="fromParameter" value="true" /></portlet:resourceURL>', 'html', 
			{ note: note },
			function( data ){ 
				overwrite( A.one( "#vcgNotes" ), data );
				A.one('#<portlet:namespace/>addNode_comments').val("");
				loadWork();
			} 
		);
	}
	
	A.on('domready', loadNotes );
	
	window.loadWork = function () {
		var node0 = A.one('#openWork');
		window.caretIo( node0.attr('url'), 'html', {},
			function( data0 ){
				overwrite( node0, data0 );
				var node1 = A.one('#openReferralsWork');
				window.caretIo( node1.attr('url'), 'html', {},
					function( data1 ){
						overwrite( node1, data1 );
						var node2 = A.one('#closedWork');
						window.caretIo( node2.attr('url'), 'html', {},
							function( data2 ){
								overwrite( node2, data2 );
								var node3 = A.one('#closedReferralsWork');
								window.caretIo( node3.attr('url'), 'html', {},
									function( data3 ){
										overwrite( node3, data3 );
										var section = A.one("#${caretMap_['scrollContext']}");
										if ( section ) {
											var scrollTo = section.get('offsetTop');
											new A.Anim({
												duration: 0.5,
												easing: 'easeBoth',
												node: 'win',
												to: {
													scroll: [0, scrollTo]
												}
											}).run();
										}
									}//end data3
								); //end Io3
							} //end data2
						);//end Io2
					} //end data1
				); //end Io1
			} //end data0
		);
	}
	
	
     
	
</aui:script>

<portlet:actionURL var="addVcgNote">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="addVcgNote"/>
</portlet:actionURL>

<div id="addVcgNote">
	<aui:form action="${addVcgNote}" method="post" name="addNote_fm"  >
	
	<input type="hidden" name="<portlet:namespace/>vcgId" value="${vcg.vcgId}" id="<portlet:namespace/>addNode_vcgId" >
			
	<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="manage-layout-medium-input ${cssClass}" >
 		<aui:input label="new-vcg-note" name="addNode_comments" id="addNode_comments" size="35" type="textarea"  />
	</aui:field-wrapper>
		
	</aui:form>
</div>
	
	<input type="hidden" id="<portlet:namespace/>placeHolder" />
	
	
<portlet:actionURL var="saveEntry">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="saveEntry"/>
	<portlet:param name="entry" value="vcg" />
</portlet:actionURL>

<div class="yui3-skin-sam">
	<aui:form name="sign_fm" method="post"  action="${saveEntry}"  >
		<input type="hidden" name="vcgId" value="${vcg.vcgId}" >
		
    	<div id="modalUpdateVcg">
    	</div>
    </aui:form>
</div>
 <div id="edit_vcg_entry">
</div>

<div class="yui3-skin-sam">
   	<div id="modalEligibility">
   	</div>
</div>
<div id="eligibility_entry">	
</div>


<div class="yui3-skin-sam">
   	<div id="modalAuditVcg">
   	</div>
</div>
 <div id="audit_vcg_entry">
</div>

<div id="audit_work_entry">
</div>

<div class="yui3-skin-sam">
	<div id="modalCreateNote"></div>
</div>


	<aui:script use="aui-tooltip,aui-modal,io-form,querystring-stringify">
			new A.TooltipDelegate( { trigger: '.has-tooltip, .vcg-entry-menu .btn-link, .vcg-entry-menu .icon-time, .vcg-entry-menu .icon-plus, .icon-time .icon-ok, .upper-icon-padding' } );
			
			
			
			
			
			var modal = new A.Modal({
				headerContent: '<h4><liferay-ui:message key="update-vcg-entry-header" /></h4>',
		        bodyContent: A.one("#edit_vcg_entry"),
		        centered: true,
		        destroyOnHide: false,
		        modal: true,
		        render: '#modalUpdateVcg',
		        resizable: {
		          handles: 'b, r'
		        },
		        visible: false,
		        width: 1000
		    });
			
			
		window.preventUser = function() {
			return "<liferay-ui:message key='back-button-lose-form-data' />";
		}
		window.addEventListener('beforeunload', preventUser);
		
		A.all("#breadcrumbs a, .collapse nav-collapse, .nav-away, li.nav-away, .taglib-icon").on('click', function(){
				window.removeEventListener('beforeunload', preventUser);
		});
		
		
			
			modal.addToolbar([
			                         {
			                           label: 'Cancel',
			                           on: {
			                             click: function() {
			                            	 modal.hide();
			                             }
			                           }
			                         },{
			                           label: 'Update',
			                           on: {
			                             click: function() {
                            		    	validateVcgFields( function ( message ) {
                            		    		var validationNotice = A.one ('#_validationResult');
                           			    		if ( message.length > 0 ){
                           		    				var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
                           		    				validationNotice.html(msg);
                           		    				//modal.footerNode.insert(validationNotice);
                           				    		return false;	
                           			    		}
                           			    		window.escapePrevent();
				                            	A.one('#<portlet:namespace/>sign_fm').submit();	
                            		    	}, '#modalUpdateVcg');
			                             }
			                           }
			                         }
			                    ]);
		    
			
				
		<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "UPDATE_ACTIVE_VCG_CG_FNAME") || permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "UPDATE_PRIMARY_INSURANCE") }' >
		
			var editVcg = function( event ) {
				    	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadVcgEntry" /><portlet:param name="page" value="editVcgEntry"/></portlet:resourceURL>', 'html', 
									{ persnId: event.currentTarget.ancestor('.vcg-entry-menu').attr('id'),
				    	  				vcgId: '${vcg.vcgId}'
									},
									function( data ){
										overwrite( A.one( '#edit_vcg_entry' ), data );
										
										modal.footerNode.all('.portlet-msg-alert').each( function (msg){
											msg.hide();	
										});
										modal.headerNode.one('h4').html('<liferay-ui:message key="update-vcg-entry-header" />');
										modal.render();
							        	modal.show();
							        	window.enforceFormats();
							        	modal.footerNode.insert(A.one ('#_validationResult'));
							        	try{
								        	A.one(".btn-link.short-facility-list.btn-primary.facil-magnet").setStyle('margin-top', '-30px');
							        	} catch(e){}
									} 
							);
					};
				
				<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "UPDATE_PRIMARY_INSURANCE") }' >
					A.all('.edit-primary').on( 'click', editVcg );
				</c:if>
					
				<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "UPDATE_ACTIVE_VCG_CG_FNAME") }' >
					A.all('.edit-vcg-entry').on( 'click', editVcg );
				</c:if>
		</c:if>
				 
				 
			<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "DISPOSITION_VCG") }' >
			A.all('.edit-disposition').on(
				      'click',
				      function( event ) {
				    	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadDisposition" /><portlet:param name="page" value="editDisposition"/></portlet:resourceURL>', 'html', 
									{ persnId: event.currentTarget.ancestor('.vcg-entry-menu').attr('id'),
										MODE: 1,
				    	  				vcgId: '${vcg.vcgId}'
									},
									function( data ){
										overwrite( A.one( '#edit_vcg_entry' ), data );
										
										modal.footerNode.all('.portlet-msg-alert').each( function (msg){
											msg.hide();	
										});
										modal.headerNode.one('h4').html("Process Disposition");
										modal.render();
							        	modal.show();
							        	window.enforceFormats();
							        	modal.footerNode.insert(A.one ('#_validationResult'));
									} 
							);
				     }
				 );
				</c:if>
				
				<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "SET_GENERAL_CG") }' >
				A.all('.create-vcg-entry').on(
				    'click',
				    function( event ) {
				    	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadGeneral" /><portlet:param name="page" value="editGeneral"/><portlet:param name="strip" value="0"/></portlet:resourceURL>', 'html', 
									{ 
				    	  				vcgId: '${vcg.vcgId}',
				    	  				MODE: 3
									},
									function( data ){
										overwrite( A.one( '#edit_vcg_entry' ), data );
										
										modal.footerNode.all('.portlet-msg-alert').each( function (msg){
											msg.hide();	
										});
										modal.render();
							        	modal.show();
							        	window.enforceFormats();
							        	modal.footerNode.insert(A.one ('#_validationResult'));
									} 
							);
				    });
				   </c:if>

			<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "UPDATE_TIER_LEVEL") }' >
				A.all('.edit-tier').on(
				      'click',
				      function( event ) {
				    	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadTier" /><portlet:param name="page" value="editTier"/></portlet:resourceURL>', 'html', 
									{ persnId: event.currentTarget.ancestor('.vcg-entry-menu').attr('id'),
				    	  				vcgId: '${vcg.vcgId}',
				    	  				MODE: 2
									},
									function( data ){
										overwrite( A.one( '#edit_vcg_entry' ), data );
										
										modal.footerNode.all('.portlet-msg-alert').each( function (msg){
											msg.hide();	
										});
										modal.render();
							        	modal.show();
							        	window.enforceFormats();
							        	modal.footerNode.insert(A.one ('#_validationResult'));
									} 
							);
				     }
				 );
			</c:if>
			
			
			var modalH = new A.Modal({
				headerContent: '<h4><liferay-ui:message key="audit-vcg-entry-header" /></h4>',
		        bodyContent: A.one("#audit_vcg_entry"),
		        centered: true,
		        destroyOnHide: false,
		        modal: true,
		        render: '#modalAuditVcg',
		        resizable: {
		          handles: 'b, r'
		        },
		        visible: false,
		        width: 1000
		    });
			
			A.all('.audit-vcg-entry').on(
				      'click',
				      function( event ) {
				    	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="persnAudit"/></portlet:resourceURL>', 'html', 
									{ classPk: event.currentTarget.ancestor('.vcg-entry-menu').attr('id'),
				    	  				vcgId: '${vcg.vcgId}'
									},
									function( data ){
										overwrite( A.one( '#audit_vcg_entry' ), data );
										modalH.render();
										modalH.show();
									} 
							);
				     }
				 );
			
			var modalEligibility = new A.Modal({
				headerContent: '<h4><liferay-ui:message key="eligibility-header" /></h4>',
		        bodyContent: A.one("#eligibility_entry"),
		        centered: true,
		        destroyOnHide: false,
		        modal: true,
		        render: '#modalEligibility',
		        resizable: {
		          handles: 'b, r'
		        },
		        visible: false,
		        width: 750
		    });
			

			window.loadEligibilityFromCaret = function() {
				var icn = A.one ('#<portlet:namespace/>icn').val();
				window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadEligibilityFromCaret" /><portlet:param name="page" value="eeHistory"/></portlet:resourceURL>', 'html', 
						{ icn : icn },
						function( data ){
							overwrite( A.one( '#eligibility_entry' ), data );
							modalEligibility.render();
							modalEligibility.show();
						} 
				);
			}

			window.loadEligibilityFromEE = function( icn ) {
				setTimeout(function(){modalEligibility.modal('hide')}, 10)
				window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="getEligibilityFromEandE" /><portlet:param name="page" value="eeHistory"/></portlet:resourceURL>', 'html', 
			                 { icn : icn
			                 },
			                 function( data ){
			                	 overwrite( A.one( '#eligibility_entry' ), data );
			                 	setTimeout(function(){modalEligibility.modal('show')}, 900)
			                 } 
			          );     
			}

			
			var needServiceCall = false;
			
			var validateVcgFields = function ( anotherCallback, parentNode ){
				  
				  var count = 0;
				  parentNode = parentNode || '';
		  		  var inputNodes = A.all( parentNode + ' .required-input input, ' 
				  				+ parentNode + ' .required-input radio, ' 
				  				+ parentNode + ' .required-input textarea, ' 
				  				+ parentNode + ' .required-input select');
				  var fields = "";
				  for ( var i = 0; i < inputNodes.size() ; i++ ){
					  var node = A.one(inputNodes._nodes[i]);
					  if (node == undefined  || node.attr('disabled') == true ) continue;
						if ( 'select-one' == node.attr('type') ){
			    			if ( node.val() == "" || node.val() == "0" ){
			    				 node.addClass( 'missing-required-input' );
			    				 fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" is required</li>";
			    				 count++;
			    			} else {
			    				if ( node.hasClass('missing-required-input') ){
			    					node.removeClass( 'missing-required-input' );
			    				}
			    			}
			    		}
						if ( 'text' == node.attr('type') || 'textarea' == node.attr('type') ){
							if ( node.val() == ""   
								|| ( node.hasClass('date-field') && node.val() == 'MM/DD/YYYY' )
								|| ( node.hasClass('ssn-field') && node.val() == '###-##-####' )
								|| ( node.hasClass('email-field') && node.val() == '[USERNAME]@[DOMAIN]' )
								|| ( node.hasClass('phone-field') && node.val() == '(###) ###-####' ) ){
			   					node.addClass( 'missing-required-input' );
			   					var custom = node.ancestorsByClassName("required-input")._nodes[0].getAttribute('data-custom-message');
			   					if ( custom ) {
			   						fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim() + ": " + custom + "</li>"; 
			   					} else {
			   						fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" is required</li>";
			   					}
			   					count++;
				   			} else {
				   				if ( node.hasClass('missing-required-input') ){
				   					node.removeClass( 'missing-required-input' );
				   				}
				   				if ( node.hasClass ('not-future') ){
				   					var parts = (""+node.val()).replace(/\W/g, '').match(/^(\d{2})(\d{2})(\d{4})$/);
				   					
				   					if ( parts ){
										  var input = new Date ( parseInt ( parts[3], 10 ), (parseInt ( parts[1], 10 ) -1), parts[2] );
										  var future = new Date ();
										  if ( input > future ){
											  fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" cannot be in future</li>";
										  }

									  }
				   				}
				   				if ( node.hasClass ('after-status-date') ) {
				   					
				   					var statusDate = node.ancestorsByClassName("required-input")._nodes[0].getAttribute('data-statusDate');
				   					//var statusDate = A.one('#statusDate').val();
				   					
				   					var appRc = (""+statusDate).replace(/\W/g, '').match(/^(\d{2})(\d{2})(\d{4})$/);
				   					var parts = (""+node.val()).replace(/\W/g, '').match(/^(\d{2})(\d{2})(\d{4})$/);
				   					if ( parts && appRc ){
										  var input = new Date ( parseInt ( parts[3], 10 ), (parseInt ( parts[1], 10 ) -1), parts[2] );
										  var recvd = new Date ( parseInt ( appRc[3], 10 ), (parseInt ( appRc[1], 10 ) -1), appRc[2] );
										  if ( recvd > input ){
											  fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" cannot be before " + statusDate + "</li>";
										  }
									}
				   				}
				   				if ( node.hasClass ('not-max-date') ){
				   					var maxDate = node.ancestorsByClassName("required-input")._nodes[0].getAttribute('data-maxDate');
				   					
				   					var max = (""+maxDate).replace(/\W/g, '').match(/^(\d{2})(\d{2})(\d{4})$/);
				   					var parts = (""+node.val()).replace(/\W/g, '').match(/^(\d{2})(\d{2})(\d{4})$/);
				   					if ( parts && max ){
										  var input = new Date ( parseInt ( parts[3], 10 ), (parseInt ( parts[1], 10 ) -1), parts[2] );
										  var beyVal = new Date ( parseInt ( max[3], 10 ), (parseInt ( max[1], 10 ) -1), max[2] );
										  if ( beyVal < input ){
											  fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" cannot be after " + maxDate + "</li>";
										  }
									}
				   				}
				   				
							}
				    	}
				    }
				    anotherCallback( fields );
			  }
			
			window.addNote = function(src) {
		modalAddNote.render();
		modalAddNote.show();
	}

	var modalAddNote = new A.Modal(
			{
				headerContent : '<h4><liferay-ui:message key="vcg-add-note" /></h4>',
				bodyContent : A.one("#addVcgNote"),
				centered : true,
				destroyOnHide : false,
				modal : true,
				render : '#modalCreateNote',
				resizable : {
					handles : 'b, r'
				},
				visible : false,
				width : 650
			});

	modalAddNote.addToolbar([ {
		label : 'Cancel',
		on : {
			click : function() {
				modalAddNote.hide();
			}
		}
	}, {
		label : 'Update',
		on : {
			click : function() {
				var note = A.one('#<portlet:namespace/>addNode_comments').val();
				if ( note != "" ){ 
				  validateVcgFields( function ( message ) {
		    		var validationNotice = A.one ('#_validationResult');
			    		if ( message.length > 0 ){
		    				var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
		    				validationNotice.html(msg);
		    				modalAddNote.footerNode.insert(validationNotice);
				    		return false;	
			    		}
			    		loadNotes( note );
			    		modalAddNote.hide();
		    	  }, '#addVcgNote');
		    	}
			}
		}
	} ]);
			
			
	</aui:script>
	
	<aui:script use="aui-base,aui-toggler,anim">
	
	var isExpanded = 10;
	if ( false | ${showAssessments eq true} ){
		isExpanded = 3;
		console.log('expanded == 3');
	}
	
	for ( i = 0 ; i < 9; i++ ){
	    new A.TogglerDelegate(
	      {
	        animated: true,
	        container: '#sectionCollapse' + i ,
	        content: '.content',
	        header: '.header',
	        transition: {
	          duration: 0.2,
	          easing: 'cubic-bezier(0, 0.1, 0, 1)'
	        }
	      }
	    );
	}
	
	
//	if ( false | ${showAssessments eq true} )
//	{
//		A.on('domready', function(event){
//			try{
//				window.<portlet:namespace />toggler.createAll();
//				window.<portlet:namespace />toggler.items[0].collapse();
//				window.<portlet:namespace />toggler.items[1].collapse();
//				window.<portlet:namespace />toggler.items[2].collapse();
//			}catch(e){}
//		});

//	}	
	
	

	

	
	 window.modalAssmtDataValidation = new A.Modal({
		    headerContent: '<h4><liferay-ui:message key="data-validation-header" /> </h4>',
		    bodyContent: A.one("#assmtValidationDiv"),
		    centered: true,
		    destroyOnHide: false,
		    modal: true,
		    render: '#assmtValidationModal',
		    resizable: {
		      handles: 'b, r'
		    },
		    visible: false,
		    width: 600
	});
	
	<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "TRACK_ASSESSMENT") }' >
	
	A.all('.save-assessment').on('click',function( event ) {
		var message = "";		
		var vcgId = '${vcg.vcgId}';
	 	var id = event.currentTarget.attr('id');	 	
	 	var idStr = id.substring(5);   
	 	var type = "";
		var assessmentId = "";		
		var completionDate = "";
		var comment = "";
		var caregiverId = "";		
		var assmtMode = "";				
		var assmt = "";
		var futureCompletionDate = "";
		
		if(idStr=="primaryClinical" || idStr=="primaryAssessment" || idStr=="primaryTraining" || idStr=="primaryInHome" 
			|| idStr=="secondaryClinical" || idStr=="secondaryAssessment" || idStr=="secondaryTraining" 
			|| idStr=="secondaryTwoClinical" || idStr=="secondaryTwoAssessment" || idStr=="secondaryTwoTraining")
		{	
			assmt="initial";
		}else{
			assmt="periodic";
		}
		
		if(assmt=="initial")
		{
		 	type = id.substring(5);
			assessmentId = A.one('#'+type+'_assessmentId').val();		
			completionDate = A.one('#<portlet:namespace/>'+type+'_completionDate').val();
			comment = A.one('#<portlet:namespace/>'+type+'_comment').val();
			caregiverId = A.one('#'+type+'_caregiverId').val();
		}else 
		{
			assessmentId = id.substring(5);
		 	type = A.one('#'+assessmentId+'_type').val();		
			completionDate = A.one('#<portlet:namespace/>'+assessmentId+'_completionDate').val();
			comment = A.one('#<portlet:namespace/>'+assessmentId+'_comment').val();
			caregiverId = A.one('#'+assessmentId+'_caregiverId').val();		
			assmtMode = A.one('#<portlet:namespace/>'+assessmentId+'_mode').val();				
		}		
		
		/*
		var typeList = [ "primaryClinical", "primaryAssessment", "primaryTraining", "primaryInHome", "secondaryClinical", "secondaryAssessment", "secondaryTraining", "secondaryTwoClinical", "secondaryTwoAssessment", "secondaryTwoTraining", "quarter1", "quarter2", "quarter3", "annual" ]
		var arrayLength = typeList.length;
		
		for (var i = 0; i < arrayLength; i++) {
		
			if( A.one('#<portlet:namespace/>'+typeList[i]+'_completionDate')!=null){
			    A.one('#<portlet:namespace/>'+typeList[i]+'_completionDate').removeClass( 'missing-required-input' );
			}		
		}
		*/
		
		var elements = document.getElementsByClassName('missing-required-input');
		while(elements.length > 0){
		    elements[0].classList.remove('missing-required-input');
		}
				
		if(assmt=="periodic" && assmtMode && assmtMode=="Not completed"){
			//console.log("assmt mode for periodic assmt is not completed..do not validate completion date");
			completionDate=='';
		}else if(!completionDate || completionDate=='MM/DD/YYYY'){
			message = "<li>Completion Date is required</li>";
			if(assmt=="initial"){
				A.one('#<portlet:namespace/>'+type+'_completionDate').addClass( 'missing-required-input' );
			}else if(assmt=="periodic"){
				A.one('#<portlet:namespace/>'+assessmentId+'_completionDate').addClass( 'missing-required-input' );
			}
		}else {
			var inputDate = new Date(completionDate);
			var todaysDate = new Date();

			if(inputDate.setHours(0,0,0,0) > todaysDate.setHours(0,0,0,0)) {
				message = message + "<li>Completion Date cannot be a future date.</li>";
				if(assmt=="initial"){
					A.one('#<portlet:namespace/>'+type+'_completionDate').addClass( 'missing-required-input' );
				}else if(assmt=="periodic"){
					A.one('#<portlet:namespace/>'+assessmentId+'_completionDate').addClass( 'missing-required-input' );
					futureCompletionDate = "yes";
				}				
			}
		}	

		if(type == 'primaryAssessment'){
			var completionDateCompare = new Date(completionDate);
			var appReceiveDate = new Date('${primaryValidAppDate}');
			
			if(completionDateCompare.valueOf() < appReceiveDate.valueOf()){
				message = message + "<li>Caregiver Assessment date cannot be before the Valid Application Received Date</li>";
				A.one('#<portlet:namespace/>primaryAssessment_completionDate').addClass( 'missing-required-input' );
			}
		}
		
		if(type == 'secondaryAssessment'){
			var completionDateCompare = new Date(completionDate);
			var appReceiveDate = new Date('${secondaryValidAppDate}');
			
			if(completionDateCompare.valueOf() < appReceiveDate.valueOf()){
				message = message + "<li>Secondary Caregiver Assessment date cannot be before the Valid Application Received Date</li>";
				A.one('#<portlet:namespace/>secondaryAssessment_completionDate').addClass( 'missing-required-input' );
			}
		}

		if(type == 'secondaryTwoAssessment'){
			var completionDateCompare = new Date(completionDate);
			var appReceiveDate = new Date('${secondaryTwoValidAppDate}');
			
			if(completionDateCompare.valueOf() < appReceiveDate.valueOf()){
				message = message + "<li>Secondary Two Caregiver Assessment date cannot be before the Valid Application Received Date</li>";
				A.one('#<portlet:namespace/>secondaryTwoAssessment_completionDate').addClass( 'missing-required-input' );
			}			
		}
		
		
		
		//NOTE : check periodic note - if completion date is more than 45 days from schedule date, then note is required
		
		//if(type == 'quarter1' || type=='quarter2' || type=='quarter3' || type=='annual')
		if(assmt=="periodic")
		{
			if(!assmtMode)
			{
				message = message + "<li>Mode of Assessment is required</li>";
				A.one('#<portlet:namespace/>'+assessmentId+'_mode').addClass( 'missing-required-input' );	
			}
			
			var scheduleDate = A.one('#'+assessmentId+'_scheduleDate').val();				
			var scheduleDateCompare = new Date(scheduleDate);
			var completionDateCompare = new Date(completionDate);
			var interval = ((completionDateCompare - scheduleDateCompare)/(24*60*60*1000));
			if(interval>61 || interval<-61){
				message = message + "<li>Completion date entered is not in the range for assessment compliance</li>";
				A.one('#<portlet:namespace/>'+assessmentId+'_completionDate').addClass( 'missing-required-input' );
			}else if(!comment && !futureCompletionDate && (interval>45 || interval<-45)){
				message = message + "<li>Comment is required</li>";
				A.one('#<portlet:namespace/>'+assessmentId+'_comment').addClass( 'missing-required-input' );
			}	
		}
		
		//alert("completion date is : "+completionDate);
			
		if ( message.length > 0 ){
			modalAssmtDataValidation.render();
			modalAssmtDataValidation.show();
			var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
			A.one ('#assmtValidationResult').html(msg);
		}else{
			window.caretIo( '<portlet:resourceURL><portlet:param name="javax.portlet.action" value="doAction"/><portlet:param name="action" value="saveAssessment"/></portlet:resourceURL>', 'json',
		    {
				vcgId:'${vcg.vcgId}',
				groupId:'${vcg.groupId}',
				type: type,
				//assessmentId: A.one('#'+type+'_assessmentId').val(),
				assessmentId: assessmentId,
				//completionDate: A.one('#<portlet:namespace/>'+type+'_completionDate').val(),
				//comment: A.one('#<portlet:namespace/>'+type+'_comment').val(),
				//caregiverId: A.one('#'+type+'_caregiverId').val(),
				completionDate:completionDate,
				comment:comment,
				caregiverId:caregiverId,
				veteranId: '${veteranId}',
				assmtMode: assmtMode
	        },
	        function( data ) {
	    	   	var assessmentId = data.assessmentId;
	    	   	
	    	   	if(assmt=="initial")
	    	   	{
		    	   	A.one('#'+type+'_assessmentId').attr('value',assessmentId);
		    	   	A.one('#<portlet:namespace/>'+type+'_completionDate').attr('disabled',true);
		    	   	A.one('#<portlet:namespace/>'+type+'_comment').attr('disabled',true);
	
		    	   	document.getElementById('edit_'+type).style.display = '';
		    	   	document.getElementById('save_'+type).style.display = 'none';
		    	   	
		    	   	A.one('.history_div_'+type).attr('id',assessmentId);
	    	   	}else if(assmt=="periodic")
	    	   	{
		    	   	A.one('#<portlet:namespace/>'+assessmentId+'_completionDate').attr('disabled',true);
		    	   	A.one('#<portlet:namespace/>'+assessmentId+'_comment').attr('disabled',true);
		    	   	A.one('#<portlet:namespace/>'+assessmentId+'_mode').attr('disabled',true);
		
		    	   	document.getElementById('edit_'+assessmentId).style.display = '';
		    	   	document.getElementById('save_'+assessmentId).style.display = 'none';
		    	   	
		    	   	//do this only when a new assessment is added
		    	   	if(data.assessmentStatus=="created")
		    	   	{		 
		    	   		window.escapePrevent();   	   	
		    	   		A.one('#<portlet:namespace/>reload_fm').submit();	
		    	   	}
	    	   	}
	       	});
		}
	});
	
	
	
	
	A.all('.edit-assessment').on('click',function( event ) {
		var id = event.currentTarget.attr('id');	 	   
	 	var type = id.substring(5);

		A.one('#<portlet:namespace/>'+type+'_completionDate').attr('disabled',false);
	   	A.one('#<portlet:namespace/>'+type+'_comment').attr('disabled',false);	  
	   	document.getElementById('save_'+type).style.display = '';
	    document.getElementById('edit_'+type).style.display = 'none';
	});
	
	
	A.all('.edit-per-assessment').on('click',function( event ) {
		var id = event.currentTarget.attr('id');	 	   
	 	var assmtId = id.substring(5);

		A.one('#<portlet:namespace/>'+assmtId+'_completionDate').attr('disabled',false);
		if(A.one('#<portlet:namespace/>'+assmtId+'_mode')!=null && A.one('#<portlet:namespace/>'+assmtId+'_mode').val()=="Not completed"){
			A.one('#<portlet:namespace/>'+assmtId+'_completionDate').attr('disabled',true);
		}		
	   	A.one('#<portlet:namespace/>'+assmtId+'_comment').attr('disabled',false);	  
	   	
  		if(A.one('#<portlet:namespace/>'+assmtId+'_mode')!=null){
   	   		A.one('#<portlet:namespace/>'+assmtId+'_mode').attr('disabled',false);
   	   	}
	   	
	   	document.getElementById('save_'+assmtId).style.display = '';
	    document.getElementById('edit_'+assmtId).style.display = 'none';
	});
	
	</c:if>
	
	 var modalAssmtHistory = new A.Modal({
		headerContent: '<h4><liferay-ui:message key="assmt-audit-header" /></h4>',
        bodyContent: A.one("#assmtHistoryDiv"),
        centered: true,
        destroyOnHide: false,
        modal: true,
        render: '#assmtHistoryModal',
        resizable: {
          handles: 'b, r'
        },
        visible: false,
        width: 1000
    });
	
	A.all('.assessment-history').on('click', function( event ) {
  	 	var id = event.currentTarget.attr('id');	 	   
		//var id = event.currentTarget.ancestor('.history-div').attr('id');
		//console.log("assessment id from div is : "+ id);
		
   	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="assmtAudit"/></portlet:resourceURL>', 'html', 
			{ 
	   	  		assmtId: id
	 		},
			function( data )
			{
				overwrite( A.one( '#assmtHistoryResult' ), data );
				modalAssmtHistory.render();
				modalAssmtHistory.show();
			}  		
		);
	});

	
	A.all('.assessment-history-all').on('click', function( event ) {
   	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="assmtAuditAll"/></portlet:resourceURL>', 'html', 
			{ 
   	  			vcgId:'${vcg.vcgId}'
	 		},
			function( data )
			{
				overwrite( A.one( '#assmtHistoryResult' ), data );
				modalAssmtHistory.render();
				modalAssmtHistory.show();
			}  		
		);
	});
	
	
	A.all('.ongoing-assmt-history-all').on('click', function( event ) {
  	 	var id = event.currentTarget.attr('id');	 	   
		
   	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="assmtAuditPeriodicAll"/></portlet:resourceURL>', 'html', 
			{ 
   	  			vcgId:'${vcg.vcgId}'
	 		},
			function( data )
			{
				overwrite( A.one( '#assmtHistoryResult' ), data );
				modalAssmtHistory.render();
				modalAssmtHistory.show();
			}  		
		);
	});
	
	A.all('.assmt-mode').on('change',function( event ) {
	
		var elements = document.getElementsByClassName('missing-required-input');
		while(elements.length > 0){
		    elements[0].classList.remove('missing-required-input');
		}
		
		//console.log("reached change mode");
		var id = event.currentTarget.attr('id');
		//console.log("id is : "+id);
		var assmtId = id.substring(0, id.indexOf('_'));
		//console.log("assmtId is : "+assmtId);
		
		var assmtMode = A.one('#<portlet:namespace/>'+assmtId+'_mode').val();
		//console.log("assmtMode is : "+assmtMode);
		
		if(assmtMode=="Not completed"){
			//console.log("assmtMode is not completed...disabling the completion date");
			var completionDate = A.one('#<portlet:namespace/>'+assmtId+'_completionDate').val();
			//console.log("completion date : "+completionDate);
			
			A.one('#<portlet:namespace/>'+assmtId+'_completionDate').attr('disabled',true);	
			A.one('#<portlet:namespace/>'+assmtId+'_completionDate').val("N/A");	
		}else{
			A.one('#<portlet:namespace/>'+assmtId+'_completionDate').attr('disabled',false);	
			A.one('#<portlet:namespace/>'+assmtId+'_completionDate').val("");			
		}	
	});
	

	var modalPeriodicAssmt = new A.Modal({
		headerContent: '<h4><liferay-ui:message key="periodic-assmt-header" /></h4>',
        bodyContent: A.one("#periodicAssmtDiv"),
        centered: true,
        destroyOnHide: false,
        modal: true,
        render: '#periodicAssmtModal',
        resizable: {
          handles: 'b, r'
        },
        visible: false,
        width: 1000
    });

<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "TRACK_ASSESSMENT") }' >
	A.all('.ongoing-assmt-all').on('click', function(event) {
  	  	window.caretIo('<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="periodicAssessmentsAll"/></portlet:resourceURL>', 'html', 
			{ 
   	  			vcgId:'${vcg.vcgId}',
   	  			primaryId:'${vcg.primaryId}'
	 		},
			function(data)
			{
				overwrite(A.one('#periodicAssmtAllResult'), data);
				modalPeriodicAssmt.render();
				modalPeriodicAssmt.show();
			}  		
		);
	});

</c:if>
		
<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "VIEW_DELETED_DOCS") }' >
	
	var deleteDocId = '';
	A.all('.delete-document').on('click', function( event ) 
	{
  	 	window.deleteDocId = event.currentTarget.attr('id');	 	   
		//console.log("document id from div is : "+ window.deleteDocId);
		
		A.one('#<portlet:namespace/>delete_doc_comment').html('');
		A.one('#<portlet:namespace/>delete_doc_comment').removeClass('missing-required-input');
		
		A.one('#deleteDocValidation').html('');
		document.getElementById('deleteDocValidation').style.display = 'none';
				 	  	
		modalDeleteDocument.render();
		modalDeleteDocument.show();		
	});
</c:if>

	window.modalDeleteDocument = new A.Modal({
	    headerContent: '<h4><liferay-ui:message key="delete-document" /> </h4>',
	    bodyContent: A.one("#deleteDocDiv"),
	    centered: true,
	    destroyOnHide: false,
	    modal: true,
	    render: '#deleteDocModal',
	    resizable: {
	      handles: 'b, r'
	    },
	    visible: false,
	    width: 800
	});
	 
	 modalDeleteDocument.addToolbar([
	   {
         label: 'Cancel',
         on: {
	            click: function() {
	            	window.deleteDocId = '';
	            	modalDeleteDocument.hide();
              	}
          }
	   },
	   {
          label: 'Delete',
          id: 'modalDelete',
          on: {
              click: function() {
              
              	//var id = event.currentTarget.attr('id');	 	   
				//console.log("again ... document id from div is : "+ window.deleteDocId);
				 
				var comment = A.one('#<portlet:namespace/>delete_doc_comment').val();
				//console.log("document delete comment is : "+ comment);
 
	            if (!comment){
	            	var txt = "Reason for Deletion is required";
					var msg = "<div class='portlet-msg-alert'>" + txt +"</div>";
	 				A.one('#<portlet:namespace/>delete_doc_comment').addClass( 'missing-required-input' );
	 				A.one ('#deleteDocValidation').html(msg);
	 				document.getElementById('deleteDocValidation').style.display = '';
	 				
	 				modalDeleteDocument.footerNode.insert(A.one ('#deleteDocValidation'));
	 				
	   				return false;	
	  			}
              
                         
            	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="deleteDocum"/></portlet:resourceURL>', 'json', 
				{ 
			   		documId: window.deleteDocId,
			   	  	deleteComment: comment
			 	},
				function( data )
				{
					document.getElementById('row_'+window.deleteDocId).style.display = 'none';
					window.deleteDocId = '';
					modalDeleteDocument.hide();
				} );
              }
          }
       }
	 ]);    
	 
	 var validateSupportingDocs = function ( anotherCallback, parentNode ){            
         var count = 0;
         parentNode = parentNode || '';
 		  var node = A.one(parentNode + ' .required-input select');
 		  
        // var inputNodes = A.all('.file-type .required-input select');
         var fields = "";
         //for ( var i = 1; i < inputNodes.size() ; i++ ){
               // var node = A.one(inputNodes._nodes[i]);
				 
                //if (node == undefined || node.attr('disabled') == true ) continue;
                if ( 'select-one' == node.attr('type') ) {
                      if ( node.val() == "" || node.val() == "0" ){
                             node.addClass( 'missing-required-input' );
                             fields = fields + "<li>" + 
                                    node.ancestorsByClassName('required-input').one('.control-label').text().trim()+
                                    " is required</li>";
                             count++;
                      } else {
                              if ( node.hasClass('missing-required-input') ){
                                     node.removeClass( 'missing-required-input' );
                              }
                      }
                      
                      if ( node.val() == "OTHER") {
                    	  var descriptionNode = A.one( parentNode + ' .required-input textarea');
                    	  //if (descriptionNode == undefined || node.attr('disabled') == true ) continue;
                    	  if ( descriptionNode.val() == ""){
                    		  descriptionNode.addClass( 'missing-required-input' );
                              ok = false;
                              fields = fields + "<li>" + 
                            		  descriptionNode.ancestorsByClassName('required-input').one('.control-label').text().trim()+
                                      " is required for OTHER File Types</li>";
                              count++;
                        } else if (descriptionNode.hasClass('missing-required-input') ){
                        	descriptionNode.removeClass( 'missing-required-input' );
                        }
                      }
                  }
               
         //}
         anotherCallback( fields );
  }
	 
	 var modalSupportingDocsAll = new A.Modal({
		headerContent: '<h4><liferay-ui:message key="sup-docs-header" /></h4>',
        bodyContent: A.one("#supportingDocsAllDiv"),
        centered: true,
        destroyOnHide: false,
        modal: true,
        render: '#supportingDocsAllModal',
        resizable: {
          handles: 'b, r'
        },
        visible: false,
        width: 1050
    });

	 modalSupportingDocsAll.addToolbar([
                       {
                         label: 'Cancel',
                         on: {
                           click: function() {
                    	   modalSupportingDocsAll.hide();
                           }
                         }
                       },{
                         label: 'Update',
                         on: {
                           click: function() {
                    	   
                    	   validateSupportingDocs( function ( message ) {
	           		    		var validationNotice = A.one ('#_validationResult');
	          			    		if ( message.length > 0 ){
	          		    				var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
	          		    				validationNotice.html(msg);
	          		    				//modal.footerNode.insert(validationNotice);
	          				    		return false;	
	          			    		}
	          			    		window.escapePrevent();
	                           	A.one('#<portlet:namespace/>saveVCGSupportingDocument').submit();	
	           		    		}, '#supportingDocsAllDiv');
                           }
                         }
                       }
                  ]);
	 A.all('.supporting-documents-all').on('click', function( event ) {
  	 	//var id = event.currentTarget.attr('id');	 	   
		//console.log("assessment id from div is : "+ id);
		
   	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadSupportingDocuments" /><portlet:param name="page" value="vcgSupportingDocsAll"/></portlet:resourceURL>', 'html', 
			{ 
   	  			vcgId:'${vcg.vcgId}'
	 		},
			function( data )
			{
				overwrite( A.one( '#supportingDocsAllResult' ), data );
				modalSupportingDocsAll.render();
				modalSupportingDocsAll.show();
	        	window.enforceFormats();
	        	modalSupportingDocsAll.footerNode.insert(A.one ('#_validationResult'));
			}  		
		);
	});
	
	var modalDocHistory = new A.Modal({
		headerContent: '<h4><liferay-ui:message key="doc-audit-header" /></h4>',
        bodyContent: A.one("#docHistoryDiv"),
        centered: true,
        destroyOnHide: false,
        modal: true,
        render: '#docHistoryModal',
        resizable: {
          handles: 'b, r'
        },
        visible: false,
        width: 1000
    });
	
	 
	 A.all('.supporting-documents-history').on('click', function( event ) {
  		
   	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="vcgDocsHistoryAll"/></portlet:resourceURL>', 'html', 
			{ 
   	  			vcgId:'${vcg.vcgId}'
	 		},
			function( data )
			{
				overwrite( A.one( '#docHistoryResult' ), data );
				modalDocHistory.render();
				modalDocHistory.show();
			}  		
		);
	});
	 
	var sectionElement = document.getElementById("section");
	var sectionVal = sectionElement.value;
	
	if(sectionVal=='assessment'){
 	 	document.getElementById("ongoingAssessments").scrollIntoView(true);
 	}
	
	</aui:script>

	<div class="yui3-skin-sam">
		<div id="assmtValidationModal"></div>
	</div>
	
	<div id="assmtValidationDiv" class="yui3-skin-sam">	
		<div id="assmtValidationResult"></div>
	</div>
	
	<div class="yui3-skin-sam">
	   	<div id="assmtHistoryModal"></div>
	</div>
	
	<div id="assmtHistoryDiv" class="yui3-skin-sam">	
		<div id="assmtHistoryResult"></div>
	</div>

	<div class="yui3-skin-sam">
	   	<div id="periodicAssmtModal"></div>
	</div>
	
	<div id="periodicAssmtDiv" class="yui3-skin-sam">	
		<div id="periodicAssmtAllResult"></div>
	</div>
	
	<div class="yui3-skin-sam">
		<div id="deleteDocModal"></div>
	</div>
	
	<div id="deleteDocDiv" class="yui3-skin-sam" >	
		<aui:field-wrapper inlineField="true" cssClass="manage-layout-wide-input">
			<aui:input label="delete-doc-comment" name="delete_doc_comment" type="textarea" size="80" id="delete_doc_comment"/>
		</aui:field-wrapper>
		<br/>
		Do you want to proceed and delete the document?
			
		<div id="deleteDocValidation" style="display:none;"><br/></div>
	</div>
	
	<div class="yui3-skin-sam">
	   	<div id="supportingDocsAllModal"></div>
	</div>
	
	<div id="supportingDocsAllDiv" class="yui3-skin-sam">	
		<div id="supportingDocsAllResult"></div>
	</div>
	
	<div class="yui3-skin-sam">
	   	<div id="docHistoryModal"></div>
	</div>
	
	<div id="docHistoryDiv" class="yui3-skin-sam">	
		<div id="docHistoryResult"></div>
	</div>
	
<portlet:actionURL var="loadEntry">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="loadEntry"/>
	<portlet:param name="entry" value="MANAGE_VCG"/>
	<portlet:param name="vcgId" value="${vcg.vcgId}"/>
	<portlet:param name="section" value="assessment"/>
</portlet:actionURL>

<aui:form name="reload_fm" method="post"  action="${loadEntry}"></aui:form>	
	
<%@include file="/jsp/internal/actionsSupport.jsp" %>		
<%@include file="/jsp/version.jsp" %>	
<%@include file="/jsp/im/compose.jsp" %>
	
