
<%@ include file="/jsp/init.jsp" %>	

<c:set var="form_" value="${caretMap_['form_']}" />

<c:set var="calcInfo" value="${workItem.calcInfo}" />
<c:set var="caregiver" value="${workItem.caregiver}" />
<c:set var="vcgSupport" value="${workItem.vcgSupport}" />
 

<div id="workTab">
  <ul class="nav nav-tabs">
    <li class="tab-click" ><a href="#tab-11"><div class="icon-bullhorn"></div> Summary </a></li>
    <li class="tab-click" ><a href="#tab-12"><div class="icon-user"></div> Information Change </a></li>
	<li class="tab-click" ><a href="#tab-13"><div class="icon-credit"></div>
    <c:choose>
    	<c:when test="${workItem.stiPtContext eq 'one-time'}" >Manual Payment Info</c:when>
    	<c:when test="${calcInfo.calculationWork}" >Auto Calculation</c:when>
    	<c:otherwise>History Log</c:otherwise>
    </c:choose>
	 </a></li>
    <li class="tab-click" ><a href="#tab-14"><div class="icon-edit"></div><liferay-ui:message key="review-work-notes" /></a></li>
  </ul>

  <div class="tab-content">
    <div id="tab-11" class="tab-pane">
		
		
		<div id="reviewOccWork2">
			<input type="hidden" value="${form_['statusDate']}" id="statusDate" />
			<input type="hidden" value="${form_['maxDate']}" id="maxDate" />
		
			<div class='portlet-msg-info' style="width:80%">(TBD) Top things to Highlight here...
				<div class="ten-ten-links" >
					<portlet:resourceURL var="getDocum">
						<portlet:param name="action" value="getDocum"/>
						<portlet:param name="classPk" value="${workItem.classPk}"/>
					</portlet:resourceURL>
			  		<a href="${getDocum}" tabindex="0"  target="_blank" class="tab-click btn icon-file stipend-row float-right" title='<liferay-ui:message key="pdf-10-10cg" />' >&nbsp;<liferay-ui:message key="pdf-10-10cg-review-message" /></a>
		  		</div>
		  	
		  
		  <ul>
			<fmt:formatDate value="${vcgSupport.primaryVcgAn.receivedDate}" var="appReceivedDate" type="date" pattern="MM/dd/yyyy"/>
			<fmt:formatDate value="${vcgSupport.primaryRevocationDate}" var="revocationDate" type="date" pattern="MM/dd/yyyy"/>
			<fmt:formatDate value="${vcgSupport.primaryDispositionDate}" var="dispositionDate" type="date" pattern="MM/dd/yyyy"/>
			<!-- 
			<li> Application Received Date: ${appReceivedDate}</li>
			-->
					<c:if test="${workItem.vendor.vendrId eq 0}">
						<span class="icon-bell" title="<liferay-ui:message key='usps-validated'/>" >&nbsp;</span>New Vendor Record &nbsp;
					</c:if>
					<li><liferay-ui:message key='cg-vendor' /> Name: ${caregiver.lastName}, ${caregiver.firstName} ${caregiver.middleName} &nbsp;</li>
					<li>SSN: ${caregiver.ssn} </li>
					<li><liferay-ui:message key='cg-vendor' /> Address:${caregiver.address} ${caregiver.address2}
					  <div style="margin-left:100px;" >
						<c:choose>
							<c:when test="${caregiver.validUspsAddress}">
								<span class="icon-star has-tooltip" title="<liferay-ui:message key='usps-validated'/>" >&nbsp;</span>
							</c:when>
							<c:otherwise>
								<span class="icon-flag" title="<liferay-ui:message key='non-usps-validated'/>" >&nbsp;</span>
							</c:otherwise>
						</c:choose>
							${caregiver.city}, ${caregiver.state} ${caregiver.zip}
					  </div>
					 </li>
					
					<li>${caregiver.insuranceInfo} </li>
					
					<c:if test="${form_['isViewMode']}">
						<li> Status: <liferay-ui:message key='${workItem.status}'/>
						</li>
					</c:if>
					
				</ul>
			</div><!-- end Top things to Highlight here... -->
			

		
		<div id="reviewMyWork">
				
			<c:choose>
			  <c:when test="${form_['isViewMode']}" >

			  	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" >
					<a class="btn" style="float:right; margin-left:30px; margin-bottom:-10px " href="javascript:manageOccWorkHide();" >&nbsp;<liferay-ui:message key="close" /></a>      			
				</aui:field-wrapper>
				
			  </c:when>
			  <c:otherwise>
				
				
				<input type="hidden" name="<portlet:namespace/>worImId" id="<portlet:namespace/>worImId16" value="${workItem.worImId}">
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="required-input float-left">
					<aui:select label="app-review-status" name="worIm_status" id="worIm_status" cssClass="srch-caret search-category"  >
							<aui:option value="0" label="please-select-review-condition" />
						<c:forEach var="reviewAction" items="${workItem.reviewActions}">
							<aui:option value="${reviewAction}" label="${reviewAction}" />
						</c:forEach>
					</aui:select>
				</aui:field-wrapper>
				<c:if test="${workItem.workType eq 'LOST_CHECK'}" >
					
					<fmt:formatNumber value="${workItem.stiPtContext.oneTimePayment}" var="reissueAmt" type="currency"/>
					
					<div class="reissue-section" id="reissueWrapper" >
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="float-left"  >
							 <aui:input name="reissueAmount" type="checkbox" id="manualPay" label="Reissue Payment of ${reissueAmt}" inlineField="true"   >
							</aui:input>
							
						</aui:field-wrapper>
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-vcg-medium-input required-input"  >
							<aui:input label="reissue-comments" name="reissue_comments" id="reissue_comments" size="50" type="textarea"  />
						</aui:field-wrapper>
					</div>
				</c:if>
				
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="required-input">
					<aui:select label="correction-type" name="worIm_correction" id="worIm_correction" cssClass="srch-caret search-category"  >
						<c:forEach var="correctionType" items="${caretMap_['correctionTypes']}">
							<aui:option value="${correctionType}" label="${correctionType}"  />
						</c:forEach>
					</aui:select>
				</aui:field-wrapper>
			  
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-vcg-medium-input"  >
					<aui:input label="comments" name="worIm_comments" id="worIm_comments" size="50" type="textarea"  />
				</aui:field-wrapper>
				
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" >
					<a class="btn btn-primary" style="float:right; margin-left:30px; margin-bottom:-10px " href="javascript:submitReview();" >&nbsp;<liferay-ui:message key="submit" /></a>      			
				</aui:field-wrapper>
				<div id="validationResult" ></div>
			  </c:otherwise>
			</c:choose>
			</div>
		</div><!-- end reviewOccWork2 -->
    </div> <!-- end tab-11 -->

    <div id="tab-12" class="tab-pane">
    	<%@include file="/jsp/internal/appInfo.jsp" %>
	</div>
	
	
	<div id="tab-13" class="tab-pane">
	  <c:choose>
    	<c:when test="${calcInfo.calculationWork}" >
    		<%@include file="/jsp/internal/autoCalc.jsp" %>
		</c:when>
    	<c:otherwise>
    		<%@include file="/jsp/internal/autoVcgChange.jsp" %>
    	</c:otherwise>
      </c:choose>
	</div>
	
	<div id="tab-14" class="tab-pane">
	  <div class="content" id="workNotes" >
		<div class="portlet-msg-info">
			<liferay-ui:message key="no-work-notes-found" />
		</div>
	  </div>
    	<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="manage-layout-medium-input ${cssClass}" >
 			<aui:input label="new-occ-work-note" name="addNode_comments2" id="addNode_comments2" size="50" type="textarea"  />
		</aui:field-wrapper>
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" >
			<a class="btn btn-primary" style="float:right;" href="javascript:loadWorkNotes();" >&nbsp;<liferay-ui:message key="Submit Note" /></a>      			
		</aui:field-wrapper>
    	
	</div><!-- end tab-14 -->
	
  </div><!-- end tab-context -->
</div><!-- workTab -->

	
<aui:script use="aui-tabview">

	window.loadWorkNotes = function (  ) {
		window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadWorkNotes" /><portlet:param name="page" value="workNotes" /><portlet:param name="classPk" value="${workItem.worImId}" /><portlet:param name="fromParameter" value="true" /></portlet:resourceURL>', 'html', 
			{ note: A.one('#<portlet:namespace/>addNode_comments2').val() },
			function( data ){ 
				overwrite( A.one( "#workNotes" ), data );
				A.one('#<portlet:namespace/>addNode_comments2').val("");
			} 
		);
	}
	
	<c:if test="${workItem.workType eq 'LOST_CHECK'}" >
				
				A.one('#<portlet:namespace />manualPayCheckbox').on('click', function(){
					if ( this.attr('checked') ){
						requireField( A.one('#<portlet:namespace />reissue_comments').ancestor('.field-wrapper') );
					} else {
						unrequireField( A.one('#<portlet:namespace />reissue_comments').ancestor('.field-wrapper') );
					}
				});
			</c:if>
	
	A.on('domready', loadWorkNotes );

  window.careTworkTab = new A.TabView({
      srcNode: '#workTab',
      type: 'pills',
      on: {
	            click: function() {
	            	//console.log('changed...' + this._getAttr('selection').get('index') );
	            	//console.log ( A.one('#modalOccWorkSubmitId') );
	            	//if ( this._getAttr('selection').get('index') == 0 ){
	            		//button says save Review
	            		//A.one('#modalOccWorkSubmitId').attr('childNodes').get(0)[0].attr('nodeValue', 'Submit Review');
	            	//} else if ( this._getAttr('selection').get('index') == 3 ){
	            		//button says save Note
	            		//A.one('#modalOccWorkSubmitId').attr('childNodes').get(0)[0].attr('nodeValue', 'Add Note');
	            	//} else {
	            		//A.one('#modalOccWorkSubmitId').attr('disabled', true);
	            	//}
	            	//console.log(A.one('#modalOccWorkSubmitId').attr('parentNode'));
              	}
          }
    }
  ).render();

	window.submitReview = function (){
		var erredOut = false;
		var msg = "";
		var field = A.one('#<portlet:namespace/>worIm_status');
		if ( field.val() == "0" ) {
			msg = "<li>&nbsp;<liferay-ui:message key='app-review-status' /></li>";
			erredOut = true;
			if ( !field.hasClass('missing-required-input') ){
             	field.addClass( 'missing-required-input' );
            }
		} else {
			if ( field.hasClass('missing-required-input') ){
             	field.removeClass( 'missing-required-input' );
            }
		}
		
	  <c:if test="${workItem.workType eq 'LOST_CHECK'}" >
		
		// A.one('#<portlet:namespace />manualPayCheckbox').attr('checked');
		var field2 = A.one('#<portlet:namespace/>reissue_comments');
		
		if ( A.one('#<portlet:namespace/>reissue_comments').ancestor('.field-wrapper').hasClass('required-input') ){
			if ( field2.val() == "" ) {
				msg =  msg + "<li>&nbsp;<liferay-ui:message key='reissue-comments' /></li>";
				erredOut = true;
				if ( !field2.hasClass('missing-required-input') ){
					field2.addClass( 'missing-required-input' );
				}
			} else {
				if ( field2.hasClass('missing-required-input') ){
					field2.removeClass( 'missing-required-input' );
				}
			}
		}
		
	  </c:if>
	  
	  	var validationNotice = A.one ('#validationResult');
   		if ( msg.length > 0 ){
 			var msg2 = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + msg +"</ul></div>";
 			validationNotice.html(msg2);
 			validationNotice.scrollIntoView();
    		return;	
   		}
		try{
			window.removeEventListener('beforeunload',preventUser);
		} catch(e){}
		overwrite( A.one( "#reviewMyWorkNode" ), A.one("#reviewMyWork") );
		A.one("#<portlet:namespace/>reviewMyWork_fm").submit();
	}
	
	
	window.submitReview0 = function (){
		validateFields( function ( message ) {
	   		var validationNotice = A.one ('#validationResult');
	   		if ( message.length > 0 ){
  				var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
  				validationNotice.html(msg);
  				validationNotice.scrollIntoView();
	    		return ;	
	   		}
			overwrite( A.one( "#modalVndrWk" ), A.one("#createVndrWk") );
			A.one("#<portlet:namespace/>createVndrWk_fm").submit();
		                 		    	}, '#createVndrWk');
	}
	
	var requireField = function( field ){
		if (field) {
			if ( !field.hasClass('required-input') ){
             	field.addClass( 'required-input' );
            }
	        field.show();
    	    field.attr('disabled', '');
        }
	}
	
	var unrequireField = function( field ){
		unrequireField( field, true );
	}
	var unrequireField = function( field, hideDisable ){
		if (field ) {
			if ( field.hasClass('required-input') ){
             	field.removeClass( 'required-input' );
            }
	        field.hide();
    	    field.attr('disabled', 'true');
        }
	}
	try {
		unrequireField( A.one('#<portlet:namespace/>worIm_correction').ancestor('.field-wrapper') );
		<c:if test="${workItem.workType eq 'LOST_CHECK'}" >
			requireField( A.one('#<portlet:namespace />worIm_comments').ancestor('.field-wrapper') );
			unrequireField( A.one('#<portlet:namespace />reissue_comments').ancestor('.field-wrapper') );
			A.one('#reissueWrapper').hide();
		</c:if>
	} catch(e){
		console.log( 'cannot unrequire worIm_correction' );
	}
	
	A.one('#<portlet:namespace/>worIm_status').on('change',
  		function(e) {
  			var selection = A.one('#<portlet:namespace/>worIm_status').val();
  			var correctionType = A.one('#<portlet:namespace/>worIm_correction').ancestor('.field-wrapper');
  			if ( selection.indexOf('CORRECTION_REQUEST') > 0 ){
  				requireField( correctionType );
  			} else {
  				unrequireField( correctionType );
  			}
  		<c:if test="${workItem.workType eq 'LOST_CHECK'}" >
  			var commentWrapper = A.one('#<portlet:namespace />reissue_comments').ancestor('.field-wrapper') ;
  			if ( selection.indexOf('LC_COMPLETE') >= 0 ){
  				A.one('#reissueWrapper').show();
  				if ( A.one('#<portlet:namespace />manualPayCheckbox').attr('checked') ){
						requireField( A.one('#<portlet:namespace />reissue_comments').ancestor('.field-wrapper') );
					} else {
						unrequireField( A.one('#<portlet:namespace />reissue_comments').ancestor('.field-wrapper') );
					}
  			} else {
  				unrequireField( commentWrapper, false );
  				A.one('#reissueWrapper').hide();
  			}
  		</c:if>	
    	}
	);
	
</aui:script>

		