
<%@ include file="/jsp/init.jsp" %>	

<c:set var="form_" value="${caretMap_['form_']}" />

<c:set var="payLog" value="${form_['payLog']}" /> 
<c:set var="workItem" value="${form_['workItem']}" /> 
<c:set var="calcInfo" value="${workItem.calcInfo}" />
<c:set var="veteran" value="${workItem.veteran}" /> 
<c:set var="vcgSupport" value="${workItem.vcgSupport}" /> 
<c:set var="caregiver" value="${workItem.caregiver}" /> 
<c:set var="stipendPaymentConfig" value="${calcInfo.stipendPaymentConfig}" /> 



<style>

.itemized-fract{
	font-size:1.5em;
}
</style>

<div id="${randomString}workTab">
  <ul class="nav nav-tabs">
	<li class="tab-click" ><a href="#tab-a1${randomString}"><div class="icon-bullhorn"></div> Create ${form_['workType']} </a></li>
    <li class="tab-click" ><a href="#tab-a2${randomString}"><div class="icon-user"></div> Additional Information </a></li>
     <li class="tab-click" ><a href="#tab-a3${randomString}"><div class="icon-credit"></div> Calculation Information </a></li>
  </ul>

  <div class="tab-content">
    
	
	
	<div id="tab-a1${randomString}" class="tab-pane">
	  	
	  	<div id="reviewOccWork2">
			<input type="hidden" value="${form_['statusDate']}" id="statusDate" />
			<input type="hidden" value="${form_['maxDate']}" id="maxDate" />
		
			<div class='portlet-msg-info' style="width:80%; margin-bottom:8px;" >(TBD) Top things to Highlight here....
				<div class="ten-ten-links" >
					<portlet:resourceURL var="getDocum">
						<portlet:param name="action" value="getDocum"/>
						<portlet:param name="classPk" value="${workItem.classPk}"/>
					</portlet:resourceURL>
			  		<a href="${getDocum}" tabindex="0"  target="_blank" class="tab-click btn icon-file stipend-row float-right" title='<liferay-ui:message key="pdf-10-10cg" />' >&nbsp;<liferay-ui:message key="pdf-10-10cg-review-message" /></a>
		  		</div>
		  	
		  
		  <ul>
			<fmt:formatDate value="${stipendPaymentConfig.stipendStartDate}" var="stipendStartDate" type="date" pattern="MM/dd/yyyy"/>
			<fmt:formatDate value="${stipendPaymentConfig.payslipDate}" var="payslipDate" type="date" pattern="MM/dd/yyyy"/>
		
			<fmt:formatDate value="${payLog.paymentDate}" var="paymentDate" type="date" pattern="MM/dd/yyyy"/>
			
		
		<c:if test="${! empty payLog}">
			<li> Timeframe of stipend payment: ${payLog.beginDateStr} to ${payLog.endDateStr} </li>
		
			<li> Check Submit Date: ${paymentDate}</li>
			
		</c:if>
			
					<li><liferay-ui:message key='cg-vendor' /> Name: ${caregiver.lastName}, ${caregiver.firstName} ${caregiver.middleName} &nbsp;</li>
					<li>SSN: ${caregiver.ssn} </li>
					<li> Recurring Payment Status: <liferay-ui:message key='${stipendPaymentConfig.stipendStatus}' /> </li>
			<c:if test="${! empty payLog}">
				<span class="icon-hand-right" title="FMS Payment Response: <liferay-ui:message key='${payLog.reason}' />" >&nbsp;</span>Stop Payment in FMS for <fmt:formatNumber value="${payLog.amount}" type="currency"/> &nbsp;
			</c:if>
					
				</ul>
			</div><!-- end Top things to Highlight here... -->
			
			<div class="clear-both" id="createVndrWk">
				<input type="hidden" name="<portlet:namespace/>worImId" id="<portlet:namespace/>worImId17" value="${workItem.worImId}">
				
				<input type="hidden" name="paymentLogId" value="${payLog.paymentLogId}" />
				<input type="hidden" value="${TRACKER}" name="TRACKER" />
				
				<c:choose>
					<c:when test="${form_['MODE'] eq \"Lost Check\" || form_['MODE'] eq \"Returned/Rejected Payment\" }">
						<input type="hidden" name="type" value="${form_['MODE']}" />
						<input type="hidden" name="cycleId" value="${payLog.cycleId}" />
						
						<div class="manage-layout float-left">
							<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="required-input float-left">
								<aui:select style="width:125px;" label="pay-period" name="config_cycle_month" id="config_cycle_month" disabled="${form_['disableDates']}"	>
									<aui:option value="" label="Please Select" selected="true" />
									<c:forEach var="month" items="${form_['MONTHS']}" varStatus="varStat" >
										<c:if test="${! empty month}" >
											<aui:option value="0${varStat.index}" label="${month}" selected="${month eq form_['MONTH']}" />
										</c:if>
									</c:forEach>
								</aui:select>
							</aui:field-wrapper>
							<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="required-input float-left">
								<aui:select style="width:80px;" label="" name="config_cycle_year" id="config_cycle_year" disabled="${form_['disableDates']}" >
									<c:forEach var="year" items="${form_['YEARS']}">
										<aui:option value="${year}" label="${year}" selected="${year eq form_['YEAR']}"  />
									</c:forEach>
								</aui:select>
							</aui:field-wrapper>
						</div>
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input float-left" data="${form_['restrictionDateData']}" >
							<aui:input label="${form_['MODE']} Event Date" name="checkDate" id="checkDate" cssClass="date-field not-future after-status-date" type="text" size="25" value=""  />
						</aui:field-wrapper>
						
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >
							<fmt:formatNumber value="${payLog.amount}" var="amount" type="currency"/>
							<aui:input label="Amount" name="checkAmount" class='money-field' id="${randomString}dollarAmount" type="text" size="25" value="${amount}" disabled="${form_['disableDates']}" />
						</aui:field-wrapper>
						
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >
							<aui:input label="Reference Number" name="checkNumber" id="${randomString}checkNumber" type="text" size="25" value="${payLog.paymentNumber}" disabled="${form_['disableDates']}" />
						</aui:field-wrapper>
						
					</c:when>
					
					<c:otherwise>
					
						<div class="manage-layout float-left">
							<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="required-input float-left">
								<aui:select style="width:125px;" label="pay-period" name="config_cycle_month" id="config_cycle_month" disabled="${form_['disableDates']}"	>
									<aui:option value="" label="Please Select" selected="true" />
									<c:forEach var="month" items="${form_['MONTHS']}" varStatus="varStat" >
										<c:if test="${! empty month}" >
											<aui:option value="0${varStat.index}" label="${month}" selected="${month eq form_['MONTH']}" />
										</c:if>
									</c:forEach>
								</aui:select>
							</aui:field-wrapper>
							<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="required-input float-left">
								<aui:select style="width:80px;" label="" name="config_cycle_year" id="config_cycle_year" disabled="${form_['disableDates']}" >
									<c:forEach var="year" items="${form_['YEARS']}">
										<aui:option value="${year}" label="${year}" selected="${year eq form_['YEAR']}"  />
									</c:forEach>
								</aui:select>
							</aui:field-wrapper>
						</div>
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input float-left" data="${form_['restrictionDateData']}" >
							<aui:input label="${form_['MODE']} Event Date" name="checkDate" id="checkDate" cssClass="date-field not-future after-status-date" type="text" size="25" value=""  />
						</aui:field-wrapper>
						
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >
							<fmt:formatNumber value="${payLog.amount}" var="amount" type="currency"/>
							<aui:input label="Amount" name="checkAmount" class='money-field' id="${randomString}dollarAmount" type="text" size="25" value="${amount}" disabled="${form_['disableDates']}" />
						</aui:field-wrapper>
					
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >
							<aui:input label="Reference Number" name="checkNumber" id="${randomString}checkNumber" type="text" size="25" value="${payLog.paymentNumber}" disabled="${form_['disableDates']}" />
						</aui:field-wrapper>
						
					</c:otherwise>
					
				</c:choose>
				
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-vcg-medium-input required-input"  >
					<aui:input label="Reason/Comments" name="worIm_comments" size="50" type="textarea"  />
				</aui:field-wrapper>

				
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" >
					<a class="btn btn-primary" style="float:right; margin-left:30px; margin-bottom:-10px" href="javascript:submitWorkItem();" >&nbsp;<liferay-ui:message key="new-work-item" /></a>      			
				</aui:field-wrapper>

				<div id="validationResult" ></div>

			</div>		
		</div>
	</div>
	  	
	<div id="tab-a2${randomString}" class="tab-pane">

		<div style="padding:2px;" id="${randomString}itemization0" tabindex="0" class="header toggler-header-collapsed" >
		
			<div class="work-section" >
				<div class="center-position">
					<div class="care-giver-name" id="update_veteran">
						<div class="selected-vcg">
					    		<div class="selected-info">
					    	 		<div class="selected-vcg-row">
					    	 			<div class="srow-label">
					    	 			Veteran Name:</div>${veteran.lastName}, ${veteran.firstName}
					    			</div>
					    			<div class="selected-vcg-row">
					    	 			<div class="srow-label">Facility:</div>${veteran.facilityName} 
					    			</div>
					    			<div class="selected-vcg-row">
					    	 			<div class="srow-label">SSN:</div>${veteran.ssn}
					    			</div>
					    			<div class="selected-vcg-row">
					    	 			<fmt:formatDate value="${veteran.birthDate}" var="vbday" type="date" pattern="MM/dd/yyyy"/>
					    	 			<div class="lrow-label">DOB:</div>${vbday}
					    			</div>
					    			<div class="selected-vcg-row">
					    	 			<div class="lrow-label">Application Id:</div>${workItem.applicationId}
					    			</div>
					    			<div class="selected-vcg-row">
					    				<div class="srow-label">Insurance at time of Payment:</div>${form_['insurance']}
					    			</div>
					    			
					    		</div>
					    	</div>
						</div>
					</div>
				</div>
				<div class="work-section" id="viewVendor" >	
					<%@include file="/jsp/internal/viewVendor.jsp" %>    	
				</div>
			</div>
		</div>
	
	
		<div id="tab-a3${randomString}" class="tab-pane">
	    	<div class="work-section manage-layout" >
				<div class="center-position">
					<div id="tier-info">
						<div class="selected-vcg">
				    		<div class="selected-info">
				    			<fmt:formatDate value="${vcgSupport.tierEffectiveDate}" var="tierEffectiveDate" type="date" pattern="MM/dd/yyyy"/>
				    			<fmt:formatDate value="${payLog.paymentDate}" var="paymentDate" type="date" pattern="MM/dd/yyyy"/>
				    		 
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">Tier Level:</div><liferay-ui:message key="tier-level-${vcgSupport.tierLevel}" />
				    			</div>
			    				<div class="my-shim"></div>
				    			<div class="selected-vcg-row">
				    				<div class="srow-label">Stipend Start Date:</div>${stipendStartDate}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="srow-label">Initial Payment Date:</div>${payslipDate}
				    			</div>
				    		  <c:if test="${! empty payLog}">
				    		  	
				    		  	
				    			<div class="selected-vcg-row">
				    				<div class="srow-label">Check Submit Date:</div>${paymentDate}
				    			</div>
				    			<div class="my-shim"></div>
				    			<div class="selected-vcg-row">
				    				<div class="srow-label">FMS Payment Response:</div> <liferay-ui:message key='${payLog.reason}' />
				    			</div>
				    		  </c:if>
				    		</div>
				    	</div>
					</div>	
				</div>
			</div>
			<div class="work-section" >	
				<div class="center-position">
					<div class="rate-info" id="update_primary">
						<div class="selected-vcg">
				    	 	<div class="selected-info">
				    	 		<div class="selected-vcg-row">
					    	 		<div class="srow-label">Zip:</div>${caregiver.zip} &nbsp;
					    	 	</div>
								<div class="selected-vcg-row has-tooltip" id="${randomString}itemization1" title="click-for-itemization" >
									<div class="header toggler-header-collapsed" >
										<div class="srow-label" >Monthly Rate: </div>
										<div class="float-left" ><fmt:formatNumber value="${calcInfo.monthlyRate}" type="currency"/>&nbsp; </div>
										<div class="icon-info-sign "></div> &nbsp;
									</div>
									<div class="content toggler-content-collapsed portlet-msg-info"  >
										<table class="itemized-table">
											<tr><th>[Monthly Rate] =</th>      <th>[Tier Monthly Hrs] x </th>  <th>[ZIP Hourly Wage]</th></tr>
											<tr><td>$${calcInfo.monthlyRate}</td><td>${stipendPaymentConfig.tierHours} </td>				  <td><fmt:formatNumber value="${calcInfo.hourlyRate}" type="currency"/></td></tr>
										</table>
										<table class="itemized-table">
											<tr><th>[Daily Rate] =</th>      <th>[Tier Monthly Hrs] &times; </th>  <th>[ZIP Hourly Wage] &times;</th><th class="itemized-fract">  <sup>12</sup>&frasl;<sub>365</sub> </th></tr>
											<tr><td>$${calcInfo.dailyRate}</td><td>${stipendPaymentConfig.tierHours} </td><td><fmt:formatNumber value="${calcInfo.hourlyRate}" type="currency"/></td><td class="itemized-fract"><sup>12</sup>&frasl;<sub>365</sub></td></tr>
										</table>
									</div>
								</div>
									
								<c:if test="${! empty payLog}">
									<div class="selected-vcg-row has-tooltip" id="${randomString}itemization2" title="click-for-itemization-of-retroactive-and-or-prorated" >
										<div class="header toggler-header-collapsed" >
											<div class="srow-label" >Back Pay: </div>
											<div class="float-left" >${(calcInfo.backPayAmount + calcInfo.proratedAmount)  gt 0 ? "YES": "NO"} &nbsp; </div>
											<div class="icon-info-sign "></div> &nbsp;
										</div>
										<div class="content toggler-content-collapsed"  >
											<div class="portlet-msg-info">
												<div class="itemized-data" >[# of Retro Months] = Number of Unpaid Full months after Tier Effective date(${tierEffectiveDate}) prior to Payment Month (${payLog.paymentMonth})
												</div>
												<table class="itemized-table">
													<tr><th>[Monthly Back Pay] =</th>      <th>[Monthly Rate] x </th>  <th>[# of Retro Months]</th></tr>
													<tr><td><fmt:formatNumber value="${calcInfo.backPayAmount}" type="currency"/></td><td>$${calcInfo.monthlyRate} </td><td> ${calcInfo.retroactiveMonths}</td></tr>
												</table>
												<div class="itemized-data" >[# of Retro Days] = Number of Partial-month days after Tier Effective date(${tierEffectiveDate}) prior to Payment Month (${payLog.paymentMonth})
												</div>
												<table class="itemized-table">
													<tr><th>[Prorated Amt] =</th>      <th>[Daily Rate] x </th>  <th>[# of Retro Days]</th></tr>
													<tr><td><fmt:formatNumber value="${calcInfo.proratedAmount}" type="currency"/></td><td><fmt:formatNumber value="${calcInfo.dailyRate}" type="currency"/> </td><td> ${calcInfo.totalDays}</td></tr>
												</table>
												<table class="itemized-table">
													<tr><th>[Back Pay] =</th>      <th>[Monthly Back Pay] + </th>  <th>[Prorated Amt]</th></tr>
													<tr><td><fmt:formatNumber value="${calcInfo.backPayAmount + calcInfo.proratedAmount}" type="currency"/></td><td><fmt:formatNumber value="${calcInfo.backPayAmount}" type="currency"/></td><td> <fmt:formatNumber value="${calcInfo.proratedAmount}" type="currency"/></td></tr>
												</table>
											</div>
										</div>
									</div>
						    		<div class="selected-vcg-row">
						    			<div class="srow-label">Back Pay Amount: </div><fmt:formatNumber value="${calcInfo.backPayAmount + calcInfo.proratedAmount}" type="currency"/>&nbsp;
						    		</div>
						    		
						    		<div class="selected-vcg-row">
						    			<div class="srow-label">Manual Payment(s): </div><fmt:formatNumber value="${form_['one-time']}" type="currency"/>&nbsp;
						    		</div>
		
					    			<div class="selected-vcg-row">
					    	 			<div class="srow-label">Total Payment Amount:</div><fmt:formatNumber value="${payLog.amount}" type="currency"/> &nbsp;
					    			</div>
								</c:if>	
					    	</div>
				    	</div>
					</div>
				</div>
			</div>
		</div>
			
  	</div><!-- end tab-context -->
</div><!-- workTab -->

	
<aui:script use="aui-tabview,node-event-simulate,aui-toggler,aui-tooltip">


   new A.TabView({
      srcNode: '#${randomString}workTab',
      type: 'pills'
    }
  ).render();

	window.submitWorkItem = function (){
		validateFields( function ( message ) {
	   		var validationNotice = A.one ('#validationResult');
	   		if ( message.length > 0 ){
  				var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
  				validationNotice.html(msg);
  				validationNotice.scrollIntoView();
	    		return false;	
	   		}
			overwrite( A.one( "#modalVndrWk" ), A.one("#createVndrWk") );
			A.one("#<portlet:namespace/>createVndrWk_fm").submit();
		                 		    	}, '#createVndrWk');
	}
	
	
	
		<c:if test="${! empty payLog}">
			new A.TogglerDelegate( {
				container: '#${randomString}itemization2',
				animated: true,
				content: '.content',
				expanded: false,
				header: '.header'
			  });
		</c:if>
			  
			  new A.TogglerDelegate( {
				container: '#${randomString}itemization1',
				animated: true,
				content: '.content',
				expanded: false,
				header: '.header'
			  });
	
	new A.TooltipDelegate( { trigger: '.has-tooltip' } );
	
	A.one('#<portlet:namespace />${randomString}checkNumber').on('change', window.numberFormat);
	A.one('#<portlet:namespace />${randomString}dollarAmount').on('change', window.dollarFormat);
	enforceFormats();
	
</aui:script>

		