
<%@ include file="/jsp/init.jsp" %>	

<c:set var="form_" value="${caretMap_['form_']}" />

<c:set var="payLog" value="${form_['payLog']}" /> 
<c:set var="workItem" value="${form_['workItem']}" /> 
<c:set var="calcInfo" value="${workItem.calcInfo}" />
<c:set var="caregiver" value="${workItem.caregiver}" /> 

<style>

.itemized-fract{
	font-size:1.5em;
}

.manage-layout label.checkbox {
    width: 350px;
}


</style>

<div id="${randomString}workTab">
  <ul class="nav nav-tabs">
	<li class="tab-click" ><a href="#tab${randomString}1"><div class="icon-bullhorn"></div> Create ${form_['workType']} </a></li>
    <li class="tab-click" ><a href="#tab${randomString}2"><div class="icon-user"></div> Additional Information </a></li>
     <li class="tab-click" ><a href="#tab${randomString}3"><div class="icon-credit"></div> Calculation Information </a></li>
  </ul>

  <div class="tab-content">
    
	
	
	<div id="tab${randomString}1" class="tab-pane">
	  	
	  	<div id="reviewOccWork2">
			<input type="hidden" value="${form_['statusDate']}" id="statusDate" />
			<input type="hidden" value="${form_['maxDate']}" id="maxDate" />
		
			<div class='portlet-msg-info' style="width:80%">(TBD) Top things to Highlight here...
				<div class="ten-ten-links" >
					<portlet:resourceURL var="getDocum">
						<portlet:param name="action" value="getDocum"/>
						<portlet:param name="classPk" value="${workItem.classPk}"/>
					</portlet:resourceURL>
			  		<a href="${getDocum}" tabindex="0"  target="_blank" class="tab-click btn icon-file stipend-row float-right" title='<liferay-ui:message key="pdf-10-10cg" />' >&nbsp;<liferay-ui:message key="pdf-10-10cg-review-message" /></a>
		  		</div>
		  	
		  
		  <ul>
			<fmt:formatDate value="${workItem.vcgSupport.primaryVcgAn.receivedDate}" var="appReceivedDate" type="date" pattern="MM/dd/yyyy"/>
			<fmt:formatDate value="${calcInfo.stipendPaymentConfig.stipendStartDate}" var="stipendStartDate" type="date" pattern="MM/dd/yyyy"/>
			<fmt:formatDate value="${calcInfo.stipendPaymentConfig.payslipDate}" var="payslipDate" type="date" pattern="MM/dd/yyyy"/>
		
			<fmt:formatDate value="${payLog.paymentDate}" var="paymentDate" type="date" pattern="MM/dd/yyyy"/>
			
			<c:if test="${! empty payLog}">
				<li> Last Check Submit Date: ${paymentDate}</li>
				<li> Last FMS Payment Response: <fmt:formatNumber value="${payLog.amount}" type="currency"/>, <liferay-ui:message key='${payLog.reason}' /> </li>
			</c:if>
			
					<li><liferay-ui:message key='cg-vendor' /> Name: ${caregiver.lastName}, ${caregiver.firstName} ${caregiver.middleName} &nbsp;</li>
					<li>SSN: ${caregiver.ssn} </li>
					<li>Other Insurance: ${caregiver.otherHealthInsurance} </li>
					
				</ul>
			</div><!-- end Top things to Highlight here... -->
			
			<div class="clear-both" id="createVndrWk">
				<input type="hidden" name="<portlet:namespace/>worImId" id="<portlet:namespace/>worImId17" value="${workItem.worImId}">
				
				<div class="my-shim"></div>
				<input type="hidden" name="paymentLogId" value="${payLog.paymentLogId}" />
				<input type="hidden" value="${TRACKER}" name="TRACKER" />
				
				<c:choose>
					
					<c:when test="${form_['MODE'] eq \"Hold Payments\"}">
						<input type="hidden" name="type" value="HELD_PAYMENT" />
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="required-input">
							<aui:select label="held-payment-reason" name="worIm_heldPaymentReason" id="worIm_heldPaymentReason" cssClass="srch-caret search-category"  >
								<c:forEach var="heldPaymentReason" items="${caretMap_['heldPaymentReasons']}">
									<aui:option value="${heldPaymentReason}" label="${heldPaymentReason}"  />
								</c:forEach>
							</aui:select>
						</aui:field-wrapper>
						 <aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout">
						 	<aui:input name="holdAllPayments" type="checkbox" label="hold-all-payments" inlineField="true"   >
								</aui:input>
						 </aui:field-wrapper>
					</c:when>
					
					
					<c:when test="${form_['MODE'] eq \"Recoupment\"}">
						<input type="hidden" name="type" value="RECOUPMENT" />
						
						<!-- 
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="required-input">
							<aui:select label="perform-recoupment" name="worIm_heldPaymentReason" id="worIm_heldPaymentReason" cssClass="srch-caret search-category"  >
									<aui:option value="yes" label="yes"  />
									<aui:option value="no" label="no"  />
							</aui:select>
						</aui:field-wrapper>
						-->
						
					</c:when>
					<c:when test="${form_['MODE'] eq \"Cancel Payment\"}">
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="required-input">
							<aui:select label="cancellation-reason" name="worIm_cancelReason" id="worIm_cancelReason" cssClass="srch-caret search-category"  >
									<aui:option value="va-error" label="va-error"  />
									<aui:option value="vendor-error" label="vendor-error"  />
									<aui:option value="cancel-other-reason" label="cancel-other-reason"  />
							</aui:select>
						</aui:field-wrapper>
					</c:when>
				</c:choose>
				
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="required-input manage-vcg-medium-input"  >
					<aui:input label="comments" name="worIm_comments" size="50" type="textarea"  />
				</aui:field-wrapper>

				
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" >
					<a class="btn btn-primary" style="float:right; margin-left:30px; margin-bottom:-10px" id="submitHoldWorkItem" >&nbsp;<liferay-ui:message key="submit" /></a>      			
				</aui:field-wrapper>

				<div id="validationResult" ></div>

			</div>		
		</div>
	</div>
	  	
	<div id="tab${randomString}2" class="tab-pane">

		<div style="padding:2px;" id="${randomString}itemization10" tabindex="0" class="header toggler-header-collapsed" >
		
			<div class="work-section" >
				<div class="center-position">
					<div class="care-giver-name" id="update_veteran">
						<div class="selected-vcg">
					    		<div class="selected-info">
					    	 		<div class="selected-vcg-row">
					    	 			<div class="srow-label">
					    	 			Veteran Name:</div>${workItem.veteran.lastName}, ${workItem.veteran.firstName}
					    			</div>
					    			<div class="selected-vcg-row">
					    	 			<div class="srow-label">Facility:</div>${workItem.veteran.facilityName} 
					    			</div>
					    			<div class="selected-vcg-row">
					    	 			<div class="srow-label">SSN:</div>${workItem.veteran.ssn}
					    			</div>
					    			<div class="selected-vcg-row">
					    	 			<fmt:formatDate value="${workItem.veteran.birthDate}" var="vbday" type="date" pattern="MM/dd/yyyy"/>
					    	 			<div class="lrow-label">DOB:</div>${vbday}
					    			</div>
					    			<div class="selected-vcg-row">
					    	 			<div class="lrow-label">Application Id:</div>${workItem.applicationId}
					    			</div>
					    		</div>
					    	</div>
						</div>
					</div>
				</div>
				<div class="work-section" id="viewVendor" >	
					<%@include file="/jsp/internal/viewVendor.jsp" %>    	
				</div>
			</div>
		</div>
	
	
		<div id="tab${randomString}3" class="tab-pane">
	    	<div class="work-section manage-layout" >
				<div class="center-position">
					<div id="tier-info">
						<div class="selected-vcg">
				    		<div class="selected-info">
				    			<fmt:formatDate value="${workItem.vcgSupport.tierEffectiveDate}" var="tierEffectiveDate" type="date" pattern="MM/dd/yyyy"/>
				    			<fmt:formatDate value="${payLog.paymentDate}" var="paymentDate" type="date" pattern="MM/dd/yyyy"/>
				    		 
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">Tier Level:</div><liferay-ui:message key="tier-level-${workItem.vcgSupport.tierLevel}" />
				    			</div>
			    				<div class="my-shim"></div>
				    			<div class="selected-vcg-row">
				    				<div class="srow-label">Stipend Start Date:</div>${stipendStartDate}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="srow-label">Initial Payment Date:</div>${payslipDate}
				    			</div>
				    		  <c:if test="${! empty payLog}">
				    			<div class="selected-vcg-row">
				    				<div class="srow-label">Check Submit Date:</div>${paymentDate}
				    			</div>
				    			<div class="my-shim"></div>
				    			<div class="selected-vcg-row">
				    				<div class="srow-label">FMS Payment Response:</div><fmt:formatNumber value="${payLog.amount}" type="currency"/>, <liferay-ui:message key='${payLog.reason}' />
				    			</div>
				    		  </c:if>
				    		</div>
				    	</div>
					</div>
				</div>
			</div>
			<div class="work-section" >	
				<div class="center-position">
					<div class="rate-info" id="update_primary">
						<div class="selected-vcg">
				    	 	<div class="selected-info">
				    	 		<div class="selected-vcg-row">
					    	 		<div class="srow-label">Zip:</div>${caregiver.zip} &nbsp;
					    	 	</div>
								<div class="selected-vcg-row has-tooltip" id="${randomString}itemization11" title="click-for-itemization" >
									<div class="header toggler-header-collapsed" >
										<div class="srow-label" >Monthly Rate: </div>
										<div class="float-left" ><fmt:formatNumber value="${calcInfo.monthlyRate}" type="currency" />&nbsp; </div>
										<div class="icon-info-sign "></div> &nbsp;
									</div>
									<div class="content toggler-content-collapsed portlet-msg-info"  >
										<table class="itemized-table">
											<tr><th>[Monthly Rate] =</th>      <th>[Tier Monthly Hrs] x </th>  <th>[ZIP Hourly Wage]</th></tr>
											<tr><td>$${calcInfo.monthlyRate}</td><td>${calcInfo.stipendPaymentConfig.tierHours} </td>				  <td> $${calcInfo.hourlyRate}</td></tr>
										</table>
										<table class="itemized-table">
											<tr><th>[Daily Rate] =</th>      <th>[Tier Monthly Hrs] &times; </th>  <th>[ZIP Hourly Wage] &times;</th><th class="itemized-fract">  <sup>12</sup>&frasl;<sub>365</sub> </th></tr>
											<tr><td>$${calcInfo.dailyRate}</td><td>${calcInfo.stipendPaymentConfig.tierHours} </td><td> $${calcInfo.hourlyRate}</td><td class="itemized-fract"><sup>12</sup>&frasl;<sub>365</sub></td></tr>
										</table>
									</div>
								</div>
							
					    	</div>
				    	</div>
					</div>
				</div>
			</div>
		</div>
			
  	</div><!-- end tab-context -->
</div><!-- workTab -->

	
<aui:script use="aui-tabview,node-event-simulate,aui-toggler,aui-tooltip">


  new A.TabView({
      srcNode: '#${randomString}workTab',
      type: 'pills'
    }
  ).render();

	A.one('#submitHoldWorkItem').on('click', function (){
		validateFields( function ( message ) {
		                 		    		var validationNotice = A.one ('#validationResult');
		                			    		if ( message.length > 0 ){
		                		    				var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
		                		    				validationNotice.html(msg);
		                				    		return false;	
		                			    		}
			overwrite( A.one( "#modalVndrWk" ), A.one("#createVndrWk") );
			A.one("#<portlet:namespace/>createVndrWk_fm").submit();
		                 		    	}, '#createVndrWk');
	} );
	
	
	
	for ( i = 1 ; i < 2; i++ ){
		new A.TogglerDelegate( {
				animated: true,
				container: '#${randomString}itemization1'+i ,
				content: '.content',
				expanded: false,
				header: '.header'
			  });
	}
	
	new A.TooltipDelegate( { trigger: '.has-tooltip' } );
	
	
</aui:script>

		