
<%@ include file="/jsp/init.jsp" %>

<c:set var="eeRecords" value="${eeRecords}" />
<c:set var="eeError" value="${eeError}" />

<div id="eligibility_entry1">
<portlet:resourceURL var="getEligibilityFromEandE">
<portlet:param name="action" value="getEligibilityFromEandE"/>
<portlet:param name="icn" value="${icn}"/>
<portlet:param name="page" value="eeHistory"/>
</portlet:resourceURL>
<div class="manage-layout" >
	<input type="hidden" id="<portlet:namespace/>icn" value="${icn}" >
	<a class="eligibility-frommodal btn-primary" title='<liferay-ui:message key="load-eligibility-tooltip" />'  >&nbsp;Retrieve E&amp;E</a>
</div>

<c:if test="${eeError eq 'true'}">
	<div class='portlet-msg-alert'>Cannot retrieve latest E&E data from E&E service</div>
</c:if>	

<c:choose>
<c:when test="${! empty eeRecords}">

<c:forEach var="eeRecord" items="${eeRecords}">	
<hr/>
<c:set var="eeLg" value="${eeRecord.eeLg}" />
<c:set var="militaryRecords" value="${eeRecord.militaryRecords}" />
<c:set var="monetaryBenefits" value="${eeRecord.monetaryBenefits}" />
<c:set var="ratedDisabilities" value="${eeRecord.ratedDisabilities}" />
		
<div class="select-caregiver">
		<div class="center-position">
			<div class="care-giver-name" id="update_veteran">
				<c:if test="${! empty eeLg}">
					<div class="selected-vcg">
			    	 	<div class="selected-info">
					    	 	<div class="selected-vcg-row">
			    	 				<fmt:formatDate value="${eeLg.createdDate}" var="createdDate" type="date" pattern="MM/dd/yy hh:mm:ss a"/>
			    	 				<div class="srow-label">Date E&E Received: ${eeError} </div>${createdDate}
			    	 			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">Military service info:</div>
				    			</div>
				    			<c:choose>
	    						<c:when test="${! empty militaryRecords}">
	    							<!-- Looping through military record -->
		    						<c:forEach var="militaryRecord" items="${militaryRecords}">	
					    			<div class="selected-vcg-row">
					    	 			<div class="prow-label">Service Branch: ${militaryRecord.serviceBranch}</div>
					    			</div>
					    			<div class="selected-vcg-row">
					    				<fmt:formatDate value="${militaryRecord.serviceDate}" var="serviceDate" type="date" pattern="MM/dd/yyyy"/>
				    	 				<div class="prow-label">Enter Service Date: ${serviceDate}</div>
				    	 			</div>
					    			<div class="selected-vcg-row">
					    				<fmt:formatDate value="${militaryRecord.exitServiceDate}" var="exitServiceDate" type="date" pattern="MM/dd/yyyy"/>
				    	 				<div class="prow-label">Exit from Service Date: ${exitServiceDate}</div>
				    	 			</div>
				    	 			<div class="selected-vcg-row">
				    	 				<div class="prow-label">Discharge type: ${militaryRecord.dischargeType}</div>
				    	 			</div>
				    	 			</c:forEach>
				    	 			<!-- End Loop -->
	    						</c:when>
	    						<c:otherwise>
	    							N/A
	    						</c:otherwise>
	    						</c:choose>
	    						
			    			<div class="selected-vcg-row">
			    			<c:choose>
			    			<c:when test="${! empty eeLg.dateOfDeath}">
			    			<fmt:formatDate value="${eeLg.dateOfDeath}" var="dateOfDeath" type="date" pattern="MM/dd/yyyy"/>
			    	 			<div class="srow-label">Date of death: </div>${dateOfDeath}
			    	 		</c:when>
   						<c:otherwise>
   							<div class="srow-label">Date of death: </div>N/A
   						</c:otherwise>
   						</c:choose>
			    	 		</div>
			    	 		
			    	 		<div class="selected-vcg-row">
		    	 			<div class="srow-label">Monetary Benefit Award status:</div>
		    	 			</div>
			    			
		    	 			<c:choose>
   						<c:when test="${! empty monetaryBenefits}">
   							<!-- Looping through monetary benefits -->
	    						<c:forEach var="monetaryBenefit" items="${monetaryBenefits}">	
				    			<div class="selected-vcg-row">
				    	 			<div class="prow-label">${monetaryBenefit.monetaryBenefit}</div>
				    			</div>
			    	 			</c:forEach>
			    	 			<!-- End Loop -->
   						</c:when>
   						<c:otherwise>
   							N/A
   						</c:otherwise>
   						</c:choose>

			    			<div class="selected-vcg-row"><div class="srow-label">Benefit Priority group: </div>${eeLg.priorityGroup}</div>
			    			<c:choose>
   						<c:when test="${! empty eeLg.medicaidEligibility && eeLg.medicaidEligibility eq 'false'}">
   							<div class="selected-vcg-row"><div class="srow-label">Eligibility for Medicaid: </div>No</div>
   						</c:when>
   						<c:otherwise>
   							<div class="selected-vcg-row"><div class="srow-label">Eligibility for Medicaid: </div>Yes</div>
   						</c:otherwise>
   						</c:choose>
			    			<div class="selected-vcg-row"><div class="srow-label">Service Connected Total combined disability rating: </div>${eeLg.scTotDisabRating}</div>
			    			
			    			<div class="selected-vcg-row"><div class="srow-label">Service Connected disabilities:</div></div>
			    			<c:choose>
   						<c:when test="${! empty ratedDisabilities}">
   							<!-- Looping through monetary benefits -->
	    						<c:forEach var="ratedDisability" items="${ratedDisabilities}">	
		    						<div class="selected-vcg-row">
				    					<div class="prow-label">Disability percentage: ${ratedDisability.percentage}</div>
					    			</div>
					    			<div class="selected-vcg-row">
					    				<div class="prow-label">Disability code: ${ratedDisability.code}</div>
					    			</div>
					    			<div class="selected-vcg-row">
					    				<div class="prow-label">Disability description: ${ratedDisability.description}</div>
					    			</div>
			    	 			<br/>
			    	 			</c:forEach>
			    	 			<!-- End Loop -->
   						</c:when>
   						<c:otherwise>
	    						N/A
   						</c:otherwise>
   						</c:choose>
   						
			    			<!-- Loop -->
			    			
				    			<!-- Loop -->
			    				
			    		</div>
		    		</div>
	    		</c:if>
			</div>
		</div>
	</div>
</c:forEach>
</c:when>
<c:otherwise>
	<div class="prow-label">No E&E data found</div>
</c:otherwise>
</c:choose>
</div>


<aui:script use="aui-modal">

A.one('.eligibility-frommodal').on('click',
        function( event ) {
			var icn = A.one ('#<portlet:namespace/>icn').val();
			loadEligibilityFromEE(icn);
        }
  );
         
</aui:script>

