
<%@ include file="/jsp/init.jsp" %>	
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

		<c:set var="form_" value="${caretMap_['form_']}" />
		<c:set var="person" value="${form_['person']}" />
		<c:set var="vcg" value="${form_['vcg']}" />
		<c:set var="disabled" value="${form_['disabled']}" />
		<c:set var="dispositionDate" value="${form_['dispositionDate']}" />
		<c:set var="initDispositionDate" value="${form_['initDispositionDate']}" />
		<c:set var="appReceivedDate" value="${form_['appReceivedDate']}" />
		<c:set var="role">${person.role}</c:set>
		<c:set var="dispositionReason" value="${form_['dispositionReason']}"></c:set>
		
		
	<input type="hidden" name="TRACKER" value="${TRACKER}" >
	<input type="hidden" name="vcg_ndx" value="${ndx}" >
	
	
		<input id="<portlet:namespace/>${TRACKER}_primaryKey" type="hidden" value="${person.primaryKey}" name="<portlet:namespace/>${ndx}_primaryKey">
		
		<input type="hidden" value="${form_['statusDate']}" id="statusDate" />
		<input type="hidden" value="${form_['maxDate']}" id="maxDate" />
		
		<div class='portlet-msg-info' style="width:65%"><liferay-ui:message key='baselines-for-caregiver' /> ${person.fullName}
		
			
			
			
			<c:forEach var="appealFile" items="${form_['appealFiles']}" >
				<div class="ten-ten-links" >
					<portlet:resourceURL var="getDocum">
						<portlet:param name="action" value="getDocum"/>
						<portlet:param name="documId" value="${appealFile.documId}"/>
					</portlet:resourceURL>
			  		<a href="${getDocum}" tabindex="0"  target="_blank" class="tab-click btn icon-file stipend-row float-right" title='${appealFile.name}' >&nbsp;${appealFile.name}</a>
		  		</div>
			</c:forEach>
		
		
		<ul>
		
		<c:if test="${!person.generalRole}" >
			<li> Application Received Date: ${appReceivedDate}</li>
		</c:if>
		<c:if test="${fn:startsWith(dispositionReason, 'revoked-')}" >
			<li> Revocation Date: ${form_['revocationDate']}</li>
		<!--	<li> Last Date you can perform Reinstatement on Caregiver: ${form_['reinstateEnd']}</li> -->
		</c:if>
		<c:if test="${person.generalRole and vcg.primaryApproved }" >
			<li> Primary Caregiver Approved <span class="icon-flag">&nbsp;</span></li>
		</c:if>
		<c:if test="${person.primaryRole and vcg.generalApproved }" >
			<li> General Caregiver Approved <span class="icon-flag">&nbsp;</span></li>
		</c:if>
			<c:if test="${!empty dispositionDate}">
				<li > Disposition Date: ${dispositionDate}</li>
			</c:if>
			<c:if test="${empty person.ssn}">
				<li > SSN Missing <span class="icon-flag">&nbsp;</span></li>
			</c:if>
			<c:if test="${ person.primaryRole and not vcg.hasBls() }">
				<li > Veteran's Zip code <span class="icon-flag">&nbsp;</span></li>
			</c:if>
			
			<c:choose>
				<c:when test="${person.validUspsAddress}">
					<li > Valid USPS Address <span class="icon-ok">&nbsp;</span></li>
				</c:when>
				<c:otherwise>
					<li > Invalid USPS Address <span class="icon-flag">&nbsp;</span></li>
				</c:otherwise>
			</c:choose>
			<c:if test="${!person.generalRole}" >
				<c:choose>
					<c:when test="${form_['assessmentComplete']}">
						<li > Assessments completed <span class="icon-ok">&nbsp;</span></li>
					</c:when>
					<c:otherwise>
						<li> Assessments not completed <span class="icon-flag">&nbsp;</span></li>
					</c:otherwise>
				</c:choose>
			</c:if>
			<c:if test="${form_['vacoWaiver'] && empty form_['appDelayApproval']}">
				<li > Requires VISN Application Delay Approval <span class="icon-flag">&nbsp; </span></li>
			</c:if>
			<c:if test="${! empty form_['APPEAL']}">
				<li id="${TRACKER}appeal" ><span class="icon-info">&nbsp; </span> <liferay-ui:message key="appeal-disclaimer" /> </li>
			</c:if>
			
			<li id="${TRACKER}termination" > No extended benefits, benefits terminate upon revocation <span class="icon-bell">&nbsp;</span></li>
			<li id="${TRACKER}benExtend" > Benefits extended <span id="${TRACKER}extendedDays"></span> days from revocation date <span class="icon-bullhorn">&nbsp;</span></li>
			
		</ul></div>
		
		
<c:if test="${! empty form_['APPEAL'] }" >

<style>

.fileUploadWrapper {
    float: right;
    width: 29%;
    margin-top: -255px;
}

.select-all-files, .select-file, .upload-list-info {
	display:none !important;
}

</style>

	<div class="lfr-dynamic-uploader fileUploadWrapper" id="<portlet:namespace />fileUploadWrapper" >
	   <div class="lfr-upload-container fileUploadAppeal" id="<portlet:namespace />fileUploadAppeal">
	        &nbsp;
	    </div>
	</div>

<portlet:actionURL var="uploadFileURLappeal">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="uploadTempFile"/>
	<portlet:param name="type" value="${form_['APPEAL']}"/>
	<portlet:param name="TRACKER" value="${TRACKER}"/>
	<portlet:param name="mvcPath" value="METADATA"/>
</portlet:actionURL>

<portlet:actionURL var="deleteFileURLappeal">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="removeFile"/>
	<portlet:param name="type" value="${form_['APPEAL']}"/>
	<portlet:param name="TRACKER" value="${TRACKER}"/>
	<portlet:param name="mvcPath" value="METADATA"/>
</portlet:actionURL>	



<aui:script  use="liferay-upload">

A.one('#<portlet:namespace />fileUploadWrapper').hide();
A.one('#${TRACKER}appeal').hide();

<c:choose>
	<c:when test="${fn:contains(dispositionReason, 'disapproved-')}" >
		<c:set var="ddLabel">disapproved-</c:set>
	</c:when>	
	<c:when test="${fn:contains(dispositionReason, 'revoked-')}" >
		<c:set var="ddLabel">revoked-</c:set>
	</c:when>	
</c:choose>

	var liferayUpload = new Liferay.Upload({
         allowedFileTypes: "${form_['extensions']}",
         container: '#<portlet:namespace />fileUploadAppeal',
         maxFileSize: 0,
         namespace:'<portlet:namespace />',
         uploadFile: '${uploadFileURLappeal}',
         deleteFile: '${deleteFileURLappeal}',       
         'strings.dropFilesText': '<liferay-ui:message key="csc-drag-and-drop-${ddLabel}files" />',
         'strings.selectFilesText': '<liferay-ui:message key="select-file" />',
         'strings.fileCannotBeSavedText': 'File cannot be saved',
         'strings.pendingFileText': 'Upload of file pending',
         'strings.uploadsCompleteText': '&nbsp;',
         multipleFiles: true
     });

	 Liferay.on( 'tempFileRemoved', function(e) {
			A.all('#<portlet:namespace/>fileUploadAppeal .upload-file').each( function (eee) {
				if( ! eee.hasClass('pending-file') ){
					for (var i = 0; i < eee.attr('childNodes').size(); i++) {
						var node = A.one(eee.attr('childNodes')._nodes[1]);
    					if ( node.hasClass('file-title') ) {
	    					eee.removeChild( node );
	    				}        
					}	
					eee.hide();
				}
			});
		}
	);
	

     A.on('domready', function( event ) {
     	try {
         	A.one('.component.liferayupload').appendTo("#<portlet:namespace />fileUploadAppeal");
     	} catch (e){}
     });
	   
	</aui:script>	
</c:if>
		
		
		
		<c:choose>
		   <c:when test="${empty initDispositionDate and vcg.visnNeeded}">
			<div class="waiver-section">
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input"  >
					<aui:select inlineField="true" label="waiver-reasons" name="${ndx}_waiverReason" id="${TRACKER}_waiverReason" >
						<aui:option value="" label="select-waiverReason-reason" />
						<c:forEach var="reason" items="${form_['waiverReasons']}">
							<aui:option value="${reason}" label="${reason}" />
						</c:forEach>
					</aui:select>
				</aui:field-wrapper>
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-vcg-medium-input required-input"  >
			 		<aui:input label="caret-waiver-note" name="${ndx}_waiverNote" size="35" type="textarea"  id="${TRACKER}_waiverNote" />
				</aui:field-wrapper>
			</div>
	<input type="hidden" name="MODE" value="4" >
		  </c:when>
		  <c:otherwise>
			
			
			
	<input type="hidden" name="MODE" value="1" >
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input" data="${form_['dispositionDateData']}" >
			<aui:input label="disposition-date" name="${ndx}_dispositionDate" cssClass="date-field not-max-date after-status-date" type="text" size="25" />
		</aui:field-wrapper>
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input"  >
			<aui:select inlineField="true" disabled="${!empty disabled['dispositionChoice']}" label="disposition-choices" name="${ndx}_dispositionChoice" id="${TRACKER}_dispositionChoice" >
				<aui:option value="" label="select-disposition-choice" />
				<c:forEach var="reason" items="${form_['dispositionChoices']}">
					<aui:option value="${reason}" label="${reason}decision" selected="${reason eq form_['dispositionChoice']}" />
				</c:forEach>
			</aui:select>
		</aui:field-wrapper>
		
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-wide-input"  >
			<aui:select inlineField="true" disabled="${!empty disabled['dispositionReason']}" label="disposition-reasons" name="${ndx}_dispositionReason" id="${TRACKER}_dispositionReason" >
				<aui:option value="" label="select-disposition-reason" />
				<c:forEach var="reason" items="${form_['dispositionReasons']}">
					<c:choose>
						<c:when test="${true eq reason.value}">
							<aui:option value="${reason.value}" label="${reason.key}" cssClass="section" disabled="true" />
						</c:when>
						<c:otherwise>
							<c:set var="reqComment" ><c:if test="${fn:contains(reason.value, '[*]')}" >require-comment</c:if></c:set>
							<aui:option value="${reason.value}" label="${reason.key}" cssClass="${reqComment}" />
						</c:otherwise>
					</c:choose>
				</c:forEach>
			</aui:select>
		</aui:field-wrapper>
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input" data="${form_['deceasedDateData']}" >
			<aui:input label="deceased-date" name="${ndx}_deceasedDate" id="${ndx}_deceasedDate" cssClass="date-field not-future after-status-date" type="text" size="25" />
		</aui:field-wrapper>
		
		
		<c:set var="tier" value="${form_['tier']}" />
		<c:set var="tierSpell" value='${tier eq "tier1"? "One": (tier eq "tier2"? "Two": (tier eq "tier3"? "Three":"") ) }' />
		
		<c:set var="tierName" value="${ndx}_tier" ></c:set>
		<input type="hidden" name="${tierName}" id="${tierName}" value="${vcg.tierLevel}" >
		
		<!-- 
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input"  >
			<c:set var="tier" value="${form_['tier']}" />
			<aui:select inlineField="true" label="tier" name="${ndx}_tier" id="${TRACKER}_tier"  >
				<aui:option value="" label="select-tier" disabled="${!empty disabled['tier'] && !(tierType eq tier)}" />
				<c:forEach var="tierType" items="${form_['tierTypes']}">
					<aui:option value="${tierType}" label="${tierType}" selected="${tierType eq tier}" disabled="${(!empty disabled['tier']) && !(tierType eq tier)}" />
				</c:forEach>
			</aui:select>
		</aui:field-wrapper>
		-->
		
		<div class="manage-layout float-left" id="<portlet:namespace/>${TRACKER}_tierWrapper">
			<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="float-left required-input"  >
				<aui:input label="tier-level" name="${TRACKER}_tierLevel" cssClass="tier-edit has-tooltip" type="text" size="25" id="${TRACKER}_tierLevel" title="One for Tier-1, Two for Tier-2, or Three for Tier-3" value="${tierSpell}" />
			</aui:field-wrapper>
			<aui:field-wrapper cssClass="float-left" >
				<ul class="tier-list" style="margin-top:-22px" >
					<li>One for Tier-1</li>
					<li>Two for Tier-2</li>
					<li>Three for Tier-3</li>	
				</ul>
			</aui:field-wrapper>
		</div>
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input" data="${form_['tierDateData']}" >
			<aui:input label="tier-effective-date" name="${ndx}_tierEffectiveDate" id="${TRACKER}_tierEffectiveDate" cssClass="date-field after-status-date" disabled="${!empty disabled['tierEffectiveDate']}"  type="text" size="25" value="${vcg.tierEffectiveDateStr}" />
		</aui:field-wrapper>
		
		<c:choose>
			<c:when test="${fn:startsWith(dispositionReason, 'disapproved-') || fn:contains(dispositionReason, 'appealed-disapproved') }" >
				<c:set var="caretNote" >justification-note</c:set>
				<c:set var="DISAPPROVED" value="${true}" />
			</c:when>
			<c:otherwise>
				<c:set var="DISAPPROVED" value="${false}" />
				<c:choose>
					<c:when test="${fn:startsWith(dispositionReason, 'disapproved-') || fn:startsWith(dispositionReason, 'revoked-') }" >
						<c:set var="caretNote" >justification-note</c:set>
					</c:when>
					<c:otherwise>
						<c:set var="caretNote" >caret-note</c:set>
					</c:otherwise>
				</c:choose>
			</c:otherwise>
		</c:choose>
		
		<c:set var="requiredNote" value="${\"required-input\"}" />
		<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "TECH_DISPOSITION") }' >
			<c:set var="caretNote" >justification-note</c:set>
			<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input"  >
				<aui:input label="ticket-number" name="${ndx}_ticketNumber" id="${ndx}_ticketNumber" cssClass="ticket-number" type="text" size="25" />
			</aui:field-wrapper>
		</c:if>
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-vcg-medium-input ${requiredNote}"  >
	 		<aui:input label="${caretNote}" name="${ndx}_note" size="35" type="textarea"  id="requiredNote" />
		</aui:field-wrapper>
		
		<c:if test="${empty initDispositionDate and vcg.cscNeeded}">
			<div class="waiver-section">
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input"  >
					<aui:select inlineField="true" label="waiver-reasons" name="${ndx}_waiverReason" id="${TRACKER}_waiverReason" >
						<aui:option value="" label="select-waiverReason-reason" />
						<c:forEach var="reason" items="${form_['waiverReasons']}">
							<aui:option value="${reason}" label="${reason}" />
						</c:forEach>
					</aui:select>
				</aui:field-wrapper>
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-vcg-medium-input required-input"  >
			 		<aui:input label="caret-waiver-note" name="${ndx}_waiverNote" size="35" type="textarea"  id="${TRACKER}_waiverNote" />
				</aui:field-wrapper>
			</div>
		</c:if>
		
			</c:otherwise>
		</c:choose>

		<input type="hidden" id="csc-reminder" value='<liferay-ui:message key="disposition-change-occurred" />' ></input>
		
		<input type="hidden" id="fileCount" name="fileCount" value='0' />
		
		<div id="_validationResult" ></div>


		
<aui:script use="aui-node" >


<c:choose>
   <c:when test="${empty initDispositionDate and vcg.visnNeeded}">
  </c:when>
  <c:otherwise>


A.one('#<portlet:namespace/>${TRACKER}_dispositionChoice').on('change',
  	function(e) {
  		var selection = A.one('#<portlet:namespace/>${TRACKER}_dispositionChoice').val();
  		var dispReason = A.one('#<portlet:namespace/>${TRACKER}_dispositionReason').ancestor('.field-wrapper');
  		if ( selection == 'disapproved-' || selection == 'revoked-' ){
  			requireField( dispReason );
  		} else {
  			unrequireField( dispReason );
  		}
  	<c:if test="${! empty form_['APPEAL'] }" >
		if ( selection.indexOf('appealed-') !== -1 ){
			A.one('#<portlet:namespace />fileUploadWrapper').show();
			A.one('#${TRACKER}appeal').show();
		} else {
			A.one('#<portlet:namespace />fileUploadWrapper').hide();
			A.one('#${TRACKER}appeal').hide();
		}
  	</c:if>
  		
  		
  	<c:if test="${ (role eq 'PRIMARY') and !DISAPPROVED }">	
  		var tierReason = A.one('#<portlet:namespace/>${TRACKER}_tierLevel').ancestor('.field-wrapper');
  		if ( selection == 'disapproved-' || selection == 'revoked-' || selection.indexOf('appealed-') !== -1 || selection == "" ){
  			A.one('#<portlet:namespace/>${TRACKER}_tierWrapper').hide();
  			unrequireField( tierReason );
  			unrequireField( A.one('#<portlet:namespace/>${TRACKER}_tierEffectiveDate').ancestor('.field-wrapper') );
  		} else {
  			A.one('#<portlet:namespace/>${TRACKER}_tierWrapper').show();
  			requireField( tierReason );
  			requireField( A.one('#<portlet:namespace/>${TRACKER}_tierEffectiveDate').ancestor('.field-wrapper') );
  		}
  		if ( selection == "appealed-revoked-veteran-"){
  			A.one('#<portlet:namespace/>${TRACKER}_tierWrapper').show();
  			requireField( tierReason );
  			requireField( A.one('#<portlet:namespace/>${TRACKER}_tierEffectiveDate').ancestor('.field-wrapper') );
  		}
  		A.all('.tier-edit').on('change',
		  	function(e) {
				var tier = this.val();
		  		var toLower = tier[0].toLowerCase();
		  		var label = '&nbsp;<liferay-ui:message key="tier-level" />';
		  		if ( toLower == 'one' && '${tier}' != toLower ){
		  			label = '&nbsp;Tier 1';
		  			tier = '1';
		  		} else if ( toLower == 'two' && '${tier}' != toLower ){
		  			label = '&nbsp;Tier 2';
		  			tier = '2';
		  		} else if ( toLower == 'three' && '${tier}' != toLower ){
		  			label = '&nbsp;Tier 3';
		  			tier = '3';
		  		} else {
		  			this.val('');
		  			tier = '${vcg.tierLevel}';
		  		}
		  		A.one('#'+ this.attr('id')).ancestor('.field-wrapper').one('.control-label').html(label);
		  		A.one('#${tierName}').val(tier);
		});
  	</c:if>
    }
);

<c:if test="${!empty dispositionDate}"><!-- they want note only... not UI smarts for "comment" -->
	A.one('#<portlet:namespace/>${TRACKER}_dispositionReason').on('change',
  		function( event ) {
		    	  	//var str = this._node.options[this._node.selectedIndex].getAttribute('class');
					//var requiredNote = A.one('#<portlet:namespace/>requiredNote').ancestor('.field-wrapper');
		    	  	//if ( str.indexOf('require-comment') > -1 ){ 		    	  		
					//	if ( !requiredNote.hasClass('required-input') ){
				  	//		requireField( requiredNote );
					//	}
					//} else {		    	  		
		    	  	//	if ( requiredNote.hasClass('required-input') ){
				  	//		unrequireField( requiredNote );
					//	}
					//}
					var selection = A.one(this._node.options[this._node.selectedIndex]).val();
					<c:if test="${!person.generalRole}">
					if ( selection.indexOf("[") > 0 ){
						if ( selection.indexOf("*") > 0 ){
							// console.log('show no days');
							A.one('#${TRACKER}benExtend').hide();
						} else {
							// console.log(selection.substring(selection.indexOf("[")+1, selection.indexOf("]")) );
							A.one('#${TRACKER}extendedDays').html( selection.substring(selection.indexOf("[")+1, selection.indexOf("]"))  );
							A.one('#${TRACKER}benExtend').show();
							A.one('#${TRACKER}termination').hide();
						}
					} else {
						A.one('#${TRACKER}termination').show();
						A.one('#${TRACKER}benExtend').hide();
					}
					</c:if>
					var requiredDeceasedDate = A.one('#<portlet:namespace/>${ndx}_deceasedDate').ancestor('.field-wrapper');
					if ( selection.indexOf ('deceased') > 0 ){
						requireField( requiredDeceasedDate );
					} else {
						unrequireField( requiredDeceasedDate );
					}
		     }
  	);
</c:if>

	var requireField = function( dispReason ){
		if (dispReason){
			if ( !dispReason.hasClass('required-input') ) {
            	dispReason.addClass( 'required-input' );
            }
	        dispReason.show();
    	    dispReason.attr('disabled', '');
        }
	}
	
	var unrequireField = function( dispReason ){
		if (dispReason){
			if ( dispReason.hasClass('required-input') ){
            	dispReason.removeClass( 'required-input' );
            }
	        dispReason.hide();
	        dispReason.attr('disabled', 'true');
        }
	}

	unrequireField( A.one('#<portlet:namespace/>${TRACKER}_dispositionReason').ancestor('.field-wrapper') );
	unrequireField( A.one('#<portlet:namespace/>${ndx}_deceasedDate').ancestor('.field-wrapper') );
	unrequireField( A.one('#<portlet:namespace/>${TRACKER}_tierEffectiveDate').ancestor('.field-wrapper') );
	unrequireField( A.one('#<portlet:namespace/>${TRACKER}_tierLevel').ancestor('.field-wrapper') );
	A.one('#<portlet:namespace/>${TRACKER}_tierWrapper').hide();

</c:otherwise>
</c:choose>

	A.one('#${TRACKER}termination').hide();
	A.one('#${TRACKER}benExtend').hide();

</aui:script>
		