<%@ include file="/jsp/init.jsp" %>

<portlet:actionURL var="saveEntry">
	<portlet:param name="javax.portlet.action" value="doAction" />
</portlet:actionURL>

	
	<c:set var="form_" value="${caretMap_['form_']}" />
	
	<legend class="header" id="headerElem">
		<liferay-ui:message key="create-call-type" /> (${role})
	</legend>


	<fieldset>
		<h4><liferay-ui:message key="call-types" /></h4> 
		<ul class="default-call-type" id="<portlet:namespace />existing_call_types" >
			<c:forEach var="boxGrp" items="${form_['standard-call-types']}" >
				<li><liferay-ui:message key="${boxGrp}" /></li>
			</c:forEach>
				
			<c:forEach var="boxGrp" items="${form_['custom-call-types']}" >
				<li> <liferay-ui:message key="${boxGrp.label}"/> </li>
			</c:forEach>
		</ul>

		<div id="<portlet:namespace />new_call_types" >
			<input type="text" id="0">
			<button class="icon-plus-sign btn btn-primary" onclick="saveType(this)" >&nbsp; <liferay-ui:message key="add-call-type" /></button>
		</div>
		
			<div class="clear-both">
				<a href="${iteratorURL['cancel']}" class="btn btn-primary" >
					<liferay-ui:message key="Back to Dashboard" />
				</a>
			</div>
	</fieldset>

<div class="yui3-skin-sam">
   	<div id="modalResponse">
   	</div>
</div>

<aui:script use="aui-node,aui-tooltip,aui-modal">
	
	var ttip =  new A.TooltipDelegate( { trigger: '.icon-ok' } );
	
	window.saveType = function(src){
			var input = src.parentNode.getElementsByTagName('input')[0];
			var callType = input.value;
			window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="addCallType" /></portlet:resourceURL>', 'json', 
					  { 
						CALL_TYPE: callType
				 	  },
					  function( data ){
				 		  	if ( data.form_ ){
				 				var callTypes = A.one('#<portlet:namespace />existing_call_types');
				 				callTypes.append( A.Node.create('<li>' + callType + '</li>') );
				 		  		new A.Modal({
									headerContent: '<h4><liferay-ui:message key="csl-admin-success" /></h4>',
							        bodyContent: '<h4><liferay-ui:message key="new-call-type-added" /></h4>',
							        centered: true,
							        modal: true,
							        render: '#modalResponse',
							        resizable: {
							          handles: 'b, r'
							        },
							        width: 500
							    }).render();
				 		  		input.value = '';
				 		  	} else {
								new A.Modal({
									headerContent: '<h4><liferay-ui:message key="call-type-error-header" /></h4>',
							        bodyContent: 'Error Creating Call Type:' + data.CALL_TYPE,
							        centered: true,
							        modal: true,
							        render: '#modalResponse',
							        resizable: {
							          handles: 'b, r'
							        },
							        width: 500
							    }).render();
				 		  	}
						} 
					);
		}		
	
	
	
</aui:script>


<%@include file="/jsp/version.jsp" %>
	
	
	