<%@ include file="/jsp/init.jsp" %>

<portlet:actionURL var="saveCSCWaiver">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="saveEntry"/>
	<portlet:param name="entry" value="cscWaiver"/>
</portlet:actionURL>

<style>
	.sectionHeading{
	    border: thin solid #d9d9d9;
	    background-color: #f0efef;
		font-weight: bold;
		margin: 1px;
		padding: 3px;
		width: 99%;
	}
	.summaryTable table, th, td{
	    border: thin solid #d9d9d9;
	    border-collapse: collapse;
	    margin: 12px;
	    padding: 5px;
	    text-align: center;
	}
	.summaryTable tr:hover {
		background-color: #f5f5f5;
	}
	.summaryTable th {
	    background-color: #f0efef;
	}
</style>


<legend class="header">CSC Waiver</legend>

<div class="caret-form clear-both" >
<form name="cscWaiver" method="post" action="${saveCSCWaiver}" >
	
	<c:set var="form_" value="${caretMap_['form_']}" />
	<c:set var="workItemId" value="${form_['workItemId']}" />
	<c:set var="vcgAnId" value="${form_['vcgAnId']}" />
	<c:set var="receivedDate" value="${form_['receivedDate']}" />
	<c:set var="daysPassed" value="${form_['daysPassed']}" />
	
	<input type="hidden" name="TRACKER" value="${TRACKER}" >
	<input type="hidden" name="waiver_classPk" value="${form_['workItemId']}" >
	<input type="hidden" name="waiver_userId" value="${form_['loggedPersnId']}" >	
	 	 
	<div class="summaryTable">
	<table style="width:50%">
		<tr>
		  <th width="60%">Name</th> 
		  <th width="40%">Data</th> 	  
		</tr>
		<tr>
		  <td style="text-align: left;">Work Item Id</td>
		  <td>${workItemId}</td>
		</tr>
		<tr>
		  <td style="text-align: left;">Application Id</td>
		  <td>${vcgAnId}</td>
		</tr>
		<tr>
		  <td style="text-align: left;">Valid Application Receive Date</td>
		  <td>${receivedDate}</td>
		</tr>
		<tr>
		  <td style="text-align: left;">Days passed since Valid Application Received Date</td>
		  <td>${daysPassed}</td>
		</tr>
	</table>
	</div>

	<br><br>
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-wide-input ${cssClass}" >
		<aui:select label="waiver-reason" name="waiver_reason">
			<aui:option value="" label="select"  />
			<aui:option value=" Veteran Assessment Delay" > Veteran Assessment Delay</aui:option>
			<aui:option value="Caregiver Assessment Delay" >Caregiver Assessment Delay</aui:option>
			<aui:option value="Caregiver Training Delay" >Caregiver Training Delay</aui:option>
			<aui:option value="In-home Assessment Delay" >In-home Assessment Delay</aui:option>
			<aui:option value="Final Disposition Delay" > Final Disposition Delay</aui:option>
			<aui:option value="Veteran's Hospitalization" >Veteran's Hospitalization</aui:option>
		</aui:select>
	</aui:field-wrapper>

	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-wide-input ${cssClass}"  >
 		<aui:input label="waiver-comments" name="waiver_note" size="50" type="textarea"  />
	</aui:field-wrapper>

	<div class="clear-both">
		<button type="button" id="submitWaiverForm" class="btn btn-primary" >
			<liferay-ui:message key="submit-waiver" />
		</button>
		
		<a href="<portlet:actionURL/>" class="btn btn-primary" >
			<liferay-ui:message key="cancel" />
		</a>		
	</div>
</form>
</div>

<aui:script use="aui-modal">
					
	var validationModal = new A.Modal({
	    headerContent: '<h4><liferay-ui:message key="data-validation-header" /></h4>',
	    bodyContent: A.one("#waiverValidationDiv"),
	    centered: true,
	    destroyOnHide: false,
	    modal: true,
	    render: '#waiverValidationModal',
	    resizable: {
	      handles: 'b, r'
	    },
	    visible: false,
	    width: 600
	});

	A.one('#submitWaiverForm').on('click', function() {	
		var msg = "";
    	if(""==A.one("#<portlet:namespace/>waiver_reason").val()){
    		A.one(A.one("#<portlet:namespace/>waiver_reason")).addClass( 'missing-required-input' );
    		msg = "<li>Reason is required</li>";
    	}else{
    		A.one(A.one("#<portlet:namespace/>waiver_reason")).removeClass( 'missing-required-input' );
    	}
    	
    	if(""==A.one("#<portlet:namespace/>waiver_note").val()){
    		A.one(A.one("#<portlet:namespace/>waiver_note")).addClass( 'missing-required-input' );
    		msg = msg + "<li>Comment is required</li>";
    	}else{
    		A.one(A.one("#<portlet:namespace/>waiver_note")).removeClass( 'missing-required-input' );
    	}
    	
    	if(""==msg){
    		document.forms['cscWaiver'].submit();
    	}else{
    		validationModal.render();
    		validationModal.show();
    		msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + msg +"</ul></div>";
    		A.one ('#waiverValidationResult').html(msg);		    		
    	}
    	
    	/*
    	validateFields( function( message ){
    		if ( message.length > 0 ){
        		modalDataValidation.render();
	    		modalDataValidation.show();
				var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
				A.one ('#${ndx}_validationResult').html(msg);
      			return;	
        	}else{
        		document.forms['cscWaiver'].submit();
        	}
    	});
    	*/
	});
	
	
  var validateFields = function (){
	  
	  var count = 0;
	  var inputNodes = A.all('.required-input input, .required-input select');
	  var fields = "";
	  for ( var i = 0; i < inputNodes.size() ; i++ ){
		  var node = A.one(inputNodes._nodes[i]);
		  if (node == undefined  || node.attr('disabled') == true ) continue;
			if ( 'select-one' == node.attr('type') ){
    			if ( node.val() == "" || node.val() == "0" ){
    				 node.addClass( 'missing-required-input' );
    				 fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" is required</li>";
    				 count++;
    			} else {
    				if ( node.hasClass('missing-required-input') ){
    					node.removeClass( 'missing-required-input' );
    				}
    			}
    		}
			if ( 'text' == node.attr('type') ){
				if ( node.val() == "" ){
   					node.addClass( 'missing-required-input' );
   					fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" is required</li>";
   					count++;
	   			} else {
	   				if ( node.hasClass('missing-required-input') ){
	   					node.removeClass( 'missing-required-input' );
	   				}
				}
	    	}
	    }			  
	  }

</aui:script>


<div class="yui3-skin-sam">
    <div id="waiverValidationModal"></div>
</div>

<div id="waiverValidationDiv" class="yui3-skin-sam">
    <div id="waiverValidationResult"></div>
</div>

