<%@ include file="/jsp/init.jsp" %>

<style>
.certify-that input[type="checkbox"] {
    margin-right: 5px;
    margin-top: 13px;
}

.lfr-dynamic-uploader {
    display: block;
    float: right;
     margin-top: -20px;
}
.lfr-dynamic-uploader.manage-layout {
    width: 427px;
}
.lfr-upload-container .upload-target {
    border: thin solid #2aaae6;
    margin-bottom: 1em;
    min-height: 60px;
    padding: 15px 0;
}
.manage-layout-wide-input select {
    width: auto;
}
.manage-layout-wide-input input[type="text"] {
    width: 65%;
}
.sectionHeading{
    border: thin solid #d9d9d9;
    background-color: #f0efef;
	font-weight: bold;
	margin: 15px 0;
	padding: 3px;
	width: 99%;
	float: left;
}
.required-input .control-label::before {
    content: "*" !important;
}
.missing-required-input {
	background-color: #ffffcc !important;
}
</style>


<legend class="header">10-10CG Form</legend>

<portlet:actionURL var="saveEntry">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="saveEntry"/>
	<portlet:param name="entry" value="vcgAn"/>
</portlet:actionURL>

<portlet:actionURL var="uploadFileURL1010cg">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="uploadTempFile"/>
	<portlet:param name="replace" value="true"/>
	<portlet:param name="type" value="CSC_1010"/>
	<portlet:param name="TRACKER" value="${TRACKER}"/>
	<portlet:param name="mvcPath" value="METADATA"/>
</portlet:actionURL>

<portlet:actionURL var="deleteFileURL1010cg">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="removeFile"/>
	<portlet:param name="type" value="CSC_1010"/>
	<portlet:param name="TRACKER" value="${TRACKER}"/>
	<portlet:param name="mvcPath" value="METADATA"/>
</portlet:actionURL>

<portlet:actionURL var="uploadFileURLpoa">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="uploadTempFile"/>
	<portlet:param name="replace" value="true"/>
	<portlet:param name="type" value="POA"/>
	<portlet:param name="TRACKER" value="${TRACKER}"/>
	<portlet:param name="mvcPath" value="METADATA"/>
</portlet:actionURL>

<portlet:actionURL var="deleteFileURLpoa">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="removeFile"/>
	<portlet:param name="type" value="POA"/>
	<portlet:param name="TRACKER" value="${TRACKER}"/>
	<portlet:param name="mvcPath" value="METADATA"/>
</portlet:actionURL>

<form name="saveEntry" method="post" action="${saveEntry}" >
	<input type="hidden" name="TRACKER" value="${TRACKER}" >
	<c:set var="form_" value="${caretMap_['form_']}" />
	<c:set var="cssClass" value="${form_['required']}" />
	
	<div id="app1010Tab">
	   	<ul class="nav nav-tabs">
		    <li><a href="#tab-4-1">Veteran</a></li>
		    <li><a href="#tab-4-2">Primary Caregiver</a></li>
		    <li><a href="#tab-4-3">Secondary Caregiver</a></li>
		    <li><a href="#tab-4-4">Secondary Two Caregiver</a></li>
		</ul>	
	
		<div class="tab-content">
			<div id="tab-4-1" class="tab-pane">				
				<c:set var="title" value="Veteran" />
		    	<%@include file="/jsp/internal/cscVeteranInfo.jsp" %>
		    </div>
		    
		    <div id="tab-4-2" class="tab-pane">
				<c:set var="title" value="Primary" />
		   		<%@include file="/jsp/internal/cscPrimaryInfo.jsp" %>
		    </div>
	
			<div id="tab-4-3" class="tab-pane">				
				<c:set var="title" value="Secondary" />
		    	<%@include file="/jsp/internal/cscSecondaryInfo.jsp" %>
		    </div>
		    
		    <div id="tab-4-4" class="tab-pane">
				<c:set var="title" value="SecondaryTwo" />
		   		<%@include file="/jsp/internal/cscSecondaryTwoInfo.jsp" %>
		    </div>	    
		</div>
	</div>

	
	<div class="clear-both">
		<button type="button" id="submitForm" class="btn btn-primary btn-main-form" >Save</button>
		
		<a href="<portlet:actionURL/>" class="btn btn-primary btn-main-form" >
			<liferay-ui:message key="cancel" />
		</a>
	</div>

</form>

<div id="<portlet:namespace/>fallback"></div>
<div id="submitState"></div>
 

<aui:script use="aui-tabview,aui-modal,aui-tooltip,liferay-upload,json-parse">

	var modalCaregiver = new A.Modal({
	    headerContent: '<h4><liferay-ui:message key="caregiver-modal-header" /> </h4>',
	    bodyContent: A.one("#caregiverDiv"),
	    centered: true,
	    destroyOnHide: false,
	    modal: true,
	    render: '#caregiverModal',
	    toolbars: false,
	    resizable: {
	      handles: 'b, r'
	    },
	    visible: false,
	    width: 600
	});

	modalCaregiver.render();
	modalCaregiver.show();


    A.all('#submitCGSelection').on('click', function() { 

		var cgJson;
		<c:if test="${not empty caller}">
			cgJson = JSON.parse('${caller}');
		</c:if>
		
    	var userCallerAs = A.one('#<portlet:namespace />userCallerAs');
		if ( cgJson && userCallerAs.val()  ){
			A.one('#<portlet:namespace/>' + userCallerAs.val() + 'CG').val(true);
			var prefix = '#<portlet:namespace />' + userCallerAs.val()  +'Persn_';
			useJsonPerson ( cgJson,  prefix );
			if ( cgJson['foreigner'] ){
				useJsonPerson ( cgJson, '#<portlet:namespace />' + userCallerAs.val() + 'Persng_' );
			} else {
				useJsonPerson ( cgJson, '#<portlet:namespace />' + userCallerAs.val() + 'Persnu_' );
				A.one('#<portlet:namespace />'+ userCallerAs.val() +'Persnu_state').simulate('change');
			}
			A.one('#<portlet:namespace />vcgAn_'+ userCallerAs.val()  +'Relationship').val(cgJson.relationship);
			
			var referralDoc = null;
			<c:if test="${! empty REFERRAL_1010}">
				referralDoc = A.one('#<portlet:namespace/>referralDoc').val();
				if( null==referralDoc || 'false'==referralDoc ){
					A.one('#<portlet:namespace />fileUploadedWrapper').hide();
				} else {
					A.one('#<portlet:namespace />fileUploadWrapper').hide();
				}
			</c:if>
			
		}
		

    	var primary = A.one('#<portlet:namespace/>primaryCG').val();
    	var secondary= A.one('#<portlet:namespace/>secondaryCG').val();
    	var secondaryTwo = A.one('#<portlet:namespace/>secondaryTwoCG').val();
    	
    	if((null==primary || 'false'==primary)
    			&& (null==secondary || 'false'==secondary)
    			&& (null==secondaryTwo || 'false'==secondaryTwo))
    	{
			var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-select-caregiver' /></div>";
			A.one ('#cgErrorSection').html(msg);
    	}else{
    		A.one ('#cgErrorSection').html('');    		
    		modalCaregiver.hide();
    		
    		if(null==primary || 'false'==primary){
    			var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='primary-not-selected' /></div>";
    			A.one ('#tab-4-2').html(msg);
    		}
    		if(null==secondary || 'false'==secondary){
       			var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='secondary-not-selected' /></div>";
    			A.one ('#tab-4-3').html(msg);
    		}
    		if(null==secondaryTwo || 'false'==secondaryTwo){
       			var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='secondary-two-not-selected' /></div>";
    			A.one ('#tab-4-4').html(msg);
    		}
   		}
    });
    

	var app1010Tab = new A.TabView({
	    srcNode: '#app1010Tab',
	    type: 'pills'
	  }
	);
	app1010Tab.render();
	
	new A.TooltipDelegate( { trigger: '.search-person-action' } );
	
	 var liferayUpload = new Liferay.Upload({
         allowedFileTypes: "${form_['extensions']}",
         container: '#<portlet:namespace />fileUpload',
         maxFileSize: 0,
         namespace:'<portlet:namespace />',
         uploadFile: '${uploadFileURL1010cg}',
         deleteFile: '${deleteFileURL1010cg}',       
         'strings.dropFilesText': '<liferay-ui:message key="csc-drag-and-drop-1010-file" />',
         'strings.dropFileText': '<liferay-ui:message key="csc-drag-and-drop-1010-file" />',
         'strings.selectFileText': '<liferay-ui:message key="select-1010-file" />',
         'strings.selectFilesText': '<liferay-ui:message key="select-1010-file" />',
         'strings.fileCannotBeSavedText': 'File cannot be saved',
         'strings.pendingFileText': 'Upload of file pending',
         'strings.uploadsCompleteText': 'Upload completed, save to attach to Application',
         multipleFiles: false

     });
		
	 var liferayUploadPOA = new Liferay.Upload({
         allowedFileTypes: "${form_['extensions']}",
         container: '#<portlet:namespace />fileUploadPOA',
         maxFileSize: 0,
         namespace:'<portlet:namespace />',
         uploadFile: '${uploadFileURLpoa}',     
         deleteFile: '${deleteFileURLpoa}',   
         'strings.dropFilesText': '<liferay-ui:message key="drag-and-drop-poa-file" />',
         'strings.dropFileText': '<liferay-ui:message key="drag-and-drop-poa-file" />',
         'strings.selectFileText': '<liferay-ui:message key="select-poa-file" />',
         'strings.selectFilesText': '<liferay-ui:message key="select-poa-file" />',
         'strings.fileCannotBeSavedText': 'File cannot be saved',
         'strings.pendingFileText': 'Upload of file pending',
         'strings.uploadsCompleteText': 'Upload completed, save to attach to Application',
         multipleFiles: false

     });
	 
	 Liferay.on( 'tempFileRemoved', function(e) {
			A.all('#<portlet:namespace/>fileUpload .upload-file, #<portlet:namespace/>fileUploadPOA .upload-file').each( function (eee) {
				if( ! eee.hasClass('pending-file') ){
					for (var i = 0; i < eee.attr('childNodes').size(); i++) {
						var node = A.one(eee.attr('childNodes')._nodes[1]);
    					if ( node.hasClass('file-title') ) {
	    					eee.removeChild( node );
	    				}        
					}	
					eee.hide();
				}
			});
		}
	);

     A.on('domready', function( event ) {
     	try {
         	A.one('.component.liferayupload').appendTo("#<portlet:namespace />fileUploadPOA");
         	A.one('.component.liferayupload').appendTo("#<portlet:namespace />fileUpload");
         	
         	document.getElementById('caregiverDiv').style.display = '';
         	document.getElementById('validationAddDiv').style.display = '';
     	} catch (e){
     		// console.log('appendTo... failed');
     	}
     });	
     
          
     A.all('#submitForm').on('click', function() { 
    	 
		var veteran = false;
		var primary = false;
		var secondary = false;
		var secondaryTwo = false;
		
		var veteranAdd = false;
		var primaryAdd = false;
		var secondaryAdd = false;
		var secondaryTwoAdd = false;
    	 
		A.one('#addressValidationResult').html('');

 	   	validateVeteranFields(function ( validationStatus ){
    		 veteran = validationStatus;    		
    		 
    		 validatePrimaryFields(function ( validationStatus ){
        		 primary = validationStatus;    
        		 
        		 validateSecondaryFields(function ( validationStatus ){
            		 secondary = validationStatus; 
            		 
            		 validateSecondaryTwoFields(function ( validationStatus ){
                		 secondaryTwo = validationStatus;                  		 
                		 
                	   	 //console.log("veteran is : "+veteran);
                    	 //console.log("primary is : "+primary);
                    	 //console.log("secondary is : "+secondary);
                		 //console.log("secondary two is : "+secondaryTwo);
                    	 
                    	 if(veteran && primary && secondary && secondaryTwo){
                    		 //console.log("good for submit");
                    		 //document.forms['saveEntry'].submit();
                    		 /*
                    		 //check usps validation
						   	 validateVeteranAddress(function ( addressStatus ){
					    		 veteranAdd = addressStatus;    		
					    		 
					    		 validatePrimaryAddress(function ( addressStatus ){
					        		 primaryAdd = addressStatus;    
					        		 
					        		 validateSecondaryAddress(function ( addressStatus ){
					            		 secondaryAdd = addressStatus; 
					            		 
					            		 validateSecondaryTwoAddress(function ( addressStatus ){
					                		 secondaryTwoAdd = addressStatus;                  		 

					                    	 if(veteranAdd && primaryAdd && secondaryAdd && secondaryTwoAdd){
					                       	   	 //console.log("veteran is : "+veteranAdd);
					                        	 //console.log("primary is : "+primaryAdd);
					                        	 //console.log("secondary is : "+secondaryAdd);
					                    		 //console.log("secondary two is : "+secondaryTwoAdd);
					     
					                    		 //console.log("good for submit");                   		 
					                    		 document.forms['saveEntry'].submit();					                    	 
					                    	 }
					            		 });
					        		 });
					    		 });
						   	 }); 
						   	 */
						   	  window.removeEventListener('beforeunload', preventUser);
						   	  document.forms['saveEntry'].submit();                  	
                         }else{
                    		 //console.log("validation errors");
                    	 }    	
                	 });
            	 });            	
        	 });        	 
    	 });
     });
     
      
	 window.modalDataValidation = new A.Modal({
		    headerContent: '<h4><liferay-ui:message key="data-validation-header" /> </h4>',
		    bodyContent: A.one("#validationDiv"),
		    centered: true,
		    destroyOnHide: false,
		    modal: true,
		    render: '#validationModal',
		    resizable: {
		      handles: 'b, r'
		    },
		    visible: false,
		    width: 600
	});
	
	modalDataValidation.addToolbar([
	  {
	     label: 'Cancel',
	     on: {
	         click: function() {
	         	modalDataValidation.hide();
	         }
	      }
	  }
	]);    
	
	
	window.modalAddressValidation = new A.Modal({
	    headerContent: '<h4><liferay-ui:message key="address-validation-header" /> </h4>',
	    bodyContent: A.one("#validationAddDiv"),
	    centered: true,
	    destroyOnHide: false,
	    modal: true,
	    render: '#validationAddModal',
	    resizable: {
	      handles: 'b, r'
	    },
	    visible: false,
	    width: 600
	});
	 
	 modalAddressValidation.addToolbar([
	   {
         label: 'Cancel',
         on: {
	            click: function() {
	            	modalAddressValidation.hide();
              	}
          }
	   },
	   {
          label: 'Submit',
          id: 'modalSubmit',
          on: {
              click: function() {
            	  document.forms['saveEntry'].submit();
              }
          }
       }
	 ]);    
	
	
	window.preventUser = function() {
		return "<liferay-ui:message key='back-button-lose-form-data' />";
	}
	window.addEventListener('beforeunload', preventUser);
	
	A.all('.btn-main-form').on('click', function ( event ) {
	  	window.removeEventListener('beforeunload', preventUser);
	});
	

</aui:script>
		  
<div class="yui3-skin-sam">
<div id="caregiverModal"></div>
</div>

<div id="caregiverDiv" class="yui3-skin-sam" style="display:none;">
	<div id="caregiverResult">

	<div id="cgErrorSection" ></div>
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass=" ${cssClass}"  >
			<aui:input label="primary-cg" name="primaryCG" type="checkbox" value="false" /><br/>
			<aui:input label="secondary-cg" name="secondaryCG" type="checkbox" value="false" /><br>
			<aui:input label="secondary-two-cg" name="secondaryTwoCG" type="checkbox" value="false" />
		</aui:field-wrapper>
		
		<c:if test="${not empty caller}">
		  <aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['caller']}"   >
   		   <aui:select label="use-caller-as" name="userCallerAs" id="userCallerAs" >
			<aui:option value="" label="dont-use-caller" />
   			<aui:option value="primary" label="primary" /> 
   			<aui:option value="secondary" label="secondary" /> 
   			<aui:option value="secondaryTwo" label="secondaryTwo" />
		   </aui:select>
		  </aui:field-wrapper>
			<c:if test="${not empty REFERRAL_1010}">
		  <aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-medium"   >
			<aui:input label="use-referrals-1010cg" id="referralDoc" name="referralDoc" type="checkbox" value="false" />
		  </aui:field-wrapper>
		  	</c:if>
		</c:if>
		
		<div class="clear-both float-right">
			<button type="button" id="submitCGSelection" class="btn btn-primary" >Ok</button>
		</div>	
	</div>
</div>


<div class="yui3-skin-sam">
	<div id="validationModal"></div>
</div>

<div id="validationDiv" class="yui3-skin-sam">	
	<div id="veteranValidationResult"></div>
	<div id="primaryValidationResult"></div>
	<div id="secondaryValidationResult"></div>
	<div id="secondaryTwoValidationResult"></div>
</div>

<div class="yui3-skin-sam">
	<div id="validationAddModal"></div>
</div>

<div id="validationAddDiv" class="yui3-skin-sam" style="display:none;">	
	<div class='portlet-msg-info'>
		<div id="addressValidationResult"></div>
		<br/>
		Do you want to proceed and submit the application?
	</div>
</div>


<c:set var="isDisabled" value="${false}" />	
<%@include file="/jsp/internal/searchPerson.jsp" %>
<c:set var="isDisabled" value="${true}" />	

<%@include file="/jsp/version.jsp" %>

	