<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>

<%@include file="/jsp/init.jsp" %>

<!-- %@include file="/jsp/online/console.jsp" % -->

<div class="yui3-skin-sam">
    <div id="modal"></div>
</div>

<%@include file="/jsp/internal/menu.jsp" %>



<div id="mainTab">
  <ul class="nav nav-tabs">
    <li class="tab-click" ><a href="#tab-1"><div class="icon-home"></div> ${role} Dashboard </a></li>
    <li class="tab-click" ><a href="#tab-2"><div class="icon-search"></div> Search</a></li>
  </ul>

  <div class="tab-content">
    <div id="tab-1" class="tab-pane">
      	<div class="dashboard-top">
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapse1">
			      	<legend class="header toggler-header-expanded"><div class="icon-bookmark"></div> My Work</legend>
			      	<div class="content toggler-header-expanded" id="myApplicationWork" >
					</div>
				</fieldset>
      		</div>
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapse2">
		      		<legend class="header toggler-header-expanded"><div class="icon-comment"></div> Messaging</legend>
		      		<div class="content toggler-header-expanded" id="myNotes" >
	      			</div>
      			</fieldset>
      		</div>
      	</div>
      	
    
		  
   		<div class="next-line">
		  <fieldset  id="sectionCollapse3" class="clear-both">
			<legend class="header"><div class="icon-star-half-full"></div> ${visnName}</legend>
			<div class="content toggler-header-expanded"  id="appDelaysOuter" >
			<div id="appDelays" class="tab-pane" >
			</div>
			</div>
		</fieldset>
		</div>
		  
	
    </div>

    <div id="tab-2" class="tab-pane">
		<%@include file="/jsp/internal/filter.jsp" %>
	</div>
  </div>

</div>


<aui:script use="aui-tabview,aui-modal,aui-dropdown,aui-toggler,node-event-simulate">
	
	for ( i = 1 ; i < 4; i++ ){
	    new A.TogglerDelegate(
	      {
	        animated: true,
	        container: '#sectionCollapse' + i ,
	        content: '.content',
	        expanded: true,
	        header: '.header',
	        transition: {
	          duration: 0.2,
	          easing: 'cubic-bezier(0, 0.1, 0, 1)'
	        }
	      }
	    );
	}

	A.all('.close-window').on(
	 'click',
	  function() {
		modal.hide();	    	  
	  }
	);
    
    var loadList = function(e, page) {
	  	if (!page){
	   		var href = e.currentTarget.getActiveTab().one('a').attr('href');
	  	   	page = href.substring(href.indexOf('#'));
		}
		var node = A.one( page );
	    if (node.hasClass('loaded-pane')){
	    	return false;
	    }
	
		window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /></portlet:resourceURL>', 'html', 
			{ page: page },
			function( data ){
				overwrite( node, data );
			} 
		);
	}
   
    
    window.midTabs = new A.TabView({
        srcNode: '#midTabs',
        type: 'pills',
        on: {
            click: function(e){
            	var ndx = e.currentTarget.getActiveTab().one('a').attr('classPk');
            	loadList(e,null,ndx,true);
             }
          }
      }      
    );
    window.midTabs.render();

  window.careTmainTab = new A.TabView({
      srcNode: '#mainTab',
      type: 'pills'
    }
  );
  window.careTmainTab.render();
  
  A.on('domready', function( event ) {
   	try {
   		//A.one('#${first}').simulate('click');
   		loadList(event,'#appDelays');
   		loadList(event,'#myApplicationWork');
   		loadList(event,'#myNotes');
   		A.all('.tab-click').attr('tabindex',0);
   	} catch (e){}
   });
  
</aui:script>

<%@include file="/jsp/internal/actionsSupport.jsp" %>
<%@include file="/jsp/im/compose.jsp" %>