<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>

<%@include file="/jsp/init.jsp" %>


      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapse1">
			      	<legend class="header toggler-header-expand"><div class="icon-search"></div> <liferay-ui:message key="search" /></legend>
			      		
			      		<div class="content toggler-content-expand" >
			      			
			      			<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout">
								<aui:select label="search-context" name="form_searchContext" id="searchContext" cssClass="srch-caret search-category"  >
									<aui:option value="" label="select-context" />
									<c:forEach var="searchFor" items="${searches}">
										<aui:option value="${searchFor}" label="${searchFor}" />
									</c:forEach>
								</aui:select>
							</aui:field-wrapper>
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout">
								<aui:select disabled="${isDisabled}" label="facility" cssClass="srch-caret" name="form_userOrgIds" id="userOrgIds" >
									<aui:option value="0" label="select-facility" selected="true" />
									<c:forEach var="district" items="${caretMap_['vhaSystem']}">
										<aui:option value="${district.key}" label="${district.key}" cssClass="district" disabled="true" />
										<c:forEach var="visn" items="${district.value}">
											<aui:option value="${visn.key}" label="${visn.key}" cssClass="visn" disabled="true" />
											<c:forEach var="facility" items="${visn.value}">
												<aui:option value="${facility.value}" label="${facility.key}" cssClass="facility" />
											</c:forEach>
										</c:forEach>
									</c:forEach>
								</aui:select>
							</aui:field-wrapper>
			      			
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout">
								<aui:select label="search-role" name="form_roleId" id="roleId" cssClass="srch-caret role-dashboard"  >
									<aui:option value="0" label="select-role" />
									<c:forEach var="searchFor" items="${CARET_ROLES}">
										<aui:option value="${searchFor.value}" label="${searchFor.key}"   />
									</c:forEach>
								</aui:select>
							</aui:field-wrapper>
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout">
								<aui:select label="user-name" name="form_userName" id="impersonateId" cssClass="srch-caret search-category"  >
									<aui:option value="" label="select-user" />
								</aui:select>
							</aui:field-wrapper>
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >
								<aui:input label="context-id" cssClass="number-field srch-caret" name="form_primaryKey" type="text" size="25" value="${search.primaryKey}" />
							</aui:field-wrapper>
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="true" last="false" cssClass="manage-layout"  >
								<aui:input label="first-name" name="form_firstName" type="text" size="25" cssClass="srch-caret" id="firstName" value="${search.firstName}" />
							</aui:field-wrapper>
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="true" last="false" cssClass="manage-layout"  >
								<aui:input label="last-name" name="form_lastName" type="text" size="25" cssClass="srch-caret" id="lastName" value="${search.lastName}" />
							</aui:field-wrapper>
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="true" last="false" cssClass="manage-layout"  >
								<aui:input label="ssn" name="form_ssn" type="text" size="25" cssClass="srch-caret ssn-field" id="ssn" value="${search.ssn}" />
							</aui:field-wrapper>
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="true" last="false" cssClass="manage-layout"  >
								<aui:input label="dob" name="form_birthDate" type="text" size="25" cssClass="srch-caret date-field" id="birthDate" value="${search.birthDate}" />
							</aui:field-wrapper>
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >
								<aui:input label="phone" cssClass="phone-field srch-caret"  name="form_phone" type="text" size="25" value="${search.phone}" />
							</aui:field-wrapper>
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >
								<aui:input label="zip" cssClass="zip-field srch-caret" name="form_zip" type="text" size="25" value="${search.zip}" />
							</aui:field-wrapper>
							
								
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout">
								<aui:select label="user-mode" name="form_impersonationMode" id="impersonationMode" cssClass="srch-caret search-category"  >
									<aui:option value="" label="standard-view-edit" />
									<aui:option value="IMPERSONATE" label="impersonate-selected-userName" />
								</aui:select>
							</aui:field-wrapper>
							
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout">
									<aui:select label="work-item-type" name="form_workType" cssClass="srch-caret" id="workType" >
										<aui:option value="" label="select-work-item-type" />
										<c:forEach var="type" items="${caretMap_['WORKITEM_TYPES']}">
											<aui:option value="${type}" label="${type}" cssClass="facility" />
										</c:forEach>
									</aui:select>
								</aui:field-wrapper>
							
							<div class="clear-both">
								<a href="<portlet:actionURL/>" class="btn btn-primary" >
									<liferay-ui:message key="clear" />
								</a>
								<a href="javascript:" id="<portlet:namespace/>searchPerson" class="btn btn-primary" >
									<liferay-ui:message key="search" />
								</a>
							</div>
							
							<div id="searchContextPane"></div>
							
							
						</div>
						
				</fieldset>
      		
      		</div>
 

<aui:script use="aui-tabview,aui-toggler">
	A.all('.role-dashboard').on( 
		      'change',
		      function( event ) {
		    	  	var eventId = event.currentTarget.attr('id');
		    	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="getRoleUsers" /></portlet:resourceURL>', 'json', 
							{ roleId: A.one('#'+ eventId).val() },
							function( data ){
						    	 var usersNode = A.one ( '#<portlet:namespace/>impersonateId');
						    	 var options = "<option>Select Found Users</option>";
								if ( data.size > 0 ){
							    	 for ( var i = 0; i < data.size; i++  ){
							    		 options = options + '<option value="' + data.users[i].userId + '">'+ data.users[i].fullName + '</option>';
							    	 }
								}
						    	 usersNode.html( options );
							} 
					);
		     }
		 );



	A.one('#<portlet:namespace/>searchContext').on ( 'change', function (e) {
		
		if ( A.one('#<portlet:namespace/>searchContext').val() == "workItems" ){
			A.one('#<portlet:namespace/>workType').ancestor('.field-wrapper').show();
		} else {
			A.one('#<portlet:namespace/>workType').ancestor('.field-wrapper').hide();
		}
	});
	A.one('#<portlet:namespace/>workType').ancestor('.field-wrapper').hide();

	A.one('#<portlet:namespace/>impersonationMode').on ( 'change', function (e) {
		 window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="impersonate" /></portlet:resourceURL>', 'json', 
				  { 
			 		impersonationMode: e.currentTarget.val(),
			 		userId: A.one('#<portlet:namespace/>impersonateId').val(),
			 		roleId: A.one('#<portlet:namespace/>roleId').val()
			 	  },
				  function( data ){
			 		  	if ( data.form_ == true || data.form_ == 'true'  ){
			 		  		//console.log( 'saved' );
			 		  	} else {
							alert( 'Could not set impersonationMode' );
			 		  	}
					} 
				);
	} );  
	  


    A.one('#<portlet:namespace/>searchPerson').on(
    		'click',
    	function ( e ){
    			var page = A.one('#<portlet:namespace/>searchContext').val();
				if ( page == "" ) {
					return false;
				}
      			var node = A.one( "#searchContextPane" );
	
      			window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="fromParameter" value="true"/></portlet:resourceURL>', 'html', 
      				{ 	page: page,
	      				roleId: A.one('#<portlet:namespace/>roleId').val(),
	      				userOrgIds: A.one('#<portlet:namespace/>userOrgIds').val(),
	      				userId: A.one('#<portlet:namespace/>impersonateId').val(),
	      				firstName: A.one('#<portlet:namespace/>firstName').val(),
	      				lastName: A.one('#<portlet:namespace/>lastName').val(),
	      				birthDate: A.one('#<portlet:namespace/>birthDate').val(),
	      				ssn: A.one('#<portlet:namespace/>ssn').val(),
	      				workType: A.one('#<portlet:namespace/>workType').val()
	      			},
      				function( data ){
      					overwrite( node, data);
      				} 
      			);
    		}		
    );
  
</aui:script>

