<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>
<portlet:actionURL var="saveFunds">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="occFmSubmit"/>
</portlet:actionURL>

<div class="yui3-skin-sam">
	<div id="modalRender"></div>
	<div id="modalPane" >
	</div>
</div>



<div class="hidden">
<aui:form action="${saveFunds}" method="post" name="close_fm" >
<div id="occMenuNode" ></div>
</aui:form>

<div id="UPDATE_FUNDING">
		<input type="hidden" name="type"  value="UPDATE_FUNDING" />
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false"
			last="false" cssClass="manage-layout">
			<aui:select label="Obligated Funds" name="funds" id="funds">
				<aui:option value="" label="Please Select" />
				<aui:option value="increase" label="Increase Funds" />
				<aui:option value="decrease" label="Decrease Funds" />
			</aui:select>
		</aui:field-wrapper>
		
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="true" last="false" cssClass="manage-layout">
			<aui:input label="Amount" name="amount" type="text" />
		</aui:field-wrapper>
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout date-field" >
			<aui:input label="Date" name="obligationDate" id="obligationDate" cssClass="date-field" type="text" size="25" />
		</aui:field-wrapper>
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout">
			<aui:input label="P.O. Number" name="poNumber" type="text" />
		</aui:field-wrapper>
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="true" cssClass="manage-vcg-medium-input"  >
	 		<aui:input label="Comment" name="obligation_note" size="35" type="textarea"  id="obligationNote" />
		</aui:field-wrapper>

</div>
<div id="_validationResult" ></div>
</div>



<div class="hidden">
	<div id="APPLY_FM_PAYMENT" title="Apply FMS Payments" >
		<input type="hidden" name="type" value="APPLY_FM_PAYMENT" />
		
		<aui:input name="mockService" label="FOR TESTING ONLY- FMS mock call, with one-third rejections" id="mockService" type="checkbox" cssClass="mock" value="false" />
				
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false"
			last="false" cssClass="manage-layout">
			<aui:select label="Call Type" name="callType" id="serviceFunds">
				<aui:option value="" label="Please Select Time Period" />
				<aui:option value="month" label="${caretMap_['month']}" />
				<aui:option value="week" label="${caretMap_['week']}" />
			</aui:select>
		</aui:field-wrapper>
									
		
	</div>
</div>

<aui:script use="aui-tabview,aui-modal,aui-dropdown,aui-toggler,node-event-simulate,anim">
	/**
	A.one('#<portlet:namespace/>${TRACKER}_dispositionChoice').on('change',
	  	function(e) {
	  		var selection = A.one('#<portlet:namespace/>serviceFunds').val();
	  		var dispReason = A.one('#<portlet:namespace/>${TRACKER}_dispositionReason').ancestor('.field-wrapper');
	  		var tierReason = A.one('#<portlet:namespace/>${TRACKER}_tier').ancestor('.field-wrapper');
	  		if ( selection == 'month' ){
	  			requireField( dispReason );
	  		} else if ( selection == 'week' ) {
	  			unrequireField( dispReason );
	  		} else {
	  			requireField( A.one('#<portlet:namespace/>${TRACKER}_tierEffectiveDate').ancestor('.field-wrapper') );
	  		}
	    }
	);
	**/
	
	
	A.all('.caret-action').on(
      'click',
      function(e) {	
    	  var id = e.currentTarget.attr('id');
       		id = id.substring( id.indexOf('<portlet:namespace/>') + '<portlet:namespace/>'.length );
       		overwrite( A.one( "#modalPane" ), A.one('#'+id).html() );
       		A.one('#<portlet:namespace/>occFmModalHeader').html(A.one('#'+id).attr('title'));
       		
       		occFmModal.render();
			occFmModal.show();
      }
    );

	var occFmModal = new A.Modal(
			{
				headerContent : '<h4><liferay-ui:message key="occ-funds" /></h4>',
				headerContent: '<h4 id="<portlet:namespace />occFmModalHeader" ><liferay-ui:message key="occ-funds" /></h4>',
				bodyContent : A.one("#modalPane"),
				centered : true,
				destroyOnHide : false,
				modal : true,
				render : '#modalRender',
				resizable : {
					handles : 'b, r'
				},
				zIndex: 1100,
				visible : false,
				width : 650
			});

	occFmModal.addToolbar([ {
		label : 'Cancel',
		on : {
			click : function() {
				occFmModal.hide();
			}
		}
	}, {
		label : 'Update',
		on : {
			click : function() {
				validateFields( function ( message ) {
		    		var validationNotice = A.one ('#_validationResult');
			    		if ( message.length > 0 ){
		    				var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
		    				validationNotice.html(msg);
		    				occFmModal.footerNode.insert(validationNotice);
				    		return false;	
			    		}
			    		// window.escapePrevent();
			    		overwrite( A.one( "#occMenuNode" ), A.one("#modalPane") );
			    		A.one("#<portlet:namespace/>close_fm").submit();
		    	}, '#saveFunds');
			}
		}
	} ]);

	/////--------------------------------------
  
  var validateFields = function ( anotherCallback, parentNode ){
				  
				  var count = 0;
				  parentNode = parentNode || '';
		  		  var inputNodes = A.all( parentNode + ' .required-input input, ' 
				  				+ parentNode + ' .required-input radio, ' 
				  				+ parentNode + ' .required-input textarea, ' 
				  				+ parentNode + ' .required-input select');
				  var fields = "";
				  for ( var i = 0; i < inputNodes.size() ; i++ ){
					  var node = A.one(inputNodes._nodes[i]);
					  if (node == undefined  || node.attr('disabled') == true ) continue;
						if ( 'select-one' == node.attr('type') ){
			    			if ( node.val() == "" || node.val() == "0" ){
			    				 node.addClass( 'missing-required-input' );
			    				 fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" is required</li>";
			    				 count++;
			    			} else {
			    				if ( node.hasClass('missing-required-input') ){
			    					node.removeClass( 'missing-required-input' );
			    				}
			    			}
			    		}
						if ( 'text' == node.attr('type') || 'textarea' == node.attr('type') ){
							if ( node.val() == ""   
								|| ( node.hasClass('date-field') && node.val() == 'MM/DD/YYYY' )
								|| ( node.hasClass('ssn-field') && node.val() == '###-##-####' )
								|| ( node.hasClass('email-field') && node.val() == '[USERNAME]@[DOMAIN]' )
								|| ( node.hasClass('phone-field') && node.val() == '(###) ###-####' ) ){
			   					node.addClass( 'missing-required-input' );
			   					var custom = node.ancestorsByClassName("required-input")._nodes[0].getAttribute('data-custom-message');
			   					if ( custom ) {
			   						fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim() + ": " + custom + "</li>"; 
			   					} else {
			   						fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" is required</li>";
			   					}
			   					count++;
				   			} else {
				   				if ( node.hasClass('missing-required-input') ){
				   					node.removeClass( 'missing-required-input' );
				   				}
				   				if ( node.hasClass ('not-future') ){
				   					var parts = (""+node.val()).replace(/\W/g, '').match(/^(\d{2})(\d{2})(\d{4})$/);
				   					
				   					if ( parts ){
										  var input = new Date ( parseInt ( parts[3], 10 ), (parseInt ( parts[1], 10 ) -1), parts[2] );
										  var future = new Date ();
										  if ( input > future ){
											  fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" cannot be in future</li>";
										  }

									  }
				   				}
				   				if ( node.hasClass ('after-status-date') ) {
				   					
				   					var statusDate = node.ancestorsByClassName("required-input")._nodes[0].getAttribute('data-statusDate');
				   					//var statusDate = A.one('#statusDate').val();
				   					
				   					var appRc = (""+statusDate).replace(/\W/g, '').match(/^(\d{2})(\d{2})(\d{4})$/);
				   					var parts = (""+node.val()).replace(/\W/g, '').match(/^(\d{2})(\d{2})(\d{4})$/);
				   					if ( parts && appRc ){
										  var input = new Date ( parseInt ( parts[3], 10 ), (parseInt ( parts[1], 10 ) -1), parts[2] );
										  var recvd = new Date ( parseInt ( appRc[3], 10 ), (parseInt ( appRc[1], 10 ) -1), appRc[2] );
										  if ( recvd > input ){
											  fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" cannot be before " + statusDate + "</li>";
										  }
									}
				   				}
				   				if ( node.hasClass ('not-max-date') ){
				   					var maxDate = node.ancestorsByClassName("required-input")._nodes[0].getAttribute('data-maxDate');
				   					
				   					var max = (""+maxDate).replace(/\W/g, '').match(/^(\d{2})(\d{2})(\d{4})$/);
				   					var parts = (""+node.val()).replace(/\W/g, '').match(/^(\d{2})(\d{2})(\d{4})$/);
				   					if ( parts && max ){
										  var input = new Date ( parseInt ( parts[3], 10 ), (parseInt ( parts[1], 10 ) -1), parts[2] );
										  var beyVal = new Date ( parseInt ( max[3], 10 ), (parseInt ( max[1], 10 ) -1), max[2] );
										  if ( beyVal < input ){
											  fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" cannot be after " + maxDate + "</li>";
										  }
									}
				   				}
				   				
							}
				    	}
				    }
				    anotherCallback( fields );
			  }
	/**		
	var requireField = function( dispReason ){
		if (dispReason){
			if ( !dispReason.hasClass('required-input') ) {
            	dispReason.addClass( 'required-input' );
            }
	        dispReason.show();
    	    dispReason.attr('disabled', '');
        }
	}
	
	var unrequireField = function( dispReason ){
		if (dispReason){
			if ( dispReason.hasClass('required-input') ){
            	dispReason.removeClass( 'required-input' );
            }
	        dispReason.hide();
	        dispReason.attr('disabled', 'true');
        }
	}
			
	unrequireField( A.one('#<portlet:namespace/>${TRACKER}_tierEffectiveDate').ancestor('.field-wrapper') );
	unrequireField( A.one('#<portlet:namespace/>${TRACKER}_tier').ancestor('.field-wrapper') );
  **/
  
</aui:script>
