<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>

<%@include file="/jsp/init.jsp" %>

<!-- %@include file="/jsp/online/console.jsp" % -->

<div class="yui3-skin-sam">
    <div id="modal"></div>
</div>

<%@include file="/jsp/internal/menu.jsp" %>



<div id="mainTab">
  <ul class="nav nav-tabs">
    <li class="tab-click" ><a href="#tab-1"><div class="icon-home"></div> ${role} Dashboard<!-- ${facilityNumber} --></a></li>
    <li class="tab-click" ><a href="#tab-2"><div class="icon-search"></div> Search</a></li>
  </ul>

  <div class="tab-content">
    <div id="tab-1" class="tab-pane">
      	<div class="dashboard-top">
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapse1">
			      	<legend class="header toggler-header-expanded"><div class="icon-bookmark"></div> My Work</legend>
			      	<div class="content" id="myApplicationWork" >
					</div>
				</fieldset>
      		</div>
      		
      		<div class="next-line">
      	
      	<fieldset id="sectionCollapse3" class="clear-both">
			<legend class="header  toggler-header-expanded"><div class="icon-hospital"></div> ${facilityName} </legend>
				<div class="content"  id="midTabsOuter" >
			   <div id="midTabs"  >
					<ul class="nav nav-tabs">
					
					    <li class="tab-click" ><a href="#unassignedWork">Unassigned (<c:if test="${ ! empty FILTERED['unassignedWork']}">*</c:if><span id='total_unassignedWork'>${total_['unassignedWork']}</span>)</a></li>
					    <li class="tab-click" ><a href="#overdueApps">Unassigned Overdue (<span id='total_overdueApps'>${total_['overdueApps']}</span>)</a></li>
					    <li class="tab-click" ><a href="#inProcess">In Process (<span id='total_inProcess'>${total_['inProcess']}</span>)</a></li>
					    <li class="tab-click" ><a href="#dueTodayWork">Due Today (<span id='total_dueTodayWork'>${total_['dueTodayWork']}</span>)</a></li>
					    <li class="tab-click" ><a href="#overdueInProcess">Overdue (<c:if test="${ ! empty FILTERED['overdueInProcess']}">*</c:if><span id='total_overdueInProcess'>${total_['overdueInProcess']}</span>)</a></li>
					    <li class="tab-click" ><a href="#transferred">Transferred (<span id='total_transferred'>${total_['transferred']}</span>)</a></li>
						<li class="tab-click" ><a href="#referralWork">Referrals (<span id='total_referralWork'>${total_['referralWork']}</span>)</a></li>
					    <li class="tab-click" ><a href="#homeVisit">Home Visit Due (<span id='total_homeVisit'>${total_['homeVisit']}</span>)</a></li>
					    <li class="tab-click" ><a href="#deathNotice">Death Notice (<span id='total_deathNotice'>${total_['deathNotice']}</span>)</a></li>
					    <li class="tab-click" ><a href="#tiuNoteRewrite">Rewrite TIU Notes (<span id='total_tiuNoteRewrite'>${total_['tiuNoteRewrite']}</span>)</a></li>
					    <li class="tab-click" ><a href="#periodicAssessments">Monitoring Assessments (<span id='total_periodicAssessments'>${total_['periodicAssessments']}</span>)</a></li>
					
					</ul>
					<div class="tab-content">
						<div id="unassignedWork" class="tab-pane"></div>
						<div id="overdueApps" class="tab-pane"></div>
						<div id="inProcess" class="tab-pane"></div>
						<div id="dueTodayWork" class="tab-pane"></div>
						<div id="overdueInProcess" class="tab-pane"></div>
						<div id="transferred" class="tab-pane"></div>
						<div id="referralWork" class="tab-pane"></div>
						<div id="homeVisit" class="tab-pane"></div>
						<div id="deathNotice" class="tab-pane"></div>
						<div id="tiuNoteRewrite" class="tab-pane"></div>
						<div id="periodicAssessments" class="tab-pane"></div>
					</div>
				</div>
			</div>
		  </fieldset>
		  </div>
      		<div class="next-line">
	
	<c:if test="${not empty visnName}">
	
		<fieldset  id="sectionCollapse5" class="clear-both">
			<legend class="header  toggler-header-expanded"><div class="icon-star-half-full"></div> ${visnName}</legend>
			<div class="content"  id="appDelaysOuter" >
			<div id="appDelays" class="tab-pane" >
			</div>
			</div>
		</fieldset>
		</div>
      		<div class="next-line">
	</c:if>
		
	  	<fieldset id="sectionCollapse4" class="clear-both">
			<legend class="header toggler-header-expanded"><div class="icon-flag-alt"></div> <liferay-ui:message key="occ-revisit-work" /></legend>
			<div class="content"  id="correctionWorkOuter" >
			<div id="correctionWork" class="tab-pane" >
			  	
			</div>
			</div>
		</fieldset>
		</div>
		<div class="next-line">
      			<fieldset id="sectionCollapse2">
		      		<legend class="header toggler-header-collapsed"><div class="icon-comment"></div> My Work Notes</legend>
		      		<div class="content" id="myNotes" >
	      			</div>
      			</fieldset>
      	  </div>
    </div>
</div>

    <div id="tab-2" class="tab-pane">
		<%@include file="/jsp/internal/filter.jsp" %>
	</div>
  </div>

</div>


<aui:script use="aui-tabview,aui-modal,aui-dropdown,aui-toggler,node-event-simulate,anim">
	<c:choose>
		<c:when test="${empty visnName}">
			for ( i = 1 ; i < 5; i++ ){
		</c:when>
		<c:otherwise>
			for ( i = 1 ; i < 6; i++ ){
		</c:otherwise>
	</c:choose>
	
	    new A.TogglerDelegate(
	      {
	        animated: true,
	        container: '#sectionCollapse' + i ,
	        content: '.content',
	        expanded: true,
	        header: '.header',
	        transition: {
	          duration: 0.2,
	          easing: 'cubic-bezier(0, 0.1, 0, 1)'
	        }
	      }
	    );
	}

	A.all('.close-window').on(
	 'click',
	  function() {
		modal.hide();	    	  
	  }
	);
    
    
    var loadList = function(e, page) {
    	var reloadCount = false;
	  	if (!page){
	   		var href = e.currentTarget.getActiveTab().one('a').attr('href');
	  	   	page = href.substring(href.indexOf('#'));
	  	   	reloadCount = true;
		}
		var node = A.one( page );
	    if (node.hasClass('loaded-pane')){
	    	return false;
	    }
	
		window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /></portlet:resourceURL>', 'html', 
			{ page: page },
			function( data ){
				overwrite( node, data );
				if ( reloadCount ){
					window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="reportCount" /></portlet:resourceURL>', 'json', { 
						      reportName: page
							}, function( data ){
								if ( data && parseInt ( data.reportCount ) > -1 ){
									var count = parseInt ( data.reportCount );
			   						A.one('#total_'+page.substring(1)).html( count );
							   }
							}
						);
				}
				
			} 
		);
		
	}
    
    window.midTabs = new A.TabView({
        srcNode: '#midTabs',
        type: 'pills',
        on: {
            click: function(e){ loadList(e); }
          }
      }      
    );
    window.midTabs.render();

  window.careTmainTab = new A.TabView({
      srcNode: '#mainTab',
      type: 'pills'
    }
  );
  window.careTmainTab.render();
  
  A.one('#sectionCollapse2').once('click', function(){
	  loadList(event,'#myNotes');
  });
  
  
  A.on('domready', function( event ) {
   	try {
   		A.one('#unassignedWork').simulate('click');
   		loadList(event,'#myApplicationWork');
   		loadList(event,'#correctionWork');
   		
   		<c:if test="${not empty visnName}">
   			loadList(event,'#appDelays');
   		</c:if>
   		
   		A.all('.tab-click').attr('tabindex',0);
   		if ("search" == "${caretMap_['tabContext']}" ){
   			window.careTmainTab.selectChild(1);
   			window.setTimeout(function(e){ A.one('#<portlet:namespace/>searchPerson').simulate('click'); }, 500);
   			new A.Anim({
				duration: 0.5,
				easing: 'easeBoth',
				node: 'win',
				to: {
					scroll: [0, A.one("#searchContextPane").get('offsetTop')]
				}
			}).run();
   		}
   	} catch (e){}
   });
  
</aui:script>

<%@include file="/jsp/internal/actionsSupport.jsp" %>
<%@include file="/jsp/im/compose.jsp" %>