package gov.via.sts.service;
 
import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.util.PortalUtil;

public class StsHeaderHandler implements SOAPHandler<SOAPMessageContext> {
	private static final Log _log = LogFactoryUtil.getLog( StsHeaderHandler.class );
	
    public boolean handleMessage(SOAPMessageContext smc) {
 
        Boolean outboundProperty = (Boolean) smc.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);
 
        if (outboundProperty.booleanValue()) {
 
            SOAPMessage message = smc.getMessage();
 
            try {
 
                SOAPEnvelope envelope = smc.getMessage().getSOAPPart().getEnvelope();
                
                SOAPHeader header = envelope.getHeader();
                if(header == null){
                    header = envelope.addHeader();
                }
                SOAPBody body = envelope.getBody();
                Iterator<SOAPBodyElement> childElements = body.getChildElements();
                while (childElements.hasNext()) {
                    SOAPBodyElement childNode = childElements.next();
                    if (childNode.getNodeName().contains("RequestSecurityToken")) {
                    	
                    	ServiceContext sc = ServiceContextThreadLocal.getServiceContext();
                        String iamSession = gov.va.caret.util.CaretUtil.getExpandoValue(PortalUtil.getUser(sc.getLiferayPortletRequest()).getExpandoBridge(), "IAMSESSION");
                        _log.info("IamSession " + iamSession);
                    	childNode.addNamespaceDeclaration("ns1", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
                    	SOAPElement onBehalfOf =
                   			 childNode.addChildElement("OnBehalfOf", "ns1");
                    	SOAPElement base =
                    			onBehalfOf.addChildElement("Base", "ns1");
                    	
                    	 SOAPElement binarySecurityToken =
                    			 base.addChildElement("BinarySecurityToken", "wss", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
                         binarySecurityToken.addAttribute(new QName("EncodingType"), "base64");
                         binarySecurityToken.addAttribute(new QName("ValueType"), "http://URL /siteminder/std_token");
                         
                         binarySecurityToken.addTextNode(iamSession);
                    	
                        SOAPElement appliesTo =
                        		childNode.addChildElement("AppliesTo", "wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
                        SOAPElement endpointReference =
                        		appliesTo.addChildElement("EndpointReference", "wsa", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
                        SOAPElement appliesToadress =
                        		endpointReference.addChildElement("Address", "wsa" );
                        		appliesToadress.addTextNode("https://URL");
                        		
                		SOAPElement issuer =childNode.addChildElement("Issuer", "ns1");
                        SOAPElement adress =
                        		issuer.addChildElement("Address", "wsa", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
                        adress.addTextNode("https://URL   /Issuer/smtoken/SAML2");
                        
                        SOAPElement requestType =childNode.addChildElement("RequestType", "ns1");
                        requestType.addTextNode("http://schemas.xmlsoap.org/ws/2005/02/trust/Issue");

                        SOAPElement tokenType =childNode.addChildElement("TokenType", "ns1");
                        tokenType.addTextNode("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                        break;
                    }
                }
                
            } catch (Exception e) {
            	_log.error(e);
            }
 
        } else {
            try {
                SOAPMessage message = smc.getMessage();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                message.writeTo(out);
                String STSResponseXML = new String(out.toByteArray());
                ServiceContext sc = ServiceContextThreadLocal.getServiceContext();
                sc.getLiferayPortletRequest().setAttribute("STSResponseXML", STSResponseXML);
                _log.info("STS Response" + STSResponseXML);
 
            } catch (Exception ex) {
            	_log.error(ex);
            } 
        }
        return outboundProperty;
    }
 
    public Set getHeaders() {
        //throw new UnsupportedOperationException("Not supported yet.");
        return null;
    }
 
    public boolean handleFault(SOAPMessageContext context) {
        //throw new UnsupportedOperationException("Not supported yet.");
        return true;
    }
 
    public void close(MessageContext context) {
    }
}
