package gov.va.oit.oed.vaww;

import static java.nio.charset.StandardCharsets.ISO_8859_1;
import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.Validator;

import freemarker.template.utility.StringUtil;
import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.TemplateHandler;
import gov.va.caret.util.Toolbox;


public class AttendedService {
	
	private static Log _log = LogFactoryUtil.getLog( AttendedService.class );
	private static final String NDX = "${ndx}";

	public List<Map<String,Object>> searchAttended ( Map<String,Object> map ) throws IOException, ParserConfigurationException, SAXException, TransformerException {
		
		_log.info("callMVI()");
		String loadedTemplate = null;
		
		_log.info("using map params");
		loadedTemplate = new TemplateHandler().loadTemplate( optimizeSearchParams(map), "/gov/va/oit/oed/vaww/templates", "attended.ftl" );
		_log.info("template loaded");
		
		if ( loadedTemplate != null ){
			_log.info("calling mvi");
			Object obj = new VAIdM().getVAIdMPort().prpaIN201305UV02( new String(loadedTemplate.getBytes(ISO_8859_1), UTF_8) );
			_log.info("finished mvi call");
			return translateList( obj );
		}
		_log.error("unable to complete response...");
		return null;
	}
	
	public Document getDocument ( Node node ) throws TransformerException, SAXException, IOException, ParserConfigurationException {
		StringWriter writer = new StringWriter();
		Transformer transformer = TransformerFactory.newInstance().newTransformer();
		transformer.transform(new DOMSource(node), new StreamResult(writer));

		InputSource inputSource = new InputSource(new StringReader(writer.toString()));
		DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
		documentBuilderFactory.setNamespaceAware(true);
		return documentBuilderFactory.newDocumentBuilder().parse(inputSource);
	}
	

	private List<Map<String,Object>> translateList ( Object obj ) throws ParserConfigurationException, SAXException, IOException, TransformerException{
		Document doc = null;
		if ( obj instanceof Node ){
			doc = getDocument ( (Node) obj );
		} else {
			_log.error("unable to parse response...");
			return null;
		}
        try {
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            xpath.setNamespaceContext(new UnattendedNameSpaceContext());
            	
            Properties props = new Properties();
			props.load(AttendedService.class.getClassLoader().getResourceAsStream("attended.properties"));
			
			String acknowledgement = getValue( doc, xpath, String.valueOf( props.remove("acknowledgement") ) );
			_log.info("acknowledgement is " + acknowledgement);
			if ( "AE".equals(acknowledgement) || "AR".equals(acknowledgement) ){
				_log.warn("MVI Service ERROR");
				return null;
			}
			List<Map<String,Object>> personMapList = new ArrayList<Map<String,Object>>();
			
			String resultCurrentQuantityStr = getValue( doc, xpath, String.valueOf( props.remove("resultCurrentQuantity") ) );
			int resultCurrentQuantity = Integer.valueOf(resultCurrentQuantityStr);
			
			java.util.Map<String,String> nodeListMap = new java.util.HashMap<String,String>();
			String nodeListExpr = null;
			
			for ( int ndx = 1; ndx <= resultCurrentQuantity; ndx++ ){
				Map<String,Object> personMap = new HashMap<String,Object>();
				for ( Object key: props.keySet() ){
					if ( key.toString().startsWith("NodeList_") ){
						if ( ndx > 1 ) continue;
						if ( "NodeList_".equals(key) ){
							nodeListExpr = props.get(key).toString();
						} else {
							nodeListMap.put( key.toString(), props.get(key).toString() );
						}
						continue;
					}
					String value = getValue( doc, xpath, String.valueOf( props.get(key) ).replace(NDX, String.valueOf(ndx) ) );
					personMap.put( String.valueOf(key), normalize( (String)key, value)  );
					_log.info( "Person "+ key + " Value: " + value );
				}
				if ( !Toolbox.isEmpty( nodeListExpr ) && !nodeListMap.isEmpty() ){
					setIdValues( doc, xpath, nodeListExpr.replace(NDX, String.valueOf(ndx) ), nodeListMap, personMap );
				}
				personMapList.add(personMap);
			}
			_log.info("finished parsing");
			return personMapList;
        } catch ( IOException e ) {
            e.printStackTrace();
        }
        return null;
    }

	protected String getValue(Document doc, XPath xpath, String expression) {
		String name = null;
		if ( expression == null || expression.isEmpty() ) return StringPool.BLANK;
		try {
			name = (String) xpath.compile( expression ).evaluate(doc, XPathConstants.STRING);
		} catch (XPathExpressionException e) {
			e.printStackTrace();
			return "";
		}
		return name;
	}
	
	protected void setIdValues( Document doc, XPath xpath, String expression, Map<String,String> nodeListMap, Map<String, Object> personMap ){
		try {
			NodeList nodeList = ((NodeList)xpath.compile( expression ).evaluate(doc, XPathConstants.NODESET));
			JSONObject vistaMap = JSONFactoryUtil.createJSONObject();
			for ( int i = 0; i < nodeList.getLength(); i++ ){
				Node node = nodeList.item(i);
				String value = node.getAttributes().getNamedItem("extension").getNodeValue();
				for ( String key: nodeListMap.keySet() ){
					if ( key.endsWith("vistaId") && !value.contains( "^PI^200ESR" )  ) {
						int ndx = value.indexOf("^PI^");
						if ( ndx < 0 ) continue;
						int ndx2 = value.indexOf("^USVHA^");
						if ( ndx2 < 0 ) continue;
						String vistaGrpId = value.substring(ndx+4, ndx2);
						if ( !Validator.isDigit(vistaGrpId.charAt(vistaGrpId.length()-1)) ) continue;
						try {
							if ( CaretUtil.isVistaGroupValidate() && 
									CaretLocalServiceUtil.getFacilityByNumber( vistaGrpId ) == null ) continue;
						} catch (ApplicationWorkFlowException e) {
							_log.error(vistaGrpId + ":" + e.getMessage() ); continue;
						}
						vistaMap.put( vistaGrpId, value.substring(0, ndx) );
					} else if ( value.contains( nodeListMap.get(key) ) && !key.endsWith("vistaId") ){
						personMap.put( key.substring(9), value.substring(0, value.indexOf('^')) );
						_log.info( "Person "+ key + " Value: " + value );
					}
				}
			}
			personMap.put( "vistaId", vistaMap.toString() );
			_log.info( "Person NodeList_vistaId Value: " + vistaMap.toString() );
		} catch (XPathExpressionException e) {
			e.printStackTrace();
		}
	}
	
	protected Object normalize( String key, String value ){
		if ( Toolbox.isEmpty(value) ) return StringPool.BLANK;
		if ( CaretStrPool.FIRSTNAME.equals( key  ) ||
			CaretStrPool.LASTNAME.equals( key  ) || 
			CaretStrPool.MIDDLENAME.equals( key  ) ||
			CaretStrPool.CITY.equals( key  ) ||
			CaretStrPool.ADDRESS2.equals( key ) || 
			CaretStrPool.ADDRESS.equals( key  ) ){
			value = StringUtil.capitalize(value.toLowerCase());
		} else if ( CaretStrPool.BIRTHDATE.equals( key ) ){
			value = Toolbox.formatDateCprs( Toolbox.parseOrientDate(value) );
		} else if ( CaretStrPool.PHONE.equals(key) ){
			value = Toolbox.parsePhone( value );
		}
		return value;
	}
	
	protected Map<String,Object> optimizeSearchParams( Map<String,Object> map ){
		Map<String,Object> optimized = new HashMap<String,Object>();
		for ( String key: map.keySet() ){
			optimized.put( key, join( map, key ) );
		}
		optimized.put( MviOptionalXmlParams.searchName.name(), 
				join( map, MviOptionalXmlParams.searchName.name(), MviOptionalXmlParams.searchLastName.name(), MviOptionalXmlParams.searchFirstName.name(), MviOptionalXmlParams.searchMiddleName.name(), MviOptionalXmlParams.searchSuffix.name() ) );
		optimized.put( MviOptionalXmlParams.searchAddress.name(), 
				join( map, MviOptionalXmlParams.searchAddress.name(), MviOptionalXmlParams.searchStreet.name(), MviOptionalXmlParams.searchCity.name(), MviOptionalXmlParams.searchZip.name(), MviOptionalXmlParams.searchState.name() ) );
		
		return optimized;
	}

	private static String join(Map<String,Object> map, String... keys ) {
		StringBuilder sb = new StringBuilder();
		for ( String key: keys ){
			String val = Toolbox.nullSafe(map.get(key));
			if ( Toolbox.isEmpty(val) ) continue;
			if ( !val.trim().isEmpty() ){
				sb.append( MviOptionalXmlParams.myValueOf(key, val )  );
			}
		}
		String ret;
		if ( keys.length > 1 ){
			ret = MviOptionalXmlParams.myValueOf( keys[0], sb.toString() );
		} else {
			ret = sb.toString();
		}
		return ret;
	}
	
	protected enum MviOptionalXmlParams {
		searchFirstName("<given>%s</given>"),
		searchMiddleName("<given>%s</given>"),
		searchLastName("<family>%s</family>"),
		searchSuffix("<suffix>%s</suffix>"),
		searchStreet("<streetAddressLine>%s</streetAddressLine>"),
		searchCity("<city>%s</city>"),
		searchState("<state>%s</state>"),
		searchZip("<postalCode>%s</postalCode>"),
		
		searchName("<livingSubjectName><value use=\"L\">%s</value><semanticsText>LivingSubject.name</semanticsText></livingSubjectName>"),
		searchAddress("<patientAddress><value use=\"PHYS\">%s</value><semanticsText>LivingSubject.address</semanticsText></patientAddress>"),
		
		searchPhone("<patientTelecom><value value=\"%s\"/><semanticsText>LivingSubject.telecom</semanticsText></patientTelecom>"),
		searchBirthday("<livingSubjectBirthTime><value value=\"%s\" /><semanticsText>LivingSubject.birthTime</semanticsText></livingSubjectBirthTime>"),
		searchGender("<livingSubjectAdministrativeGender><value code=\"%s\"></value><semanticsText>LivingSubject.administrativeGender</semanticsText></livingSubjectAdministrativeGender>"),
		searchSsn("<livingSubjectId><value root=\"2.16.840.1.113883.4.1\" extension=\"%s\" /><semanticsText>LivingSubject.SSN</semanticsText></livingSubjectId>");

		String xml;
		MviOptionalXmlParams(String xml) {
			this.xml = xml;
		}
		
		static String myValueOf( String name, String value ){
			if ( value == null || value.isEmpty() ){
				return StringPool.BLANK;
			}
			try{
				MviOptionalXmlParams mviXml = valueOf(name);
				return String.format(mviXml.xml, value);
			} catch ( java.lang.IllegalArgumentException ex ){
				return value;
			}
		}
	}
}
