package gov.va.iam;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import gov.va.iam.esig.dss.AddUserFailedException_Exception;
import gov.va.iam.esig.dss.ESigDSS;
import gov.va.iam.esig.dss.ESigDSSService;
import gov.va.iam.esig.dss.Exception_Exception;
import gov.va.iam.esig.dss.SignFailedException_Exception;
import gov.va.iam.esig.dss.UnsupportedFileTypeException_Exception;
import gov.va.oit.oed.DNS .AttendedService;
import gov.va.oit.oed.DNS .UnattendedService;

public class IamService {

	public final static String appId = "200CARE";
	final static String reason = "Approve";
	final static String fileName = "10-10CG.pdf";
	
	private IamService(){}
	
	private static ESigDSS getEsigPort(){
		return new ESigDSSService().getESigDSSPort();
	}
	
	public static String verifyPdf(byte[] file, String userId) throws Exception_Exception{
		return getEsigPort().verify(appId, fileName, file, userId);
	}
	
	public static byte[] signPdf(String userid, String commonname, String email, byte[] file, String signField, String gmtoffset )
					throws Exception_Exception, AddUserFailedException_Exception, SignFailedException_Exception, UnsupportedFileTypeException_Exception{
		return getEsigPort().sign(userid, commonname, email, appId, fileName, file, reason, gmtoffset, null, null, null, null, null, signField );
	}
	
	public static void testMvi(){
		try {
			new UnattendedService().testMvi();
		} catch (IOException | ParserConfigurationException | SAXException | TransformerException e) {
			e.printStackTrace();
		}
	}

	public static Map<String,Object> searchUnattended(Map<String, Object> map) {
		try {
			return new UnattendedService().searchUnattended(map);
		} catch (IOException | ParserConfigurationException | SAXException | TransformerException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public static List<Map<String,Object>> searchAttended(Map<String, Object> map) {
		try {
			return new AttendedService().searchAttended(map);
		} catch (IOException | ParserConfigurationException | SAXException | TransformerException e) {
			e.printStackTrace();
		}
		return null;
	}
}
