package gov.va.caret.workflow;

import com.liferay.portal.kernel.util.StringPool;

import gov.va.caret.util.CaretStrPool;

public enum QueAction {
		//generic actions per queue and subsequent queue in workflow
		REVIEW_CG_APPROVAL( 10, "VENDOR_Q"  ),
		REVIEW_CG_APPROVAL_WITH_STIPEND_ERRORS( 20, "VENDOR_Q", "with-stipend-related-errors" ),
		APPLICATION_CORRECTION_REQUEST ( 30, "CORRECTION_Q", "rejected-state" ),
		
		TRIAGE_PENDING(35, "REVIEW_Q"),
		REVIEW_VENDOR( 40, "VENDOR_Q"  ),
		REVIEW_VENDOR_COMPLETE ( 45, "VERIFIED_COMPLETED_Q" ),
		REVIEW_VENDORIZATION_COMPLETE( 50, "VERIFY_Q"  ),
		REVIEW_INPUT_PENDING(55, "VENDOR_Q"),
		REJECT_TO_REVIEW_QUEUE( 60, "REVIEW_Q", "with-stipend-related-errors" ), //sends to Review Queue marked as with stipend related errors
		REJECT_TO_VENDOR_QUEUE( 70, "VENDOR_Q", "rejected-state"),
		
		VERIFIED ( 80, "VERIFIED_COMPLETED_Q" ),
		
//		VERIFY_REJECT_REVIEW( "REVIEW_Q", "rejected-state" ),
		
		SUPER_VERIFY ( 90, "VERIFY_Q" ),
		SUPER_VENDOR ( 100, "VENDOR_Q" ),
		SUPER_REVIEW ( 110, "REVIEW_Q" ), 
		SUPER_CORRECTION_NEEDED ( 120, "SUPERVISOR_Q" ),
//		STIPEND ( "CORRECTION_Q" ),
		
		ESCALATE( 120, "SUPERVISOR_Q" ), 
		VERIFIED_APPROVED_FOR_PAYMENT ( 130, "SUPERVISOR_Q"),
		
		REJ_PPW_INITIATED( 140, "REJ_PAY_Q" ),
		REJ_PPW_VERIFIED( 150, "REJ_PAY_Q" ),
		PPW_HOLD_REMOVED( 160, "REJ_PAY_Q" ),
		MOVE_TO_HELD_QUEUE( 165, "HELD_PAYMENT_Q" ),
		PPW_CORRECTED( 170, "VERIFIED_COMPLETED_Q" ),  //Vendor is moved back into normal payment, and any lump sum payments queued

		//Lost Check, OCC Lead & Super
		PPW_INITIATED_60( 180, "REJ_PAY_Q" ),
		
		REVIEWED_WITH_STIPEND_ERRORS( 190, "VERIFY_Q", "with-stipend-related-errors" ), //sends to Verify Queue marked as with stipend related errors
		
		VCG_CORRECTION_NEEDED( 200, "CORRECTION_Q" ),  //Address change?
		COMPLETE_INFO_CHANGE( 210, "CHAMPVA_Q" ),
		
		REVIEW_VENDOR_UPDATE_COMPLETE( 220, "VERIFY_Q" ), //FMS manual process; Vendor update complete (sends to Verify queue)
		VENDOR_CSC_REJECT( 325, "CORRECTION_Q" ),
		
//		VCG_INFO_CHANGE_REVIEWED( "VERIFY_Q" ), //FMS manual process; Vendor update complete (sends to Verify queue)
		
		CHAMP_VERIFY( 230, "VERIFIED_COMPLETED_Q" ),  //? Is this correct?
		CANNOT_VERIFY( 235, "CANNOT_VERIFY_Q"),
		
		TC_COMPLETE( 240, "VERIFIED_COMPLETED_Q" ), //? Is this correct?
		TC_CORRECTION_REQUEST( 250, "CORRECTION_Q" ),
		
		REVOKE_COMPLETE( 260, "VERIFIED_COMPLETED_Q" ), //? Is this correct?
		REVOKE_CORRECTION_REQUEST( 270, "CORRECTION_Q" ),
		
		SEND_TO_CHAMP_VA( 280, "CHAMPVA_Q" ),
		GT_35K_SEND_TO_SUPERVISOR_Q( 290, "SUPERVISOR_Q"),
		GT_35K_SUPERVISOR_VERIFIED ( 300, "CHAMPVA_Q" ),
		
		REINSTATE_COMPLETE( 310, "VERIFIED_COMPLETED_Q" ), //? Is this correct?
		REINSTATE_CSC_REJECT( 320, "CORRECTION_Q" ),
		
		INSURANCE_COMPLETE( 330, "VERIFIED_COMPLETED_Q" ),
		
		HOLD_REMOVED( 400, "VERIFIED_COMPLETED_Q" ),
		HOLD_PPW_INITIATED( 410, "HELD_PAYMENT_Q" ),
		HOLD_PPW_VERIFIED_COMPLETE( 420, "VERIFIED_COMPLETED_Q" ),
		
		VERIFY_RECOUPMENT( 500, "CONSIDERATION_Q" ),
		RECOUPMENT_COMPLETE( 505, "VERIFIED_COMPLETED_Q" ),
		COMPLETE_DUPLICATE_PAYMENT( 510, "STIPEND_PAYMENT_Q" ),
		
		REJECT_DUPLICATE_PAYMENT( 525, "UNKNOWN_Q" ),
		
		LC_PPW_INITIATED( 530, "LOST_CK_Q" ),
		LC_PPW_VERIFIED( 535, "LOST_CK_Q" ),
		PPW_INITIATED_60_REMINDER( 540, "LOST_CK_Q" ),
		REISSUE_COMPLETE( 550, "VERIFIED_COMPLETED_Q" ),
		AFTER_REMINDER_30( 560, "LOST_CK_Q" ),
		TCIS_MONITORING_COMPLETED_60( 570, "LOST_CK_Q" ),
		TCIS_MONITORING_COMPLETED_90( 580, "LOST_CK_Q" ),
		LC_COMPLETE( 585, "VERIFIED_COMPLETED_Q"), //close work
		
		CORRECTED_PAYMENT( 590, "VERIFIED_COMPLETED_Q"), //close work
		
		INS_REVIEW( 600, "PRIM_HEALTH_INS_Q"), //health insurance
		
		BEGIN_CONSIDERATION( 610, "RECOUPMENT_Q"),
		
		TC_REVIEW_VERIFY( 620, "TIER_MOD_Q"),
		REINSTATE_PENDING( 625, "PRIM_REINST_Q"),
		REINSTATE_REVIEW_VERIFY( 630, "PRIM_REINST_Q"),
		REVOKE_REVIEW_VERIFY( 640, "PRIM_REVOKE_Q"),
		DUP_REVIEW( 650, "DUPL_PAY_Q"),
		
		SUPER_APPROVE_PAYMENT( 660, "VERIFIED_COMPLETED_Q" ),
		
		CORRECTION_RESOLVED_COMPLETE( 670, "SELF_Q", CaretStrPool.PENDING ),
		CORRECTION_IN_PROGRESS( 680, "SELF_Q"),
		CORRECTION_CANCELLED( 690, "SELF_Q", CaretStrPool.PENDING );
		

		String nextQueue;
		String workMarkation = StringPool.BLANK;
		int actionId;
		
		QueAction( int actionId, String nextQueue ){
			this.nextQueue = nextQueue;
			this.actionId = actionId;
		}
		
		QueAction( int actionId, String nextQueue, String workMarkation ){
			this.nextQueue = nextQueue;
			this.workMarkation = workMarkation;
			this.actionId = actionId;
		}

		public String getNextQueue() {
			return nextQueue;
		}

		public String getWorkMarkation() {
			return workMarkation;
		}

		public int getActionId() {
			return actionId;
		}
		
	}