package gov.va.caret.workflow;

import java.util.Arrays;
import java.util.List;


public enum OwnerQueue{
	
	/*
	 * APP_DELAY ( 5l ),
		ASSIGN_GENERAL ( 10l ),
		CAREGIVER_INFO(20l),
		CREATE_VCG ( 30l ),
		CUSTOM_NOTE ( 40l ),
		DISPOSITION ( 50l ),
		PROFILE_UPDATE ( 60l ),
		REFERRAL ( 70l ),
		TIER_UPDATE ( 80l ),
		TRANSFER ( 90l ), 
		OCC_REVIEW_1 ( 100l );
		
					
	 * 
	 */
		TRANSFER_COMPLETED_WORK ( 67 ), //this is coming back from CSC...
		
		CORRECTION_Q ( 105, QueAction.CORRECTION_RESOLVED_COMPLETE, QueAction.CORRECTION_IN_PROGRESS, QueAction.CORRECTION_CANCELLED ),  //this queue is on CSC dashboard
		
		MY_CSC_Q ( 110 ), //this is coming back from CSC...
		
		SUPERVISOR_Q ( 200, QueAction.SUPER_VERIFY, QueAction.SUPER_VENDOR, QueAction.SUPER_REVIEW, QueAction.SUPER_CORRECTION_NEEDED ),
		CHAMPVA_Q ( 300, QueAction.CHAMP_VERIFY, QueAction.CANNOT_VERIFY ),  //(send back to CBOPC Lead role, which queue?????)
		
		VCG_INFO_MOD_Q ( 400, QueAction.REVIEWED_WITH_STIPEND_ERRORS, QueAction.VCG_CORRECTION_NEEDED, QueAction.ESCALATE, QueAction.COMPLETE_INFO_CHANGE ), //address, phone number, any needed SSN correction, name change (if needed), and/or any other required change
		PRIM_HEALTH_INS_Q ( 420, QueAction.INS_REVIEW, QueAction.INSURANCE_COMPLETE ),
		TIER_MOD_Q( 450, QueAction.TC_REVIEW_VERIFY, QueAction.TC_COMPLETE, QueAction.TC_CORRECTION_REQUEST, QueAction.ESCALATE ),

		REVIEW_Q ( 500, QueAction.REVIEW_CG_APPROVAL, QueAction.REVIEW_CG_APPROVAL_WITH_STIPEND_ERRORS, QueAction.APPLICATION_CORRECTION_REQUEST, QueAction.ESCALATE ),
		VENDOR_Q ( 600, QueAction.REVIEW_VENDOR, QueAction.REVIEW_VENDORIZATION_COMPLETE, QueAction.REVIEWED_WITH_STIPEND_ERRORS, QueAction.REJECT_TO_REVIEW_QUEUE, QueAction.ESCALATE ),
		VENDOR_Q2 ( 610, QueAction.REVIEW_VENDOR_COMPLETE, QueAction.VENDOR_CSC_REJECT ),
		VERIFY_Q( 700, QueAction.VERIFIED, QueAction.APPLICATION_CORRECTION_REQUEST, QueAction.REJECT_TO_VENDOR_QUEUE, QueAction.REJECT_TO_REVIEW_QUEUE, QueAction.ESCALATE ),
		
		
		
		PRIM_REVOKE_Q( 800, QueAction.REVOKE_REVIEW_VERIFY, QueAction.REVOKE_COMPLETE, QueAction.REVOKE_CORRECTION_REQUEST, QueAction.ESCALATE ),
		PRIM_REINST_Q( 850, QueAction.REINSTATE_COMPLETE, QueAction.REINSTATE_CSC_REJECT, QueAction.ESCALATE, QueAction.BEGIN_CONSIDERATION, QueAction.REINSTATE_REVIEW_VERIFY ),//Send work item to Consideration queue 
		
		
		STIPEND_PAYMENT_Q(900), //P
		REJ_PAY_Q ( 910, QueAction.CORRECTED_PAYMENT, QueAction.REJ_PPW_INITIATED,
				QueAction.PPW_INITIATED_60, QueAction.PPW_CORRECTED, QueAction.PPW_HOLD_REMOVED,  
				QueAction.REJ_PPW_VERIFIED, QueAction.MOVE_TO_HELD_QUEUE ),

		RECOUPMENT_Q( 930, QueAction.VERIFY_RECOUPMENT, QueAction.ESCALATE ),   
		CONSIDERATION_Q( 935, QueAction.RECOUPMENT_COMPLETE, QueAction.ESCALATE ),
		LOST_CK_Q( 940, QueAction.LC_PPW_INITIATED,
						QueAction.LC_PPW_VERIFIED, // Paperwork Initiated, 
						// QueAction.AFTER_REMINDER_30, // Reissue Completed, 30 days after reminder,
						// QueAction.PPW_INITIATED_60_REMINDER,  // Paperwork Initiated-60 day reminder, 
						QueAction.TCIS_MONITORING_COMPLETED_60, // 60 day TCIS monitoring completed Paperwork Verified, 
						// QueAction.TCIS_MONITORING_COMPLETED_90,  // 90 day TCIS monitoring completed  Close Work Item
						QueAction.REISSUE_COMPLETE,
						QueAction.LC_COMPLETE,
						QueAction.ESCALATE ),   //		 
		

		
		
		DUPL_PAY_Q( 950, QueAction.DUP_REVIEW, QueAction.COMPLETE_DUPLICATE_PAYMENT, QueAction.REJECT_DUPLICATE_PAYMENT, QueAction.ESCALATE ),
		HELD_PAYMENT_Q( 960, QueAction.HOLD_PPW_INITIATED, QueAction.HOLD_PPW_VERIFIED_COMPLETE ),
		
		CANNOT_VERIFY_Q ( 1000 ),
		
		SELF_Q(-1),
		UNKNOWN_Q(-1),
		
		VERIFIED_COMPLETED_Q(1100); //closes out the work item
		
		public List<QueAction> queueAction;
		public long queueId;
		OwnerQueue( long queId, QueAction... queAction ){
			this.queueId = queId;
			this.queueAction = Arrays.asList(queAction);
		}
		
		public long getQueueId(){
			return queueId;
		}
		
		public List<QueAction> getActions (){
			return queueAction;
		}
		
		public static OwnerQueue getOwnerQue ( long queueId ){
			for ( OwnerQueue oq : OwnerQueue.values() ){
				if ( oq.getQueueId() == queueId ){
					return oq;
				}
			}
			return null;
		}
	}