 package gov.va.caret.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.portlet.PortletRequest;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.support.ApplicationStatus;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.VcgApplication;
import gov.va.caret.model.support.VcgSupport;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.service.VcgLocalServiceUtil;

public class OnlineUtil {

	private static Log _log = LogFactoryUtil.getLog( OnlineUtil.class );
	
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static List myCaregivers ( List<Map<String, Object>> applications, PortletRequest request ) throws ApplicationWorkFlowException {
		
		if ( applications.isEmpty() ){
			return Collections.EMPTY_LIST;
		}
		List returnList = new ArrayList<Map>();
		ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
		for ( Map<String, Object> appFields : applications ){
			BigDecimal vcgAnId = (BigDecimal) appFields.get( CaretStrPool.NDX0 );
			VcgApplication vcgApp = null;
			VcgSupport vcg = null;
			try {
				vcgApp = new VcgApplication( VcgAnLocalServiceUtil.getVcgAn( vcgAnId.longValue() ));
				if ( vcgApp.getVcgId() > 0 ){
					vcg = new VcgSupport( VcgLocalServiceUtil.getVcg( vcgApp.getVcgId() ) );
				}
			} catch (PortalException e) {
				throw new ApplicationWorkFlowException(e);
			} catch (SystemException e) {
				throw new ApplicationWorkFlowException(e);
			}
			if ( CaretStrPool.INVALID.equals( appFields.get(CaretStrPool.NDX4) ) || CaretStrPool.DUPLICATE_APPLICATION.equals( appFields.get(CaretStrPool.NDX4) ) ) {
				continue;
			}
			long primaryId = Toolbox.getLong(appFields,CaretStrPool.NDX11);
			if ( primaryId > 0 ){
				Object primarySignDate;
				String primarySigned = StringPool.BLANK;
				if ( ApplicationStatus.CANCELLED.name().equals( vcgApp.getStatus() ) ){
					primarySigned = ApplicationStatus.CANCELLED.name();
					primarySignDate = StringPool.BLANK;
				} else if ( appFields.get(CaretStrPool.NDX8) == StringPool.BLANK && Toolbox.isEmpty( appFields.get(CaretStrPool.NDX19).toString() )){
					primarySigned = CaretStrPool.NEED_SIGNATURE;
					primarySignDate = StringPool.BLANK;
				} else {
				if ( vcgApp.isInvalidPrimary() || ( vcg != null && vcg.getPrimaryInitDispDate() != null ) ){
						primarySigned = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.DECISION_MADE.name() );
					} else if ( vcg != null ){
						primarySigned = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.IN_REVIEW.name() ); 
					} else if (  Toolbox.isEmpty( appFields.get(CaretStrPool.NDX19).toString() ) || !Toolbox.isEmpty( String.valueOf(appFields.get(CaretStrPool.NDX8)) ) ) {
						primarySigned = CaretStrPool.SIGNED;
					}
					
					primarySignDate = appFields.get(CaretStrPool.NDX8);
				}
				
				
				returnList.add( Toolbox.getMap( CaretStrPool.PRIMARY, appFields.get(CaretStrPool.NDX1),
						primarySigned, primarySignDate, vcgAnId ) );
			}
			
			long secondaryId = Toolbox.getLong(appFields,CaretStrPool.NDX12);
			if ( secondaryId > 0 ){
				Object secondarySignDate;
				String secondarySigned = StringPool.BLANK;
				if ( ApplicationStatus.CANCELLED.name().equals( vcgApp.getStatus() ) ){
					secondarySigned = ApplicationStatus.CANCELLED.name();
					secondarySignDate = StringPool.BLANK;
				} else if ( appFields.get(CaretStrPool.NDX9) == StringPool.BLANK && Toolbox.isEmpty( appFields.get(CaretStrPool.NDX19).toString() ) ){
					secondarySigned = CaretStrPool.NEED_SIGNATURE;
					secondarySignDate = StringPool.BLANK;
				} else {
					if ( vcgApp.isInvalidSecondary() || ( vcg != null && vcg.getSecondaryInitDispDate() != null ) ){
						secondarySigned = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.DECISION_MADE.name() );
					} else if ( vcg != null ){
						secondarySigned = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.IN_REVIEW.name() ); 
					} else if ( Toolbox.isEmpty( appFields.get(CaretStrPool.NDX19).toString() ) || !Toolbox.isEmpty( String.valueOf(appFields.get(CaretStrPool.NDX9)) ) ) {
						secondarySigned = CaretStrPool.SIGNED;
					}
					
					secondarySignDate = appFields.get(CaretStrPool.NDX9);
				}
				returnList.add( Toolbox.getMap( CaretStrPool.SECONDARY, appFields.get(CaretStrPool.NDX2),
						secondarySigned, secondarySignDate, vcgAnId ) );
			}
			
			long secondaryTwoId = Toolbox.getLong(appFields,CaretStrPool.NDX13);
			if ( secondaryTwoId > 0 ){ 
				Object secondaryTwoSignDate;
				String secondaryTwoSigned = StringPool.BLANK;
				if ( ApplicationStatus.CANCELLED.name().equals( vcgApp.getStatus() ) ){
					secondaryTwoSigned = ApplicationStatus.CANCELLED.name();
					secondaryTwoSignDate = StringPool.BLANK;
				} else if ( appFields.get(CaretStrPool.NDX10) == StringPool.BLANK && Toolbox.isEmpty( appFields.get(CaretStrPool.NDX19).toString() ) ){
					secondaryTwoSigned = CaretStrPool.NEED_SIGNATURE;
					secondaryTwoSignDate = StringPool.BLANK;
				} else {
					if ( vcgApp.isInvalidSecondaryTwo() || ( vcg != null && vcg.getSecondaryTwoInitDispDate() != null ) ){
						secondaryTwoSigned = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.DECISION_MADE.name() );
					} else if ( vcg != null ){
						secondaryTwoSigned = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.IN_REVIEW.name() ); 
					} else if (  Toolbox.isEmpty( appFields.get(CaretStrPool.NDX19).toString() ) || !Toolbox.isEmpty( String.valueOf(appFields.get(CaretStrPool.NDX10)) ) ){
						secondaryTwoSigned = CaretStrPool.SIGNED;
					}
					
					secondaryTwoSignDate = appFields.get(CaretStrPool.NDX10);
				}
				returnList.add( Toolbox.getMap( CaretStrPool.SECONDARYTWO, appFields.get(CaretStrPool.NDX3),
						secondaryTwoSigned, secondaryTwoSignDate, vcgAnId ) );
			}
		}
		return returnList;
	}
	

	public static boolean isRevision(Person formPerson, Person vcgPerson) {
		boolean isRevision = false;
		if ( !formPerson.getLastName().equals( vcgPerson.getLastName() ) ||
				!formPerson.getFirstName().equals( vcgPerson.getFirstName() ) ){
			_log.info("Last name change");
			isRevision = true;
		}
		if ( !Toolbox.isEmpty( formPerson.getMiddleName() ) &&  !formPerson.getMiddleName().equals( vcgPerson.getMiddleName() ) ) {
			_log.info("Updates to Person Middle Name");
			isRevision = true;
		}
		if ( ( ! formPerson.getAddress().equals( vcgPerson.getAddress() ) || !formPerson.getCity().equals( vcgPerson.getCity() ) ||
				! formPerson.getZip().equals( vcgPerson.getZip() ) || ! formPerson.getState().equals( vcgPerson.getState() ) ) ){
			_log.info("Updates to Person Address");
			isRevision = true;
		}
		if ( !Toolbox.isEmpty( formPerson.getSsn() ) && !formPerson.getSsn().equals( vcgPerson.getSsn() ) ) {
			_log.info("Updates to Person SSN");
			isRevision = true;
		}
		if ( formPerson.getBirthDate() != null && !formPerson.getBirthDate().equals( vcgPerson.getBirthDate() ) ) {
			 _log.info("Updates to Person Birthdate");
			 isRevision = true;
		}
		if ( formPerson.getRole() == Person.Role.VETERAN && formPerson.getGroupId() != vcgPerson.getGroupId() ) {
			_log.info("Veteran Facility Change");
			isRevision = true;
		}

		if ( !Toolbox.isEmpty( formPerson.getGender() ) && ! formPerson.getGender().equals( vcgPerson.getGender() ) ) {
			_log.info("Updates to Person Gender");
			isRevision = true;
		}
		
		if ( formPerson.getRole() == Person.Role.PRIMARY ){
			if ( !formPerson.getOtherHealthInsurance().equals( vcgPerson.getOtherHealthInsurance() ) ) {
				_log.info("Updates to Person Medicare/Medicaid enrollment");
				isRevision = true;
			} 
		}

		if ( !isRevision ){
			vcgPerson.setPhone( formPerson.getPhone() );
			vcgPerson.setPhone2( formPerson.getPhone2() );
			vcgPerson.setEmail( formPerson.getEmail() );
		} else {
			formPerson.setStatus( CaretStrPool.ONLINE_REVISION );
			formPerson.setUserId( vcgPerson.getRootUserId() );
			formPerson.setVistaId( vcgPerson.getVistaId() );
			formPerson.setEeId( vcgPerson.getEeId() );
			formPerson.setICN( vcgPerson.getICN() );
			formPerson.setExternalId( vcgPerson.getExternalId() );
		}
		return isRevision;
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static List myVeterans(List<Long> persnRevisionIds, List<Map<String, Object>>[] listArr, PortletRequest request ) throws ApplicationWorkFlowException {
		List<Map<String, Object>> list = listArr[0];
		List<Map<String, Object>> update = new ArrayList<Map<String, Object>>();
		if ( list.isEmpty() ){
			return Collections.EMPTY_LIST;
		}
		List returnList = new ArrayList<Map>();
		ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
		for ( Map<String, Object> map : list ){
			VcgApplication vcgApp = null;
			VcgSupport vcg = null;
			try {
				vcgApp = new VcgApplication( VcgAnLocalServiceUtil.getVcgAn( Toolbox.getLong(map,CaretStrPool.NDX0) ));
				if ( vcgApp.getVcgId() > 0 ){
					vcg = new VcgSupport( VcgLocalServiceUtil.getVcg( vcgApp.getVcgId() ) );
				}
			} catch (PortalException e) {
				throw new ApplicationWorkFlowException(e);
			} catch (SystemException e) {
				throw new ApplicationWorkFlowException(e);
			}
			String status = StringPool.BLANK;
			Object signDate;
			// Primary Cg
			if ( map.get(CaretStrPool.NDX11) != StringPool.BLANK  && persnRevisionIds.contains( Toolbox.getLong(map,CaretStrPool.NDX11) ) ){
				if ( ApplicationStatus.CANCELLED.name().equals( vcgApp.getStatus() ) ){
					status = ApplicationStatus.CANCELLED.name();
					signDate = StringPool.BLANK;
				} else if ( map.get(CaretStrPool.NDX8) == StringPool.BLANK ){
					status = CaretStrPool.NOT_SIGNED;
					signDate = StringPool.BLANK;
				} else {
					if ( vcgApp.isInvalidPrimary() || ( vcg != null && vcg.getPrimaryDispositionDate() != null ) ){
						status = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.DECISION_MADE.name() );
						try {
							if ( PortalUtil.getUserId(request) == new Person ( PersnLocalServiceUtil.getPersn( vcgApp.getPrimaryId() ) ).getRootUserId() ){
								map.put(CaretStrPool.NDX4, status);
							}
						} catch (PortalException e) {
							ApplicationWorkFlowException.handleException(e);
						} catch (SystemException e) {
							ApplicationWorkFlowException.handleException(e);
						}
					} else if ( vcg != null ){
						status = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.IN_REVIEW.name() );
					} else {
						status = CaretStrPool.SIGNED;
					}
					
					signDate = map.get(CaretStrPool.NDX8);
				}
				returnList.add( Toolbox.getMap( CaretStrPool.PRIMARY,
											map.get(CaretStrPool.NDX14),
											status, signDate,
											map.get(CaretStrPool.NDX0) ) );
			
			//Secondary Cg
			} else if ( map.get(CaretStrPool.NDX12) != StringPool.BLANK && persnRevisionIds.contains( Toolbox.getLong(map,CaretStrPool.NDX12) ) ){
				if ( ApplicationStatus.CANCELLED.name().equals( vcgApp.getStatus() ) ){
					status = ApplicationStatus.CANCELLED.name();
					signDate = StringPool.BLANK;
				} else if ( map.get(CaretStrPool.NDX9) == StringPool.BLANK ){
					status = CaretStrPool.NOT_SIGNED;
					signDate = StringPool.BLANK;
				} else {
					if ( vcgApp.isInvalidSecondary() || ( vcg != null && vcg.getSecondaryDispositionDate() != null ) ){
						status = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.DECISION_MADE.name() );
						try {
							if ( PortalUtil.getUserId(request) == new Person ( PersnLocalServiceUtil.getPersn( vcgApp.getSecondaryId() ) ).getRootUserId() ){
								map.put(CaretStrPool.NDX4, status);
							}
						} catch (PortalException e) {
							ApplicationWorkFlowException.handleException(e);
						} catch (SystemException e) {
							ApplicationWorkFlowException.handleException(e);
						}
					} else if ( vcg != null ){
						status = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.IN_REVIEW.name() );
					} else {
						status = CaretStrPool.SIGNED;
					}
					signDate = map.get(CaretStrPool.NDX9);
				}
				returnList.add( 
						Toolbox.getMap( CaretStrPool.SECONDARY,
											map.get(CaretStrPool.NDX14),
											status, signDate,
											map.get(CaretStrPool.NDX0) ) );
			
				//Secondary II
			} else if ( map.get(CaretStrPool.NDX13) != StringPool.BLANK && persnRevisionIds.contains( Toolbox.getLong(map,CaretStrPool.NDX13) ) ){
				if ( ApplicationStatus.CANCELLED.name().equals( vcgApp.getStatus() ) ){
					status = ApplicationStatus.CANCELLED.name();
					signDate = StringPool.BLANK;
				} else if ( map.get(CaretStrPool.NDX10) == StringPool.BLANK ){
					status = CaretStrPool.NOT_SIGNED;
					signDate = StringPool.BLANK;
				} else {
					if ( vcgApp.isInvalidSecondaryTwo() || ( vcg != null && vcg.getSecondaryTwoDispositionDate() != null ) ){
						status = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.DECISION_MADE.name() );
						try {
							if ( PortalUtil.getUserId(request) == new Person ( PersnLocalServiceUtil.getPersn( vcgApp.getSecondaryTwoId() ) ).getRootUserId() ){
								map.put(CaretStrPool.NDX4, status);
							}
						} catch (PortalException e) {
							ApplicationWorkFlowException.handleException(e);
						} catch (SystemException e) {
							ApplicationWorkFlowException.handleException(e);
						}
					} else if ( vcg != null ){
						status = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.IN_REVIEW.name() );
					} else {
						status = CaretStrPool.SIGNED;
					}
					signDate = map.get(CaretStrPool.NDX10);
				}
				returnList.add( Toolbox.getMap( 
											CaretStrPool.SECONDARYTWO,
											map.get(CaretStrPool.NDX14),
											status, signDate,
											map.get(CaretStrPool.NDX0) ) );
			}
			update.add(map);
		}
		listArr[0] = update;
		return returnList;
	}
	
	public static Map<Long,String> getCaregivers ( long siteId, long caregiverRoleId ) throws SystemException, PortalException {
		List<UserGroupRole> caregivers = UserGroupRoleLocalServiceUtil.getUserGroupRolesByGroupAndRole( siteId, caregiverRoleId );
		Map<Long,String> caregiverNames = new HashMap<Long,String>();
		for ( UserGroupRole userGroupRole: caregivers ){
			User u = UserLocalServiceUtil.getUser( userGroupRole.getUserId() );
			caregiverNames.put( userGroupRole.getUserId(), u.getFullName() + StringPool.COMMA_AND_SPACE + u.getEmailAddress() );
		}
		return caregiverNames;
	}
	
}
