package gov.va.caret.util;

import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class DateFormatCprsThreadLocal<T> extends ThreadLocal<T> {
	
	private static final String DATE_FORMAT = "MM/DD/YYYY";
	
	private final Format dateFormat = new SimpleDateFormat(Toolbox.CARET_DATE_FORMAT_CPRS){
		public Object parseObject(String source) throws ParseException {
			if ( DATE_FORMAT.equals( source ) ){
				return null;
			}
			return super.parseObject(source);
		}
	};
	
	protected T initialValue() {
        return (T) dateFormat;
    }
}
