package gov.va.caret.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import com.liferay.mail.service.MailServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.mail.SMTPAccount;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.model.ExpandoTable;
import com.liferay.portlet.expando.model.ExpandoValue;
import com.liferay.portlet.expando.service.ExpandoColumnLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoTableLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoValueLocalServiceUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.dashboard.config.FacilityDashboardConfig;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Facil;
import gov.va.caret.model.Note;
import gov.va.caret.model.Persn;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.impl.BoxGpImpl;
import gov.va.caret.model.impl.NoteImpl;
import gov.va.caret.model.impl.WorImImpl;
import gov.va.caret.model.support.NoteSupport;
import gov.va.caret.model.support.Vendor;
import gov.va.caret.model.support.WorkItemSupport;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.FacilLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.view.CaretParam;
import gov.va.caret.workflow.QueAction;

public class CaretUtil {

	private static Log _log = LogFactoryUtil.getLog( CaretUtil.class ); 
			
	static Map<String,Long> _visnMap = new TreeMap<String,Long>();
	static Map<String,Map<String,Map<String,Long>>> districtMap = null;
	public static boolean isMviEnabled() {
		return StringPool.TRUE.equals( PropsUtil.get( "search.mvi.attended.enabled" ) );
	}
	
	public static boolean isEmailEnabled() {
		return StringPool.TRUE.equals( PropsUtil.get( "email.enabled" ) );
	}
	
	public static boolean isTiuEnabled() {
		return StringPool.TRUE.equals( PropsUtil.get( "tiu.write.service.enabled" ) );
	}
	
	public static String getWsdlDirectory(){
		return PropsUtil.get("wsdl.location");
	}
	
	public static String getEEWsdlocation(){
		return PropsUtil.get("EE.wsdl.location");
	}
	
	public static boolean isTrackerEnabled() {
		return StringPool.TRUE.equals( PropsUtil.get( "form.submit.tracker.enabled" ) );
	}
	
	public static void sendPaymentNotificationMail( Map<String,Object> otherInfo ) { 
		InternetAddress fromAddress = null; 
		InternetAddress toAddress = null; 
			try { 
		  		fromAddress = new InternetAddress("PII                           "); 
		   		toAddress = new InternetAddress("PII                    "); 
		 		MailMessage mailMessage = new MailMessage(); 
		 		mailMessage.setTo(toAddress); 
		 		mailMessage.setFrom(fromAddress); 
		   		mailMessage.setSubject("Testing mail with Plain Text"); 
		  		mailMessage.setBody("This Mail Comes From Liferay Is Easy"); 
		  		MailServiceUtil.sendEmail(mailMessage); 
		 		System.out.println("Send mail with Plain Text"); 
		} catch (AddressException e) { 
		    	e.printStackTrace(); 
		} 
	} 


	public static boolean isValidateUspsAddress ( String userAddress, String userCity, String userState, String userZip, String apt ){
		if ( Toolbox.isEmpty( apt ) ) {
			apt = "<Address1 />";
		} else {
			apt = "<Address1>" + apt + "</Address1>";
		}
	    String urlQuery = "API=Verify&XML=<AddressValidateRequest USERID=\"402VA0000550\"><IncludeOptionalElements>true</IncludeOptionalElements><ReturnCarrierRoute>true</ReturnCarrierRoute><Address ID=\"0\"><FirmName />"+ apt +"<Address2>"+userAddress+"</Address2><City>"+userCity+"</City><State>"+userState+"</State><Zip5>"+userZip+"</Zip5><Zip4></Zip4></Address></AddressValidateRequest>";
	    
	    try{
	        URI uri = new URI(
	                        "http", 
	                        "production.shippingapis.com", 
	                        "/ShippingAPI.dll",
	                        urlQuery,
	                        null);
	        URL url = uri.toURL();
	        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	        DocumentBuilder db = factory.newDocumentBuilder();
	        Document doc = db.parse(url.openStream());
	        doc.getDocumentElement().normalize();
	        NodeList nodeList = doc.getElementsByTagName("Error");
	        if (nodeList != null && nodeList.getLength() > 0) {
	            return false;
	        }
	        return true;
	    } catch (Exception e) {
	        ApplicationWorkFlowException.handleException(e);
	    }
	    return false;
	}

	public static Note createNote(Date now, long chainId, long groupId, long userId,
			String messageString) {
		
		Note note;
		if ( messageString == null ){
			note = null;
			ApplicationWorkFlowException.handleException("CREATE NOTE on EMPTY ");
		} else {
			note = new NoteSupport ( new NoteImpl() );
			note.setCreationDate(now);
			note.setValue( messageString );
			note.setChainId(chainId);
			note.setGroupId(groupId);
			note.setUserId(userId);
		}
		return note;
	}

	public static List<WorIm> createWorkItems ( PortletRequest request, long groupId, BaseModel<?> src, boolean[] changes, long veteranPersnId, long caregiverPersnId ){
		List<WorIm> workItems = new ArrayList<WorIm>();
		Map<WorkType,WorIm> workItemMap = (Map)request.getAttribute("workItemMap");
		if ( workItemMap == null ){
			workItemMap = new HashMap<WorkType,WorIm>();
			request.setAttribute("workItemMap", workItemMap);
		}
		ServiceContext sc = CaretParam.setCaretServiceContext(request);
		WorIm workItem;
		for ( int ndx = 0; ndx < changes.length; ndx++ ){
			if ( changes[ndx] ){
				switch ( ndx ){
				case (0):
					if ( workItemMap.containsKey( WorkType.PII_CHANGE) ) continue;
				workItem = CaretUtil.createWorkItem(sc, groupId, src, WorkType.PII_CHANGE, veteranPersnId, caregiverPersnId);
				workItemMap.put( WorkType.PII_CHANGE, workItem);
					workItems.add ( workItem );
					break;
				case (1):
					if ( workItemMap.containsKey( WorkType.NAME_CHANGE) ) continue;
				workItem = CaretUtil.createWorkItem(sc, groupId, src, WorkType.NAME_CHANGE, veteranPersnId, caregiverPersnId);
				workItemMap.put( WorkType.NAME_CHANGE, workItem);
					workItems.add ( workItem );
					break;
				case (2):
					if ( workItemMap.containsKey( WorkType.INSURANCE_CHANGE) ) continue;
				workItem = CaretUtil.createWorkItem(sc, groupId, src, WorkType.INSURANCE_CHANGE, veteranPersnId, caregiverPersnId);
				workItemMap.put( WorkType.INSURANCE_CHANGE, workItem);
					workItems.add ( workItem );
					break;
				case (3):
					if ( workItemMap.containsKey( WorkType.ADDRESS_CHANGE) ) continue;
				workItem = CaretUtil.createWorkItem(sc, groupId, src, WorkType.ADDRESS_CHANGE, veteranPersnId, caregiverPersnId);
				workItemMap.put( WorkType.ADDRESS_CHANGE, workItem);
					workItems.add ( workItem );
					break;
				case (4):
					if ( workItemMap.containsKey( WorkType.FACILITY_CHANGE) ) continue;
				workItem = CaretUtil.createWorkItem(sc, groupId, src, WorkType.FACILITY_CHANGE, veteranPersnId, caregiverPersnId);
				workItemMap.put( WorkType.FACILITY_CHANGE, workItem);
					workItems.add ( workItem );
					break;
				default:
				}
			}
		}
		return workItems;
	}

	public static WorIm createWorkItem ( ServiceContext sc, long groupId, BaseModel<?> src, WorkType type, long veteranPersnId, long caregiverPersnId ){
		return CaretUtil.createWorkItem(sc, groupId, src, veteranPersnId,  type.name(), caregiverPersnId, type.getDueDate( sc.getCreateDate() ) );
	}

	public static WorIm createWorkItem ( ServiceContext sc, long groupId, BaseModel<?> src, long veteranPersnId, String name, long caregiverPersnId, Date dueDate ){
		return CaretUtil.createWorkItem(sc, groupId, PortalUtil.getClassNameId( src.getModelClass() ), (Long)src.getPrimaryKeyObj(), veteranPersnId,  name, caregiverPersnId, dueDate );
	}

	public static WorIm createWorkItem ( ServiceContext sc, long groupId, long srcClassId, long srcPrimaryKey, long veteranPersnId, String name, long caregiverPersnId, Date dueDate ){
		WorIm workItem = new WorImImpl();
		if ( groupId < 1200 ) {
			workItem.setStatus( CaretStrPool.PENDING );
		} else {
			workItem.setStatus( CaretStrPool.NEW );
		}
		workItem.setCreationDate( sc.getCreateDate() );
		workItem.setGroupId( groupId );
		workItem.setClassPk( srcPrimaryKey );
		workItem.setPersnId(veteranPersnId);
		workItem.setCaregiverId(caregiverPersnId);
		workItem.setType( name );
		if ( _log.isInfoEnabled() ){
			_log.info("using DueDate=" + dueDate );
		}
		workItem.setDueDate( dueDate );
		if ( _log.isInfoEnabled() ){
			_log.info("using src.getModelClass()=" + srcClassId );
		}
		workItem.setClassId( srcClassId );
		return workItem;
	}

	public static WorIm createHomeVisitWorkItem ( ServiceContext sc, long groupId, BaseModel<?> src, WorkType type, long veteranPersnId, long caregiverPersnId, long vcgId, Date completionDate){
		WorIm workItem = new WorImImpl();
		workItem.setStatus( CaretStrPool.NEW );
		workItem.setCreationDate( sc.getCreateDate() );
		workItem.setGroupId( groupId );
		workItem.setType( type.name() );
		workItem.setClassPk( (Long)src.getPrimaryKeyObj() );
		workItem.setPersnId(veteranPersnId);
		workItem.setCaregiverId(caregiverPersnId);
		if ( _log.isInfoEnabled() ){
			_log.info("using DueDate=" + type.getBusinessDueDate( completionDate ) );
		}
		workItem.setDueDate( type.getBusinessDueDate( completionDate ) );
		if ( _log.isInfoEnabled() ){
			_log.info("using src.getModelClass()=" + src.getModelClass());
		}
		workItem.setClassId( PortalUtil.getClassNameId( src.getModelClass() ) );
		workItem.setVcgId(vcgId);
		return workItem;
	}

	public static Map<String,Map<String,Map<String,Long>>> getVhaOrgTree( long companyId, boolean includeNumber ) throws ApplicationWorkFlowException {
		
		if ( CaretUtil.districtMap == null ){
			try {
				Organization head = OrganizationLocalServiceUtil.getOrganization( companyId, PortletProps.get(CaretStrPool.HEAD_ORG_NAME) );
				CaretUtil.districtMap = new HashMap<String,Map<String,Map<String,Long>>>();
				for ( Organization district: OrganizationLocalServiceUtil.getOrganizations( companyId, head.getOrganizationId() ) ){
					Map<String,Map<String,Long>> visnMap = new TreeMap<String,Map<String,Long>>();
					CaretUtil.districtMap.put(district.getName(), visnMap );
					for ( Organization visn: OrganizationLocalServiceUtil.getOrganizations( companyId, district.getOrganizationId() ) ){
						Map<String,Long> facilityMap = new TreeMap<String,Long>();
						visnMap.put(visn.getName(), facilityMap );
						CaretUtil._visnMap.put( visn.getName(), visn.getOrganizationId() );
						for ( Organization facility : OrganizationLocalServiceUtil.getOrganizations( companyId, visn.getOrganizationId() ) ){
							Facil facil = FacilLocalServiceUtil.getByOrgId( facility.getPrimaryKey() );
							
							facilityMap.put( includeNumber? facil.getFacilityNumber() + StringPool.COMMA_AND_SPACE + facility.getName() + StringPool.COMMA_AND_SPACE + facil.getLocation() :
								facility.getName(),
									facility.getOrganizationId() );
						}
					}
				}
			} catch (PortalException e) {
				throw new ApplicationWorkFlowException(e);
			} catch (SystemException e) {
				throw new ApplicationWorkFlowException(e);
			}
			
		}
		return CaretUtil.districtMap;
	}

	public static Map<Long, String> getVhaOrgList(PortletRequest actionRequest) throws ApplicationWorkFlowException {
		
		PortletSession psession = actionRequest.getPortletSession();
		Map<Long, String> linked;
		if ( psession.getAttribute(CaretStrPool.VHA_MEMBER) == null ) {
			linked = new LinkedHashMap<Long, String>();
		} else {
			linked = (Map<Long, String>)psession.getAttribute(CaretStrPool.VHA_MEMBER);
		}
		
		FacilityDashboardConfig config = (FacilityDashboardConfig)psession.getAttribute(CaretStrPool.DASHBOARD_CONFIG);
		try {
			Set<Long> groupIds = new HashSet<Long>( config.getGroupId() );
			groupIds.addAll( config.getVisnId() );
			for ( Long groupId : groupIds ){
				Organization org = OrganizationLocalServiceUtil.getOrganization( groupId );
				Facil facil = null;
				if ( !org.getName().toLowerCase().startsWith("visn")) {
					facil = FacilLocalServiceUtil.getByOrgId( org.getOrganizationId() );
				}
				if ( facil == null ){
					// linked.put( 1l, org.getName() );
					for ( Organization subOrg : org.getSuborganizations()){
						facil = FacilLocalServiceUtil.getByOrgId( subOrg.getOrganizationId() );
						linked.put( subOrg.getOrganizationId(), facil.getFacilityNumber() + StringPool.COMMA_AND_SPACE + subOrg.getName() );
					}
				} else {
//					linked.put( facil.getGroupId(), facil.getFacilityNumber() + StringPool.COMMA_AND_SPACE + org.getName() + StringPool.COMMA_AND_SPACE + facil.getLocation() );
					linked.put( facil.getGroupId(), facil.getFacilityNumber() + StringPool.COMMA_AND_SPACE + org.getName() );
				}
			}
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		psession.setAttribute(CaretStrPool.VHA_MEMBER, linked); 
		return linked;
	}

	public static Map<String,Long> getVisnMap(){
		return _visnMap;
	}

	public static String getUserFullName(long userId) {
		try { 
			User user = UserLocalServiceUtil.getUser( userId );
			return user.getLastName() + StringPool.COMMA_AND_SPACE + user.getFirstName();
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return StringPool.BLANK;
	}

	public static String getPersnFullName(long persnId) {
		try { 
			Persn persn = PersnLocalServiceUtil.getPersn( persnId );
			if ( CaretStrPool.UNKNOWN_IDENTITY.equals( persn.getStatus() ) ){
				return CaretStrPool.UNKNOWN_IDENTITY;
			} else {
				return persn.getLastName() + StringPool.COMMA_AND_SPACE + persn.getFirstName();
			}
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return StringPool.BLANK;
	}

	public static String getClinicSite() {
		return PropsUtil.get( "caret.clinic.site" );
	}

	public static String getOnlineSite() {
		return PropsUtil.get( "caret.online.site" );
	}

	public static void initYesNoBoxGp ( String subgroup, String yesNoGroup, List<BoxGp> list, int sequence ) throws ApplicationWorkFlowException{
		BoxGp yesAnswer = new BoxGpImpl();
		yesAnswer.setBoxGroup(yesNoGroup);
		yesAnswer.setBoxSubGroup(subgroup);
		yesAnswer.setLabel(CaretStrPool.YES);
		yesAnswer.setViewSequence(sequence);
		
		BoxGp noAnswer = new BoxGpImpl();
		noAnswer.setBoxGroup(yesNoGroup);
		noAnswer.setBoxSubGroup(subgroup);
		noAnswer.setLabel(CaretStrPool.NO);
		noAnswer.setViewSequence(sequence+1);
		try {
			list.add( BoxGpLocalServiceUtil.addBoxGp(yesAnswer) );
			list.add( BoxGpLocalServiceUtil.addBoxGp(noAnswer) );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public static Vendor vendorUpdate ( PortletRequest request, Vendor vendor ){ //WorkItemSupport work
		try{
			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			String data = request.getParameter("data");
			Map<String,String> map = Toolbox.getUrlQuery(data);
			vendor.setLastName(map.get("_lastName"));
			vendor.setFirstName(map.get("_firstName"));
			vendor.setAddress(map.get("_address"));
			vendor.setCity(map.get("_u_city"));
			vendor.setZip(map.get("_u_zip"));
			vendor.setState(map.get("_u_state"));
			vendor.setTaxId(map.get("_TAXID"));
			vendor.setUserId(sc.getUserId());
			WorkType workType = vendor.getWorkType();
			CaretLocalServiceUtil.save(vendor);
			if ( workType != null ){
				WorIm worIm = ((WorkItemSupport)request.getAttribute("workItem"));
				WorIm wis = createWorkItem( sc, 0, vendor, workType, worIm.getPersnId(), worIm.getCaregiverId() ) ;
				wis.setVcgId(worIm.getVcgId());
				if ( worIm.getUserId() == sc.getUserId() && CAction.canDoCaret(request, CaretCan.CBOPC_VENDOR_Q) ){
					wis.setUserId( sc.getUserId() );
				}
				wis.setClassId( PortalUtil.getClassNameId( VcgAn.class ) );
				wis.setClassPk( worIm.getClassPk() );
				if ( WorkType.VENDOR_CREATE == workType ) {
					wis.setCompletionBy( sc.getUserId() );
					wis.setCompletionDate( sc.getCreateDate() );
					wis.setQueueId( 1100 );
					wis.setStatus( QueAction.REVIEW_VENDOR_COMPLETE.name() );
				} else {
					wis.setQueueId(workType.workName.getQueueId());
				}
				CaretLocalServiceUtil.save( wis );
			}
			return vendor;
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (UnsupportedEncodingException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}

	static List<BoxGp> initBoxGroup( String name, String subName ) throws ApplicationWorkFlowException { 
		String boxGroupValues = PortletProps.get(subName);
		List<BoxGp> groups = BoxGpLocalServiceUtil.getBoxGroups(name, subName);
		String[] labels =  boxGroupValues.split( StringPool.SEMICOLON );
		groups = new ArrayList<BoxGp>();
		int i = 0;
		for ( String label: labels ){
			BoxGp grp = new BoxGpImpl();
			grp.setBoxGroup(name);
			grp.setBoxSubGroup(subName);
			grp.setLabel(label);
			grp.setViewSequence(i++);
			try {
				groups.add( BoxGpLocalServiceUtil.addBoxGp(grp) );
			} catch (SystemException e) {
				throw new ApplicationWorkFlowException(e);
			}
		}
		return groups; 
	}

	public static List<BoxGp> loadBoxGroup ( String name, String subName ) throws ApplicationWorkFlowException {
			
			List<BoxGp> groups = BoxGpLocalServiceUtil.getBoxGroups(name, subName);
			if ( groups.isEmpty() ){
				groups = initBoxGroup(name, subName);
			}
			return groups;
	//		ResultMap.getForm(request).put( subName, groups );
		}

	public static boolean setExpandoValue( BaseModel<?> baseModel, String attributeName, String value ) throws SystemException {
		try {
			if ( Validator.isNotNull( attributeName ) ){
				if ( baseModel.getExpandoBridge().hasAttribute( attributeName ) ) {
//					baseModel.getExpandoBridge().setAttribute( attributeName, value, false );
					setUserCustomFieldValue( (User)baseModel, attributeName, value );
				} else {
					throw new ApplicationWorkFlowException(CaretStrPool.METADATA + " not initialized" );
				}
			}
			return true;
		}catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return false;
	}

	public static String getExpandoValue( ExpandoBridge expandoBridge,	String attributeName ) {
		return CaretUtil.getExpandoValue(expandoBridge, attributeName, false);
	}

	public static String getExpandoValue( ExpandoBridge expandoBridge,
			String attributeName,
			Boolean isSecure ) {
		if ( Validator.isNotNull( attributeName ) && expandoBridge.hasAttribute( attributeName ) ) {
			return (String) expandoBridge.getAttribute( attributeName, isSecure );
		}
		return StringPool.BLANK;
	}
	
	private static void setUserCustomFieldValue ( User user, String field, String value ) throws PortalException, SystemException{
		ExpandoTable table = ExpandoTableLocalServiceUtil.getDefaultTable( user.getCompanyId(), User.class.getName() );
		ExpandoColumn column = ExpandoColumnLocalServiceUtil.getColumn( table.getTableId(), field );
		ExpandoValue expandoValue = ExpandoValueLocalServiceUtil.getValue(table.getTableId(), column.getColumnId(), user.getPrimaryKey());
		if ( expandoValue == null ) {
			ExpandoValueLocalServiceUtil.addValue(user.getCompanyId(), table.getTableId(), column.getColumnId(), user.getPrimaryKey(), value);
		} else {
			expandoValue.setData(value);
			ExpandoValueLocalServiceUtil.updateExpandoValue(expandoValue);
		}
	}

	static List<String> relationshipFamily = 
	ListUtil.toList( PortletProps.get(CaretStrPool.RELATIONSHIP_FAMILY).split(StringPool.COMMA));
	public static boolean isFamily(String individual) {
		return relationshipFamily.contains(individual);
	}

	public static boolean isMockFmsEnabled() {
		return StringPool.TRUE.equals( PropsUtil.get( "mock.fms.enabled" ) );
	}

	public static boolean isVistaGroupValidate() {
		return StringPool.TRUE.equals( PropsUtil.get( "vista.validate.enabled" ) );
	}

}
