package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchZipFyException;
import gov.va.caret.model.ZipFy;
import gov.va.caret.model.impl.ZipFyImpl;
import gov.va.caret.model.impl.ZipFyModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The persistence implementation for the zip fy service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see ZipFyPersistence
 * @see ZipFyUtil
 * @generated
 */
public class ZipFyPersistenceImpl extends BasePersistenceImpl<ZipFy>
    implements ZipFyPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link ZipFyUtil} to access the zip fy persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = ZipFyImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(ZipFyModelImpl.ENTITY_CACHE_ENABLED,
            ZipFyModelImpl.FINDER_CACHE_ENABLED, ZipFyImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(ZipFyModelImpl.ENTITY_CACHE_ENABLED,
            ZipFyModelImpl.FINDER_CACHE_ENABLED, ZipFyImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(ZipFyModelImpl.ENTITY_CACHE_ENABLED,
            ZipFyModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_ZIP = new FinderPath(ZipFyModelImpl.ENTITY_CACHE_ENABLED,
            ZipFyModelImpl.FINDER_CACHE_ENABLED, ZipFyImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByZip",
            new String[] {
                String.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ZIP = new FinderPath(ZipFyModelImpl.ENTITY_CACHE_ENABLED,
            ZipFyModelImpl.FINDER_CACHE_ENABLED, ZipFyImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByZip",
            new String[] { String.class.getName() },
            ZipFyModelImpl.FACILZIP_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_ZIP = new FinderPath(ZipFyModelImpl.ENTITY_CACHE_ENABLED,
            ZipFyModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByZip",
            new String[] { String.class.getName() });
    private static final String _FINDER_COLUMN_ZIP_FACILZIP_1 = "zipFy.facilZip IS NULL";
    private static final String _FINDER_COLUMN_ZIP_FACILZIP_2 = "zipFy.facilZip = ?";
    private static final String _FINDER_COLUMN_ZIP_FACILZIP_3 = "(zipFy.facilZip IS NULL OR zipFy.facilZip = '')";
    private static final String _SQL_SELECT_ZIPFY = "SELECT zipFy FROM ZipFy zipFy";
    private static final String _SQL_SELECT_ZIPFY_WHERE = "SELECT zipFy FROM ZipFy zipFy WHERE ";
    private static final String _SQL_COUNT_ZIPFY = "SELECT COUNT(zipFy) FROM ZipFy zipFy";
    private static final String _SQL_COUNT_ZIPFY_WHERE = "SELECT COUNT(zipFy) FROM ZipFy zipFy WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "zipFy.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ZipFy exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ZipFy exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(ZipFyPersistenceImpl.class);
    private static ZipFy _nullZipFy = new ZipFyImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<ZipFy> toCacheModel() {
                return _nullZipFyCacheModel;
            }
        };

    private static CacheModel<ZipFy> _nullZipFyCacheModel = new CacheModel<ZipFy>() {
            @Override
            public ZipFy toEntityModel() {
                return _nullZipFy;
            }
        };

    public ZipFyPersistenceImpl() {
        setModelClass(ZipFy.class);
    }

    /**
     * Returns all the zip fies where facilZip = &#63;.
     *
     * @param facilZip the facil zip
     * @return the matching zip fies
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<ZipFy> findByZip(String facilZip) throws SystemException {
        return findByZip(facilZip, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the zip fies where facilZip = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ZipFyModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param facilZip the facil zip
     * @param start the lower bound of the range of zip fies
     * @param end the upper bound of the range of zip fies (not inclusive)
     * @return the range of matching zip fies
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<ZipFy> findByZip(String facilZip, int start, int end)
        throws SystemException {
        return findByZip(facilZip, start, end, null);
    }

    /**
     * Returns an ordered range of all the zip fies where facilZip = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ZipFyModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param facilZip the facil zip
     * @param start the lower bound of the range of zip fies
     * @param end the upper bound of the range of zip fies (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching zip fies
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<ZipFy> findByZip(String facilZip, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ZIP;
            finderArgs = new Object[] { facilZip };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_ZIP;
            finderArgs = new Object[] { facilZip, start, end, orderByComparator };
        }

        List<ZipFy> list = (List<ZipFy>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (ZipFy zipFy : list) {
                if (!Validator.equals(facilZip, zipFy.getFacilZip())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_ZIPFY_WHERE);

            boolean bindFacilZip = false;

            if (facilZip == null) {
                query.append(_FINDER_COLUMN_ZIP_FACILZIP_1);
            } else if (facilZip.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_ZIP_FACILZIP_3);
            } else {
                bindFacilZip = true;

                query.append(_FINDER_COLUMN_ZIP_FACILZIP_2);
            }

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(ZipFyModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindFacilZip) {
                    qPos.add(facilZip);
                }

                if (!pagination) {
                    list = (List<ZipFy>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<ZipFy>(list);
                } else {
                    list = (List<ZipFy>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first zip fy in the ordered set where facilZip = &#63;.
     *
     * @param facilZip the facil zip
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching zip fy
     * @throws gov.va.caret.NoSuchZipFyException if a matching zip fy could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ZipFy findByZip_First(String facilZip,
        OrderByComparator orderByComparator)
        throws NoSuchZipFyException, SystemException {
        ZipFy zipFy = fetchByZip_First(facilZip, orderByComparator);

        if (zipFy != null) {
            return zipFy;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("facilZip=");
        msg.append(facilZip);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchZipFyException(msg.toString());
    }

    /**
     * Returns the first zip fy in the ordered set where facilZip = &#63;.
     *
     * @param facilZip the facil zip
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching zip fy, or <code>null</code> if a matching zip fy could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ZipFy fetchByZip_First(String facilZip,
        OrderByComparator orderByComparator) throws SystemException {
        List<ZipFy> list = findByZip(facilZip, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last zip fy in the ordered set where facilZip = &#63;.
     *
     * @param facilZip the facil zip
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching zip fy
     * @throws gov.va.caret.NoSuchZipFyException if a matching zip fy could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ZipFy findByZip_Last(String facilZip,
        OrderByComparator orderByComparator)
        throws NoSuchZipFyException, SystemException {
        ZipFy zipFy = fetchByZip_Last(facilZip, orderByComparator);

        if (zipFy != null) {
            return zipFy;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("facilZip=");
        msg.append(facilZip);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchZipFyException(msg.toString());
    }

    /**
     * Returns the last zip fy in the ordered set where facilZip = &#63;.
     *
     * @param facilZip the facil zip
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching zip fy, or <code>null</code> if a matching zip fy could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ZipFy fetchByZip_Last(String facilZip,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByZip(facilZip);

        if (count == 0) {
            return null;
        }

        List<ZipFy> list = findByZip(facilZip, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the zip fies before and after the current zip fy in the ordered set where facilZip = &#63;.
     *
     * @param zipFyId the primary key of the current zip fy
     * @param facilZip the facil zip
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next zip fy
     * @throws gov.va.caret.NoSuchZipFyException if a zip fy with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ZipFy[] findByZip_PrevAndNext(long zipFyId, String facilZip,
        OrderByComparator orderByComparator)
        throws NoSuchZipFyException, SystemException {
        ZipFy zipFy = findByPrimaryKey(zipFyId);

        Session session = null;

        try {
            session = openSession();

            ZipFy[] array = new ZipFyImpl[3];

            array[0] = getByZip_PrevAndNext(session, zipFy, facilZip,
                    orderByComparator, true);

            array[1] = zipFy;

            array[2] = getByZip_PrevAndNext(session, zipFy, facilZip,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected ZipFy getByZip_PrevAndNext(Session session, ZipFy zipFy,
        String facilZip, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_ZIPFY_WHERE);

        boolean bindFacilZip = false;

        if (facilZip == null) {
            query.append(_FINDER_COLUMN_ZIP_FACILZIP_1);
        } else if (facilZip.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_ZIP_FACILZIP_3);
        } else {
            bindFacilZip = true;

            query.append(_FINDER_COLUMN_ZIP_FACILZIP_2);
        }

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(ZipFyModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        if (bindFacilZip) {
            qPos.add(facilZip);
        }

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(zipFy);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<ZipFy> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the zip fies where facilZip = &#63; from the database.
     *
     * @param facilZip the facil zip
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByZip(String facilZip) throws SystemException {
        for (ZipFy zipFy : findByZip(facilZip, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(zipFy);
        }
    }

    /**
     * Returns the number of zip fies where facilZip = &#63;.
     *
     * @param facilZip the facil zip
     * @return the number of matching zip fies
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByZip(String facilZip) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_ZIP;

        Object[] finderArgs = new Object[] { facilZip };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_ZIPFY_WHERE);

            boolean bindFacilZip = false;

            if (facilZip == null) {
                query.append(_FINDER_COLUMN_ZIP_FACILZIP_1);
            } else if (facilZip.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_ZIP_FACILZIP_3);
            } else {
                bindFacilZip = true;

                query.append(_FINDER_COLUMN_ZIP_FACILZIP_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindFacilZip) {
                    qPos.add(facilZip);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the zip fy in the entity cache if it is enabled.
     *
     * @param zipFy the zip fy
     */
    @Override
    public void cacheResult(ZipFy zipFy) {
        EntityCacheUtil.putResult(ZipFyModelImpl.ENTITY_CACHE_ENABLED,
            ZipFyImpl.class, zipFy.getPrimaryKey(), zipFy);

        zipFy.resetOriginalValues();
    }

    /**
     * Caches the zip fies in the entity cache if it is enabled.
     *
     * @param zipFies the zip fies
     */
    @Override
    public void cacheResult(List<ZipFy> zipFies) {
        for (ZipFy zipFy : zipFies) {
            if (EntityCacheUtil.getResult(ZipFyModelImpl.ENTITY_CACHE_ENABLED,
                        ZipFyImpl.class, zipFy.getPrimaryKey()) == null) {
                cacheResult(zipFy);
            } else {
                zipFy.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all zip fies.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(ZipFyImpl.class.getName());
        }

        EntityCacheUtil.clearCache(ZipFyImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the zip fy.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(ZipFy zipFy) {
        EntityCacheUtil.removeResult(ZipFyModelImpl.ENTITY_CACHE_ENABLED,
            ZipFyImpl.class, zipFy.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<ZipFy> zipFies) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (ZipFy zipFy : zipFies) {
            EntityCacheUtil.removeResult(ZipFyModelImpl.ENTITY_CACHE_ENABLED,
                ZipFyImpl.class, zipFy.getPrimaryKey());
        }
    }

    /**
     * Creates a new zip fy with the primary key. Does not add the zip fy to the database.
     *
     * @param zipFyId the primary key for the new zip fy
     * @return the new zip fy
     */
    @Override
    public ZipFy create(long zipFyId) {
        ZipFy zipFy = new ZipFyImpl();

        zipFy.setNew(true);
        zipFy.setPrimaryKey(zipFyId);

        return zipFy;
    }

    /**
     * Removes the zip fy with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param zipFyId the primary key of the zip fy
     * @return the zip fy that was removed
     * @throws gov.va.caret.NoSuchZipFyException if a zip fy with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ZipFy remove(long zipFyId)
        throws NoSuchZipFyException, SystemException {
        return remove((Serializable) zipFyId);
    }

    /**
     * Removes the zip fy with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the zip fy
     * @return the zip fy that was removed
     * @throws gov.va.caret.NoSuchZipFyException if a zip fy with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ZipFy remove(Serializable primaryKey)
        throws NoSuchZipFyException, SystemException {
        Session session = null;

        try {
            session = openSession();

            ZipFy zipFy = (ZipFy) session.get(ZipFyImpl.class, primaryKey);

            if (zipFy == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchZipFyException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(zipFy);
        } catch (NoSuchZipFyException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected ZipFy removeImpl(ZipFy zipFy) throws SystemException {
        zipFy = toUnwrappedModel(zipFy);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(zipFy)) {
                zipFy = (ZipFy) session.get(ZipFyImpl.class,
                        zipFy.getPrimaryKeyObj());
            }

            if (zipFy != null) {
                session.delete(zipFy);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (zipFy != null) {
            clearCache(zipFy);
        }

        return zipFy;
    }

    @Override
    public ZipFy updateImpl(gov.va.caret.model.ZipFy zipFy)
        throws SystemException {
        zipFy = toUnwrappedModel(zipFy);

        boolean isNew = zipFy.isNew();

        ZipFyModelImpl zipFyModelImpl = (ZipFyModelImpl) zipFy;

        Session session = null;

        try {
            session = openSession();

            if (zipFy.isNew()) {
                session.save(zipFy);

                zipFy.setNew(false);
            } else {
                session.merge(zipFy);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !ZipFyModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((zipFyModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ZIP.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        zipFyModelImpl.getOriginalFacilZip()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_ZIP, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ZIP,
                    args);

                args = new Object[] { zipFyModelImpl.getFacilZip() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_ZIP, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ZIP,
                    args);
            }
        }

        EntityCacheUtil.putResult(ZipFyModelImpl.ENTITY_CACHE_ENABLED,
            ZipFyImpl.class, zipFy.getPrimaryKey(), zipFy);

        return zipFy;
    }

    protected ZipFy toUnwrappedModel(ZipFy zipFy) {
        if (zipFy instanceof ZipFyImpl) {
            return zipFy;
        }

        ZipFyImpl zipFyImpl = new ZipFyImpl();

        zipFyImpl.setNew(zipFy.isNew());
        zipFyImpl.setPrimaryKey(zipFy.getPrimaryKey());

        zipFyImpl.setZipFyId(zipFy.getZipFyId());
        zipFyImpl.setFacilId(zipFy.getFacilId());
        zipFyImpl.setFacilZip(zipFy.getFacilZip());
        zipFyImpl.setDistance(zipFy.getDistance());

        return zipFyImpl;
    }

    /**
     * Returns the zip fy with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the zip fy
     * @return the zip fy
     * @throws gov.va.caret.NoSuchZipFyException if a zip fy with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ZipFy findByPrimaryKey(Serializable primaryKey)
        throws NoSuchZipFyException, SystemException {
        ZipFy zipFy = fetchByPrimaryKey(primaryKey);

        if (zipFy == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchZipFyException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return zipFy;
    }

    /**
     * Returns the zip fy with the primary key or throws a {@link gov.va.caret.NoSuchZipFyException} if it could not be found.
     *
     * @param zipFyId the primary key of the zip fy
     * @return the zip fy
     * @throws gov.va.caret.NoSuchZipFyException if a zip fy with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ZipFy findByPrimaryKey(long zipFyId)
        throws NoSuchZipFyException, SystemException {
        return findByPrimaryKey((Serializable) zipFyId);
    }

    /**
     * Returns the zip fy with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the zip fy
     * @return the zip fy, or <code>null</code> if a zip fy with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ZipFy fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        ZipFy zipFy = (ZipFy) EntityCacheUtil.getResult(ZipFyModelImpl.ENTITY_CACHE_ENABLED,
                ZipFyImpl.class, primaryKey);

        if (zipFy == _nullZipFy) {
            return null;
        }

        if (zipFy == null) {
            Session session = null;

            try {
                session = openSession();

                zipFy = (ZipFy) session.get(ZipFyImpl.class, primaryKey);

                if (zipFy != null) {
                    cacheResult(zipFy);
                } else {
                    EntityCacheUtil.putResult(ZipFyModelImpl.ENTITY_CACHE_ENABLED,
                        ZipFyImpl.class, primaryKey, _nullZipFy);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(ZipFyModelImpl.ENTITY_CACHE_ENABLED,
                    ZipFyImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return zipFy;
    }

    /**
     * Returns the zip fy with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param zipFyId the primary key of the zip fy
     * @return the zip fy, or <code>null</code> if a zip fy with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ZipFy fetchByPrimaryKey(long zipFyId) throws SystemException {
        return fetchByPrimaryKey((Serializable) zipFyId);
    }

    /**
     * Returns all the zip fies.
     *
     * @return the zip fies
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<ZipFy> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the zip fies.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ZipFyModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of zip fies
     * @param end the upper bound of the range of zip fies (not inclusive)
     * @return the range of zip fies
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<ZipFy> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the zip fies.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ZipFyModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of zip fies
     * @param end the upper bound of the range of zip fies (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of zip fies
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<ZipFy> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<ZipFy> list = (List<ZipFy>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_ZIPFY);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_ZIPFY;

                if (pagination) {
                    sql = sql.concat(ZipFyModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<ZipFy>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<ZipFy>(list);
                } else {
                    list = (List<ZipFy>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the zip fies from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (ZipFy zipFy : findAll()) {
            remove(zipFy);
        }
    }

    /**
     * Returns the number of zip fies.
     *
     * @return the number of zip fies
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_ZIPFY);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the zip fy persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.ZipFy")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<ZipFy>> listenersList = new ArrayList<ModelListener<ZipFy>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<ZipFy>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(ZipFyImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
