package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchVetVrException;
import gov.va.caret.model.VetVr;
import gov.va.caret.model.impl.VetVrImpl;
import gov.va.caret.model.impl.VetVrModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The persistence implementation for the vet vr service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see VetVrPersistence
 * @see VetVrUtil
 * @generated
 */
public class VetVrPersistenceImpl extends BasePersistenceImpl<VetVr>
    implements VetVrPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link VetVrUtil} to access the vet vr persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = VetVrImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(VetVrModelImpl.ENTITY_CACHE_ENABLED,
            VetVrModelImpl.FINDER_CACHE_ENABLED, VetVrImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(VetVrModelImpl.ENTITY_CACHE_ENABLED,
            VetVrModelImpl.FINDER_CACHE_ENABLED, VetVrImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(VetVrModelImpl.ENTITY_CACHE_ENABLED,
            VetVrModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    private static final String _SQL_SELECT_VETVR = "SELECT vetVr FROM VetVr vetVr";
    private static final String _SQL_COUNT_VETVR = "SELECT COUNT(vetVr) FROM VetVr vetVr";
    private static final String _ORDER_BY_ENTITY_ALIAS = "vetVr.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No VetVr exists with the primary key ";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(VetVrPersistenceImpl.class);
    private static VetVr _nullVetVr = new VetVrImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<VetVr> toCacheModel() {
                return _nullVetVrCacheModel;
            }
        };

    private static CacheModel<VetVr> _nullVetVrCacheModel = new CacheModel<VetVr>() {
            @Override
            public VetVr toEntityModel() {
                return _nullVetVr;
            }
        };

    public VetVrPersistenceImpl() {
        setModelClass(VetVr.class);
    }

    /**
     * Caches the vet vr in the entity cache if it is enabled.
     *
     * @param vetVr the vet vr
     */
    @Override
    public void cacheResult(VetVr vetVr) {
        EntityCacheUtil.putResult(VetVrModelImpl.ENTITY_CACHE_ENABLED,
            VetVrImpl.class, vetVr.getPrimaryKey(), vetVr);

        vetVr.resetOriginalValues();
    }

    /**
     * Caches the vet vrs in the entity cache if it is enabled.
     *
     * @param vetVrs the vet vrs
     */
    @Override
    public void cacheResult(List<VetVr> vetVrs) {
        for (VetVr vetVr : vetVrs) {
            if (EntityCacheUtil.getResult(VetVrModelImpl.ENTITY_CACHE_ENABLED,
                        VetVrImpl.class, vetVr.getPrimaryKey()) == null) {
                cacheResult(vetVr);
            } else {
                vetVr.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all vet vrs.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(VetVrImpl.class.getName());
        }

        EntityCacheUtil.clearCache(VetVrImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the vet vr.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(VetVr vetVr) {
        EntityCacheUtil.removeResult(VetVrModelImpl.ENTITY_CACHE_ENABLED,
            VetVrImpl.class, vetVr.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<VetVr> vetVrs) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (VetVr vetVr : vetVrs) {
            EntityCacheUtil.removeResult(VetVrModelImpl.ENTITY_CACHE_ENABLED,
                VetVrImpl.class, vetVr.getPrimaryKey());
        }
    }

    /**
     * Creates a new vet vr with the primary key. Does not add the vet vr to the database.
     *
     * @param vetVrId the primary key for the new vet vr
     * @return the new vet vr
     */
    @Override
    public VetVr create(long vetVrId) {
        VetVr vetVr = new VetVrImpl();

        vetVr.setNew(true);
        vetVr.setPrimaryKey(vetVrId);

        return vetVr;
    }

    /**
     * Removes the vet vr with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param vetVrId the primary key of the vet vr
     * @return the vet vr that was removed
     * @throws gov.va.caret.NoSuchVetVrException if a vet vr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VetVr remove(long vetVrId)
        throws NoSuchVetVrException, SystemException {
        return remove((Serializable) vetVrId);
    }

    /**
     * Removes the vet vr with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the vet vr
     * @return the vet vr that was removed
     * @throws gov.va.caret.NoSuchVetVrException if a vet vr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VetVr remove(Serializable primaryKey)
        throws NoSuchVetVrException, SystemException {
        Session session = null;

        try {
            session = openSession();

            VetVr vetVr = (VetVr) session.get(VetVrImpl.class, primaryKey);

            if (vetVr == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchVetVrException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(vetVr);
        } catch (NoSuchVetVrException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected VetVr removeImpl(VetVr vetVr) throws SystemException {
        vetVr = toUnwrappedModel(vetVr);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(vetVr)) {
                vetVr = (VetVr) session.get(VetVrImpl.class,
                        vetVr.getPrimaryKeyObj());
            }

            if (vetVr != null) {
                session.delete(vetVr);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (vetVr != null) {
            clearCache(vetVr);
        }

        return vetVr;
    }

    @Override
    public VetVr updateImpl(gov.va.caret.model.VetVr vetVr)
        throws SystemException {
        vetVr = toUnwrappedModel(vetVr);

        boolean isNew = vetVr.isNew();

        Session session = null;

        try {
            session = openSession();

            if (vetVr.isNew()) {
                session.save(vetVr);

                vetVr.setNew(false);
            } else {
                session.merge(vetVr);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }

        EntityCacheUtil.putResult(VetVrModelImpl.ENTITY_CACHE_ENABLED,
            VetVrImpl.class, vetVr.getPrimaryKey(), vetVr);

        return vetVr;
    }

    protected VetVr toUnwrappedModel(VetVr vetVr) {
        if (vetVr instanceof VetVrImpl) {
            return vetVr;
        }

        VetVrImpl vetVrImpl = new VetVrImpl();

        vetVrImpl.setNew(vetVr.isNew());
        vetVrImpl.setPrimaryKey(vetVr.getPrimaryKey());

        vetVrImpl.setVetVrId(vetVr.getVetVrId());
        vetVrImpl.setVendrId(vetVr.getVendrId());
        vetVrImpl.setCgId(vetVr.getCgId());
        vetVrImpl.setVeteranId(vetVr.getVeteranId());
        vetVrImpl.setGroupId(vetVr.getGroupId());

        return vetVrImpl;
    }

    /**
     * Returns the vet vr with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the vet vr
     * @return the vet vr
     * @throws gov.va.caret.NoSuchVetVrException if a vet vr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VetVr findByPrimaryKey(Serializable primaryKey)
        throws NoSuchVetVrException, SystemException {
        VetVr vetVr = fetchByPrimaryKey(primaryKey);

        if (vetVr == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchVetVrException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return vetVr;
    }

    /**
     * Returns the vet vr with the primary key or throws a {@link gov.va.caret.NoSuchVetVrException} if it could not be found.
     *
     * @param vetVrId the primary key of the vet vr
     * @return the vet vr
     * @throws gov.va.caret.NoSuchVetVrException if a vet vr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VetVr findByPrimaryKey(long vetVrId)
        throws NoSuchVetVrException, SystemException {
        return findByPrimaryKey((Serializable) vetVrId);
    }

    /**
     * Returns the vet vr with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the vet vr
     * @return the vet vr, or <code>null</code> if a vet vr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VetVr fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        VetVr vetVr = (VetVr) EntityCacheUtil.getResult(VetVrModelImpl.ENTITY_CACHE_ENABLED,
                VetVrImpl.class, primaryKey);

        if (vetVr == _nullVetVr) {
            return null;
        }

        if (vetVr == null) {
            Session session = null;

            try {
                session = openSession();

                vetVr = (VetVr) session.get(VetVrImpl.class, primaryKey);

                if (vetVr != null) {
                    cacheResult(vetVr);
                } else {
                    EntityCacheUtil.putResult(VetVrModelImpl.ENTITY_CACHE_ENABLED,
                        VetVrImpl.class, primaryKey, _nullVetVr);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(VetVrModelImpl.ENTITY_CACHE_ENABLED,
                    VetVrImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return vetVr;
    }

    /**
     * Returns the vet vr with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param vetVrId the primary key of the vet vr
     * @return the vet vr, or <code>null</code> if a vet vr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VetVr fetchByPrimaryKey(long vetVrId) throws SystemException {
        return fetchByPrimaryKey((Serializable) vetVrId);
    }

    /**
     * Returns all the vet vrs.
     *
     * @return the vet vrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VetVr> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the vet vrs.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VetVrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of vet vrs
     * @param end the upper bound of the range of vet vrs (not inclusive)
     * @return the range of vet vrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VetVr> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the vet vrs.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VetVrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of vet vrs
     * @param end the upper bound of the range of vet vrs (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of vet vrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VetVr> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<VetVr> list = (List<VetVr>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_VETVR);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_VETVR;

                if (pagination) {
                    sql = sql.concat(VetVrModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<VetVr>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<VetVr>(list);
                } else {
                    list = (List<VetVr>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the vet vrs from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (VetVr vetVr : findAll()) {
            remove(vetVr);
        }
    }

    /**
     * Returns the number of vet vrs.
     *
     * @return the number of vet vrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_VETVR);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the vet vr persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.VetVr")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<VetVr>> listenersList = new ArrayList<ModelListener<VetVr>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<VetVr>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(VetVrImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
