package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchNotifException;
import gov.va.caret.model.Notif;
import gov.va.caret.model.impl.NotifImpl;
import gov.va.caret.model.impl.NotifModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * The persistence implementation for the notif service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see NotifPersistence
 * @see NotifUtil
 * @generated
 */
public class NotifPersistenceImpl extends BasePersistenceImpl<Notif>
    implements NotifPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link NotifUtil} to access the notif persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = NotifImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(NotifModelImpl.ENTITY_CACHE_ENABLED,
            NotifModelImpl.FINDER_CACHE_ENABLED, NotifImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(NotifModelImpl.ENTITY_CACHE_ENABLED,
            NotifModelImpl.FINDER_CACHE_ENABLED, NotifImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(NotifModelImpl.ENTITY_CACHE_ENABLED,
            NotifModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    private static final String _SQL_SELECT_NOTIF = "SELECT notif FROM Notif notif";
    private static final String _SQL_COUNT_NOTIF = "SELECT COUNT(notif) FROM Notif notif";
    private static final String _ORDER_BY_ENTITY_ALIAS = "notif.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Notif exists with the primary key ";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(NotifPersistenceImpl.class);
    private static Set<String> _badColumnNames = SetUtil.fromArray(new String[] {
                "type"
            });
    private static Notif _nullNotif = new NotifImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<Notif> toCacheModel() {
                return _nullNotifCacheModel;
            }
        };

    private static CacheModel<Notif> _nullNotifCacheModel = new CacheModel<Notif>() {
            @Override
            public Notif toEntityModel() {
                return _nullNotif;
            }
        };

    public NotifPersistenceImpl() {
        setModelClass(Notif.class);
    }

    /**
     * Caches the notif in the entity cache if it is enabled.
     *
     * @param notif the notif
     */
    @Override
    public void cacheResult(Notif notif) {
        EntityCacheUtil.putResult(NotifModelImpl.ENTITY_CACHE_ENABLED,
            NotifImpl.class, notif.getPrimaryKey(), notif);

        notif.resetOriginalValues();
    }

    /**
     * Caches the notifs in the entity cache if it is enabled.
     *
     * @param notifs the notifs
     */
    @Override
    public void cacheResult(List<Notif> notifs) {
        for (Notif notif : notifs) {
            if (EntityCacheUtil.getResult(NotifModelImpl.ENTITY_CACHE_ENABLED,
                        NotifImpl.class, notif.getPrimaryKey()) == null) {
                cacheResult(notif);
            } else {
                notif.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all notifs.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(NotifImpl.class.getName());
        }

        EntityCacheUtil.clearCache(NotifImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the notif.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(Notif notif) {
        EntityCacheUtil.removeResult(NotifModelImpl.ENTITY_CACHE_ENABLED,
            NotifImpl.class, notif.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<Notif> notifs) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (Notif notif : notifs) {
            EntityCacheUtil.removeResult(NotifModelImpl.ENTITY_CACHE_ENABLED,
                NotifImpl.class, notif.getPrimaryKey());
        }
    }

    /**
     * Creates a new notif with the primary key. Does not add the notif to the database.
     *
     * @param notifId the primary key for the new notif
     * @return the new notif
     */
    @Override
    public Notif create(long notifId) {
        Notif notif = new NotifImpl();

        notif.setNew(true);
        notif.setPrimaryKey(notifId);

        return notif;
    }

    /**
     * Removes the notif with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param notifId the primary key of the notif
     * @return the notif that was removed
     * @throws gov.va.caret.NoSuchNotifException if a notif with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Notif remove(long notifId)
        throws NoSuchNotifException, SystemException {
        return remove((Serializable) notifId);
    }

    /**
     * Removes the notif with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the notif
     * @return the notif that was removed
     * @throws gov.va.caret.NoSuchNotifException if a notif with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Notif remove(Serializable primaryKey)
        throws NoSuchNotifException, SystemException {
        Session session = null;

        try {
            session = openSession();

            Notif notif = (Notif) session.get(NotifImpl.class, primaryKey);

            if (notif == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchNotifException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(notif);
        } catch (NoSuchNotifException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected Notif removeImpl(Notif notif) throws SystemException {
        notif = toUnwrappedModel(notif);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(notif)) {
                notif = (Notif) session.get(NotifImpl.class,
                        notif.getPrimaryKeyObj());
            }

            if (notif != null) {
                session.delete(notif);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (notif != null) {
            clearCache(notif);
        }

        return notif;
    }

    @Override
    public Notif updateImpl(gov.va.caret.model.Notif notif)
        throws SystemException {
        notif = toUnwrappedModel(notif);

        boolean isNew = notif.isNew();

        Session session = null;

        try {
            session = openSession();

            if (notif.isNew()) {
                session.save(notif);

                notif.setNew(false);
            } else {
                session.merge(notif);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }

        EntityCacheUtil.putResult(NotifModelImpl.ENTITY_CACHE_ENABLED,
            NotifImpl.class, notif.getPrimaryKey(), notif);

        return notif;
    }

    protected Notif toUnwrappedModel(Notif notif) {
        if (notif instanceof NotifImpl) {
            return notif;
        }

        NotifImpl notifImpl = new NotifImpl();

        notifImpl.setNew(notif.isNew());
        notifImpl.setPrimaryKey(notif.getPrimaryKey());

        notifImpl.setNotifId(notif.getNotifId());
        notifImpl.setOwnerId(notif.getOwnerId());
        notifImpl.setType(notif.getType());
        notifImpl.setDiscontinueDate(notif.getDiscontinueDate());

        return notifImpl;
    }

    /**
     * Returns the notif with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the notif
     * @return the notif
     * @throws gov.va.caret.NoSuchNotifException if a notif with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Notif findByPrimaryKey(Serializable primaryKey)
        throws NoSuchNotifException, SystemException {
        Notif notif = fetchByPrimaryKey(primaryKey);

        if (notif == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchNotifException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return notif;
    }

    /**
     * Returns the notif with the primary key or throws a {@link gov.va.caret.NoSuchNotifException} if it could not be found.
     *
     * @param notifId the primary key of the notif
     * @return the notif
     * @throws gov.va.caret.NoSuchNotifException if a notif with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Notif findByPrimaryKey(long notifId)
        throws NoSuchNotifException, SystemException {
        return findByPrimaryKey((Serializable) notifId);
    }

    /**
     * Returns the notif with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the notif
     * @return the notif, or <code>null</code> if a notif with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Notif fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        Notif notif = (Notif) EntityCacheUtil.getResult(NotifModelImpl.ENTITY_CACHE_ENABLED,
                NotifImpl.class, primaryKey);

        if (notif == _nullNotif) {
            return null;
        }

        if (notif == null) {
            Session session = null;

            try {
                session = openSession();

                notif = (Notif) session.get(NotifImpl.class, primaryKey);

                if (notif != null) {
                    cacheResult(notif);
                } else {
                    EntityCacheUtil.putResult(NotifModelImpl.ENTITY_CACHE_ENABLED,
                        NotifImpl.class, primaryKey, _nullNotif);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(NotifModelImpl.ENTITY_CACHE_ENABLED,
                    NotifImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return notif;
    }

    /**
     * Returns the notif with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param notifId the primary key of the notif
     * @return the notif, or <code>null</code> if a notif with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Notif fetchByPrimaryKey(long notifId) throws SystemException {
        return fetchByPrimaryKey((Serializable) notifId);
    }

    /**
     * Returns all the notifs.
     *
     * @return the notifs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Notif> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the notifs.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.NotifModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of notifs
     * @param end the upper bound of the range of notifs (not inclusive)
     * @return the range of notifs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Notif> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the notifs.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.NotifModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of notifs
     * @param end the upper bound of the range of notifs (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of notifs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Notif> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<Notif> list = (List<Notif>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_NOTIF);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_NOTIF;

                if (pagination) {
                    sql = sql.concat(NotifModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<Notif>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Notif>(list);
                } else {
                    list = (List<Notif>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the notifs from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (Notif notif : findAll()) {
            remove(notif);
        }
    }

    /**
     * Returns the number of notifs.
     *
     * @return the number of notifs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_NOTIF);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    @Override
    protected Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    /**
     * Initializes the notif persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.Notif")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<Notif>> listenersList = new ArrayList<ModelListener<Notif>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<Notif>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(NotifImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
