package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchEEMilitaryRecordException;
import gov.va.caret.model.EEMilitaryRecord;
import gov.va.caret.model.impl.EEMilitaryRecordImpl;
import gov.va.caret.model.impl.EEMilitaryRecordModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The persistence implementation for the e e military record service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see EEMilitaryRecordPersistence
 * @see EEMilitaryRecordUtil
 * @generated
 */
public class EEMilitaryRecordPersistenceImpl extends BasePersistenceImpl<EEMilitaryRecord>
    implements EEMilitaryRecordPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link EEMilitaryRecordUtil} to access the e e military record persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = EEMilitaryRecordImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(EEMilitaryRecordModelImpl.ENTITY_CACHE_ENABLED,
            EEMilitaryRecordModelImpl.FINDER_CACHE_ENABLED,
            EEMilitaryRecordImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION,
            "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(EEMilitaryRecordModelImpl.ENTITY_CACHE_ENABLED,
            EEMilitaryRecordModelImpl.FINDER_CACHE_ENABLED,
            EEMilitaryRecordImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(EEMilitaryRecordModelImpl.ENTITY_CACHE_ENABLED,
            EEMilitaryRecordModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_EELGID = new FinderPath(EEMilitaryRecordModelImpl.ENTITY_CACHE_ENABLED,
            EEMilitaryRecordModelImpl.FINDER_CACHE_ENABLED,
            EEMilitaryRecordImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION,
            "findByeeLgId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_EELGID =
        new FinderPath(EEMilitaryRecordModelImpl.ENTITY_CACHE_ENABLED,
            EEMilitaryRecordModelImpl.FINDER_CACHE_ENABLED,
            EEMilitaryRecordImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByeeLgId",
            new String[] { Long.class.getName() },
            EEMilitaryRecordModelImpl.EELGID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_EELGID = new FinderPath(EEMilitaryRecordModelImpl.ENTITY_CACHE_ENABLED,
            EEMilitaryRecordModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByeeLgId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_EELGID_EELGID_2 = "eeMilitaryRecord.eeLgId = ?";
    private static final String _SQL_SELECT_EEMILITARYRECORD = "SELECT eeMilitaryRecord FROM EEMilitaryRecord eeMilitaryRecord";
    private static final String _SQL_SELECT_EEMILITARYRECORD_WHERE = "SELECT eeMilitaryRecord FROM EEMilitaryRecord eeMilitaryRecord WHERE ";
    private static final String _SQL_COUNT_EEMILITARYRECORD = "SELECT COUNT(eeMilitaryRecord) FROM EEMilitaryRecord eeMilitaryRecord";
    private static final String _SQL_COUNT_EEMILITARYRECORD_WHERE = "SELECT COUNT(eeMilitaryRecord) FROM EEMilitaryRecord eeMilitaryRecord WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "eeMilitaryRecord.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No EEMilitaryRecord exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No EEMilitaryRecord exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(EEMilitaryRecordPersistenceImpl.class);
    private static EEMilitaryRecord _nullEEMilitaryRecord = new EEMilitaryRecordImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<EEMilitaryRecord> toCacheModel() {
                return _nullEEMilitaryRecordCacheModel;
            }
        };

    private static CacheModel<EEMilitaryRecord> _nullEEMilitaryRecordCacheModel = new CacheModel<EEMilitaryRecord>() {
            @Override
            public EEMilitaryRecord toEntityModel() {
                return _nullEEMilitaryRecord;
            }
        };

    public EEMilitaryRecordPersistenceImpl() {
        setModelClass(EEMilitaryRecord.class);
    }

    /**
     * Returns all the e e military records where eeLgId = &#63;.
     *
     * @param eeLgId the ee lg ID
     * @return the matching e e military records
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EEMilitaryRecord> findByeeLgId(long eeLgId)
        throws SystemException {
        return findByeeLgId(eeLgId, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the e e military records where eeLgId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EEMilitaryRecordModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param eeLgId the ee lg ID
     * @param start the lower bound of the range of e e military records
     * @param end the upper bound of the range of e e military records (not inclusive)
     * @return the range of matching e e military records
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EEMilitaryRecord> findByeeLgId(long eeLgId, int start, int end)
        throws SystemException {
        return findByeeLgId(eeLgId, start, end, null);
    }

    /**
     * Returns an ordered range of all the e e military records where eeLgId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EEMilitaryRecordModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param eeLgId the ee lg ID
     * @param start the lower bound of the range of e e military records
     * @param end the upper bound of the range of e e military records (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching e e military records
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EEMilitaryRecord> findByeeLgId(long eeLgId, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_EELGID;
            finderArgs = new Object[] { eeLgId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_EELGID;
            finderArgs = new Object[] { eeLgId, start, end, orderByComparator };
        }

        List<EEMilitaryRecord> list = (List<EEMilitaryRecord>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (EEMilitaryRecord eeMilitaryRecord : list) {
                if ((eeLgId != eeMilitaryRecord.getEeLgId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_EEMILITARYRECORD_WHERE);

            query.append(_FINDER_COLUMN_EELGID_EELGID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(EEMilitaryRecordModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(eeLgId);

                if (!pagination) {
                    list = (List<EEMilitaryRecord>) QueryUtil.list(q,
                            getDialect(), start, end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<EEMilitaryRecord>(list);
                } else {
                    list = (List<EEMilitaryRecord>) QueryUtil.list(q,
                            getDialect(), start, end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first e e military record in the ordered set where eeLgId = &#63;.
     *
     * @param eeLgId the ee lg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching e e military record
     * @throws gov.va.caret.NoSuchEEMilitaryRecordException if a matching e e military record could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMilitaryRecord findByeeLgId_First(long eeLgId,
        OrderByComparator orderByComparator)
        throws NoSuchEEMilitaryRecordException, SystemException {
        EEMilitaryRecord eeMilitaryRecord = fetchByeeLgId_First(eeLgId,
                orderByComparator);

        if (eeMilitaryRecord != null) {
            return eeMilitaryRecord;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("eeLgId=");
        msg.append(eeLgId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchEEMilitaryRecordException(msg.toString());
    }

    /**
     * Returns the first e e military record in the ordered set where eeLgId = &#63;.
     *
     * @param eeLgId the ee lg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching e e military record, or <code>null</code> if a matching e e military record could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMilitaryRecord fetchByeeLgId_First(long eeLgId,
        OrderByComparator orderByComparator) throws SystemException {
        List<EEMilitaryRecord> list = findByeeLgId(eeLgId, 0, 1,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last e e military record in the ordered set where eeLgId = &#63;.
     *
     * @param eeLgId the ee lg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching e e military record
     * @throws gov.va.caret.NoSuchEEMilitaryRecordException if a matching e e military record could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMilitaryRecord findByeeLgId_Last(long eeLgId,
        OrderByComparator orderByComparator)
        throws NoSuchEEMilitaryRecordException, SystemException {
        EEMilitaryRecord eeMilitaryRecord = fetchByeeLgId_Last(eeLgId,
                orderByComparator);

        if (eeMilitaryRecord != null) {
            return eeMilitaryRecord;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("eeLgId=");
        msg.append(eeLgId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchEEMilitaryRecordException(msg.toString());
    }

    /**
     * Returns the last e e military record in the ordered set where eeLgId = &#63;.
     *
     * @param eeLgId the ee lg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching e e military record, or <code>null</code> if a matching e e military record could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMilitaryRecord fetchByeeLgId_Last(long eeLgId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByeeLgId(eeLgId);

        if (count == 0) {
            return null;
        }

        List<EEMilitaryRecord> list = findByeeLgId(eeLgId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the e e military records before and after the current e e military record in the ordered set where eeLgId = &#63;.
     *
     * @param eeMilRecordId the primary key of the current e e military record
     * @param eeLgId the ee lg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next e e military record
     * @throws gov.va.caret.NoSuchEEMilitaryRecordException if a e e military record with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMilitaryRecord[] findByeeLgId_PrevAndNext(long eeMilRecordId,
        long eeLgId, OrderByComparator orderByComparator)
        throws NoSuchEEMilitaryRecordException, SystemException {
        EEMilitaryRecord eeMilitaryRecord = findByPrimaryKey(eeMilRecordId);

        Session session = null;

        try {
            session = openSession();

            EEMilitaryRecord[] array = new EEMilitaryRecordImpl[3];

            array[0] = getByeeLgId_PrevAndNext(session, eeMilitaryRecord,
                    eeLgId, orderByComparator, true);

            array[1] = eeMilitaryRecord;

            array[2] = getByeeLgId_PrevAndNext(session, eeMilitaryRecord,
                    eeLgId, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected EEMilitaryRecord getByeeLgId_PrevAndNext(Session session,
        EEMilitaryRecord eeMilitaryRecord, long eeLgId,
        OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_EEMILITARYRECORD_WHERE);

        query.append(_FINDER_COLUMN_EELGID_EELGID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(EEMilitaryRecordModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(eeLgId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(eeMilitaryRecord);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<EEMilitaryRecord> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the e e military records where eeLgId = &#63; from the database.
     *
     * @param eeLgId the ee lg ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByeeLgId(long eeLgId) throws SystemException {
        for (EEMilitaryRecord eeMilitaryRecord : findByeeLgId(eeLgId,
                QueryUtil.ALL_POS, QueryUtil.ALL_POS, null)) {
            remove(eeMilitaryRecord);
        }
    }

    /**
     * Returns the number of e e military records where eeLgId = &#63;.
     *
     * @param eeLgId the ee lg ID
     * @return the number of matching e e military records
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByeeLgId(long eeLgId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_EELGID;

        Object[] finderArgs = new Object[] { eeLgId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_EEMILITARYRECORD_WHERE);

            query.append(_FINDER_COLUMN_EELGID_EELGID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(eeLgId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the e e military record in the entity cache if it is enabled.
     *
     * @param eeMilitaryRecord the e e military record
     */
    @Override
    public void cacheResult(EEMilitaryRecord eeMilitaryRecord) {
        EntityCacheUtil.putResult(EEMilitaryRecordModelImpl.ENTITY_CACHE_ENABLED,
            EEMilitaryRecordImpl.class, eeMilitaryRecord.getPrimaryKey(),
            eeMilitaryRecord);

        eeMilitaryRecord.resetOriginalValues();
    }

    /**
     * Caches the e e military records in the entity cache if it is enabled.
     *
     * @param eeMilitaryRecords the e e military records
     */
    @Override
    public void cacheResult(List<EEMilitaryRecord> eeMilitaryRecords) {
        for (EEMilitaryRecord eeMilitaryRecord : eeMilitaryRecords) {
            if (EntityCacheUtil.getResult(
                        EEMilitaryRecordModelImpl.ENTITY_CACHE_ENABLED,
                        EEMilitaryRecordImpl.class,
                        eeMilitaryRecord.getPrimaryKey()) == null) {
                cacheResult(eeMilitaryRecord);
            } else {
                eeMilitaryRecord.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all e e military records.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(EEMilitaryRecordImpl.class.getName());
        }

        EntityCacheUtil.clearCache(EEMilitaryRecordImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the e e military record.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(EEMilitaryRecord eeMilitaryRecord) {
        EntityCacheUtil.removeResult(EEMilitaryRecordModelImpl.ENTITY_CACHE_ENABLED,
            EEMilitaryRecordImpl.class, eeMilitaryRecord.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<EEMilitaryRecord> eeMilitaryRecords) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (EEMilitaryRecord eeMilitaryRecord : eeMilitaryRecords) {
            EntityCacheUtil.removeResult(EEMilitaryRecordModelImpl.ENTITY_CACHE_ENABLED,
                EEMilitaryRecordImpl.class, eeMilitaryRecord.getPrimaryKey());
        }
    }

    /**
     * Creates a new e e military record with the primary key. Does not add the e e military record to the database.
     *
     * @param eeMilRecordId the primary key for the new e e military record
     * @return the new e e military record
     */
    @Override
    public EEMilitaryRecord create(long eeMilRecordId) {
        EEMilitaryRecord eeMilitaryRecord = new EEMilitaryRecordImpl();

        eeMilitaryRecord.setNew(true);
        eeMilitaryRecord.setPrimaryKey(eeMilRecordId);

        return eeMilitaryRecord;
    }

    /**
     * Removes the e e military record with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param eeMilRecordId the primary key of the e e military record
     * @return the e e military record that was removed
     * @throws gov.va.caret.NoSuchEEMilitaryRecordException if a e e military record with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMilitaryRecord remove(long eeMilRecordId)
        throws NoSuchEEMilitaryRecordException, SystemException {
        return remove((Serializable) eeMilRecordId);
    }

    /**
     * Removes the e e military record with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the e e military record
     * @return the e e military record that was removed
     * @throws gov.va.caret.NoSuchEEMilitaryRecordException if a e e military record with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMilitaryRecord remove(Serializable primaryKey)
        throws NoSuchEEMilitaryRecordException, SystemException {
        Session session = null;

        try {
            session = openSession();

            EEMilitaryRecord eeMilitaryRecord = (EEMilitaryRecord) session.get(EEMilitaryRecordImpl.class,
                    primaryKey);

            if (eeMilitaryRecord == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchEEMilitaryRecordException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(eeMilitaryRecord);
        } catch (NoSuchEEMilitaryRecordException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected EEMilitaryRecord removeImpl(EEMilitaryRecord eeMilitaryRecord)
        throws SystemException {
        eeMilitaryRecord = toUnwrappedModel(eeMilitaryRecord);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(eeMilitaryRecord)) {
                eeMilitaryRecord = (EEMilitaryRecord) session.get(EEMilitaryRecordImpl.class,
                        eeMilitaryRecord.getPrimaryKeyObj());
            }

            if (eeMilitaryRecord != null) {
                session.delete(eeMilitaryRecord);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (eeMilitaryRecord != null) {
            clearCache(eeMilitaryRecord);
        }

        return eeMilitaryRecord;
    }

    @Override
    public EEMilitaryRecord updateImpl(
        gov.va.caret.model.EEMilitaryRecord eeMilitaryRecord)
        throws SystemException {
        eeMilitaryRecord = toUnwrappedModel(eeMilitaryRecord);

        boolean isNew = eeMilitaryRecord.isNew();

        EEMilitaryRecordModelImpl eeMilitaryRecordModelImpl = (EEMilitaryRecordModelImpl) eeMilitaryRecord;

        Session session = null;

        try {
            session = openSession();

            if (eeMilitaryRecord.isNew()) {
                session.save(eeMilitaryRecord);

                eeMilitaryRecord.setNew(false);
            } else {
                session.merge(eeMilitaryRecord);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !EEMilitaryRecordModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((eeMilitaryRecordModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_EELGID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        eeMilitaryRecordModelImpl.getOriginalEeLgId()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_EELGID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_EELGID,
                    args);

                args = new Object[] { eeMilitaryRecordModelImpl.getEeLgId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_EELGID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_EELGID,
                    args);
            }
        }

        EntityCacheUtil.putResult(EEMilitaryRecordModelImpl.ENTITY_CACHE_ENABLED,
            EEMilitaryRecordImpl.class, eeMilitaryRecord.getPrimaryKey(),
            eeMilitaryRecord);

        return eeMilitaryRecord;
    }

    protected EEMilitaryRecord toUnwrappedModel(
        EEMilitaryRecord eeMilitaryRecord) {
        if (eeMilitaryRecord instanceof EEMilitaryRecordImpl) {
            return eeMilitaryRecord;
        }

        EEMilitaryRecordImpl eeMilitaryRecordImpl = new EEMilitaryRecordImpl();

        eeMilitaryRecordImpl.setNew(eeMilitaryRecord.isNew());
        eeMilitaryRecordImpl.setPrimaryKey(eeMilitaryRecord.getPrimaryKey());

        eeMilitaryRecordImpl.setEeMilRecordId(eeMilitaryRecord.getEeMilRecordId());
        eeMilitaryRecordImpl.setEeLgId(eeMilitaryRecord.getEeLgId());
        eeMilitaryRecordImpl.setServiceBranch(eeMilitaryRecord.getServiceBranch());
        eeMilitaryRecordImpl.setServiceDate(eeMilitaryRecord.getServiceDate());
        eeMilitaryRecordImpl.setExitServiceDate(eeMilitaryRecord.getExitServiceDate());
        eeMilitaryRecordImpl.setDischargeType(eeMilitaryRecord.getDischargeType());

        return eeMilitaryRecordImpl;
    }

    /**
     * Returns the e e military record with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the e e military record
     * @return the e e military record
     * @throws gov.va.caret.NoSuchEEMilitaryRecordException if a e e military record with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMilitaryRecord findByPrimaryKey(Serializable primaryKey)
        throws NoSuchEEMilitaryRecordException, SystemException {
        EEMilitaryRecord eeMilitaryRecord = fetchByPrimaryKey(primaryKey);

        if (eeMilitaryRecord == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchEEMilitaryRecordException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return eeMilitaryRecord;
    }

    /**
     * Returns the e e military record with the primary key or throws a {@link gov.va.caret.NoSuchEEMilitaryRecordException} if it could not be found.
     *
     * @param eeMilRecordId the primary key of the e e military record
     * @return the e e military record
     * @throws gov.va.caret.NoSuchEEMilitaryRecordException if a e e military record with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMilitaryRecord findByPrimaryKey(long eeMilRecordId)
        throws NoSuchEEMilitaryRecordException, SystemException {
        return findByPrimaryKey((Serializable) eeMilRecordId);
    }

    /**
     * Returns the e e military record with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the e e military record
     * @return the e e military record, or <code>null</code> if a e e military record with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMilitaryRecord fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        EEMilitaryRecord eeMilitaryRecord = (EEMilitaryRecord) EntityCacheUtil.getResult(EEMilitaryRecordModelImpl.ENTITY_CACHE_ENABLED,
                EEMilitaryRecordImpl.class, primaryKey);

        if (eeMilitaryRecord == _nullEEMilitaryRecord) {
            return null;
        }

        if (eeMilitaryRecord == null) {
            Session session = null;

            try {
                session = openSession();

                eeMilitaryRecord = (EEMilitaryRecord) session.get(EEMilitaryRecordImpl.class,
                        primaryKey);

                if (eeMilitaryRecord != null) {
                    cacheResult(eeMilitaryRecord);
                } else {
                    EntityCacheUtil.putResult(EEMilitaryRecordModelImpl.ENTITY_CACHE_ENABLED,
                        EEMilitaryRecordImpl.class, primaryKey,
                        _nullEEMilitaryRecord);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(EEMilitaryRecordModelImpl.ENTITY_CACHE_ENABLED,
                    EEMilitaryRecordImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return eeMilitaryRecord;
    }

    /**
     * Returns the e e military record with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param eeMilRecordId the primary key of the e e military record
     * @return the e e military record, or <code>null</code> if a e e military record with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMilitaryRecord fetchByPrimaryKey(long eeMilRecordId)
        throws SystemException {
        return fetchByPrimaryKey((Serializable) eeMilRecordId);
    }

    /**
     * Returns all the e e military records.
     *
     * @return the e e military records
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EEMilitaryRecord> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the e e military records.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EEMilitaryRecordModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of e e military records
     * @param end the upper bound of the range of e e military records (not inclusive)
     * @return the range of e e military records
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EEMilitaryRecord> findAll(int start, int end)
        throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the e e military records.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EEMilitaryRecordModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of e e military records
     * @param end the upper bound of the range of e e military records (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of e e military records
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EEMilitaryRecord> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<EEMilitaryRecord> list = (List<EEMilitaryRecord>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_EEMILITARYRECORD);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_EEMILITARYRECORD;

                if (pagination) {
                    sql = sql.concat(EEMilitaryRecordModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<EEMilitaryRecord>) QueryUtil.list(q,
                            getDialect(), start, end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<EEMilitaryRecord>(list);
                } else {
                    list = (List<EEMilitaryRecord>) QueryUtil.list(q,
                            getDialect(), start, end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the e e military records from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (EEMilitaryRecord eeMilitaryRecord : findAll()) {
            remove(eeMilitaryRecord);
        }
    }

    /**
     * Returns the number of e e military records.
     *
     * @return the number of e e military records
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_EEMILITARYRECORD);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the e e military record persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.EEMilitaryRecord")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<EEMilitaryRecord>> listenersList = new ArrayList<ModelListener<EEMilitaryRecord>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<EEMilitaryRecord>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(EEMilitaryRecordImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
