package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchEELgException;
import gov.va.caret.model.EELg;
import gov.va.caret.model.impl.EELgImpl;
import gov.va.caret.model.impl.EELgModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The persistence implementation for the e e lg service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see EELgPersistence
 * @see EELgUtil
 * @generated
 */
public class EELgPersistenceImpl extends BasePersistenceImpl<EELg>
    implements EELgPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link EELgUtil} to access the e e lg persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = EELgImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(EELgModelImpl.ENTITY_CACHE_ENABLED,
            EELgModelImpl.FINDER_CACHE_ENABLED, EELgImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(EELgModelImpl.ENTITY_CACHE_ENABLED,
            EELgModelImpl.FINDER_CACHE_ENABLED, EELgImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(EELgModelImpl.ENTITY_CACHE_ENABLED,
            EELgModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_ICN = new FinderPath(EELgModelImpl.ENTITY_CACHE_ENABLED,
            EELgModelImpl.FINDER_CACHE_ENABLED, EELgImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByIcn",
            new String[] {
                String.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ICN = new FinderPath(EELgModelImpl.ENTITY_CACHE_ENABLED,
            EELgModelImpl.FINDER_CACHE_ENABLED, EELgImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByIcn",
            new String[] { String.class.getName() },
            EELgModelImpl.ICN_COLUMN_BITMASK |
            EELgModelImpl.CREATEDDATE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_ICN = new FinderPath(EELgModelImpl.ENTITY_CACHE_ENABLED,
            EELgModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByIcn",
            new String[] { String.class.getName() });
    private static final String _FINDER_COLUMN_ICN_ICN_1 = "eeLg.ICN IS NULL";
    private static final String _FINDER_COLUMN_ICN_ICN_2 = "eeLg.ICN = ?";
    private static final String _FINDER_COLUMN_ICN_ICN_3 = "(eeLg.ICN IS NULL OR eeLg.ICN = '')";
    private static final String _SQL_SELECT_EELG = "SELECT eeLg FROM EELg eeLg";
    private static final String _SQL_SELECT_EELG_WHERE = "SELECT eeLg FROM EELg eeLg WHERE ";
    private static final String _SQL_COUNT_EELG = "SELECT COUNT(eeLg) FROM EELg eeLg";
    private static final String _SQL_COUNT_EELG_WHERE = "SELECT COUNT(eeLg) FROM EELg eeLg WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "eeLg.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No EELg exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No EELg exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(EELgPersistenceImpl.class);
    private static EELg _nullEELg = new EELgImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<EELg> toCacheModel() {
                return _nullEELgCacheModel;
            }
        };

    private static CacheModel<EELg> _nullEELgCacheModel = new CacheModel<EELg>() {
            @Override
            public EELg toEntityModel() {
                return _nullEELg;
            }
        };

    public EELgPersistenceImpl() {
        setModelClass(EELg.class);
    }

    /**
     * Returns all the e e lgs where ICN = &#63;.
     *
     * @param ICN the i c n
     * @return the matching e e lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EELg> findByIcn(String ICN) throws SystemException {
        return findByIcn(ICN, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the e e lgs where ICN = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EELgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param ICN the i c n
     * @param start the lower bound of the range of e e lgs
     * @param end the upper bound of the range of e e lgs (not inclusive)
     * @return the range of matching e e lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EELg> findByIcn(String ICN, int start, int end)
        throws SystemException {
        return findByIcn(ICN, start, end, null);
    }

    /**
     * Returns an ordered range of all the e e lgs where ICN = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EELgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param ICN the i c n
     * @param start the lower bound of the range of e e lgs
     * @param end the upper bound of the range of e e lgs (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching e e lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EELg> findByIcn(String ICN, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ICN;
            finderArgs = new Object[] { ICN };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_ICN;
            finderArgs = new Object[] { ICN, start, end, orderByComparator };
        }

        List<EELg> list = (List<EELg>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (EELg eeLg : list) {
                if (!Validator.equals(ICN, eeLg.getICN())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_EELG_WHERE);

            boolean bindICN = false;

            if (ICN == null) {
                query.append(_FINDER_COLUMN_ICN_ICN_1);
            } else if (ICN.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_ICN_ICN_3);
            } else {
                bindICN = true;

                query.append(_FINDER_COLUMN_ICN_ICN_2);
            }

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(EELgModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindICN) {
                    qPos.add(ICN);
                }

                if (!pagination) {
                    list = (List<EELg>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<EELg>(list);
                } else {
                    list = (List<EELg>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first e e lg in the ordered set where ICN = &#63;.
     *
     * @param ICN the i c n
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching e e lg
     * @throws gov.va.caret.NoSuchEELgException if a matching e e lg could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EELg findByIcn_First(String ICN, OrderByComparator orderByComparator)
        throws NoSuchEELgException, SystemException {
        EELg eeLg = fetchByIcn_First(ICN, orderByComparator);

        if (eeLg != null) {
            return eeLg;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("ICN=");
        msg.append(ICN);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchEELgException(msg.toString());
    }

    /**
     * Returns the first e e lg in the ordered set where ICN = &#63;.
     *
     * @param ICN the i c n
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching e e lg, or <code>null</code> if a matching e e lg could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EELg fetchByIcn_First(String ICN, OrderByComparator orderByComparator)
        throws SystemException {
        List<EELg> list = findByIcn(ICN, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last e e lg in the ordered set where ICN = &#63;.
     *
     * @param ICN the i c n
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching e e lg
     * @throws gov.va.caret.NoSuchEELgException if a matching e e lg could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EELg findByIcn_Last(String ICN, OrderByComparator orderByComparator)
        throws NoSuchEELgException, SystemException {
        EELg eeLg = fetchByIcn_Last(ICN, orderByComparator);

        if (eeLg != null) {
            return eeLg;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("ICN=");
        msg.append(ICN);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchEELgException(msg.toString());
    }

    /**
     * Returns the last e e lg in the ordered set where ICN = &#63;.
     *
     * @param ICN the i c n
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching e e lg, or <code>null</code> if a matching e e lg could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EELg fetchByIcn_Last(String ICN, OrderByComparator orderByComparator)
        throws SystemException {
        int count = countByIcn(ICN);

        if (count == 0) {
            return null;
        }

        List<EELg> list = findByIcn(ICN, count - 1, count, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the e e lgs before and after the current e e lg in the ordered set where ICN = &#63;.
     *
     * @param eeLgId the primary key of the current e e lg
     * @param ICN the i c n
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next e e lg
     * @throws gov.va.caret.NoSuchEELgException if a e e lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EELg[] findByIcn_PrevAndNext(long eeLgId, String ICN,
        OrderByComparator orderByComparator)
        throws NoSuchEELgException, SystemException {
        EELg eeLg = findByPrimaryKey(eeLgId);

        Session session = null;

        try {
            session = openSession();

            EELg[] array = new EELgImpl[3];

            array[0] = getByIcn_PrevAndNext(session, eeLg, ICN,
                    orderByComparator, true);

            array[1] = eeLg;

            array[2] = getByIcn_PrevAndNext(session, eeLg, ICN,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected EELg getByIcn_PrevAndNext(Session session, EELg eeLg, String ICN,
        OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_EELG_WHERE);

        boolean bindICN = false;

        if (ICN == null) {
            query.append(_FINDER_COLUMN_ICN_ICN_1);
        } else if (ICN.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_ICN_ICN_3);
        } else {
            bindICN = true;

            query.append(_FINDER_COLUMN_ICN_ICN_2);
        }

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(EELgModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        if (bindICN) {
            qPos.add(ICN);
        }

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(eeLg);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<EELg> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the e e lgs where ICN = &#63; from the database.
     *
     * @param ICN the i c n
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByIcn(String ICN) throws SystemException {
        for (EELg eeLg : findByIcn(ICN, QueryUtil.ALL_POS, QueryUtil.ALL_POS,
                null)) {
            remove(eeLg);
        }
    }

    /**
     * Returns the number of e e lgs where ICN = &#63;.
     *
     * @param ICN the i c n
     * @return the number of matching e e lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByIcn(String ICN) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_ICN;

        Object[] finderArgs = new Object[] { ICN };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_EELG_WHERE);

            boolean bindICN = false;

            if (ICN == null) {
                query.append(_FINDER_COLUMN_ICN_ICN_1);
            } else if (ICN.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_ICN_ICN_3);
            } else {
                bindICN = true;

                query.append(_FINDER_COLUMN_ICN_ICN_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindICN) {
                    qPos.add(ICN);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the e e lg in the entity cache if it is enabled.
     *
     * @param eeLg the e e lg
     */
    @Override
    public void cacheResult(EELg eeLg) {
        EntityCacheUtil.putResult(EELgModelImpl.ENTITY_CACHE_ENABLED,
            EELgImpl.class, eeLg.getPrimaryKey(), eeLg);

        eeLg.resetOriginalValues();
    }

    /**
     * Caches the e e lgs in the entity cache if it is enabled.
     *
     * @param eeLgs the e e lgs
     */
    @Override
    public void cacheResult(List<EELg> eeLgs) {
        for (EELg eeLg : eeLgs) {
            if (EntityCacheUtil.getResult(EELgModelImpl.ENTITY_CACHE_ENABLED,
                        EELgImpl.class, eeLg.getPrimaryKey()) == null) {
                cacheResult(eeLg);
            } else {
                eeLg.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all e e lgs.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(EELgImpl.class.getName());
        }

        EntityCacheUtil.clearCache(EELgImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the e e lg.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(EELg eeLg) {
        EntityCacheUtil.removeResult(EELgModelImpl.ENTITY_CACHE_ENABLED,
            EELgImpl.class, eeLg.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<EELg> eeLgs) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (EELg eeLg : eeLgs) {
            EntityCacheUtil.removeResult(EELgModelImpl.ENTITY_CACHE_ENABLED,
                EELgImpl.class, eeLg.getPrimaryKey());
        }
    }

    /**
     * Creates a new e e lg with the primary key. Does not add the e e lg to the database.
     *
     * @param eeLgId the primary key for the new e e lg
     * @return the new e e lg
     */
    @Override
    public EELg create(long eeLgId) {
        EELg eeLg = new EELgImpl();

        eeLg.setNew(true);
        eeLg.setPrimaryKey(eeLgId);

        return eeLg;
    }

    /**
     * Removes the e e lg with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param eeLgId the primary key of the e e lg
     * @return the e e lg that was removed
     * @throws gov.va.caret.NoSuchEELgException if a e e lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EELg remove(long eeLgId) throws NoSuchEELgException, SystemException {
        return remove((Serializable) eeLgId);
    }

    /**
     * Removes the e e lg with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the e e lg
     * @return the e e lg that was removed
     * @throws gov.va.caret.NoSuchEELgException if a e e lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EELg remove(Serializable primaryKey)
        throws NoSuchEELgException, SystemException {
        Session session = null;

        try {
            session = openSession();

            EELg eeLg = (EELg) session.get(EELgImpl.class, primaryKey);

            if (eeLg == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchEELgException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(eeLg);
        } catch (NoSuchEELgException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected EELg removeImpl(EELg eeLg) throws SystemException {
        eeLg = toUnwrappedModel(eeLg);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(eeLg)) {
                eeLg = (EELg) session.get(EELgImpl.class,
                        eeLg.getPrimaryKeyObj());
            }

            if (eeLg != null) {
                session.delete(eeLg);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (eeLg != null) {
            clearCache(eeLg);
        }

        return eeLg;
    }

    @Override
    public EELg updateImpl(gov.va.caret.model.EELg eeLg)
        throws SystemException {
        eeLg = toUnwrappedModel(eeLg);

        boolean isNew = eeLg.isNew();

        EELgModelImpl eeLgModelImpl = (EELgModelImpl) eeLg;

        Session session = null;

        try {
            session = openSession();

            if (eeLg.isNew()) {
                session.save(eeLg);

                eeLg.setNew(false);
            } else {
                session.merge(eeLg);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !EELgModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((eeLgModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ICN.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { eeLgModelImpl.getOriginalICN() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_ICN, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ICN,
                    args);

                args = new Object[] { eeLgModelImpl.getICN() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_ICN, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ICN,
                    args);
            }
        }

        EntityCacheUtil.putResult(EELgModelImpl.ENTITY_CACHE_ENABLED,
            EELgImpl.class, eeLg.getPrimaryKey(), eeLg);

        return eeLg;
    }

    protected EELg toUnwrappedModel(EELg eeLg) {
        if (eeLg instanceof EELgImpl) {
            return eeLg;
        }

        EELgImpl eeLgImpl = new EELgImpl();

        eeLgImpl.setNew(eeLg.isNew());
        eeLgImpl.setPrimaryKey(eeLg.getPrimaryKey());

        eeLgImpl.setEeLgId(eeLg.getEeLgId());
        eeLgImpl.setICN(eeLg.getICN());
        eeLgImpl.setDateOfDeath(eeLg.getDateOfDeath());
        eeLgImpl.setPriorityGroup(eeLg.getPriorityGroup());
        eeLgImpl.setScTotDisabRating(eeLg.getScTotDisabRating());
        eeLgImpl.setScIndicator(eeLg.getScIndicator());
        eeLgImpl.setMedicaidEligibility(eeLg.getMedicaidEligibility());
        eeLgImpl.setCreatedDate(eeLg.getCreatedDate());

        return eeLgImpl;
    }

    /**
     * Returns the e e lg with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the e e lg
     * @return the e e lg
     * @throws gov.va.caret.NoSuchEELgException if a e e lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EELg findByPrimaryKey(Serializable primaryKey)
        throws NoSuchEELgException, SystemException {
        EELg eeLg = fetchByPrimaryKey(primaryKey);

        if (eeLg == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchEELgException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return eeLg;
    }

    /**
     * Returns the e e lg with the primary key or throws a {@link gov.va.caret.NoSuchEELgException} if it could not be found.
     *
     * @param eeLgId the primary key of the e e lg
     * @return the e e lg
     * @throws gov.va.caret.NoSuchEELgException if a e e lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EELg findByPrimaryKey(long eeLgId)
        throws NoSuchEELgException, SystemException {
        return findByPrimaryKey((Serializable) eeLgId);
    }

    /**
     * Returns the e e lg with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the e e lg
     * @return the e e lg, or <code>null</code> if a e e lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EELg fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        EELg eeLg = (EELg) EntityCacheUtil.getResult(EELgModelImpl.ENTITY_CACHE_ENABLED,
                EELgImpl.class, primaryKey);

        if (eeLg == _nullEELg) {
            return null;
        }

        if (eeLg == null) {
            Session session = null;

            try {
                session = openSession();

                eeLg = (EELg) session.get(EELgImpl.class, primaryKey);

                if (eeLg != null) {
                    cacheResult(eeLg);
                } else {
                    EntityCacheUtil.putResult(EELgModelImpl.ENTITY_CACHE_ENABLED,
                        EELgImpl.class, primaryKey, _nullEELg);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(EELgModelImpl.ENTITY_CACHE_ENABLED,
                    EELgImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return eeLg;
    }

    /**
     * Returns the e e lg with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param eeLgId the primary key of the e e lg
     * @return the e e lg, or <code>null</code> if a e e lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EELg fetchByPrimaryKey(long eeLgId) throws SystemException {
        return fetchByPrimaryKey((Serializable) eeLgId);
    }

    /**
     * Returns all the e e lgs.
     *
     * @return the e e lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EELg> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the e e lgs.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EELgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of e e lgs
     * @param end the upper bound of the range of e e lgs (not inclusive)
     * @return the range of e e lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EELg> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the e e lgs.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EELgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of e e lgs
     * @param end the upper bound of the range of e e lgs (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of e e lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EELg> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<EELg> list = (List<EELg>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_EELG);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_EELG;

                if (pagination) {
                    sql = sql.concat(EELgModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<EELg>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<EELg>(list);
                } else {
                    list = (List<EELg>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the e e lgs from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (EELg eeLg : findAll()) {
            remove(eeLg);
        }
    }

    /**
     * Returns the number of e e lgs.
     *
     * @return the number of e e lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_EELG);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the e e lg persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.EELg")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<EELg>> listenersList = new ArrayList<ModelListener<EELg>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<EELg>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(EELgImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
