package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchDocumException;
import gov.va.caret.model.Docum;
import gov.va.caret.model.impl.DocumImpl;
import gov.va.caret.model.impl.DocumModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * The persistence implementation for the docum service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see DocumPersistence
 * @see DocumUtil
 * @generated
 */
public class DocumPersistenceImpl extends BasePersistenceImpl<Docum>
    implements DocumPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link DocumUtil} to access the docum persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = DocumImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(DocumModelImpl.ENTITY_CACHE_ENABLED,
            DocumModelImpl.FINDER_CACHE_ENABLED, DocumImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(DocumModelImpl.ENTITY_CACHE_ENABLED,
            DocumModelImpl.FINDER_CACHE_ENABLED, DocumImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(DocumModelImpl.ENTITY_CACHE_ENABLED,
            DocumModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_TYPE = new FinderPath(DocumModelImpl.ENTITY_CACHE_ENABLED,
            DocumModelImpl.FINDER_CACHE_ENABLED, DocumImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByType",
            new String[] {
                Long.class.getName(), Long.class.getName(),
                String.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_TYPE = new FinderPath(DocumModelImpl.ENTITY_CACHE_ENABLED,
            DocumModelImpl.FINDER_CACHE_ENABLED, DocumImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByType",
            new String[] {
                Long.class.getName(), Long.class.getName(),
                String.class.getName()
            },
            DocumModelImpl.CLASSPK_COLUMN_BITMASK |
            DocumModelImpl.CLASSID_COLUMN_BITMASK |
            DocumModelImpl.TYPE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_TYPE = new FinderPath(DocumModelImpl.ENTITY_CACHE_ENABLED,
            DocumModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByType",
            new String[] {
                Long.class.getName(), Long.class.getName(),
                String.class.getName()
            });
    private static final String _FINDER_COLUMN_TYPE_CLASSPK_2 = "docum.classPk = ? AND ";
    private static final String _FINDER_COLUMN_TYPE_CLASSID_2 = "docum.classId = ? AND ";
    private static final String _FINDER_COLUMN_TYPE_TYPE_1 = "docum.type IS NULL";
    private static final String _FINDER_COLUMN_TYPE_TYPE_2 = "docum.type = ?";
    private static final String _FINDER_COLUMN_TYPE_TYPE_3 = "(docum.type IS NULL OR docum.type = '')";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_CLASSPK = new FinderPath(DocumModelImpl.ENTITY_CACHE_ENABLED,
            DocumModelImpl.FINDER_CACHE_ENABLED, DocumImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByClassPk",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CLASSPK =
        new FinderPath(DocumModelImpl.ENTITY_CACHE_ENABLED,
            DocumModelImpl.FINDER_CACHE_ENABLED, DocumImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByClassPk",
            new String[] { Long.class.getName() },
            DocumModelImpl.CLASSPK_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_CLASSPK = new FinderPath(DocumModelImpl.ENTITY_CACHE_ENABLED,
            DocumModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByClassPk",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_CLASSPK_CLASSPK_2 = "docum.classPk = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_CLASSID = new FinderPath(DocumModelImpl.ENTITY_CACHE_ENABLED,
            DocumModelImpl.FINDER_CACHE_ENABLED, DocumImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByClassId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CLASSID =
        new FinderPath(DocumModelImpl.ENTITY_CACHE_ENABLED,
            DocumModelImpl.FINDER_CACHE_ENABLED, DocumImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByClassId",
            new String[] { Long.class.getName() },
            DocumModelImpl.CLASSID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_CLASSID = new FinderPath(DocumModelImpl.ENTITY_CACHE_ENABLED,
            DocumModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByClassId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_CLASSID_CLASSID_2 = "docum.classId = ?";
    private static final String _SQL_SELECT_DOCUM = "SELECT docum FROM Docum docum";
    private static final String _SQL_SELECT_DOCUM_WHERE = "SELECT docum FROM Docum docum WHERE ";
    private static final String _SQL_COUNT_DOCUM = "SELECT COUNT(docum) FROM Docum docum";
    private static final String _SQL_COUNT_DOCUM_WHERE = "SELECT COUNT(docum) FROM Docum docum WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "docum.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Docum exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Docum exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(DocumPersistenceImpl.class);
    private static Set<String> _badColumnNames = SetUtil.fromArray(new String[] {
                "type"
            });
    private static Docum _nullDocum = new DocumImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<Docum> toCacheModel() {
                return _nullDocumCacheModel;
            }
        };

    private static CacheModel<Docum> _nullDocumCacheModel = new CacheModel<Docum>() {
            @Override
            public Docum toEntityModel() {
                return _nullDocum;
            }
        };

    public DocumPersistenceImpl() {
        setModelClass(Docum.class);
    }

    /**
     * Returns all the docums where classPk = &#63; and classId = &#63; and type = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @return the matching docums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Docum> findByType(long classPk, long classId, String type)
        throws SystemException {
        return findByType(classPk, classId, type, QueryUtil.ALL_POS,
            QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the docums where classPk = &#63; and classId = &#63; and type = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param start the lower bound of the range of docums
     * @param end the upper bound of the range of docums (not inclusive)
     * @return the range of matching docums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Docum> findByType(long classPk, long classId, String type,
        int start, int end) throws SystemException {
        return findByType(classPk, classId, type, start, end, null);
    }

    /**
     * Returns an ordered range of all the docums where classPk = &#63; and classId = &#63; and type = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param start the lower bound of the range of docums
     * @param end the upper bound of the range of docums (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching docums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Docum> findByType(long classPk, long classId, String type,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_TYPE;
            finderArgs = new Object[] { classPk, classId, type };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_TYPE;
            finderArgs = new Object[] {
                    classPk, classId, type,
                    
                    start, end, orderByComparator
                };
        }

        List<Docum> list = (List<Docum>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (Docum docum : list) {
                if ((classPk != docum.getClassPk()) ||
                        (classId != docum.getClassId()) ||
                        !Validator.equals(type, docum.getType())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(5 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(5);
            }

            query.append(_SQL_SELECT_DOCUM_WHERE);

            query.append(_FINDER_COLUMN_TYPE_CLASSPK_2);

            query.append(_FINDER_COLUMN_TYPE_CLASSID_2);

            boolean bindType = false;

            if (type == null) {
                query.append(_FINDER_COLUMN_TYPE_TYPE_1);
            } else if (type.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_TYPE_TYPE_3);
            } else {
                bindType = true;

                query.append(_FINDER_COLUMN_TYPE_TYPE_2);
            }

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(DocumModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(classPk);

                qPos.add(classId);

                if (bindType) {
                    qPos.add(type);
                }

                if (!pagination) {
                    list = (List<Docum>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Docum>(list);
                } else {
                    list = (List<Docum>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first docum in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching docum
     * @throws gov.va.caret.NoSuchDocumException if a matching docum could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum findByType_First(long classPk, long classId, String type,
        OrderByComparator orderByComparator)
        throws NoSuchDocumException, SystemException {
        Docum docum = fetchByType_First(classPk, classId, type,
                orderByComparator);

        if (docum != null) {
            return docum;
        }

        StringBundler msg = new StringBundler(8);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("classPk=");
        msg.append(classPk);

        msg.append(", classId=");
        msg.append(classId);

        msg.append(", type=");
        msg.append(type);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchDocumException(msg.toString());
    }

    /**
     * Returns the first docum in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching docum, or <code>null</code> if a matching docum could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum fetchByType_First(long classPk, long classId, String type,
        OrderByComparator orderByComparator) throws SystemException {
        List<Docum> list = findByType(classPk, classId, type, 0, 1,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last docum in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching docum
     * @throws gov.va.caret.NoSuchDocumException if a matching docum could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum findByType_Last(long classPk, long classId, String type,
        OrderByComparator orderByComparator)
        throws NoSuchDocumException, SystemException {
        Docum docum = fetchByType_Last(classPk, classId, type, orderByComparator);

        if (docum != null) {
            return docum;
        }

        StringBundler msg = new StringBundler(8);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("classPk=");
        msg.append(classPk);

        msg.append(", classId=");
        msg.append(classId);

        msg.append(", type=");
        msg.append(type);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchDocumException(msg.toString());
    }

    /**
     * Returns the last docum in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching docum, or <code>null</code> if a matching docum could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum fetchByType_Last(long classPk, long classId, String type,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByType(classPk, classId, type);

        if (count == 0) {
            return null;
        }

        List<Docum> list = findByType(classPk, classId, type, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the docums before and after the current docum in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
     *
     * @param documId the primary key of the current docum
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next docum
     * @throws gov.va.caret.NoSuchDocumException if a docum with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum[] findByType_PrevAndNext(long documId, long classPk,
        long classId, String type, OrderByComparator orderByComparator)
        throws NoSuchDocumException, SystemException {
        Docum docum = findByPrimaryKey(documId);

        Session session = null;

        try {
            session = openSession();

            Docum[] array = new DocumImpl[3];

            array[0] = getByType_PrevAndNext(session, docum, classPk, classId,
                    type, orderByComparator, true);

            array[1] = docum;

            array[2] = getByType_PrevAndNext(session, docum, classPk, classId,
                    type, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected Docum getByType_PrevAndNext(Session session, Docum docum,
        long classPk, long classId, String type,
        OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_DOCUM_WHERE);

        query.append(_FINDER_COLUMN_TYPE_CLASSPK_2);

        query.append(_FINDER_COLUMN_TYPE_CLASSID_2);

        boolean bindType = false;

        if (type == null) {
            query.append(_FINDER_COLUMN_TYPE_TYPE_1);
        } else if (type.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_TYPE_TYPE_3);
        } else {
            bindType = true;

            query.append(_FINDER_COLUMN_TYPE_TYPE_2);
        }

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(DocumModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(classPk);

        qPos.add(classId);

        if (bindType) {
            qPos.add(type);
        }

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(docum);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<Docum> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the docums where classPk = &#63; and classId = &#63; and type = &#63; from the database.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByType(long classPk, long classId, String type)
        throws SystemException {
        for (Docum docum : findByType(classPk, classId, type,
                QueryUtil.ALL_POS, QueryUtil.ALL_POS, null)) {
            remove(docum);
        }
    }

    /**
     * Returns the number of docums where classPk = &#63; and classId = &#63; and type = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @return the number of matching docums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByType(long classPk, long classId, String type)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_TYPE;

        Object[] finderArgs = new Object[] { classPk, classId, type };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(4);

            query.append(_SQL_COUNT_DOCUM_WHERE);

            query.append(_FINDER_COLUMN_TYPE_CLASSPK_2);

            query.append(_FINDER_COLUMN_TYPE_CLASSID_2);

            boolean bindType = false;

            if (type == null) {
                query.append(_FINDER_COLUMN_TYPE_TYPE_1);
            } else if (type.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_TYPE_TYPE_3);
            } else {
                bindType = true;

                query.append(_FINDER_COLUMN_TYPE_TYPE_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(classPk);

                qPos.add(classId);

                if (bindType) {
                    qPos.add(type);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the docums where classPk = &#63;.
     *
     * @param classPk the class pk
     * @return the matching docums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Docum> findByClassPk(long classPk) throws SystemException {
        return findByClassPk(classPk, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the docums where classPk = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param classPk the class pk
     * @param start the lower bound of the range of docums
     * @param end the upper bound of the range of docums (not inclusive)
     * @return the range of matching docums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Docum> findByClassPk(long classPk, int start, int end)
        throws SystemException {
        return findByClassPk(classPk, start, end, null);
    }

    /**
     * Returns an ordered range of all the docums where classPk = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param classPk the class pk
     * @param start the lower bound of the range of docums
     * @param end the upper bound of the range of docums (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching docums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Docum> findByClassPk(long classPk, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CLASSPK;
            finderArgs = new Object[] { classPk };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_CLASSPK;
            finderArgs = new Object[] { classPk, start, end, orderByComparator };
        }

        List<Docum> list = (List<Docum>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (Docum docum : list) {
                if ((classPk != docum.getClassPk())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_DOCUM_WHERE);

            query.append(_FINDER_COLUMN_CLASSPK_CLASSPK_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(DocumModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(classPk);

                if (!pagination) {
                    list = (List<Docum>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Docum>(list);
                } else {
                    list = (List<Docum>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first docum in the ordered set where classPk = &#63;.
     *
     * @param classPk the class pk
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching docum
     * @throws gov.va.caret.NoSuchDocumException if a matching docum could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum findByClassPk_First(long classPk,
        OrderByComparator orderByComparator)
        throws NoSuchDocumException, SystemException {
        Docum docum = fetchByClassPk_First(classPk, orderByComparator);

        if (docum != null) {
            return docum;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("classPk=");
        msg.append(classPk);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchDocumException(msg.toString());
    }

    /**
     * Returns the first docum in the ordered set where classPk = &#63;.
     *
     * @param classPk the class pk
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching docum, or <code>null</code> if a matching docum could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum fetchByClassPk_First(long classPk,
        OrderByComparator orderByComparator) throws SystemException {
        List<Docum> list = findByClassPk(classPk, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last docum in the ordered set where classPk = &#63;.
     *
     * @param classPk the class pk
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching docum
     * @throws gov.va.caret.NoSuchDocumException if a matching docum could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum findByClassPk_Last(long classPk,
        OrderByComparator orderByComparator)
        throws NoSuchDocumException, SystemException {
        Docum docum = fetchByClassPk_Last(classPk, orderByComparator);

        if (docum != null) {
            return docum;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("classPk=");
        msg.append(classPk);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchDocumException(msg.toString());
    }

    /**
     * Returns the last docum in the ordered set where classPk = &#63;.
     *
     * @param classPk the class pk
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching docum, or <code>null</code> if a matching docum could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum fetchByClassPk_Last(long classPk,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByClassPk(classPk);

        if (count == 0) {
            return null;
        }

        List<Docum> list = findByClassPk(classPk, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the docums before and after the current docum in the ordered set where classPk = &#63;.
     *
     * @param documId the primary key of the current docum
     * @param classPk the class pk
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next docum
     * @throws gov.va.caret.NoSuchDocumException if a docum with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum[] findByClassPk_PrevAndNext(long documId, long classPk,
        OrderByComparator orderByComparator)
        throws NoSuchDocumException, SystemException {
        Docum docum = findByPrimaryKey(documId);

        Session session = null;

        try {
            session = openSession();

            Docum[] array = new DocumImpl[3];

            array[0] = getByClassPk_PrevAndNext(session, docum, classPk,
                    orderByComparator, true);

            array[1] = docum;

            array[2] = getByClassPk_PrevAndNext(session, docum, classPk,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected Docum getByClassPk_PrevAndNext(Session session, Docum docum,
        long classPk, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_DOCUM_WHERE);

        query.append(_FINDER_COLUMN_CLASSPK_CLASSPK_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(DocumModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(classPk);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(docum);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<Docum> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the docums where classPk = &#63; from the database.
     *
     * @param classPk the class pk
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByClassPk(long classPk) throws SystemException {
        for (Docum docum : findByClassPk(classPk, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(docum);
        }
    }

    /**
     * Returns the number of docums where classPk = &#63;.
     *
     * @param classPk the class pk
     * @return the number of matching docums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByClassPk(long classPk) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_CLASSPK;

        Object[] finderArgs = new Object[] { classPk };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_DOCUM_WHERE);

            query.append(_FINDER_COLUMN_CLASSPK_CLASSPK_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(classPk);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the docums where classId = &#63;.
     *
     * @param classId the class ID
     * @return the matching docums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Docum> findByClassId(long classId) throws SystemException {
        return findByClassId(classId, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the docums where classId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param classId the class ID
     * @param start the lower bound of the range of docums
     * @param end the upper bound of the range of docums (not inclusive)
     * @return the range of matching docums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Docum> findByClassId(long classId, int start, int end)
        throws SystemException {
        return findByClassId(classId, start, end, null);
    }

    /**
     * Returns an ordered range of all the docums where classId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param classId the class ID
     * @param start the lower bound of the range of docums
     * @param end the upper bound of the range of docums (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching docums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Docum> findByClassId(long classId, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CLASSID;
            finderArgs = new Object[] { classId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_CLASSID;
            finderArgs = new Object[] { classId, start, end, orderByComparator };
        }

        List<Docum> list = (List<Docum>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (Docum docum : list) {
                if ((classId != docum.getClassId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_DOCUM_WHERE);

            query.append(_FINDER_COLUMN_CLASSID_CLASSID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(DocumModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(classId);

                if (!pagination) {
                    list = (List<Docum>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Docum>(list);
                } else {
                    list = (List<Docum>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first docum in the ordered set where classId = &#63;.
     *
     * @param classId the class ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching docum
     * @throws gov.va.caret.NoSuchDocumException if a matching docum could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum findByClassId_First(long classId,
        OrderByComparator orderByComparator)
        throws NoSuchDocumException, SystemException {
        Docum docum = fetchByClassId_First(classId, orderByComparator);

        if (docum != null) {
            return docum;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("classId=");
        msg.append(classId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchDocumException(msg.toString());
    }

    /**
     * Returns the first docum in the ordered set where classId = &#63;.
     *
     * @param classId the class ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching docum, or <code>null</code> if a matching docum could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum fetchByClassId_First(long classId,
        OrderByComparator orderByComparator) throws SystemException {
        List<Docum> list = findByClassId(classId, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last docum in the ordered set where classId = &#63;.
     *
     * @param classId the class ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching docum
     * @throws gov.va.caret.NoSuchDocumException if a matching docum could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum findByClassId_Last(long classId,
        OrderByComparator orderByComparator)
        throws NoSuchDocumException, SystemException {
        Docum docum = fetchByClassId_Last(classId, orderByComparator);

        if (docum != null) {
            return docum;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("classId=");
        msg.append(classId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchDocumException(msg.toString());
    }

    /**
     * Returns the last docum in the ordered set where classId = &#63;.
     *
     * @param classId the class ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching docum, or <code>null</code> if a matching docum could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum fetchByClassId_Last(long classId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByClassId(classId);

        if (count == 0) {
            return null;
        }

        List<Docum> list = findByClassId(classId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the docums before and after the current docum in the ordered set where classId = &#63;.
     *
     * @param documId the primary key of the current docum
     * @param classId the class ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next docum
     * @throws gov.va.caret.NoSuchDocumException if a docum with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum[] findByClassId_PrevAndNext(long documId, long classId,
        OrderByComparator orderByComparator)
        throws NoSuchDocumException, SystemException {
        Docum docum = findByPrimaryKey(documId);

        Session session = null;

        try {
            session = openSession();

            Docum[] array = new DocumImpl[3];

            array[0] = getByClassId_PrevAndNext(session, docum, classId,
                    orderByComparator, true);

            array[1] = docum;

            array[2] = getByClassId_PrevAndNext(session, docum, classId,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected Docum getByClassId_PrevAndNext(Session session, Docum docum,
        long classId, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_DOCUM_WHERE);

        query.append(_FINDER_COLUMN_CLASSID_CLASSID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(DocumModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(classId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(docum);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<Docum> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the docums where classId = &#63; from the database.
     *
     * @param classId the class ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByClassId(long classId) throws SystemException {
        for (Docum docum : findByClassId(classId, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(docum);
        }
    }

    /**
     * Returns the number of docums where classId = &#63;.
     *
     * @param classId the class ID
     * @return the number of matching docums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByClassId(long classId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_CLASSID;

        Object[] finderArgs = new Object[] { classId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_DOCUM_WHERE);

            query.append(_FINDER_COLUMN_CLASSID_CLASSID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(classId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the docum in the entity cache if it is enabled.
     *
     * @param docum the docum
     */
    @Override
    public void cacheResult(Docum docum) {
        EntityCacheUtil.putResult(DocumModelImpl.ENTITY_CACHE_ENABLED,
            DocumImpl.class, docum.getPrimaryKey(), docum);

        docum.resetOriginalValues();
    }

    /**
     * Caches the docums in the entity cache if it is enabled.
     *
     * @param docums the docums
     */
    @Override
    public void cacheResult(List<Docum> docums) {
        for (Docum docum : docums) {
            if (EntityCacheUtil.getResult(DocumModelImpl.ENTITY_CACHE_ENABLED,
                        DocumImpl.class, docum.getPrimaryKey()) == null) {
                cacheResult(docum);
            } else {
                docum.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all docums.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(DocumImpl.class.getName());
        }

        EntityCacheUtil.clearCache(DocumImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the docum.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(Docum docum) {
        EntityCacheUtil.removeResult(DocumModelImpl.ENTITY_CACHE_ENABLED,
            DocumImpl.class, docum.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<Docum> docums) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (Docum docum : docums) {
            EntityCacheUtil.removeResult(DocumModelImpl.ENTITY_CACHE_ENABLED,
                DocumImpl.class, docum.getPrimaryKey());
        }
    }

    /**
     * Creates a new docum with the primary key. Does not add the docum to the database.
     *
     * @param documId the primary key for the new docum
     * @return the new docum
     */
    @Override
    public Docum create(long documId) {
        Docum docum = new DocumImpl();

        docum.setNew(true);
        docum.setPrimaryKey(documId);

        return docum;
    }

    /**
     * Removes the docum with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param documId the primary key of the docum
     * @return the docum that was removed
     * @throws gov.va.caret.NoSuchDocumException if a docum with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum remove(long documId)
        throws NoSuchDocumException, SystemException {
        return remove((Serializable) documId);
    }

    /**
     * Removes the docum with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the docum
     * @return the docum that was removed
     * @throws gov.va.caret.NoSuchDocumException if a docum with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum remove(Serializable primaryKey)
        throws NoSuchDocumException, SystemException {
        Session session = null;

        try {
            session = openSession();

            Docum docum = (Docum) session.get(DocumImpl.class, primaryKey);

            if (docum == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchDocumException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(docum);
        } catch (NoSuchDocumException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected Docum removeImpl(Docum docum) throws SystemException {
        docum = toUnwrappedModel(docum);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(docum)) {
                docum = (Docum) session.get(DocumImpl.class,
                        docum.getPrimaryKeyObj());
            }

            if (docum != null) {
                session.delete(docum);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (docum != null) {
            clearCache(docum);
        }

        return docum;
    }

    @Override
    public Docum updateImpl(gov.va.caret.model.Docum docum)
        throws SystemException {
        docum = toUnwrappedModel(docum);

        boolean isNew = docum.isNew();

        DocumModelImpl documModelImpl = (DocumModelImpl) docum;

        Session session = null;

        try {
            session = openSession();

            if (docum.isNew()) {
                session.save(docum);

                docum.setNew(false);
            } else {
                session.evict(docum);
                session.saveOrUpdate(docum);
            }

            session.flush();
            session.clear();
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !DocumModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((documModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_TYPE.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        documModelImpl.getOriginalClassPk(),
                        documModelImpl.getOriginalClassId(),
                        documModelImpl.getOriginalType()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_TYPE, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_TYPE,
                    args);

                args = new Object[] {
                        documModelImpl.getClassPk(), documModelImpl.getClassId(),
                        documModelImpl.getType()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_TYPE, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_TYPE,
                    args);
            }

            if ((documModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CLASSPK.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { documModelImpl.getOriginalClassPk() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_CLASSPK, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CLASSPK,
                    args);

                args = new Object[] { documModelImpl.getClassPk() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_CLASSPK, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CLASSPK,
                    args);
            }

            if ((documModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CLASSID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { documModelImpl.getOriginalClassId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_CLASSID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CLASSID,
                    args);

                args = new Object[] { documModelImpl.getClassId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_CLASSID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CLASSID,
                    args);
            }
        }

        EntityCacheUtil.putResult(DocumModelImpl.ENTITY_CACHE_ENABLED,
            DocumImpl.class, docum.getPrimaryKey(), docum);

        docum.resetOriginalValues();

        return docum;
    }

    protected Docum toUnwrappedModel(Docum docum) {
        if (docum instanceof DocumImpl) {
            return docum;
        }

        DocumImpl documImpl = new DocumImpl();

        documImpl.setNew(docum.isNew());
        documImpl.setPrimaryKey(docum.getPrimaryKey());

        documImpl.setDocumId(docum.getDocumId());
        documImpl.setDocument(docum.getDocument());
        documImpl.setClassId(docum.getClassId());
        documImpl.setClassPk(docum.getClassPk());
        documImpl.setName(docum.getName());
        documImpl.setType(docum.getType());

        return documImpl;
    }

    /**
     * Returns the docum with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the docum
     * @return the docum
     * @throws gov.va.caret.NoSuchDocumException if a docum with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum findByPrimaryKey(Serializable primaryKey)
        throws NoSuchDocumException, SystemException {
        Docum docum = fetchByPrimaryKey(primaryKey);

        if (docum == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchDocumException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return docum;
    }

    /**
     * Returns the docum with the primary key or throws a {@link gov.va.caret.NoSuchDocumException} if it could not be found.
     *
     * @param documId the primary key of the docum
     * @return the docum
     * @throws gov.va.caret.NoSuchDocumException if a docum with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum findByPrimaryKey(long documId)
        throws NoSuchDocumException, SystemException {
        return findByPrimaryKey((Serializable) documId);
    }

    /**
     * Returns the docum with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the docum
     * @return the docum, or <code>null</code> if a docum with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        Docum docum = (Docum) EntityCacheUtil.getResult(DocumModelImpl.ENTITY_CACHE_ENABLED,
                DocumImpl.class, primaryKey);

        if (docum == _nullDocum) {
            return null;
        }

        if (docum == null) {
            Session session = null;

            try {
                session = openSession();

                docum = (Docum) session.get(DocumImpl.class, primaryKey);

                if (docum != null) {
                    cacheResult(docum);
                } else {
                    EntityCacheUtil.putResult(DocumModelImpl.ENTITY_CACHE_ENABLED,
                        DocumImpl.class, primaryKey, _nullDocum);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(DocumModelImpl.ENTITY_CACHE_ENABLED,
                    DocumImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return docum;
    }

    /**
     * Returns the docum with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param documId the primary key of the docum
     * @return the docum, or <code>null</code> if a docum with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Docum fetchByPrimaryKey(long documId) throws SystemException {
        return fetchByPrimaryKey((Serializable) documId);
    }

    /**
     * Returns all the docums.
     *
     * @return the docums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Docum> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the docums.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of docums
     * @param end the upper bound of the range of docums (not inclusive)
     * @return the range of docums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Docum> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the docums.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of docums
     * @param end the upper bound of the range of docums (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of docums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Docum> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<Docum> list = (List<Docum>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_DOCUM);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_DOCUM;

                if (pagination) {
                    sql = sql.concat(DocumModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<Docum>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Docum>(list);
                } else {
                    list = (List<Docum>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the docums from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (Docum docum : findAll()) {
            remove(docum);
        }
    }

    /**
     * Returns the number of docums.
     *
     * @return the number of docums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_DOCUM);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    @Override
    protected Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    /**
     * Initializes the docum persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.Docum")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<Docum>> listenersList = new ArrayList<ModelListener<Docum>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<Docum>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(DocumImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
