package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchClSocException;
import gov.va.caret.model.ClSoc;
import gov.va.caret.model.impl.ClSocImpl;
import gov.va.caret.model.impl.ClSocModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The persistence implementation for the cl soc service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see ClSocPersistence
 * @see ClSocUtil
 * @generated
 */
public class ClSocPersistenceImpl extends BasePersistenceImpl<ClSoc>
    implements ClSocPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link ClSocUtil} to access the cl soc persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = ClSocImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(ClSocModelImpl.ENTITY_CACHE_ENABLED,
            ClSocModelImpl.FINDER_CACHE_ENABLED, ClSocImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(ClSocModelImpl.ENTITY_CACHE_ENABLED,
            ClSocModelImpl.FINDER_CACHE_ENABLED, ClSocImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(ClSocModelImpl.ENTITY_CACHE_ENABLED,
            ClSocModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_CALLID = new FinderPath(ClSocModelImpl.ENTITY_CACHE_ENABLED,
            ClSocModelImpl.FINDER_CACHE_ENABLED, ClSocImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCallId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLID =
        new FinderPath(ClSocModelImpl.ENTITY_CACHE_ENABLED,
            ClSocModelImpl.FINDER_CACHE_ENABLED, ClSocImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCallId",
            new String[] { Long.class.getName() },
            ClSocModelImpl.CALLID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_CALLID = new FinderPath(ClSocModelImpl.ENTITY_CACHE_ENABLED,
            ClSocModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCallId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_CALLID_CALLID_2 = "clSoc.callId = ?";
    private static final String _SQL_SELECT_CLSOC = "SELECT clSoc FROM ClSoc clSoc";
    private static final String _SQL_SELECT_CLSOC_WHERE = "SELECT clSoc FROM ClSoc clSoc WHERE ";
    private static final String _SQL_COUNT_CLSOC = "SELECT COUNT(clSoc) FROM ClSoc clSoc";
    private static final String _SQL_COUNT_CLSOC_WHERE = "SELECT COUNT(clSoc) FROM ClSoc clSoc WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "clSoc.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ClSoc exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ClSoc exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(ClSocPersistenceImpl.class);
    private static ClSoc _nullClSoc = new ClSocImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<ClSoc> toCacheModel() {
                return _nullClSocCacheModel;
            }
        };

    private static CacheModel<ClSoc> _nullClSocCacheModel = new CacheModel<ClSoc>() {
            @Override
            public ClSoc toEntityModel() {
                return _nullClSoc;
            }
        };

    public ClSocPersistenceImpl() {
        setModelClass(ClSoc.class);
    }

    /**
     * Returns all the cl socs where callId = &#63;.
     *
     * @param callId the call ID
     * @return the matching cl socs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<ClSoc> findByCallId(long callId) throws SystemException {
        return findByCallId(callId, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the cl socs where callId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ClSocModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param callId the call ID
     * @param start the lower bound of the range of cl socs
     * @param end the upper bound of the range of cl socs (not inclusive)
     * @return the range of matching cl socs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<ClSoc> findByCallId(long callId, int start, int end)
        throws SystemException {
        return findByCallId(callId, start, end, null);
    }

    /**
     * Returns an ordered range of all the cl socs where callId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ClSocModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param callId the call ID
     * @param start the lower bound of the range of cl socs
     * @param end the upper bound of the range of cl socs (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching cl socs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<ClSoc> findByCallId(long callId, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLID;
            finderArgs = new Object[] { callId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_CALLID;
            finderArgs = new Object[] { callId, start, end, orderByComparator };
        }

        List<ClSoc> list = (List<ClSoc>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (ClSoc clSoc : list) {
                if ((callId != clSoc.getCallId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_CLSOC_WHERE);

            query.append(_FINDER_COLUMN_CALLID_CALLID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(ClSocModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(callId);

                if (!pagination) {
                    list = (List<ClSoc>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<ClSoc>(list);
                } else {
                    list = (List<ClSoc>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first cl soc in the ordered set where callId = &#63;.
     *
     * @param callId the call ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching cl soc
     * @throws gov.va.caret.NoSuchClSocException if a matching cl soc could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ClSoc findByCallId_First(long callId,
        OrderByComparator orderByComparator)
        throws NoSuchClSocException, SystemException {
        ClSoc clSoc = fetchByCallId_First(callId, orderByComparator);

        if (clSoc != null) {
            return clSoc;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("callId=");
        msg.append(callId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchClSocException(msg.toString());
    }

    /**
     * Returns the first cl soc in the ordered set where callId = &#63;.
     *
     * @param callId the call ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching cl soc, or <code>null</code> if a matching cl soc could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ClSoc fetchByCallId_First(long callId,
        OrderByComparator orderByComparator) throws SystemException {
        List<ClSoc> list = findByCallId(callId, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last cl soc in the ordered set where callId = &#63;.
     *
     * @param callId the call ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching cl soc
     * @throws gov.va.caret.NoSuchClSocException if a matching cl soc could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ClSoc findByCallId_Last(long callId,
        OrderByComparator orderByComparator)
        throws NoSuchClSocException, SystemException {
        ClSoc clSoc = fetchByCallId_Last(callId, orderByComparator);

        if (clSoc != null) {
            return clSoc;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("callId=");
        msg.append(callId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchClSocException(msg.toString());
    }

    /**
     * Returns the last cl soc in the ordered set where callId = &#63;.
     *
     * @param callId the call ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching cl soc, or <code>null</code> if a matching cl soc could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ClSoc fetchByCallId_Last(long callId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByCallId(callId);

        if (count == 0) {
            return null;
        }

        List<ClSoc> list = findByCallId(callId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the cl socs before and after the current cl soc in the ordered set where callId = &#63;.
     *
     * @param clSocId the primary key of the current cl soc
     * @param callId the call ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next cl soc
     * @throws gov.va.caret.NoSuchClSocException if a cl soc with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ClSoc[] findByCallId_PrevAndNext(long clSocId, long callId,
        OrderByComparator orderByComparator)
        throws NoSuchClSocException, SystemException {
        ClSoc clSoc = findByPrimaryKey(clSocId);

        Session session = null;

        try {
            session = openSession();

            ClSoc[] array = new ClSocImpl[3];

            array[0] = getByCallId_PrevAndNext(session, clSoc, callId,
                    orderByComparator, true);

            array[1] = clSoc;

            array[2] = getByCallId_PrevAndNext(session, clSoc, callId,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected ClSoc getByCallId_PrevAndNext(Session session, ClSoc clSoc,
        long callId, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_CLSOC_WHERE);

        query.append(_FINDER_COLUMN_CALLID_CALLID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(ClSocModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(callId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(clSoc);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<ClSoc> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the cl socs where callId = &#63; from the database.
     *
     * @param callId the call ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByCallId(long callId) throws SystemException {
        for (ClSoc clSoc : findByCallId(callId, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(clSoc);
        }
    }

    /**
     * Returns the number of cl socs where callId = &#63;.
     *
     * @param callId the call ID
     * @return the number of matching cl socs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByCallId(long callId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_CALLID;

        Object[] finderArgs = new Object[] { callId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_CLSOC_WHERE);

            query.append(_FINDER_COLUMN_CALLID_CALLID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(callId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the cl soc in the entity cache if it is enabled.
     *
     * @param clSoc the cl soc
     */
    @Override
    public void cacheResult(ClSoc clSoc) {
        EntityCacheUtil.putResult(ClSocModelImpl.ENTITY_CACHE_ENABLED,
            ClSocImpl.class, clSoc.getPrimaryKey(), clSoc);

        clSoc.resetOriginalValues();
    }

    /**
     * Caches the cl socs in the entity cache if it is enabled.
     *
     * @param clSocs the cl socs
     */
    @Override
    public void cacheResult(List<ClSoc> clSocs) {
        for (ClSoc clSoc : clSocs) {
            if (EntityCacheUtil.getResult(ClSocModelImpl.ENTITY_CACHE_ENABLED,
                        ClSocImpl.class, clSoc.getPrimaryKey()) == null) {
                cacheResult(clSoc);
            } else {
                clSoc.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all cl socs.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(ClSocImpl.class.getName());
        }

        EntityCacheUtil.clearCache(ClSocImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the cl soc.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(ClSoc clSoc) {
        EntityCacheUtil.removeResult(ClSocModelImpl.ENTITY_CACHE_ENABLED,
            ClSocImpl.class, clSoc.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<ClSoc> clSocs) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (ClSoc clSoc : clSocs) {
            EntityCacheUtil.removeResult(ClSocModelImpl.ENTITY_CACHE_ENABLED,
                ClSocImpl.class, clSoc.getPrimaryKey());
        }
    }

    /**
     * Creates a new cl soc with the primary key. Does not add the cl soc to the database.
     *
     * @param clSocId the primary key for the new cl soc
     * @return the new cl soc
     */
    @Override
    public ClSoc create(long clSocId) {
        ClSoc clSoc = new ClSocImpl();

        clSoc.setNew(true);
        clSoc.setPrimaryKey(clSocId);

        return clSoc;
    }

    /**
     * Removes the cl soc with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param clSocId the primary key of the cl soc
     * @return the cl soc that was removed
     * @throws gov.va.caret.NoSuchClSocException if a cl soc with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ClSoc remove(long clSocId)
        throws NoSuchClSocException, SystemException {
        return remove((Serializable) clSocId);
    }

    /**
     * Removes the cl soc with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the cl soc
     * @return the cl soc that was removed
     * @throws gov.va.caret.NoSuchClSocException if a cl soc with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ClSoc remove(Serializable primaryKey)
        throws NoSuchClSocException, SystemException {
        Session session = null;

        try {
            session = openSession();

            ClSoc clSoc = (ClSoc) session.get(ClSocImpl.class, primaryKey);

            if (clSoc == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchClSocException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(clSoc);
        } catch (NoSuchClSocException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected ClSoc removeImpl(ClSoc clSoc) throws SystemException {
        clSoc = toUnwrappedModel(clSoc);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(clSoc)) {
                clSoc = (ClSoc) session.get(ClSocImpl.class,
                        clSoc.getPrimaryKeyObj());
            }

            if (clSoc != null) {
                session.delete(clSoc);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (clSoc != null) {
            clearCache(clSoc);
        }

        return clSoc;
    }

    @Override
    public ClSoc updateImpl(gov.va.caret.model.ClSoc clSoc)
        throws SystemException {
        clSoc = toUnwrappedModel(clSoc);

        boolean isNew = clSoc.isNew();

        ClSocModelImpl clSocModelImpl = (ClSocModelImpl) clSoc;

        Session session = null;

        try {
            session = openSession();

            if (clSoc.isNew()) {
                session.save(clSoc);

                clSoc.setNew(false);
            } else {
                session.merge(clSoc);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !ClSocModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((clSocModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { clSocModelImpl.getOriginalCallId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_CALLID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLID,
                    args);

                args = new Object[] { clSocModelImpl.getCallId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_CALLID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLID,
                    args);
            }
        }

        EntityCacheUtil.putResult(ClSocModelImpl.ENTITY_CACHE_ENABLED,
            ClSocImpl.class, clSoc.getPrimaryKey(), clSoc);

        return clSoc;
    }

    protected ClSoc toUnwrappedModel(ClSoc clSoc) {
        if (clSoc instanceof ClSocImpl) {
            return clSoc;
        }

        ClSocImpl clSocImpl = new ClSocImpl();

        clSocImpl.setNew(clSoc.isNew());
        clSocImpl.setPrimaryKey(clSoc.getPrimaryKey());

        clSocImpl.setClSocId(clSoc.getClSocId());
        clSocImpl.setCallId(clSoc.getCallId());
        clSocImpl.setPersnId(clSoc.getPersnId());
        clSocImpl.setSurveyStatus(clSoc.getSurveyStatus());
        clSocImpl.setSurveyComment(clSoc.getSurveyComment());
        clSocImpl.setCreationDate(clSoc.getCreationDate());
        clSocImpl.setAttemptNum(clSoc.getAttemptNum());
        clSocImpl.setCallerAvailable(clSoc.getCallerAvailable());
        clSocImpl.setRequestedCallbackTime(clSoc.getRequestedCallbackTime());
        clSocImpl.setWillingToAnsQues(clSoc.getWillingToAnsQues());
        clSocImpl.setCalledCsl(clSoc.getCalledCsl());
        clSocImpl.setCslKnowledgable(clSoc.getCslKnowledgable());
        clSocImpl.setCslSupportive(clSoc.getCslSupportive());
        clSocImpl.setLocalResSuggested(clSoc.getLocalResSuggested());
        clSocImpl.setLocalResContacted(clSoc.getLocalResContacted());
        clSocImpl.setRsnLocalResNotContacted(clSoc.getRsnLocalResNotContacted());
        clSocImpl.setLocalResHelpful(clSoc.getLocalResHelpful());
        clSocImpl.setConcernsAnswered(clSoc.getConcernsAnswered());
        clSocImpl.setUnderstandNextSteps(clSoc.getUnderstandNextSteps());
        clSocImpl.setCallCslAgain(clSoc.getCallCslAgain());
        clSocImpl.setRecommendCsl(clSoc.getRecommendCsl());
        clSocImpl.setSuggestions(clSoc.getSuggestions());
        clSocImpl.setFollowupCall(clSoc.getFollowupCall());
        clSocImpl.setFollowupCallTime(clSoc.getFollowupCallTime());
        clSocImpl.setTresholdMet(clSoc.getTresholdMet());

        return clSocImpl;
    }

    /**
     * Returns the cl soc with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the cl soc
     * @return the cl soc
     * @throws gov.va.caret.NoSuchClSocException if a cl soc with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ClSoc findByPrimaryKey(Serializable primaryKey)
        throws NoSuchClSocException, SystemException {
        ClSoc clSoc = fetchByPrimaryKey(primaryKey);

        if (clSoc == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchClSocException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return clSoc;
    }

    /**
     * Returns the cl soc with the primary key or throws a {@link gov.va.caret.NoSuchClSocException} if it could not be found.
     *
     * @param clSocId the primary key of the cl soc
     * @return the cl soc
     * @throws gov.va.caret.NoSuchClSocException if a cl soc with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ClSoc findByPrimaryKey(long clSocId)
        throws NoSuchClSocException, SystemException {
        return findByPrimaryKey((Serializable) clSocId);
    }

    /**
     * Returns the cl soc with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the cl soc
     * @return the cl soc, or <code>null</code> if a cl soc with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ClSoc fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        ClSoc clSoc = (ClSoc) EntityCacheUtil.getResult(ClSocModelImpl.ENTITY_CACHE_ENABLED,
                ClSocImpl.class, primaryKey);

        if (clSoc == _nullClSoc) {
            return null;
        }

        if (clSoc == null) {
            Session session = null;

            try {
                session = openSession();

                clSoc = (ClSoc) session.get(ClSocImpl.class, primaryKey);

                if (clSoc != null) {
                    cacheResult(clSoc);
                } else {
                    EntityCacheUtil.putResult(ClSocModelImpl.ENTITY_CACHE_ENABLED,
                        ClSocImpl.class, primaryKey, _nullClSoc);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(ClSocModelImpl.ENTITY_CACHE_ENABLED,
                    ClSocImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return clSoc;
    }

    /**
     * Returns the cl soc with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param clSocId the primary key of the cl soc
     * @return the cl soc, or <code>null</code> if a cl soc with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public ClSoc fetchByPrimaryKey(long clSocId) throws SystemException {
        return fetchByPrimaryKey((Serializable) clSocId);
    }

    /**
     * Returns all the cl socs.
     *
     * @return the cl socs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<ClSoc> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the cl socs.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ClSocModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of cl socs
     * @param end the upper bound of the range of cl socs (not inclusive)
     * @return the range of cl socs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<ClSoc> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the cl socs.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ClSocModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of cl socs
     * @param end the upper bound of the range of cl socs (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of cl socs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<ClSoc> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<ClSoc> list = (List<ClSoc>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_CLSOC);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_CLSOC;

                if (pagination) {
                    sql = sql.concat(ClSocModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<ClSoc>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<ClSoc>(list);
                } else {
                    list = (List<ClSoc>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the cl socs from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (ClSoc clSoc : findAll()) {
            remove(clSoc);
        }
    }

    /**
     * Returns the number of cl socs.
     *
     * @return the number of cl socs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_CLSOC);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the cl soc persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.ClSoc")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<ClSoc>> listenersList = new ArrayList<ModelListener<ClSoc>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<ClSoc>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(ClSocImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
