package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchCalEtException;
import gov.va.caret.model.CalEt;
import gov.va.caret.model.impl.CalEtImpl;
import gov.va.caret.model.impl.CalEtModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * The persistence implementation for the cal et service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see CalEtPersistence
 * @see CalEtUtil
 * @generated
 */
public class CalEtPersistenceImpl extends BasePersistenceImpl<CalEt>
    implements CalEtPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link CalEtUtil} to access the cal et persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = CalEtImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(CalEtModelImpl.ENTITY_CACHE_ENABLED,
            CalEtModelImpl.FINDER_CACHE_ENABLED, CalEtImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(CalEtModelImpl.ENTITY_CACHE_ENABLED,
            CalEtModelImpl.FINDER_CACHE_ENABLED, CalEtImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(CalEtModelImpl.ENTITY_CACHE_ENABLED,
            CalEtModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_CALLID = new FinderPath(CalEtModelImpl.ENTITY_CACHE_ENABLED,
            CalEtModelImpl.FINDER_CACHE_ENABLED, CalEtImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCallId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLID =
        new FinderPath(CalEtModelImpl.ENTITY_CACHE_ENABLED,
            CalEtModelImpl.FINDER_CACHE_ENABLED, CalEtImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCallId",
            new String[] { Long.class.getName() },
            CalEtModelImpl.CALLID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_CALLID = new FinderPath(CalEtModelImpl.ENTITY_CACHE_ENABLED,
            CalEtModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCallId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_CALLID_CALLID_2 = "calEt.callId = ?";
    private static final String _SQL_SELECT_CALET = "SELECT calEt FROM CalEt calEt";
    private static final String _SQL_SELECT_CALET_WHERE = "SELECT calEt FROM CalEt calEt WHERE ";
    private static final String _SQL_COUNT_CALET = "SELECT COUNT(calEt) FROM CalEt calEt";
    private static final String _SQL_COUNT_CALET_WHERE = "SELECT COUNT(calEt) FROM CalEt calEt WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "calEt.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CalEt exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CalEt exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(CalEtPersistenceImpl.class);
    private static Set<String> _badColumnNames = SetUtil.fromArray(new String[] {
                "comment"
            });
    private static CalEt _nullCalEt = new CalEtImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<CalEt> toCacheModel() {
                return _nullCalEtCacheModel;
            }
        };

    private static CacheModel<CalEt> _nullCalEtCacheModel = new CacheModel<CalEt>() {
            @Override
            public CalEt toEntityModel() {
                return _nullCalEt;
            }
        };

    public CalEtPersistenceImpl() {
        setModelClass(CalEt.class);
    }

    /**
     * Returns all the cal ets where callId = &#63;.
     *
     * @param callId the call ID
     * @return the matching cal ets
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<CalEt> findByCallId(long callId) throws SystemException {
        return findByCallId(callId, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the cal ets where callId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CalEtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param callId the call ID
     * @param start the lower bound of the range of cal ets
     * @param end the upper bound of the range of cal ets (not inclusive)
     * @return the range of matching cal ets
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<CalEt> findByCallId(long callId, int start, int end)
        throws SystemException {
        return findByCallId(callId, start, end, null);
    }

    /**
     * Returns an ordered range of all the cal ets where callId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CalEtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param callId the call ID
     * @param start the lower bound of the range of cal ets
     * @param end the upper bound of the range of cal ets (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching cal ets
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<CalEt> findByCallId(long callId, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLID;
            finderArgs = new Object[] { callId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_CALLID;
            finderArgs = new Object[] { callId, start, end, orderByComparator };
        }

        List<CalEt> list = (List<CalEt>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (CalEt calEt : list) {
                if ((callId != calEt.getCallId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_CALET_WHERE);

            query.append(_FINDER_COLUMN_CALLID_CALLID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(CalEtModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(callId);

                if (!pagination) {
                    list = (List<CalEt>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<CalEt>(list);
                } else {
                    list = (List<CalEt>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first cal et in the ordered set where callId = &#63;.
     *
     * @param callId the call ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching cal et
     * @throws gov.va.caret.NoSuchCalEtException if a matching cal et could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public CalEt findByCallId_First(long callId,
        OrderByComparator orderByComparator)
        throws NoSuchCalEtException, SystemException {
        CalEt calEt = fetchByCallId_First(callId, orderByComparator);

        if (calEt != null) {
            return calEt;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("callId=");
        msg.append(callId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchCalEtException(msg.toString());
    }

    /**
     * Returns the first cal et in the ordered set where callId = &#63;.
     *
     * @param callId the call ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching cal et, or <code>null</code> if a matching cal et could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public CalEt fetchByCallId_First(long callId,
        OrderByComparator orderByComparator) throws SystemException {
        List<CalEt> list = findByCallId(callId, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last cal et in the ordered set where callId = &#63;.
     *
     * @param callId the call ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching cal et
     * @throws gov.va.caret.NoSuchCalEtException if a matching cal et could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public CalEt findByCallId_Last(long callId,
        OrderByComparator orderByComparator)
        throws NoSuchCalEtException, SystemException {
        CalEt calEt = fetchByCallId_Last(callId, orderByComparator);

        if (calEt != null) {
            return calEt;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("callId=");
        msg.append(callId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchCalEtException(msg.toString());
    }

    /**
     * Returns the last cal et in the ordered set where callId = &#63;.
     *
     * @param callId the call ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching cal et, or <code>null</code> if a matching cal et could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public CalEt fetchByCallId_Last(long callId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByCallId(callId);

        if (count == 0) {
            return null;
        }

        List<CalEt> list = findByCallId(callId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the cal ets before and after the current cal et in the ordered set where callId = &#63;.
     *
     * @param calEtId the primary key of the current cal et
     * @param callId the call ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next cal et
     * @throws gov.va.caret.NoSuchCalEtException if a cal et with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public CalEt[] findByCallId_PrevAndNext(long calEtId, long callId,
        OrderByComparator orderByComparator)
        throws NoSuchCalEtException, SystemException {
        CalEt calEt = findByPrimaryKey(calEtId);

        Session session = null;

        try {
            session = openSession();

            CalEt[] array = new CalEtImpl[3];

            array[0] = getByCallId_PrevAndNext(session, calEt, callId,
                    orderByComparator, true);

            array[1] = calEt;

            array[2] = getByCallId_PrevAndNext(session, calEt, callId,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected CalEt getByCallId_PrevAndNext(Session session, CalEt calEt,
        long callId, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_CALET_WHERE);

        query.append(_FINDER_COLUMN_CALLID_CALLID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(CalEtModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(callId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(calEt);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<CalEt> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the cal ets where callId = &#63; from the database.
     *
     * @param callId the call ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByCallId(long callId) throws SystemException {
        for (CalEt calEt : findByCallId(callId, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(calEt);
        }
    }

    /**
     * Returns the number of cal ets where callId = &#63;.
     *
     * @param callId the call ID
     * @return the number of matching cal ets
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByCallId(long callId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_CALLID;

        Object[] finderArgs = new Object[] { callId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_CALET_WHERE);

            query.append(_FINDER_COLUMN_CALLID_CALLID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(callId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the cal et in the entity cache if it is enabled.
     *
     * @param calEt the cal et
     */
    @Override
    public void cacheResult(CalEt calEt) {
        EntityCacheUtil.putResult(CalEtModelImpl.ENTITY_CACHE_ENABLED,
            CalEtImpl.class, calEt.getPrimaryKey(), calEt);

        calEt.resetOriginalValues();
    }

    /**
     * Caches the cal ets in the entity cache if it is enabled.
     *
     * @param calEts the cal ets
     */
    @Override
    public void cacheResult(List<CalEt> calEts) {
        for (CalEt calEt : calEts) {
            if (EntityCacheUtil.getResult(CalEtModelImpl.ENTITY_CACHE_ENABLED,
                        CalEtImpl.class, calEt.getPrimaryKey()) == null) {
                cacheResult(calEt);
            } else {
                calEt.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all cal ets.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(CalEtImpl.class.getName());
        }

        EntityCacheUtil.clearCache(CalEtImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the cal et.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(CalEt calEt) {
        EntityCacheUtil.removeResult(CalEtModelImpl.ENTITY_CACHE_ENABLED,
            CalEtImpl.class, calEt.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<CalEt> calEts) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (CalEt calEt : calEts) {
            EntityCacheUtil.removeResult(CalEtModelImpl.ENTITY_CACHE_ENABLED,
                CalEtImpl.class, calEt.getPrimaryKey());
        }
    }

    /**
     * Creates a new cal et with the primary key. Does not add the cal et to the database.
     *
     * @param calEtId the primary key for the new cal et
     * @return the new cal et
     */
    @Override
    public CalEt create(long calEtId) {
        CalEt calEt = new CalEtImpl();

        calEt.setNew(true);
        calEt.setPrimaryKey(calEtId);

        return calEt;
    }

    /**
     * Removes the cal et with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param calEtId the primary key of the cal et
     * @return the cal et that was removed
     * @throws gov.va.caret.NoSuchCalEtException if a cal et with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public CalEt remove(long calEtId)
        throws NoSuchCalEtException, SystemException {
        return remove((Serializable) calEtId);
    }

    /**
     * Removes the cal et with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the cal et
     * @return the cal et that was removed
     * @throws gov.va.caret.NoSuchCalEtException if a cal et with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public CalEt remove(Serializable primaryKey)
        throws NoSuchCalEtException, SystemException {
        Session session = null;

        try {
            session = openSession();

            CalEt calEt = (CalEt) session.get(CalEtImpl.class, primaryKey);

            if (calEt == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchCalEtException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(calEt);
        } catch (NoSuchCalEtException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected CalEt removeImpl(CalEt calEt) throws SystemException {
        calEt = toUnwrappedModel(calEt);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(calEt)) {
                calEt = (CalEt) session.get(CalEtImpl.class,
                        calEt.getPrimaryKeyObj());
            }

            if (calEt != null) {
                session.delete(calEt);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (calEt != null) {
            clearCache(calEt);
        }

        return calEt;
    }

    @Override
    public CalEt updateImpl(gov.va.caret.model.CalEt calEt)
        throws SystemException {
        calEt = toUnwrappedModel(calEt);

        boolean isNew = calEt.isNew();

        CalEtModelImpl calEtModelImpl = (CalEtModelImpl) calEt;

        Session session = null;

        try {
            session = openSession();

            if (calEt.isNew()) {
                session.save(calEt);

                calEt.setNew(false);
            } else {
                session.merge(calEt);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !CalEtModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((calEtModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { calEtModelImpl.getOriginalCallId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_CALLID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLID,
                    args);

                args = new Object[] { calEtModelImpl.getCallId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_CALLID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLID,
                    args);
            }
        }

        EntityCacheUtil.putResult(CalEtModelImpl.ENTITY_CACHE_ENABLED,
            CalEtImpl.class, calEt.getPrimaryKey(), calEt);

        return calEt;
    }

    protected CalEt toUnwrappedModel(CalEt calEt) {
        if (calEt instanceof CalEtImpl) {
            return calEt;
        }

        CalEtImpl calEtImpl = new CalEtImpl();

        calEtImpl.setNew(calEt.isNew());
        calEtImpl.setPrimaryKey(calEt.getPrimaryKey());

        calEtImpl.setCalEtId(calEt.getCalEtId());
        calEtImpl.setCallId(calEt.getCallId());
        calEtImpl.setEvent(calEt.getEvent());
        calEtImpl.setComment(calEt.getComment());
        calEtImpl.setCreationDate(calEt.getCreationDate());
        calEtImpl.setUserId(calEt.getUserId());

        return calEtImpl;
    }

    /**
     * Returns the cal et with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the cal et
     * @return the cal et
     * @throws gov.va.caret.NoSuchCalEtException if a cal et with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public CalEt findByPrimaryKey(Serializable primaryKey)
        throws NoSuchCalEtException, SystemException {
        CalEt calEt = fetchByPrimaryKey(primaryKey);

        if (calEt == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchCalEtException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return calEt;
    }

    /**
     * Returns the cal et with the primary key or throws a {@link gov.va.caret.NoSuchCalEtException} if it could not be found.
     *
     * @param calEtId the primary key of the cal et
     * @return the cal et
     * @throws gov.va.caret.NoSuchCalEtException if a cal et with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public CalEt findByPrimaryKey(long calEtId)
        throws NoSuchCalEtException, SystemException {
        return findByPrimaryKey((Serializable) calEtId);
    }

    /**
     * Returns the cal et with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the cal et
     * @return the cal et, or <code>null</code> if a cal et with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public CalEt fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        CalEt calEt = (CalEt) EntityCacheUtil.getResult(CalEtModelImpl.ENTITY_CACHE_ENABLED,
                CalEtImpl.class, primaryKey);

        if (calEt == _nullCalEt) {
            return null;
        }

        if (calEt == null) {
            Session session = null;

            try {
                session = openSession();

                calEt = (CalEt) session.get(CalEtImpl.class, primaryKey);

                if (calEt != null) {
                    cacheResult(calEt);
                } else {
                    EntityCacheUtil.putResult(CalEtModelImpl.ENTITY_CACHE_ENABLED,
                        CalEtImpl.class, primaryKey, _nullCalEt);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(CalEtModelImpl.ENTITY_CACHE_ENABLED,
                    CalEtImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return calEt;
    }

    /**
     * Returns the cal et with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param calEtId the primary key of the cal et
     * @return the cal et, or <code>null</code> if a cal et with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public CalEt fetchByPrimaryKey(long calEtId) throws SystemException {
        return fetchByPrimaryKey((Serializable) calEtId);
    }

    /**
     * Returns all the cal ets.
     *
     * @return the cal ets
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<CalEt> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the cal ets.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CalEtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of cal ets
     * @param end the upper bound of the range of cal ets (not inclusive)
     * @return the range of cal ets
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<CalEt> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the cal ets.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CalEtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of cal ets
     * @param end the upper bound of the range of cal ets (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of cal ets
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<CalEt> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<CalEt> list = (List<CalEt>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_CALET);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_CALET;

                if (pagination) {
                    sql = sql.concat(CalEtModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<CalEt>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<CalEt>(list);
                } else {
                    list = (List<CalEt>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the cal ets from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (CalEt calEt : findAll()) {
            remove(calEt);
        }
    }

    /**
     * Returns the number of cal ets.
     *
     * @return the number of cal ets
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_CALET);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    @Override
    protected Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    /**
     * Initializes the cal et persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.CalEt")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<CalEt>> listenersList = new ArrayList<ModelListener<CalEt>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<CalEt>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(CalEtImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
