package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchBgNumException;
import gov.va.caret.model.BgNum;
import gov.va.caret.model.impl.BgNumImpl;
import gov.va.caret.model.impl.BgNumModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The persistence implementation for the bg num service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BgNumPersistence
 * @see BgNumUtil
 * @generated
 */
public class BgNumPersistenceImpl extends BasePersistenceImpl<BgNum>
    implements BgNumPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link BgNumUtil} to access the bg num persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = BgNumImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(BgNumModelImpl.ENTITY_CACHE_ENABLED,
            BgNumModelImpl.FINDER_CACHE_ENABLED, BgNumImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(BgNumModelImpl.ENTITY_CACHE_ENABLED,
            BgNumModelImpl.FINDER_CACHE_ENABLED, BgNumImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(BgNumModelImpl.ENTITY_CACHE_ENABLED,
            BgNumModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_BOXGROUPNUMBERASSOCIATIONS =
        new FinderPath(BgNumModelImpl.ENTITY_CACHE_ENABLED,
            BgNumModelImpl.FINDER_CACHE_ENABLED, BgNumImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION,
            "findByBoxGroupNumberAssociations",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPNUMBERASSOCIATIONS =
        new FinderPath(BgNumModelImpl.ENTITY_CACHE_ENABLED,
            BgNumModelImpl.FINDER_CACHE_ENABLED, BgNumImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION,
            "findByBoxGroupNumberAssociations",
            new String[] { Long.class.getName() },
            BgNumModelImpl.OWNERID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_BOXGROUPNUMBERASSOCIATIONS =
        new FinderPath(BgNumModelImpl.ENTITY_CACHE_ENABLED,
            BgNumModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION,
            "countByBoxGroupNumberAssociations",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_BOXGROUPNUMBERASSOCIATIONS_OWNERID_2 =
        "bgNum.ownerId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_BGNUMINST = new FinderPath(BgNumModelImpl.ENTITY_CACHE_ENABLED,
            BgNumModelImpl.FINDER_CACHE_ENABLED, BgNumImpl.class,
            FINDER_CLASS_NAME_ENTITY, "fetchByBgNumInst",
            new String[] { Long.class.getName(), Long.class.getName() },
            BgNumModelImpl.OWNERID_COLUMN_BITMASK |
            BgNumModelImpl.BOXGPID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_BGNUMINST = new FinderPath(BgNumModelImpl.ENTITY_CACHE_ENABLED,
            BgNumModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByBgNumInst",
            new String[] { Long.class.getName(), Long.class.getName() });
    private static final String _FINDER_COLUMN_BGNUMINST_OWNERID_2 = "bgNum.ownerId = ? AND ";
    private static final String _FINDER_COLUMN_BGNUMINST_BOXGPID_2 = "bgNum.boxGpId = ?";
    private static final String _SQL_SELECT_BGNUM = "SELECT bgNum FROM BgNum bgNum";
    private static final String _SQL_SELECT_BGNUM_WHERE = "SELECT bgNum FROM BgNum bgNum WHERE ";
    private static final String _SQL_COUNT_BGNUM = "SELECT COUNT(bgNum) FROM BgNum bgNum";
    private static final String _SQL_COUNT_BGNUM_WHERE = "SELECT COUNT(bgNum) FROM BgNum bgNum WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "bgNum.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No BgNum exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No BgNum exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(BgNumPersistenceImpl.class);
    private static BgNum _nullBgNum = new BgNumImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<BgNum> toCacheModel() {
                return _nullBgNumCacheModel;
            }
        };

    private static CacheModel<BgNum> _nullBgNumCacheModel = new CacheModel<BgNum>() {
            @Override
            public BgNum toEntityModel() {
                return _nullBgNum;
            }
        };

    public BgNumPersistenceImpl() {
        setModelClass(BgNum.class);
    }

    /**
     * Returns all the bg nums where ownerId = &#63;.
     *
     * @param ownerId the owner ID
     * @return the matching bg nums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgNum> findByBoxGroupNumberAssociations(long ownerId)
        throws SystemException {
        return findByBoxGroupNumberAssociations(ownerId, QueryUtil.ALL_POS,
            QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the bg nums where ownerId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgNumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param ownerId the owner ID
     * @param start the lower bound of the range of bg nums
     * @param end the upper bound of the range of bg nums (not inclusive)
     * @return the range of matching bg nums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgNum> findByBoxGroupNumberAssociations(long ownerId,
        int start, int end) throws SystemException {
        return findByBoxGroupNumberAssociations(ownerId, start, end, null);
    }

    /**
     * Returns an ordered range of all the bg nums where ownerId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgNumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param ownerId the owner ID
     * @param start the lower bound of the range of bg nums
     * @param end the upper bound of the range of bg nums (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching bg nums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgNum> findByBoxGroupNumberAssociations(long ownerId,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPNUMBERASSOCIATIONS;
            finderArgs = new Object[] { ownerId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_BOXGROUPNUMBERASSOCIATIONS;
            finderArgs = new Object[] { ownerId, start, end, orderByComparator };
        }

        List<BgNum> list = (List<BgNum>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (BgNum bgNum : list) {
                if ((ownerId != bgNum.getOwnerId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_BGNUM_WHERE);

            query.append(_FINDER_COLUMN_BOXGROUPNUMBERASSOCIATIONS_OWNERID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(BgNumModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(ownerId);

                if (!pagination) {
                    list = (List<BgNum>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<BgNum>(list);
                } else {
                    list = (List<BgNum>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first bg num in the ordered set where ownerId = &#63;.
     *
     * @param ownerId the owner ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching bg num
     * @throws gov.va.caret.NoSuchBgNumException if a matching bg num could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgNum findByBoxGroupNumberAssociations_First(long ownerId,
        OrderByComparator orderByComparator)
        throws NoSuchBgNumException, SystemException {
        BgNum bgNum = fetchByBoxGroupNumberAssociations_First(ownerId,
                orderByComparator);

        if (bgNum != null) {
            return bgNum;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("ownerId=");
        msg.append(ownerId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchBgNumException(msg.toString());
    }

    /**
     * Returns the first bg num in the ordered set where ownerId = &#63;.
     *
     * @param ownerId the owner ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching bg num, or <code>null</code> if a matching bg num could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgNum fetchByBoxGroupNumberAssociations_First(long ownerId,
        OrderByComparator orderByComparator) throws SystemException {
        List<BgNum> list = findByBoxGroupNumberAssociations(ownerId, 0, 1,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last bg num in the ordered set where ownerId = &#63;.
     *
     * @param ownerId the owner ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching bg num
     * @throws gov.va.caret.NoSuchBgNumException if a matching bg num could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgNum findByBoxGroupNumberAssociations_Last(long ownerId,
        OrderByComparator orderByComparator)
        throws NoSuchBgNumException, SystemException {
        BgNum bgNum = fetchByBoxGroupNumberAssociations_Last(ownerId,
                orderByComparator);

        if (bgNum != null) {
            return bgNum;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("ownerId=");
        msg.append(ownerId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchBgNumException(msg.toString());
    }

    /**
     * Returns the last bg num in the ordered set where ownerId = &#63;.
     *
     * @param ownerId the owner ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching bg num, or <code>null</code> if a matching bg num could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgNum fetchByBoxGroupNumberAssociations_Last(long ownerId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByBoxGroupNumberAssociations(ownerId);

        if (count == 0) {
            return null;
        }

        List<BgNum> list = findByBoxGroupNumberAssociations(ownerId, count - 1,
                count, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the bg nums before and after the current bg num in the ordered set where ownerId = &#63;.
     *
     * @param bgNumId the primary key of the current bg num
     * @param ownerId the owner ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next bg num
     * @throws gov.va.caret.NoSuchBgNumException if a bg num with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgNum[] findByBoxGroupNumberAssociations_PrevAndNext(long bgNumId,
        long ownerId, OrderByComparator orderByComparator)
        throws NoSuchBgNumException, SystemException {
        BgNum bgNum = findByPrimaryKey(bgNumId);

        Session session = null;

        try {
            session = openSession();

            BgNum[] array = new BgNumImpl[3];

            array[0] = getByBoxGroupNumberAssociations_PrevAndNext(session,
                    bgNum, ownerId, orderByComparator, true);

            array[1] = bgNum;

            array[2] = getByBoxGroupNumberAssociations_PrevAndNext(session,
                    bgNum, ownerId, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected BgNum getByBoxGroupNumberAssociations_PrevAndNext(
        Session session, BgNum bgNum, long ownerId,
        OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_BGNUM_WHERE);

        query.append(_FINDER_COLUMN_BOXGROUPNUMBERASSOCIATIONS_OWNERID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(BgNumModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(ownerId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(bgNum);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<BgNum> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the bg nums where ownerId = &#63; from the database.
     *
     * @param ownerId the owner ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByBoxGroupNumberAssociations(long ownerId)
        throws SystemException {
        for (BgNum bgNum : findByBoxGroupNumberAssociations(ownerId,
                QueryUtil.ALL_POS, QueryUtil.ALL_POS, null)) {
            remove(bgNum);
        }
    }

    /**
     * Returns the number of bg nums where ownerId = &#63;.
     *
     * @param ownerId the owner ID
     * @return the number of matching bg nums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByBoxGroupNumberAssociations(long ownerId)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_BOXGROUPNUMBERASSOCIATIONS;

        Object[] finderArgs = new Object[] { ownerId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_BGNUM_WHERE);

            query.append(_FINDER_COLUMN_BOXGROUPNUMBERASSOCIATIONS_OWNERID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(ownerId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns the bg num where ownerId = &#63; and boxGpId = &#63; or throws a {@link gov.va.caret.NoSuchBgNumException} if it could not be found.
     *
     * @param ownerId the owner ID
     * @param boxGpId the box gp ID
     * @return the matching bg num
     * @throws gov.va.caret.NoSuchBgNumException if a matching bg num could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgNum findByBgNumInst(long ownerId, long boxGpId)
        throws NoSuchBgNumException, SystemException {
        BgNum bgNum = fetchByBgNumInst(ownerId, boxGpId);

        if (bgNum == null) {
            StringBundler msg = new StringBundler(6);

            msg.append(_NO_SUCH_ENTITY_WITH_KEY);

            msg.append("ownerId=");
            msg.append(ownerId);

            msg.append(", boxGpId=");
            msg.append(boxGpId);

            msg.append(StringPool.CLOSE_CURLY_BRACE);

            if (_log.isWarnEnabled()) {
                _log.warn(msg.toString());
            }

            throw new NoSuchBgNumException(msg.toString());
        }

        return bgNum;
    }

    /**
     * Returns the bg num where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
     *
     * @param ownerId the owner ID
     * @param boxGpId the box gp ID
     * @return the matching bg num, or <code>null</code> if a matching bg num could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgNum fetchByBgNumInst(long ownerId, long boxGpId)
        throws SystemException {
        return fetchByBgNumInst(ownerId, boxGpId, true);
    }

    /**
     * Returns the bg num where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
     *
     * @param ownerId the owner ID
     * @param boxGpId the box gp ID
     * @param retrieveFromCache whether to use the finder cache
     * @return the matching bg num, or <code>null</code> if a matching bg num could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgNum fetchByBgNumInst(long ownerId, long boxGpId,
        boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[] { ownerId, boxGpId };

        Object result = null;

        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(FINDER_PATH_FETCH_BY_BGNUMINST,
                    finderArgs, this);
        }

        if (result instanceof BgNum) {
            BgNum bgNum = (BgNum) result;

            if ((ownerId != bgNum.getOwnerId()) ||
                    (boxGpId != bgNum.getBoxGpId())) {
                result = null;
            }
        }

        if (result == null) {
            StringBundler query = new StringBundler(4);

            query.append(_SQL_SELECT_BGNUM_WHERE);

            query.append(_FINDER_COLUMN_BGNUMINST_OWNERID_2);

            query.append(_FINDER_COLUMN_BGNUMINST_BOXGPID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(ownerId);

                qPos.add(boxGpId);

                List<BgNum> list = q.list();

                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGNUMINST,
                        finderArgs, list);
                } else {
                    if ((list.size() > 1) && _log.isWarnEnabled()) {
                        _log.warn(
                            "BgNumPersistenceImpl.fetchByBgNumInst(long, long, boolean) with parameters (" +
                            StringUtil.merge(finderArgs) +
                            ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                    }

                    BgNum bgNum = list.get(0);

                    result = bgNum;

                    cacheResult(bgNum);

                    if ((bgNum.getOwnerId() != ownerId) ||
                            (bgNum.getBoxGpId() != boxGpId)) {
                        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGNUMINST,
                            finderArgs, bgNum);
                    }
                }
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_BGNUMINST,
                    finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        if (result instanceof List<?>) {
            return null;
        } else {
            return (BgNum) result;
        }
    }

    /**
     * Removes the bg num where ownerId = &#63; and boxGpId = &#63; from the database.
     *
     * @param ownerId the owner ID
     * @param boxGpId the box gp ID
     * @return the bg num that was removed
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgNum removeByBgNumInst(long ownerId, long boxGpId)
        throws NoSuchBgNumException, SystemException {
        BgNum bgNum = findByBgNumInst(ownerId, boxGpId);

        return remove(bgNum);
    }

    /**
     * Returns the number of bg nums where ownerId = &#63; and boxGpId = &#63;.
     *
     * @param ownerId the owner ID
     * @param boxGpId the box gp ID
     * @return the number of matching bg nums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByBgNumInst(long ownerId, long boxGpId)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_BGNUMINST;

        Object[] finderArgs = new Object[] { ownerId, boxGpId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(3);

            query.append(_SQL_COUNT_BGNUM_WHERE);

            query.append(_FINDER_COLUMN_BGNUMINST_OWNERID_2);

            query.append(_FINDER_COLUMN_BGNUMINST_BOXGPID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(ownerId);

                qPos.add(boxGpId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the bg num in the entity cache if it is enabled.
     *
     * @param bgNum the bg num
     */
    @Override
    public void cacheResult(BgNum bgNum) {
        EntityCacheUtil.putResult(BgNumModelImpl.ENTITY_CACHE_ENABLED,
            BgNumImpl.class, bgNum.getPrimaryKey(), bgNum);

        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGNUMINST,
            new Object[] { bgNum.getOwnerId(), bgNum.getBoxGpId() }, bgNum);

        bgNum.resetOriginalValues();
    }

    /**
     * Caches the bg nums in the entity cache if it is enabled.
     *
     * @param bgNums the bg nums
     */
    @Override
    public void cacheResult(List<BgNum> bgNums) {
        for (BgNum bgNum : bgNums) {
            if (EntityCacheUtil.getResult(BgNumModelImpl.ENTITY_CACHE_ENABLED,
                        BgNumImpl.class, bgNum.getPrimaryKey()) == null) {
                cacheResult(bgNum);
            } else {
                bgNum.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all bg nums.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(BgNumImpl.class.getName());
        }

        EntityCacheUtil.clearCache(BgNumImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the bg num.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(BgNum bgNum) {
        EntityCacheUtil.removeResult(BgNumModelImpl.ENTITY_CACHE_ENABLED,
            BgNumImpl.class, bgNum.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        clearUniqueFindersCache(bgNum);
    }

    @Override
    public void clearCache(List<BgNum> bgNums) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (BgNum bgNum : bgNums) {
            EntityCacheUtil.removeResult(BgNumModelImpl.ENTITY_CACHE_ENABLED,
                BgNumImpl.class, bgNum.getPrimaryKey());

            clearUniqueFindersCache(bgNum);
        }
    }

    protected void cacheUniqueFindersCache(BgNum bgNum) {
        if (bgNum.isNew()) {
            Object[] args = new Object[] { bgNum.getOwnerId(), bgNum.getBoxGpId() };

            FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_BGNUMINST, args,
                Long.valueOf(1));
            FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGNUMINST, args,
                bgNum);
        } else {
            BgNumModelImpl bgNumModelImpl = (BgNumModelImpl) bgNum;

            if ((bgNumModelImpl.getColumnBitmask() &
                    FINDER_PATH_FETCH_BY_BGNUMINST.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        bgNum.getOwnerId(), bgNum.getBoxGpId()
                    };

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_BGNUMINST, args,
                    Long.valueOf(1));
                FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGNUMINST, args,
                    bgNum);
            }
        }
    }

    protected void clearUniqueFindersCache(BgNum bgNum) {
        BgNumModelImpl bgNumModelImpl = (BgNumModelImpl) bgNum;

        Object[] args = new Object[] { bgNum.getOwnerId(), bgNum.getBoxGpId() };

        FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BGNUMINST, args);
        FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_BGNUMINST, args);

        if ((bgNumModelImpl.getColumnBitmask() &
                FINDER_PATH_FETCH_BY_BGNUMINST.getColumnBitmask()) != 0) {
            args = new Object[] {
                    bgNumModelImpl.getOriginalOwnerId(),
                    bgNumModelImpl.getOriginalBoxGpId()
                };

            FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BGNUMINST, args);
            FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_BGNUMINST, args);
        }
    }

    /**
     * Creates a new bg num with the primary key. Does not add the bg num to the database.
     *
     * @param bgNumId the primary key for the new bg num
     * @return the new bg num
     */
    @Override
    public BgNum create(long bgNumId) {
        BgNum bgNum = new BgNumImpl();

        bgNum.setNew(true);
        bgNum.setPrimaryKey(bgNumId);

        return bgNum;
    }

    /**
     * Removes the bg num with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param bgNumId the primary key of the bg num
     * @return the bg num that was removed
     * @throws gov.va.caret.NoSuchBgNumException if a bg num with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgNum remove(long bgNumId)
        throws NoSuchBgNumException, SystemException {
        return remove((Serializable) bgNumId);
    }

    /**
     * Removes the bg num with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the bg num
     * @return the bg num that was removed
     * @throws gov.va.caret.NoSuchBgNumException if a bg num with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgNum remove(Serializable primaryKey)
        throws NoSuchBgNumException, SystemException {
        Session session = null;

        try {
            session = openSession();

            BgNum bgNum = (BgNum) session.get(BgNumImpl.class, primaryKey);

            if (bgNum == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchBgNumException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(bgNum);
        } catch (NoSuchBgNumException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected BgNum removeImpl(BgNum bgNum) throws SystemException {
        bgNum = toUnwrappedModel(bgNum);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(bgNum)) {
                bgNum = (BgNum) session.get(BgNumImpl.class,
                        bgNum.getPrimaryKeyObj());
            }

            if (bgNum != null) {
                session.delete(bgNum);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (bgNum != null) {
            clearCache(bgNum);
        }

        return bgNum;
    }

    @Override
    public BgNum updateImpl(gov.va.caret.model.BgNum bgNum)
        throws SystemException {
        bgNum = toUnwrappedModel(bgNum);

        boolean isNew = bgNum.isNew();

        BgNumModelImpl bgNumModelImpl = (BgNumModelImpl) bgNum;

        Session session = null;

        try {
            session = openSession();

            if (bgNum.isNew()) {
                session.save(bgNum);

                bgNum.setNew(false);
            } else {
                session.merge(bgNum);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !BgNumModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((bgNumModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPNUMBERASSOCIATIONS.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { bgNumModelImpl.getOriginalOwnerId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BOXGROUPNUMBERASSOCIATIONS,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPNUMBERASSOCIATIONS,
                    args);

                args = new Object[] { bgNumModelImpl.getOwnerId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BOXGROUPNUMBERASSOCIATIONS,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPNUMBERASSOCIATIONS,
                    args);
            }
        }

        EntityCacheUtil.putResult(BgNumModelImpl.ENTITY_CACHE_ENABLED,
            BgNumImpl.class, bgNum.getPrimaryKey(), bgNum);

        clearUniqueFindersCache(bgNum);
        cacheUniqueFindersCache(bgNum);

        return bgNum;
    }

    protected BgNum toUnwrappedModel(BgNum bgNum) {
        if (bgNum instanceof BgNumImpl) {
            return bgNum;
        }

        BgNumImpl bgNumImpl = new BgNumImpl();

        bgNumImpl.setNew(bgNum.isNew());
        bgNumImpl.setPrimaryKey(bgNum.getPrimaryKey());

        bgNumImpl.setBgNumId(bgNum.getBgNumId());
        bgNumImpl.setOwnerId(bgNum.getOwnerId());
        bgNumImpl.setBoxGpId(bgNum.getBoxGpId());
        bgNumImpl.setValue(bgNum.getValue());

        return bgNumImpl;
    }

    /**
     * Returns the bg num with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the bg num
     * @return the bg num
     * @throws gov.va.caret.NoSuchBgNumException if a bg num with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgNum findByPrimaryKey(Serializable primaryKey)
        throws NoSuchBgNumException, SystemException {
        BgNum bgNum = fetchByPrimaryKey(primaryKey);

        if (bgNum == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchBgNumException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return bgNum;
    }

    /**
     * Returns the bg num with the primary key or throws a {@link gov.va.caret.NoSuchBgNumException} if it could not be found.
     *
     * @param bgNumId the primary key of the bg num
     * @return the bg num
     * @throws gov.va.caret.NoSuchBgNumException if a bg num with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgNum findByPrimaryKey(long bgNumId)
        throws NoSuchBgNumException, SystemException {
        return findByPrimaryKey((Serializable) bgNumId);
    }

    /**
     * Returns the bg num with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the bg num
     * @return the bg num, or <code>null</code> if a bg num with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgNum fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        BgNum bgNum = (BgNum) EntityCacheUtil.getResult(BgNumModelImpl.ENTITY_CACHE_ENABLED,
                BgNumImpl.class, primaryKey);

        if (bgNum == _nullBgNum) {
            return null;
        }

        if (bgNum == null) {
            Session session = null;

            try {
                session = openSession();

                bgNum = (BgNum) session.get(BgNumImpl.class, primaryKey);

                if (bgNum != null) {
                    cacheResult(bgNum);
                } else {
                    EntityCacheUtil.putResult(BgNumModelImpl.ENTITY_CACHE_ENABLED,
                        BgNumImpl.class, primaryKey, _nullBgNum);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(BgNumModelImpl.ENTITY_CACHE_ENABLED,
                    BgNumImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return bgNum;
    }

    /**
     * Returns the bg num with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param bgNumId the primary key of the bg num
     * @return the bg num, or <code>null</code> if a bg num with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgNum fetchByPrimaryKey(long bgNumId) throws SystemException {
        return fetchByPrimaryKey((Serializable) bgNumId);
    }

    /**
     * Returns all the bg nums.
     *
     * @return the bg nums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgNum> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the bg nums.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgNumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of bg nums
     * @param end the upper bound of the range of bg nums (not inclusive)
     * @return the range of bg nums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgNum> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the bg nums.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgNumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of bg nums
     * @param end the upper bound of the range of bg nums (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of bg nums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgNum> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<BgNum> list = (List<BgNum>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_BGNUM);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_BGNUM;

                if (pagination) {
                    sql = sql.concat(BgNumModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<BgNum>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<BgNum>(list);
                } else {
                    list = (List<BgNum>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the bg nums from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (BgNum bgNum : findAll()) {
            remove(bgNum);
        }
    }

    /**
     * Returns the number of bg nums.
     *
     * @return the number of bg nums
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_BGNUM);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the bg num persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.BgNum")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<BgNum>> listenersList = new ArrayList<ModelListener<BgNum>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<BgNum>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(BgNumImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
