package gov.va.caret.service.paymentjobs;

import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;

import gov.va.caret.ApplicationWorkFlowException;

public class WeeklyPaymentJob implements MessageListener {

	public static Log log = LogFactoryUtil.getLog( WeeklyPaymentJob.class );
	
	@Override
	public void receive(Message arg0) throws MessageListenerException {

		log.info("Weekly payment list file notification job started "+ new Date().toString());
		try {
			ExecutorService exec = Executors.newFixedThreadPool(15);
			MonthlyPaymentJobWorker vsw = new MonthlyPaymentJobWorker();
			exec.submit(vsw);
			exec.shutdown();
			try {
				exec.awaitTermination(120, TimeUnit.MINUTES);//give it two hours to finish doing what it is doing
			} catch (InterruptedException e) {
			  
			}
			
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
		log.info("Weekly payment list file notification job ended "+ new Date().toString());
	}

}
