package gov.va.caret.service.impl;

import java.util.List;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.NoSuchWorSeException;
import gov.va.caret.model.WorSe;
import gov.va.caret.service.base.WorSeLocalServiceBaseImpl;

/**
 * The implementation of the wor se local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.WorSeLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.WorSeLocalServiceBaseImpl
 * @see gov.va.caret.service.WorSeLocalServiceUtil
 */
public class WorSeLocalServiceImpl extends WorSeLocalServiceBaseImpl {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never reference this interface directly. Always use {@link gov.va.caret.service.WorSeLocalServiceUtil} to access the wor se local service.
     */
	
	public int getCount ( long worImId ){
		try {
			return getWorSePersistence().countByWorkId(worImId);
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return -1;
	}
	
	public List<WorSe> getByWorkId ( long worImId ){
		try {
			return getWorSePersistence().findByWorkId(worImId);
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public WorSe getFirst ( long worImId ){
		try {
			return getWorSePersistence().findByWorkId_First(worImId, null);
		} catch (NoSuchWorSeException e) {
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public WorSe getLast ( long worImId ){
		try {
			return getWorSePersistence().findByWorkId_Last(worImId, null);
		} catch (NoSuchWorSeException e) {
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public List<WorSe> findOldStep ( String oldStep ){
//		try {
//			return worSePersistence.findByoldStep(oldStep);
//		} catch (SystemException e) {
//			e.printStackTrace();
//		}
		return null;
	}
	
}
