package gov.va.caret.service.impl;

import java.util.List;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Docum;
import gov.va.caret.model.Letter;
import gov.va.caret.service.base.LetterLocalServiceBaseImpl;

/**
 * The implementation of the letter local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.LetterLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.LetterLocalServiceBaseImpl
 * @see gov.va.caret.service.LetterLocalServiceUtil
 */
public class LetterLocalServiceImpl extends LetterLocalServiceBaseImpl {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never reference this interface directly. Always use {@link gov.va.caret.service.LetterLocalServiceUtil} to access the letter local service.
     */

	public List<Letter> getByClass ( long primaryKey, long classId, String type ) throws ApplicationWorkFlowException {
		try {
			return letterPersistence.findByType(primaryKey, classId, type);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<Letter> getByDocumId ( long documId ) throws ApplicationWorkFlowException {
		try {
			return letterPersistence.findBydocumId(documId);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
}
