package gov.va.caret.service.impl;

import java.util.List;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.FmsOg;
import gov.va.caret.service.base.FmsOgLocalServiceBaseImpl;

/**
 * The implementation of the fms og local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.FmsOgLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.FmsOgLocalServiceBaseImpl
 * @see gov.va.caret.service.FmsOgLocalServiceUtil
 */
public class FmsOgLocalServiceImpl extends FmsOgLocalServiceBaseImpl {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never reference this interface directly. Always use {@link gov.va.caret.service.FmsOgLocalServiceUtil} to access the fms og local service.
     */
	
	public FmsOg getLastFmsOg () throws SystemException {
		List<FmsOg> list = fmsOgPersistence.findAll(0, 1);
		if ( list.isEmpty() ) {
			return null;
		}
		return list.get(0);
	}
	
	public FmsOg getStiPtCycleType ( long stiPtId, long cycleId ) throws SystemException {
		List<FmsOg> list = fmsOgPersistence.findAll(0, 1);
		if ( list.isEmpty() ) {
			return null;
		}
		return list.get(0);
	}
	
	public FmsOg findByVendor ( long vendrId, long cycleId ) throws SystemException {
		return fmsOgPersistence.fetchByStiPtVoucher_First(String.valueOf( cycleId ), vendrId, null);
	}
	
}
