package gov.va.caret.service.impl;

import java.util.List;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;

import gov.va.caret.model.FmsIc;
import gov.va.caret.service.base.FmsIcLocalServiceBaseImpl;

/**
 * The implementation of the fms ic local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.FmsIcLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.FmsIcLocalServiceBaseImpl
 * @see gov.va.caret.service.FmsIcLocalServiceUtil
 */
public class FmsIcLocalServiceImpl extends FmsIcLocalServiceBaseImpl {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never reference this interface directly. Always use {@link gov.va.caret.service.FmsIcLocalServiceUtil} to access the fms ic local service.
     */
	
	final OrderByComparator orderByCycleId = new OrderByComparator() {
		private static final long serialVersionUID = 1L;
		public int compare(Object obj1, Object obj2) { return 0; }
		public String getOrderBy() { return "cycleId"; }
		public boolean isAscending() { return false; }
	};
	
	public FmsIc getLastFmsIc () throws SystemException {
		List<FmsIc> list = fmsIcPersistence.findAll(0, 1, orderByCycleId);
		if ( list.isEmpty() ) {
			return null;
		}
		return list.get(0);
	}
	
	public FmsIc findByVoucherId ( long fmsOgId ) throws SystemException {
		List<FmsIc> list = fmsIcPersistence.findByVoucherId( String.valueOf( fmsOgId ) );
		if ( list.isEmpty() ) {
			return null;
		}
		return list.get(0);
	}
}
