package gov.va.caret.service.impl;

import java.util.List;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.EEMonetaryBenefit;
import gov.va.caret.service.base.EEMonetaryBenefitLocalServiceBaseImpl;

/**
 * The implementation of the e e monetary benefit local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.EEMonetaryBenefitLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.EEMonetaryBenefitLocalServiceBaseImpl
 * @see gov.va.caret.service.EEMonetaryBenefitLocalServiceUtil
 */
public class EEMonetaryBenefitLocalServiceImpl
    extends EEMonetaryBenefitLocalServiceBaseImpl {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never reference this interface directly. Always use {@link gov.va.caret.service.EEMonetaryBenefitLocalServiceUtil} to access the e e monetary benefit local service.
     */ 
	/**
    * Returns all the e e military records where eeLgId = &#63;.
    *
    * @param eeLgId the ee lg ID
    * @return the matching e e military records
    * @throws SystemException if a system exception occurred
    */
    public List<EEMonetaryBenefit> findByeeLgId(
        long eeLgId) throws com.liferay.portal.kernel.exception.SystemException {
        return this.eeMonetaryBenefitPersistence.findByeeLgId(eeLgId);
    }
}
