package gov.va.caret.service.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.service.base.EEMilitaryRecordLocalServiceBaseImpl;

/**
 * The implementation of the e e military record local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.EEMilitaryRecordLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.EEMilitaryRecordLocalServiceBaseImpl
 * @see gov.va.caret.service.EEMilitaryRecordLocalServiceUtil
 */
public class EEMilitaryRecordLocalServiceImpl
    extends EEMilitaryRecordLocalServiceBaseImpl {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never reference this interface directly. Always use {@link gov.va.caret.service.EEMilitaryRecordLocalServiceUtil} to access the e e military record local service.
     */

    /**
    * Returns all the e e military records where eeLgId = &#63;.
    *
    * @param eeLgId the ee lg ID
    * @return the matching e e military records
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.EEMilitaryRecord> findByeeLgId(
        long eeLgId) throws com.liferay.portal.kernel.exception.SystemException {
        return this.eeMilitaryRecordPersistence.findByeeLgId(eeLgId);
    }

}
