/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;


import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.dao.orm.CustomSQLUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.NoSuchBgAsnException;
import gov.va.caret.NoSuchFacilException;
import gov.va.caret.model.Assmt;
import gov.va.caret.model.AudLg;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.CalEt;
import gov.va.caret.model.Docum;
import gov.va.caret.model.Facil;
import gov.va.caret.model.FmsIc;
import gov.va.caret.model.Note;
import gov.va.caret.model.Persn;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.occ.StipendConfig;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.base.CaretLocalServiceBaseImpl;
import gov.va.caret.service.persistence.CaretFinderUtil;
import gov.va.caret.service.thread.Monitor;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * The implementation of the caret local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.CaretLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author 
 * @see gov.va.caret.service.base.CaretLocalServiceBaseImpl
 * @see gov.va.caret.service.CaretLocalServiceUtil
 */
public class CaretLocalServiceImpl extends CaretLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.CaretLocalServiceUtil} to access the caret local service.
	 */
		
	public int getReportCount ( String name, Object entries ) throws ApplicationWorkFlowException{
		return CaretFinderUtil.getReportCount(name, entries);
	}
	
	public List<Map<String,Object>> getReport ( String name, Object entries ) throws ApplicationWorkFlowException{
		return CaretFinderUtil.getReport( name, entries, QueryUtil.ALL_POS, QueryUtil.ALL_POS);
	}
	
	public List<Map<String,Object>> getReport ( String name, Object entries, int start, int end ) throws ApplicationWorkFlowException {
		return CaretFinderUtil.getReport( name, entries, start, end );
	}
	
	public List<Map<String,Object>> getReport ( String name, Object entries, String column, boolean desc, int start, int end ) throws ApplicationWorkFlowException {
		return CaretFinderUtil.getReport( name, entries, column, desc, start, end );
	}

	public BaseModel<?> save( BaseModel<?> model ) throws ApplicationWorkFlowException {
		return getAudLgLocalService().save( model );
	}
	
	public Note addNote ( Note note ) throws ApplicationWorkFlowException {
		try {
			if ( note == null || note.getValue() == null || note.getValue().isEmpty() ){
				ApplicationWorkFlowException.handleException("Empty Note ignored " );
				return note;
			} else {
				return getNoteLocalService().addNote(note);
			}
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public Facil getFacilityByNumber ( String facilityNumber ) throws ApplicationWorkFlowException {
		try {
			return getFacilPersistence().findByFacilityNumber(facilityNumber);
		} catch (NoSuchFacilException e) {
			return null;
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException( e );
		}
	}
	
	public List<CalEt> getCallEvents( long callId ) throws ApplicationWorkFlowException {
		try {
			return getCalEtPersistence().findByCallId( callId );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException( e );
		}
	}
	
	public List<Assmt> getAssessments( long vcgId ) throws ApplicationWorkFlowException {
		try {
			return assmtPersistence.findByVcgId( vcgId );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException( e );
		}
	}
	
	public AudLg getAudLg ( long classId, long classPk, String attribute ) throws ApplicationWorkFlowException {
		try {
			return audLgPersistence.fetchByAttribute(classId, classPk, attribute);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException( e );
		}
	}
	
	public AudLg getAudLgLatest ( long classPk, String attribute, Date targetDate ) throws ApplicationWorkFlowException {
		try {
			return audLgPersistence.fetchByModifiedDatePrior_First(targetDate, classPk, attribute, null);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException( e );
		}
	}
	
	public List<AudLg> getChange( Date modifiedDate, long[] classPk, String[] attributes ) throws ApplicationWorkFlowException {
		try {
			return audLgPersistence.findByModifiedDate(modifiedDate, classPk, attributes);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException (e);
		}
	}
	
	public int getChangeCount( Date modifiedDate, long[] classPk, String[] attributes ) throws ApplicationWorkFlowException {
		try {
			return audLgPersistence.countByModifiedDate(modifiedDate, classPk, attributes);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException (e);
		}
	}
	
	public List<AudLg> findByClassPk( long classPk, String attribute ) throws ApplicationWorkFlowException {
		try {
			return audLgPersistence.findByClassPk(classPk, attribute);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		} 
	}

	public List<Docum> getByClass ( long primaryKey, long classId, String type ) throws ApplicationWorkFlowException {
		try {
			return documPersistence.findByType(primaryKey, classId, type, false);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<Docum> getByPrimaryKey ( long primaryKey ) throws ApplicationWorkFlowException {
		try {
			return documPersistence.findByClassPk( primaryKey, false );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public Persn getPerson ( long persnId ) throws ApplicationWorkFlowException {
		Persn person = null;
		try {
			person = PersnLocalServiceUtil.getPersn( persnId );
		} catch (PortalException e) {
		} catch (SystemException e) {
		}
		if ( person == null ){
			ApplicationWorkFlowException.handleException("No Person exists with id " + persnId );
			return Person.DEFAULT_PERSON;
		}
		return new Person ( person );
	}
	
	
	public VcgAn getPrimaryApp ( long veteranId ) throws ApplicationWorkFlowException {
		try {
			
			List<VcgAn> list = vcgAnPersistence.findByPrimaryApp(0, veteranId);
			if ( !list.isEmpty() ){
				return list.get(0);
			}
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	//=========
	
	public List<BoxGp> getBoxGroups ( String name ) throws ApplicationWorkFlowException{
		try {
			return boxGpPersistence.findByBoxGroup( name );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public List<BoxGp> getBoxGroups ( String boxGroup, String boxSubGroup ) throws ApplicationWorkFlowException{
		try {
			return boxGpPersistence.findByBoxSubGroup(boxGroup, boxSubGroup);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public List<BgAsn> getBoxGroupAssociations ( long ownerId ) throws ApplicationWorkFlowException{
		try {
			return bgAsnPersistence.findByBoxGroupAssociations(ownerId);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public List<BgAsn> getBoxGroupAssociations ( long ownerId, boolean enabled ) throws ApplicationWorkFlowException{
		try {
			return bgAsnPersistence.findBySelectedBoxGroupAssociations(ownerId, enabled);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public BgAsn getBoxGroupAssociation ( long ownerId, long boxGpId ) throws ApplicationWorkFlowException{
		try { int count = bgAsnPersistence.countByBgAsnInst(ownerId, boxGpId);
			if ( count == 1 )
			return bgAsnPersistence.findByBgAsnInst(ownerId, boxGpId);
		} catch (NoSuchBgAsnException e) {
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	
	
	public void setFmsOut ( String cycleType, String cycleId, Date payDate, boolean clearCache ) throws ApplicationWorkFlowException {
		Long cycleIdLong = Long.valueOf(cycleId);
		Long cycleTypeLong = Long.valueOf(cycleType);
		if ( cycleIdLong != Monitor.lock( cycleTypeLong, cycleIdLong ) ) {
			throw new ApplicationWorkFlowException("COULD NOT LOCK OUT-GOING-PAYMENTS, was it submitted twice?");
		}
		try {
			BgLae bgLae = BgLaeLocalServiceUtil.getBgLae( Long.valueOf(cycleId) );
			bgLae.setLargeText( bgLae.getLargeText().replace(StipendConfig.PENDING, StipendConfig.STAGED) );
			save(bgLae);
		} catch (NumberFormatException | PortalException | SystemException e1) {
			e1.printStackTrace();
		} 

		String sql = StringUtil.replace( CustomSQLUtil.get( "fmsOut" ), CYCLETYPE, cycleType );
		sql = StringUtil.replace( sql, CYCLE, cycleId );
		sql = StringUtil.replace( sql, TARGETDATE, Toolbox.formatDate(payDate) );
		SqlUpdateFactoryUtil.getSqlUpdate( fmsOgPersistence.getDataSource(), sql, new int[0] ).update((Object[]) null );
		if ( clearCache ) {
			fmsOgPersistence.clearCache();
		}
		ServiceContext sc = ServiceContextThreadLocal.getServiceContext();
		if ( sc == null ) {
			sc = new ServiceContext();
			sc.setCompanyId( PortalUtil.getDefaultCompanyId() );
			sc.setAddGuestPermissions(false);
			try {
				sc.setUserId( UserLocalServiceUtil.getDefaultUserId( PortalUtil.getDefaultCompanyId() ) );
			} catch (PortalException e) {
				e.printStackTrace();
			} catch (SystemException e) {
				e.printStackTrace();
			}
		}
		if ( sc.getCreateDate() == null ){
			sc.setCreateDate( payDate );
		}
//		try {
//			//one timers first...
//			for ( StiPt stiPt : stiPtPersistence.findByUpdatePending("one-time", payDate) ) {
//				FmsOg fmsOg = FmsOgLocalServiceUtil.findByVendor( stiPt.getVendrId(), stiPt.getWorSeId() );
//				if ( fmsOg!= null && FmsIcLocalServiceUtil.findByVoucherId( fmsOg.getFmsOgId() ) != null ){
//					stiPt.setPayslipDate( payDate );
//					stiPt.setStipendStatus( StipendConfig.OBSOLETE_PAYMENT );
//					CaretLocalServiceUtil.save(stiPt);
//				};
//			}
//			//new approvals...
//			if ( Long.valueOf(cycleType) < 100000 ) {
//				BgLae bgLae = Vendor.initMonth( Calendar.getInstance() );
//				for ( int count = 100; count > 0; count = stiPtPersistence.countByUpdatePending("recurring", payDate) ) {
//					for ( StiPt stiPt : stiPtPersistence.findByUpdatePending("recurring", payDate, 0, Math.min(count, 100) ) ) {
//						FmsOg fmsOg = FmsOgLocalServiceUtil.findByVendor(stiPt.getVendrId(), stiPt.getWorSeId() );
//						if ( fmsOg!= null && FmsIcLocalServiceUtil.findByVoucherId( fmsOg.getFmsOgId() ) != null ){
//							stiPt.setPayslipDate( payDate );
//							stiPt.setWorSeId( bgLae.getBgLaeId() );
//							CaretLocalServiceUtil.save(stiPt);
//						};
//					}
//				}
//			}
//		} catch (PortalException e) {
//			throw new ApplicationWorkFlowException(e);
//		} catch (SystemException e) {
//			throw new ApplicationWorkFlowException(e);
//		}
		Monitor.unlock( cycleTypeLong );
	}
	
	public void mockService ( String cycleType, String cycleId, boolean clearCache ) {
		String sql = StringUtil.replace( StringUtil.replace( CustomSQLUtil.get( "fmsMockIn" ), CYCLETYPE, cycleType ), CYCLE, cycleId );
		SqlUpdateFactoryUtil.getSqlUpdate( fmsIcPersistence.getDataSource(), sql, new int[0] ).update((Object[]) null );
		if ( clearCache ) {
			fmsIcPersistence.clearCache();
		}
	}
	
	
	public void cleanFmsTables ( String cycleType, String cycleId, boolean clearCache ) {
		ServiceContext sc = ServiceContextThreadLocal.getServiceContext();
		if ( sc.getAttribute("MOCK_RESPONSE") != null && sc.getAttribute("MOCK_RESPONSE").equals( sc.getCreateDate() ) ) {
			String sql = StringUtil.replace( CustomSQLUtil.get( "fmsMockCleanIn" ), CYCLETYPE, cycleType );
			sql = StringUtil.replace( sql, CYCLE, cycleId );
			SqlUpdateFactoryUtil.getSqlUpdate( fmsIcPersistence.getDataSource(), sql, new int[0] ).update((Object[]) null );
			if ( clearCache ) {
				fmsIcPersistence.clearCache();
			}
		
			sql = StringUtil.replace( StringUtil.replace( CustomSQLUtil.get( "fmsMockCleanOut" ), CYCLETYPE, cycleType ), CYCLE, cycleId );
			SqlUpdateFactoryUtil.getSqlUpdate( fmsOgPersistence.getDataSource(), sql, new int[0] ).update((Object[]) null );
			if ( clearCache ) {
				fmsOgPersistence.clearCache();
			}
		}
	}
	
	public double getFmsOutSum ( Date date ) {
		
		double out = 0.0;
		Map<String, String> map = new HashMap<String,String>();
		map.put("TARGETDATE", Toolbox.formatDate(date) );
		try {
			out = Double.valueOf( getReport( "fmsOutSum", map ).get(0).get(CaretStrPool.NDX0).toString() );
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		}
		return out;
	}
	
	public double getFmsOutSum ( String cycleType, String cycleId ) {
		
		double out = 0.0;
//		Map<String, String> map = new HashMap<String,String>();
//		map.put(CYCLE_, cycleId);
//		map.put(CYCLETYPE_, cycleType);
//		try {
//			out = Double.valueOf( getReport( "fmsOutSum", map ).get(0).get(CaretStrPool.NDX0).toString() );
//		} catch (ApplicationWorkFlowException e) {
//			e.printStackTrace();
//		}
		return out;
	}
	
	public List<FmsIc> getFmsIn ( int cycleType, long cycleId, String type, int start, int end ) throws ApplicationWorkFlowException {
		
		try {
			return fmsIcPersistence.findByCycleType(cycleType, cycleId, type, start, end);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException (e);
		}
	}
	
	public List<FmsIc> getFmsIn ( int cycleType, long cycleId, int start, int end ) throws ApplicationWorkFlowException {
		
		try {
			return fmsIcPersistence.findByCycle(cycleType, cycleId, start, end);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException (e);
		}
	}
	
	public double getFmsOutSumEstimate ( String cycleType, String cycleId ) {
		
		double out = 0.0;
		Map<String, String> map = new HashMap<String,String>();
		map.put(CYCLE_, cycleId);
		map.put(CYCLETYPE_, cycleType);
		try {
			out = Double.valueOf( getReport( "fmsOutSumEstimate", map ).get(0).get(CaretStrPool.NDX0).toString() );
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		}
		return out;
	}
	
	private static String CYCLE_ = "cycleId";
	private static String CYCLETYPE_ = "cycleType";
	private static String CYCLE = "[$cycleId$]";
	private static String CYCLETYPE = "[$cycleType$]";
	private static String TARGETDATE = "[$TARGETDATE$]";
	
	
}