package gov.va.caret.service.ctssh.template;

import java.io.File;
import java.io.FilenameFilter;
import java.io.StringReader;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Document;

import gov.va.caret.service.ctssh.util.AppHelper;
import gov.va.caret.service.ctssh.util.CacheHandler;

public class TemplateHandler {

	
	/**
	 * 
	 */
	public static final String ENV_LOCAL 	= "LOCAL";
	/**
	 * 
	 */
	public static final String ENV_DEV 		= "DEV";
	/**
	 * 
	 */
	public static final String ENV_SQA 		= "SQA";
	/**
	 * 
	 */
	public static final String ENV_LPERF 	= "LPERF";
	/**
	 * 
	 */
	public static final String ENV_PPROD 	= "PPROD";
	/**
	 * 
	 */
	public static final String ENV_PROD 	= "PROD";	
	
	 	
		
	
	/**
	 * 
	 */
	private static TemplateHandler sngleton;
	/**
	 * 
	 */
	String _template_path = "";
	/**
	 * 
	 */
	String _env = "";
	
	/**
	 * @return
	 * @throws Exception
	 */
	public static TemplateHandler instance() throws Exception {
		if (sngleton == null)
			throw new Exception("TemplateHandler not initialized");

		return sngleton;
	}


	/**
	 * @param path
	 * @param env
	 * @throws Exception
	 */
	public static void init(String path, String env) throws Exception {
		
		
		
		sngleton = new TemplateHandler(path, env);
	}

	/**
	 * @param path
	 * @param env
	 * @throws Exception
	 */
	private TemplateHandler(String path, String env) throws Exception {
		// load all the templates here. chained templates go last becasue they
		// are dependent on the others to be loaded
		
		_env = env;
		File dr = new File(path);
		
		if (!dr.exists() || !dr.isDirectory())
			throw new Exception("Path to templates (\"" + path + "\") either does not exist or is not a folder");

		
		//cache any non template files
		File[] xtemps = dr.listFiles(new FilenameFilter() {
			public boolean accept(File dir, String name) {
				return name.toLowerCase().endsWith(".xsl");
			}
		});
		for (File f : xtemps) {
			String key = f.getName().substring(0,f.getName().length() - 4);
			String buff = AppHelper.loadFile(f.getAbsolutePath());
			Transformer xform = TransformerFactory.newInstance().newTransformer(new StreamSource(new StringReader(buff)));
			CacheHandler.instance().cacheXform(key, xform);
		}
		
		
		
		File[] templates = dr.listFiles(new FilenameFilter() {
				public boolean accept(File dir, String name) {
					return name.toLowerCase().endsWith(".xml");
				}
			});
		
		if (templates.length == 0)
			throw new Exception("Path to templates (\"" + path + "\") contains no templates");

		_template_path = path;

		// load the simple templates first
		ArrayList<File> chain_templates = new ArrayList<>();
		for (File f : templates) {
			Document template_doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(f);
			String template_type = AppHelper.getStringValue(Template.TEMPLATE_TYPE, template_doc);
			if (template_type.intern() == "simple") {
				Template t = new SimpleTemplate(f);
				CacheHandler.instance().cacheTemplate(t.key(), t);
			} else
				chain_templates.add(f);// just save the file don't create
										// because it is dependent on the others

		}

		// now go through all the chain templates
		for (File f : chain_templates) {
			Template t = new ChainedTemplate(f);
			CacheHandler.instance().cacheTemplate(t.key(), t);
		}

	}

	/**
	 * @param key
	 * @return
	 */
	public Template template(String key) {
		return CacheHandler.instance().getTemplate(key);
	}

	/**
	 * @param key
	 * @return
	 */
	public boolean isValidKey(String key) {
		return CacheHandler.instance().isValidTemplateKey(key);
	}

	/**
	 * @param key
	 * @return
	 */
	public String call_type(String key) {

		return CacheHandler.instance().getTemplate(key)._type;

	}

	/**
	 * @return
	 */
	public String env()
	{
		return _env;
	}
	
	
}
