/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.caret.service.ctssh.template;

import java.io.File;

import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;

import gov.va.caret.service.ctssh.util.AppHelper;
import gov.va.caret.service.ctssh.util.CacheHandler;

/**
 *
 * @author ronaday
 */
public class Template {
    
    
    /**
     * 
     */
    protected static final String TEMPLATE_REQ_URL_XPATHKEY               = AppHelper.generateKey();
    /**
     * 
     */
    protected static final String TEMPLATE_REQ_BODY_XPATHKEY              = AppHelper.generateKey();
    /**
     * 
     */
    protected static final String TEMPLATE_REQ_RECORD_XPATHKEY            = AppHelper.generateKey();
    /**
     * 
     */
    protected static final String TEMPLATE_KEY                            = AppHelper.generateKey();
    /**
     * 
     */
    protected static final String TEMPLATE_TYPE                           = AppHelper.generateKey();
    /**
     * 
     */
    protected static final String TEMPLATE_FAIL_MSG      				  = AppHelper.generateKey();
    /**
     * 
     */
    protected static final String TEMPLATE_CALL_STEPS                     = AppHelper.generateKey();
    /**
     * 
     */
    protected static final String TEMPLATE_REQ_PARAMETER_XPATHKEY         = AppHelper.generateKey();
    /**
     * 
     */
    protected static final String TEMPLATE_REQ_HTTPHEADERS_XPATHKEY       = AppHelper.generateKey();
    /**
     * 
     */
    protected static final String TEMPLATE_RESP_FIELD_XPATHKEY            = AppHelper.generateKey();
    /**
     * 
     */
    protected static final String TEMPLATE_RESP_PROPERTY_XPATHKEY         = AppHelper.generateKey();
    /**
     * 
     */
    protected static final String TEMPLATE_RESP_RECORD_XPATHKEY           = AppHelper.generateKey();
    /**
     * 
     */
    protected static final String TEMPLATE_RESP_RESULT_XPATHKEY           = AppHelper.generateKey();
    /**
     * 
     */
    protected static final String TEMPLATE_RESP_FIELD_GROUP_XPATHKEY      = AppHelper.generateKey();
    /**
     * 
     */
    protected static final String TEMPLATE_RESP_XFORM_XPATHKEY            = AppHelper.generateKey();
    /**
     * 
     */
    protected static final String TEMPLATE_RESP_GROUP_FIELD_XPATHKEY      = AppHelper.generateKey();
    
    
    static {
        
        try {
        
            CacheHandler.instance().cacheXPath(TEMPLATE_KEY, "//@key");
            CacheHandler.instance().cacheXPath(TEMPLATE_FAIL_MSG, "//@fail_message");
            CacheHandler.instance().cacheXPath(TEMPLATE_TYPE, "//@type");
            CacheHandler.instance().cacheXPath(TEMPLATE_CALL_STEPS, "//*/call_steps/step");
            CacheHandler.instance().cacheXPath(TEMPLATE_REQ_URL_XPATHKEY, "//*/url");
            CacheHandler.instance().cacheXPath(TEMPLATE_REQ_BODY_XPATHKEY,"//*/request/body");
            CacheHandler.instance().cacheXPath(TEMPLATE_REQ_RECORD_XPATHKEY, "//*/response/results/record/@xpath");
            CacheHandler.instance().cacheXPath(TEMPLATE_REQ_PARAMETER_XPATHKEY, "//*/request/parameters/parameter");
            CacheHandler.instance().cacheXPath(TEMPLATE_REQ_HTTPHEADERS_XPATHKEY, "//*/request/http_headers/header");
            CacheHandler.instance().cacheXPath(TEMPLATE_RESP_FIELD_XPATHKEY, "//*/record/field");
            CacheHandler.instance().cacheXPath(TEMPLATE_RESP_PROPERTY_XPATHKEY, "//*/result_property");
            CacheHandler.instance().cacheXPath(TEMPLATE_RESP_RECORD_XPATHKEY, "//*/record");
            CacheHandler.instance().cacheXPath(TEMPLATE_RESP_RESULT_XPATHKEY, "//*/response/results");
            CacheHandler.instance().cacheXPath(TEMPLATE_RESP_FIELD_GROUP_XPATHKEY, "//*/record/field_group");
            CacheHandler.instance().cacheXPath(TEMPLATE_RESP_XFORM_XPATHKEY, "//*/response/transform");
            CacheHandler.instance().cacheXPath(TEMPLATE_RESP_GROUP_FIELD_XPATHKEY, "field");
            
        }catch(Exception e)
        {
            e.printStackTrace();
        }
        
    }
    
    /**
     * 
     */
    protected  String template_path = "";
    /**
     * 
     */
    protected  Document template_doc;
    /**
     * 
     */
    protected  String _key = "";
    /**
     * 
     */
    protected  String _type = "";
    /**
     * 
     */
    protected  String _fail_message = "";
    
    /**
     * @param template
     * @throws Exception
     */
    public Template(File template) throws Exception
    {
        
      	template_path = template.getAbsolutePath();
        template_doc  = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(template);
        

        _key = AppHelper.getStringValue(TEMPLATE_KEY,template_doc);
        _type = AppHelper.getStringValue(TEMPLATE_TYPE,template_doc);
        _fail_message = AppHelper.getStringValue(TEMPLATE_FAIL_MSG,template_doc);
        
    }
    
    /**
     * @return
     */
    public String type() {
        return _type;
    }

    /**
     * @return
     */
    public String key()
    {
        return _key;
    }
    
    
}
