package gov.va.caret.service.ctssh.template;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

import org.w3c.dom.NodeList;

import gov.va.caret.service.ctssh.util.AppHelper;





public final class SimpleTemplate extends Template {

    /*
       
    <CTSSH_Template key  =" * this is the key that will be used to uniquely identify this template * "  
                    type =" * this can be CHAIN, SIMPLE, or blank.  If it's blank it defaults to SIMPLE *"> 
	<request>
            <url> * this is where the url for the service call goes * </url>
            <http_headers> 
                * all the headers that should be sent as part of this request   *
                * there can be as many of these as needed                       *
                * each one has a name and a value only                          *
                <header name="***" value="***" />
                    ... 
            </http_headers>
            <parameters> 
                * these are all of the parameters that can go into the call *
                * there can be many of these
                * each one has a token which is used to do a search and replace on the temlate body, 
                               a name that is used to identify the parameter, 
                               a tag that is used to identify the parent tag that needs to be removed if the value is not set
                               and a default value.  
                               The default can have any of the following built in values : [remove] - this will remove the tag indicated in the tag property if the value is not set
                                                                                           [error]  - this will throw an error if the value is not set (used to indicate required parameters

                <parameter token=""	name="" tag=""	default="value || [remove] || [error]"/>		
            </parameters>

            <body>  * this is the actual body of the soap request xml.  it contains all the tokens and structure for a successful call. Each of the parameters above has a token which is also
                    present in the template body.  A simple String.replace(token, value) is used to inject parameter values into the template.*
            </body>
	</request>
	<response>
            <transform> CDATA!
                * this is optional.  If it is present in the template it will be executed on the return results prior to internal data retrieval *
                * transforms are useful because we can do conditional data retreivals - and they are FAST!
    	    </transform>
            <results>
                * this is the core return results from the call *
                * it's broken up between general properties that are returned from the call, records/fields, and record/field groups (entities that may occur more than once. *
                * all entities have an xpath attribute that is used to retrieve data from the results
                * result properties have a simple name/xpath  these are added to the result object as simple properties
                * result record just has an xpath so we know where to find it. records are added to the result object as an array list
                * record fields have a name, xpath, and default.  Default is almost always [null].  fields are added to the result as a map off the record
		* record field groups represent nested records which consist of fields
    
                RESULT
                -----------------------------
                
                HashMap<String,String> properties; 
                ResponseRecord[] <- array of result record objects
                    HashMap<String, Field> _fields; 
                    HashMap<String, FieldGroups> _field_groups; 
                        HashMap<String, Field> _fields;
                  
                <result_property name="" xpath="" /> * may occur as many times as needed *
		<record xpath="">                    * each result can have only one record construct *
                    <field name="" xpath=""  default="" /> 
                        ....
                    <field_group name="" xpath="" list_key="">
                            <field name="" xpath=""  default="" /> 
                    </field_group>
		</record>
  	    </results>
	</response>
    </CTSSH_Template>
    */

    //the actual values of these are meaningless as long as they are unique. 


    /**
     * 
     */
    private  HashMap<String,String> _urls = null;
    /**
     * 
     */
    private  String _raw_request_body;
    /**
     * 
     */
    private  String _raw_xform_body;
    /**
     * 
     */
    private  TemplateHttpHeader[] _http_headers;
    /**
     * 
     */
    private  SimpleTemplateRequestParameter[] _request_parameters;
    /**
     * 
     */
    private  TemplateResponseProperty[] _response_properties;
    /**
     * 
     */
    private  TemplateResponseFieldGroup[] _rec_field_groups;
    /**
     * 
     */
    private  TemplateResponseField[] _rec_fields;
    /**
     * 
     */
    private  ArrayList<String> _parameter_names;
    /**
     * 
     */
    private  String _rec_xpath;  
   
		
    
    
    
    /**
     * @param template
     * @throws Exception
     */
    protected SimpleTemplate(File template) throws Exception
    {
        super(template);
					
        AppHelper.log("Creating Simple Call Template : " + _key + " from " + template_path);
        //------------------------
        // LOAD THE REQUEST
        //------------------------

        _urls = new HashMap<>();
        NodeList nlurls = AppHelper.getNodeList(TEMPLATE_REQ_URL_XPATHKEY,template_doc);
        for(int ix = 0; ix < nlurls.getLength(); ix++)
        {
        	_urls.put(AppHelper.getAttributeValue(nlurls.item(ix),"env",""), AppHelper.getNodeValue(nlurls.item(ix),""));
        }
        
        
        
        
        _raw_request_body = AppHelper.getStringValue(TEMPLATE_REQ_BODY_XPATHKEY,template_doc);

        //load the request headers
        NodeList nl_http_headers = AppHelper.getNodeList(TEMPLATE_REQ_HTTPHEADERS_XPATHKEY,template_doc);
        _http_headers = new TemplateHttpHeader[nl_http_headers.getLength()];
        for(int ix = 0; ix < nl_http_headers.getLength(); ix++)
        {
            _http_headers[ix] = new TemplateHttpHeader(nl_http_headers.item(ix));
        }

        //load up the request parameters
        _parameter_names = new ArrayList<>();
        NodeList nl_parameters = AppHelper.getNodeList(TEMPLATE_REQ_PARAMETER_XPATHKEY,template_doc);
        _request_parameters = new SimpleTemplateRequestParameter[nl_parameters.getLength()];
        for(int ix = 0; ix < nl_parameters.getLength(); ix++)
        {
            _request_parameters[ix] = new SimpleTemplateRequestParameter(nl_parameters.item(ix));
            _parameter_names.add(_request_parameters[ix].name().toLowerCase());
        }

        //------------------------
        // LOAD THE REPSONSE
        //------------------------
        _raw_xform_body = AppHelper.getStringValue(TEMPLATE_RESP_XFORM_XPATHKEY,template_doc);

        _rec_xpath = AppHelper.getStringValue(TEMPLATE_REQ_RECORD_XPATHKEY,template_doc);

        //load up the response properties
        NodeList nl_response_properties = AppHelper.getNodeList(TEMPLATE_RESP_PROPERTY_XPATHKEY,template_doc);
        _response_properties = new TemplateResponseProperty[nl_response_properties.getLength()];
        for(int ix = 0; ix < nl_response_properties.getLength(); ix++)
        {
            _response_properties[ix] = new TemplateResponseProperty(nl_response_properties.item(ix));
        }

        //load the base response record
        NodeList nl_resp_fields = AppHelper.getNodeList(TEMPLATE_RESP_FIELD_XPATHKEY,template_doc);
        _rec_fields = new TemplateResponseField[nl_resp_fields.getLength()];
        for(int ix = 0; ix < nl_resp_fields.getLength(); ix++)
        {
            _rec_fields[ix] = new TemplateResponseField(nl_resp_fields.item(ix));
        }

        NodeList nl_resp_field_groups = AppHelper.getNodeList(TEMPLATE_RESP_FIELD_GROUP_XPATHKEY,template_doc);
        _rec_field_groups = new TemplateResponseFieldGroup[nl_resp_field_groups.getLength()];
        for(int ix = 0; ix < nl_resp_field_groups.getLength(); ix++)
        {
            NodeList nl_group_fields = AppHelper.getNodeList(TEMPLATE_RESP_GROUP_FIELD_XPATHKEY,nl_resp_field_groups.item(ix));
            TemplateResponseField[] group_fields = new TemplateResponseField[nl_group_fields.getLength()];    
            for(int ix2 = 0; ix2 < nl_group_fields.getLength(); ix2++)
            {
                group_fields[ix2] = new TemplateResponseField(nl_group_fields.item(ix2));
            }

            _rec_field_groups[ix] = new TemplateResponseFieldGroup(nl_resp_field_groups.item(ix), group_fields);
        }


    }

     
 
    
   

    
    /**
     * @param name
     * @return
     */
    public boolean isParameter(String name)
    {
        return _parameter_names.contains(name);
    }
 
    /**
     * @return
     */
    public SimpleTemplateRequestParameter[] parameters()
    {
        return _request_parameters;
    }
    
    /**
     * @param params
     * @return
     */
    public ParameterValidationResult validateParameters(HashMap<String,String> params)
    {
        StringBuilder sb = new StringBuilder();
        boolean valid = true;
        
        for(SimpleTemplateRequestParameter rp:_request_parameters)
        {
            if(rp.isRequired() && !params.containsKey(rp.name().toLowerCase()))
            {
                sb.append("\nMissing Parameter : " + rp.name());
                valid = false;
            }
        }
                
        if(valid == false)
        	AppHelper.log(sb.toString());
        else
        	AppHelper.log("Parameters are valid");
        
        
        return new ParameterValidationResult(sb.toString(), valid);
    }
    
    
    /**
     * @return
     */
    public String raw_request_body()
    {
        return _raw_request_body;
    }

    /**
     * @return
     */
    public String raw_xform_body()
    {
        return _raw_xform_body;
    }
    
    /**
     * @return
     * @throws Exception
     */
    public String url() throws Exception {
        return _urls.get(TemplateHandler.instance().env());
    }
  
   
    
    /**
     * @return
     */
    public TemplateHttpHeader[] http_headers() 
    {
        return _http_headers;
    }

    /**
     * @return
     */
    public TemplateResponseProperty[] response_properties()
    {
        return _response_properties;
    }

    /**
     * @return
     */
    public TemplateResponseFieldGroup[] rec_field_groups()
    {
        return _rec_field_groups;
    }

    /**
     * @return
     */
    public TemplateResponseField[] rec_fields()
    {
        return _rec_fields;
    }

    /**
     * @return
     */
    public String rec_xpath()
    {
        return _rec_xpath;
    }







	/**
	 * @return
	 */
	public String failmsg() {
		return _fail_message;
	}

 
    
}
