package gov.va.caret.service.ctssh.response;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map.Entry;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import gov.va.caret.service.ctssh.template.TemplateResponseField;
import gov.va.caret.service.ctssh.template.TemplateResponseFieldGroup;
import gov.va.caret.service.ctssh.util.AppHelper;

public class ResponseFieldGroup {

	/**
	 * 
	 */
	String _group_name = null;
	/**
	 * 
	 */
	HashMap<String, HashMap<String,ResponseField>> _grouprecs;
	/**
	 * 
	 */
	int _count = 0;
	/**
	 * 
	 */
	String _path = null;
	/**
	 * 
	 */
	boolean _path_found = true;
	
	
	
	
	
	//field group can have many "records";
	/**
	 * @param tfldg
	 * @param _source_record_node
	 * @throws Exception
	 */
	public ResponseFieldGroup(TemplateResponseFieldGroup tfldg, Node _source_record_node) throws Exception
	{
		_path = tfldg.xpath();
		_group_name = tfldg.name();
		_grouprecs = new HashMap<>();
		
		ArrayList<String> keys_to_remove = new ArrayList<>();
		NodeList nlGroupInstances = AppHelper.getNodeList(tfldg.xpath(), _source_record_node);
		for(int ix = 0; ix < nlGroupInstances.getLength(); ix++)
		{
			HashMap<String,ResponseField> _fields = new HashMap<>();
			
			for(TemplateResponseField field: tfldg.fields())
		    {
				_fields.put(field.name().toLowerCase(), new ResponseField(field, nlGroupInstances.item(ix)));	
		    }				
			
			String key = _fields.get(tfldg.key().toLowerCase()).value().toLowerCase();
			
			if(_grouprecs.containsKey(key))
			{
				

				int counter = 1;
				String key2 = key + "0" + counter;
				_grouprecs.put(key2, _grouprecs.get(key));
				keys_to_remove.add(key);
				
				while(_grouprecs.containsKey(key2))
				{
					counter++;
					key2 = key + "0" + counter;
				}
				
				_grouprecs.put(key2, _fields);
				
				
			}else
			{
				_grouprecs.put(key, _fields);
			}
				
		}
		
		for(String key: keys_to_remove)
		{
			_grouprecs.remove(key);
		}
    

		_count = _grouprecs.size();
		
		
		
	}


	/**
	 * @param prefix
	 * @return
	 */
	public String toString(String prefix)
	{
		StringBuilder sb = new StringBuilder();
		sb.append(prefix);
		sb.append(name());
		sb.append("\n");
		sb.append(ResponseField.fieldheader2("\t\t"));
		sb.append("\n");
		
		for(Entry<String, HashMap<String, ResponseField>> hmrf : _grouprecs.entrySet())
		{
			sb.append(prefix);
			sb.append(prefix);
			sb.append(hmrf.getKey());
			sb.append("\n");
			for(ResponseField rf: hmrf.getValue().values())
			{
				sb.append(rf.toString("\t\t\t\t"));
				sb.append("\n");
			}
			
			sb.append("\n");
		}
		
		
		
		return sb.toString();
	}
	
	/**
	 * @return
	 */
	public String name() {
		return _group_name;
	}


	

	/**
	 * @return
	 */
	public int count() {
		return _count;
	}


	/**
	 * @return
	 */
	public String path() {
		return _path;
	}


	/**
	 * @return
	 */
	public boolean pathfound() {
		return _path_found;
	}


	/**
	 * @param group_key
	 * @return
	 */
	public boolean containsKey(String group_key) {
		
		return _grouprecs.containsKey(group_key);
	}


	/**
	 * @param group_key
	 * @return
	 */
	public HashMap<String, ResponseField> get(String group_key) {
		
		return _grouprecs.get(group_key);
		
	}
	
	
	
}
