package gov.va.caret.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.ResourceAction;
import com.liferay.portal.model.ResourceConstants;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.RoleConstants;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.portlet.OnlinePortlet;

public class CodifiedRole {
	
	private static CodifiedRole instance = new CodifiedRole();
	private static long companyId = PortalUtil.getDefaultCompanyId();
	
	private Map<String,String> codifiedRoles = new HashMap<String,String>();
	
	public static String getRoleName( String key ) {
		if ( instance.codifiedRoles.isEmpty() ){
			init();
		}
		return instance.codifiedRoles.get( key );
	}
	
	private static void init() {
		try {
			ServiceContext sc = new ServiceContext();
			sc.setUserId( UserLocalServiceUtil.getDefaultUserId( companyId ) );
			sc.setCompanyId( companyId );
			sc.setAddGuestPermissions(false);

			instance.loadRoles(sc);
		} catch (SystemException e) {
			e.printStackTrace();
		} catch (PortalException e) {
			e.printStackTrace();
		}
	}

	public static String getCode ( String roleName ){
		if ( instance.codifiedRoles.isEmpty() ){
			init();
		}
		for ( String key : instance.codifiedRoles.keySet() ){
			if ( instance.codifiedRoles.get(key).equals(roleName) ){
				return key;
			}
		}
		return StringPool.BLANK;
	}
	
	public static Set<String> getCodifiedKeys(){
		if ( instance.codifiedRoles.isEmpty() ){
			init();
		}
		return instance.codifiedRoles.keySet();
	}

	public static boolean updateClinicRole ( long userId, long[] roleIds, Long[] orgIds ) throws PortalException, SystemException {
		if ( orgIds != null && orgIds.length > 0 ){
			UserLocalServiceUtil.updateOrganizations( userId, ArrayUtil.toArray(orgIds), new ServiceContext());
		}
		RoleLocalServiceUtil.setUserRoles( userId, roleIds );
		return true;
	}
	
	
	class RoleImport {
		String name;
		long roleId;
		List<String> actions;
		RoleImport(String name, long roleId){
			this.actions = new ArrayList<String>();
			this.name = name;
			this.roleId = roleId;
		}
		public long getRoleId() {
			return roleId;
		}
		public String getName() {
			return name;
		}
		public List<String> getActions() {
			return actions;
		}
		public void addAction(String action) {
			this.actions.add(action);
		}
	}

	private void loadRoles ( ServiceContext serviceContext ) throws SystemException, PortalException {
			
			Properties props = new Properties( );
			try {
				props.load( getClass().getClassLoader().getResourceAsStream("role.properties") );
			} catch (IOException e) {
				e.printStackTrace();
			}
		
			int totalRoles = Integer.valueOf( props.getProperty("totalRoles") );
			
			Map<String,RoleImport> roles = new HashMap<String,RoleImport>();
			boolean error = false;
			
			for ( int i = 0; i < totalRoles && !error ; i++ ){
				
				String roleName = props.get("role"+i+".name").toString();
				Role role = RoleLocalServiceUtil.fetchRole( serviceContext.getCompanyId(), roleName );
				if ( role == null ){
					long classPK = CounterLocalServiceUtil.increment( Role.class.getName() );
					
					role = RoleLocalServiceUtil.addRole(serviceContext.getUserId(), 
							Role.class.getName(), classPK, roleName, 
							Collections.singletonMap(LocaleUtil.getDefault(), roleName), 
							Collections.singletonMap(LocaleUtil.getDefault(), "Autogenerated role for CareT"),
							RoleConstants.TYPE_REGULAR, PropsUtil.get( "roles.regular.subtypes" ), serviceContext);
					
					if ( role != null ){
						List<?> roleResourcePermission = ResourcePermissionLocalServiceUtil.getRoleResourcePermissions( role.getRoleId() );
						
						if ( roleResourcePermission == null || roleResourcePermission.isEmpty() ){
						
							String[] roleActionsProp = props.get("role"+i+".actions").toString().split(StringPool.COMMA);
							
							RoleImport roleImport = new RoleImport(roleName, role.getRoleId());
							for ( String actions: roleActionsProp ){
								actions = actions.trim();
								roleImport.addAction(actions);
							}
							roles.put( "role"+i, roleImport );
						}
					}
				}
				
				String[] codes = props.get("role"+i+".code").toString().split(StringPool.COMMA);
				for ( String code: codes){
					codifiedRoles.put(code, roleName);
				}
			}
			codifiedRoles.put( props.get("veteran.code").toString(), props.get("veteran.name").toString() );
			codifiedRoles.put( props.get("caregiver.code").toString(), props.get("caregiver.name").toString() );
			
			String PRIMKEY = String.valueOf( serviceContext.getCompanyId() );
			String[] resourceNames = new String[]{
					CAction.CARET_PORTLET, CAction.SCOPE_DASHBD_QS, CAction.SCOPE_DASHBOARD,
					CAction.SCOPE_CALLS, CAction.SCOPE_VCGS, CAction.SCOPE_MESSAGES,
					CAction.SCOPE_APPLICATIONS, CAction.SCOPE_UI_EXTRAS };
			for ( String key : roles.keySet() ){
				long roleId = roles.get(key).getRoleId();
				List<String> actions = roles.get(key).getActions();
				String roleName0 = roles.get(key).getName();
				for ( String resourceName: resourceNames ){
					assignActions( resourceName, roleName0, actions, serviceContext.getCompanyId(), roleId, PRIMKEY, ResourceConstants.SCOPE_COMPANY );
				}
			}
			
		addRoles2 ( serviceContext, props );
	}
	
	
	private void addRoles2(ServiceContext serviceContext, Properties props) throws SystemException {
	
		Map<String,RoleImport> roles = new HashMap<String,RoleImport>();
		
		for ( String rolePropName: new String[]{"veteran", "caregiver"} ){
		
			String roleName = props.get( rolePropName +".name").toString();
			Role role = RoleLocalServiceUtil.fetchRole( serviceContext.getCompanyId(), roleName );
			if ( role == null ){
				long classPK = CounterLocalServiceUtil.increment( Role.class.getName() );
				
				try {
					role = RoleLocalServiceUtil.addRole(serviceContext.getUserId(),
							Role.class.getName(), classPK, roleName, 
							Collections.singletonMap(LocaleUtil.getDefault(), roleName), 
							Collections.singletonMap(LocaleUtil.getDefault(), "Autogenerated role for CareT Online"),
							RoleConstants.TYPE_SITE, null, serviceContext);
				} catch (PortalException e) {
					e.printStackTrace();
				}
			}
			
			if ( role != null ){
				List<?> c = ResourcePermissionLocalServiceUtil.getRoleResourcePermissions( role.getRoleId() );
				if ( c == null || c.isEmpty() ){  //configure role
					String[] roleActionsProp = props.get(rolePropName +".actions").toString().split(StringPool.COMMA);
					RoleImport roleImport = new RoleImport(roleName, role.getRoleId());
					for ( String actions: roleActionsProp ){
						actions = actions.trim();
						roleImport.addAction(actions);
					}
					roles.put( rolePropName, roleImport );
				}
			}
		}
		
		try {
			String PRIMKEY = "0";
			for ( String key : roles.keySet() ){
			assignActions( OnlinePortlet.PLID, roles.get(key).getName(), 
							roles.get(key).getActions(),
							serviceContext.getCompanyId(),
							roles.get(key).getRoleId(),
							PRIMKEY,
							ResourceConstants.SCOPE_GROUP_TEMPLATE);
			}
		} catch (PortalException e) {
			e.printStackTrace();
		}
	}
	
	private void assignActions( String resourceName, String roleName, List<String> actions, long companyId, long roleId, String primKey, int scope ) throws SystemException, PortalException {
		
		List<ResourceAction> availableActions = ResourceActionLocalServiceUtil.getResourceActions(resourceName);
		
		long resourceActionBitwiseValue = 0;
		List<String> list = new ArrayList<String>();
		for ( ResourceAction resourceAction: availableActions ){
			String actionId = resourceAction.getActionId();
			if ( actions.contains ( actionId ) ){
				resourceActionBitwiseValue += resourceAction.getBitwiseValue();
				list.add(actionId);
			}
		}
		
		if ( resourceActionBitwiseValue > 0 ){
			ResourcePermissionLocalServiceUtil.setResourcePermissions( companyId,
					resourceName,
					scope,
					primKey,
					roleId,
					list.toArray(new String[list.size()]) );
		}
	}
	
}
