package gov.va.caret.portlet.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.ProcessAction;

import org.apache.commons.collections.CollectionUtils;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.NoSuchClassNameException;
import com.liferay.portal.kernel.dao.jdbc.OutputBlob;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CountryConstants;
import com.liferay.portal.model.Dummy;
import com.liferay.portal.model.Role;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.service.RegionServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.bean.AssmtBean;
import gov.va.caret.bean.AttachmentBean;
import gov.va.caret.bean.CespBean;
import gov.va.caret.controller.CaretViewController;
import gov.va.caret.controller.dashboard.config.CbopcDashboardConfig;
import gov.va.caret.controller.dashboard.config.CbopcFmDashboardConfig;
import gov.va.caret.controller.dashboard.config.CslDashboardConfig;
import gov.va.caret.controller.dashboard.config.DashboardConfig;
import gov.va.caret.controller.dashboard.config.DashboardConfigFactory;
import gov.va.caret.controller.dashboard.config.FacilityDashboardConfig;
import gov.va.caret.letters.CscLetterType;
import gov.va.caret.letters.OccLetterType;
import gov.va.caret.letters.PopulateLettersImpl;
import gov.va.caret.model.Apeal;
import gov.va.caret.model.Assmt;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.BgNum;
import gov.va.caret.model.BlsRe;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.CalEt;
import gov.va.caret.model.Call;
import gov.va.caret.model.Cesp;
import gov.va.caret.model.ClSoc;
import gov.va.caret.model.Docum;
import gov.va.caret.model.Letter;
import gov.va.caret.model.Note;
import gov.va.caret.model.PayLg;
import gov.va.caret.model.Persn;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.Vendr;
import gov.va.caret.model.Waivr;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.WorSe;
import gov.va.caret.model.impl.ApealImpl;
import gov.va.caret.model.impl.AssmtImpl;
import gov.va.caret.model.impl.BgAsnImpl;
import gov.va.caret.model.impl.BgLaeImpl;
import gov.va.caret.model.impl.CalEtImpl;
import gov.va.caret.model.impl.CallImpl;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.model.impl.StiPtImpl;
import gov.va.caret.model.impl.VcgAnImpl;
import gov.va.caret.model.impl.WaivrImpl;
import gov.va.caret.model.impl.WorImImpl;
import gov.va.caret.model.impl.WorSeImpl;
import gov.va.caret.model.support.ApplicationStatus;
import gov.va.caret.model.support.BoxedGroupAssociation;
import gov.va.caret.model.support.General;
import gov.va.caret.model.support.NoteSupport;
import gov.va.caret.model.support.NoteSupport.NoteGroup;
import gov.va.caret.model.support.PaymentLog;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.Primary;
import gov.va.caret.model.support.Secondary;
import gov.va.caret.model.support.SecondaryTwo;
import gov.va.caret.model.support.VcgApplication;
import gov.va.caret.model.support.VcgSupport;
import gov.va.caret.model.support.Vendor;
import gov.va.caret.model.support.Veteran;
import gov.va.caret.model.support.WorkItemSupport;
import gov.va.caret.model.support.WorkStatus;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.model.support.occ.StipendConfig;
import gov.va.caret.pdf.FileType;
import gov.va.caret.pm.portlet.PMPortlet;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.security.CodifiedRole;
import gov.va.caret.service.ApealLocalServiceUtil;
import gov.va.caret.service.AssmtLocalServiceUtil;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.BlsReLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CallLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.CespLocalServiceUtil;
import gov.va.caret.service.ClSocLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.LetterLocalServiceUtil;
import gov.va.caret.service.NoteLocalServiceUtil;
import gov.va.caret.service.PayLgLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.StiPtLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.service.VcgLocalServiceUtil;
import gov.va.caret.service.VendrLocalServiceUtil;
import gov.va.caret.service.WaivrLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.service.WorSeLocalServiceUtil;
import gov.va.caret.service.impl.FmsOgSupport;
import gov.va.caret.service.thread.Monitor;
import gov.va.caret.service.tiu.TiuService;
import gov.va.caret.soc.SocCachedReportUtil;
import gov.va.caret.util.CaretMap;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.ResultMap;
import gov.va.caret.workflow.OwnerQueue;
import gov.va.caret.workflow.QueAction;
import gov.va.caret.workflow.WorkName;
import gov.va.med.via.service.TextTO;
import gov.via.sts.service.StsService;


public class CaretActionCommand extends ActionCommand implements Serializable {
	
private static final long serialVersionUID = 2251500780038409153L;
	
@ProcessAction (name="loadVcgManagement")
public void loadVcgManagement( ActionRequest request, ActionResponse response ) {
	//CaretUtil.sendPaymentNotificationMail();
	long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
	long vcgId = ParamUtil.getLong( request, CaretStrPool.VCGID );
	if ( vcgId == 0 ){
		vcgId = (Long) request.getAttribute(CaretStrPool.VCGID);
	}
	
	Map<String, Object> form = ResultMap.getForm(request);
	form.put(CaretStrPool.WORK_ID, worImId);
	try {
		VcgSupport vcg = null;
		VcgAn app = null;
		if ( vcgId != 0 ){
			vcg = VcgSupport.getVcgSupport(vcgId);
			vcg.setViewable( request );
			if (! vcg.isViewMember() ) {
				_log.error("Facility membership group missing");
				return;
			}
			long associate = ParamUtil.getLong(request, "associate");
			if ( associate > 0 ) {
				associateWorkItem ( associate, vcgId, request );
			}
			
			//StsService.getEmrSvcInterface(vcg, request);
			app =  VcgAnLocalServiceUtil.getRecent(vcgId);
			if ( app == null ){
				app = new VcgAnImpl();
			}
			List<Docum> supportDocs = new ArrayList<Docum>();

			
			DashboardConfig dashConfig = ( DashboardConfig ) request.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG );
			if ( dashConfig instanceof CbopcDashboardConfig ){
				form.put("queueIds", ((CbopcDashboardConfig)dashConfig).getQueueIds());
			} else {
				form.put("queueIds", "-1");
				if ( dashConfig instanceof FacilityDashboardConfig ) {
					ResultMap.getCaretMap(request).put( CaretStrPool.VHA_MEMBER, CaretUtil.getVhaOrgList( request ) );
				}
			}
			
			form.put("supportDocs", supportDocs );
			ResultMap.getCaretMap(request).put( CaretStrPool.VCG_UPLOAD_FILE_TYPES, Arrays.asList(FileType.values()) );
			form.put(CaretStrPool.VCG_UPLOAD_FILE_TYPES, Arrays.asList(FileType.values()));
			
			//_log.info("number of supporting docs is : "+supportDocs.size());
			
		}
		
		form.put(CaretStrPool.VCGAN, app);
		vcg.loadPermissionState( request );
		form.put("vcg", vcg);
		
						
		
		//***Start of Supporting Doc Code ****		
		VcgSupport vcgSupport = new VcgSupport(vcg);
		vcgSupport.getSupportingDocData();
				
		form.put("vcgDocsCurrent", vcgSupport.getVcgDocsCurrent());
		form.put("vcgDocsCurrentSize", vcgSupport.getVcgDocsCurrent().size());

		
		// Periodic Assessments code 
		String section = ParamUtil.getString(request, "section", "");
		form.put("section", section);
		
		form.put("EaE", CaretUtil.isMviEnabled());
		
		//***Start of Assessments Code***		
		form.put(CaretStrPool.VETERAN_ID, app.getVeteranId() );
		if ( vcgId > 0 ){
			//get all applications for the vcg record (vcgid) - then check for IN_PROCESS apps
			List<VcgAn> vcgAnList= VcgAnLocalServiceUtil.getByVcg(vcgId);				
			
			for(VcgAn vcgAn:vcgAnList)
			{
				String dateStr = Toolbox.formatDateCprs(vcgAn.getReceivedDate());
				if(vcg.getPrimaryVcgAnId()==vcgAn.getVcgAnId()){
					form.put("primaryValidAppDate", dateStr);
				}
				if(vcg.getSecondaryVcgAnId()==vcgAn.getVcgAnId()){
					form.put("secondaryValidAppDate", dateStr);
				}				 
				if(vcg.getSecondaryTwoVcgAnId()==vcgAn.getVcgAnId()){
					form.put("secondaryTwoValidAppDate", dateStr);
				}
			}
			
			//for periodic assessments
			if(vcg.getPrimaryDispReason()!=null && (vcg.isApproved(vcg.getPrimaryDispReason())||(vcg.isReinstated(vcg.getPrimaryDispReason())))){
				String dateStr = Toolbox.formatDateCprs(vcg.getPrimaryDispositionDate());
				form.put("primaryApprovalDate", dateStr);				
			}
		
			loadAssessments(request, form, vcg);
			
			String showSection = ParamUtil.getString(request, CaretStrPool.SHOW_SECTION, "");
			request.setAttribute("showSection", showSection);
			if(showSection!=null && !showSection.equals("")){
				request.setAttribute("showAssessments", true);			 
			}
		}
		//***End of Assessments Code***
		
		ResultMap.getCaretMap(request).put("noteContext", "vcg");
		ResultMap.getCaretMap(request).put("context", "manageVcg");
		
	} catch (IllegalArgumentException e) {
		ApplicationWorkFlowException.handleException(e);
	} catch (PortalException e) {
		ApplicationWorkFlowException.handleException(e);
	}
	
}
	@ProcessAction (name="loadProcessApplication")
	public void loadProcessApplication ( ActionRequest request, ActionResponse response ) {
		Map<String, Object> form = ResultMap.getForm(request);
		request.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( request ) );
		long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		form.put(CaretStrPool.WORK_ID, worImId);
		try {
			if ( worImId > 0 ){
				
				long vcgAnId = ParamUtil.getLong(request, CaretStrPool.PRIMARY_KEY);
				_log.info("primary key is : "+vcgAnId);
				VcgAn app = VcgAnLocalServiceUtil.getVcgAn( vcgAnId );
				Veteran veteran = new Veteran( PersnLocalServiceUtil.getPersn( app.getVeteranId() ) );
				
				form.put( CaretStrPool.VETERAN_PERSN, veteran );
				Boolean verifiedVeteranOnly = true; // || StringPool.TRUE.equals( PortletProps.get("process-app-veteran.registered") );
				form.put( CaretStrPool.REGISTERED_ONLY, verifiedVeteranOnly );
				
				if ( app.getPrimaryId() > 0 ){
					form.put(CaretStrPool.PRIMARY_PERSN, new Primary (PersnLocalServiceUtil.getPersn( app.getPrimaryId() ) ) );
				}
				if ( app.getSecondaryId() > 0 ){
					form.put(CaretStrPool.SECONDARY_PERSN, new Secondary (PersnLocalServiceUtil.getPersn( app.getSecondaryId() ) ) );
				}
				if ( app.getSecondaryTwoId() > 0 ){
					form.put(CaretStrPool.SECONDARY_TWO_PERSN, new SecondaryTwo (PersnLocalServiceUtil.getPersn( app.getSecondaryTwoId() ) ) );
				}
				String actives = Arrays.deepToString( veteran.getVcgActives() );
				form.put(CaretStrPool.ACTIVE_VCG, actives.substring(1,actives.length()-2) );
				form.put("workType", WorImLocalServiceUtil.getWorIm(worImId).getType() );
				form.put(CaretStrPool.VCGAN, app);
				
				List<Docum> supportDocs = DocumLocalServiceUtil.getByPrimaryKey( vcgAnId );
				form.put("supportDocs", supportDocs );
				_log.info("number of supporting docs is : "+supportDocs.size());
				form.put("veteranId", app.getVeteranId() );
				ResultMap.getCaretMap(request).put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
				response.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.VCG_DISPOSITION_PAGE);
			}
		} catch (IllegalArgumentException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
	}
	
	public void loadAssessments( ActionRequest request, Map<String,Object> form, Vcg vcg) 
	{
		try 
		{			
			AssmtBean primaryClinical = new AssmtBean(new AssmtImpl(), CaretStrPool.PRIMARY_CLINICAL); 				
			AssmtBean primaryAssessment = new AssmtBean(new AssmtImpl(), CaretStrPool.PRIMARY_ASSESSMENT); 			
			AssmtBean primaryTraining = new AssmtBean(new AssmtImpl(), CaretStrPool.PRIMARY_TRAINING); 				
			AssmtBean primaryInHome = new AssmtBean(new AssmtImpl(), CaretStrPool.PRIMARY_IN_HOME); 				
			AssmtBean secondaryClinical = new AssmtBean(new AssmtImpl(), CaretStrPool.SECONDARY_CLINICAL); 
			AssmtBean secondaryAssessment = new AssmtBean(new AssmtImpl(), CaretStrPool.SECONDARY_ASSESSMENT); 
			AssmtBean secondaryTraining = new AssmtBean(new AssmtImpl(), CaretStrPool.SECONDARY_TRAINING); 
			AssmtBean secondaryTwoClinical = new AssmtBean(new AssmtImpl(), CaretStrPool.SECONDARY_TWO_CLINICAL); 
			AssmtBean secondaryTwoAssessment = new AssmtBean(new AssmtImpl(), CaretStrPool.SECONDARY_TWO_ASSESSMENT); 
			AssmtBean secondaryTwoTraining = new AssmtBean(new AssmtImpl(), CaretStrPool.SECONDARY_TWO_TRAINING); 
			
			List<Assmt> completedAssessmentList = AssmtLocalServiceUtil.findByVcgId(vcg.getVcgId());
			
			long year=0;
			for(Assmt assessment:completedAssessmentList)
			{
				//get active assessments for the caregiver
				if(assessment.isActive())
				{
					String dateStr = Toolbox.formatDateCprs(assessment.getCompletionDate());				
					if(assessment.getType().equals(CaretStrPool.PRIMARY_CLINICAL) && assessment.getCaregiverId()==vcg.getPrimaryId()){
						primaryClinical.setAssessment(assessment);
						primaryClinical.setFormattedcompletionDate(dateStr);					
					}else if(assessment.getType().equals(CaretStrPool.PRIMARY_ASSESSMENT) && assessment.getCaregiverId()==vcg.getPrimaryId()){
						primaryAssessment.setAssessment(assessment);
						primaryAssessment.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.PRIMARY_TRAINING) && assessment.getCaregiverId()==vcg.getPrimaryId()){
						primaryTraining.setAssessment(assessment);
						primaryTraining.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.PRIMARY_IN_HOME) && assessment.getCaregiverId()==vcg.getPrimaryId()){
						primaryInHome.setAssessment(assessment);
						primaryInHome.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_CLINICAL) && assessment.getCaregiverId()==vcg.getSecondaryId()){
						secondaryClinical.setAssessment(assessment);
						secondaryClinical.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_ASSESSMENT) && assessment.getCaregiverId()==vcg.getSecondaryId()){
						secondaryAssessment.setAssessment(assessment);
						secondaryAssessment.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_TRAINING) && assessment.getCaregiverId()==vcg.getSecondaryId()){
						secondaryTraining.setAssessment(assessment);
						secondaryTraining.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_TWO_CLINICAL) && assessment.getCaregiverId()==vcg.getSecondaryTwoId()){
						secondaryTwoClinical.setAssessment(assessment);
						secondaryTwoClinical.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_TWO_ASSESSMENT) && assessment.getCaregiverId()==vcg.getSecondaryTwoId()){
						secondaryTwoAssessment.setAssessment(assessment);
						secondaryTwoAssessment.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_TWO_TRAINING) && assessment.getCaregiverId()==vcg.getSecondaryTwoId()){
						secondaryTwoTraining.setAssessment(assessment);
						secondaryTwoTraining.setFormattedcompletionDate(dateStr);
					}
					
					if(assessment.getYear()>year){
						year = assessment.getYear();
					}
				}
			}
					
			
			List<AssmtBean> primaryAssessmentList = new ArrayList<AssmtBean>();
			primaryAssessmentList.add(primaryClinical);
			primaryAssessmentList.add(primaryAssessment);
			primaryAssessmentList.add(primaryTraining);
			primaryAssessmentList.add(primaryInHome);
			
			List<AssmtBean> secondaryAssessmentList = new ArrayList<AssmtBean>();
			secondaryAssessmentList.add(secondaryClinical);
			secondaryAssessmentList.add(secondaryAssessment);
			secondaryAssessmentList.add(secondaryTraining);

			List<AssmtBean> secondaryTwoAssessmentList = new ArrayList<AssmtBean>();
			secondaryTwoAssessmentList.add(secondaryTwoClinical);
			secondaryTwoAssessmentList.add(secondaryTwoAssessment);
			secondaryTwoAssessmentList.add(secondaryTwoTraining);

			form.put("primaryAssessmentList", primaryAssessmentList);
			form.put("secondaryAssessmentList", secondaryAssessmentList);
			form.put("secondaryTwoAssessmentList", secondaryTwoAssessmentList);				
			
			
			//****Start for Periodic Assessments*****
			
			//get current set of periodic assessments
			List<AssmtBean> periodicAssessmentList = new ArrayList<AssmtBean>();
			for(Assmt assessment:completedAssessmentList)
			{
				AssmtBean assmtBean = new AssmtBean(new AssmtImpl(), "");
				//String completionDateStr = Toolbox.formatDateCprs(assessment.getCompletionDate());
				String completionDateStr = "";
				if(assessment.isActive() && assessment.getYear()>0 && (year==assessment.getYear() || (year-1)==assessment.getYear()))
				{
					String scheduleDateStr = Toolbox.formatDateCprs(assessment.getScheduleDate());
					if(assessment.getMode().equals(CaretStrPool.NOT_COMPLETED) && assessment.getCompletionDate()==null){
						completionDateStr = "";
					}else{
						completionDateStr = Toolbox.formatDateCprs(assessment.getCompletionDate());
					}
										
					assmtBean.setAssessment(assessment);
					assmtBean.setFormattedScheduleDate(scheduleDateStr);					
					assmtBean.setFormattedcompletionDate(completionDateStr);					
					periodicAssessmentList.add(assmtBean);
				}
				//_log.info("assessment id is : "+assessment.getAssmtId());
			}	
			
			//_log.info("periodic assmt number is : "+periodicAssessmentList.size());

			form.put("periodicAssessmentList", periodicAssessmentList);
			form.put("periodicAssessmentSize", periodicAssessmentList.size());
			
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}

	
	@ProcessAction (name="workClose")
	public void workClose ( ActionRequest request, ActionResponse response ) {
		_log.info("workClose");
		ServiceContext sc = CaretParam.setCaretServiceContext(request);
		String workType = request.getParameter("workType");
		if ( "rejectedPayments".equals(workType ) || "returnedPayments".equals(workType ) || "heldPayments".equals(workType ) ) {
			
			String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
			if ( ! CaretParam.isTracked( request, tracker, true ) ){
				_log.warn("TRACKER BLOCKING action... ");
				request.setAttribute(CaretStrPool.INVALID_REQUEST, true);
				return;
			}
			
			if ( ! CAction.canDoCaret(request, CaretCan.CBOPC_HELD_PAYMENT_Q) ) {
				_log.warn("Access missing to release...");
				return;
			}
			Set<Long> workIds = new HashSet<Long>();
			for ( String id: request.getParameter( workType +"_rowCheckerIds").split(StringPool.COMMA ) ) {
				
				if ( "on".equals(id)) {
					continue;
				}
				
				workIds.add( Long.valueOf(id) );
			}
			if ( !workIds.isEmpty() ) {
				try {
					FmsOgSupport.removeHold( sc, workIds );
				} catch (SystemException | PortalException e) {
					e.printStackTrace();
				}
			}
			return;
		}
		long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		try {
			WorkItemSupport workItem = new WorkItemSupport(WorImLocalServiceUtil.getWorIm(worImId) );
			switch ( WorkType.valueOf( workItem.getType() ) ){
			case CALL_REFERRAL:
			case REFERRAL:
			case HEC_REFERRAL:
			case HRC_REFERRAL:
			case CSL_REFERRAL:
			case DELAY_REVIEWED:
				
				workItem.setStatus( WorkStatus.COMPLETE.name() );
				workItem.setCompletionBy( sc.getUserId() );
				workItem.setCompletionDate( sc.getCreateDate() );
				
				CaretLocalServiceUtil.save(workItem);
				_log.info("adding note " + LanguageUtil.get( Locale.getDefault(), ParamUtil.get(request, CaretStrPool.WORK_COMMENT, StringPool.BLANK) ) );
				CaretLocalServiceUtil.addNote(CaretUtil.createNote(sc.getCreateDate(),
						worImId,
						NoteSupport.NoteGroup.CLOSE_NOTE.groupId(),
						sc.getUserId(),
						ParamUtil.get(request, CaretStrPool.WORK_COMMENT, StringPool.BLANK)));
				break;
			case FAILED_TIU_NOTE:
				if ( worImId > 0 && CAction.canDoCaret(request, CAction.CaretCan.APPROVE_TIU_REWRITE ) ){
					if ( workItem.getCompletionDate() == null ){
						VcgSupport vcg = new VcgSupport( VcgLocalServiceUtil.getVcg( workItem.getVcgId() ) );
						BaseModel<?> bm = vcg.getPersonVcgAn( workItem.getCaregiverId() );
						if ( bm == null ){
							bm = vcg;
						}
						WorkItemSupport cscWork = new WorkItemSupport( 
								CaretUtil.createWorkItem( sc, vcg.getGroupId(), bm, WorkType.TIU_NOTE_REWRITE, vcg.getVeteranId(), workItem.getCaregiverId() ) );
						cscWork.setVcgId( workItem.getVcgId() );
						String note = ParamUtil.get(request, CaretStrPool.WORK_COMMENT, StringPool.BLANK);
						if ( !Toolbox.isEmpty(note) ){
							Note noteObj = CaretUtil.createNote(sc.getCreateDate(), worImId, NoteSupport.NoteGroup.CLOSE_NOTE.groupId(), sc.getUserId(), note);
							CaretLocalServiceUtil.addNote(noteObj);
							CaretLocalServiceUtil.save( cscWork );
							cscWork.useNote("tiuRewriteNote", noteObj);
							workItem.useNote("tiuRewriteNote", noteObj);
						}
						CaretLocalServiceUtil.save( cscWork );
						workItem.setCompletionBy( sc.getUserId() );
						workItem.setStatus( WorkStatus.COMPLETE.name() );
						workItem.setCompletionDate( sc.getCreateDate() );
						CaretLocalServiceUtil.save( workItem );
					}
				}
			default:
				break;
			}
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}

	@ProcessAction (name="openReferral")
	public void openReferral ( ActionRequest request, ActionResponse response ) {
		
		try {
			WorkType type = WorkType.valueOf( ParamUtil.getString(request, "type", StringPool.BLANK) );  
			request.setAttribute(CaretStrPool.WORK_ID, ParamUtil.getLong(request, CaretStrPool.WORK_ID ) );
			switch ( type ){
			case CSL_REFERRAL:
			case CALL_REFERRAL:
				loadCall(request);
				response.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_CALL_PAGE);
				break;
			case REFERRAL:
			case HEC_REFERRAL:
			case HRC_REFERRAL:
				loadReferral(request);
				response.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_REFERRAL_PAGE);
				break;
			default:
				break;
			}
			if ( "VCG_MANAGEMENT_PAGE".equals( ParamUtil.getString(request, "onPageComplete", StringPool.BLANK) ) ){
				ResultMap.getForm(request).put("onPageComplete", "VCG_MANAGEMENT_PAGE" );
//				response.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.VCG_MANAGEMENT_PAGE);
			}
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (IllegalArgumentException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
		
	}
	
	@ProcessAction (name="loadTen10App")
	public void loadVcgAnApp ( ActionRequest actionRequest, ActionResponse actionResponse ) {
		_log.info("loadTen10App..." );
		actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/internal/createTen10.jsp" );
		loadStatesAndFacilities( actionRequest );
	}
	
	public void loadStatesAndFacilities ( PortletRequest request ) {
		try {
			Map<String,Object> caret = ResultMap.getCaretMap(request);
			caret.put( CaretStrPool.VHA_SYSTEM, CaretUtil.getVhaOrgTree( PortalUtil.getCompanyId( request ), true ) );
			try {
				caret.put(CaretStrPool.STATES, RegionServiceUtil.getRegions( CountryConstants.DEFAULT_COUNTRY_ID ) );
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
			
			
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	private void saveBoxGroups ( PortletRequest request, long primaryKey ){
		try {
			List<Long> fmChecks = CaretParam.loadSelectedBoxModel(request, CaretStrPool.BOX_GROUP);

			String[] radioNames = new String[]{
					"boxRadioGrp_heardFromUs", "boxRadioGrp_enrolledVaHealth", 
					"boxRadioGrp_dischargedAfter911", "boxRadioGrp_veteranScCondition",
					"boxRadioGrp_prescreenPcafc"
			};
			for ( String radio: radioNames ){
				Long radioId = ParamUtil.getLong(request, radio, 0);
				if ( radioId > 0 ){
					fmChecks.add(radioId);
				}
			}
			
			if ( primaryKey > 0 ){
				List<Long> updated = new ArrayList<Long>();
				List<BgAsn> bgAsnList = BoxGpLocalServiceUtil.getBoxGroupAssociations( primaryKey );
				for ( BgAsn bgAsn: bgAsnList ){
					if ( fmChecks.contains( bgAsn.getBoxGpId() ) ){
						if ( !bgAsn.isSelected() ){
							bgAsn.setSelected( true );
							CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
							updated.add( bgAsn.getBoxGpId() );
						}
						fmChecks.remove( bgAsn.getBoxGpId() );
					} else {
						if ( bgAsn.isSelected() ){
							bgAsn.setSelected( false );
							CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
						}
					}
				}
				for ( Long boxGpId: fmChecks){
					if ( ! updated.contains( boxGpId ) ){
						BgAsn bgAsn = new BgAsnImpl();
						bgAsn.setBoxGpId( boxGpId );
						bgAsn.setOwnerId( primaryKey );
						bgAsn.setSelected( true );
						CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
					}
				}
			} else {
				for ( Long boxGpId: fmChecks ){
					BgAsn bgAsn = new BgAsnImpl();
					bgAsn.setBoxGpId(boxGpId);
					bgAsn.setOwnerId( primaryKey );
					bgAsn.setSelected( true );
					CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
				}
			}
			
			_log.info(fmChecks);
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	private void saveCall ( ActionRequest request ) throws ApplicationWorkFlowException{
		_log.info("saveCall..." );
		Call call = null;
		Person caller = null;
		Veteran veteran = null;
		
		getOutput(request);
		Long callId = ParamUtil.getLong(request, "call_primaryKey");
		Long veteranId = ParamUtil.getLong(request, "veteranPersn_primaryKey");
		
		ServiceContext sc = CaretParam.setCaretServiceContext(request);
		if ( callId > 0 ){
			try {
				call = CallLocalServiceUtil.getCall(callId);
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		
		if ( call == null) {
			call = new CallImpl();
		}
			
		Long callerId = ParamUtil.getLong(request, "callerPersn_primaryKey");
		
		Map<Long,Person> cachedMVI = (Map<Long,Person>) request.getPortletSession().getAttribute(CaretStrPool.CACHED_MVI);
		if ( cachedMVI == null ){
			cachedMVI = new HashMap<>();
		}
		
		if ( callerId > 0 ){
			try {
				if ( cachedMVI.containsKey(callerId) ){
					Persn person = null;
					if ( !Toolbox.isEmpty( cachedMVI.get(callerId).getICN() ) ){
						person = PersnLocalServiceUtil.getByIcn( cachedMVI.get(callerId).getICN() );
					}
					if ( person != null ){
						caller = new Person ( person );
					} else {
						caller = new Person( cachedMVI.get(callerId) );
						CaretLocalServiceUtil.save(caller);
					}
					callerId = caller.getPrimaryKey();
				}
				
				caller = new Person( PersnLocalServiceUtil.getPersn( callerId ) );
			} catch (Exception e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		if ( caller == null ){
			caller = new Person ( new PersnImpl() );
		}
		//TODO: pass list of parameter names 
		//////////////////////////////////////////
		String s_callbackPref = request.getParameter("call_callbackPref");
		//call.setCallbackPref(s_callbackPref);
		_log.info("MAction debug....CaretActionCommand.saveCall...call_callbackPref: " + s_callbackPref);
		String v5_callbackPref = SocCachedReportUtil.getCallbackPref_24HourFormat(s_callbackPref);
		_log.info("MAction debug....CaretActionCommand.saveCall...v5_callbackPref: " + v5_callbackPref);
		//////////////////////////////////////////		
		CaretParam.loadModel( request, call, call.getModelAttributes().keySet(), "call_");
		CaretParam.loadModelSingleElement(request, call, "callbackPref", v5_callbackPref, "call_");

		//TODO: pass list of parameter names 
		CaretParam.loadModel(request, caller, caller.getModelAttributes().keySet(), "callerPersn_");
		
		boolean unknown = ParamUtil.getBoolean(request,  "callerPersn_statusLabel");
		if ( unknown ){
			caller.setStatus(CaretStrPool.UNKNOWN_IDENTITY);
			caller.setFirstName(StringPool.BLANK);
			caller.setLastName(StringPool.BLANK);
		} else if ( !Toolbox.isEmpty( caller.getFirstName() ) ){
			caller.setStatus(StringPool.BLANK);
		} 
		
		if ( veteranId > 0 ){
			try {
				if ( cachedMVI.containsKey(veteranId) ){
					Persn person = null;
					if ( !Toolbox.isEmpty( cachedMVI.get(veteranId).getICN() ) ){
						person = PersnLocalServiceUtil.getByIcn( cachedMVI.get(veteranId).getICN() );
					}
					if ( person != null ){
						veteran = new Veteran ( person );
					} else {
						veteran = new Veteran( cachedMVI.get(veteranId) );
						CaretLocalServiceUtil.save(veteran);
					}
					veteranId = veteran.getPrimaryKey();
				}
				veteran = new Veteran ( PersnLocalServiceUtil.getPersn( veteranId ) );
			} catch (Exception e) {
				throw new ApplicationWorkFlowException(e);
			}
		}
		if ( veteran == null ){
			veteran = new Veteran ( new PersnImpl() );
		}
		//TODO: pass list of parameter names 
		
		CaretParam.loadModel(request, veteran, veteran.getModelAttributes().keySet(), "veteranPersn_");
		
		if ( veteran.isForeigner() ){
			CaretParam.loadModel( request, veteran, Toolbox.getAddressCollection(), CaretStrPool.VETERAN_PERSN + CaretStrPool.G_UNDERLINE );
		} else {
			CaretParam.loadModel( request, veteran, Toolbox.getAddressCollection(), CaretStrPool.VETERAN_PERSN + CaretStrPool.U_UNDERLINE );
		}
		
		if ( call.isSameAddress() ){
			caller.setAddress(veteran.getAddress());
			caller.setAddress2(veteran.getAddress2());
			caller.setZip(veteran.getZip());
			caller.setState(veteran.getState());
			caller.setCity(veteran.getCity());
			caller.setValidAddress(veteran.getValidAddress());
		} else {
			if ( caller.isForeigner() ){
				CaretParam.loadModel( request, caller, Toolbox.getAddressCollection(), CaretStrPool.CALLER_PERSN + CaretStrPool.G_UNDERLINE );
			} else {
				CaretParam.loadModel( request, caller, Toolbox.getAddressCollection(), CaretStrPool.CALLER_PERSN + CaretStrPool.U_UNDERLINE );
			}
		}
		CaretLocalServiceUtil.save( caller );
		CaretLocalServiceUtil.save( veteran );
		_log.info("veteran is " + veteran);
		
		long roleId = (Long)sc.getAttribute( CaretStrPool.ROLE_ID );
		ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );

		String message = null;
		if ( call.getPrimaryKey() == 0 ){
			call.setCreateGroupId( roleId );
			call.setUserId( (Long) sc.getAttribute( CaretStrPool.USER_ID ) );
			try {
				message = PortalUtil.getUser(request).getFullName() + " created " +
							LanguageUtil.get(themeDisplay.getLocale(), call.getCallType()) + " as " +
							LanguageUtil.get(themeDisplay.getLocale(), call.getCallState() ) ; 
			} catch (Exception e) {
				throw new ApplicationWorkFlowException(e);
			}
		}
		call.setVeteranPersnId( veteran.getPersnId() );
		call.setCallerPersnId( caller.getPersnId() );
		if ( call.getCallId() > 0 ){
			call.setModificationDate( sc.getCreateDate() );
		}
		if ( call.getCallState() != null &&
				call.getCallState().toLowerCase().contains(CaretStrPool.CALL_STATE_COMPLETE)
				&& call.getCompletionDate() == null ){
			call.setCompletionDate(sc.getCreateDate());
		}
		call = (Call)CaretLocalServiceUtil.save( call );
		if ( CaretStrPool.CALL_STATE_REFERRAL.equals( call.getCallState() ) ){
			WorIm workItem = null;
			
			if ( veteran.getGroupId() > 0  ){//type, persnId
				if ( call.getWorkPrimaryKey() > 0 ){
					try {
						workItem = WorImLocalServiceUtil.getWorIm( call.getWorkPrimaryKey() );
						if ( workItem != null ){
							workItem.setGroupId( veteran.getGroupId() );
							CaretLocalServiceUtil.save( workItem );
						}
					} catch (PortalException e) {
						ApplicationWorkFlowException.handleException(e);
					} catch (SystemException e) {
						ApplicationWorkFlowException.handleException(e);
					}
				}
				if ( workItem == null ){
					call.setCallState(CaretStrPool.CALL_STATE_COMPLETE);
					DashboardConfig dashConfig = ( DashboardConfig ) request.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG );
					call.setCreateGroupId( dashConfig.getRoleId() );
					call.setUserId( (Long) sc.getAttribute( CaretStrPool.USER_ID ) );
					CaretLocalServiceUtil.save( call );
					
					WorkType workType;
					if ( dashConfig instanceof CslDashboardConfig ){
						workType = WorkType.CSL_REFERRAL;
					} else {
						try{
							workType = WorkType.valueOf( dashConfig.getRole() + "_REFERRAL");
						} catch(Exception e){
							workType = WorkType.REFERRAL;
						}
					}
					
					workItem = CaretUtil.createWorkItem(sc, veteran.getGroupId(), call, workType, veteran.getPersnId(), call.getCallerPersnId() );
					
//					workItem.setQueId(CaretStrPool.REFERRAL_QUE);
					CaretLocalServiceUtil.save( workItem );
					call.setWorkPrimaryKey(workItem.getPrimaryKey());
					CaretLocalServiceUtil.save( call );
				}
				workItem = new WorkItemSupport(workItem);
				if ( !Toolbox.isEmpty( call.getTransferRemarks() ) ){
					((WorkItemSupport)workItem).useNote("referralRemark", CaretUtil.createNote(sc.getCreateDate(), workItem.getWorImId(), NoteSupport.NoteGroup.REFERRAL.groupId(), sc.getUserId(), call.getTransferRemarks()));
				}
				if ( !Toolbox.isEmpty( call.getSummary() ) ){
					((WorkItemSupport)workItem).useNote("referralSummary", CaretUtil.createNote(sc.getCreateDate(), workItem.getWorImId(), NoteSupport.NoteGroup.REFERRAL.groupId(), sc.getUserId(), call.getSummary()));
				}
				if ( !Toolbox.isEmpty( call.getTransferredTo() ) ){
					((WorkItemSupport)workItem).useNote("referralWarmTransferTo", CaretUtil.createNote(sc.getCreateDate(), workItem.getWorImId(), NoteSupport.NoteGroup.REFERRAL.groupId(), sc.getUserId(), call.getTransferredTo()));
				}
				CaretLocalServiceUtil.save( workItem );
			} else {
				throw new ApplicationWorkFlowException( "NEED GROUP ID" );
			}
			
		} else if ( !CaretStrPool.CALL_STATE_COMPLETE.equals(  call.getCallState() ) ){
			CalEt callEvent = new CalEtImpl();
			callEvent.setCallId(call.getCallId());
			StringBuilder sb = new StringBuilder( call.getCallType() );
			sb.append(CaretStrPool.COLON_SPACE);
			if ( call.isHangUp() ){
				sb.append("Hang-up, ");
			}
			if ( call.isWithoutContact() ){
				sb.append("Without-contact, ");
			}
			if ( call.isWrongNumber() ){
				sb.append("Wrong-number, ");
			}
			callEvent.setComment( sb.substring(0,sb.length()-1) );
			callEvent.setEvent( call.getCallState() );
			callEvent.setCreationDate( sc.getCreateDate() );
			CaretLocalServiceUtil.save(callEvent);
		}
		
		
		saveBoxGroups(request, call.getPrimaryKey());
		_log.info("adding note " + LanguageUtil.get( Locale.getDefault(), message	 ) );
		CaretLocalServiceUtil.addNote( CaretUtil.createNote(sc.getCreateDate(), call.getCallId(), NoteSupport.NoteGroup.CALL_NOTE.groupId(), sc.getUserId(), message) );
		_log.info("call is " + call);
	}
	
	private void saveCall_callbackDate ( ActionRequest request, boolean setCallStatusToCallBack) throws ApplicationWorkFlowException {
		//_log.info("MAction debug....CaretActionCommand.saveCall_callbackDate...start");
		String soc_callbackPref = request.getParameter("soc_callbackPref");
		//_log.info("MAction debug....CaretActionCommand.saveSoc...soc_callbackPref: " + soc_callbackPref);
		if (SocCachedReportUtil.isCallbackPrefEmpty(soc_callbackPref) && !setCallStatusToCallBack) {return;}
		//
		Call call = null;

		getOutput(request);
		Long callId = ParamUtil.getLong(request, "soc_callId");
		 
		//_log.info("MAction debug....CaretActionCommand.saveCall_callbackDate...callId: " + callId);
		ServiceContext sc = CaretParam.setCaretServiceContext(request);
		if ( callId > 0 ){
		try {
		call = CallLocalServiceUtil.getCall(callId);
		} catch (PortalException e) {
		ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
		ApplicationWorkFlowException.handleException(e);
		}
		}
		if ( call == null) {
		call = new CallImpl();
		}
		//////////////////////////////////////////
		String v5_callbackPref = SocCachedReportUtil.getCallbackPref_24HourFormat(soc_callbackPref);
		//_log.info("MAction debug....CaretActionCommand.saveCall...v5_callbackPref: " + v5_callbackPref);
		if (!SocCachedReportUtil.isCallbackPrefEmpty(v5_callbackPref)) {
		call.setCallbackPref(soc_callbackPref);
		 
		}
		if ((!SocCachedReportUtil.isCallbackPrefEmpty(soc_callbackPref)) || setCallStatusToCallBack) {
		call.setCallState("csl-call-back");
		}
		//////////////////////////////////////////
		//TODO: pass list of parameter names 
		CaretParam.loadModel( request, call, call.getModelAttributes().keySet(), "call_");
		//CaretParam.loadModelSingleElement(request, call, "callbackPref", v5_callbackPref, "call_");
		CaretLocalServiceUtil.save(call);
	} 
		
	public void saveSoc ( ActionRequest request ){
		_log.info("saveSoc()");
		String callIdS = ParamUtil.get(request, "callId", StringPool.BLANK);
		List<ClSoc> socList = null;
		//
		long callId = Toolbox.isEmpty(callIdS) ? 0 : Long.parseLong(callIdS);
		try {
			socList = ClSocLocalServiceUtil.findByCallId(callId);
		}
		catch(Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
		boolean isNew = CollectionUtils.isEmpty(socList);
		ClSoc oneSoc = isNew ? null : socList.get(socList.size() - 1);		
		String attemptNum = oneSoc == null ? "1" : ((Integer.parseInt(oneSoc.getAttemptNum())) + 1) + "";
		try {			
			getOutput(request);
			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			String thresholdMet = ParamUtil.get(request, "soc_tresholdMet", StringPool.BLANK);						
			long socId = isNew ? CounterLocalServiceUtil.increment( ClSoc.class.getName()) : oneSoc.getClSocId();
			ClSoc soc = isNew ? ClSocLocalServiceUtil.createClSoc(socId) : oneSoc;
			CaretParam.loadModel_reset(request, soc, soc.getModelAttributes().keySet(), "soc_");
			soc.setClSocId(socId);
			soc.setPrimaryKey(socId);
			soc.setCreationDate(new Date());
			soc.setAttemptNum(attemptNum + "");
			//
			boolean setCallStatusToCallBack = false;
			if(thresholdMet.equals("No")){
				//String followupCallTime = ParamUtil.get(request, "soc_followupCallTime_q14", StringPool.BLANK);
				String followupCall = ParamUtil.get(request, "soc_followupCall_q14", StringPool.BLANK);
				//soc.setFollowupCallTime(followupCallTime);
				soc.setFollowupCall(followupCall);
			}
			else if (thresholdMet.equals("Yes")) {
				if (!soc.getFollowupCall().equals("No")) {
					setCallStatusToCallBack = true;
				}
			}
			ClSocLocalServiceUtil.updateClSoc(soc);
			saveCall_callbackDate(request, setCallStatusToCallBack);		
			//create work item for follow up call			
			if(soc.getFollowupCall() != null && soc.getFollowupCall().equals("Yes")){
				Call call = CallLocalServiceUtil.getCall( Long.parseLong(ParamUtil.get(request, "soc_callId", StringPool.BLANK)) );
				long veteranId = call.getVeteranPersnId();
				Person veteran = new Person ( PersnLocalServiceUtil.getPersn( veteranId ) );
				CaretLocalServiceUtil.save( CaretUtil.createWorkItem( sc, veteran.getGroupId(), soc, WorkType.SOC_FOLLOWUP, veteranId, call.getCallerPersnId() ));
			}
			CaretLocalServiceUtil.addNote( CaretUtil.createNote(sc.getCreateDate(), soc.getCallId(), (Long)sc.getAttribute( CaretStrPool.ROLE_ID ), sc.getUserId(), "Completed SOC Call Attempt - "+soc.getAttemptNum()) );			
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	

	public void saveCesp ( ActionRequest request ){
		_log.info("saveCesp..." );

		try {
			getOutput(request);
			
			ServiceContext sc = CaretParam.setCaretServiceContext(request);

			int numOfCesp = ParamUtil.getInteger(request, "cesp_numOfCesp");
			String cespClosed = ParamUtil.get(request, "cesp_cespClosed", StringPool.BLANK);

			long cespId = CounterLocalServiceUtil.increment( Cesp.class.getName() );
			Cesp cesp = CespLocalServiceUtil.createCesp(cespId);
			CaretParam.loadModel(request, cesp, cesp.getModelAttributes().keySet(), "cesp_");
			
			cesp.setCespId(cespId);
			cesp.setCreationDate(new Date());

			String notification = "";
			if(numOfCesp == 0){
				cesp.setStatus(CaretStrPool.CESP_STATUS_INITIAL);//initial	
				notification = "CESP - Initial - Completed";
			}else if(cespClosed.equals("No")){
				cesp.setStatus(CaretStrPool.CESP_STATUS_COMPLETE);//complete - in step 2								
				notification = "CESP - Completed";
			}else if(cespClosed.equals("Yes")){
				cesp.setStatus(CaretStrPool.CESP_STATUS_CLOSED);//complete - cesp closed										
				notification = "CESP - Closed";
			}

			CespLocalServiceUtil.addCesp(cesp);
			//NOTE: TODO use save() to save cesp
			//CaretLocalServiceUtil.save( cesp );

			
			//create work item for CSC			
			if(null!=cesp.getCespClosedReason() 
				&& (cesp.getCespClosedReason().equals("Goals Reached") || cesp.getCespClosedReason().equals("Participation Discontinued - refer to CSC"))){
				Call call = CallLocalServiceUtil.getCall( Long.parseLong(ParamUtil.get(request, "cesp_callId", StringPool.BLANK)) );
				long veteranId = call.getVeteranPersnId();
				Person veteran = new Person ( PersnLocalServiceUtil.getPersn( veteranId ) );
				CaretLocalServiceUtil.save( CaretUtil.createWorkItem( sc, veteran.getGroupId(), cesp, WorkType.CESP_CSC, veteranId, call.getCallerPersnId() ));
			}

			CaretLocalServiceUtil.addNote( CaretUtil.createNote(sc.getCreateDate(), cesp.getCallId(), (Long)sc.getAttribute( CaretStrPool.ROLE_ID ), sc.getUserId(), notification) );			
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}

	private void saveReferral ( ActionRequest request ) throws ApplicationWorkFlowException{
		Call call = null;
		Person caller = null;
		WorIm workItem = null;

		getOutput(request);
		Long callId = ParamUtil.getLong(request, "call_primaryKey");

		Person veteran = null;
		Long veteranId = ParamUtil.getLong(request, "veteranPersn_primaryKey");
		if ( veteranId > 0 ){
			try {
				veteran = new Person ( PersnLocalServiceUtil.getPersn( veteranId ) );
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		if ( veteran == null ){
			veteran = new Person ( new PersnImpl() );
		}
		
		CaretParam.setCaretServiceContext(request);
		boolean createWorkItem = false;
		if ( callId > 0 ){
			try {
				call = CallLocalServiceUtil.getCall(callId);
				if ( call.getWorkPrimaryKey() > 0 ){
					workItem = WorImLocalServiceUtil.getWorIm( call.getWorkPrimaryKey() );
				} else {
					createWorkItem = true;
					workItem = new WorImImpl();
				}
			} catch (Exception e) {
				throw new ApplicationWorkFlowException(e);
			}
			if ( workItem.getStatus().equals( StringPool.BLANK ) ){
				workItem.setStatus( WorkStatus.NEW.name() );
			}
			
			if ( !workItem.getStatus().equals( WorkStatus.NEW.name() ) ){
				throw new ApplicationWorkFlowException( "WORK ITEM ALREADY STARTED" );
			}
		}
		
		
			
		Long callerId = ParamUtil.getLong(request, "callerPersn_primaryKey");
		if ( callerId > 0 ){
			try {
				caller = new Person ( PersnLocalServiceUtil.getPersn( callerId ) );
			} catch (Exception e) {
				throw new ApplicationWorkFlowException(e);
			}
		}
		if ( caller == null ){
			caller = new Person ( new PersnImpl() );
		}
		
		//TODO: pass list of parameter names
		CaretParam.loadModel(request, caller, caller.getModelAttributes().keySet(), "callerPersn_");
		
		boolean unknown = ParamUtil.getBoolean(request,  "callerPersn_statusLabel");
		if ( unknown ){
			caller.setStatus(CaretStrPool.UNKNOWN_IDENTITY);
			caller.setFirstName(StringPool.BLANK);
			caller.setLastName(StringPool.BLANK);
		} else if ( !Toolbox.isEmpty( caller.getFirstName() ) ){
			caller.setStatus(StringPool.BLANK);
		}
		CaretLocalServiceUtil.save( caller );
		_log.info("caller is " + caller);
		

		//TODO: pass list of parameter names 
		CaretParam.loadModel(request, veteran, veteran.getModelAttributes().keySet(), "veteranPersn_");
		_log.info("veteran is " + veteran);
		if ( veteran.isForeigner() ){
			CaretParam.loadModel( request, veteran, Toolbox.getAddressCollection(), CaretStrPool.VETERAN_PERSN + CaretStrPool.G_UNDERLINE );
		} else {
			CaretParam.loadModel( request, veteran, Toolbox.getAddressCollection(), CaretStrPool.VETERAN_PERSN + CaretStrPool.U_UNDERLINE );
		}
		
		if ( call == null) {
			call = new CallImpl();
		}
		CaretParam.loadModel( request, call, call.getModelAttributes().keySet(), "call_");

		if ( call.isSameAddress() ){
			caller.setAddress( veteran.getAddress() );
			caller.setAddress2( veteran.getAddress2() );
			caller.setZip( veteran.getZip() );
			caller.setState( veteran.getState() );
			caller.setCity( veteran.getCity() );
			caller.setValidAddress( veteran.getValidAddress() );
		}
		CaretLocalServiceUtil.save( veteran );
		
		if ( ! CaretViewController.getViewController().validateRequired(CaretStrPool.CALL, request) ){
			throw new ApplicationWorkFlowException( "VALIDATION" );
		}
		

		ServiceContext sc = CaretParam.setCaretServiceContext( request );
		
		call.setVeteranPersnId( veteran.getPersnId() );
		call.setCallerPersnId( caller.getPersnId() );

		if ( call.getCallId() == 0 || createWorkItem ){
			call.setCallState(CaretStrPool.CALL_STATE_COMPLETE);
			DashboardConfig dashConfig = ( DashboardConfig ) request.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG );
			call.setCreateGroupId( dashConfig.getRoleId() );
			call.setUserId( (Long) sc.getAttribute( CaretStrPool.USER_ID ) );
			CaretLocalServiceUtil.save( call );
			
			WorkType workType;
			if ( dashConfig instanceof CslDashboardConfig ){
				workType = WorkType.CSL_REFERRAL;
			} else {
				try{
					workType = WorkType.valueOf( dashConfig.getRole() + "_REFERRAL");
				} catch(Exception e){
					workType = WorkType.REFERRAL;
				}
			}
			
			workItem = CaretUtil.createWorkItem(sc, veteran.getGroupId(), call, workType, veteran.getPersnId(), call.getCallerPersnId() );
		} else {
			workItem.setGroupId( veteran.getGroupId() );
		}
		CaretLocalServiceUtil.save( workItem );
		workItem = new WorkItemSupport(workItem);
		if ( !Toolbox.isEmpty( call.getMessage() ) ){
			((WorkItemSupport)workItem).useNote("referralNote", CaretUtil.createNote(sc.getCreateDate(), workItem.getWorImId(), NoteSupport.NoteGroup.REFERRAL.groupId(), sc.getUserId(), call.getMessage()));
		}
		CaretLocalServiceUtil.save( workItem );
		
		call.setWorkPrimaryKey( workItem.getPrimaryKey() );
		if ( call.getCallState() != null &&
				call.getCallState().toLowerCase().contains(CaretStrPool.CALL_STATE_COMPLETE)
				&& call.getCompletionDate() == null ){
			call.setCompletionDate(sc.getCreateDate());
		}
		call = (Call)CaretLocalServiceUtil.save( call );
		_log.info("call is" + call);
		
		saveReferralQuestionaire ( call.getCallId(), request );
			
		
		//Supporting Docs attachment code
//		try {		
			String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
			List<Docum> documents = DocumLocalServiceUtil.getByTrackerNote( tracker );
			for ( Docum docum : documents ){
				if ( docum.getClassPk() == 0 ){
					docum.setClassPk( call.getCallId() );
					docum.setClassId( PortalUtil.getClassNameId(Call.class) );
					docum.setNote(StringPool.BLANK);
					try {
						DocumLocalServiceUtil.updateDocum(docum);
					} catch (SystemException e) {
						e.printStackTrace();
					}
				}
			}
			
//			if ( request.getPortletSession().getAttribute(CaretStrPool.FILE_PATH) != null ){
//				for ( Docum document : DocumLocalServiceUtil.getByPrimaryKey( call.getCallId() ) ){
//					DocumLocalServiceUtil.deleteDocument( document );
//				}
//				String path = (String) request.getPortletSession().getAttribute(CaretStrPool.FILE_PATH);
//				String name = (String) request.getPortletSession().getAttribute(CaretStrPool.FILE_NAME);
//				AttachmentBean attachment = new AttachmentBean();
//				attachment.setClassId(PortalUtil.getClassNameId(Call.class));
//				attachment.setClassPk(call.getCallId());
//				attachment.setPath(path);
//				attachment.setName(name);
//				attachment.setType(FileType.REFERRAL_1010.name());
//				handleApplicationDocument( request, attachment);
//				request.getPortletSession().removeAttribute(CaretStrPool.FILE_PATH);
//				request.getPortletSession().removeAttribute(CaretStrPool.FILE_NAME);
//			}
//			if ( request.getPortletSession().getAttribute(CaretStrPool.POA_FILE_PATH) != null ){
//				String path = (String) request.getPortletSession().getAttribute(CaretStrPool.POA_FILE_PATH);
//				String name = (String) request.getPortletSession().getAttribute(CaretStrPool.POA_FILE_NAME);
//				AttachmentBean attachment = new AttachmentBean();
//				attachment.setClassId(PortalUtil.getClassNameId(Call.class));
//				attachment.setClassPk(call.getCallId());
//				attachment.setPath(path);
//				attachment.setName(name);
//				attachment.setType(FileType.REFERRAL_POA.name());
//				handleApplicationDocument( request, attachment);
//				request.getPortletSession().removeAttribute(CaretStrPool.POA_FILE_PATH);
//				request.getPortletSession().removeAttribute(CaretStrPool.POA_FILE_NAME);
//			}
//		} catch (FileNotFoundException e) {
//			ApplicationWorkFlowException.handleException(e);
//		} catch (SystemException e) {
//			ApplicationWorkFlowException.handleException(e);
//		}
		
		
		_log.info("saveReferral..." );
	}
	
	private void saveReferralQuestionaire(long persnId, PortletRequest request) throws ApplicationWorkFlowException {
		
		List<Long> fmChecks = CaretParam.loadSelectedBoxModel(request, CaretStrPool.BOX_GROUP);

		String[] radioNames = new String[]{
				"boxRadioGrp_enrolledVaHealth", "boxRadioGrp_dischargedAfter911", 
				"boxRadioGrp_veteranScCondition", "boxRadioGrp_prescreenPcafc"
		};
		for ( String radio: radioNames ){
			Long radioId = ParamUtil.getLong(request, radio, 0);
			if ( radioId > 0 ){
				fmChecks.add(radioId);
			}
		}
		
		List<Long> updated = new ArrayList<Long>();

		Set<Long> privateSet = new HashSet<Long>();
		for ( BoxGp item: BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.REFERRAL_QUESTIONAIRE_YN) ){
			privateSet.add( item.getBoxGpId() );
		}
		boolean lodQa = CAction.canDoCaret(request, CaretCan.LOD_QA.name() );
		
		List<BgAsn> bgAsnList = BoxGpLocalServiceUtil.getBoxGroupAssociations( persnId );
		
		for ( BgAsn bgAsn: bgAsnList ){
			if ( !lodQa && privateSet.contains( bgAsn.getBoxGpId() ) ){
				fmChecks.remove( bgAsn.getBoxGpId() );
				continue;
			}
			if ( fmChecks.contains( bgAsn.getBoxGpId() ) ){
				if ( !bgAsn.isSelected() ){
					bgAsn.setSelected( true );
					CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
					updated.add( bgAsn.getBoxGpId() );
				}
				fmChecks.remove( bgAsn.getBoxGpId() );
			} else {
				if ( bgAsn.isSelected() ){
					bgAsn.setSelected( false );
					CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
				}
			}
		}
		for ( Long boxGpId: fmChecks){
			if ( ! updated.contains( boxGpId ) ){
				BgAsn bgAsn = new BgAsnImpl();
				bgAsn.setBoxGpId( boxGpId );
				bgAsn.setOwnerId( persnId );
				bgAsn.setSelected( true );
				CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
			}
		}
	}

	
	public void getOutput( PortletRequest request ){
		CaretViewController.getViewController().getOutput(request);
	}
	
	public void writeTiuNote ( ActionRequest request, String noteBody, String noteTitle, VcgSupport vcg, Person.Role caregiverRole, long userId ) throws ApplicationWorkFlowException{
		_log.info("write TIU Note..." );
		try{
			/*boolean exception = false;
			exception = "true".equals( PortletProps.get("tiu.pending") );
			if ( exception ){
				throw new Exception("WriteTIUNote service impl. PENDING");
			}*/
			
			String dispositionChoice = vcg.caregiverDispReason(caregiverRole);
			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			StsService.getEmrSvcInterface(vcg, request);
			TextTO textTO = TiuService.WriteTIUNote(vcg, request,
					getNoteTitle(vcg, dispositionChoice, caregiverRole),
					getNoteBody(vcg, dispositionChoice, caregiverRole, sc),
					vcg.getVeteran().getIcn());
			
			if (textTO == null || textTO.getFault() != null) {
					throw new Exception("WriteTIUNote service impl. PENDING");
			}
			
		} catch ( Exception e ){
			String msg = request.getParameter("msg");
			ApplicationWorkFlowException.handleException(e, msg);
			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			WorkItemSupport work = new WorkItemSupport( CaretUtil.createWorkItem( sc, vcg.getGroupId(), vcg.getPersonVcgAn( vcg.getPerson(caregiverRole).getPersnId() ), WorkType.FAILED_TIU_NOTE, vcg.getVeteranId(), vcg.getPersonId(caregiverRole) ) );
			work.setStatus("research-required");
//			work.setQueId( sc.getUserId() );
			work.setVcgId( vcg.getVcgId() );
			work.setLeaAttr("FAILURE_DESC", "ERR CODE: Exception, ERR DESC: " + e.getMessage() );
			CaretLocalServiceUtil.save( work );
			
			WorSe workItemStep = new WorSeImpl();
			workItemStep.setWorImId( work.getWorImId() );
			workItemStep.setCreationDate( sc.getCreateDate() );
			workItemStep.setUserId( userId == 0? sc.getUserId() : userId );
			int count = WorSeLocalServiceUtil.getCount ( work.getWorImId() );
			workItemStep.setStep( (count < 10? "0":StringPool.BLANK) + count + StringPool.COLON + work.getType() + StringPool.COLON + work.getStatus() );
			workItemStep.setStepNumber(count+1);
			CaretLocalServiceUtil.save( workItemStep );
			
		}
	}

	public void newWorkNote ( ActionRequest request, ActionResponse response ) throws ApplicationWorkFlowException {
		String note = request.getParameter(CaretStrPool.WORK_COMMENT);
		try{
			long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
			WorkItemSupport work = new WorkItemSupport( WorImLocalServiceUtil.getWorIm(worImId) );
			
			ServiceContext sc = CaretParam.setCaretServiceContext(request);

			String applicationStatus = request.getParameter("applicationStatus");
			if ( !Toolbox.isEmpty( applicationStatus ) && ( CaretStrPool.IN_PROCESS.equals( work.getStatus() ) || CaretStrPool.NEW.equals( work.getStatus() ) ) ){
				VcgApplication vcgAn = new VcgApplication ( VcgAnLocalServiceUtil.getVcgAn( work.getClassPk() ) );
				if ( CaretStrPool.IN_PROCESS.equals( applicationStatus ) ){
					applicationStatus = LanguageUtil.get( Locale.getDefault(), "awaiting-va-healthcare-enrollment");
					work.setNote("newWorkNote", applicationStatus + ":" + note, sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.CUSTOM_NOTE.groupId() );
					vcgAn.setStatus( ApplicationStatus.IN_REVIEW.name() );
				} else if ( CAction.canDoCaret( request, CAction.CaretCan.DISPOSITION_VCG.name() ) ) {
					VcgSupport vcgSupport = ( work.getVcgId() == 0? VcgSupport.getVeteranVcg( work.getPersnId() ) : new VcgSupport( VcgLocalServiceUtil.getVcg( work.getVcgId() ) ) );
					if ( CaretStrPool.DUPLICATE.equals(applicationStatus) ){
						vcgAn.setStatus( CaretStrPool.DUPLICATE );
						vcgAn.setStatus( ApplicationStatus.DECISION_MADE.name() );
						if ( vcgSupport.getVcgId() > 0 ){
							vcgSupport.setDuplicateApplication(vcgAn.getVcgAnId(), request.getParameter(CaretStrPool.DISPOSITION_NOTE) );
							CaretLocalServiceUtil.save(vcgSupport);
						}
					} else if ( CaretStrPool.INVALID.equals(applicationStatus) ){
						vcgAn.setStatus( CaretStrPool.INVALID );
						vcgAn.setStatus( ApplicationStatus.DECISION_MADE.name() );
						if ( vcgSupport.getVcgId() > 0 ){
							vcgSupport.setInvalidApplication( work.getClassPk(), note);
							CaretLocalServiceUtil.save(vcgSupport);
						}
					}
					work.setStatus(CaretStrPool.COMPLETE);
					work.setCompletionDate( sc.getCreateDate() );
					work.setCompletionBy( sc.getUserId() );
					work.setNote("newWorkNote", applicationStatus + ":" + note, sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.CUSTOM_NOTE.groupId()  );
					if ( ApplicationStatus.DECISION_MADE.name().equals(vcgAn.getStatus() ) && WorkType.ONLINE_APP.equals( work.getType() ) ) {
						Set<Long> userSet = new HashSet<Long>();
						userSet.add( CaretStrPool.ALL_POS );
						setOnlineNotes(userSet, vcgAn, vcgSupport.getVeteran(), sc);
					}
				}
				CaretLocalServiceUtil.save(vcgAn);
			} else if ( !Toolbox.isEmpty(note) ){
				work.setNote("newWorkNote", note, sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.CUSTOM_NOTE.groupId() );
			}
			
			CaretLocalServiceUtil.save(work);
			checkContext( request, response, work.getVcgId() );
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	
	public void submitTiuNote ( ActionRequest request, ActionResponse response ) throws ApplicationWorkFlowException {
		
		if ( CAction.canDoCaret(request, CAction.CaretCan.PERFORM_TIU_REWRITE) ) try {
			
			long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
			WorkItemSupport work = new WorkItemSupport( WorImLocalServiceUtil.getWorIm(worImId) );
			VcgSupport vcg = new VcgSupport( VcgLocalServiceUtil.getVcg( work.getVcgId() ) );
			Person person = vcg.getPersonRole( work.getCaregiverId() );
			String dispositionChoice = vcg.caregiverDispReason( person.getRole() );
			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			
			writeTiuNote(request, getNoteBody(vcg, dispositionChoice, person.getRole(), sc),
					getNoteTitle(vcg, dispositionChoice, person.getRole()), vcg, person.getRole(), work.getUserId() );
			work.setStatus(WorkStatus.COMPLETE.name());
			work.setCompletionDate( sc.getCreateDate() );
			CaretLocalServiceUtil.save(work);
/*
			String body = request.getParameter(CaretStrPool.WORK_COMMENT);
			String header = request.getParameter("tiu_header");
			
			ServiceFacade.WriteTIUNote(PersnLocalServiceUtil.getPersn( CaretParam.getPersnId(request) ),
					getNoteTitle(vcg, dispositionChoice, person.getRole()),
					getNoteBody(vcg, dispositionChoice, person.getRole(), sc),
					vcg.getVeteran().getIcn());
			
			boolean exception = false;
			exception = "true".equals( PortletProps.get("tiu.pending") );
			//TODO: comment out when ServiceFacade.WriteTIUNote() is completed
			if ( exception ){
				ApplicationWorkFlowException.handleException("Could not not save TIU Note");
				if ( ! Toolbox.isEmpty(header) ){
					work.setNote("errorTiuRewrite", header, sc.getUserId(), sc.getCreateDate() );
				}
//				work.setNote("tiuWriteAttemptBody", body, sc.getUserId(), sc.getCreateDate() );
				CaretLocalServiceUtil.save( work );
			} else {
				work.setStatus(WorkStatus.COMPLETE.name());
				work.setCompletionDate( sc.getCreateDate() );
				CaretLocalServiceUtil.save(work);
			}
		*/	
			
			
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
		
	}
	
	public void saveVcgTier ( ActionRequest request, ActionResponse response ) throws ApplicationWorkFlowException{
		// see saveVcgEntry
		_log.info("saveVcgTier");
	}
	
	public void createVcg( ActionRequest request, ActionResponse response ) throws ApplicationWorkFlowException {
		String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
		if ( ! CaretParam.isTracked( request, tracker, true ) ){
			_log.warn("TRACKER BLOCKING action... ");
			request.setAttribute(CaretStrPool.INVALID_REQUEST, true);
			return;
		}
		if (CAction.canDoCaret(request, CAction.CaretCan.DISPOSITION_VCG.name())) {
			_log.info("createVcg... ");
			getOutput(request);
			long veteranId = ParamUtil.getLong(request, "vcg_veteranId", 0);
			long vcgAnId = ParamUtil.getLong(request, CaretStrPool.VCGANID);
			long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);

			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			String applicationStatus = request.getParameter("applicationStatus");

			VcgApplication vcgAn = null;
			WorIm worIm = null;
			VcgSupport vcgSupport = null;
			Veteran vcgVeteran = null;
			Map<Long,Person> cachedMVI = (Map<Long,Person>) request.getPortletSession().getAttribute(CaretStrPool.CACHED_MVI);
			if ( cachedMVI == null ){
				cachedMVI = new HashMap<>();
			}
			try {
				worIm = WorImLocalServiceUtil.getWorIm(worImId);
				vcgAn = new VcgApplication(VcgAnLocalServiceUtil.getVcgAn(vcgAnId));
				vcgAn.setStatus(applicationStatus);
				if ( cachedMVI.containsKey(veteranId) ){
					Persn person = null;
					if ( !Toolbox.isEmpty( cachedMVI.get(veteranId).getICN() ) ){
						person = PersnLocalServiceUtil.getByIcn( cachedMVI.get(veteranId).getICN() );
					}
					if ( person != null ){
						vcgVeteran = new Veteran ( person );
					} else {
						vcgVeteran = new Veteran( cachedMVI.get(veteranId) );
						CaretLocalServiceUtil.save(vcgVeteran);
					}
					vcgVeteran.setGroupId( vcgAn.getGroupId() );
					veteranId = vcgVeteran.getPrimaryKey();
				}

				if (CaretStrPool.INVALID.equals(applicationStatus)) {
					if (veteranId > 0) {
						vcgVeteran = new Veteran(PersnLocalServiceUtil.getPersn(veteranId));
						vcgVeteran.setStatus(CaretStrPool.ACTIVE_VCG);
						
						vcgSupport = VcgSupport.getVeteranVcg(veteranId);
						vcgSupport.setGroupId(vcgVeteran.getGroupId());
						String noteStr = request.getParameter(CaretStrPool.DISPOSITION_NOTE);
						vcgSupport.setInvalidApplication(vcgAnId, noteStr);

						CaretLocalServiceUtil.save(vcgVeteran);
						Note note = CaretLocalServiceUtil.addNote(CaretUtil.createNote(sc.getCreateDate(), vcgSupport.getVcgId(),
								NoteSupport.NoteGroup.CORRECTIVE_RESPONSE.groupId(), sc.getUserId(), noteStr));
						vcgSupport.useNote("Invalid", note);
						CaretLocalServiceUtil.save(vcgSupport);
						vcgAn.setVcgId(vcgSupport.getVcgId());
						
						worIm.setVcgId(vcgSupport.getVcgId());
					}
					vcgAn.setInvalidPerson(1, request.getParameter(CaretStrPool.DISPOSITION_NOTE) );
					vcgAn.setStatus(applicationStatus);
					CaretLocalServiceUtil.save(vcgAn);

					worIm.setStatus(WorkStatus.COMPLETE.name());
					worIm.setCompletionDate( sc.getCreateDate() );
					worIm.setCompletionBy( sc.getUserId() );
					CaretLocalServiceUtil.save(worIm);
					
					//Note for Online users
//					_log.info("adding note " + LanguageUtil.get( Locale.getDefault(), CaretStrPool.DISPOSITIONED_ONLINE_MESSAGE) );
					if ( worIm.getType().equals( WorkType.ONLINE_APP.name() ) ){
						CaretLocalServiceUtil.addNote(CaretUtil.createNote(sc.getCreateDate(), vcgAn.getVcgAnId(),
								NoteSupport.NoteGroup.CORRECTIVE_RESPONSE.groupId(), vcgAn.getVeteranId(), LanguageUtil.get( Locale.getDefault(), CaretStrPool.DISPOSITIONED_ONLINE_MESSAGE) ) );
					}
					return;
				} else if (veteranId == 0) {
					ApplicationWorkFlowException.handleException("VCG requires VeteranId");
					return;
				} 

				vcgVeteran = new Veteran(PersnLocalServiceUtil.getPersn(veteranId));
				String oldVeteranAddress = new StringBuilder(vcgVeteran.getAddress()).append(StringPool.COMMA_AND_SPACE).append(vcgVeteran.getCity()).append(StringPool.SPACE).append(vcgVeteran.getState()).append(StringPool.SPACE).append(vcgVeteran.getZip()).toString();
				String oldZip = vcgVeteran.getZip();
				vcgVeteran.setStatus(CaretStrPool.ACTIVE_VCG);
				vcgSupport = VcgSupport.getVeteranVcg(veteranId);
				boolean isNewVcg = vcgSupport.getVcgId() > 0;
				// groupId defect...
//				_log.info( "************************************");
//				_log.info( "************************************");
				_log.info( "VCG=Veteran=Application... groupId=" + vcgAn.getGroupId() );
//				_log.info( "************************************");
//				_log.info( "************************************");
				vcgSupport.setGroupId(vcgAn.getGroupId());
				vcgVeteran.setGroupId(vcgAn.getGroupId());

//				String comment = StringPool.BLANK;

				Map<Person,boolean[]> changeMap = new HashMap<Person,boolean[]>();
				List<String> errors = new ArrayList<String>();
				
				int invalids = 0;
				int caregivers = 0;
				int count = 0;
				Set<Long> userSet = new HashSet<Long>();
				
				if (CaretStrPool.DUPLICATE.equals(applicationStatus)) {
					worIm.setStatus( WorkStatus.COMPLETE.name() );
					worIm.setCompletionDate( sc.getCreateDate() );
					worIm.setCompletionBy( sc.getUserId() );
					vcgAn.setStatus( CaretStrPool.DUPLICATE );
					vcgSupport.setDuplicateApplication(vcgAn.getVcgAnId(), request.getParameter(CaretStrPool.DISPOSITION_NOTE) );
					
					userSet.add(CaretStrPool.ALL_POS);
				} else {
					worIm.setStatus(WorkStatus.IN_PROCESS.name());

					long primaryId = ParamUtil.getLong(request, "vcg_primaryId", 0);
					long secondaryId = ParamUtil.getLong(request, "vcg_secondaryId", 0);
					long secondaryTwoId = ParamUtil.getLong(request, "vcg_secondaryTwoId", 0);

					Person vcgPrimary = null, vcgSecondary = null, vcgSecondaryTwo = null;

					if (vcgAn.getVeteranId() != veteranId) {
						boolean[] changes = new boolean[Person.Changes.values().length];
						Persn merged = PersnLocalServiceUtil.getPersn(vcgAn.getVeteranId());
						errors.addAll( CaretViewController.getViewController().setVcgPerson(request, new Veteran(merged), vcgVeteran, changes) );

						if ( errors.isEmpty() ){
							merged.setStatus(CaretStrPool.REVISION_MERGED);
							CaretLocalServiceUtil.save(merged);
						}
						if ( vcgSupport != null && ( vcgSupport.isPrimaryApproved() ) && changes[Person.Changes.ADDRESS_CHANGE.ordinal()]  ){
							changeMap.put(vcgVeteran, changes);
						}
					}
					vcgAn.setVeteranId( veteranId );
					//init VCG 
					CaretLocalServiceUtil.save(vcgSupport);
					
					if (vcgAn.getPrimaryId() > 0) {
						Primary appPrimary = new Primary(PersnLocalServiceUtil.getPersn(vcgAn.getPrimaryId()));
						String primaryStatus = ParamUtil.get(request, "primaryStatus", StringPool.BLANK);
						caregivers++;
						if (CaretStrPool.INVALID.equals(primaryStatus)) { //Decision Made
							vcgAn.setInvalidPerson(vcgAn.getPrimaryId(), ParamUtil.get(request, "primaryNote", "Missing INVALID-App reason"));
							
							invalids++;
							if ( appPrimary.getRootUserId() > 0 ){
								userSet.add( appPrimary.getRootUserId() ); //Decision Made
							}
						} else if (primaryId > 0) {
							
							if ( cachedMVI.containsKey( primaryId ) ){
								Persn person = null;
								if ( !Toolbox.isEmpty( cachedMVI.get( primaryId ).getICN() ) ){
									person = PersnLocalServiceUtil.getByIcn( cachedMVI.get( primaryId ).getICN() );
								}
								if ( person != null ){
									vcgPrimary = new Primary ( person );
								} else {
									vcgPrimary = new Primary( cachedMVI.get( primaryId ) );
									CaretLocalServiceUtil.save( vcgPrimary );
								}
								primaryId = vcgPrimary.getPrimaryKey();
							} else {
								vcgPrimary = new Primary(PersnLocalServiceUtil.getPersn(primaryId));
							}
							
							if (CaretStrPool.IN_PROCESS.equals(primaryStatus)) {
								if ( veteranId == vcgPrimary.getPersnId() || vcgSupport.getPrimaryDispReason() != null && VcgSupport.isActive( vcgSupport.getPrimaryDispReason() ) ) {
									throw new ApplicationWorkFlowException("VCG - Primary Slot already reserved!");
								} else if (vcgAn.getPrimaryId() != primaryId) {
									boolean[] changes = new boolean[Person.Changes.values().length];
									CaretViewController.getViewController().setVcgPerson(request, appPrimary, vcgPrimary, changes);
									
									if ( isVendorCandidate(vcgPrimary, vcgSupport.getVcgId() ) ){
										changeMap.put(vcgPrimary, changes);
									} else if ( ArrayUtil.contains(changes, true) ){
										CaretLocalServiceUtil.save( vcgPrimary );
									}
									
								}
								vcgPrimary.setStatus(CaretStrPool.ACTIVE_VCG);
								vcgSupport.setNewPrimary( primaryId, vcgAn.getPrimaryRelationship(), vcgAnId );
								count++;
							}
						}
					}
					if (vcgAn.getSecondaryId() > 0) {
						Secondary appSecondary = new Secondary(PersnLocalServiceUtil.getPersn(vcgAn.getSecondaryId()));
						String secondaryStatus = ParamUtil.get(request, "secondaryStatus", StringPool.BLANK);
						caregivers++;
						if (CaretStrPool.INVALID.equals(secondaryStatus)) {
							vcgAn.setInvalidPerson(vcgAn.getSecondaryId(),
									ParamUtil.get(request, "secondaryNote", "Missing INVALID-App reason"));
							invalids++;
							userSet.add( appSecondary.getRootUserId() );
						} else if (secondaryId > 0) {
							
							if ( cachedMVI.containsKey( secondaryId ) ){
								Persn person = null;
								if ( !Toolbox.isEmpty( cachedMVI.get( secondaryId ).getICN() ) ){
									person = PersnLocalServiceUtil.getByIcn( cachedMVI.get( secondaryId ).getICN() );
								}
								if ( person != null ){
									vcgSecondary = new Secondary ( person );
								} else {
									vcgSecondary = new Secondary( cachedMVI.get( secondaryId ) );
									CaretLocalServiceUtil.save( vcgSecondary );
								}
								secondaryId = vcgSecondary.getPrimaryKey();
							} else {
								vcgSecondary = new Secondary(PersnLocalServiceUtil.getPersn(secondaryId));
							}
							
							if (CaretStrPool.IN_PROCESS.equals(secondaryStatus)) {
								if ( veteranId == vcgSecondary.getPersnId() || vcgSupport.getSecondaryDispReason() != null && VcgSupport.isActive( vcgSupport.getSecondaryDispReason() ) ) {
									throw new ApplicationWorkFlowException("VCG - Secondary Slot already reserved!");
								} else if (vcgAn.getSecondaryId() != secondaryId) {
									boolean[] changes = new boolean[Person.Changes.values().length];
									CaretViewController.getViewController().setVcgPerson(request, appSecondary,
											vcgSecondary, changes);
									if ( isVendorCandidate( vcgSecondary, vcgSupport.getVcgId() ) ){
										changeMap.put(vcgSecondary, changes);
									} else if ( ArrayUtil.contains(changes, true) ){
										CaretLocalServiceUtil.save( vcgSecondary );
									}
								}
								vcgSecondary.setStatus(CaretStrPool.ACTIVE_VCG);
								vcgSupport.setNewSecondary( secondaryId, vcgAn.getSecondaryRelationship(), vcgAnId );
								count++;
							}
						}
					}
					if (vcgAn.getSecondaryTwoId() > 0) {
						SecondaryTwo appSecondaryTwo = new SecondaryTwo(PersnLocalServiceUtil.getPersn(vcgAn.getSecondaryTwoId()));
						String secondaryTwoStatus = ParamUtil.get(request, "secondaryTwoStatus", StringPool.BLANK);
						caregivers++;
						
						if (CaretStrPool.INVALID.equals(secondaryTwoStatus)) {
							vcgAn.setInvalidPerson(vcgAn.getSecondaryTwoId(),
									ParamUtil.get(request, "secondaryTwoNote", "Missing INVALID-App reason"));
							invalids++;
							userSet.add( appSecondaryTwo.getRootUserId() );
						} else if (secondaryTwoId > 0) {
							
							if ( cachedMVI.containsKey( secondaryTwoId ) ){
								Persn person = null;
								if ( !Toolbox.isEmpty( cachedMVI.get( secondaryTwoId ).getICN() ) ){
									person = PersnLocalServiceUtil.getByIcn( cachedMVI.get( secondaryTwoId ).getICN() );
								}
								if ( person != null ){
									vcgSecondaryTwo = new SecondaryTwo ( person );
								} else {
									vcgSecondaryTwo = new SecondaryTwo( cachedMVI.get( secondaryTwoId ) );
									CaretLocalServiceUtil.save( vcgSecondaryTwo );
								}
								secondaryTwoId = vcgSecondaryTwo.getPrimaryKey();
							} else {
								vcgSecondaryTwo = new SecondaryTwo(PersnLocalServiceUtil.getPersn(secondaryTwoId));
							}
							if (CaretStrPool.IN_PROCESS.equals(secondaryTwoStatus)) {
								if ( veteranId == vcgSecondaryTwo.getPersnId() || vcgSupport.getSecondaryTwoDispReason() != null && VcgSupport.isActive( vcgSupport.getSecondaryTwoDispReason() ) ) {
									throw new ApplicationWorkFlowException("VCG - Secondary II Slot already reserved!");
								} else if (vcgAn.getSecondaryTwoId() != secondaryTwoId) {
									boolean[] changes = new boolean[Person.Changes.values().length];
									CaretViewController.getViewController().setVcgPerson(request, appSecondaryTwo,
											vcgSecondaryTwo, changes);
									if ( isVendorCandidate( vcgSecondaryTwo, vcgSupport.getVcgId() ) ){
										changeMap.put(vcgSecondaryTwo, changes);
									} else if ( ArrayUtil.contains(changes, true) ){
										CaretLocalServiceUtil.save( vcgSecondaryTwo );
									}
								}
								vcgSecondaryTwo.setStatus(CaretStrPool.ACTIVE_VCG);
								vcgSupport.setNewSecondaryTwo( secondaryTwoId, vcgAn.getSecondaryTwoRelationship(), vcgAnId );
								count++;
							}
						}
					}
				}
				setOnlineNotes(userSet, vcgAn, vcgVeteran, sc);
				
				CaretLocalServiceUtil.save(vcgSupport);
				CaretLocalServiceUtil.save(vcgVeteran);
				
				if ( invalids == caregivers || count == 0 ){
					worIm.setStatus(WorkStatus.COMPLETE.name());
					vcgAn.setStatus( ApplicationStatus.DECISION_MADE.name() );
				} else {
					vcgAn.setStatus( ApplicationStatus.IN_REVIEW.name() );
				}
				vcgAn.setVcgId( vcgSupport.getVcgId() );
				CaretLocalServiceUtil.save(vcgAn);

				worIm.setVcgId( vcgSupport.getVcgId() );
				CaretLocalServiceUtil.save(worIm);
				
				String comment = isNewVcg?
						"Updated VCG record with " + count + " new Caregiver selection(s)"
						: "Created new VCG record with " + count + " Caregiver selection(s)";
				CaretLocalServiceUtil.addNote(CaretUtil.createNote(sc.getCreateDate(), vcgSupport.getVcgId(),
						NoteSupport.NoteGroup.CREATE_VCG.groupId(), sc.getUserId(), comment));
				
				for ( Person person: changeMap.keySet() ){
					if ( person.isVeteranRole() ){
						if ( changeMap.get(person)[Person.Changes.ADDRESS_CHANGE.ordinal()] ){
							WorIm workItem = CaretUtil.createWorkItem(sc, vcgSupport.getGroupId(), vcgAn, WorkType.ADDRESS_CHANGE, 
									person.getPersnId(), vcgSupport.getPrimaryId() );
//							workItem.setQueId( sc.getUserId() );
							workItem.setStatus(CaretStrPool.ADDRESS_CHANGE_REVIEW_PENDING);
							workItem.setQueueId( OwnerQueue.VCG_INFO_MOD_Q.queueId );
							workItem.setVcgId(vcgSupport.getVcgId());
							CaretLocalServiceUtil.save( workItem );
							
							String newAddress = new StringBuilder(person.getAddress()).append(StringPool.COMMA_AND_SPACE).append(person.getCity()).append(StringPool.SPACE).append(person.getState()).append(StringPool.SPACE).append(person.getZip()).toString();
							
							BlsRe newRate = BlsReLocalServiceUtil.findLatestBlsByZip( person.getZip() );
							BlsRe oldRate = BlsReLocalServiceUtil.findLatestBlsByZip( oldZip );
							if ( newRate == null || oldRate == null ) {
								_log.error("BLS Rate no longer found for the selected address");
							} else if ( newRate.getH75() != oldRate.getH75() ) {
								StipendConfig config = new StipendConfig( new StiPtImpl() );
								config.setFields(sc.getCreateDate(), vcgSupport, new WorkItemSupport( workItem ), sc, oldVeteranAddress, newAddress );
								Vendr vendor = VendrLocalServiceUtil.findByPersnId( vcgSupport.getPrimaryId() );
								if ( vendor != null ){
									config.setVendrId( vendor.getVendrId() ) ;
								}
								CaretLocalServiceUtil.save(config);
							}
						} else {
							CaretViewController.getViewController().applyWorkItem( request, changeMap.get(person), person, vcgSupport, person.getRole() );
						}
					} else {
						CaretViewController.getViewController().applyWorkItem( request, changeMap.get(person), person, vcgSupport, person.getRole() );
						CaretLocalServiceUtil.save(person);
					}
				}
				
				if ( CAction.canDoCaret(request, CAction.CaretCan.MANAGE_VCG.name()) ) {
					request.setAttribute( CaretStrPool.VCGID, vcgSupport.getVcgId() );
					loadVcgManagement(request, response);
					response.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.VCG_MANAGEMENT_PAGE);
				}
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
	}

	private boolean isVendorCandidate (Person vcgPrimary, long excludeVcgId ) throws ApplicationWorkFlowException {
		return VendrLocalServiceUtil.findByPersnId( vcgPrimary.getPersnUserId() ) != null;
	}


	private void setOnlineNotes( Set<Long> userSet, VcgApplication vcgAn, Veteran vcgVeteran, ServiceContext sc ) throws ApplicationWorkFlowException, PortalException, SystemException {
		if ( userSet.contains( CaretStrPool.ALL_POS ) ){
			userSet.remove( CaretStrPool.ALL_POS );
			if ( vcgAn.getPrimaryId() > 0 ){
				userSet.add(new Primary(PersnLocalServiceUtil.getPersn(vcgAn.getPrimaryId())).getRootUserId());
			}
			if ( vcgAn.getSecondaryId() > 0 ){
				userSet.add(new Secondary(PersnLocalServiceUtil.getPersn(vcgAn.getSecondaryId())).getRootUserId());
			}
			if ( vcgAn.getSecondaryTwoId() > 0 ){
				userSet.add(new SecondaryTwo(PersnLocalServiceUtil.getPersn(vcgAn.getSecondaryTwoId())).getRootUserId());
			}
		}
		String onlineMessage = LanguageUtil.get( Locale.getDefault(), CaretStrPool.DISPOSITIONED_ONLINE_MESSAGE) ;
		if ( !userSet.isEmpty() ){
			userSet.add(vcgVeteran.getRootUserId());
		}
		for ( Long id : userSet ){
			CaretLocalServiceUtil.addNote(CaretUtil.createNote(sc.getCreateDate(), vcgAn.getVcgAnId(), NoteSupport.NoteGroup.DISPOSITION.groupId(), id, onlineMessage ) );
		}
	}


	public void saveVcgDisposition ( ActionRequest request, VcgSupport vcg, Person person ) throws ApplicationWorkFlowException{
			String ndx = request.getParameter("vcg_ndx") + StringPool.UNDERLINE;
			Date dispositionDate = Toolbox.parseDate(request.getParameter(ndx + "dispositionDate"));
			String dispositionChoice = request.getParameter(ndx + "dispositionChoice");
			String dispositionReason = Toolbox.nullSafe( request.getParameter(ndx + "dispositionReason") );
			
			String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
						
//			String oldDispositionState = null;
			long vcgAnId = 0;
			int[] extensionDays = new int[1];
			ServiceContext sc = CaretParam.setCaretServiceContext( request );
			String outComeAppeal = StringPool.BLANK;
			Set<Long> userIds = new HashSet<Long>();
//			VcgApplication vcgApp = null;
			
			if ( person.getRole() == Person.Role.PRIMARY && !vcg.getPrimaryDispReason().equals( dispositionChoice )){
//				oldDispositionState = vcg.getPrimaryDispReason();
				vcg.setPrimaryDispReason( extDays(dispositionChoice, extensionDays) + dispositionReason  );
				userIds.add( vcg.getPrimary().getRootUserId() ); 
				vcgAnId = vcg.getPrimaryVcgAnId();
				

				StipendConfig config = new StipendConfig ( new StiPtImpl() );
				Vendr vendor = VendrLocalServiceUtil.findByPersnId( vcg.getPrimaryId() );
				if ( vendor != null ){
					config.setVendrId( vendor.getVendrId() );
				}

				if ( vcg.isPrimaryRevoked() ){
					vcg.setPrimaryRevocationDate(dispositionDate);
					extDays(dispositionReason, extensionDays);
					config.setEntitledDays( extensionDays[0] );
				} else {
					if ( vcg.isTierEditEnabled() ){
						Date tierEffectiveDate = Toolbox.parseDate(request.getParameter(ndx + "tierEffectiveDate"));
						vcg.setTierEffectiveDate(tierEffectiveDate );
						String tierLevelStr = request.getParameter( ndx + "tier");
						if ( !"appeal-tier".equals(tierLevelStr) ) {
							int tierLevel = Integer.valueOf(tierLevelStr);
							vcg.setTierLevel( tierLevel );
						}

						if ( ( vcg.isDisapproved(dispositionChoice) || vcg.isApproved(dispositionChoice) ) && vcg.getPrimaryInitDispDate() == null ){
							if ( VcgSupport.WaiverCode.APPROVED.name().equals( vcg.getPrimaryWaiverCode() ) || 
									VcgSupport.WaiverCode.DENIED.name().equals( vcg.getPrimaryWaiverCode() ) ){
								closeDelayWork ( request, person, sc, vcg );
							} else if ( vcg.isWaiverPrimary() ) {
								saveCscWaiver( request, person, sc, ndx, vcg.getPrimaryVcgAnId(), CaretStrPool.ACCEPTED );
							} 
						}
						
					}
					vcg.setPrimaryDispositionDate(dispositionDate, sc.getCreateDate());
				}

				if ( dispositionChoice.endsWith("-veteran-") ){
					outComeAppeal = dispositionChoice.substring(0, dispositionChoice.indexOf("-veteran-") + 1);
					CaretLocalServiceUtil.save(vcg);
					if ( dispositionChoice.contains("revoked") ){
						dispositionChoice = CaretStrPool.REINSTATED;
					} else {
						dispositionChoice = CaretStrPool.IN_PROCESS;
					}
					vcg.setPrimaryDispReason( dispositionChoice );
				}

				WorkType cbopcWork = vcg.getDispositionWork(dispositionChoice);
				
				if ( cbopcWork  != null ){
					WorIm workItem = CaretUtil.createWorkItem(sc, vcg.getGroupId(), vcg.getPrimaryVcgAn(), cbopcWork, vcg.getVeteranId(), person.getPersnId() );
					workItem.setVcgId( vcg.getVcgId() );
					if ( cbopcWork == WorkType.APPROVED_DISPOSITION ) {
						workItem.setStatus( QueAction.TRIAGE_PENDING.name() );
					} else if ( cbopcWork == WorkType.REINSTATED_DISPOSITION )  {
						workItem.setStatus( QueAction.REINSTATE_PENDING.name() );
					} else if ( cbopcWork == WorkType.REVOKED_DISPOSITION )  {
						workItem.setStatus( CaretStrPool.REVOKE_PENDING );
					} else {
						workItem.setStatus( CaretStrPool.PENDING );
					}
//					workItem.setQueId( sc.getUserId() );
					workItem.setQueueId( cbopcWork.workName.getQueueId() );
					CaretLocalServiceUtil.save(workItem);
					if ( cbopcWork == WorkType.REINSTATED_DISPOSITION ){
						config.setFields( vcg.getTierEffectiveDate(), vcg, new WorkItemSupport( workItem ), sc, String.valueOf(vcg.getTierLevelPreviously()), String.valueOf(vcg.getTierLevel()) );
					} else {
						config.setFields( vcg.getTierEffectiveDate(), vcg, new WorkItemSupport( workItem ), sc, StringPool.BLANK, StringPool.BLANK  );
					}
					CaretLocalServiceUtil.save( config );

				}
				
				boolean deactivateAgain = true;
				if ( dispositionChoice.endsWith("-va-") ){
					outComeAppeal = dispositionChoice.substring(0, dispositionChoice.indexOf("-va-") +1 );
					deactivateAgain = false;
					CaretLocalServiceUtil.save(vcg);
					if ( dispositionChoice.contains("revoked") ){
						for ( gov.va.caret.model.AudLg lg : CaretLocalServiceUtil.findByClassPk(vcg.getVcgId(), "primaryDispReason") ){
							if ( lg.getNewValue().toLowerCase().startsWith("revoke") ){
								dispositionChoice = lg.getNewValue();
								break;
							}
						}
					} else {
						dispositionChoice = CaretStrPool.DISAPPROVED;
					}
					vcg.setPrimaryDispReason( dispositionChoice );
				}

				long workUserId = updateActiveWork(vcgAnId, vcg, userIds, sc);
				
				if ( vcg.isRevoked( dispositionChoice ) || vcg.isApproved(dispositionChoice) || vcg.isReinstated(dispositionChoice) || vcg.isAppealed(dispositionChoice) ){
					if ( CaretUtil.isTiuEnabled() ) {
						writeTiuNote(request, getNoteBody(vcg, dispositionChoice, person.getRole(), sc), getNoteTitle(vcg, dispositionChoice, person.getRole()), vcg, person.getRole(), workUserId);
					}
				}
				
				//**** Periodic Assessments
				//if disp == approved -> create 4 periodic assessments scheduled 90 days apart
				if(vcg.isApproved(dispositionChoice)){
					saveFirstPeriodicAssessments(request, vcg, person, dispositionDate);				
				}
				//if primary was revoked; inactivate all periodic assessments
				if(vcg.isRevoked(dispositionChoice) && deactivateAgain){
					_log.info("primary status changed from approved...inactivating periodic assmts...");
					inactivateAssessments(vcg.getVcgId(), vcg.getPrimaryId(), CaretStrPool.ASSMT_PERIODIC);
				}
				
				//if primary was reinstated; activate all periodic assessments
				if(vcg.isReinstated(dispositionChoice)){
					_log.info("primary status changed to reinstated...activating periodic assmts...");
					activateAssessments(vcg.getVcgId(), vcg.getPrimaryId(), CaretStrPool.ASSMT_PERIODIC);
				}
				
			} else if ( person.getRole() == Person.Role.SECONDARY && !vcg.getSecondaryDispReason().equals( dispositionChoice ) ){
//				oldDispositionState = vcg.getSecondaryDispReason();
				vcg.setSecondaryDispReason( extDays(dispositionChoice, extensionDays) + dispositionReason  );
				vcgAnId = vcg.getSecondaryVcgAnId();
				userIds.add( vcg.getSecondary().getRootUserId() );
				if ( vcg.isRevoked( vcg.getSecondaryDispReason() ) ){
					vcg.setSecondaryRevocationDate(dispositionDate);
				} else {
					if ( ( vcg.isDisapproved(dispositionChoice) || vcg.isApproved(dispositionChoice) )  && vcg.getSecondaryInitDispDate()== null ){
						if ( VcgSupport.WaiverCode.APPROVED.name().equals( vcg.getSecondaryWaiverCode() ) || 
								VcgSupport.WaiverCode.DENIED.name().equals( vcg.getSecondaryWaiverCode() ) ){
							closeDelayWork ( request, person, sc, vcg );
						} else if ( vcg.isWaiverSecondary() ) {
							saveCscWaiver( request, person, sc, ndx, vcg.getSecondaryVcgAnId(), CaretStrPool.ACCEPTED);
						}
					}
					vcg.setSecondaryDispositionDate(dispositionDate, sc.getCreateDate());
				}
				if ( dispositionChoice.endsWith("-veteran-") ){
					outComeAppeal = dispositionChoice.substring(0, dispositionChoice.indexOf("-veteran-") + 1);
					CaretLocalServiceUtil.save(vcg);
					if ( dispositionChoice.contains("revoked") ){
						dispositionChoice = CaretStrPool.REINSTATED;
					} else {
						dispositionChoice = CaretStrPool.IN_PROCESS;
					}
					vcg.setSecondaryDispReason( dispositionChoice );
				} else if ( dispositionChoice.endsWith("-va-") ){
					outComeAppeal = dispositionChoice.substring(0, dispositionChoice.indexOf("-va-") +1 );
					CaretLocalServiceUtil.save(vcg);
					if ( dispositionChoice.contains("revoked") ){
						for ( gov.va.caret.model.AudLg lg : CaretLocalServiceUtil.findByClassPk(vcg.getVcgId(), "secondaryDispReason") ){
							if ( lg.getNewValue().toLowerCase().startsWith("revoke") ){
								dispositionChoice = lg.getNewValue();
								break;
							}
						}
					} else {
						dispositionChoice = CaretStrPool.DISAPPROVED;
					}
					vcg.setSecondaryDispReason( dispositionChoice );
				}
				long workUserId = updateActiveWork(vcgAnId, vcg, userIds, sc);
				
				if ( vcg.isRevoked( dispositionChoice ) || vcg.isApproved(dispositionChoice) || vcg.isReinstated(dispositionChoice) || vcg.isAppealed(dispositionChoice) ){
					writeTiuNote(request, getNoteBody(vcg, dispositionChoice, person.getRole(), sc), getNoteTitle(vcg, dispositionChoice, person.getRole()), vcg, person.getRole(), workUserId);
				}
			} else if ( person.getRole() == Person.Role.SECONDARYTWO && !vcg.getSecondaryTwoDispReason().equals( dispositionChoice )  ){
//				oldDispositionState = vcg.getSecondaryTwoDispReason();
				vcg.setSecondaryTwoDispReason( extDays(dispositionChoice, extensionDays)  + dispositionReason );
				vcgAnId = vcg.getSecondaryTwoVcgAnId();
				userIds.add( vcg.getSecondaryTwo().getRootUserId() );
				if ( vcg.isRevoked( vcg.getSecondaryTwoDispReason() ) ){
					vcg.setSecondaryTwoRevocationDate(dispositionDate);
				} else {
					if ( ( vcg.isDisapproved(dispositionChoice) || vcg.isApproved(dispositionChoice) ) && vcg.getSecondaryInitDispDate() == null ){
						if ( VcgSupport.WaiverCode.APPROVED.name().equals( vcg.getSecondaryTwoWaiverCode() ) || 
								VcgSupport.WaiverCode.DENIED.name().equals( vcg.getSecondaryTwoWaiverCode() ) ){
							closeDelayWork ( request, person, sc, vcg );
						} else if ( VcgSupport.WaiverCode.CSC_NEEDED.name().equals( vcg.getSecondaryTwoWaiverCode() ) ){
							saveCscWaiver( request, person, sc, ndx, vcg.getSecondaryTwoVcgAnId(), CaretStrPool.ACCEPTED);
						}
					}
					vcg.setSecondaryTwoDispositionDate(dispositionDate, sc.getCreateDate());
				}
				if ( dispositionChoice.endsWith("-veteran-") ){
					outComeAppeal = dispositionChoice.substring(0, dispositionChoice.indexOf("-veteran-") + 1);
					CaretLocalServiceUtil.save(vcg);
					if ( dispositionChoice.contains("revoked") ){
						dispositionChoice = CaretStrPool.REINSTATED;
					} else {
						dispositionChoice = CaretStrPool.IN_PROCESS;
					}
					vcg.setSecondaryTwoDispReason( dispositionChoice );
				} else if ( dispositionChoice.endsWith("-va-") ){
					outComeAppeal = dispositionChoice.substring(0, dispositionChoice.indexOf("-va-") +1 );
					CaretLocalServiceUtil.save(vcg);
					if ( dispositionChoice.contains("revoked") ){
						for ( gov.va.caret.model.AudLg lg : CaretLocalServiceUtil.findByClassPk(vcg.getVcgId(), "secondaryTwoDispReason") ){
							if ( lg.getNewValue().toLowerCase().startsWith("revoke") ){
								dispositionChoice = lg.getNewValue();
								break;
							}
						}
					} else {
						dispositionChoice = CaretStrPool.DISAPPROVED;
					}
					vcg.setSecondaryTwoDispReason( dispositionChoice );
				}
				if ( extensionDays[0] > 0 ){
					_log.info("Benefits extended " + extensionDays[0] + " days from revocation date");
				}
				long workUserId = updateActiveWork(vcgAnId, vcg, userIds, sc);
				
				if ( vcg.isRevoked( dispositionChoice ) || vcg.isApproved(dispositionChoice) || vcg.isReinstated(dispositionChoice) || vcg.isAppealed(dispositionChoice) ){
					writeTiuNote(request, getNoteBody(vcg, dispositionChoice, person.getRole(), sc), getNoteTitle(vcg, dispositionChoice, person.getRole()), vcg, person.getRole(), workUserId);
				}
			} else if ( person.getRole() == Person.Role.GENERAL && !vcg.getGeneralDispReason().equals( dispositionChoice )  ){ // General Caregiver
				_log.info( "General Caregiver... update profile..." );
//				generalUpdate = true;
 
				vcg.setGeneralDispReason( extDays(dispositionChoice, extensionDays)  + dispositionReason  );
//				oldDispositionState = vcg.getGeneralDispReason();
				if ( vcg.isRevoked( vcg.getGeneralDispReason() ) ){
					vcg.setGeneralRevocationDate(dispositionDate);
				} else {
					vcg.setGeneralDispositionDate(dispositionDate);
				}
			} else {
				_log.error("Invalid state: " + person + " with role " + person.getRole() );
			}
			
			if ( vcgAnId > 0 && ( vcg.isAppealed(dispositionChoice) || !Toolbox.isEmpty(outComeAppeal) )  ){
				try {
					Apeal appeal;
					if ( !Toolbox.isEmpty(outComeAppeal) ){
						appeal = ApealLocalServiceUtil.getByOwner(vcgAnId, person.getPersnId(), outComeAppeal);
						String adjudication = LanguageUtil.get( Locale.getDefault(), dispositionChoice ) + ":" + request.getParameter(ndx + "note");
						appeal.setAdjudication( adjudication.substring(0, Math.min( adjudication.length(), 75 ) ) );
						appeal.setCompletionDate(dispositionDate);
//						appeal.setContact(contact);
					} else {
						appeal = new ApealImpl();
						appeal.setClassPk( vcgAnId );
						appeal.setOwnerId( person.getPersnId() );
						appeal.setReason(dispositionChoice);
						appeal.setCreationDate(sc.getCreateDate());
						String note = request.getParameter(ndx + "note");
						appeal.setNote( note.substring(0, Math.min( note.length(), 75 ) ) );
					}
					CaretLocalServiceUtil.save( appeal );
					
					List<Docum> documents = DocumLocalServiceUtil.getByTrackerNote( tracker );
					for ( Docum docum : documents ){
						if ( docum.getClassPk() == 0 ){
							docum.setClassPk(appeal.getApealId());
							docum.setClassId(PortalUtil.getClassNameId(Apeal.class));
							docum.setNote(StringPool.BLANK);
							try {
								DocumLocalServiceUtil.updateDocum(docum);
							} catch (SystemException e) {
								e.printStackTrace();
							}
						}
					}
					if ( CaretStrPool.IN_PROCESS.equals( dispositionChoice )) {
						Note note = CaretUtil.createNote(sc.getCreateDate(), appeal.getApealId(), NoteGroup.APPEAL.groupId(), sc.getUserId(), request.getParameter(ndx + "note"));
						note.setVcgId(vcg.getVcgId());
						NoteLocalServiceUtil.addNote(note);
					}
					
				} catch (ApplicationWorkFlowException e) {
					ApplicationWorkFlowException.handleException(e);
				} catch (SystemException e) {
					e.printStackTrace();
				} 
			}
			
			if ( CAction.canDoCaret(request, CaretCan.TECH_DISPOSITION ) ){
				String ticketNumber = Toolbox.nullSafe( request.getParameter(ndx + "ticketNumber") );
				_log.info("ticket" + vcgAnId + ":" + ticketNumber );
				vcg.setTicketNumber(vcgAnId, ticketNumber);
				vcg.setNote( "TicketNumber", ticketNumber, sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.DISPOSITION.groupId() );
			}
			
			String note = request.getParameter(ndx + "note");
			if ( !CaretStrPool.IN_PROCESS.equals( dispositionChoice )){
				vcg.setNote("dispositionNote", note, sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.DISPOSITION.groupId() );
			}
			
			CaretLocalServiceUtil.save(vcg);
		}
	
	
	public long updateActiveWork( long vcgAnId, VcgSupport vcg, Collection<Long> userIds, ServiceContext sc ) throws ApplicationWorkFlowException{
			//Update active Work Item
			try {
				long workUserId = 0;
				VcgApplication vcgApp = new VcgApplication( VcgAnLocalServiceUtil.getVcgAn( vcgAnId ) );
				if ( vcgApp != null ){
					ApplicationStatus appStatus = null;
					List<WorIm> works = WorImLocalServiceUtil.findByClassId( vcg.getVcgId(), vcgAnId); //worImId=630644, type=CSC_APP, US2517B, CGU2
					if ( !works.isEmpty() ){
						WorkItemSupport vcgAppWork = new WorkItemSupport( works.get(0) );
						if ( vcgAppWork.isCompletable( vcg ) ){
							if ( !WorkStatus.COMPLETE.name().equals( vcgAppWork.getStatus() ) ){
								vcgAppWork.setStatus( CaretStrPool.COMPLETE );
								vcgAppWork.setCompletionBy(sc.getUserId());
								vcgAppWork.setCompletionDate(sc.getCreateDate());
								workUserId = vcgAppWork.getUserId();
								CaretLocalServiceUtil.save(vcgAppWork);
								appStatus = ApplicationStatus.DECISION_MADE;
							} else if ( !ApplicationStatus.DECISION_MADE.name().equals( vcgApp.getStatus() ) ){
								appStatus = ApplicationStatus.IN_REVIEW;
							}
						} else if ( !ApplicationStatus.DECISION_MADE.name().equals( vcgApp.getStatus() ) ){
							appStatus = ApplicationStatus.IN_REVIEW;
						}
					}
					if ( appStatus != null ){
						vcgApp.setStatus( appStatus.name() );
						CaretLocalServiceUtil.save( vcgApp );
					}
				}
				
				
				if ( ! userIds.isEmpty() && vcgApp != null ) {
					String message = LanguageUtil.get( Locale.getDefault(), CaretStrPool.DISPOSITIONED_ONLINE_MESSAGE);
					userIds.add( vcg.getVeteran().getRootUserId() );
					for ( long userId : userIds ){
						if ( userId > 0 ){
							CaretLocalServiceUtil.addNote( CaretUtil.createNote( sc.getCreateDate(), vcgApp.getVcgAnId(), NoteSupport.NoteGroup.DISPOSITION.groupId(), userId, message ) );
						}
					}
				}
				
				return workUserId  == 0? sc.getUserId(): workUserId;
				
			} catch (NoSuchClassNameException e) {
				throw new ApplicationWorkFlowException(e);
			} catch (SystemException e) {
				throw new ApplicationWorkFlowException(e);
			} catch (PortalException e) {
				throw new ApplicationWorkFlowException(e);
			}
	}
	
	public String getNoteBody(VcgSupport vcg, String dispositionChoice, Person.Role role, ServiceContext sc ) {
		StringBuilder sb = new StringBuilder();
		sb.append("Veteran's Name - ").append(vcg.getVeteranName()).append("\n");
		sb.append("Veteran's SSN - ").append(vcg.getVeteran().getSsn()).append("\n");
		
		VcgAn app = vcg.getPersonVcgAn(role);
		if (app != null){
			sb.append("Form 10-10CG Valid Date - ").append( Toolbox.formatDateCprs(app.getReceivedDate() ) ).append("\n");
			
		}
		//sb.append("Form 10-10CG Valid Date - ").append( Toolbox.formatDateCprs(app.getReceivedDate() ) ).append("\n");
		
		try {
			sb.append("Veteran Assessment Completed - ").append( Toolbox.formatDateCprs(vcg.geVeteranAssessmentCompletionDate() ) ).append("\n");
			sb.append("Caregiver Assessment Completed - ").append( Toolbox.formatDateCprs(vcg.getCaregiverAssessmentCompletionDate(role) ) ).append("\n");
			sb.append("Caregiver Training Verified - ").append( Toolbox.formatDateCprs(vcg.getCaregiverTrainingCompletionDate(role) ) ).append("\n");
			sb.append("In-Home Visit Completed - ").append( Toolbox.formatDateCprs(vcg.getInHomeCompletionDate(role) ) ).append("\n");
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		}
		
		sb.append("Approval Date - ").append( Toolbox.formatDateCprs(sc.getCreateDate()) ).append("\n");
		sb.append("Approved Primary Family Caregiver Name - ").append(vcg.getPrimaryName()).append("\n");
//		(If there is a Secondary)
		if ( vcg.isSecondaryApproved() ){
			sb.append("Approved Secondary Family Caregiver Name - ").append(vcg.getSecondaryName()). append("\n");
		}
		
		
		return sb.toString();
	}


	public String getNoteTitle(VcgSupport vcg, String dispositionChoice, Person.Role role ) {
		
		String title = MessageFormat.format( LanguageUtil.get( Locale.getDefault(), "national-note-title-" + dispositionChoice ), role.name() );
		
		return title;
	}


	private void closeDelayWork(ActionRequest request, Person person, ServiceContext sc, VcgSupport vcg) throws ApplicationWorkFlowException {
		
		WorIm workItem = WorImLocalServiceUtil.findByCgWorkLast( vcg.getVcgId(), person.getPersnId(), WorkType.APP_DELAY.name() );
		
		if ( Toolbox.isEmpty( workItem.getStatus() ) || CaretStrPool.IN_PROCESS.equals( workItem.getStatus() ) ){
			throw new ApplicationWorkFlowException( "INVALID WORK ITEM STATUS" );
		} else {
			workItem = WorImLocalServiceUtil.findByCgWorkLast( vcg.getVcgId(), person.getPersnId(), WorkType.DELAY_REVIEWED.name() );
			workItem.setCompletionBy(PortalUtil.getUserId(request) );
			workItem.setCompletionDate( sc.getCreateDate() );
			workItem.setStatus( WorkStatus.COMPLETE.name() );
			
//			workItem.useNote(noteAtt, vcg.getNote(noteAtt));
			CaretLocalServiceUtil.save(workItem);
		}
		
	}


	private Waivr saveCscWaiver(ActionRequest request, Person person, ServiceContext sc, String ndx, long classPk, String adjudication) throws ApplicationWorkFlowException {
		Waivr waiver = new WaivrImpl();
		waiver.setReason( request.getParameter(ndx + "waiverReason") );
		waiver.setNote( request.getParameter(ndx + "waiverNote") );
		waiver.setUserId( person.getPersnId() );
		waiver.setOwnerId( person.getPersnId() );
		waiver.setCreationDate( sc.getCreateDate() );
		waiver.setClassPk( classPk );
		waiver.setAdjudication( adjudication );
		CaretLocalServiceUtil.save(waiver);
		return waiver;
	}


	private void saveFirstPeriodicAssessments(ActionRequest request, VcgSupport vcgSupport, Person person, Date dispositionDate){
		
		Map<String, Object> form = ResultMap.getForm(request);
		ServiceContext sc = CaretParam.setCaretServiceContext(request);
		
		//AssmtBean periodicAssmtOne = new AssmtBean(new AssmtImpl(), CaretStrPool.QUARTER1); 				
		//AssmtBean periodicAssmtTwo = new AssmtBean(new AssmtImpl(), CaretStrPool.QUARTER2);  			
		//AssmtBean periodicAssmtThree = new AssmtBean(new AssmtImpl(), CaretStrPool.QUARTER3); 				
		//AssmtBean periodicAssmtAnnual = new AssmtBean(new AssmtImpl(), CaretStrPool.ANNUAL); 

		List<AssmtBean> periodicAssessmentList = new ArrayList<AssmtBean>();
		//periodicAssessmentList.add(periodicAssmtOne);
		//periodicAssessmentList.add(periodicAssmtTwo);
		//periodicAssessmentList.add(periodicAssmtThree);
		//periodicAssessmentList.add(periodicAssmtAnnual);
		periodicAssessmentList.add(new AssmtBean(new AssmtImpl(), CaretStrPool.QUARTER1));
		periodicAssessmentList.add(new AssmtBean(new AssmtImpl(), CaretStrPool.QUARTER2));
		periodicAssessmentList.add(new AssmtBean(new AssmtImpl(), CaretStrPool.QUARTER3));
		periodicAssessmentList.add(new AssmtBean(new AssmtImpl(), CaretStrPool.ANNUAL));

		try {
			Calendar c = Calendar.getInstance(); 
			c.setTime(dispositionDate);
			for(AssmtBean oneAssmt:periodicAssessmentList){
				oneAssmt.getAssessment().setYear(1);
				oneAssmt.getAssessment().setVcgId(vcgSupport.getVcgId());
				oneAssmt.getAssessment().setActive(true);
				oneAssmt.getAssessment().setCaregiverId(person.getPersnId());
				oneAssmt.getAssessment().setUserId(sc.getUserId());
				
				c.add(Calendar.DATE, 90);
				oneAssmt.getAssessment().setScheduleDate(c.getTime());	
				
				CaretLocalServiceUtil.save(oneAssmt.getAssessment());
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}

		form.put("periodicAssessmentList", periodicAssessmentList);
	}

	
	public void inactivateAssessments( long vcgId, long caregiverId, String category) 
	{
		String[] periodicTypes = {CaretStrPool.QUARTER1, CaretStrPool.QUARTER2, CaretStrPool.QUARTER3, CaretStrPool.ANNUAL};
		String[] initialTypes = {CaretStrPool.PRIMARY_ASSESSMENT, CaretStrPool.PRIMARY_CLINICAL, CaretStrPool.PRIMARY_TRAINING, CaretStrPool.PRIMARY_IN_HOME, CaretStrPool.SECONDARY_ASSESSMENT, CaretStrPool.SECONDARY_CLINICAL, CaretStrPool.SECONDARY_TRAINING, CaretStrPool.SECONDARY_TWO_ASSESSMENT, CaretStrPool.SECONDARY_TWO_CLINICAL, CaretStrPool.SECONDARY_TWO_TRAINING};

		try 
		{						
			List<Assmt> assessmentList;
			if(category.equals(CaretStrPool.ASSMT_PERIODIC)){
				assessmentList = AssmtLocalServiceUtil.findByAssmtTypes(vcgId, periodicTypes);
			}else if(category.equals(CaretStrPool.ASSMT_INITIAL)){
				assessmentList = AssmtLocalServiceUtil.findByAssmtTypes(vcgId, initialTypes);
			}else{
				assessmentList = AssmtLocalServiceUtil.findByVcgId(vcgId);
			}
			
			for(Assmt assessment:assessmentList)
			{
				if(assessment.isActive() && assessment.getCaregiverId()==caregiverId)
				{
					assessment.setActive(false);
					CaretLocalServiceUtil.save(assessment);
				}
			}			
		} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
		}
	}

	
	public void activateAssessments( long vcgId, long caregiverId, String category) 
	{
		String[] periodicTypes = {CaretStrPool.QUARTER1, CaretStrPool.QUARTER2, CaretStrPool.QUARTER3, CaretStrPool.ANNUAL};
		String[] initialTypes = {CaretStrPool.PRIMARY_ASSESSMENT, CaretStrPool.PRIMARY_CLINICAL, CaretStrPool.PRIMARY_TRAINING, CaretStrPool.PRIMARY_IN_HOME, CaretStrPool.SECONDARY_ASSESSMENT, CaretStrPool.SECONDARY_CLINICAL, CaretStrPool.SECONDARY_TRAINING, CaretStrPool.SECONDARY_TWO_ASSESSMENT, CaretStrPool.SECONDARY_TWO_CLINICAL, CaretStrPool.SECONDARY_TWO_TRAINING};

		try 
		{						
			List<Assmt> assessmentList;
			if(category.equals(CaretStrPool.ASSMT_PERIODIC)){
				assessmentList = AssmtLocalServiceUtil.findByAssmtTypes(vcgId, periodicTypes);
			}else if(category.equals(CaretStrPool.ASSMT_INITIAL)){
				assessmentList = AssmtLocalServiceUtil.findByAssmtTypes(vcgId, initialTypes);
			}else{
				assessmentList = AssmtLocalServiceUtil.findByVcgId(vcgId);
			}
			
			for(Assmt assessment:assessmentList)
			{
				if(!assessment.isActive() && assessment.getCaregiverId()==caregiverId)
				{
					assessment.setActive(true);
					CaretLocalServiceUtil.save(assessment);
				}
			}			
		} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
		}
	}



	private String extDays(String dispositionReason, int[] extensionDays) {
		int ndx = dispositionReason.indexOf("[");
		String temp = dispositionReason;
		//TODO: do additional validation
		if ( ndx > 0 ){
			temp = dispositionReason.substring(0,ndx);
			extensionDays[0] = Integer.valueOf( dispositionReason.substring(ndx+1, dispositionReason.indexOf("]")) );
		}
		return temp;
	}

	
	public void saveVcgEntry ( ActionRequest request, ActionResponse response ) throws ApplicationWorkFlowException{
		getOutput(request);
		String ndx = Toolbox.nullSafe(request.getParameter("ndx")) + StringPool.UNDERLINE;
		long persnId = ParamUtil.getLong(request, request.getParameter("vcg_ndx") + "_primaryKey", ParamUtil.getLong(request, "_primaryKey", ParamUtil.getLong(request, ndx + "primaryKey") ) );
		long vcgId = ParamUtil.getLong(request, request.getParameter("ndx") + "vcgId", ParamUtil.getLong(request, "vcgId") );
		String icn = request.getParameter(ndx + "iCN");
		
		ServiceContext sc = CaretParam.setCaretServiceContext( request );
		VcgSupport vcg = null;
		if ( vcgId > 0 ){
			vcg = VcgSupport.getVcgSupport( vcgId );
			
			if ( CAction.canDoCaret( request, CAction.CaretCan.MANAGE_VCG.name() ) ){
				int mode = ParamUtil.getInteger(request, "MODE", 0);
				
				try {
					
					Person person = null;
					Person formPerson = null;
					boolean isApproved = false;
//					boolean relationshipEmpty = mode == 1 || Toolbox.isEmpty( request.getParameter( ndx + "relationship" ) );
					if ( persnId > 0 ){
						if ( persnId == vcg.getVeteranId() ){
							if ( mode == 0 ){
								formPerson = (Veteran) CaretParam.loadModel( request, new Veteran( new PersnImpl() ), 
									Toolbox.getCollection("firstName","lastName","middleName", "birthDate", "gender", "email", "address", "address2", "phone", "phone2", "ssn", "country", "validAddress",  "externalId", "vaHealthEnrolled", "groupId" ),
									ndx ); //TODO: create transfer work-item if facility is changed
							}
							person = new Veteran( PersnLocalServiceUtil.getPersn(persnId) );
							isApproved = vcg.isPrimaryApproved(); // || vcg.isSecondaryApproved() || vcg.isSecondaryTwoApproved();
						} else if ( persnId == vcg.getPrimaryId() ){
							person = new Primary( PersnLocalServiceUtil.getPersn(persnId) );
							if ( mode == 0 ) {
								formPerson = (Primary) CaretParam.loadModel( request, new Primary( new PersnImpl() ), 
										Toolbox.getCollection("firstName","lastName","middleName", "birthDate", "gender", "email", "address", "address2", "phone", "phone2", "ssn", "country", "validAddress",  "externalId", "otherHealthInsurance"),
										ndx );
								((Primary)formPerson).setInsurance( Primary.OTHER_INSURANCE_ATTRIBUTE, request.getParameter(ndx+"otherInsChecked") );
								((Primary)formPerson).setInsurance( Primary.MEDI_ENROLLED_ATTRIBUTE, request.getParameter(ndx+Primary.MEDI_ENROLLED_ATTRIBUTE) );
								((Primary)formPerson).setInsurance( Primary.TRICARE_ENROLLED_ATTRIBUTE, request.getParameter(ndx+Primary.TRICARE_ENROLLED_ATTRIBUTE) );
								((Primary)formPerson).setInsurance( Primary.CHAMPVA_ENROLLED_ATTRIBUTE, request.getParameter(ndx+Primary.CHAMPVA_ENROLLED_ATTRIBUTE) );
								vcg.setPrimaryType( request.getParameter( ndx + "relationship" ) );
							}
							isApproved = vcg.isPrimaryApproved();
						} else if ( persnId == vcg.getSecondaryId() ){
							person = new Secondary( PersnLocalServiceUtil.getPersn(persnId) );
							if ( mode == 0 ) {
								formPerson = (Secondary) CaretParam.loadModel( request, new Secondary( new PersnImpl() ), 
										Toolbox.getCollection("firstName","lastName","middleName", "birthDate", "gender", "email", "address", "address2", "phone", "phone2", "ssn", "country", "validAddress",  "externalId" ),
										ndx );
								vcg.setSecondaryType( request.getParameter( ndx + "relationship" ) );
							}
							isApproved = vcg.isSecondaryApproved();
						} else if ( persnId == vcg.getSecondaryTwoId() ){
							person = new SecondaryTwo( PersnLocalServiceUtil.getPersn(persnId) );
							if ( mode == 0 ) {
								formPerson = (SecondaryTwo) CaretParam.loadModel( request, new SecondaryTwo( new PersnImpl() ), 
										Toolbox.getCollection("firstName","lastName","middleName", "birthDate", "gender", "email", "address", "address2", "phone", "phone2", "ssn", "country", "validAddress",  "externalId" ),
										ndx );
								vcg.setSecondaryTwoType( request.getParameter( ndx + "relationship" ) );
							}
							isApproved = vcg.isSecondaryTwoApproved();
						} else {
							person = new General( PersnLocalServiceUtil.getPersn(persnId) );
							if ( mode == 0  || mode == 3 ) {
								formPerson = (General) CaretParam.loadModel( request, new General( new PersnImpl() ), 
										Toolbox.getCollection("firstName","lastName","middleName", "birthDate", "gender", "email", "address", "address2", "phone", "phone2", "ssn", "country", "validAddress",  "externalId" ),
										ndx );
								vcg.setGeneralType( request.getParameter( ndx + "relationship" ) );
							}
						}
						if ( mode != 2) CaretLocalServiceUtil.save(vcg);
					} else if ( mode == 3 ) {
						person = new General( new PersnImpl() );
						if ( mode == 0  || mode == 3 ) {
							formPerson = (General) CaretParam.loadModel( request, new General( new PersnImpl() ), 
									Toolbox.getCollection("firstName","lastName","middleName", "birthDate", "gender", "email", "address", "address2", "phone", "phone2", "ssn", "country", "validAddress",  "externalId" ),
									ndx );
						}
					}
					
					
					if ( mode == 0 || mode == 3 ){
						if ( formPerson.isForeigner() ){
							CaretParam.loadModel( request, formPerson, Toolbox.getAddressCollection(), Toolbox.nullSafe(request.getParameter("ndx")) + CaretStrPool.G_UNDERLINE );
						} else {
							CaretParam.loadModel( request, formPerson, Toolbox.getAddressCollection(), Toolbox.nullSafe(request.getParameter("ndx")) + CaretStrPool.U_UNDERLINE );
						}
					}
					
					//writeTiuNote(request, getNoteBody(vcg, "Approved", person.getRole(), sc), getNoteTitle(vcg, "Approved", person.getRole()), vcg, person.getRole(), 0);
					
					switch ( mode ){
						case 1:
							if ( CAction.canDoCaret( request, CAction.CaretCan.DISPOSITION_VCG.name() ) ){
								saveVcgDisposition ( request, vcg, person );
							}
							break;
						case 2:
							saveVcgTier( request, response );
							if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_TIER_LEVEL.name() ) ){
								String tierEffectiveDate = request.getParameter(ndx + "tierEffectiveDate");
								String tierLevelStr = request.getParameter(ndx + "tier");
								boolean appealTier = ParamUtil.getBoolean(request, "appealTier");
								String dispositionDate = request.getParameter(ndx + "dispositionDate");
								String caretNote = request.getParameter("caret_note");
								String outComeAppeal  = request.getParameter("_appeal_outcome");
								int tierLevel = ParamUtil.getInteger(request, ndx + "tier");
								int oldTier = vcg.getTierLevel();
								boolean tierChanged = tierLevel != oldTier;
								
								String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
								vcg.setTierLevel(tierLevel);
								if ( !Toolbox.isEmpty(outComeAppeal) || appealTier )  {
									try {
										Apeal appeal;
										String auditOnce = StringPool.BLANK;
										boolean appealed = false;
										if ( !Toolbox.isEmpty(outComeAppeal) ){
											appeal = ApealLocalServiceUtil.getByOwner( vcg.getPrimaryVcgAnId(), person.getPersnId(), "tier" );
											appeal.setAdjudication( LanguageUtil.get( Locale.getDefault(), outComeAppeal ) + ":" + request.getParameter(ndx + "note") );
											appeal.setCompletionDate(Toolbox.parseDate(dispositionDate) );
//											if ( outComeAppeal.endsWith( "veteran-" ) ){
//												tierLevel = Integer.valueOf(String.valueOf(tierLevelStr));
//											}
//											appeal.setContact(contact);
//											ApealLocalServiceUtil.countByOwner( vcg.getPrimaryVcgAnId(), person.getPersnId(), "tier" + vcg.getTierLevel() );
											auditOnce = outComeAppeal;
											appealed = false;
										} else {
											auditOnce = tierLevelStr;
											appealed = true;
											appeal = new ApealImpl();
											appeal.setClassPk( vcg.getPrimaryVcgAnId() );
											appeal.setOwnerId( person.getPersnId() );
											appeal.setReason( "tier" );
											appeal.setType( tierLevelStr );
											appeal.setCreationDate(sc.getCreateDate());
											appeal.setNote( request.getParameter(ndx + "note") );
										}
										
										vcg.setTierAppealed(appealed, auditOnce);
										CaretLocalServiceUtil.save(vcg);
										vcg.setTierAppealed(appealed, auditOnce);
										
										CaretLocalServiceUtil.save( appeal );
										
										List<Docum> documents = DocumLocalServiceUtil.getByTrackerNote( tracker );
										for ( Docum docum : documents ){
											if ( docum.getClassPk() == 0 ){
												docum.setClassPk(appeal.getApealId());
												docum.setClassId(PortalUtil.getClassNameId(Apeal.class));
												docum.setNote(StringPool.BLANK);
												try {
													DocumLocalServiceUtil.updateDocum(docum);
												} catch (SystemException e) {
													e.printStackTrace();
												}
											}
										}
										
									} catch (ApplicationWorkFlowException e) {
										ApplicationWorkFlowException.handleException(e);
									} 
								}
								
								
//								VcgSupport vcgSupport = new VcgSupport(vcg);
								if ( tierEffectiveDate != null && !vcg.getTierEffectiveDateStr().equals( tierEffectiveDate ) || tierChanged ){
									vcg.setTierEffectiveDateStr( tierEffectiveDate );
									if ( dispositionDate!= null && !StringPool.BLANK.equals( dispositionDate ) ){
										vcg.setPrimaryDispositionDate( Toolbox.parseDate(dispositionDate) );
									}
									vcg.setTierLevel( tierLevel  );
					
									vcg.setNote("tierUpdateNote", caretNote, sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.TIER_UPDATE.groupId() );
									CaretLocalServiceUtil.save(vcg);
									
									if ( tierChanged ){
										String message = LanguageUtil.get( Locale.getDefault(), CaretStrPool.DISPOSITIONED_ONLINE_MESSAGE);
										CaretLocalServiceUtil.addNote( CaretUtil.createNote(sc.getCreateDate(), vcg.getPrimaryVcgAnId(), NoteSupport.NoteGroup.TIER_UPDATE.groupId(), person.getRootUserId(), message ) );
										CaretLocalServiceUtil.addNote( CaretUtil.createNote(sc.getCreateDate(), vcg.getPrimaryVcgAnId(), NoteSupport.NoteGroup.TIER_UPDATE.groupId(), vcg.getVeteran().getRootUserId(), message ) );
									}
									
									BaseModel<?> bm = vcg.getPersonVcgAn( persnId );
									if ( bm == null || mode == 0 ){
										bm = vcg;
									}
									
									List<StiPt> list = StiPtLocalServiceUtil.findByVcg(vcgId, -1, -1, null);
									if ( !list.isEmpty() ) {
										
										for ( StiPt stiPt: list ) {
											
											StipendConfig foundConfig = new StipendConfig(stiPt);
											if ( foundConfig.isRecurring( ) ) {
												//TODO:...
											}
											
											
											WorIm workItem = CaretUtil.createWorkItem(sc, vcg.getGroupId(), bm, WorkType.TIER_UPDATE, 
													vcg.getVeteranId(), person.getPersnId() == vcg.getVeteranId()? vcg.getPrimaryId(): person.getPersnId() );
											workItem.setQueueId( OwnerQueue.TIER_MOD_Q.queueId );
											workItem.setStatus( CaretStrPool.TIER_UPDATE_REVIEW_PENDING );
											workItem.setVcgId(vcgId);
											CaretLocalServiceUtil.save( workItem );
											
											StipendConfig config = new StipendConfig ( new StiPtImpl() );
											config.setFields( vcg.getTierEffectiveDate(), vcg, new WorkItemSupport( workItem ), sc, String.valueOf(vcg.getTierLevelPreviously()), String.valueOf(vcg.getTierLevel())   );
											CaretLocalServiceUtil.save( config );
											CaretLocalServiceUtil.addNote( CaretUtil.createNote( sc.getCreateDate(), workItem.getWorImId(), NoteSupport.NoteGroup.TIER_UPDATE.groupId(), sc.getUserId(), request.getParameter("caret_note") ) );
										
										}
										
										
									}
									
									
								} 
							}
							break;
						case 3: //assigning General CG
							
							if ( vcg.getGeneralId() > 0 && ( vcg.isApproved( vcg.getGeneralDispReason() ) || vcg.isReinstated( vcg.getGeneralDispReason() ) ) ){
								throw new ApplicationWorkFlowException ( "Cannot over-write an approved General Caregiver for a new General Caregiver ");
							}
							
							if ( CaretViewController.getViewController().setVcgPerson( request, formPerson, person, new boolean[5]).isEmpty() ){
								CaretLocalServiceUtil.save(person);
								vcg.setNote("generalAssignmentNote", ParamUtil.get(request, CaretStrPool.WORK_COMMENT, CaretStrPool.ASSIGNED_GENERAL_CG_MESSAGE ),
										sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.ASSIGN_GENERAL.groupId() );
								
								vcg.setNewGeneral(person.getPersnId(), request.getParameter( ndx + "relationship" ) );
								CaretLocalServiceUtil.save(vcg);
							}
							
							break;
						case 4:
//							String vcgNdx = request.getParameter("vcg_ndx") + StringPool.UNDERLINE;
//							VcgAn vcgAn = vcg.getPersonVcgAn( persnId );
							BaseModel<?> bm = vcg.getPersonVcgAn( persnId );
							if ( bm == null || mode == 0 ){
								bm = vcg;
							}
							WorkItemSupport workAppDelay =  new WorkItemSupport(CaretUtil.createWorkItem(sc, vcg.getGroupId(), bm, WorkType.APP_DELAY, vcg.getVeteranId(), persnId));
							workAppDelay.setVcgId( vcg.getVcgId() );
//							workAppDelay.setQueId( waiver.getWaivrId() );
							CaretLocalServiceUtil.save(workAppDelay);
							saveCscWaiver( request, person, sc, ndx, workAppDelay.getApplicationId(), null );
							
							vcg.setNote("appDelayNote",  request.getParameter(ndx + "waiverNote"),
									sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.APP_DELAY.groupId() );
							CaretLocalServiceUtil.save(vcg);

							workAppDelay.useNote("appDelayNote", vcg.getNote("appDelayNote"));
							CaretLocalServiceUtil.save(workAppDelay);
							break;
						default:
					
							
						
						boolean[] change = new boolean[5];
						
						String oldAddress = null;
						String oldzip = person.getZip();
						if ( Person.Role.VETERAN == person.getRole() || Person.Role.PRIMARY == person.getRole() ){
							oldAddress = new StringBuilder(person.getAddress()).append(StringPool.COMMA_AND_SPACE).append(person.getCity()).append(StringPool.SPACE).append(person.getState()).append(StringPool.SPACE).append(person.getZip()).toString();
						}
						
						List<String> errors = CaretViewController.getViewController().setVcgPerson( request, formPerson, person, change);
						
						if ( ! errors.isEmpty() ){
							request.setAttribute("SAVE_FAILED", errors.get(0) );
							return;
						}
						
						if ( change[Person.Changes.INSURANCE_CHANGE.ordinal()] || 
								change[Person.Changes.ADDRESS_CHANGE.ordinal()] || 
								change[Person.Changes.PII_CHANGE.ordinal()] || 
								change[Person.Changes.NAME_CHANGE.ordinal()] ){
							if ( isApproved ){
								long caregiverPersnId = person.getPersnId() == vcg.getVeteranId()? vcg.getPrimaryId(): person.getPersnId();
								bm = vcg.getPersonVcgAn( caregiverPersnId );
								if ( bm == null || mode == 0 ){
									bm = vcg;
								}
								boolean addedInsurChange = false;
								boolean addedInfoChange = false;
								StipendConfig config = null;
								List <WorIm> workItems =  CaretUtil.createWorkItems(request, 0, bm, change, 
										vcg.getVeteranId(), caregiverPersnId ) ;
								if ( person.getRole() == Person.Role.PRIMARY || person.getRole() == Person.Role.VETERAN ) {
										for ( WorIm workItem : workItems ){
											if ( WorkName.INSURANCE_CHANGE.name().equals( workItem.getType() ) ){
												if ( !addedInsurChange ){
													workItem.setVcgId( vcg.getVcgId() );
													workItem.setGroupId( vcg.getGroupId() );
													workItem.setQueueId( OwnerQueue.PRIM_HEALTH_INS_Q.queueId );
													CaretLocalServiceUtil.save(workItem);
													addedInsurChange = true;
												}
											} else if ( !addedInfoChange ){
												String oldValue = StringPool.BLANK;
												String newValue = StringPool.BLANK;
												if ( Person.Role.PRIMARY == person.getRole() ){
													workItem.setType( WorkName.C_INFO_CHANGE.name() );
													if ( vcg.isPrimaryApproved() && change[Person.Changes.ADDRESS_CHANGE.ordinal()] ){
														oldValue = oldAddress;
														newValue = new StringBuilder(person.getAddress()).append(StringPool.COMMA_AND_SPACE).append(person.getCity()).append(StringPool.SPACE).append(person.getState()).append(StringPool.SPACE).append(person.getZip()).toString();
													}
												} else if ( Person.Role.VETERAN == person.getRole() ){
													workItem.setType( WorkName.V_INFO_CHANGE.name() );
													if ( vcg.getPrimaryId() > 0 ){
														if ( config == null && vcg.isPrimaryApproved() && change[Person.Changes.ADDRESS_CHANGE.ordinal()] ){
															BlsRe newRate = BlsReLocalServiceUtil.findLatestBlsByZip( person.getZip() );
															BlsRe oldRate = BlsReLocalServiceUtil.findLatestBlsByZip( oldzip );
															if ( newRate == null || oldRate == null ) {
																_log.error("BLS Rate no longer found for the selected address");
															} else if ( newRate.getH75() != oldRate.getH75() ) {
																config = new StipendConfig( new StiPtImpl() );
															} else { //unchanged config settings...
																List<StiPt> stPt = StiPtLocalServiceUtil.findByVcg( vcg.getVcgId(), -1, -1, null);
																if ( !stPt.isEmpty() ) {
																	 workItem.setGroupId( stPt.get(0).getStiPtId() );
																}
															}
															oldValue = oldAddress;
															newValue = new StringBuilder(person.getAddress()).append(StringPool.COMMA_AND_SPACE).append(person.getCity()).append(StringPool.SPACE).append(person.getState()).append(StringPool.SPACE).append(person.getZip()).toString();
															workItem.setType( WorkType.ADDRESS_CHANGE.name() );
														}
													}
												}
												workItem.setQueId( sc.getUserId() );
												workItem.setQueueId( OwnerQueue.VCG_INFO_MOD_Q.queueId );
												if ( workItem.getGroupId() == 0 ) {
													workItem.setGroupId( vcg.getGroupId() );
												}
												workItem.setVcgId( vcg.getVcgId() );
												CaretLocalServiceUtil.save(workItem);
												if ( config != null && config.getPrimaryKey() == 0 ){
													config.setFields( sc.getCreateDate(), vcg, new WorkItemSupport( workItem ), sc, oldValue, newValue  );
													CaretLocalServiceUtil.save( config );
												}
												addedInfoChange = true;
											} 
										}
									}
							}
							String comment = request.getParameter(CaretStrPool.WORK_COMMENT);
							if ( !Toolbox.isEmpty(comment) ){
								vcg.setNote(person.getRole().getLabel()+"Note", request.getParameter(CaretStrPool.WORK_COMMENT), sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.PROFILE_UPDATE.groupId() );
								CaretLocalServiceUtil.save(vcg);
							}
//							if ( change[Person.Changes.ADDRESS_CHANGE.ordinal()] ){
//								StringBuilder sb = new StringBuilder().append(person.getAddress())
//										.append( person.getCity() ).append( person.getState()).append( person.getZip());
//								boolean valid = isValid(request, person.getAddress(), person.getCity(), person.getState(), person.getZip() );
//								person.setValidAddress( valid );
//							}
						} else {
							String comment = request.getParameter(CaretStrPool.WORK_COMMENT);
							if ( !Toolbox.isEmpty(comment) ){
								vcg.setNote(person.getRole().getLabel()+"Note", request.getParameter(CaretStrPool.WORK_COMMENT), sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.CAREGIVER_INFO.groupId() );
								CaretLocalServiceUtil.save(vcg);
							}
						}
						CaretLocalServiceUtil.save(person);
					}

				} catch (PortalException e) {
					ApplicationWorkFlowException.handleException(e);
				} catch (SystemException e) {
					ApplicationWorkFlowException.handleException(e);
				}
				
				loadVcgManagement (request, response);
				response.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.VCG_MANAGEMENT_PAGE);
			}
		} else {
			_log.info("vcgId == 0");
			Veteran vcgVeteran;
			try {
				
				Map<Long,Person> cachedMVI = (Map<Long,Person>) request.getPortletSession().getAttribute(CaretStrPool.CACHED_MVI);
				if ( cachedMVI == null ){
					cachedMVI = new HashMap<>();
				}
				if ( persnId > 0 ){
					if ( cachedMVI.containsKey(persnId) ){
						Persn person = null;
						if ( !Toolbox.isEmpty( cachedMVI.get(persnId).getICN() ) ){
							person = PersnLocalServiceUtil.getByIcn( cachedMVI.get(persnId).getICN() );
						}
						if ( person != null ){
							vcgVeteran = new Veteran ( person );
						} else {
							vcgVeteran = new Veteran( cachedMVI.get(persnId) );
							CaretLocalServiceUtil.save(vcgVeteran);
						}
						persnId = vcgVeteran.getPrimaryKey();
					}
				}
				
				if ( persnId > 0 ){
					vcgVeteran = new Veteran(PersnLocalServiceUtil.getPersn(persnId));
				} else if ( !Toolbox.isEmpty(icn) ){
					vcgVeteran = new Veteran(new PersnImpl());
					vcgVeteran.setICN(icn);
					vcgVeteran.setLastName(request.getParameter("veteranPersonu_lastName"));
				} else {
					throw new ApplicationWorkFlowException ( "NEED VERIFIED ID FOR VCG CREATION" );
				}
				CaretParam.loadModel(request, vcgVeteran, vcgVeteran.getModelAttributes().keySet(), ndx);
				if ( vcgVeteran.isForeigner() ){
					CaretParam.loadModel( request, vcgVeteran, Toolbox.getAddressCollection(), CaretStrPool.VETERAN_PERSON + CaretStrPool.G_UNDERLINE );
				} else {
					CaretParam.loadModel( request, vcgVeteran, Toolbox.getAddressCollection(), CaretStrPool.VETERAN_PERSON + CaretStrPool.U_UNDERLINE );
				}
			} catch (PortalException e) {
				throw new ApplicationWorkFlowException(e);
			} catch (SystemException e) {
				throw new ApplicationWorkFlowException(e);
			}
			vcgVeteran.setStatus(CaretStrPool.ACTIVE_VCG);
			vcgVeteran.setVaHealthEnrolled(ParamUtil.get(request, ndx + "_vaHealthEnrolled", false));
			CaretLocalServiceUtil.save(vcgVeteran);
			VcgSupport vcgSupport = VcgSupport.getVeteranVcg( vcgVeteran.getPersnId() );
			vcgSupport.setGroupId(vcgVeteran.getGroupId());

			CaretLocalServiceUtil.save(vcgSupport);
			vcgSupport.setNote("vcgCreateNote", ParamUtil.get(request, "veteranPerson_comments", "Created a VCG Record"),
					sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.CREATE_VCG.groupId());
			CaretLocalServiceUtil.save(vcgSupport);

			Note note = vcgSupport.getNote("vcgCreateNote");
			long worImId = ParamUtil.getLong(request, "worImId");
			if ( worImId > 0 ){
				try {
					WorkItemSupport workItem = new WorkItemSupport ( WorImLocalServiceUtil.getWorIm(worImId) );
					workItem.useNote("vcgCreateNote", note);
					workItem.setVcgId( vcgSupport.getVcgId() );
					CaretLocalServiceUtil.save(workItem);
				} catch (PortalException e) {
					throw new ApplicationWorkFlowException();
				} catch (SystemException e) {
					throw new ApplicationWorkFlowException();
				}
			}
			vcg = vcgSupport;
		}
		
		if ( vcg != null ){
			request.setAttribute(CaretStrPool.VCGID, vcg.getVcgId() );
		}
		loadVcgManagement (request, response);
		request.setAttribute( CaretStrPool.MVC_PATH, CaretStrPool.VCG_MANAGEMENT_PAGE );
	}
	
//	private boolean isValid( PortletRequest request, String address, String city, String state, String zip ) {
//		PortletSession session = request.getPortletSession();
//		StringBuilder sb = new StringBuilder().append(address).append( city ).append( state ).append( zip );
//		Boolean valid = (Boolean)session.getAttribute( sb.toString() );
//		if ( valid == null ){
//			valid = CaretUtil.isValidateUspsAddress(address, city, state, zip );
//			session.setAttribute( sb.toString() , valid );
//		}
//		return valid;
//	}


	public void associateWorkItem ( long associateId, long vcgId, PortletRequest request ) throws ApplicationWorkFlowException{
		if ( associateId > 0 ){
			try {
				ServiceContext sc = CaretParam.setCaretServiceContext(request);
				WorkItemSupport associateWorIm = new WorkItemSupport ( WorImLocalServiceUtil.getWorIm(associateId) );
				String summary = null;
				if ( WorkType.CALL_REFERRAL.equals( associateWorIm.getWorkType() ) ) {
					summary = CallLocalServiceUtil.getCall( associateWorIm.getClassPk() ).getSummary();
					
					
					
					//hardcoding url as html link in a note : decided not to go that way...
					//String s = "<a href=\"http://localhost:8090/group/clinic/local?p_p_id=caret_WAR_caretportlet&p_p_lifecycle=1&p_p_state=normal&p_p_mode=view&_caret_WAR_caretportlet_entry=CREATE_REFERRAL&_caret_WAR_caretportlet_action=loadEntry&_caret_WAR_caretportlet_callId=";
					//s += associateWorIm.getClassPk();
					//s += "&_caret_WAR_caretportlet_javax.portlet.action=doAction\">link</a>";
					//CaretLocalServiceUtil.addNote( CaretUtil.createNote(sc.getCreateDate(), associateWorIm.getClassPk(), roleId, sc.getUserId(), s) );

					
					//Object pauth = com.liferay.portal.security.auth.AuthTokenUtil.getAuthToken();
					//AuthToken at = ((com.liferay.portal.security.auth.AuthTokenUtil) pauth).getAuthToken();
					//String s1 = PortalUtil.getPathFriendlyURLPrivateGroup();
					//String s2 = PortalUtil.getPathFriendlyURLPrivateUser();
					//String s3 = PortalUtil.getPathFriendlyURLPublic();
					//String s4 = PortalUtil.getPathMain();
					////String s5 = at.toString();
					//String s6 = pauth.toString();
					//_log.info("8e: associateWorkItem s1: " + s1);
					//_log.info("8e: associateWorkItem s2: " + s2);
					//_log.info("8e: associateWorkItem s3: " + s3);
					//_log.info("8e: associateWorkItem s4: " + s4);
					////_log.info("8e: associateWorkItem s5: " + s5);
					//_log.info("8e: associateWorkItem s6: " + s6);

				}
				//
				associateWorIm.setVcgId(vcgId); 
				String comment = "Associated " + associateWorIm.getType() + " to VCG. ";
				if ( !Toolbox.isEmpty(summary) ){
					associateWorIm.setNote("callSummary", summary, sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.CALL_NOTE.groupId() );
					associateWorIm.setNote("associatedNote", comment, sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.ASSOCIATE_NOTE.groupId() );
				} else {
					associateWorIm.setNote("associatedNote", comment, sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.ASSOCIATE_NOTE.groupId() );
				}
				if ( CaretStrPool.NEW.equals( associateWorIm.getStatus() ) ){
					associateWorIm.setStatus( CaretStrPool.IN_PROCESS );
				}
				CaretLocalServiceUtil.save(associateWorIm);
				Note note = associateWorIm.getNote( "associatedNote" );
				
				VcgSupport vcgSupport = VcgSupport.getVcgSupport(vcgId);
				vcgSupport.useNote("workItemAssociate", note );
				CaretLocalServiceUtil.save( vcgSupport );
				
				List<Long> noteIds = new ArrayList<Long>();
				if (note != null) {
					if (!noteIds.contains(note.getNoteId())) {
						noteIds.add(note.getNoteId());
					}
				} else {
					_log.info("associateWorkItem....current note is null ");
				}
				List<Note> notes = NoteLocalServiceUtil.findByChainId(associateWorIm.getClassPk());
				for (Note noteIter : notes) {
					if (!noteIds.contains(noteIter.getNoteId())) {
						noteIds.add(noteIter.getNoteId());
					}
				}
				notes = NoteLocalServiceUtil.findByChainId(vcgSupport.getVcgId());
				for (Note noteIter : notes) {
					if (!noteIds.contains(noteIter.getNoteId())) {
						noteIds.add(noteIter.getNoteId());
					}
				}
				for (Long longIter : noteIds) {
					Note noteIter = NoteLocalServiceUtil.fetchNote(longIter.longValue());
					noteIter.setVcgId(vcgId);
					NoteLocalServiceUtil.updateNote(noteIter);
				} 

				
			} catch (PortalException e) {
				throw new ApplicationWorkFlowException();
			} catch (SystemException e) {
				throw new ApplicationWorkFlowException();
			}
		}
	}
	
	public void saveVcgAn ( ActionRequest actionRequest ){
		_log.info("saveVcgAn..." );
		getOutput(actionRequest);
		
		try {
			
			VcgApplication vcgApplication = new VcgApplication( new VcgAnImpl() );
			CaretParam.loadModel(actionRequest, vcgApplication, vcgApplication.getModelAttributes().keySet(), CaretStrPool.VCGAN_UNDERLINE);
						
			//create new person records in db for veteran and caregivers
			ServiceContext sc = CaretParam.setCaretServiceContext(actionRequest);
			vcgApplication.setCreationDate(sc.getCreateDate());
			
			long caregiverId = 0;

			String veteranFirstName = ParamUtil.get(actionRequest, "veteranPersn_firstName", "");
			if(!veteranFirstName.equals("")){			
				Veteran veteran = new Veteran( new PersnImpl() );
				CaretParam.loadModel(actionRequest, veteran, veteran.getModelAttributes().keySet(), CaretStrPool.VETERAN_PERSN  + StringPool.UNDERLINE);
				if( "false".equals(veteran.getCountry()) ){ //usa address
					CaretParam.loadModel(actionRequest, veteran, Toolbox.getAddressCollection(), CaretStrPool.VETERAN_PERSN + "u_" );
					if ( PortletProps.get("csc.required.veteran.input").contains("uspsValidation") && veteran.isCompleteDomesticAddress() && !veteran.isForeigner() ){
						veteran.setValidAddress(veteran.isValidUspsAddress());
					}
				}else if(!"false".equals(veteran.getCountry())){//foreign address
					CaretParam.loadModel(actionRequest, veteran, Toolbox.getAddressCollection(), CaretStrPool.VETERAN_PERSN + "g_" );										
				}	
				veteran.setVaHealthEnrolled( vcgApplication.getVaHealthEnrolled() );
				CaretLocalServiceUtil.save( veteran );
				vcgApplication.setVeteranId(veteran.getPersnId());
			}
			
			String primaryFirstName = ParamUtil.get(actionRequest, "primaryPersn_firstName", "");
			if(!primaryFirstName.equals("")){			
				Primary primary = new Primary ( new PersnImpl() );
				CaretParam.loadModel(actionRequest, primary, primary.getModelAttributes().keySet(), CaretStrPool.PRIMARY_PERSN  + StringPool.UNDERLINE);
				if( "false".equals(primary.getCountry()) ){ //usa address
					CaretParam.loadModel(actionRequest, primary, Toolbox.getAddressCollection(), CaretStrPool.PRIMARY_PERSN + "u_" );
					if ( PortletProps.get("csc.required.primary.input").contains("uspsValidation") && primary.isCompleteDomesticAddress() && !primary.isForeigner() ){
						primary.setValidAddress(primary.isValidUspsAddress());
					}
				} else if (!"false".equals(primary.getCountry())){
					CaretParam.loadModel(actionRequest, primary, Toolbox.getAddressCollection(), CaretStrPool.PRIMARY_PERSN + "g_" );					
				}
				primary.setOtherInsChecked(ParamUtil.getBoolean(actionRequest, "primaryPersn_otherHealthInsuranceYesNo"));
				primary.setMediEnrolled(vcgApplication.getMediEnrolled());
				CaretLocalServiceUtil.save( primary );
				vcgApplication.setPrimaryId(primary.getPersnId());
				caregiverId = primary.getPersnId();
			}
			
			String secondaryFirstName = ParamUtil.get(actionRequest, "secondaryPersn_firstName", "");
			if(!secondaryFirstName.equals("")){			
				Person secondary = new Person ( new PersnImpl() );
				CaretParam.loadModel(actionRequest, secondary, secondary.getModelAttributes().keySet(), CaretStrPool.SECONDARY_PERSN  + StringPool.UNDERLINE);
				if( "false".equals(secondary.getCountry()) ){ //usa address
					CaretParam.loadModel(actionRequest, secondary, Toolbox.getAddressCollection(), CaretStrPool.SECONDARY_PERSN + "u_" );
					if ( PortletProps.get("csc.required.secondary.input").contains("uspsValidation") && secondary.isCompleteDomesticAddress() && !secondary.isForeigner() ){
						secondary.setValidAddress(secondary.isValidUspsAddress());
					}
				}else if(!"false".equals(secondary.getCountry()) ){
					CaretParam.loadModel(actionRequest, secondary, Toolbox.getAddressCollection(), CaretStrPool.SECONDARY_PERSN + "g_" );					
				}
				CaretLocalServiceUtil.save( secondary );
				vcgApplication.setSecondaryId(secondary.getPersnId());
				if ( caregiverId == 0 ){
					caregiverId = secondary.getPersnId();
				}
			}

			String secondaryTwoFirstName = ParamUtil.get(actionRequest, "secondaryTwoPersn_firstName", "");
			if(!secondaryTwoFirstName.equals("")){			
				Person secondaryTwo = new Person ( new PersnImpl() );
				CaretParam.loadModel(actionRequest, secondaryTwo, secondaryTwo.getModelAttributes().keySet(), CaretStrPool.SECONDARY_TWO_PERSN  + StringPool.UNDERLINE);
				if( "false".equals(secondaryTwo.getCountry()) ){ //usa address
					CaretParam.loadModel(actionRequest, secondaryTwo, Toolbox.getAddressCollection(), CaretStrPool.SECONDARY_TWO_PERSN + "u_" );
					if ( PortletProps.get("csc.required.secondaryTwo.input").contains("uspsValidation") && secondaryTwo.isCompleteDomesticAddress() && !secondaryTwo.isForeigner() ){
						secondaryTwo.setValidAddress(secondaryTwo.isValidUspsAddress());
					}
				}else if(!"false".equals(secondaryTwo.getCountry()) ){
					CaretParam.loadModel(actionRequest, secondaryTwo, Toolbox.getAddressCollection(), CaretStrPool.SECONDARY_TWO_PERSN + "g_" );
				}
				CaretLocalServiceUtil.save( secondaryTwo );
				vcgApplication.setSecondaryTwoId(secondaryTwo.getPersnId());
				if ( caregiverId == 0 ){
					caregiverId = secondaryTwo.getPersnId();
				}
			}

			boolean foreignCountry = ParamUtil.getBoolean(actionRequest, "veteranPersn_country");
			String groupId = "";
			if(foreignCountry){
				groupId = ParamUtil.get(actionRequest, "veteranPersng_groupId", "");
			}else{
				groupId = ParamUtil.get(actionRequest, "veteranPersn_groupId", "");
			}
			if(!groupId.equals("")){vcgApplication.setGroupId(Long.parseLong(groupId));}

			CaretLocalServiceUtil.save( vcgApplication );
			
						
			long documId = ParamUtil.getLong(actionRequest, "REFERRAL_1010");
			if ( documId > 0 ){
				try {
					Docum docum = DocumLocalServiceUtil.getDocum(documId);
					Docum copy = DocumLocalServiceUtil.createDocum( CounterLocalServiceUtil.increment( Docum.class.getName() ) );
					copy.setDocument(docum.getDocument());
					copy.setClassPk(vcgApplication.getVcgAnId());
					copy.setClassId(PortalUtil.getClassNameId(VcgAn.class));
					copy.setNote("Loaded from Referal");
					copy.setName(docum.getName());
					copy.setType(FileType.CSC_1010.name());
					DocumLocalServiceUtil.addDocum( copy );
				} catch (PortalException e) {
					e.printStackTrace();
				}
			} else {
				String tracker = ParamUtil.getString(actionRequest, CaretStrPool.TRACKER, StringPool.BLANK );
				List<Docum> documents = DocumLocalServiceUtil.getByTrackerNote( tracker );
				for ( Docum docum : documents ){
					if ( docum.getClassPk() == 0 ){
						docum.setClassPk(vcgApplication.getVcgAnId());
						docum.setClassId(PortalUtil.getClassNameId(VcgAn.class));
						docum.setNote(StringPool.BLANK);
						DocumLocalServiceUtil.updateDocum(docum);
					}
				}
			}
			WorkItemSupport work = new WorkItemSupport( CaretUtil.createWorkItem( sc, vcgApplication.getGroupId(), vcgApplication, WorkType.CSC_APP, vcgApplication.getVeteranId(), caregiverId ) );
			CaretLocalServiceUtil.save( work );
			work.setNote("cscNewApp", actionRequest.getParameter("vcgAn_comments"), sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.CSC_APP.groupId()  );
			CaretLocalServiceUtil.save( work );
			
		} catch (SystemException e1) {
			ApplicationWorkFlowException.handleException(e1);
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
	}
	
	public void handleApplicationDocument ( PortletRequest request, AttachmentBean attachment) throws FileNotFoundException, SystemException {
		
		//File uploadFile = new File(path);
		File uploadFile = new File(attachment.getPath());
		InputStream inputStream = new FileInputStream( uploadFile );
		OutputBlob outputBlob = new OutputBlob ( inputStream, uploadFile.length() );
		
		long documId = CounterLocalServiceUtil.increment( Docum.class.getName() );
		Docum document = DocumLocalServiceUtil.createDocum(documId);
		document.setDocument(outputBlob);
		document.setDeleted(false);
		//document.setClassPk( vcgApplication.getVcgAnId() );
		//document.setClassId( PortalUtil.getClassNameId(VcgAn.class) );
		document.setClassPk( attachment.getClassPk() );
		document.setClassId( attachment.getClassId() );
		document.setType(attachment.getType());
		document.setName(attachment.getName());
		try {
			DocumLocalServiceUtil.addDocum( document );
			request.getPortletSession().removeAttribute(CaretStrPool.FILE_NAME);
			FileUtil.delete(uploadFile);
		}
		catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	@ProcessAction (name="searchEntry")
	public void searchEntry( ActionRequest actionRequest, ActionResponse actionResponse ) {
		searchEntry(actionRequest);
	}

	public void loadCallType(PortletRequest request) throws ApplicationWorkFlowException {
		
		Map<String,Object> form = ResultMap.getForm (request);
		
		String callType = PortletProps.get("call.type");
		if ( !callType.isEmpty() ){
			String[] array = (callType + StringPool.COMMA + "soc-call").split(StringPool.COMMA) ;
			List<String> c = ListUtil.fromArray(array);
			Collections.sort(c);
			form.put( "standard-call-types", c );
		}
		form.put( CaretStrPool.CUSTOM_CALL_TYPES, BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.CUSTOM_CALL_TYPES) );
		DashboardConfigFactory.loadInstance( request, null );
	}
	
	public void loadCall(PortletRequest request) throws ApplicationWorkFlowException {
		request.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( request ) );
		
		String serviceStatus = PortletProps.get("veteran.supplemental.serviceStatuses");
		if ( !serviceStatus.isEmpty() ){
			request.setAttribute("serviceStatus", serviceStatus.split(StringPool.COMMA) );
		}

		Map<String,Object> form = ResultMap.getForm (request);
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		
		Map<String,Integer> total = ResultMap.getResultTotalMap( request );
		Map<String,List<?>> results = ResultMap.getResultListMap( request );
		boolean newInstance = CaretStrPool.NEW.equals( request.getParameter(CaretStrPool.STATUS) ) ;
		
		long veteranId = 0;
		
		try {
			long callId = ParamUtil.getLong(request, CaretStrPool.CALL_ID, 0 );
			CaretViewController controller = CaretViewController.getViewController();
			if ( callId > 0 ){
				Call call = CallLocalServiceUtil.getCall( callId );
				if ( newInstance ) {
					call.setCallId(0);
					call.setWorkPrimaryKey(0);
				}
				if (!Toolbox.isEmpty(call.getCallbackPref())) {
					call.setCallbackPref(
							SocCachedReportUtil.getCallbackPref_12HourFormat(call.getCallbackPref())
					);
				}
				form.put( "call", call );
				
				Person caller = new Person(PersnLocalServiceUtil.getPersn( call.getCallerPersnId() ));
				form.put(CaretStrPool.CALLER_PERSN, caller );
				controller.loadAddress( caret, caller, CaretStrPool.CALLER_PERSN );
				
				if ( !newInstance ){
					//Start SOC
					String callerName = caller.getFirstName() +" "+caller.getLastName();
					form.put("callerName", callerName);
	
					loadSocAspects(request, form, call, callId);
					//End SOC
					
					//Start CESP
					loadCespAspects(request, form, call, callId);
					//End CESP
				}
				
				veteranId = call.getVeteranPersnId();
				Person person = new Person( PersnLocalServiceUtil.getPersn( veteranId ) );
				form.put(CaretStrPool.VETERAN_PERSN, person );
				controller.loadAddress( caret, person, CaretStrPool.VETERAN_PERSN );
			
				//enableSoc is only set on requests coming from SOCs Pending Queue or SOCs Pending Search
				//boolean enableSoc = !newInstance && call.getCreationDate().before( CaretParam.getSocDueDate() );
				boolean enableSoc = false;
				request.setAttribute("enableSoc", enableSoc );
				//request.setAttribute("expanded", enableSoc? "collapsed": "expanded" );
				request.setAttribute("expanded", "expanded");

				List<?> l = CaretLocalServiceUtil.getCallEvents( callId );
				results.put("callEvents", l);
				total.put("callEvents", l.size());

				request.setAttribute("isDisabled", call.getCallState() != null && call.getCallState().toLowerCase().contains(CaretStrPool.CALL_STATE_COMPLETE) );
//				request.setAttribute("isDisabled", call.getCallId() > 0);
				
				if ( call.getWorkPrimaryKey() > 0 ){
					WorIm workItem = WorImLocalServiceUtil.getWorIm( call.getWorkPrimaryKey() );
					form.put("workItem", workItem );
					if ( workItem != null && ( workItem.getUserId() > 0 || workItem.getCompletionBy() > 0 ) ){
						request.setAttribute("isDisabled", true);
						if ( workItem.getStatus() != null ){
							if ( ! workItem.getStatus().toLowerCase().contains("completed") ){
								request.setAttribute("dispositionCall", CAction.canDoCaret(request, CaretCan.DISPOSITION_CALLS.name() ) );
							}
						} else {
							request.setAttribute("dispositionCall", CAction.canDoCaret(request, CaretCan.DISPOSITION_CALLS.name() ) );
						}
					}
				}
				
				if ( StringPool.TRUE.equals( PortletProps.get("csl-lead-on-open")) && CAction.canDoCaret(request, CaretCan.CSL_FUNCTION) ){
					call.setUserId( CaretParam.setCaretServiceContext(request).getUserId() );
					CaretLocalServiceUtil.save(call);
				}
			} else {
				request.setAttribute("expanded", "expanded");
			}
			
			ResultMap.getCaretMap(request).put("noteContext", CaretStrPool.CALL);
			ResultMap.getCaretMap(request).put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
			loadCallSelects( request );
			loadMoreCallInfo ( request );
//			loadMoreReferralInfo ( request, veteranId );
			loadStatesAndFacilities( request );
			controller.loadRequiredInputs( CaretStrPool.CALL, form );
			
			request.setAttribute(CaretStrPool.ROLE, ((DashboardConfig)request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG)).getRole() );
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
	}
	public void loadNewCallUseExistingIdentities(PortletRequest request) throws ApplicationWorkFlowException {
		Map<String,Object> form = ResultMap.getForm (request);
		Call callExistingIdentity = null;
		long callIdExistingIdentity = 0;
		Object callIdO2 = null;
		try {
			callIdO2 = request.getParameter("selectedExistingCallId");
			//
			if (callIdO2 != null && callIdO2 instanceof String) {callIdExistingIdentity = Long.parseLong((String) callIdO2);}
			else if (callIdO2 != null && callIdO2 instanceof Integer) {callIdExistingIdentity = new Long(callIdO2 + "");}
			else if (callIdO2 != null && callIdO2 instanceof Long) {callIdExistingIdentity = ((Long) callIdO2).longValue();}
			if ( callIdExistingIdentity > 0 ){
				callExistingIdentity = CallLocalServiceUtil.getCall( callIdExistingIdentity );
			}
		}
		catch( Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}  
		request.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( request ) );
		String serviceStatus = PortletProps.get("veteran.supplemental.serviceStatuses");
		if ( !serviceStatus.isEmpty() ){
			request.setAttribute("serviceStatus", serviceStatus.split(StringPool.COMMA) );
		}
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		
		Map<String,Integer> total = ResultMap.getResultTotalMap( request );
		Map<String,List<?>> results = ResultMap.getResultListMap( request );
		boolean newInstance = true;
		
		long veteranId = 0;
		
		try {
			long callId = ParamUtil.getLong(request, CaretStrPool.CALL_ID, 0 );
			CaretViewController controller = CaretViewController.getViewController();
			if ( callIdExistingIdentity > 0){
				Person caller = new Person(PersnLocalServiceUtil.getPersn( callExistingIdentity.getCallerPersnId() ));
				form.put(CaretStrPool.CALLER_PERSN, caller );
				controller.loadAddress( caret, caller, CaretStrPool.CALLER_PERSN );
				String callerName = caller.getFirstName() + " " + caller.getLastName();
				form.put("callerName", callerName);
				veteranId = callExistingIdentity.getVeteranPersnId();
				Person person = new Person( PersnLocalServiceUtil.getPersn( veteranId ) );
				form.put(CaretStrPool.VETERAN_PERSN, person );
				controller.loadAddress( caret, person, CaretStrPool.VETERAN_PERSN );
				//enableSoc is only set on requests coming from SOCs Pending Queue or SOCs Pending Search
				request.setAttribute("enableSoc", false );
				request.setAttribute("expanded", "expanded");
				request.setAttribute("isDisabled", true );
				//if ( StringPool.TRUE.equals( PortletProps.get("csl-lead-on-open")) && CAction.canDoCaret(request, CaretCan.CSL_FUNCTION) ){
				//  call.setUserId( CaretParam.setCaretServiceContext(request).getUserId() );
				//  CaretLocalServiceUtil.save(call);
				//}
			} else {
				request.setAttribute("expanded", "expanded");
			}
			ResultMap.getCaretMap(request).put("noteContext", CaretStrPool.CALL);
			ResultMap.getCaretMap(request).put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
			loadCallSelects( request );
			loadMoreCallInfo ( request );
			loadStatesAndFacilities( request );
			controller.loadRequiredInputs( CaretStrPool.CALL, form );
			
			request.setAttribute(CaretStrPool.ROLE, ((DashboardConfig)request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG)).getRole() );
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}  
	
    public void loadExistingCall(PortletRequest request) throws ApplicationWorkFlowException {
    	Map<String,Object> form = ResultMap.getForm (request);
    	Call call = null;
    	long callId = 0;
    	Object callIdO = null;
    	try {
    		callIdO = Toolbox.getRegisteredValue(PortalUtil.getUserId(request) + "|" + "selectedCallId");
	    	if (callIdO != null && callIdO instanceof String) {callId = Long.parseLong((String) callIdO);}
	    	else if (callIdO != null && callIdO instanceof Integer) {callId = new Long(callIdO + "");}
	    	else if (callIdO != null && callIdO instanceof Long) {callId = ((Long) callIdO).longValue();}
	    	if ( callId > 0 ){
	    		call = CallLocalServiceUtil.getCall( callId );
	    	}
    	}
    	catch( Exception e) {
    		ApplicationWorkFlowException.handleException(e);
    	}  
    	request.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( request ) );
    	String serviceStatus = PortletProps.get("veteran.supplemental.serviceStatuses");
    	if ( !serviceStatus.isEmpty() ){
    		request.setAttribute("serviceStatus", serviceStatus.split(StringPool.COMMA) );
    	}
    	Map<String,Object> caret = ResultMap.getCaretMap(request);
    	Map<String,Integer> total = ResultMap.getResultTotalMap( request );
    	Map<String,List<?>> results = ResultMap.getResultListMap( request );
    	boolean newInstance = false;
    	long veteranId = 0;
    	try {
	    	CaretViewController controller = CaretViewController.getViewController();
	    	if ( callId > 0 ){
		    	form.put( "call", call );
		    	Person caller = new Person(PersnLocalServiceUtil.getPersn( call.getCallerPersnId() ));
		    	form.put(CaretStrPool.CALLER_PERSN, caller );
		    	controller.loadAddress( caret, caller, CaretStrPool.CALLER_PERSN );
		    	if ( !newInstance ){
		    		//Start SOC
			    	String callerName = caller.getFirstName() +" "+caller.getLastName();
			    	form.put("callerName", callerName);
			    	loadSocAspects(request, form, call, callId);
			    	//End SOC
			    	
			    	//Start CESP
			    	loadCespAspects(request, form, call, callId);
			    	//End CESP
		    	}
		    	veteranId = call.getVeteranPersnId();
		    	Person person = new Person( PersnLocalServiceUtil.getPersn( veteranId ) );
		    	form.put(CaretStrPool.VETERAN_PERSN, person );
		    	controller.loadAddress( caret, person, CaretStrPool.VETERAN_PERSN );
		    	_log.info("enableSoc: newInstance = " + newInstance );
		    	//enableSoc is only set on requests coming from SOCs Pending Queue or SOCs Pending Search
		    	//boolean enableSoc = !newInstance && call.getCreationDate().before( CaretParam.getSocDueDate() );
		    	boolean enableSoc = false;
		    	_log.info("enableSoc = " + enableSoc );
		    	request.setAttribute("enableSoc", enableSoc );
		    	request.setAttribute("expanded", "expanded");
		
		    	List<?> l = CaretLocalServiceUtil.getCallEvents( callId );
		    	results.put("callEvents", l);
		    	total.put("callEvents", l.size());
		
		    	request.setAttribute("isDisabled", call.getCallState() != null && call.getCallState().toLowerCase().contains(CaretStrPool.CALL_STATE_COMPLETE) );
		    	
		    	if ( call.getWorkPrimaryKey() > 0 ){
			    	WorIm workItem = WorImLocalServiceUtil.getWorIm( call.getWorkPrimaryKey() );
			    	form.put("workItem", workItem );
			    	if ( workItem != null && ( workItem.getUserId() > 0 || workItem.getCompletionBy() > 0 ) ){
				    	request.setAttribute("isDisabled", true);
				    	if ( workItem.getStatus() != null ){
					    	if ( ! workItem.getStatus().toLowerCase().contains("completed") ){
					    		request.setAttribute("dispositionCall", CAction.canDoCaret(request, CaretCan.DISPOSITION_CALLS.name() ) );
					    	}
				    	} else {
				    		request.setAttribute("dispositionCall", CAction.canDoCaret(request, CaretCan.DISPOSITION_CALLS.name() ) );
				    	}
			    	}
		    	}
		    	if ( StringPool.TRUE.equals( PortletProps.get("csl-lead-on-open")) && CAction.canDoCaret(request, CaretCan.CSL_FUNCTION) ){
		    		call.setUserId( CaretParam.setCaretServiceContext(request).getUserId() );
		    		CaretLocalServiceUtil.save(call);
		    	}
	    	} else {
	    		request.setAttribute("expanded", "expanded");
	    	}
	    	
	    	ResultMap.getCaretMap(request).put("noteContext", CaretStrPool.CALL);
	    	ResultMap.getCaretMap(request).put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
	    	loadCallSelects( request );
	    	loadMoreCallInfo ( request );
	    	loadStatesAndFacilities( request );
	    	controller.loadRequiredInputs( CaretStrPool.CALL, form );
	    	
	    	request.setAttribute(CaretStrPool.ROLE, ((DashboardConfig)request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG)).getRole() );
    	} catch (Exception e) {
    		ApplicationWorkFlowException.handleException(e);
    	}
    }
	public void loadCallFromSocView(PortletRequest request) throws ApplicationWorkFlowException {
		Map<String,Object> form = ResultMap.getForm (request);
		ClSoc clSoc = null;
		Call call = null;
		long callId = 0;
		try {
			String viewSocReturnUrl = ParamUtil.getString(request, "viewSocReturnUrl");
			long clSocId = ParamUtil.getLong(request, "socId", 0 );
			if ( clSocId > 0 ){
				clSoc = ClSocLocalServiceUtil.getClSoc(clSocId);
				callId = clSoc.getCallId();
				if ( callId > 0 ){
					call = CallLocalServiceUtil.getCall( callId );
				};  
			}
		}
		catch( Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}  
		request.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( request ) );
		String serviceStatus = PortletProps.get("veteran.supplemental.serviceStatuses");
		if ( !serviceStatus.isEmpty() ){
			request.setAttribute("serviceStatus", serviceStatus.split(StringPool.COMMA) );
		}
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		Map<String,Integer> total = ResultMap.getResultTotalMap( request );
		Map<String,List<?>> results = ResultMap.getResultListMap( request );
		boolean newInstance = false;
		long veteranId = 0;
		try {
			CaretViewController controller = CaretViewController.getViewController();
			if ( callId > 0 ){
			form.put( "call", call );
			Person caller = new Person(PersnLocalServiceUtil.getPersn( call.getCallerPersnId() ));
			form.put(CaretStrPool.CALLER_PERSN, caller );
			controller.loadAddress( caret, caller, CaretStrPool.CALLER_PERSN );
			if ( !newInstance ){
				//Start SOC
				String callerName = caller.getFirstName() +" "+caller.getLastName();
				form.put("callerName", callerName);
				loadSocAspects(request, form, call, callId);
				//End SOC
				//Start CESP
				loadCespAspects(request, form, call, callId);
				//End CESP
			}
			veteranId = call.getVeteranPersnId();
			Person person = new Person( PersnLocalServiceUtil.getPersn( veteranId ) );
			form.put(CaretStrPool.VETERAN_PERSN, person );
			controller.loadAddress( caret, person, CaretStrPool.VETERAN_PERSN );
			_log.info("enableSoc: newInstance = " + newInstance );
			//enableSoc is only set on requests coming from SOCs Pending Queue or SOCs Pending Search
			//boolean enableSoc = !newInstance && call.getCreationDate().before( CaretParam.getSocDueDate() );
			boolean enableSoc = false;
			_log.info("enableSoc = " + enableSoc );
			request.setAttribute("enableSoc", enableSoc );
			request.setAttribute("expanded", "expanded");
	
			List<?> l = CaretLocalServiceUtil.getCallEvents( callId );
			results.put("callEvents", l);
			total.put("callEvents", l.size());
	
			request.setAttribute("isDisabled", call.getCallState() != null && call.getCallState().toLowerCase().contains(CaretStrPool.CALL_STATE_COMPLETE) );
			if ( call.getWorkPrimaryKey() > 0 ){
				WorIm workItem = WorImLocalServiceUtil.getWorIm( call.getWorkPrimaryKey() );
				form.put("workItem", workItem );
				if ( workItem != null && ( workItem.getUserId() > 0 || workItem.getCompletionBy() > 0 ) ){
					request.setAttribute("isDisabled", true);
					if ( workItem.getStatus() != null ){
						if ( ! workItem.getStatus().toLowerCase().contains("completed") ){
						request.setAttribute("dispositionCall", CAction.canDoCaret(request, CaretCan.DISPOSITION_CALLS.name() ) );
						}
					} else {
					request.setAttribute("dispositionCall", CAction.canDoCaret(request, CaretCan.DISPOSITION_CALLS.name() ) );
					}
				}
			}
			if ( StringPool.TRUE.equals( PortletProps.get("csl-lead-on-open")) && CAction.canDoCaret(request, CaretCan.CSL_FUNCTION) ){
				call.setUserId( CaretParam.setCaretServiceContext(request).getUserId() );
				CaretLocalServiceUtil.save(call);
			}
			} else {
				request.setAttribute("expanded", "expanded");
			}
			ResultMap.getCaretMap(request).put("noteContext", CaretStrPool.CALL);
			ResultMap.getCaretMap(request).put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
			loadCallSelects( request );
			loadMoreCallInfo ( request );
			loadStatesAndFacilities( request );
			controller.loadRequiredInputs( CaretStrPool.CALL, form );
			request.setAttribute(CaretStrPool.ROLE, ((DashboardConfig)request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG)).getRole() );
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}  
	public void loadCallAndSoc(PortletRequest request) throws ApplicationWorkFlowException {
		Map<String,Object> form = ResultMap.getForm (request);
		ClSoc clSoc = null;
		Call call = null;
		try {
			String viewSocReturnUrl = ParamUtil.getString(request, "viewSocReturnUrl");
			long clSocId = ParamUtil.getLong(request, "socId", 0 );
			if ( clSocId > 0 ){
				clSoc = ClSocLocalServiceUtil.getClSoc(clSocId);
				long callId = clSoc.getCallId();
				if ( callId > 0 ){
					call = CallLocalServiceUtil.getCall( callId );
				}
				loadSocViewAspects(request, form, call, clSoc);	 
			}
		}
		catch( Exception e) {
		ApplicationWorkFlowException.handleException(e);
		}
	} 	
	public String initiateLetter(ActionRequest request, ActionResponse response) {
		PopulateLettersImpl populateLettersImpl = new PopulateLettersImpl();
		try {
			Boolean fromOcc = ParamUtil.getBoolean(request, "fromOcc");
			response.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.LOAD_LETTER_PAGE);
			  
			long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
			long vcgId = ParamUtil.getLong( request, CaretStrPool.VCGID );
			if ( vcgId == 0 ) {
				vcgId = (Long) request.getAttribute(CaretStrPool.VCGID);
			}
			VcgAn vcgAn =  VcgAnLocalServiceUtil.getRecent(vcgId);
			Long vcgAnId = vcgAn.getVcgAnId();
			request.setAttribute(CaretStrPool.WORK_ID, worImId);
			request.setAttribute(CaretStrPool.VCGID, vcgId);
			
			//List<Letter> allLetters = new ArrayList<Letter>();
			//allLetters.addAll();
			
			Map<Long, Letter> allLetters = new HashMap<Long, Letter>();
			List<Docum> allLetterDocums = DocumLocalServiceUtil.getByClass(vcgAnId, PortalUtil.getClassNameId(VcgAn.class), fromOcc?FileType.OCC_Letter.name():FileType.CSC_Letter.name());
			
			for (Iterator<Docum> iter = allLetterDocums.iterator(); iter.hasNext();) {
				Docum docum = iter.next();
				allLetters.put(docum.getDocumId(), LetterLocalServiceUtil.getByDocumId(docum.getDocumId()).get(0));
			}
			request.setAttribute("allLetterDocums", allLetterDocums);
			request.setAttribute("allLetters", allLetters);
			
			if (fromOcc) {
				OccLetterType[] occLetterTypes = OccLetterType.values();
				Arrays.sort(occLetterTypes, new Comparator<OccLetterType>() {
					 public int compare(OccLetterType s1, OccLetterType s2) {
					        return s1.toString().compareToIgnoreCase(s2.toString());
					    }
				});
				request.setAttribute(CaretStrPool.OCC_LETTER_NAMES, Arrays.asList(occLetterTypes));
			} else {
				CscLetterType[] cscLetterTypes = CscLetterType.values();
				Arrays.sort(cscLetterTypes, new Comparator<CscLetterType>() {
					 public int compare(CscLetterType s1, CscLetterType s2) {
					        return s1.toString().compareToIgnoreCase(s2.toString());
					    }
				});
				request.setAttribute(CaretStrPool.CSC_LETTER_NAMES, Arrays.asList(cscLetterTypes));
			}
			request.setAttribute("recipients", populateLettersImpl.getLetterRecipients(request));
			request.setAttribute("fromOcc", fromOcc);
			_log.info("Number of letters docs is : "+allLetters.size());
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			} 
			
			return StringPool.BLANK;
	}
	
	@ProcessAction (name="sendLetter")
	public void sendLetter( ActionRequest actionRequest, ActionResponse actionResponse ) throws IOException {
	    String letterName = actionRequest.getParameter(CaretStrPool.SEND_LETTER_NAME);
	    Boolean veteranRecipient = ParamUtil.getBoolean(actionRequest, "veteranRecipient");
		Boolean primaryCGRecipient = ParamUtil.getBoolean(actionRequest, "primaryCGRecipient");
	    Boolean secondaryCGRecipient = ParamUtil.getBoolean(actionRequest, "secondaryCGRecipient");
	    Boolean secondaryTwoCGRecipient = ParamUtil.getBoolean(actionRequest, "secondaryTwoCGRecipient");
	    PopulateLettersImpl populateLettersImpl = new PopulateLettersImpl();
	    Boolean fromOcc = ParamUtil.getBoolean(actionRequest, "fromOcc");
		
	    populateLettersImpl.generateAndPopulatePDFWithEditedContent(actionRequest, letterName, false);
		//update if existing pdf or save if new pdf
		if ( letterName != null && !letterName.isEmpty() ) {
			try {
				String type = fromOcc?FileType.OCC_Letter.name():FileType.CSC_Letter.name();
				long vcgId = ParamUtil.getLong( actionRequest, CaretStrPool.VCGID );
				String recipients = "";
				VcgAn vcgAn;
				vcgAn = VcgAnLocalServiceUtil.getRecent(vcgId);
				Long vcgAnId = vcgAn.getVcgAnId();
				
				String note = "Letter document added";
				AttachmentBean attachment = new AttachmentBean();
				attachment.setClassPk(vcgAnId);
				attachment.setClassId(PortalUtil.getClassNameId(VcgAn.class));
				attachment.setType(type);
				attachment.setName(letterName);
				Long documId = handleLettersDocument( actionRequest, attachment, note);
				
				Map<String, String> recepientMap = populateLettersImpl.getLetterRecipients(actionRequest);
				Letter letter = LetterLocalServiceUtil.createLetter(CounterLocalServiceUtil.increment(Letter.class.getName()));
				letter.setClassPk(vcgAnId);
				letter.setClassId(PortalUtil.getClassNameId(VcgAn.class));
				letter.setName(letterName + ".pdf");
				letter.setType(type);
				letter.setSentDate(new Date());
				letter.setDocumId(documId);
				Boolean first = true;
				if (veteranRecipient) {
					recipients =  recepientMap.get(CaretStrPool.PERSON_CATEGORY_VETERAN);
					first = false;
				} if (primaryCGRecipient) {
					if (first == false) {
						recipients =  recipients + ", ";
					}
					recipients =  recipients + recepientMap.get(CaretStrPool.PERSON_CATEGORY_PRIMARY);
					first = false;
				} if (secondaryCGRecipient) {
					if (first == false) {
						recipients =  recipients + ", ";
					}
					recipients =  recipients + recepientMap.get(CaretStrPool.PERSON_CATEGORY_SECONDARY);
					first = false;
				} if (secondaryTwoCGRecipient) {
					if (first == false) {
						recipients =  recipients + ", ";
					}
					recipients =  recipients + recepientMap.get(CaretStrPool.PERSON_CATEGORY_SECONDARYTWO);
					first = false;
				} 
				letter.setRecepients(recipients);
				LetterLocalServiceUtil.addLetter(letter);
				ServiceContext sc = CaretParam.setCaretServiceContext(actionRequest);
				String comment = "Letter sent";
				CaretLocalServiceUtil.addNote(CaretUtil.createNote(sc.getCreateDate(), vcgId,
						NoteSupport.NoteGroup.LETTER_NOTE.groupId(), sc.getUserId(), comment));
				
				
			} catch (ApplicationWorkFlowException | SystemException e) {
				e.printStackTrace();
			}
		}
		initiateLetter(actionRequest, actionResponse);
	}
	
	//Saves letter document to DB
	public long handleLettersDocument( ActionRequest actionRequest, AttachmentBean attachment, String note) {
		
		try {
			String name = (String) actionRequest.getAttribute(CaretStrPool.LETTER_FILE);
			File uploadFile = new File( PortletProps.get(CaretStrPool.FILE_TEMP_STORE) + name );
			InputStream inputStream = new FileInputStream( uploadFile );
			OutputBlob outputBlob = new OutputBlob ( inputStream, uploadFile.length() );
			long documId = CounterLocalServiceUtil.increment( Docum.class.getName() );
			Docum document = DocumLocalServiceUtil.createDocum(documId);
			document.setDocument(outputBlob);
			document.setDeleted(false);
			document.setClassPk( attachment.getClassPk() );
			document.setClassId( attachment.getClassId() );
			document.setType(attachment.getType());
			document.setName(name);
			document.setNote(new Date().toString() + "," + note);
			DocumLocalServiceUtil.addDocum( document );
			actionRequest.getPortletSession().removeAttribute(CaretStrPool.LETTER_FILE);
			FileUtil.delete(uploadFile);
			return document.getDocumId();
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return 0;
	}
		
	private void loadSocAspects(PortletRequest request, Map<String,Object> form, Call call, long callId) throws PortalException, SystemException {
		form.put("callDate", Toolbox.formatDateCprs( call.getCreationDate() ) );
		long loggedPersnId = CaretParam.getPersnId(request);
		Person loggedUser = new Person ( PersnLocalServiceUtil.getPersn( loggedPersnId ) );
		form.put("loggedPersnId", loggedPersnId );
		form.put("loggedUserName", loggedUser.getFirstName() +" "+ loggedUser.getLastName() );
		List<ClSoc> socList = ClSocLocalServiceUtil.findByCallId(callId);

		//int attemptNum = socList.size()+1;
		//form.put("attemptNum", attemptNum);
		int numOfSoc = socList.size();
		form.put("numOfSoc", numOfSoc);
		if(numOfSoc > 0){
			boolean enableViewSoc = false;
			_log.info("enableViewSoc = " + enableViewSoc );
			request.setAttribute("enableViewSoc", enableViewSoc );
			//
			List<Map<String,String>> socHistory = new ArrayList<Map<String,String>>();
			Map<String,String> map = null;
			//for(ClSoc oneSoc : socList){
				ClSoc oneSoc = socList.get(socList.size() - 1);
				map = new HashMap<String,String>();
				map.put("clSocId", oneSoc.getClSocId() + "");
				map.put("attempNum", oneSoc.getAttemptNum());
				map.put("tresholdMet", oneSoc.getTresholdMet());
				map.put("date", Toolbox.formatDateTimeMetadata(oneSoc.getCreationDate()));
				Person createdByPersn = new Person ( PersnLocalServiceUtil.getPersn( oneSoc.getPersnId() ) );
				String name = createdByPersn.getFirstName()+" "+createdByPersn.getLastName();
				map.put("name", name);
				socHistory.add(map); 
			//}
			form.put("soc-history", socHistory);
		}  
	}
	
	private void loadSocViewAspects(PortletRequest request, Map<String,Object> form, Call call, ClSoc clSoc) throws PortalException, SystemException {
		_log.info("MAction debug....CaretActionCommand.loadSocViewAspects...start");
		if (request != null && form != null && call != null && clSoc != null) {
		form.put("callDate", Toolbox.formatDateCprs( call.getCreationDate() ) );
			long loggedPersnId = CaretParam.getPersnId(request);
			Person loggedUser = new Person ( PersnLocalServiceUtil.getPersn( loggedPersnId ) );
			form.put("loggedPersnId", loggedPersnId );
			form.put("loggedUserName", loggedUser.getFirstName() +" "+ loggedUser.getLastName() );
			//  
			Map<String,String> viewMap = null;
			viewMap = new HashMap<String,String>();
			viewMap.put("primaryKey",clSoc.getPrimaryKey() + "");
			viewMap.put("clSocId",clSoc.getClSocId() + "");
			viewMap.put("callId",clSoc.getCallId() + "");
			viewMap.put("persnId",clSoc.getPersnId() + "");
			viewMap.put("surveyStatus",clSoc.getSurveyStatus() + "");
			viewMap.put("surveyComment",clSoc.getSurveyComment() + "");
			viewMap.put("creationDate",clSoc.getCreationDate() + "");
			viewMap.put("attemptNum",clSoc.getAttemptNum() + "");
			viewMap.put("callerAvailable",clSoc.getCallerAvailable() + "");
			viewMap.put("willingToAnsQues",clSoc.getWillingToAnsQues() + "");
			viewMap.put("calledCsl",clSoc.getCalledCsl() + "");
			viewMap.put("cslKnowledgable",clSoc.getCslKnowledgable() + "");
			viewMap.put("cslSupportive",clSoc.getCslSupportive() + "");
			viewMap.put("localResSuggested",clSoc.getLocalResSuggested() + "");
			viewMap.put("localResContacted",clSoc.getLocalResContacted() + "");
			viewMap.put("rsnLocalResNotContacted",clSoc.getRsnLocalResNotContacted() + "");
			viewMap.put("localResHelpful",clSoc.getLocalResHelpful() + "");
			viewMap.put("concernsAnswered",clSoc.getConcernsAnswered() + "");
			viewMap.put("understandNextSteps",clSoc.getUnderstandNextSteps() + "");
			viewMap.put("callCslAgain",clSoc.getCallCslAgain() + "");
			viewMap.put("recommendCsl",clSoc.getRecommendCsl() + "");
			viewMap.put("suggestions",clSoc.getSuggestions() + "");
			viewMap.put("followupCall",clSoc.getFollowupCall() + "");
			viewMap.put("completed",Toolbox.fromBoolToYesNo(clSoc.getCompleted()));
			//viewMap.put("requestedCallbackTime",clSoc.getRequestedCallbackTime() + "");
			viewMap.put("requestedCallbackTime", clSoc.getFollowupCallTime() + "; " + clSoc.getRequestedCallbackTime());
			viewMap.put("tresholdMet",clSoc.getTresholdMet() + "");
			viewMap.put("date", Toolbox.formatDateCprs(clSoc.getCreationDate()));
			Person cslPersn = new Person ( PersnLocalServiceUtil.getPersn( clSoc.getPersnId() ) );
			String cslName = cslPersn.getFirstName()+" "+ cslPersn.getLastName();
			viewMap.put("cslName", cslName);
			Person callerPersn = new Person( PersnLocalServiceUtil.getPersn(call.getCallerPersnId()));
			String callerName = callerPersn.getFirstName() + " " + callerPersn.getLastName();
			String callerPhone = callerPersn.getPhone() + " " + callerPersn.getPhone2();
			viewMap.put("callerName", callerName);
			viewMap.put("callerPhone", callerPhone);
			Person veteranPersn = new Person( PersnLocalServiceUtil.getPersn(call.getVeteranPersnId()));
			String veteranName = veteranPersn.getFirstName() + " " + veteranPersn.getLastName();
			String veteranPhone = veteranPersn.getPhone() + " " + veteranPersn.getPhone2();
			viewMap.put("veteranName", veteranName);
			viewMap.put("veteranPhone", veteranPhone);
			//_log.info("MAction debug....viewMap: " + viewMap.toString());
			form.put("view-soc",viewMap);
		}
	} 

	private void loadCespAspects(PortletRequest request, Map<String,Object> form, Call call, long callId) throws PortalException, SystemException {
		
		long loggedPersnId = CaretParam.getPersnId(request);
		form.put("loggedPersnId", loggedPersnId );

		//check if there are any cesp for the call
		List<Cesp> cespList = CespLocalServiceUtil.findByCallId(callId);	
		int numOfCesp = cespList.size();
		form.put("numOfCesp", numOfCesp);
		
		String cespStatus = StringPool.BLANK;

		if(numOfCesp > 0){
			form.put("step", CaretStrPool.CESP_STEP2);
				 
			List<CespBean> cespHistory = new ArrayList<CespBean>();
			for(Cesp oneCesp : cespList){
				Person createdByPersn = new Person ( PersnLocalServiceUtil.getPersn( oneCesp.getCreatedByPersnId() ) );
				String name = createdByPersn.getFirstName()+" "+createdByPersn.getLastName();

				CespBean oneBean = new CespBean();
				oneBean.setCesp(oneCesp);
				oneBean.setFormattedCreatedDate(Toolbox.formatDateTimeMetadata(oneCesp.getCreationDate()));
				oneBean.setCespCreatedByName(name);
				cespHistory.add(oneBean);	
				
				if(oneCesp.getStatus().equals(CaretStrPool.CESP_STATUS_CLOSED)){
					cespStatus = "closed";
				}
			}
			form.put("cesp-history", cespHistory);
		}else{
			form.put("step", CaretStrPool.CESP_STEP1);
		}

		form.put("cespStatus", cespStatus);
	}
	
	
	@ProcessAction (name="loadEntry")
	public void loadEntry( ActionRequest actionRequest, ActionResponse actionResponse ) {
		String entry = ParamUtil.get(actionRequest, "entry", StringPool.BLANK);
		_log.info("loadEntry..." +  entry );
//		actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/internal/"+ action + ".jsp" );
//		_log.info("action..." +  entry );
		try{
			if ( CaretStrPool.CREATE_REFERRAL.equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_REFERRAL.name() ) ){
					boolean isCallReferral = loadReferral(actionRequest);
					if ( isCallReferral ){
						actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_CALL_PAGE);
					} else {
						actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_REFERRAL_PAGE);
					}
				}
			} else if ( "MANAGE_VCG".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.MANAGE_VCG.name() ) ){
					loadVcgManagement (actionRequest, actionResponse);
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.VCG_MANAGEMENT_PAGE);
				}
			} else if ( CaretStrPool.CREATE_CALLS.equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_CALLS.name() ) ){
					loadCall (actionRequest);
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_CALL_PAGE);
				}
			} else if ( "CREATE_CALL_TYPE".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_CALL_TYPE.name() ) ){
					loadCallType (actionRequest);
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.ADD_CALLTYPE_PAGE);
				}
			}  else if ( "load-new-call-existing-ident".equals(entry) ){
				this.loadNewCallUseExistingIdentities(actionRequest);
				actionRequest.setAttribute("enableSoc", false);
				actionRequest.setAttribute("isDisabled", false);
				actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_CALL_PAGE); 
				
			}  else if ( "view-existing-call".equals(entry) ){
				loadExistingCall (actionRequest);
				actionRequest.setAttribute("enableSoc", false);
				actionRequest.setAttribute("isDisabled", true);
				actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_CALL_PAGE);
			} else if ( "soc".equals(entry) ){
				_log.info("loadEntry for 'soc'");
				String socSource = actionRequest.getParameter("socSource");
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_SOC.name() ) ){
				loadCall (actionRequest);
				//enableSoc is only set on requests coming from SOCs Pending Queue or SOCs Pending Search
				actionRequest.setAttribute("enableSoc", true);
				actionRequest.setAttribute("isDisabled", true);
				if (socSource.equalsIgnoreCase("groupSocActions")) {
					actionRequest.setAttribute("socSourceResponse", "searchOrQueue");
				}
				actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_CALL_PAGE);
				//  loadLetter(actionRequest);
				}
			} else if ( "view-soc".equals(entry) ){
				//if ( CAction.canDoCaret(actionRequest, CaretCan.VIEW_SOC.name() ) ){
				loadCallAndSoc (actionRequest);
				//enableSoc is only set on requests coming from SOCs Pending Queue or SOCs Pending Search
				//actionRequest.setAttribute("enableViewSoc", true);
				actionRequest.setAttribute("enableSoc", false);
				actionRequest.setAttribute("myHiddenVS", true);
				actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/internal/myViewSoc.jsp");
				//}
			} else if ( "view-soc-return".equals(entry) ){
				loadCallFromSocView (actionRequest);
				actionRequest.setAttribute("enableSoc", true);
				actionRequest.setAttribute("isDisabled", true);
				actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_CALL_PAGE);
				 
			} else if ( "cesp".equals(entry) ){

				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_CESP.name() ) ){
					loadCall (actionRequest);
					actionRequest.setAttribute("enableCesp", true);
					actionRequest.setAttribute("isDisabled", true);
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_CALL_PAGE);
					//			loadLetter(actionRequest);
				}
			} else if ( "cbopcWork".equals(entry) ){
				
			} else if ( "CREATE_VCG".equals(entry) || "SET_GENERAL_CG".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_VCG.name() ) ){
					ResultMap.getForm(actionRequest).put("veteranRequired", Collections.singletonMap("lastTreatmentPlace", "hidden-element"));
					long veteranId = ParamUtil.getLong(actionRequest, CaretStrPool.VETERAN_ID );
					if ( veteranId > 0 ){
						Persn person;
						try {
							person = PersnLocalServiceUtil.getPersn(veteranId);
							ResultMap.getForm(actionRequest).put(CaretStrPool.LASTNAME, new Person(person));
						} catch (PortalException e) {
							ApplicationWorkFlowException.handleException(e);
						} catch (SystemException e) {
							ApplicationWorkFlowException.handleException(e);
						}
					}
					ResultMap.getForm(actionRequest).put("associate", ParamUtil.getBoolean(actionRequest, "associate"));
					if ( ParamUtil.getLong(actionRequest, "worImId") > 0 ){
						try {
							ResultMap.getForm(actionRequest).put("workItem", 
									new WorkItemSupport ( WorImLocalServiceUtil.getWorIm( ParamUtil.getLong(actionRequest, "worImId") ) ) ); 
						} catch (PortalException e1) {
							ApplicationWorkFlowException.handleException(e1);
						} catch (SystemException e1) {
							ApplicationWorkFlowException.handleException(e1);
						}
					}
					actionRequest.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( actionRequest ) );

					Map<String, Object> caret = ResultMap.getCaretMap(actionRequest);
					if ( actionRequest.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG) instanceof FacilityDashboardConfig ) {
						caret.put( CaretStrPool.VHA_MEMBER, CaretUtil.getVhaOrgList( actionRequest ) );
						try {
							caret.put(CaretStrPool.STATES, RegionServiceUtil.getRegions( CountryConstants.DEFAULT_COUNTRY_ID ) );
						} catch (SystemException e) {
							ApplicationWorkFlowException.handleException(e);
						}
						caret.put( CaretStrPool.VHA_ORGTREE, false );
					} else {
						loadStatesAndFacilities( actionRequest );
						caret.put( CaretStrPool.VHA_ORGTREE , true );
					}
					//TODO: required attributes...
					
					CaretViewController.getViewController().loadRequiredInputs( CaretStrPool.NEW_VCG_VETERAN_FORM, ResultMap.getForm(actionRequest) ) ;
					
					caret.put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.CREATE_VCG_PAGE );
					//			loadLetter(actionRequest);
				}
	//			loadCbopcWork(actionRequest);
			} else if ( "ASSOCIATE_CALLS".equals(entry) || "ASSOCIATE_REFERRAL".equals(entry)){
				boolean isReferral =  "ASSOCIATE_REFERRAL".equals(entry) ? true : false;
				boolean canDoCaret = isReferral ?
						CAction.canDoCaret(actionRequest, CaretCan.ASSOCIATE_REFERRAL.name()) :
						CAction.canDoCaret(actionRequest, CaretCan.ASSOCIATE_CALLS.name());
				_log.info("ASSOCIATE CALLS: isReferral: " + isReferral);
				_log.info("ASSOCIATE CALLS: canDoCaret: " + canDoCaret);
				if ( canDoCaret ){
					ResultMap.getForm(actionRequest).put("veteranRequired", Collections.singletonMap("lastTreatmentPlace", "hidden-element"));

					long veteranId = 0;
					long worImId = 0;
					long primaryKey = 0;
					long vcgId = 0;					
					long callId = ParamUtil.getLong(actionRequest, "callId" );
					boolean associate = ParamUtil.getBoolean(actionRequest, "associate");
					//
					Call call = null;
					Persn person = null;
					WorIm workItem = null;
					WorIm workItem2 = null;
					//
					if (veteranId == 0 && callId > 0) {
						try {call = CallLocalServiceUtil.getCall(callId);}
						catch(Exception e) {ApplicationWorkFlowException.handleException(e);}
						if (call != null) {veteranId = call.getVeteranPersnId();}
					}
					if ( veteranId > 0 ){
						try {
							person = PersnLocalServiceUtil.getPersn(veteranId);
							ResultMap.getForm(actionRequest).put(CaretStrPool.LASTNAME, new Person(person));
						} catch (PortalException e) {
							ApplicationWorkFlowException.handleException(e);
						} catch (SystemException e) {
							ApplicationWorkFlowException.handleException(e);
						}
					}
					//
					if (call != null && call.getWorkPrimaryKey() > 0) {worImId = call.getWorkPrimaryKey();}
					//
					if (worImId == 0) {
						ServiceContext sc = CaretParam.setCaretServiceContext(actionRequest);
						DashboardConfig dashConfig = ( DashboardConfig ) actionRequest.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG );
						WorkType workType;
						if ( dashConfig instanceof CslDashboardConfig ){
							workType = isReferral ? WorkType.CSL_REFERRAL : WorkType.CALL_REFERRAL;
						} else {
							try{
								workType = WorkType.valueOf( dashConfig.getRole() + "_REFERRAL");
							} catch(Exception e){
								workType = WorkType.REFERRAL;
							}
						}
						workItem = CaretUtil.createWorkItem(sc, person.getGroupId(), call, workType, veteranId, call.getCallerPersnId() );

						try {
							workItem2 = WorImLocalServiceUtil.updateWorIm(workItem);
						}
						catch(Exception e) {
							ApplicationWorkFlowException.handleException(e);
						}
						List<WorIm> list = (List<WorIm>) WorImLocalServiceUtil.findByClassPk(callId);
						if (list.size() > 0) {
							workItem2 = list.get(0);
						}
						worImId = workItem2.getWorImId();
						if (worImId > 0) {
							call.setWorkPrimaryKey(worImId);
							try {CallLocalServiceUtil.updateCall(call);}
							catch(Exception e) {ApplicationWorkFlowException.handleException(e);}
						}
					}
					//
					ResultMap.getForm(actionRequest).put("associate", associate);
					if ( worImId > 0 ){
						try {
							ResultMap.getForm(actionRequest).put("workItem", 
							new WorkItemSupport ( WorImLocalServiceUtil.getWorIm( worImId ) ) ); 
						} catch (PortalException e1) {
							ApplicationWorkFlowException.handleException(e1);
						} catch (SystemException e1) {
							ApplicationWorkFlowException.handleException(e1);
						}
					}
					actionRequest.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( actionRequest ) );

					Map caret = ResultMap.getCaretMap(actionRequest);
					if ( actionRequest.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG) instanceof FacilityDashboardConfig ) {
						caret.put( CaretStrPool.VHA_MEMBER, CaretUtil.getVhaOrgList( actionRequest ) );
						try {
							caret.put(CaretStrPool.STATES, RegionServiceUtil.getRegions( CountryConstants.DEFAULT_COUNTRY_ID ) );
						} catch (SystemException e) {
							ApplicationWorkFlowException.handleException(e);
						}
						caret.put( CaretStrPool.VHA_ORGTREE, false );
					} else {
						loadStatesAndFacilities( actionRequest );
						caret.put( CaretStrPool.VHA_ORGTREE , true );
					}
					//TODO: required attributes...
					CaretViewController.getViewController().loadRequiredInputs( CaretStrPool.NEW_VCG_VETERAN_FORM, ResultMap.getForm(actionRequest) ) ;
					
					caret.put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.CREATE_VCG_PAGE );
					//  loadLetter(actionRequest);
				}
				//  loadCbopcWork(actionRequest); 

			} else if ( "LOAD_1010_APPLICATION".equals(entry) ){
//				long worImId = ParamUtil.getLong(actionRequest, CaretStrPool.WORK_ID);
//				try {
//					WorkItemSupport workItem = new WorkItemSupport( WorImLocalServiceUtil.getWorIm( worImId ) );
//					VcgSupport vcg = VcgSupport.getVcgSupport( workItem.getVcgId() );
//					VcgApplication vcgAn = new VcgApplication( vcg.getPersonVcgAn( workItem.getCaregiverId() ) );
//					Person veteran = new Veteran( PersnLocalServiceUtil.getPersn( vcgAn.getVeteranId() ) );
//					ResultMap.getForm( actionRequest ).put( CaretStrPool.VETERAN_PERSN, veteran );
//					CaretViewController.getViewController().loadAddress( ResultMap.getCaretMap(actionRequest), veteran, CaretStrPool.VETERAN_PERSN );
//					
//					actionRequest.setAttribute("isDisabled", true);
//					
//					Person primary = new Primary( PersnLocalServiceUtil.getPersn( vcgAn.getPrimaryId() ) );
//					CaretViewController.getViewController().loadAddress( ResultMap.getCaretMap(actionRequest), primary, CaretStrPool.PRIMARY_PERSN );
//					ResultMap.getForm( actionRequest ).put( CaretStrPool.PRIMARY_PERSN, primary );
//					ResultMap.getForm( actionRequest ).put( CaretStrPool.VCGAN, vcgAn );
//					//TODO: Work in progress...
//					_log.info( vcgAn.getComments() ) ;
//					_log.info( vcgAn.getApplicationDate() );
//					_log.info( vcgAn.getPrimarySignDate() == null? "CSC FORM" : "ONLINE FORM");
//					actionRequest.setAttribute ( "vcgAn", vcgAn );
//					loadRelationshipLists(actionRequest);
//					actionRequest.setAttribute("REFERRAL_1010", DocumLocalServiceUtil.getAppByOwnerId( vcgAn.getPrimaryKey() ) ); 
//					
//					if ( vcgAn.getSecondaryId() > 0 ){
//						ResultMap.getForm( actionRequest ).put( CaretStrPool.SECONDARY_PERSN, new Person( PersnLocalServiceUtil.getPersn( vcgAn.getSecondaryId() ) ) );
//						vcgAn.getSecondaryRelationship();
//					}
//					if ( vcgAn.getSecondaryTwoId() > 0 ){
//						ResultMap.getForm( actionRequest ).put( CaretStrPool.SECONDARY_TWO_PERSN, new Person( PersnLocalServiceUtil.getPersn( vcgAn.getSecondaryTwoId() ) ) );
//						vcgAn.getSecondaryTwoRelationship();
//					}
//					Map<String, Object> caret = ResultMap.getCaretMap(actionRequest);
//					if ( actionRequest.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG) instanceof FacilityDashboardConfig ) {
//						caret.put( CaretStrPool.VHA_MEMBER, CaretUtil.getVhaOrgList( actionRequest ) );
//						try {
//							caret.put(CaretStrPool.STATES, RegionServiceUtil.getRegions( CountryConstants.DEFAULT_COUNTRY_ID ) );
//						} catch (SystemException e) {
//							ApplicationWorkFlowException.handleException(e);
//						}
//						caret.put( CaretStrPool.VHA_ORGTREE, false );
//					} else {
//						loadStatesAndFacilities( actionRequest );
//						caret.put( CaretStrPool.VHA_ORGTREE , true );
//					}
//					//TODO: required attributes...
//					
//					caret.put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
//					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.CREATE_APPLICATION_PAGE );
//				} catch (PortalException e) {
//					e.printStackTrace();
//				} catch (SystemException e) {
//					e.printStackTrace();
//				}
				
//				//form_['veteranPersn']
			} else if ( "CREATE_APPLICATIONS".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_APPLICATIONS.name() ) ){
		//			loadStatesAndFacilities( actionRequest );
					createEntry(actionRequest, actionResponse);
					long callId = ParamUtil.getLong(actionRequest, CaretStrPool.CALL_ID );
					if ( callId > 0 ){
						try {
							Call call = CallLocalServiceUtil.getCall(callId);
							Person person = new Person(PersnLocalServiceUtil.getPersn( call.getCallerPersnId() ) );
							person.setRelationship( call.getCallerRelationship() );
							actionRequest.setAttribute( "caller", person.getJsonObject() );
							person = new Person( PersnLocalServiceUtil.getPersn( call.getVeteranPersnId() ) );
							ResultMap.getForm( actionRequest ).put( CaretStrPool.VETERAN_PERSN, person );
							CaretViewController.getViewController().loadAddress( ResultMap.getCaretMap(actionRequest), person, CaretStrPool.VETERAN_PERSN );
							
							List<Docum> ten10 = DocumLocalServiceUtil.getByClass( callId, PortalUtil.getClassNameId(Call.class), FileType.REFERRAL_1010.name() );
							if ( !ten10.isEmpty() ){
								actionRequest.setAttribute("REFERRAL_1010", ten10.get(0) );
							}
							
						} catch (PortalException e) {
							ApplicationWorkFlowException.handleException(e);
						} catch (SystemException e) {
							ApplicationWorkFlowException.handleException(e);
						}
					}
				}
			} else if ( "PROCESS_APPLICATIONS".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.MANAGE_VCG.name() ) ){
					loadProcessApplication(actionRequest, actionResponse);
					
				}
			} else if ( "INTERNAL_MESSAGE".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.INTERNAL_MESSAGE.name() ) ){
					PMPortlet.render(actionRequest, actionResponse);
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.INTERNAL_MESSAGES_PAGE+actionRequest.getAttribute("targetPath"));
				}
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException ( e );
		}
	}
	


	private void searchEntry( PortletRequest request ) {
//		Map<String, Integer> total = ResultMap.getResultTotalMap( request );
//		Map<String, List<?>> results = ResultMap.getResultListMap(request);
		_log.info("searchEntry");
	}
	
	@ProcessAction (name="saveEntry")
	public void saveEntry( ActionRequest actionRequest, ActionResponse actionResponse ) {
		String entry = ParamUtil.get(actionRequest, "entry", StringPool.BLANK);

		_log.info("save entry..." +  entry );
		
///*		
		String tracker = ParamUtil.getString(actionRequest, CaretStrPool.TRACKER, StringPool.BLANK );
		if ( ! CaretParam.isTracked( actionRequest, tracker, true ) ){
			_log.warn("TRACKER BLOCKING action... ");
			actionRequest.setAttribute(CaretStrPool.INVALID_REQUEST, true);
			return;
		}
//*/
		try {
			if ( "vcg".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.MANAGE_VCG.name() ) ){
					saveVcgEntry(actionRequest, actionResponse);
				}
			} else if ( "CREATE_REFERRAL".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_REFERRAL.name() ) ){
					saveReferral(actionRequest);
				} else if ( CAction.canDoCaret(actionRequest, CaretCan.DISPOSITION_CALLS.name() ) ){
					saveCallDisposition( actionRequest, actionResponse );
				}
			} else if ( "CREATE_CALLS".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_CALLS.name() ) ){
					saveCall(actionRequest);
				}
				if ( CAction.canDoCaret(actionRequest, CaretCan.DISPOSITION_CALLS.name() ) ){
					saveCallDisposition( actionRequest, actionResponse );
				}
			} else if ( "soc".equals(entry) ){
				String socSourceResponsePath = actionRequest.getParameter("socSourceResponsePath");
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_SOC.name() ) ){
					saveSoc(actionRequest);
					if (socSourceResponsePath != null && socSourceResponsePath.equals("searchOrQueue")) {
						actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/internal/performSocResponse.jsp");
					}
				}
			}else if("cesp".equals(entry)){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_CESP.name() ) ){
					saveCesp(actionRequest);
				}
			}else if ( "vcgAn".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_APPLICATIONS.name() ) ){
					saveVcgAn(actionRequest);
				}
			} else if ( "cscWaiver".equals(entry) ){				
				saveCSCWaiver(actionRequest);
			} else if ( "cscAppealOutcome".equals(entry) ){				
				saveCSCAppealOutcome( actionRequest, actionResponse );
			} else if ( "cscAppeal".equals(entry) ){				
				saveCSCAppeal( actionRequest, actionResponse );
			}
									
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException ( e );
		}
	}
	
	


	private void saveCallDisposition(ActionRequest actionRequest, ActionResponse actionResponse) {
		_log.info("saveCallDisposition..."  );
		long callId = ParamUtil.getLong(actionRequest, "call_primaryKey");
		if ( callId > 0 ){
			try {
				ServiceContext sc = CaretParam.setCaretServiceContext(actionRequest);
				Call call = CallLocalServiceUtil.getCall(callId);
//				call.setSummary(actionRequest.getParameter(CaretStrPool.WORK_COMMENT));
				call.setModificationDate( sc.getCreateDate() );
				String callState = actionRequest.getParameter("call_callState");
				call.setCallState( callState );
				
				WorkItemSupport work = new WorkItemSupport( WorImLocalServiceUtil.getWorIm( call.getWorkPrimaryKey() ) );
				if ( work.getVcgId() > 0 ){
					VcgSupport vcgSupport = VcgSupport.getVcgSupport( work.getVcgId() );
					vcgSupport.setNote("callDispComment", actionRequest.getParameter(CaretStrPool.WORK_COMMENT),
							sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.REFERRAL.groupId());
					vcgSupport.setNote("callDisposition", callState, sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.REFERRAL.groupId());
					CaretLocalServiceUtil.save(vcgSupport);
					work.useNote("callDispComment", vcgSupport.getNote("callDispComment") );
					work.useNote("callDisposition", vcgSupport.getNote("callDisposition") );
					actionRequest.setAttribute( CaretStrPool.VCGID, vcgSupport.getVcgId() );
				} else {
					work.setNote("callDispComment", actionRequest.getParameter(CaretStrPool.WORK_COMMENT), sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.CALL_NOTE.groupId() );
					work.setNote("callDisposition", callState, sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.DISPOSITION.groupId() );
				}
				
				if ( callState.contains("completed") ){
					work.setStatus(WorkStatus.COMPLETE.name());
					work.setCompletionBy( sc.getUserId() );
					work.setCompletionDate( sc.getCreateDate() );
				}
				CaretLocalServiceUtil.save(work);
				CaretLocalServiceUtil.save(call);
				
				if ( "VCG_MANAGEMENT_PAGE".equals( ParamUtil.getString( actionRequest, "onPageComplete", StringPool.BLANK) ) ){
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.VCG_MANAGEMENT_PAGE);
					loadVcgManagement(actionRequest, actionResponse);
				}
				
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		
	}


	private void loadCallSelects(PortletRequest request ) throws ApplicationWorkFlowException{
		Map<String,Object> form = ResultMap.getForm (request);
		
		String callType = PortletProps.get("call.type");
		if ( !callType.isEmpty() ){
			form.put( "standard-call-types", callType.split(StringPool.COMMA) );
		}
		form.put( "custom-call-types", BoxGpLocalServiceUtil.getBoxGroups("custom-call-types") );
		
		
		String callerLearnAbout = PortletProps.get("call.callerLearnAbout");
		if ( !callerLearnAbout.isEmpty() ){
			request.setAttribute("callerLearnAbout", callerLearnAbout.split(StringPool.COMMA) );
		}
		String callerCaregiverType = PortletProps.get("call.callerCaregiverType");
		if ( !callerCaregiverType.isEmpty() ){
			request.setAttribute("callerCaregiverType", callerCaregiverType.split(StringPool.COMMA) );
		}
		
		loadRelationshipLists(request);
	}
	
	private void loadMoreReferralInfo ( PortletRequest request, long veteranId ) throws ApplicationWorkFlowException{
		
		List<BoxGp> groups = BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.REFERRAL_QUESTIONAIRE_YN);
		Map<String,List<BoxGp>> boxGpMap = new HashMap<String,List<BoxGp>>();
		int i = 0;
		List<BoxGp> boxGpList = new ArrayList<BoxGp>(5);
		for ( BoxGp boxGp: groups ){
			boxGpList.add( boxGp );
			if ( i % 2 == 1 ){
				boxGpMap.put( boxGp.getBoxSubGroup(), boxGpList );
				boxGpList = new ArrayList<BoxGp>(5);
			}
			i++;
		}
		
		Map<String, Object> form = ResultMap.getForm(request);
		form.put( "ref-prescreen-meets-pcafc", CaretUtil.loadBoxGroup ( "referral-questionaire-radio", "ref-prescreen-meets-pcafc" ) );
		form.put( "ref-enrolled-in-va-health", CaretUtil.loadBoxGroup ( "referral-questionaire-radio", "ref-enrolled-in-va-health" ) );
		form.put( "ref-discharged-after-911", CaretUtil.loadBoxGroup ( "referral-questionaire-radio", "ref-discharged-after-911" ) );
		form.put( "ref-veteran-has-sc-condition", CaretUtil.loadBoxGroup ( "referral-questionaire-radio", "ref-veteran-has-sc-condition" ) );
		
		Map<Long,Boolean> enabledBxGps =  new CaretMap<Long,Boolean>( false );
		form.put(CaretStrPool.BOX_GROUP, enabledBxGps);
		
		if ( veteranId > 0 ){
			for ( BgAsn bgAsn0: BoxGpLocalServiceUtil.getBoxGroupAssociations( veteranId, true ) ) {
				enabledBxGps.put( bgAsn0.getBoxGpId(), true );
			}
		}		
		
		if ( CAction.canDoCaret(request, CaretCan.LOD_QA.name() ) ){
			form.put( CaretStrPool.HEC_QUESTIONAIRE, CaretUtil.loadBoxGroup ( CaretStrPool.HEC_QUESTIONAIRE, CaretStrPool.HEC_QUESTIONAIRE ) );
		}
	}
	
	private void loadMoreCallInfo ( PortletRequest request ) throws ApplicationWorkFlowException{
		
		String serviceBranches = PortletProps.get("call.serviceBranches");
		if ( !serviceBranches.isEmpty() ){
			request.setAttribute("serviceBranches", serviceBranches.split(StringPool.COMMA) );
		}
		
		String eraServiceTypes = PortletProps.get("call.eraServiceTypes");
		if ( !eraServiceTypes.isEmpty() ){
			request.setAttribute("eraServiceTypes", eraServiceTypes.split(StringPool.COMMA) );
		}
		
		long callId = ParamUtil.getLong(request, CaretStrPool.CALL_ID, 0 );
//		Set<Long> bgAsnSet = new HashSet<Long>();
		
		Map<Long,Boolean> boxGrp =  new CaretMap<Long,Boolean>( false );
		
		Map<String, Object> form = ResultMap.getForm(request);
		form.put(CaretStrPool.BOX_GROUP, boxGrp);
		
		if ( callId > 0 ){
			for ( BgAsn bgAsn0: BoxGpLocalServiceUtil.getBoxGroupAssociations( callId, true ) ) {
				boxGrp.put( bgAsn0.getBoxGpId(), true );
			}
		}
		ResultMap.getForm(request);
//		form.put( subName, groups );
		form.put( "veteran-primary-diagnosis", CaretUtil.loadBoxGroup ( "veteran-primary-diagnosis", "veteran-primary-diagnosis" ) );
		form.put( "other-primary-diagnosis", CaretUtil.loadBoxGroup ( "other-primary-diagnosis", "other-primary-diagnosis" ) );
		form.put( "public-law-111-163-reasons", CaretUtil.loadBoxGroup ( "public-law-111-163-reasons", "public-law-111-163-reasons") );
		form.put( "heard-from-us", CaretUtil.loadBoxGroup ( "heard-from-us", "heard-from-us" ) );

//		form.put( "prescreen-meets-pcafc", CaretUtil.loadBoxGroup ( "referral-questionaire-yn", "prescreen-meets-pcafc" ) );
//		form.put( "enrolled-in-va-health", CaretUtil.loadBoxGroup ( "referral-questionaire-yn", "enrolled-in-va-health" ) );
//		form.put( "discharged-after-911", CaretUtil.loadBoxGroup ( "referral-questionaire-yn", "discharged-after-911" ) );
//		form.put( "veteran-has-sc-condition", CaretUtil.loadBoxGroup ( "referral-questionaire-yn", "veteran-has-sc-condition" ) );
		form.put( "ref-prescreen-meets-pcafc", CaretUtil.loadBoxGroup ( "referral-questionaire-radio", "ref-prescreen-meets-pcafc" ) );
		form.put( "ref-enrolled-in-va-health", CaretUtil.loadBoxGroup ( "referral-questionaire-radio", "ref-enrolled-in-va-health" ) );
		form.put( "ref-discharged-after-911", CaretUtil.loadBoxGroup ( "referral-questionaire-radio", "ref-discharged-after-911" ) );
		form.put( "ref-veteran-has-sc-condition", CaretUtil.loadBoxGroup ( "referral-questionaire-radio", "ref-veteran-has-sc-condition" ) );
		
		form.put( "support-lines-transfer", CaretUtil.loadBoxGroup ( "support-lines", "support-lines-transfer") );
		form.put( "support-lines-number-provided", CaretUtil.loadBoxGroup ( "support-lines", "support-lines-number-provided") );
		form.put( "interventions-applied-family", CaretUtil.loadBoxGroup ( "interventions-applied", "interventions-applied-family") );
		form.put( "interventions-applied-care", CaretUtil.loadBoxGroup ( "interventions-applied", "interventions-applied-care") );
		form.put( "interventions-applied-respite", CaretUtil.loadBoxGroup ( "interventions-applied", "interventions-applied-respite") );
		form.put( "interventions-applied-counseling", CaretUtil.loadBoxGroup ( "interventions-applied", "interventions-applied-counseling") );
		form.put( "interventions-applied-directives", CaretUtil.loadBoxGroup ( "interventions-applied", "interventions-applied-directives") );
		form.put( "interventions-applied-other", CaretUtil.loadBoxGroup ( "interventions-applied", "interventions-applied-other") );
		
		if ( CAction.canDoCaret(request, CaretCan.LOD_QA.name() ) ){
			form.put( CaretStrPool.HEC_QUESTIONAIRE, CaretUtil.loadBoxGroup ( CaretStrPool.HEC_QUESTIONAIRE, CaretStrPool.HEC_QUESTIONAIRE ) );
		}
	}
	
	
	
	public boolean loadReferral(PortletRequest request) throws ApplicationWorkFlowException {
		request.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( request ) );

		String serviceStatus = PortletProps.get("veteran.supplemental.serviceStatuses");
		if ( !serviceStatus.isEmpty() ){
			request.setAttribute(CaretStrPool.SERVICE_STATUS, serviceStatus.split(StringPool.COMMA) );
		}
		Map<String,Object> form = ResultMap.getForm( request );
		boolean newInstance = CaretStrPool.NEW.equals( request.getParameter(CaretStrPool.STATUS) ) ;
		try {
			CaretViewController controller = CaretViewController.getViewController();
			long callId = ParamUtil.getLong(request, CaretStrPool.CALL_ID, 0 );
			long veteranId = 0;
			if ( callId > 0 ){
				Map<String,Object> caret = ResultMap.getCaretMap(request);
				
				Call call = CallLocalServiceUtil.getCall( callId );
				if ( newInstance ) {
					call.setCallId(0);
					call.setWorkPrimaryKey(0);
				} else if ( "send-referral".equals( call.getCallState() ) ) {
					loadCall ( request );
					return true;
				}
				form.put( CaretStrPool.CALL, call );
				
				if ( call.getWorkPrimaryKey() > 0 ){
					WorIm workItem = WorImLocalServiceUtil.getWorIm( call.getWorkPrimaryKey() );
					form.put("workItem", workItem );
					if ( workItem != null && ( workItem.getUserId() > 0 || workItem.getCompletionBy() > 0 )  ){
						request.setAttribute("isDisabled", true);
						if ( workItem.getStatus() != null ){
							if ( ! workItem.getStatus().toLowerCase().contains("completed") ){
								request.setAttribute("dispositionCall", CAction.canDoCaret(request, CaretCan.DISPOSITION_CALLS.name() ) );
							}
						} else {
							request.setAttribute("dispositionCall", CAction.canDoCaret(request, CaretCan.DISPOSITION_CALLS.name() ) );
						}
					}
				}
				
				Person person = new Person( PersnLocalServiceUtil.getPersn( call.getCallerPersnId() ) );
				form.put(CaretStrPool.CALLER_PERSN, person );
				controller.loadAddress( caret, person, CaretStrPool.CALLER_PERSN );
				veteranId = call.getVeteranPersnId();
				person = new Person ( PersnLocalServiceUtil.getPersn( veteranId ) );
				form.put(CaretStrPool.VETERAN_PERSN, person );
				controller.loadAddress( caret, person, CaretStrPool.VETERAN_PERSN );

//				if ( ( call.getCallState() != null &&
//						call.getCallState().toLowerCase().contains(CaretStrPool.CALL_STATE_COMPLETE) ) ||					
//						! CAction.canDoCaret(request, CAction.CaretCan.CREATE_REFERRAL.name() ) ){
//					request.setAttribute("isDisabled", true);
//				}
				request.setAttribute("isDisabled", !newInstance && call.getCallId() > 0);
				
			}
			
			loadCallSelects( request );
			loadMoreReferralInfo(request, callId );
			
			ResultMap.getCaretMap(request).put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
			
			loadStatesAndFacilities( request );

			DashboardConfig config = (DashboardConfig)request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG);
			if ( config != null ){
				request.setAttribute(CaretStrPool.ROLE, config.getRole() );
			}
			controller.loadRequiredInputs( CaretStrPool.REFFERAL, form );
			
			if ( CAction.canDoCaret(request, CAction.CaretCan.REFERRAL_ATTACHMENT.name() ) || CAction.canDoCaret(request, CAction.CaretCan.MANAGE_VCG.name() ) ){
				if ( callId > 0 ) {
					List<Docum> supportDocs = DocumLocalServiceUtil.getByPrimaryKey( callId );
					form.put("supportDocs", supportDocs );
				}
				form.put("hasDocumentAcess", true);
			} else {
				form.put("hasDocumentAcess", false);
			}
			
//			form.put("noteContext", CaretStrPool.CALL );
			ResultMap.getCaretMap(request).put("noteContext", CaretStrPool.CALL);
			
		} catch (Exception e) {
			throw new ApplicationWorkFlowException(e);
		}
		return false;
	}
	
	
	public void takeOwnershipCall ( ActionRequest request, ActionResponse actionResponse ){
		_log.info("takeOwnershipCall");
		
		long callId = ParamUtil.getLong(request, CaretStrPool.CALL_ID);
		try {
			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			Call workItem = CallLocalServiceUtil.getCall(callId);
			workItem.setUserId( sc.getUserId() );
//			workItem.setStatus(WorkStatus.IN_PROCESS.name());
			CaretLocalServiceUtil.save(workItem);
			
//			updateVcgAnStatus(workItem);
			
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
	}
	
	public void takeOwnership ( ActionRequest request, ActionResponse actionResponse ){
		_log.info("takeOwnership");
		
		long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		try {
			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			WorkItemSupport workItem = new WorkItemSupport( WorImLocalServiceUtil.getWorIm(worImId) );
			workItem.setUserId( sc.getUserId() );

			DashboardConfig config = (DashboardConfig) request.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG);
			if ( config instanceof CbopcDashboardConfig ){
				occSiblingAssignMe(config, workItem, sc, true);
			}
			
			CaretLocalServiceUtil.save(workItem);
			checkContext( request, actionResponse, workItem.getVcgId() );
			
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}

	private void checkContext(ActionRequest request, ActionResponse actionResponse, long vcgId ) {
		// TODO Auto-generated method stub
		String context = request.getParameter("context");
		if ( "manageVcg".equals( context ) && vcgId > 0 ){
			request.setAttribute( CaretStrPool.VCGID, vcgId );
			loadVcgManagement(request, actionResponse);
			ResultMap.getCaretMap(request).put("scrollContext", "openWork" );
			actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.VCG_MANAGEMENT_PAGE);
		} else if ( "dashboard".equals( context ) ){
			ResultMap.getCaretMap(request).put("tabContext", "search" );
			ResultMap.getCaretMap(request).put("lastSearch", request.getPortletSession().getAttribute("lastSearch"));
		}
		_log.info("context is " + context );
	}
	public void unassignTo ( ActionRequest request, ActionResponse actionResponse ){
		
		long primKey = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		if ( primKey > 0 ){
			try {
				WorIm workItem = WorImLocalServiceUtil.getWorIm(primKey);
				workItem.setUserId(0);
				ServiceContext sc = CaretParam.setCaretServiceContext(request);
				DashboardConfig config = (DashboardConfig) request.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG );
				CaretLocalServiceUtil.save( workItem );

				if ( config instanceof CbopcDashboardConfig ){
					occSiblingAssignMe(config, workItem, sc, false);
				}
				checkContext( request, actionResponse, workItem.getVcgId() );
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			} 
		}		
	}

	public void assignTo ( ActionRequest request, ActionResponse actionResponse ){
		
		long primKey = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		long userId = ParamUtil.getLong(request, "form_userName");
		if ( primKey > 0 && userId > 0 ){
			try {
				ServiceContext sc = CaretParam.setCaretServiceContext(request);
				WorkItemSupport workItem = new WorkItemSupport ( WorImLocalServiceUtil.getWorIm(primKey) );
				workItem.setNote("assign", ParamUtil.get(request, CaretStrPool.WORK_COMMENT, StringPool.BLANK ),
						sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.WORK_ASSIGN_NOTE.groupId());
				
				workItem.setUserId(userId);
				
				DashboardConfig config = (DashboardConfig) request.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG );
				if ( config instanceof CbopcDashboardConfig ){
					occSiblingAssignTo(config, workItem, userId, sc);
				}
						
				CaretLocalServiceUtil.save( workItem );

//				updateVcgAnStatus(workItem);
				checkContext( request, actionResponse, workItem.getVcgId() );
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			} 
		}		
	}

	public void correctWork ( ActionRequest request, ActionResponse actionResponse ){
		
		long primKey = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		if ( primKey > 0 ){ //TODO:// CAction.canDoCaret(request, CORRECT WORK ) 
			try {
				ServiceContext sc = CaretParam.setCaretServiceContext(request);
				
				WorkItemSupport workItem = new WorkItemSupport( WorImLocalServiceUtil.getWorIm(primKey) );
				workItem.setStatus( WorkStatus.CORRECTED_WORK.name() );
				
				String noteAtt = "CorrectedNote";
				String comment = ParamUtil.get(request, CaretStrPool.WORK_COMMENT, StringPool.BLANK );
				Note note = CaretUtil.createNote( sc.getCreateDate(), primKey, NoteSupport.NoteGroup.CORRECTIVE_RESPONSE.groupId(), sc.getUserId(), comment);
				workItem.useNote( noteAtt, note );
				
				if ( sc.getUserId() != workItem.getUserId() ){//change back to last OCC user
					for ( WorSe workItemStep: WorSeLocalServiceUtil.getByWorkId( workItem.getWorImId() ) ){
						try {
							for ( long roleId : UserLocalServiceUtil.getUser( workItemStep.getUserId() ).getRoleIds() ){
								if ( CAction.canDoCaret( sc.getCompanyId(), CAction.CaretCan.CBOPC_FUNCTION, roleId) ){
									workItem.setUserId( workItemStep.getUserId() );
								}
							}
						} catch (SystemException e) {
							e.printStackTrace();
						} catch (PortalException e) {
							e.printStackTrace();
						}
					}
				}
				CaretLocalServiceUtil.save( workItem );

				WorSe workItemStep = new WorSeImpl();
				workItemStep.setWorImId( workItem.getWorImId() );
				workItemStep.setCreationDate( sc.getCreateDate() );
				workItemStep.setUserId( sc.getUserId() );
				int count = WorSeLocalServiceUtil.getCount ( workItem.getWorImId() );
				workItemStep.setStep( (count < 10? "0":StringPool.BLANK) + count + StringPool.COLON + workItem.getType() + StringPool.COLON + workItem.getStatus() );
				workItemStep.setStepNumber(count+1);
				CaretLocalServiceUtil.save( workItemStep );
				checkContext( request, actionResponse, workItem.getVcgId() );
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
	}
	
	public void occSiblingAssignMe ( DashboardConfig config, WorIm workItem, ServiceContext sc, boolean assign ) throws ApplicationWorkFlowException {
		Collection<Long> collection = ((CbopcDashboardConfig)config).getOwnerQueueIds();
		List<WorIm> worImList = WorImLocalServiceUtil.findByOpenQueueIds( ArrayUtil.toArray( collection.toArray(new Long[collection.size()]) ), workItem.getVcgId() );
		for ( WorIm worIm: worImList ){
			boolean update = true;
			if ( worIm.getWorImId() == workItem.getWorImId() ) {
				update = false;
			}
			if ( OwnerQueue.CORRECTION_Q.name().equals( workItem.getStatus() ) ){
				if ( workItem.getUserId() != 0  ){
					try {
						for ( long roleId : UserLocalServiceUtil.getUser( workItem.getUserId() ).getRoleIds() ){
							if ( CAction.canDoCaret( sc.getCompanyId(), CAction.CaretCan.CSC_FUNCTION, roleId) ){
								update = false;
							}
						}
					} catch (SystemException e) {
						e.printStackTrace();
					} catch (PortalException e) {
						e.printStackTrace();
					}
				}
			}
			if ( update ){
				WorkItemSupport sibling = new WorkItemSupport (worIm);
				sibling.setUserId( assign? sc.getUserId() : 0 );
				sibling.setNote(assign? "assign": "unassign", workItem.getWorImId() + (assign? " Sibling assignment": " Sibling unassignment"), sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.WORK_ASSIGN_NOTE.groupId());
				CaretLocalServiceUtil.save(sibling);
			}
		}
	}
	
	
	public void occSiblingAssignTo ( DashboardConfig config, WorIm workItem, long assignee, ServiceContext sc ) throws ApplicationWorkFlowException{
		
		try {
			List<Role> roles = RoleLocalServiceUtil.getUserRoles(assignee);
			
			Collection<Long> collection = ((CbopcDashboardConfig)config).getOwnerQueueIds();
			List<WorIm> worImList = WorImLocalServiceUtil.findByOpenQueueIds( ArrayUtil.toArray( collection.toArray(new Long[collection.size()]) ), workItem.getVcgId() );
			List<WorIm> siblingList = new ArrayList<WorIm>();
			for ( WorIm worIm: worImList ){
				boolean update = true;
				if ( worIm.getWorImId() == workItem.getWorImId() ) {
					update = false;
				}
				if ( OwnerQueue.CORRECTION_Q.name().equals( workItem.getStatus() ) ){
					if ( workItem.getUserId() != 0  ){
						try {
							List<Role> roles2 = RoleLocalServiceUtil.getUserRoles(workItem.getUserId());
							for ( Role role : roles2 ){
								if ( CAction.canDoCaret( sc.getCompanyId(), CAction.CaretCan.CSC_FUNCTION, role.getRoleId() ) ){ //already picked up by CSC
									update = false;
									WorSe workItemStep = new WorSeImpl();
									workItemStep.setWorImId( workItem.getWorImId() );
									workItemStep.setCreationDate( sc.getCreateDate() );
									workItemStep.setUserId( assignee );
									int count = WorSeLocalServiceUtil.getCount ( workItem.getWorImId() );
									workItemStep.setStep( (count < 10? "0":StringPool.BLANK) + count + StringPool.COLON + workItem.getType() + StringPool.COLON + workItem.getStatus() );
									workItemStep.setStepNumber(count+1);
									CaretLocalServiceUtil.save( workItemStep );
								}
							}
						} catch (SystemException e) {
							e.printStackTrace();
						} catch (PortalException e) {
							e.printStackTrace();
						}
					} else {
						WorSe workItemStep = new WorSeImpl();
						workItemStep.setWorImId( workItem.getWorImId() );
						workItemStep.setCreationDate( sc.getCreateDate() );
						workItemStep.setUserId( assignee );
						int count = WorSeLocalServiceUtil.getCount ( workItem.getWorImId() );
						workItemStep.setStep( count < 10? "0":StringPool.BLANK + count + StringPool.COLON + workItem.getType() + StringPool.COLON + workItem.getStatus() );
						CaretLocalServiceUtil.save( workItemStep );
					}
				}
				if ( update ){
					String queueName = new WorkItemSupport (worIm).getQueueName();
					
					if ( !Toolbox.isEmpty(queueName) ){
						CaretCan action = CaretCan.valueOf( CbopcDashboardConfig.NDX + queueName ); 
						for ( Role role : roles ){
							try {
								if ( CAction.canDoCaret( sc.getCompanyId(), action, role.getRoleId() ) ){
									siblingList.add(worIm);
									break;
								}
							} catch (PortalException e) {
								e.printStackTrace();
							}
						}
					}
				}
			}
				
			for ( WorIm worIm: siblingList ){
				WorkItemSupport sibling = new WorkItemSupport (worIm);
				sibling.setUserId( assignee );
				sibling.setNote("assign", workItem.getWorImId() + " Sibling assignment", sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.WORK_ASSIGN_NOTE.groupId());
				CaretLocalServiceUtil.save(sibling);
			}
			
		} catch (SystemException e) {
			e.printStackTrace();
		}
	}
	
	
	public void reviewMyWork ( ActionRequest request, ActionResponse actionResponse ){
		
		long primKey = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		String workImStatus = ParamUtil.get(request, "worIm_status", StringPool.BLANK);
//		String workItemStepName = ParamUtil.get(request, "worIm_step", workImStatus );
		QueAction queAction = QueAction.valueOf( workImStatus );
		if ( primKey > 0 && ! Toolbox.isEmpty(workImStatus) ){ //TODO:// CAction.canDoCaret(request, queAction.name() ) 
			try {
				ServiceContext sc = CaretParam.setCaretServiceContext(request);
				
				WorkItemSupport workItem = new WorkItemSupport( WorImLocalServiceUtil.getWorIm(primKey) );
				
				long noteGrpId;
				OwnerQueue nextQueue = OwnerQueue.valueOf( queAction.getNextQueue() );
				boolean workItemStepCreated = false;
				if ( OwnerQueue.CORRECTION_Q == nextQueue ){
					workItem.setStatus( OwnerQueue.CORRECTION_Q.name() );
//					workItemStepName = workItemStepName + StringPool.COMMA_AND_SPACE + ParamUtil.get(request, "worIm_correction", "Other");
					noteGrpId = NoteSupport.NoteGroup.CORRECTION_REQUEST.groupId();
					workItem.setLeaAttr( "CorrectionType", ParamUtil.get(request, "worIm_correction", "Other") );
					for ( WorSe workItemStep: WorSeLocalServiceUtil.getByWorkId( workItem.getWorImId() ) ){//change back to last CSC user
						try {
							for ( long roleId : UserLocalServiceUtil.getUser( workItemStep.getUserId() ).getRoleIds() ){
								if ( CAction.canDoCaret( sc.getCompanyId(), CAction.CaretCan.CSC_FUNCTION, roleId) ){
									workItem.setUserId( workItemStep.getUserId() );
								}
							}
						} catch (SystemException e) {
							e.printStackTrace();
						} catch (PortalException e) {
							e.printStackTrace();
						}
					}
				} else {
					if ( workItem.getQueueId() != nextQueue.getQueueId() ){
						DashboardConfig config = (DashboardConfig) request.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG);
						if ( config.getQueueIds().indexOf( String.valueOf( nextQueue.getQueueId() ) ) == -1 ){
							workItem.setUserId(0);
						}
					}
					noteGrpId = NoteSupport.NoteGroup.OCC_REVIEW_1.groupId();
					boolean changeStatus = true;
					if ( nextQueue.getQueueId() == -1 ){
						if ( OwnerQueue.CORRECTION_Q.name().equals( workItem.getStatus() ) ){

							if ( queAction.getWorkMarkation().isEmpty() ){
								changeStatus = false;
							}
							
							if ( sc.getUserId() != workItem.getUserId() ){//change back to last OCC user
								for ( WorSe workItemStep: WorSeLocalServiceUtil.getByWorkId( workItem.getWorImId() ) ){
									try {
										for ( long roleId : UserLocalServiceUtil.getUser( workItemStep.getUserId() ).getRoleIds() ){
											if ( CAction.canDoCaret( sc.getCompanyId(), CAction.CaretCan.CBOPC_FUNCTION, roleId) ){
												workItem.setUserId( workItemStep.getUserId() );
											}
										}
									} catch (SystemException e) {
										e.printStackTrace();
									} catch (PortalException e) {
										e.printStackTrace();
									}
								}
							}
						}
					} else {
						workItem.setQueueId( nextQueue.getQueueId() );
						if ( workItem.getQueueId() == OwnerQueue.VERIFIED_COMPLETED_Q.queueId ){
							
							workItemStepCreated = workItem.calcInfoVerified( sc );
						} else if ( workItem.getQueueId() == OwnerQueue.CHAMPVA_Q.queueId && QueAction.REVOKE_COMPLETE.name().equals( workImStatus ) ){
							workItem.calcInfoRevoked ( sc );
						} else if ( (workItem.getQueueId() == OwnerQueue.VENDOR_Q.queueId && QueAction.REVIEW_VENDOR.name().equals( workImStatus )) ||
							( workItem.getQueueId() == OwnerQueue.VERIFY_Q.queueId && QueAction.REVIEW_VENDORIZATION_COMPLETE.name().equals( workImStatus ) ) ){
							DashboardConfig dashConfig = (DashboardConfig) request.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG);
							workItem.verifyVendor( sc, dashConfig.getQueueIds() );
						}
					}
					if ( changeStatus ){
						if ( queAction.getWorkMarkation().isEmpty() ){
							workItem.setStatus( workImStatus );
						} else {
							workItem.setStatus( queAction.getWorkMarkation() );
						}
					}
					OwnerQueue oq = OwnerQueue.getOwnerQue(workItem.getQueueId());
					if ( oq != null && oq == OwnerQueue.VERIFIED_COMPLETED_Q ) {
						workItem.checkChampVaType();
						
						workItem.setCompletionBy( sc.getUserId() );
						workItem.setCompletionDate( sc.getCreateDate() );
					}
				}
				
				String comment = ParamUtil.get(request, CaretStrPool.WORK_COMMENT, StringPool.BLANK );
				Note note = CaretUtil.createNote( sc.getCreateDate(), primKey, noteGrpId, sc.getUserId(), comment);
				workItem.useNote( "ReviewNote", note );
				CaretLocalServiceUtil.save( workItem );
				if ( !workItemStepCreated ){
					WorSe workItemStep = new WorSeImpl();
					workItemStep.setWorImId( workItem.getWorImId() );
					workItemStep.setCreationDate( sc.getCreateDate() );
					workItemStep.setUserId( sc.getUserId() );
					int count = WorSeLocalServiceUtil.getCount ( workItem.getWorImId() );
					workItemStep.setStep( (count < 10? "0":StringPool.BLANK) + count + StringPool.COLON + workItem.getType() + StringPool.COLON + workItem.getStatus() );
					workItemStep.setStepNumber(count+1);
					CaretLocalServiceUtil.save( workItemStep );
				}
				checkContext( request, actionResponse, workItem.getVcgId() );
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
	}
	
	public void reviewAppDelay ( ActionRequest request, ActionResponse actionResponse ){
		
		long primKey = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		String workImStatus = ParamUtil.get(request, "worIm_status", StringPool.BLANK);
		if ( primKey > 0 && ! Toolbox.isEmpty(workImStatus) && CAction.canDoCaret(request, CAction.CaretCan.CREATE_VACO_WAIVER) ){
			try {
				ServiceContext sc = CaretParam.setCaretServiceContext(request);

				WorkItemSupport workItem = new WorkItemSupport( WorImLocalServiceUtil.getWorIm(primKey) );

				if ( workImStatus.equals( CaretStrPool.COMPLETE ) && 
						workItem.getWorkType() == WorkType.APP_DELAY && 
						workItem.getCreateId() == sc.getUserId() ){
					_log.warn("App Delay Cannot move to complete by creator of work item");
				}

				workItem.setStatus( workImStatus );

				String noteAtt = "ReviewNote";
				VcgSupport vcg = VcgSupport.getVcgSupport( workItem.getVcgId() );
				String comment = ParamUtil.get(request, CaretStrPool.WORK_COMMENT, StringPool.BLANK );
				vcg.setNote(noteAtt, comment, sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.DELAY_REVIEWED.groupId());
				CaretLocalServiceUtil.save( vcg );
				
				if ( !workImStatus.equals( CaretStrPool.IN_PROCESS ) ){
					workItem.setCompletionBy(PortalUtil.getUserId(request) );
					workItem.setCompletionDate( sc.getCreateDate() );
					Waivr waiver = WaivrLocalServiceUtil.getByOwner( workItem.getApplicationId(), workItem.getCaregiverId() );
					waiver.setCompletionDate( sc.getCreateDate() );
					waiver.setAdjudication( workImStatus );
					CaretLocalServiceUtil.save( waiver );
					
					VcgAn vcgAn = vcg.getPersonVcgAn( workItem.getCaregiverId() );
					WorkItemSupport workAppDelay =  new WorkItemSupport(CaretUtil.createWorkItem(sc, workItem.getGroupId(), vcgAn, WorkType.DELAY_REVIEWED, workItem.getPersnId(), workItem.getCaregiverId()));
					workAppDelay.setVcgId( vcg.getVcgId() );
//					workAppDelay.setQueId( waiver.getUserId() );
					
					workAppDelay.useNote(noteAtt, vcg.getNote(noteAtt));
					CaretLocalServiceUtil.save(workAppDelay);
				}
				workItem.useNote(noteAtt, vcg.getNote(noteAtt) );
				CaretLocalServiceUtil.save( workItem );
				checkContext( request, actionResponse, workItem.getVcgId() );
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			} 
		}		
	}
	
	
	
	public void updateVcgAnStatus ( WorIm workItem ){
		
		try{
			String[] types = PortletProps.get(CaretStrPool.APP_TYPES).split(StringPool.COMMA);
			
			boolean updateStatus = false;
			for (String appType: types) { 
				if(workItem.getType().equals(appType))
				{
			         updateStatus = true;
			    }
			}
			
			if(updateStatus)
			{	
				long vcgAnId = workItem.getClassPk();
				VcgAn vcgAn = VcgAnLocalServiceUtil.getVcgAn(vcgAnId);
				vcgAn.setStatus(ApplicationStatus.IN_REVIEW.name());
				VcgAnLocalServiceUtil.updateVcgAn(vcgAn);
			}
			
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}		
	}

	
	public void facilTransfer ( ActionRequest request, ActionResponse actionResponse ){
		
		long primKey = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		long groupId = ParamUtil.getLong(request, "transfer_groupId");
		if ( primKey > 0 && groupId > 0 ){
			try {
				WorkItemSupport workItem = new WorkItemSupport( WorImLocalServiceUtil.getWorIm(primKey) );
				workItem.setQueId(groupId);
				workItem.setQueueId( OwnerQueue.TRANSFER_COMPLETED_WORK.queueId );
				ServiceContext sc = CaretParam.setCaretServiceContext(request);
				workItem.setNote("transferReason", ParamUtil.get(request, CaretStrPool.WORK_COMMENT, StringPool.BLANK ),
												sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.TRANSFER.groupId() );
				CaretLocalServiceUtil.save( workItem );
				checkContext( request, actionResponse, workItem.getVcgId() );
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			} 
		}//audit log to contain
		//reason for transfer and date transfer accepted
	}
	
	public void transferCancel ( ActionRequest request, ActionResponse actionResponse ) throws PortalException, SystemException{
		completeTransfer ( request, actionResponse, "Cancel Transfer", false );
	}
	
	public void acceptTransfer ( ActionRequest request, ActionResponse actionResponse ) throws PortalException, SystemException{
		completeTransfer ( request, actionResponse, ParamUtil.get(request, CaretStrPool.WORK_COMMENT, StringPool.BLANK ), ParamUtil.getBoolean(request, "transfer") );
	}
	
	public void completeTransfer ( ActionRequest request, ActionResponse actionResponse, String comment, boolean accept ) throws PortalException, SystemException{
		long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		if ( worImId > 0 ){
			ServiceContext sc = CaretParam.setCaretServiceContext(request);
//			DashboardConfig config = (DashboardConfig) request.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG);
			WorkItemSupport workItem = new WorkItemSupport( WorImLocalServiceUtil.getWorIm(worImId) );
			if ( accept ){
				if ( workItem.getQueueId() == OwnerQueue.TRANSFER_COMPLETED_WORK.queueId ){
					workItem.setQueueId(0);
					if ( workItem.getUserId() != PortalUtil.getUserId(request) ){
						workItem.setUserId(0);
					}
				}
				workItem.setGroupId( workItem.getQueId() );
				workItem.setQueId(0);
				if ( workItem.getVcgId() > 0 ){
					transferVcgWorkItems( workItem, accept );
				}
			} else {
				workItem.setQueueId(0);
			}
			Persn veteran = PersnLocalServiceUtil.getPersn( workItem.getPersnId() );
			if ( workItem.getQueId() > 0 && workItem.getQueId() != veteran.getGroupId() ){
				veteran.setGroupId( workItem.getQueId() );
				CaretLocalServiceUtil.save( veteran );
			}
			workItem.setNote("transferResponse", comment,
					sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.TRANSFER.groupId() );
			CaretLocalServiceUtil.save( workItem );
			checkContext( request, actionResponse, workItem.getVcgId() );
		}
	}

	
	private void transferVcgWorkItems(WorIm workItem, boolean accept ) throws ApplicationWorkFlowException {
		for ( WorIm worIm : WorImLocalServiceUtil.findByVcgId( workItem.getVcgId() ) ){
			if ( worIm.getWorImId() == workItem.getWorImId() ) continue;
			//workTypes.contains(worIm.getType()) && ( worIm.getQueId() > 0 ||
			if ( accept && worIm.getGroupId() != workItem.getGroupId() ) {
				if ( accept ){
					if (worIm.getQueueId() == OwnerQueue.TRANSFER_COMPLETED_WORK.queueId){
						worIm.setQueueId(0);
					}
					worIm.setGroupId( workItem.getGroupId() );
					worIm.setUserId(0);
//Should we prevent the transfer/overwrite of competing to another Facility request?
					worIm.setQueId( 0 );
				}
				CaretLocalServiceUtil.save( worIm );
			}
		}
		if ( accept && workItem.getVcgId() > 0 ){
			try {
				Vcg vcg = VcgLocalServiceUtil.getVcg( workItem.getVcgId() );
				vcg.setGroupId( workItem.getGroupId() );
				CaretLocalServiceUtil.save(vcg);
			} catch (PortalException | SystemException e) {
				throw new ApplicationWorkFlowException(e);
			}
		}
		
	}
	
	

	@ProcessAction (name="createEntry")
	public void createEntry( ActionRequest actionRequest, ActionResponse actionResponse ) {
		String entry = ParamUtil.get(actionRequest, "entry", StringPool.BLANK);
		_log.info("createEntry..." +  entry );
		
		actionRequest.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( actionRequest ) );
		ResultMap.getCaretMap(actionRequest).put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
//		loadStatesAndFacilities( actionRequest );
		try {
			ResultMap.getCaretMap(actionRequest).put(CaretStrPool.STATES, RegionServiceUtil.getRegions( CountryConstants.DEFAULT_COUNTRY_ID ) );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		try {
			ResultMap.getCaretMap( actionRequest ).put( CaretStrPool.VHA_MEMBER, CaretUtil.getVhaOrgList( actionRequest ) );
		} catch (ApplicationWorkFlowException e1) {
			e1.printStackTrace();
		}
		loadRelationshipLists( actionRequest );
		
		actionRequest.setAttribute("isDisabled", true);
		
		Map<String,Object> form = ResultMap.getForm (actionRequest);
		CaretViewController controller = CaretViewController.getViewController();
		controller.loadRequiredInputs( CaretStrPool.VETERAN_PERSN, form );
		controller.loadRequiredInputs( CaretStrPool.PRIMARY_PERSN, form );
		controller.loadRequiredInputs( CaretStrPool.SECONDARY_PERSN, form );
		controller.loadRequiredInputs( CaretStrPool.SECONDARY_TWO_PERSN, form );

		try {
			String  extensions = StringUtil.merge(PrefsPropsUtil.getStringArray(PropsKeys.DL_FILE_EXTENSIONS, StringPool.COMMA));
			long maxSize = Long.parseLong(PrefsPropsUtil.getString(PropsKeys.DL_FILE_MAX_SIZE)) / 1024;
			//_log.info("extensions = " + extensions + ", maxSize=" + maxSize );
			form.put("extensions",  extensions );
			form.put("maxSize",  maxSize );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}

		actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.CREATE_APPLICATION_PAGE);
	}
	
	
	public void loadRelationshipLists ( PortletRequest request ) {
		CaretViewController.getViewController().loadRelationshipLists(request);
	}
	
	@ProcessAction (name="uploadTempFile")
	public void uploadTempFile ( ActionRequest request, ActionResponse actionResponse ) throws FileNotFoundException{
		
		UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest(request);
		String type = ParamUtil.get(request, CaretStrPool.TYPE, StringPool.BLANK);
		String name = uploadRequest.getFileName(CaretStrPool.FILE);
		File uploadFile = uploadRequest.getFile(CaretStrPool.FILE);
		String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
		
		if ( ParamUtil.getBoolean(request, CaretStrPool.REPLACE ) ){
			removeFile( request, actionResponse );
		}
		
		long documId = 0;
		try {
			documId = CounterLocalServiceUtil.increment( Docum.class.getName() );
		} catch (SystemException e1) {
			e1.printStackTrace();
		}
		Docum document = DocumLocalServiceUtil.createDocum(documId);

		InputStream inputStream = new FileInputStream( uploadFile );
		OutputBlob outputBlob = new OutputBlob ( inputStream, uploadFile.length() );
		
		document.setDocument(outputBlob);
		document.setNote( tracker );
		document.setType( type );
		document.setName( name );
		document.setClassId( ClassNameLocalServiceUtil.getClassNameId( Dummy.class) );
		try {
			DocumLocalServiceUtil.addDocum( document );
			FileUtil.delete(uploadFile);
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	@ProcessAction (name="removeFile")
	public void removeFile ( ActionRequest request, ActionResponse actionResponse ) throws FileNotFoundException{
		
		String trackerNote = request.getParameter(CaretStrPool.TRACKER);
		String type = request.getParameter( CaretStrPool.TYPE );
		String name = request.getParameter("fileName");
		request.setAttribute(CaretStrPool.MVC_PATH, CaretStrPool.METADATA);
		try {
			for ( Docum toDelete : DocumLocalServiceUtil.getByTrackerNote( trackerNote, type ) ){
				if ( toDelete.getClassPk() == 0 && ( ParamUtil.getBoolean(request, CaretStrPool.REPLACE ) || name.equals(toDelete.getName()) ) ){
					DocumLocalServiceUtil.deleteDocum(toDelete);
					break;
				}
			}
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		}
	}
	
	@ProcessAction (name="uploadFile")
	public void uploadFile ( ActionRequest request, ActionResponse actionResponse ) throws FileNotFoundException{
		UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest(request);
		
		String type = ParamUtil.get(request, "type", StringPool.BLANK);
		//_log.info("file type is : "+type);

		
		long size = uploadRequest.getSize("file");
		//_log.info("size=" + size );
		if ( size == 0 ){
			_log.info("returning since size is 0...");
			return;
		}

		File uploadFile = uploadRequest.getFile("file");
		String tempLocation = PropsUtil.get(CaretStrPool.FILE_TEMP_STORE);
		String name = uploadRequest.getFileName("file");
		
		File file = new File(tempLocation + name);
		try {
			FileUtil.copyFile( uploadFile, file );
		} catch (IOException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
		//_log.info("path is ... " + uploadFile.getPath() + ", name=" + name );
		//String filePath = "";
		//String fileName = "";
		if(CaretStrPool.TEN_TEN_CG.equals(type) ){
			//filePath = CaretStrPool.FILE_PATH;
			//fileName = CaretStrPool.FILE_NAME;
			request.getPortletSession().setAttribute(CaretStrPool.FILE_PATH, file.getPath() );
			request.getPortletSession().setAttribute(CaretStrPool.FILE_NAME, name);
		} else if( CaretStrPool.POA.equals(type) ){
			//filePath = CaretStrPool.POA_FILE_PATH;
			//fileName = CaretStrPool.POA_FILE_NAME;			
			request.getPortletSession().setAttribute(CaretStrPool.POA_FILE_PATH, file.getPath() );
			request.getPortletSession().setAttribute(CaretStrPool.POA_FILE_NAME, name);
		} else {
			request.getPortletSession().setAttribute(CaretStrPool.FILE_PATH, file.getPath() );
			request.getPortletSession().setAttribute(CaretStrPool.FILE_NAME, name);
		}
		_log.info("path is ... " + file.getPath() + ", name=" + name );
	}


	
	@ProcessAction (name="cscWaiver")
	public void cscWaiver( ActionRequest actionRequest, ActionResponse actionResponse ) {
		_log.info("cscWaiver....");
		actionRequest.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( actionRequest ));
		
		String workItemId = ParamUtil.get(actionRequest, "workItemId", StringPool.BLANK);
		String vcgAnId = ParamUtil.get(actionRequest, "vcgAnId", StringPool.BLANK);
		String receivedDate = ParamUtil.get(actionRequest, "receivedDate", StringPool.BLANK);
		String daysPassed = ParamUtil.get(actionRequest, "daysPassed", StringPool.BLANK);
				
		Map<String,Object> form = ResultMap.getForm (actionRequest);
		form.put("workItemId", workItemId);
		form.put("vcgAnId", vcgAnId);
		form.put("receivedDate", receivedDate);
		form.put("daysPassed", daysPassed);
		
		try {
			long loggedPersnId = CaretParam.getPersnId(actionRequest);
			form.put("loggedPersnId", loggedPersnId );
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}

		actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.CSC_WAIVER_PAGE);
	}

	
	public void saveCSCWaiver( ActionRequest actionRequest) throws ApplicationWorkFlowException {
		getOutput(actionRequest);
		
		try {
			ServiceContext sc = CaretParam.setCaretServiceContext(actionRequest);
			Waivr w = new WaivrImpl();
			Waivr waiver = (Waivr) CaretParam.loadModel(actionRequest, new WaivrImpl(), w.getModelAttributes().keySet(), CaretStrPool.WAIVER_UNDERLINE);
			waiver.setCreationDate(new Date());
			
			CaretLocalServiceUtil.save( waiver );
									
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
	}

	public void saveCSCAppealOutcome( ActionRequest actionRequest, ActionResponse response )  {
		getOutput(actionRequest);
		
		try {
			ServiceContext sc = CaretParam.setCaretServiceContext(actionRequest);
			Apeal a = new ApealImpl();
			Apeal apeal = (Apeal) CaretParam.loadModel(actionRequest, new ApealImpl(), a.getModelAttributes().keySet(), CaretStrPool.APPEALED_UNDERLINE);
			apeal.setCreationDate(new Date());
			
			CaretLocalServiceUtil.save( apeal );
			
			String tracker = ParamUtil.getString(actionRequest, CaretStrPool.TRACKER, StringPool.BLANK );
			List<Docum> documents = DocumLocalServiceUtil.getByTrackerNote( tracker );
			for ( Docum docum : documents ){
				if ( docum.getClassPk() == 0 ){
					docum.setClassPk(apeal.getApealId());
					docum.setClassId(PortalUtil.getClassNameId(Apeal.class));
					docum.setNote(StringPool.BLANK);
					try {
						DocumLocalServiceUtil.updateDocum(docum);
					} catch (SystemException e) {
						e.printStackTrace();
					}
				}
			}
			
			
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
	}
	
	private void createManualPayment( ActionRequest request, ActionResponse response) throws PortalException, SystemException  {
				
		if ( !CAction.canDoCaret(request, CaretCan.MANUAL_PAYMENT) ) {
			throw new SystemException("Missing permissions...");
		}

		long paymentLogId = ParamUtil.getLong(request, "paymentLogId");
		long worImId = ParamUtil.getLong(request, "worImId");
		
		if ( paymentLogId == 0 && worImId == 0 ) {
			return;
		}
		
		ServiceContext sc = CaretParam.setCaretServiceContext(request);
		WorIm worIm = WorImLocalServiceUtil.getWorIm(worImId);
		String comments = request.getParameter("worIm_manualPaymentReason");
		Calendar calendar = Calendar.getInstance();
		
		Double dollarAmount = null;
		PayLg payLg = PayLgLocalServiceUtil.fetchPayLg(paymentLogId);
		if ( payLg != null ) {
			dollarAmount = payLg.getAmount();
			calendar.setTime( payLg.getPaymentDate() );
		} else try {
			Object dollarAmountObj = NumberFormat.getCurrencyInstance(Locale.getDefault()).parseObject(request.getParameter("dollarAmount"));
			dollarAmount = Double.valueOf(dollarAmountObj.toString());
			calendar.set( Calendar.MONTH, ParamUtil.getInteger(request, "config_cycle_month") );
			calendar.set( Calendar.YEAR, ParamUtil.getInteger(request, "config_cycle_year") );
			calendar.set( Calendar.DAY_OF_MONTH, 1);
			calendar.set( Calendar.HOUR_OF_DAY, 0);
			calendar.set( Calendar.MINUTE, 0);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		
		long vendrId = ParamUtil.getLong(request, "vendrId");
		int count = StiPtLocalServiceUtil.countByOneTime( vendrId, dollarAmount.toString(), calendar.getTime() );
		int oneTimeCount = ParamUtil.getInteger(request, "oneTimeCount");
		if ( count != oneTimeCount ) {
			_log.error("Count user accepted does not match current state");
			return;
		}
		
		Note note = null;
		Date eventDate = Toolbox.parseDate(request.getParameter("checkDate"));
		
		StipendConfig manualPayConf = null;
		WorkItemSupport workItem = new WorkItemSupport(CaretUtil.createWorkItem( sc, worIm.getGroupId(), 
				worIm.getClassId(), worIm.getClassPk(), worIm.getPersnId(), WorkType.MANUAL_PAYMENT.name(),
				worIm.getCaregiverId(), Toolbox.adjustDate( CbopcDashboardConfig.OCC_DUE_DAYS, sc.getCreateDate(), true) ) );
		
		if ( payLg != null ) {
			StiPt stiPt = new PaymentLog(payLg).getStipendConfig();
			manualPayConf = new StipendConfig( StipendConfig.getStipendConfig( stiPt.getStipendStartDate(), stiPt.getPayment(), stiPt.getTierHours(), stiPt.getBlsRateHourly() ) );
			manualPayConf.setVendrId( stiPt.getVendrId() );

			payLg.setStatus( "manual-payment-verified" );
			CaretLocalServiceUtil.save( payLg );
		} else {
			manualPayConf = new StipendConfig( StipendConfig.getStipendConfig( calendar.getTime(), "0", "0", "0") );
			manualPayConf.setVendrId( vendrId );
		}
		manualPayConf.setOneTimePayment( dollarAmount.toString() );
		manualPayConf.setStipendType(StipendConfig.ONE_TIME);
		manualPayConf.setStipendApprovedDate( eventDate );
		manualPayConf.setVcgId( worIm.getVcgId() );
		manualPayConf.setStipendStatus(StipendConfig.PAYMENT_FINANCE);

		workItem.setQueueId(WorkType.MANUAL_PAYMENT.workName.getQueueId());
		workItem.setVcgId( worIm.getVcgId() );
		workItem.setStatus("Edited, Approved");
		workItem.setCompletionDate(sc.getCreateDate());
		workItem.setCompletionBy(sc.getUserId());
		CaretLocalServiceUtil.save( workItem );
		
		note = CaretUtil.createNote(sc.getCreateDate(), worIm.getClassPk(), NoteSupport.NoteGroup.MANUAL_PAYMENT.groupId(), sc.getUserId(), comments);
		note.setVcgId(workItem.getVcgId());

		WorSe workItemState = new WorSeImpl();
		workItemState.setWorImId( workItem.getWorImId() );
//		long ownerId = Vendor.getPaymentStep( sc ).getOwnerId();
//		workItemState.setStepNumber( (int) ownerId );
		workItemState.setCreationDate( calendar.getTime() );//stores the Calendar paymentMonthDate of origin
		workItemState.setStep(comments.substring(0, Math.min( comments.length(), WorkItemSupport.WORK_ITEM_SUPPORT_NOTE_LENGTH ) ) );
		CaretLocalServiceUtil.save( workItemState );
		
//		manualPayConf.setWorSeId( ownerId );
		manualPayConf.setWorImId(workItem.getWorImId());
		CaretLocalServiceUtil.save( manualPayConf );
		
//		for ( StiPt pt : StiPtLocalServiceUtil.findByOneTimeStatus( manualPayConf.getVendrId(), new String[] { StipendConfig.PAYMENT_FINANCE } ) ){
//			if ( pt.getWorSeId() == workItemState.getWorSeId() ) continue;
//			pt.setWorSeId( ownerId );
//			CaretLocalServiceUtil.save( manualPayConf );
//		}
		
		ResultMap.getCaretMap(request).put("tabContext", "search" );
		ResultMap.getCaretMap(request).put("lastSearch", request.getPortletSession().getAttribute("lastSearch"));
	}
	
	public void stagePayments( ActionRequest request, ActionResponse response) throws ApplicationWorkFlowException, SystemException {
		
		String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
		if ( ! CaretParam.isTracked( request, tracker, true ) ){
			_log.warn("TRACKER BLOCKING action... ");
			request.setAttribute(CaretStrPool.INVALID_REQUEST, true);
			return;
		}
		if ( !CAction.canDoCaret(request, CAction.CaretCan.MANUAL_PAYMENT)  ) {
			_log.warn("permissioning... ");
			return;
		}
		
		
		boolean isThursday = false;
		boolean isMonthLastDay = false;
		
		Calendar today = Calendar.getInstance();
		if ( today.get(Calendar.DAY_OF_WEEK) == Calendar.THURSDAY ) {
			isThursday = true;
		}
		today.roll(Calendar.DAY_OF_MONTH, true);
		if ( today.get(Calendar.DAY_OF_MONTH) == 1 ) {
			isMonthLastDay = true;
		}
		
		ServiceContext sc = CaretParam.setCaretServiceContext(request);//ParamUtil.print( request )

		BgLae bgLae = null;
		if ( isThursday || isMonthLastDay ) {
			bgLae = Vendor.getPaymentStep(sc);
			if ( bgLae.getLargeText().startsWith(StipendConfig.SUBMITTED) || 
					bgLae.getLargeText().startsWith(StipendConfig.COMPLETED) ) { //payment was already submitted/responded, re-issue as daily...
				bgLae = null;
			}
		}
		
		long ownerId = Toolbox.getBgLaeDay();
		if ( bgLae == null ){
			bgLae = BgLaeLocalServiceUtil.getLastBgLae( ownerId );
			if ( bgLae != null && ( bgLae.getLargeText().startsWith(StipendConfig.SUBMITTED) || 
					bgLae.getLargeText().startsWith(StipendConfig.COMPLETED) ) ) { 
				bgLae = null;
			}
		}
		
		if ( bgLae == null ){
			//set up new daily payment request...
			Calendar calendar = Calendar.getInstance();
			BoxGp boxGp = Vendor.getOneTimeDailyBg(calendar);
			bgLae = new BgLaeImpl();
			bgLae.setOwnerId( ownerId );
			bgLae.setBoxGpId( boxGp.getBoxGpId() );
		}
		
		bgLae.setLargeText( StipendConfig.STAGED + Toolbox.formatDateTime( sc.getCreateDate()) );
		try {
			CaretLocalServiceUtil.save(bgLae);
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
			return;
		}
		long lockId = Monitor.lock(bgLae.getBoxGpId(), bgLae.getBgLaeId());
		if ( bgLae.getBoxGpId() != lockId ){
			//1 daily payment at a time...
//			return;
		}
		
		int count = 0;
		for ( String id: request.getParameter( "paymentConfig_rowCheckerIds").split(StringPool.COMMA ) ) {
			
			if ( "on".equals(id)) {
				continue;
			}
			
			StiPt stiPt = StiPtLocalServiceUtil.fetchStiPt( Long.valueOf(id) );
			if ( stiPt.getCycleId() > 0 ){
				BgLae bgl = BgLaeLocalServiceUtil.fetchBgLae( stiPt.getCycleId() );
				if ( bgl != null & bgLae.getLargeText().startsWith(StipendConfig.SUBMITTED) || //daily was already staged/submitted for this payment... 
						bgl.getLargeText().startsWith(StipendConfig.STAGED) || 
						bgl.getBoxGpId() == bgLae.getBoxGpId() ) { 
					_log.error("Submitted twice??" + stiPt.getStiPtId() + "::" + bgl);
					continue;
				}
			}
			_log.info("payment:" + stiPt.getOneTimePayment() + " for Vendor:" + stiPt.getVendrId() + " gets new cycleId:" + bgLae.getBgLaeId() );
			stiPt.setCycleId( bgLae.getBgLaeId() );
			CaretLocalServiceUtil.save( stiPt );
			count++;
		}
		
		Monitor.unlock(lockId);
		if ( count > 0 && CaretUtil.isEmailEnabled() ) {
			CaretUtil.sendPaymentNotificationMail(Collections.EMPTY_MAP);
		}
	}
	
	public void createOccWork( ActionRequest request, ActionResponse response) throws PortalException, SystemException  {
		
		String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
		if ( ! CaretParam.isTracked( request, tracker, true ) ){
			_log.warn("TRACKER BLOCKING action... ");
			request.setAttribute(CaretStrPool.INVALID_REQUEST, true);
			return;
		}
		
		String type = request.getParameter("type");
		WorkType workType;
		if ( "Lost Check".equals(type)) {
			workType = WorkType.LOST_CHECK;
		} else if ( "Returned/Rejected Payment".equals(type)) {
			workType = WorkType.RETURNED_PAYMENT;
		} else if ( "Held Payment".equals(type) ) {
			workType = WorkType.HELD_PAYMENT;
//		} else if ( "Rejected Payment".equals(type)) {
//			workType = WorkType.REJECTED_PAYMENT;
		} else {
			workType = WorkType.valueOf(type);
		}
		if ( workType == WorkType.MANUAL_PAYMENT ) {
			createManualPayment(request, response);
			return;
		}

		ServiceContext sc = CaretParam.setCaretServiceContext(request);
		long paymentLogId = ParamUtil.getLong(request, "paymentLogId");
		long worImId = ParamUtil.getLong(request, "worImId");

		if ( paymentLogId == 0 && worImId == 0 ) {
			return;
		}
		
		WorIm worIm = WorImLocalServiceUtil.getWorIm(worImId);
		String comments = request.getParameter("worIm_comments");

		long groupId = 0;
		PayLg payLg = PayLgLocalServiceUtil.fetchPayLg(paymentLogId);
		if ( payLg != null ) {
			groupId = paymentLogId;
		} else {
			groupId = worImId;
		}
		WorkItemSupport manualWorkItem = new WorkItemSupport(CaretUtil.createWorkItem( 
				sc, groupId, 
				worIm.getClassId(), worIm.getClassPk(), worIm.getPersnId(), workType.name(),
				worIm.getCaregiverId(), Toolbox.adjustDate(CbopcDashboardConfig.OCC_DUE_DAYS, sc.getCreateDate(), true) ) );
		long vendrId = VendrLocalServiceUtil.findByPersnId( manualWorkItem.getCaregiverId() ).getVendrId();
		manualWorkItem.setQueueId(workType.workName.getQueueId());
		manualWorkItem.setVcgId(worIm.getVcgId());
		
		
		Note note = null;
		StiPt secondary = null;
		Date checkDate = Toolbox.parseDate( request.getParameter("checkDate") );
		int checkNum = ParamUtil.getInteger(request, "checkNumber");
		WorSe workItemState = new WorSeImpl();
		
		if ( workType == WorkType.LOST_CHECK || workType == WorkType.RETURNED_PAYMENT ) {
			manualWorkItem.setStatus(CaretStrPool.PENDING);
			long noteGroupId;
			if ( workType == WorkType.LOST_CHECK ) {
				noteGroupId = NoteSupport.NoteGroup.LOST_CHECK.groupId();
			} else { //Manual Reject Payment... WorkType.RETURNED_PAYMENT
				noteGroupId = NoteSupport.NoteGroup.RETURNED_PAYMENT.groupId();
				manualWorkItem.setStatus("Hold placed on account");
				for ( StiPt toHold : StiPtLocalServiceUtil.findByRecurrentVendor(vendrId, new String[] {StipendConfig.PAYMENT_FINANCE}) ){
					toHold.setStipendStatus(StipendConfig.ON_HOLD);
					CaretLocalServiceUtil.save(toHold);
					_log.info("hold placed on recurring stiPt:" + toHold.getStiPtId() );
				}
				
			}
			
			note = CaretUtil.createNote(sc.getCreateDate(), paymentLogId, noteGroupId, sc.getUserId(), comments);
			
			secondary = new StiPtImpl();
			if ( payLg != null ) {
				payLg.setStatus( "CREATED:" + workType.name() );
				CaretLocalServiceUtil.save( payLg );

				manualWorkItem.setGroupId( payLg.getPaymentLogId() );
				
				secondary.setOneTimePayment( payLg.getAmount().toString() );
				secondary.setVendrId(payLg.getVendrId());
			} else {
				Object dollarAmountObj;
				try {
					dollarAmountObj = NumberFormat.getCurrencyInstance(Locale.getDefault()).parseObject(request.getParameter("checkAmount"));
					secondary.setOneTimePayment( dollarAmountObj.toString() );
				} catch (ParseException e) {
					e.printStackTrace();
				}
			}
			secondary.setStipendType(StipendConfig.ONE_TIME);
			workItemState.setStep(comments.substring(0, Math.min( comments.length(), WorkItemSupport.WORK_ITEM_SUPPORT_NOTE_LENGTH ) ) );
			Calendar cycleMonth = Calendar.getInstance();
			cycleMonth.clear();
			cycleMonth.set(ParamUtil.getInteger(request, "config_cycle_year"), ParamUtil.getInteger(request, "config_cycle_month"), 1);
			secondary.setStipendStartDate(cycleMonth.getTime());
			secondary.setStipendStatus( StipendConfig.ON_HOLD );
		}  else if ( workType == WorkType.RECOUPMENT ) {
			manualWorkItem.setStatus(CaretStrPool.RECOUPMENT_INITIATED);
			note = CaretUtil.createNote(sc.getCreateDate(), paymentLogId, NoteSupport.NoteGroup.RECOUPMENT.groupId(), sc.getUserId(), comments);
		} else if ( workType == WorkType.HELD_PAYMENT ) {
			manualWorkItem.setStatus("Hold placed on account");
			
			secondary = StiPtLocalServiceUtil.findByWorIm(worImId);
			if ( ParamUtil.getBoolean(request, "holdAllPayments") ) {
				for ( StiPt sp: StiPtLocalServiceUtil.findByVendorId( secondary.getVendrId(), new String[] {StipendConfig.PAYMENT_FINANCE} ) ) {
					if ( StipendConfig.PAYMENT_FINANCE.equals( sp.getStipendStatus() ) ) {
						if ( sp.getStiPtId() == secondary.getStiPtId() ) {
							secondary.setStipendStatus(StipendConfig.ON_HOLD);
						} else {
							sp.setStipendStatus(StipendConfig.ON_HOLD);
							CaretLocalServiceUtil.save(sp);
						}
					}
				}
				manualWorkItem.setGroupId( secondary.getVendrId() );
				workItemState.setStep(CaretStrPool.HOLD_PLACED_ON_ACCOUNT);
				checkDate = sc.getCreateDate();
			} else {
				if ( StipendConfig.PAYMENT_FINANCE.equals( secondary.getStipendStatus() ) ) {
					secondary.setStipendStatus(StipendConfig.ON_HOLD);
					manualWorkItem.setGroupId( secondary.getStiPtId() );
				}
				workItemState.setStep(StipendConfig.ON_HOLD);
			}
			workItemState.setOldStep( request.getParameter("worIm_heldPaymentReason") );
			note = CaretUtil.createNote(sc.getCreateDate(), secondary.getVcgId(), NoteSupport.NoteGroup.HELD_PAYMENT.groupId(), sc.getUserId(), comments);
		}
		CaretLocalServiceUtil.save( manualWorkItem );

		note.setVcgId(manualWorkItem.getVcgId());
		note.setChainId(manualWorkItem.getWorImId());
		NoteLocalServiceUtil.addNote(note);
		
		if ( secondary.getStiPtId() == 0 ) {
			secondary.setVcgId( manualWorkItem.getVcgId() );
			secondary.setWorImId( manualWorkItem.getWorImId() );
			secondary.setVendrId( vendrId );
		}
		CaretLocalServiceUtil.save( secondary );
		
		
		workItemState.setStepNumber(checkNum);
		workItemState.setWorImId( manualWorkItem.getWorImId() );
		
		workItemState.setUserId(sc.getUserId());
		workItemState.setCreationDate(checkDate);
		CaretLocalServiceUtil.save( workItemState );
		
		
//		if ( secondary != null ) {
//			secondary.setWorImId(workItem.getWorImId());
//			CaretLocalServiceUtil.save( secondary );
//		}
//		
//		if ( payLg != null ) {
//			payLg.setStatus( workType.name() );
//			CaretLocalServiceUtil.save( payLg );
//		}
		
		ResultMap.getCaretMap(request).put("tabContext", "search" );
		if ( workType == WorkType.HELD_PAYMENT ) {
			request.getPortletSession().getAttribute("lastSearch");
		}
 		ResultMap.getCaretMap(request).put("lastSearch", request.getPortletSession().getAttribute("lastSearch"));
		
	}
	
	public void saveCSCAppeal( ActionRequest actionRequest, ActionResponse response)  {
		getOutput(actionRequest);
		
		try {
			ServiceContext sc = CaretParam.setCaretServiceContext(actionRequest);
			Apeal a = new ApealImpl();
			Apeal apeal = (Apeal) CaretParam.loadModel(actionRequest, new ApealImpl(), a.getModelAttributes().keySet(), CaretStrPool.APPEALED_UNDERLINE);
			apeal.setCreationDate(new Date());
			
			CaretLocalServiceUtil.save( apeal );
			
			String tracker = ParamUtil.getString(actionRequest, CaretStrPool.TRACKER, StringPool.BLANK );
			List<Docum> documents = DocumLocalServiceUtil.getByTrackerNote( tracker );
			for ( Docum docum : documents ){
				if ( docum.getClassPk() == 0 ){
					docum.setClassPk(apeal.getApealId());
					docum.setClassId(PortalUtil.getClassNameId(Apeal.class));
					docum.setNote(StringPool.BLANK);
					try {
						DocumLocalServiceUtil.updateDocum(docum);
					} catch (SystemException e) {
						e.printStackTrace();
					}
				}
			}
			
			
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
	}
	
	public void saveVCGSupportingDocument( ActionRequest actionRequest, ActionResponse response)  {
		getOutput(actionRequest);
		try {
			ServiceContext sc = CaretParam.setCaretServiceContext(actionRequest);
			String tracker = ParamUtil.getString(actionRequest, CaretStrPool.TRACKER, StringPool.BLANK );
			List<Docum> documents = DocumLocalServiceUtil.getByTrackerNote( tracker );
			long vcgId = ParamUtil.getLong(actionRequest, CaretStrPool.VCGID );
			String type = ParamUtil.get(actionRequest, CaretStrPool.TYPE, StringPool.BLANK);
			
			VcgAn vcgAn;
			for ( Docum docum : documents ){
				vcgAn = VcgAnLocalServiceUtil.getRecent(vcgId);
				Long vcgAnId = vcgAn.getVcgAnId();
				if ( docum.getClassPk() == 0 ){
					docum.setClassPk(vcgAnId);
					docum.setClassId(PortalUtil.getClassNameId(VcgAn.class));
					docum.setNote(StringPool.BLANK);
					docum.setType(type);
					try {
						DocumLocalServiceUtil.updateDocum(docum);
					} catch (SystemException e) {
						e.printStackTrace();
					}
				}
			}
			
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
	}
	
	@ProcessAction (name="messageActions")
	public void messageActions( ActionRequest actionRequest, ActionResponse actionResponse ) {
		String messageAction = ParamUtil.get(actionRequest, "messageAction", StringPool.BLANK);
		_log.info("messageActions..." +  messageAction );
				PMPortlet.render(actionRequest, actionResponse);
				actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.INTERNAL_MESSAGES_PAGE+actionRequest.getAttribute("targetPath"));
	}
	
	
	
	@ProcessAction (name="electPayment")
	public void electPayment ( ActionRequest request, ActionResponse actionResponse ) throws SystemException {
		
		
		ServiceContext sc = CaretParam.setCaretServiceContext(request);
		String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK ); 
		String type = ParamUtil.getString(request, CaretStrPool.TYPE, StringPool.BLANK );
		
		Calendar today = Calendar.getInstance();
		Date payDate = today.getTime();
		
		boolean isThursday = false;
		boolean isMonthLastDay = false;
		
		if ( today.get(Calendar.DAY_OF_WEEK) == Calendar.THURSDAY ) {
			isThursday = true;
		}
		today.roll(Calendar.DAY_OF_MONTH, true);
		if ( today.get(Calendar.DAY_OF_MONTH) == 1 ) {
			isMonthLastDay = true;
		}
		
		try {
			BgLae bgLae = null;
			if ( isThursday || isMonthLastDay ) {
				bgLae = Vendor.getPaymentStep(sc);
				
				if (    bgLae.getLargeText().startsWith(StipendConfig.SUBMITTED) || 
						bgLae.getLargeText().startsWith(StipendConfig.COMPLETED) ) { //payment was already sent, re-issue as daily...
					
					bgLae = null;
				}
			} 
			
			Calendar calendar = Calendar.getInstance();

			if ( bgLae == null ){
				BoxGp boxGp = Vendor.getOneTimeBg(calendar);
				bgLae = new BgLaeImpl();
				bgLae.setOwnerId( Toolbox.getBgLaeDay() );
				bgLae.setBoxGpId( boxGp.getBoxGpId() );
			}
			
			bgLae.setLargeText( "PENDING-" + Toolbox.formatDateTime( sc.getCreateDate()) );
			CaretLocalServiceUtil.save(bgLae);

			
			Calendar cal = Calendar.getInstance();
			cal.setTime(payDate);
			cal.roll(Calendar.SECOND, true);
			Date logDate = cal.getTime();
			
			for ( StiPt stiPt : StiPtLocalServiceUtil.findByUpdatePending(StipendConfig.ONE_TIME, logDate) ) {
				_log.info("payment:" + stiPt.getOneTimePayment() + " for Vendor:" + stiPt.getVendrId() + " gets new worseId:" + bgLae.getBgLaeId() );
				stiPt.setCycleId( bgLae.getBgLaeId() );
				CaretLocalServiceUtil.save( stiPt );
			}
		
			CaretLocalServiceUtil.setFmsOut( String.valueOf( bgLae.getOwnerId() ), String.valueOf( bgLae.getBgLaeId() ), payDate, true);
						
			try {
				long nextCycleId = Vendor.initMonth( cal, false ).getBgLaeId();
				StiPtLocalServiceUtil.findByUpdatePending(StipendConfig.RECURRING, logDate);
				for ( StiPt stiPt : StiPtLocalServiceUtil.findByUpdatePending(StipendConfig.RECURRING, logDate) ) {
					_log.info("payment:" + stiPt.getOneTimePayment() + " for Vendor:" + stiPt.getVendrId() + " gets new worseId:" + bgLae.getBgLaeId() );
					stiPt.setCycleId( nextCycleId );
					CaretLocalServiceUtil.save( stiPt );
				}
			} catch (SystemException e1) {
				e1.printStackTrace();
			}
			if ( CaretUtil.isMockFmsEnabled() ) {
				//mock the FMS service response...
				CaretLocalServiceUtil.mockService( String.valueOf( bgLae.getOwnerId() ), String.valueOf( bgLae.getBgLaeId() ), true );
				//TODO: test it where an response is not returned and additional payments are submitted
			}
			FmsOgSupport.loadPayLog( bgLae, logDate );
			
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		}
	}
		
	@ProcessAction (name="occFmSubmit")
	public void occFmSubmit( ActionRequest request, ActionResponse actionResponse ) {
		
		String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK ); 
		String type = ParamUtil.getString(request, CaretStrPool.TYPE, StringPool.BLANK );
		
		_log.info("mockService:" + request.getParameter("mockService") );
		
		ServiceContext sc = CaretParam.setCaretServiceContext(request);

		if ( CAction.CaretCan.FMS_SERVICE.name().equals(type) ) {
			try {
				electPayment(request, actionResponse);
			} catch (SystemException e) {
				e.printStackTrace();
			}
		}
		
		if ( CAction.CaretCan.UPDATE_FUNDING.name().equals(type) ) {
			
			Double funds = 0.0;
			Double trhld = 0.0;
			try {
				Object dollarAmountObj = NumberFormat.getCurrencyInstance(Locale.getDefault()).parseObject(request.getParameter("amount"));
				funds = Double.valueOf(dollarAmountObj.toString());
				
				dollarAmountObj = NumberFormat.getCurrencyInstance(Locale.getDefault()).parseObject(request.getParameter("threshold"));
				trhld = Double.valueOf(dollarAmountObj.toString());
			} catch (ParseException e1) {
				e1.printStackTrace();
			}

			String obligationDate = ParamUtil.getString(request, "obligationDate", StringPool.BLANK );
			String poNumber = ParamUtil.getString(request, "poNumber", StringPool.BLANK );
			String obligationNote = ParamUtil.getString(request, "obligation_note", StringPool.BLANK );
			
			_log.info("amount..." +  funds );
			_log.info("obligationDate..." +  obligationDate );
			_log.info("poNumber..." +  poNumber );
			_log.info("obligationNote..." +  obligationNote );
			if ( funds > 0 ){
				try {
					BgNum num = BoxGpLocalServiceUtil.getBoxGroupBgNum( CbopcFmDashboardConfig.AVAILABLE_ID ).get(0);
					String direction = ParamUtil.getString(request, "funds" );
					if ( "increase".equals(direction) ) {
						num.setValue( num.getValue() + funds );
					} else {
						num.setValue( num.getValue() - funds );
					}
					CaretLocalServiceUtil.save(num);
				} catch (ApplicationWorkFlowException e) {
					e.printStackTrace();
				}
			}
			if ( trhld > 0 ){
				try {
					BgNum num = BoxGpLocalServiceUtil.getBoxGroupBgNum( CbopcFmDashboardConfig.THRESHOLD_ID ).get(0);
					num.setValue( trhld );
					CaretLocalServiceUtil.save(num);
				} catch (ApplicationWorkFlowException e) {
					e.printStackTrace();
				}
			}
			String note = request.getParameter("obligation_note");
			try {
				DashboardConfig dashConfig = ( DashboardConfig ) request.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG );
				NoteLocalServiceUtil.addNote( CaretUtil.createNote(sc.getCreateDate(), dashConfig.getRoleId(), NoteSupport.NoteGroup.OCC_FM.groupId(), PortalUtil.getUserId(request), note));
			} catch (SystemException e) {
				e.printStackTrace();
			}
		}
	}
	
	@ProcessAction (name="selectRole")
	public void selectRole( ActionRequest request, ActionResponse actionResponse ) throws ApplicationWorkFlowException, PortalException, SystemException {
		
		if ( StringPool.TRUE.equals( PortletProps.get(CaretStrPool.ROLES_SELECTION_ENABLED ) ) ) {
			String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
	
			if ( ! CaretParam.isTracked( request, tracker, true ) ){
				_log.warn("TRACKER BLOCKING action... ");
				request.setAttribute(CaretStrPool.INVALID_REQUEST, true);
				return;
			}
			long roleId = ParamUtil.getLong(request,  "role" );
			_log.info("reached save selected Role..... " + roleId);
			if ( roleId > 0 ){
				Role role = RoleLocalServiceUtil.getRole(roleId);
				long orgId = 0;
				boolean validates = true;
				if ( role.getName().toLowerCase().startsWith("csc") ){
					validates = (orgId = ParamUtil.getLong(request,  "facility" )) > 0;
				} else if ( role.getName().toLowerCase().startsWith("visn") ){
					validates = (orgId = ParamUtil.getLong(request,  "visn" )) > 0;
				}
				if ( validates ){
					Long[] orgIds = orgId > 0? new Long[]{orgId}: new Long[0];
					CodifiedRole.updateClinicRole( PortalUtil.getUserId(request), new long[]{ role.getRoleId() }, orgIds );
				}
			}
		}
	}
	
	private static Log _log = LogFactoryUtil.getLog( CaretActionCommand.class );
}
