package gov.va.caret.model.support.occ;


import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringPool;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.AudLg;
import gov.va.caret.model.support.AuditLogSupport;
import gov.va.caret.model.support.WorkItemSupport;
import gov.va.caret.service.CaretLocalServiceUtil;


public class UnchangedPayment extends InitialPayment implements PersonChange {
	
	private static Log _log = LogFactoryUtil.getLog(UnchangedPayment.class);
	private List<AuditLogSupport> retList;
	private String who;
	private String when;
	
	
	public UnchangedPayment(WorkItemSupport workItem, Calendar paymentMonthDate) {
		super(workItem, null, paymentMonthDate);
	}

	public boolean isCalculationWork(){
		return false;
	}
	//TODO: move this to WorItemSupport...
	public List<AuditLogSupport> getChanges(){
		if ( retList == null ){
			try {
				String[] attributes = null;
				long[] classPk = null;
				switch( ((WorkItemSupport)workItem).getWorkType() ){
				case PII_CHANGE:
					classPk = new long[] {workItem.getPersnId(), workItem.getCaregiverId()};
					attributes = new String[] {"gender", "birthDate", "ssn"};
					break;
				case NAME_CHANGE:
					classPk = new long[] {workItem.getPersnId(), workItem.getCaregiverId()};
					attributes = new String[] {"lastName", "firstName", "middleName"};
					break;
				case ADDRESS_CHANGE: 
					classPk = new long[] {workItem.getCaregiverId()};
					attributes = new String[] {"address", "zip", "city", "state", "country"};
					break;
				case INSURANCE_CHANGE:
					classPk = new long[] {workItem.getPersnId(), workItem.getCaregiverId()};
					attributes = new String[] {"otherHealthInsurance","mediEnrolled","vaHealthEnrolled","otherHealthInsuranceYesNo","mediEnrolledYesNo","vaHealthEnrolledYesNo"};
					break;
				case V_INFO_CHANGE:
					classPk = new long[] {workItem.getPersnId()};
					attributes = new String[] {"lastName", "firstName", "middleName", "gender", "birthDate", "ssn", "phone"};
					break;
				case C_INFO_CHANGE:
					classPk = new long[] {workItem.getCaregiverId()};
					attributes = new String[] {"lastName", "firstName", "middleName", "gender", "birthDate", "ssn", "phone"};
					break;
				default:
					classPk = new long[] {workItem.getWorImId()};
					attributes = new String[] {"WorIm"};
				}
				this.retList = new ArrayList<AuditLogSupport>();
				for ( AudLg lg: CaretLocalServiceUtil.getChange( workItem.getCreationDate(), classPk, attributes) ){
					retList.add(new AuditLogSupport(lg));
				}
				return retList;
			
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			}
			retList = Collections.emptyList();
		}
		return retList;
	}

	public String getWho() {
		if ( who == null ){
			if ( retList == null ){
				getChanges();
			}
			if ( retList.isEmpty() ){
				who = StringPool.BLANK;
			} else {
				who = retList.get(0).getModifiedBy();
			}
		}
		return who;
	}

	public String getWhen() {
		if ( when == null ){
			if ( retList == null ){
				getChanges();
			}
			if ( retList.isEmpty() ){
				when = StringPool.BLANK;
			} else {
				when = retList.get(0).getModificationDate();
			}
		}
		return when;
	}
	
}

