package gov.va.caret.model.support.occ;


import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.BlsRe;
import gov.va.caret.model.Persn;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.StiPtWrapper;
import gov.va.caret.model.Vendr;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.WorSe;
import gov.va.caret.model.impl.StiPtImpl;
import gov.va.caret.model.impl.WorSeImpl;
import gov.va.caret.model.support.VcgSupport;
import gov.va.caret.model.support.WorkItemSupport;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.BlsReLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VendrLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.service.WorSeLocalServiceUtil;
import gov.va.caret.util.Toolbox;

public class StipendConfig extends StiPtWrapper {

	private static final long serialVersionUID = 1L;
	WorSe workItemStep = null;
	/*
	a.	Monthly recurring amount 
	b.	Back pay amount
	c.	Final payment amount 
	d.	Recoupment amount
	e.	Monthly rate
	g.	Daily rate
	h.	Prorated amount and dates
	i.	Number of retroactive months
	
	f.	Hourly rate
	j.	Veterans zip code
	k.	Transaction date (application approval date)
	l.	Tier level
	 */
	public static final StipendConfig NULLCONFIG = new StipendConfig(null) {
//		public long getStiPtId() {return 0l;}
		public String getTier() { return "0"; }
		public String getTierHours() { return "0"; }
		public String getBlsRateHourly() { return "0.0";}
		public String getPayment() { return "0.0";}
	};
	
	public static final String OBSOLETE_PAYMENT = "PAYMENT_OBSOLETE";
	public static final String ON_HOLD = "PAYMENT_HOLD";
	public static final String PAYMENT_REJECTED = "PAYMENT_REJECTED";
	public static final String PAYMENT_FINANCE = "PAYMENT_FINANCE";
	public static final String STAGED_PAYMENT = "STAGED_PAYMENT";
	public static final String ONE_TIME = "one-time";
	public static final String RECURRING = "recurring";
	
	public static final String[] OCC_PAYMENT_STATUSES = new String[] { PAYMENT_FINANCE, OBSOLETE_PAYMENT, ON_HOLD };
	
	public static final BigDecimal MONTH_MULTIPLIER = new BigDecimal( PortletProps.get("bls.payment.weeks") );
	public static final BigDecimal TIER_3_MONTH_HOURS = StipendConfig.MONTH_MULTIPLIER.multiply( new BigDecimal( Integer.getInteger( PortletProps.get( "tier3.hours"), 40 ) ) );
	public static final BigDecimal TIER_2_MONTH_HOURS = StipendConfig.MONTH_MULTIPLIER.multiply( new BigDecimal( Integer.getInteger( PortletProps.get( "tier2.hours"), 25 ) ) );
	public static final BigDecimal TIER_1_MONTH_HOURS = StipendConfig.MONTH_MULTIPLIER.multiply( new BigDecimal( Integer.getInteger( PortletProps.get( "tier1.hours"), 10 ) ) );

	public static final int WEEK_YEAR_0 = 2018 * 52;
	public static final int MONTH_YEAR_0 = 2018 * 12;
	public static final String STAGED = "STAGED-";
	public static final String PENDING = "PENDING-";
	public static final String SUBMITTED = "SUBMITTED-";
	public static final String COMPLETED = "COMPLETED-";
	
	private static Log _log = LogFactoryUtil.getLog( StipendConfig.class );

	private WorIm workItem = null;
	private Vendr vendor = null;
	private String veteranName = null;
	
	public StipendConfig(StiPt stiPt) {
		super(stiPt);
	}

	public static StiPt getStipendConfig( Date stipendStartDate, String payment, String tierHours, String blsRateHourly ) {
		StiPt stiPt = new StiPtImpl();
		stiPt.setStipendStartDate(stipendStartDate);
		stiPt.setPayment(payment);
		stiPt.setTierHours(tierHours);
		stiPt.setBlsRateHourly(blsRateHourly);
		return stiPt;
	}

	//Caregivers Effective Date is always the Application Received Date
	//The date the Application was received
	//AKA Effective Date.  Approval Date must be after applicationReceivedDate
	public Date getEffectiveDate() {
		return super.getStipendStartDate();
	}

	
	@Override
    public void persist() throws com.liferay.portal.kernel.exception.SystemException {
        super.persist();
        if ( workItemStep != null ){
        	workItemStep.persist();
		}
    }
	
	//Used only during save...
	public void setFields( Date effectiveDate, VcgSupport vcg, WorkItemSupport workItem, ServiceContext sc, String oldVal, String newVal ) throws ApplicationWorkFlowException {
		
		BlsRe bls = BlsReLocalServiceUtil.findLatestBlsByZip( vcg.getVeteran().getZip() );
		setBlsRateHourly( String.valueOf( bls.getH75() ) );
		setTier( String.valueOf( vcg.getTierLevel() ) );
		setTierHours( String.valueOf( getTierLevelMonthlyHours( getTier() )  ) );
		setWorImId( workItem.getWorImId() );
		if ( !"PAYMENT_OBSOLETE".equals( getStipendStatus() ) ) {
			setStipendStatus( workItem.getType() );
		}
		setStipendStartDate( effectiveDate );
		if ( WorkType.REVOKED_DISPOSITION.name().equals( workItem.getType() ) ) {
			setStipendType( ONE_TIME );
		} else {
			setStipendType( RECURRING );
		}
		
		setPayment( getMonthlyRate( bls.getH75(), vcg.getTierLevel() ).toString() );
		setICN( vcg.getPrimary().getICN() );
		setVcgId( vcg.getVcgId() );
		
		workItemStep = new WorSeImpl();
		workItemStep.setWorImId( workItem.getWorImId() );
		workItemStep.setCreationDate( sc.getCreateDate() );
		workItemStep.setUserId( sc.getUserId() );
		int count = WorSeLocalServiceUtil.getCount ( workItem.getWorImId() );
		workItemStep.setStepNumber(count+1);
		workItemStep.setOldStep( oldVal );
		workItemStep.setStep( newVal );
	
		CalculationInfo calculationInfo = workItem.getCalcInfo( this );
		_log.info( calculationInfo );

	}
	
	public static BigDecimal getMonthlyRate(Double localRate, int tierLevel ) {
		if ( tierLevel == 0 ) {
			return BigDecimal.ZERO;
		}
		BigDecimal monthlyRate= new BigDecimal( localRate ).multiply( getTierLevelMonthlyHours( tierLevel  ) );
		monthlyRate = new BigDecimal( String.valueOf( monthlyRate.doubleValue() ) ).setScale( 2, RoundingMode.HALF_UP );
		return monthlyRate;
	}

	public static BigDecimal getTierLevelMonthlyHours( String level ){
		if ( Toolbox.isEmpty(level) ){
			return BigDecimal.ZERO;
		}
		return getTierLevelMonthlyHours( Integer.valueOf(level) );
	}
	
	public static BigDecimal getTierLevelMonthlyHours( int level ){
		switch( Integer.valueOf( level ) ){
		case 1: return StipendConfig.TIER_1_MONTH_HOURS;
		case 2: return StipendConfig.TIER_2_MONTH_HOURS;
		case 3: return StipendConfig.TIER_3_MONTH_HOURS;
		default: return BigDecimal.ZERO; 
		}
	}
	
	public String getVendorName() throws SystemException {
		if ( getVendor() != null ) {
			return vendor.getLastName() + StringPool.COMMA_AND_SPACE + vendor.getFirstName();
		}
		return StringPool.BLANK;
	}
	
	public String getVerifierName() throws SystemException {
		if ( getWorkItem() != null ) {
			User verifier = UserLocalServiceUtil.fetchUser(workItem.getCompletionBy());
			if ( verifier != null ) {
				return verifier.getLastName() + StringPool.COMMA_AND_SPACE + verifier.getFirstName();
			}
		}
		return StringPool.BLANK;
	}
	
	public Vendr getVendor() throws SystemException {
		if ( vendor == null ) {
			vendor = VendrLocalServiceUtil.fetchVendr(getVendrId());
		}
		return vendor;
	}

	public WorIm getWorkItem() throws SystemException {
		if ( workItem == null ) {
			workItem = WorImLocalServiceUtil.fetchWorIm(getWorImId());
		}
		return workItem;
	}
	
	public String getVeteranName() throws SystemException {
		if ( veteranName == null ) {
			Persn veteran = PersnLocalServiceUtil.fetchPersn( getWorkItem().getPersnId() );
			if ( veteran != null ) {
				veteranName = veteran.getLastName() + StringPool.COMMA_AND_SPACE + veteran.getFirstName();
			}
		}
		return veteranName;
	}
	
	public String getReason() throws SystemException  {
		if ( getWorkItem() != null ) {
			return workItem.getType();
		}
		return StringPool.BLANK;
	}
	
	public long getVcgAnId() throws SystemException {
		if ( getWorkItem() != null ) {
			return getWorkItem().getClassPk();
		}
		return 0;
	}
	
	public String getStipendStartDateStr(){
		return Toolbox.formatDate(getStipendStartDate());
	}
	
	public String getStipendApprovedDateStr(){
		return Toolbox.formatDate(getStipendApprovedDate());
	}
	
	public String getPayslipDateStr(){
		return Toolbox.formatDate(getPayslipDate());
	}
	
	public void setPayslipDate(Date payslipDate) {
		if ( getPayslipDate() == null ) {
			super.setPayslipDate(payslipDate);
		}
	}
	
    public void setStipendStatus(java.lang.String stipendStatus) {
    	if ( StipendConfig.RECURRING.equals( getStipendType() ) && StipendConfig.OBSOLETE_PAYMENT.equals( super.getStipendStatus() ) ) {
   			_log.error("Invalid state...");
   			return;
    	}
    	super.setStipendStatus(stipendStatus);
    }
    
    public String getPaymentTypeStr() throws SystemException {
		return LanguageUtil.get( LocaleUtil.getDefault(), getReason() ) + " " + LanguageUtil.get( LocaleUtil.getDefault(), getStipendType() );
    }
	
	public String getPaymentStatusStr() throws SystemException{
		return LanguageUtil.get( LocaleUtil.getDefault(), getStipendStatus() ) ;
	}
	
	public String getPaymentStatusStage() throws SystemException {
		return isStaged()?
			(getPaymentStatusStr() + " Staged"):
				getPaymentStatusStr() ;
	}

	public boolean isRecurring() {
		return ( StipendConfig.RECURRING.equals( getStipendType() ) || getPayslipDate() != null ) && StipendConfig.PAYMENT_FINANCE.equals( getStipendStatus() );
	}
	
	public boolean isStaged() {
		if ( PAYMENT_FINANCE.equals( getStipendStatus() ) ) {
			if ( getCycleId() > 0 ) {
				try {
					BgLae bl = BgLaeLocalServiceUtil.fetchBgLae(getCycleId());
					return ( bl != null && ( bl.getLargeText().startsWith(STAGED) ||
							bl.getLargeText().startsWith(SUBMITTED) ) );
				} catch (SystemException e) {
					e.printStackTrace();
				}
			}
		}
		return false;
	}

	public static Calendar toCalendar(long cycle) {
		Calendar calendar = Calendar.getInstance();
		calendar.set( Calendar.MONTH, (int)(cycle % 12) - 1 );
		calendar.set( Calendar.YEAR, (int)cycle / 12 );
		calendar.set( Calendar.DAY_OF_MONTH, 1);
		return calendar;
	}

}
