package gov.va.caret.model.support.occ;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;

import gov.va.caret.model.StiPt;
import gov.va.caret.model.WorIm;
import gov.va.caret.util.Toolbox;


public class InitialPayment extends CalculationWrapper {

	private BigDecimal totalStipend;  				//[Monthly Amount] + [Prorated Amount] + [Back Pay] OCC Super must review if > 35k
	private BigDecimal backPay = null;				//[Number of Retro Months] * [Monthly Amount]
	private Boolean recurring = null;

	public InitialPayment(WorIm workItem, StiPt config, Calendar paymentMonthDate ) {
		super(workItem, config, paymentMonthDate);
	}

	public BigDecimal getBackPayAmount(){
		if (  isRecurring() ) {
			return defaultValue;
		} 
		if ( backPay == null ){
			backPay = new BigDecimal( getRetroactiveMonths() ).multiply( getMonthlyRate() );
		}
		return backPay;
	}
	
	public BigDecimal getFinalAmount(){
		if ( totalStipend == null ){
			if ( StipendConfig.ONE_TIME.equals( getStipendPaymentConfig().getStipendType() ) || BigDecimal.ZERO.equals( getMonthlyRate() ) ) {
				return new BigDecimal(getStipendPaymentConfig().getOneTimePayment());
			}
			if (  isRecurring() ) {
				totalStipend = getMonthlyRate();
			} else {
				Calendar lastDayStipendStartMonth = Calendar.getInstance();
				lastDayStipendStartMonth.setTime( config.getStipendStartDate() );
				
				if ( Calendar.DECEMBER == lastDayStipendStartMonth.get( Calendar.MONTH ) ){
					lastDayStipendStartMonth.roll( Calendar.YEAR, true);
				}
				lastDayStipendStartMonth.roll(Calendar.MONTH, true);
				
//			if ( lastDayStipendStartMonth.getTime().after( getPaymentDate() ) || lastDayStipendStartMonth.getTime().equals( getPaymentDate() ) ){
				if ( !getPaymentDate().after( lastDayStipendStartMonth.getTime() ) ) {
					totalStipend = getProratedAmount().add( getBackPayAmount() );
				} else {
					totalStipend = getMonthlyRate().add( getProratedAmount() ).add( getBackPayAmount() );
				}
			}
			totalStipend = new BigDecimal( String.valueOf( totalStipend.doubleValue() ) ).setScale( 2, RoundingMode.HALF_UP );
		}
		return totalStipend;
	}
	
	public static String getFinalAmount ( String stipendStartDate, String payment, String tierHours, String blsRateHourly, Calendar payday  ) {
		return new InitialPayment(null, StipendConfig.getStipendConfig( Toolbox.parseDateTime(stipendStartDate), payment, tierHours, blsRateHourly ), payday).getFinalAmount().toString();
	}
	
	public static String getFinalAmount ( Date stipendStartDate, String payment, String tierHours, String blsRateHourly, Calendar payday  ) {
		return new InitialPayment(null, StipendConfig.getStipendConfig( stipendStartDate, payment, tierHours, blsRateHourly ), payday).getFinalAmount().toString();
	}
	
	//Junit tested...
	public int getTotalDays( ) {
		if ( paymentDate.before( config.getStipendStartDate() ) ) {
			return 0;
		}
		if (  isRecurring()  ) {
			return 0;
		} else {
			Calendar calendar = Calendar.getInstance();
			calendar.setTime( config.getStipendStartDate() );
			int applicationDay = calendar.get( Calendar.DAY_OF_MONTH );
			if ( applicationDay == 1) {
				return 0;				//full month will be accounted
			}
			calendar.set( Calendar.DAY_OF_MONTH, 1 );
			calendar.roll(Calendar.DAY_OF_MONTH, false );
			int endDateCurrentPaymentMonth = calendar.get( Calendar.DAY_OF_MONTH );
			return endDateCurrentPaymentMonth - applicationDay + 1;//to make the approval date inclusive
		}
	}
	
	public boolean isRecurring () {
		if ( recurring == null ) {
			recurring  = new Boolean( StipendConfig.RECURRING.equals(getStipendPaymentConfig().getStipendType()) &&
				getStipendPaymentConfig().getPayslipDate() != null && (getStipendPaymentConfig().getPayslipDate().compareTo( this.getPaymentMonthDate() ) < 0) );
		}
		return recurring;
	}
	
	//Application Date - End Date of Current Payment Month = Total Days
	public BigDecimal getProratedAmount(){  //getProratedAmount()
		if (  isRecurring() ) {
			return defaultValue;
		}
		int totaldays = getTotalDays();
		if ( totaldays == 0 ) {
			return getMonthlyRate();
		}
		return new BigDecimal( totaldays ).multiply( getDailyRate() );
	}
	
	@Override
	public BigDecimal getOneTimePayment() {
		if ( config.getPayslipDate() == null ) {
			//Monthly Stipend Payment+Backpay Prorate Amount = Total Stipend Payment
			return getMonthlyRecurringAmount().multiply(new BigDecimal( getRetroactiveMonths( ))).add( getProratedAmount() );
		}
		return defaultValue;
	}
	
	public BigDecimal getDailyRate(){
		if ( dailyRate == null ){
//			dailyRate = StipendConfig.getTierLevelMonthlyHours( config.getTier() ).multiply( new BigDecimal( config.getBlsRateHourly() ) ).multiply( new BigDecimal(12) ).divide( new BigDecimal(365), 2, RoundingMode.HALF_UP );
			dailyRate = new BigDecimal ( config.getTierHours() ).multiply( new BigDecimal( config.getBlsRateHourly() ) ).multiply( new BigDecimal(12) ).divide( new BigDecimal(365), 2, RoundingMode.HALF_UP );

		}
		return dailyRate;
	}
	

	public boolean isRecoupable(){
		return false;
	}

	public String toString () {
		return  "Stipend Payment Date: " + formatDate( getPaymentDate() ) + 
				"\n        With Begin Date: " + formatDate( config.getStipendStartDate() ) +
				"\n          Tier Level of: " + config.getTier() + 
				"\n Total Monthly Hours of: " + config.getTierHours() + 
				"\n   Local hourly Rate of: " + config.getBlsRateHourly() +
				"\n          Daily Rate of: " + getDailyRate() +
				"\n        Retro Months of: " + getRetroactiveMonths(  ) +
				"\n          Total Days of: " + getTotalDays(  ) +
				"\n           Payment owed: " + getFinalAmount(  ) +
				"\n------------------------------------------------" +
				"\n MonthlyRecurringAmount: " + getMonthlyRecurringAmount()+
				"\n          BackPayAmount: " + getBackPayAmount()+
				"\n            FinalAmount: " + getFinalAmount()+
				//getRecoupmentAmount();
				"\n         ProratedAmount: " + getProratedAmount()+
				"\n            MonthlyRate: " + getMonthlyRate()+
				"\n              DailyRate: " + getDailyRate()+
				"\n             HourlyRate: " + getHourlyRate()+
				"\n           ProratedDate: " + getProratedDate()+
				"\n      RetroactiveMonths: " + getRetroactiveMonths();
	}
}

