package gov.va.caret.model.support.occ;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;

import gov.va.caret.model.StiPt;
import gov.va.caret.model.WorIm;
import gov.va.caret.util.Toolbox;

public class CalculationWrapper implements CalculationInfo {

	BigDecimal defaultValue = BigDecimal.ZERO;
	
	protected WorIm workItem;
	protected StiPt config;
	protected Calendar paymentDate;
	private int stipendMonth;
	private int stipendYear;
	protected BigDecimal dailyRate = null;			//( ( [Tier Level Monthly Hours] * [Local Hourly Wage] ) * 12) / 365
	protected BigDecimal monthlyRate = null;		//1296.30 [Tier Level Monthly Hours] * [Local Hourly Wage]
	
	public CalculationWrapper(WorIm workItem, StiPt config, Calendar paymentMonthDate ) {
		this.workItem = workItem;
		this.config = config;
		this.paymentDate = paymentMonthDate;
		
		int payingMonth = paymentMonthDate.get(Calendar.MONTH);
		int payingYear = paymentMonthDate.get(Calendar.YEAR);
		if ( payingMonth == Calendar.JANUARY ) {
			this.stipendYear = payingYear - 1;
			this.stipendMonth = Calendar.DECEMBER;
		} else {
			this.stipendYear = payingYear;
			this.stipendMonth = payingMonth -1;
		}
	}
	
	public int getPaymentMonth() {
		return stipendMonth;
	}
	
	public int getPaymentYear() {
		return stipendYear;
	}
	
	public Date getPaymentMonthDate(  ){
		return paymentDate.getTime();
	}
	
	public Date getPaymentDate( ){
		return paymentDate.getTime();
	}
	
	@Override
	public String getProratedDate() {
		return null;
	}
	
	//Junit tested
	@Override
	public int getRetroactiveMonths( ){
		int totalMonths = -2;//to account for full month and partial month.
		Calendar rollingFirstDay = Calendar.getInstance();
		rollingFirstDay.setTime( config.getStipendStartDate() );
		
		for (  ; rollingFirstDay.getTime().before( getPaymentMonthDate(  ) ); totalMonths++ ) {
			if ( rollingFirstDay.get(Calendar.MONTH ) == Calendar.DECEMBER ){
				rollingFirstDay.roll( Calendar.YEAR, true );
				rollingFirstDay.roll( Calendar.MONTH, true );
			} else {
				rollingFirstDay.roll( Calendar.MONTH, true );
			}
		}
		return Math.max( totalMonths, 0 ) ;
	}

	@Override
	public BigDecimal getMonthlyRecurringAmount() {
		return getMonthlyRate();
	}
	
	public StiPt getStipendPaymentConfig (){
		return config;
	}

	public BigDecimal getMonthlyRate (  ) {
		if ( monthlyRate == null && config != null ) {
			monthlyRate = new BigDecimal( config.getPayment() );
		}
		if ( monthlyRate == null ) {
			monthlyRate = BigDecimal.ZERO;
		}
		return monthlyRate;
	}
	
	@Override
	public BigDecimal getBackPayAmount() {
		return defaultValue;
	}

	@Override
	public BigDecimal getFinalAmount() {
		return defaultValue;
	}

	@Override
	public BigDecimal getRecoupmentAmount() {
		return defaultValue;
	}

	@Override
	public BigDecimal getProratedAmount() {
		return defaultValue;
	}
	
	@Override
	public BigDecimal getHourlyRate() {
		return Toolbox.isEmpty( config.getBlsRateHourly() )?  BigDecimal.ZERO: new BigDecimal( config.getBlsRateHourly() );
	}

	@Override
	public BigDecimal getDailyRate(){
		if ( dailyRate == null ){
			BigDecimal configTierHours = new BigDecimal ( config.getTierHours() );
			dailyRate = new BigDecimal( config.getBlsRateHourly() ).multiply( configTierHours ).multiply( new BigDecimal(12) ).divide( new BigDecimal(365), 2, RoundingMode.HALF_UP );
		}
		return dailyRate;
	}

	
	public boolean isCalculationWork(){
		return true;
	}
	
	public boolean isCalculationChange(){
		return false;
	}
	
	public boolean isRecoupable(){
		return true;
	}
	
	public String formatDate( Date date ){
		return Toolbox.formatDate(date);
	}

	//Application Date - End Date of Current Payment Month = Total Days
	public int getTotalDays( ) {
		return 0;
	}

	@Override
	public BigDecimal getOneTimePayment() {
		return defaultValue;
	}
	
}

