package gov.va.caret.model.support.occ;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import com.liferay.portal.kernel.util.StringPool;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.AudLg;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.support.AuditLogSupport;
import gov.va.caret.service.CaretLocalServiceUtil;


public class AddressChange extends CalculationWrapper implements CalculationChange, PersonChange {

	private StiPt oldConfig;
	private BigDecimal oldDailyRate = null;			//( ( [Tier Level Monthly Hours] * [Local Hourly Wage] ) * 12) / 365
	private BigDecimal totalStipend;  				//[Monthly Amount] + [Prorated Amount] + [Back Pay] OCC Super must review if > 35k
	private List<AuditLogSupport> retList;
	private String who;
	private String when;

	public AddressChange(WorIm workItem, StiPt config, StiPt oldConfig, Calendar paymentMonthDate ) {
		super(workItem, config, paymentMonthDate);
		this.oldConfig = oldConfig == null? StipendConfig.NULLCONFIG: oldConfig;
	}
	
	public BigDecimal getTotalStipend(){
		if ( totalStipend == null ){
			totalStipend = getMonthlyRate().subtract( getOldMonthlyRate() );
			totalStipend = new BigDecimal( String.valueOf( totalStipend.doubleValue() ) ).setScale( 2, RoundingMode.HALF_UP );
		}
		return totalStipend;
	}
	
	//( [Total Days] * ([Old Daily Rate]  [New Daily Rate]) ) + ([Number of Retro Months * ([Old Monthly Amount]  [New Monthly Amount]))
	public BigDecimal getRecoupmentAmount(){
		BigDecimal dailyRateDiff = getDailyRateDiff();
		return dailyRateDiff.doubleValue() < 0 ?
		 (new BigDecimal( getTotalDays() ).multiply( dailyRateDiff.negate() ) )
				.add( new BigDecimal( getRetroactiveMonths() ).multiply( getOldPartialMonthlyAmount().subtract( getPartialMonthlyAmount() ) ) ): BigDecimal.ZERO;
	}
	
	public BigDecimal getBackPayAmount(){
		BigDecimal dailyRateDiff = getDailyRateDiff();
		return dailyRateDiff.doubleValue() > 0 ?
		 (new BigDecimal( getTotalDays() ).multiply( dailyRateDiff ) )
				.add( new BigDecimal( getRetroactiveMonths() ).multiply( getPartialMonthlyAmount().subtract( getOldPartialMonthlyAmount() ) ) ): BigDecimal.ZERO;
	}
	
	public int getTotalDays(  ) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime( config.getStipendStartDate() );
		return calendar.getActualMaximum( Calendar.DAY_OF_MONTH ) - calendar.get(Calendar.DAY_OF_MONTH) + 1;
	}
	
	public BigDecimal getPartialMonthlyAmount (  ) {
		Calendar effectiveDate = Calendar.getInstance();
		effectiveDate.setTime( config.getStipendStartDate() );
		int count = effectiveDate.getActualMaximum( Calendar.DAY_OF_MONTH ) - effectiveDate.get(Calendar.DAY_OF_MONTH) + 1;
		return new BigDecimal ( count ).multiply( getDailyRate() );
	}
	
	public BigDecimal getOldPartialMonthlyAmount( ){
		Calendar effectiveDate = Calendar.getInstance();
		effectiveDate.setTime( config.getStipendStartDate() );
		return new BigDecimal ( effectiveDate.get( Calendar.DAY_OF_MONTH )).multiply( getOldDailyRate() );
	}
	
	public BigDecimal getOldMonthlyRate (  ) {
		return new BigDecimal( oldConfig.getPayment() );
	}
	
	public BigDecimal getOldDailyRate(){
		if ( oldDailyRate == null ){
//			oldDailyRate = getOldHourlyRate().multiply( StipendConfig.getTierLevelMonthlyHours( config.getTier() ) )									.multiply( new BigDecimal(12) ).divide( new BigDecimal(365), 2, RoundingMode.HALF_UP );
			oldDailyRate = getOldHourlyRate().multiply(new BigDecimal ( oldConfig.getTierHours() ) ).multiply( new BigDecimal(12) ).divide( new BigDecimal(365), 2, RoundingMode.HALF_UP );
		}
		return oldDailyRate;
	}
	
	@Override
	public BigDecimal getOldHourlyRate() {
		return new BigDecimal( oldConfig.getBlsRateHourly() );
	}
	
	public boolean isCalculationChange(){
		return true;
	}

//	public static void main ( String[] args ) throws ParseException{
//		StipendConfig oldConfig = new StipendConfig( 2, 11.92, format.parse("10/15/2016") );
//		StipendConfig config = new StipendConfig( 2, 18.11, format.parse("02/05/2017") );		
//		System.out.println( new AddressChange( config, oldConfig, Calendar.MARCH, 2017 ) );
//	}
	
	
	//[address change date] - [first of the month of the next or current payment month] * DailyRateDiff
	public BigDecimal getDailyRateDiff(){
		return getDailyRate().subtract( getOldDailyRate() ); 
	}

	public String toString () {
		return   "    Stipend Payment Date: " + formatDate( getPaymentDate() ) + 
				"\n Tier Change Start Date: " + formatDate( config.getStipendStartDate() ) +
				"\n Current Monthly Amount: " + getOldMonthlyRate() +
				"\n     New Monthly Amount: " + getMonthlyRate(  ) +

				"\n  Current Daily Rate of: " + getOldDailyRate() +
				"\n      New Daily Rate of: " + getDailyRate() +
				"\n             Pay Change: " + getMonthlyRate().subtract(getOldMonthlyRate()) + 
				"\n      Recoupment Amount: " + getRecoupmentAmount()  +
				"\n      Total Payment Due: " + getTotalStipend(  )  +
				"\n------------------------------------------------" +
				"\n MonthlyRecurringAmount: " + getMonthlyRecurringAmount()+
				"\n          BackPayAmount: " + getBackPayAmount()+
				"\n            FinalAmount: " + getFinalAmount()+
				//getRecoupmentAmount();
				"\n         ProratedAmount: " + getProratedAmount()+
				"\n            MonthlyRate: " + getMonthlyRate()+
				"\n              DailyRate: " + getDailyRate()+
				"\n             HourlyRate: " + getHourlyRate()+
				"\n           ProratedDate: " + getProratedDate()+
				"\n      RetroactiveMonths: " + getRetroactiveMonths();
	}

	@Override
	public List<AuditLogSupport> getChanges() {
		if ( retList == null ){
			try {
				this.retList = new ArrayList<AuditLogSupport>();
				for ( AudLg lg: CaretLocalServiceUtil.getChange( workItem.getCreationDate(), new long[]{ workItem.getPersnId() }, new String[] {"address", "zip", "city", "state", "country"} ) ){
					retList.add(new AuditLogSupport(lg));
				}
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			}
		}
		return retList;
	}

	public String getWho() {
		if ( who == null ){
			if ( retList == null ){
				getChanges();
			}
			if ( retList.isEmpty() ){
				who = StringPool.BLANK;
			} else {
				who = retList.get(0).getModifiedBy();
			}
		}
		return who;
	}

	public String getWhen() {
		if ( when == null ){
			if ( retList == null ){
				getChanges();
			}
			if ( retList.isEmpty() ){
				when = StringPool.BLANK;
			} else {
				when = retList.get(0).getModificationDate();
			}
		}
		return when;
	}

	@Override
	public StiPt getOldStipendPaymentConfig() {
		return oldConfig;
	}
	
}

